/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.plugin.ImportLogger;

public class PersonImportLogger {
    private int rowIndex;
    private int lastRowIndex;
    private int total;
    private String srcFile;
    private String errFile;
    private Map<Integer, List<ImportLogger.ImportLog>> logCache = new HashMap<Integer, List<ImportLogger.ImportLog>>(16);
    private int failed;
    private int success;

    public PersonImportLogger() {
    }

    public PersonImportLogger(String url) {
        this.setSrcFile(url);
    }

    public PersonImportLogger tick() {
        this.setTotal(this.getTotal() + 1);
        return this;
    }

    public PersonImportLogger putRowError(Integer rowIndex, String msg) {
        List<ImportLogger.ImportLog> errors = this.logCache.get(rowIndex);
        if (null == errors) {
            errors = new ArrayList<ImportLogger.ImportLog>(10);
            this.logCache.put(rowIndex, errors);
        }
        errors.add(new ImportLogger.ImportLog(msg));
        return this;
    }

    public PersonImportLogger putRowError(Integer rowIndex, Set<String> msgs) {
        List<ImportLogger.ImportLog> errors = this.logCache.get(rowIndex);
        if (null == errors) {
            errors = new ArrayList<ImportLogger.ImportLog>(10);
            this.logCache.put(rowIndex, errors);
        }
        for (String msg : msgs) {
            errors.add(new ImportLogger.ImportLog(msg));
        }
        return this;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getLastRowIndex() {
        return this.lastRowIndex;
    }

    public void setLastRowIndex(int lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    private void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public String getErrFile() {
        return this.errFile;
    }

    public void setErrFile(String errFile) {
        this.errFile = errFile;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getSuccess() {
        return this.success;
    }

    public void setSuccess(int success) {
        this.success = success;
    }

    public Map<Integer, List<ImportLogger.ImportLog>> getLogCache() {
        return this.logCache;
    }

    public void setLogCache(Map<Integer, List<ImportLogger.ImportLog>> logCache) {
        this.logCache = logCache;
    }
}

