/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.dataport.PersonImportConfig;
import kd.swc.hsas.business.dataport.PersonImportEntityMapping;
import kd.swc.hsas.business.dataport.PersonImportLogger;
import org.xml.sax.SAXException;

public class PersonImportSheetHandler
extends SheetHandler {
    private static Log log = LogFactory.getLog(PersonImportSheetHandler.class);
    private PersonImportConfig conf;
    private String url;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private PersonImportEntityMapping entityMapping;
    private int startRowNum = 0;
    private int lastStartRowNum = 0;
    private SheetHandler.ParsedRow currentRow;
    private JSONObject data;

    public PersonImportSheetHandler(PersonImportConfig conf, String url, LinkedBlockingQueue<ImportBillData> linkedBlockingQueue) {
        this.conf = conf;
        this.url = url;
        this.dataQueue = linkedBlockingQueue;
    }

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        this.currentRow = parsedRow;
        int currRowIndex = this.currentRow.getRowNum();
        this.conf.getUrlLoggers().get(this.url).setRowIndex(currRowIndex);
        if (currRowIndex > 2) {
            if (!this.entityMapping.isEntityEmpty()) {
                JSONObject dataJson;
                String mainEntityId = this.conf.getImportEntityRel().getMainEntity().getEntityId();
                if (this.data != null && null != (dataJson = this.data.getJSONObject(mainEntityId)) && !dataJson.isEmpty()) {
                    this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowIndex - 1));
                }
                log.info("{}...import analyze Excel first data\uff1a{}", (Object)this.conf.getFormView().getPageId(), (Object)JSON.toJSONString((Object)parsedRow.getData()));
                this.data = new JSONObject();
                this.startRowNum = currRowIndex;
                Set<String> errMsgs = this.entityMapping.pushData(parsedRow.getData(), this.data, mainEntityId);
                if (!errMsgs.isEmpty()) {
                    PersonImportLogger importLogger = this.conf.getUrlLoggers().get(this.url);
                    importLogger.putRowError((Integer)(currRowIndex + 1), errMsgs);
                }
            }
        } else if (currRowIndex == 2) {
            this.entityMapping = PersonImportEntityMapping.create(this.conf.getImportEntityRel(), parsedRow.getData());
        } else if (currRowIndex == 0) {
            this.firstRowResolve(parsedRow);
        }
    }

    private void firstRowResolve(SheetHandler.ParsedRow parsedRow) {
        this.conf.getUrlLoggers().get(this.url).setLastRowIndex(this.getRowCount());
        if (parsedRow.isEmpty()) {
            log.error("{}...\u83ab\u540d\u5176\u5999\u8bfb\u5230\u7684\u6570\u636e\u4e3a\u7a7a...\u5148\u8df3\u8fc7", (Object)this.conf.getFormView().getPageId());
            return;
        }
        String entityName = parsedRow.get(Integer.valueOf(0));
        if (entityName == null || !entityName.contains(" # ") || !this.conf.getImportEntityRel().getMainEntity().getEntityId().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
            this.addBillData(new ImportBillData(this.data, this.startRowNum, 0));
            this.conf.addCompleteUrl(this.url);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u81f4\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\uff1a\u201c{0}\u201d\u3002", (String)"PersonImportSheetHandler_0", (String)"swc-hsas-business", (Object[])new Object[]{entityName}));
        }
    }

    private void addBillData(ImportBillData billData) {
        try {
            this.dataQueue.put(billData);
        }
        catch (Throwable e) {
            log.error("\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", e);
            throw new KDBizException(e, new ErrorCode("", ResManager.loadKDString((String)"\u7ebf\u7a0b\u89e3\u6790\u5f02\u5e38\u3002", (String)"PersonImportSheetHandler_2", (String)"swc-hsas-business", (Object[])new Object[0])), new Object[0]);
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 5000) {
            this.conf.feedbackProgress(0, this.conf.getUrlLoggers().get(this.url), null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            int currRowNum = this.currentRow.getRowNum();
            this.conf.addCompleteUrl(this.url);
            ImportBillData lastBillData = null;
            if (null != this.data) {
                JSONObject dataJson = this.data.getJSONObject(this.conf.getImportEntityRel().getMainEntity().getEntityId());
                if (null != dataJson && !dataJson.isEmpty()) {
                    lastBillData = new ImportBillData(this.data, this.startRowNum, currRowNum);
                    this.addBillData(lastBillData);
                    log.info("{}...doAfterAllAnalysed...{}", (Object)this.conf.getFormView().getPageId(), (Object)currRowNum);
                } else {
                    lastBillData = new ImportBillData(null, this.startRowNum, currRowNum);
                    this.addBillData(lastBillData);
                }
            } else {
                lastBillData = new ImportBillData(null, this.startRowNum, currRowNum);
                this.addBillData(lastBillData);
            }
            log.info("{}...doAfterAllAnalysed...{}", (Object)this.conf.getFormView().getPageId(), (Object)currRowNum);
        }
    }
}

