/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.ImportRowInfo;
import kd.swc.hsas.business.dataport.PersonImportConfig;
import kd.swc.hsas.business.dataport.PersonImportDataTask;
import kd.swc.hsas.business.dataport.PersonImportLogger;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileImportDataTask
extends PersonImportDataTask {
    private static Log log = LogFactory.getLog(SalaryFileImportDataTask.class);

    public SalaryFileImportDataTask(RequestContext ctx, PersonImportConfig conf, String action) {
        super(ctx, conf, action);
    }

    @Override
    public void importData(ImportEntityRel importEntityRel, Map<String, String> entityOpRel, List<ImportRowInfo> rowInfos, LinkedBlockingQueue<ImportRowInfo> reimportDataQueue, PersonImportLogger importLogger) {
        Map<String, List<DynamicObject>> multiEntityDyobjRel = this.getQualifiedMultiEntityDyobjs(importEntityRel, rowInfos, importLogger);
        HashMap<String, OperationResult> operationResults = new HashMap<String, OperationResult>(16);
        if (!this.isImportDataEmpty(importEntityRel, multiEntityDyobjRel)) {
            this.localImportData(importEntityRel, multiEntityDyobjRel, operationResults, entityOpRel, rowInfos, importLogger);
        }
    }

    public void localImportData(ImportEntityRel importEntityRel, Map<String, List<DynamicObject>> multiEntityDyobjRel, Map<String, OperationResult> operationResults, Map<String, String> entityOpRel, List<ImportRowInfo> rowInfos, PersonImportLogger importLogger) {
        try {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            for (Map.Entry<String, List<DynamicObject>> entrySet : multiEntityDyobjRel.entrySet()) {
                String entityId = entrySet.getKey();
                String opKey = entityOpRel.get(entityId);
                DynamicObject[] multiEntityDyobjRelArray = (DynamicObject[])entrySet.getValue().stream().toArray(DynamicObject[]::new);
                if (SWCStringUtils.isEmpty((String)opKey)) continue;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ignoreinteraction", "true");
                operateOption.setVariableValue("normalsave", "true");
                operateOption.setVariableValue("import", "1");
                operateOption.setVariableValue("ishasright", String.valueOf(true));
                operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
                OperationResult operationResult = opImpl.localInvokeOperation(opKey, multiEntityDyobjRelArray, operateOption);
                operationResults.put(entityId, operationResult);
                if (operationResult.isSuccess()) continue;
                break;
            }
            this.assembleErrorInfosDuringImport(operationResults, importEntityRel, rowInfos, importLogger);
        }
        catch (Exception ex) {
            log.error("importData error...localImportData...", (Throwable)ex);
            String msg = ex.getMessage();
            if (SWCStringUtils.isEmpty((String)msg)) {
                msg = "Batch save error[localImportData]";
            }
            for (ImportRowInfo rowInfo : rowInfos) {
                importLogger.putRowError((Integer)rowInfo.getRowIndex(), msg);
            }
        }
    }

    @Override
    protected boolean isUseStatusQualified(DynamicObject basedata) {
        DataEntityPropertyCollection properties = basedata.getDataEntityType().getProperties();
        boolean isSubmited = false;
        if (!properties.containsKey((Object)"status") || SWCStringUtils.equals((String)basedata.getString("status"), (String)"C")) {
            isSubmited = true;
        }
        boolean isEnabled = false;
        if (!properties.containsKey((Object)"enable") || SWCStringUtils.equals((String)basedata.getString("enable"), (String)"1")) {
            isEnabled = true;
        }
        return isSubmited && isEnabled;
    }
}

