/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport.salaryfile;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.AbstractListView;
import kd.sdk.swc.hsas.common.entity.ImportEntity;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.PersonImportHelper;
import kd.swc.hsas.business.dataport.salaryfile.SalaryFileExportService;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryFileExportConfig {
    private Map<String, Object> params = new HashMap<String, Object>();
    private IFormView targetView;
    private ImportEntityRel entityRel;
    private final boolean hasTaxPerms;
    private static final String placeHolder = " # ";

    public SalaryFileExportConfig(Map<String, Object> params) {
        this.params = params;
        this.hasTaxPerms = MapUtils.getBooleanValue(params, (Object)"hastaxfileperm");
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getFileName(boolean isImport) {
        String fileName = "";
        if (isImport) {
            LocalDate now = LocalDate.now();
            String date = String.format(Locale.ROOT, "%04d", now.getYear()) + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
            fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u5bfc\u5165_%s", (String)"SalaryFileExportConfig_1", (String)"swc-hsas-business", (Object[])new Object[0]), date);
        } else {
            fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u4eba\u5458\u85aa\u8d44\u6863\u6848_{0}", (String)"SalaryFileExportConfig_2", (String)"swc-hsas-business", (Object[])new Object[]{SWCDateTimeUtils.format((Date)new Date(), (String)"MMddHHmmss")});
        }
        return fileName;
    }

    public List<Map<String, Object>> getHeader() {
        return this.parseEntityRel(this.getEntityRel());
    }

    public IFormView getTargetView() {
        if (this.targetView == null) {
            this.targetView = this.buildView();
        }
        return this.targetView;
    }

    private IFormView buildView() {
        String parentPageId = (String)this.params.get("targetpageid");
        if (StringUtils.isBlank((CharSequence)parentPageId)) {
            return null;
        }
        IFormView targetView = new SessionManager().getView(parentPageId);
        ((AbstractListView)targetView).getEntityTypeId();
        IFormController srv = (IFormController)targetView.getService(IFormController.class);
        srv.registerListener();
        return targetView;
    }

    private List<Map<String, Object>> parseEntityRel(ImportEntityRel entityRel) {
        ArrayList<Map<String, Object>> headerList = new ArrayList<Map<String, Object>>(10);
        Map allEntity = entityRel.getAllEntity();
        for (Map.Entry entitys : allEntity.entrySet()) {
            String[] fields;
            String entityKey = (String)entitys.getKey();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)entitys.getKey()));
            ImportEntity entity = (ImportEntity)entitys.getValue();
            for (String fieldKey : fields = entity.getFieldKey()) {
                Map<String, Object> columnInfo = this.transfColumnInfo(fieldKey, entityType, entityKey);
                headerList.add(columnInfo);
            }
        }
        return headerList;
    }

    private Map<String, Object> transfColumnInfo(String fieldKey, MainEntityType entityType, String entityKey) {
        String[] splitField = fieldKey.split("\\.");
        String displayName = "";
        DynamicProperty dynProperty = new DynamicProperty();
        HashMap<String, Object> columnInfo = new HashMap<String, Object>(6);
        if (splitField.length > 2) {
            displayName = entityType.getProperty(splitField[0]).getDisplayName().toString();
        } else {
            for (String field : splitField) {
                dynProperty = entityType.getProperty(field);
                if (!(dynProperty instanceof BasedataProp)) continue;
                displayName = dynProperty.getDisplayName().toString();
            }
            if (SWCStringUtils.isEmpty((String)displayName)) {
                displayName = dynProperty.getDisplayName().toString();
            }
        }
        if (this.isMustInput(splitField, entityType)) {
            displayName = "*" + displayName;
        }
        if (fieldKey.contains("name")) {
            displayName = displayName + String.format(ResManager.loadKDString((String)".\u540d\u79f0", (String)"SalaryFileExportConfig_3", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("employee.person.name")) {
            displayName = String.format(ResManager.loadKDString((String)"*\u8ba1\u85aa\u4eba\u5458.\u59d3\u540d", (String)"SalaryFileExportConfig_5", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("managingscope.managingscope.name")) {
            displayName = String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u8303\u56f4.\u540d\u79f0", (String)"SalaryFileExportConfig_6", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.contains("empnumber")) {
            displayName = displayName + String.format(ResManager.loadKDString((String)".\u5de5\u53f7", (String)"SalaryFileExportConfig_4", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("taxunit.admindivision.name")) {
            displayName = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u5730.\u540d\u79f0", (String)"SalaryFileExportConfig_7", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("salarycalcstyle.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u65b9\u5f0f.\u7f16\u7801", (String)"SalaryFileExportConfig_8", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("org.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7.\u7f16\u7801", (String)"SalaryFileExportConfig_9", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("payrollregion.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730.\u7f16\u7801", (String)"SalaryFileExportConfig_10", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("payrollgroup.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4.\u7f16\u7801", (String)"SalaryFileExportConfig_11", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("depcytype.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u5c5e\u5730\u5458\u5de5\u7c7b\u522b.\u7f16\u7801", (String)"SalaryFileExportConfig_12", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("adminorg.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7.\u7f16\u7801", (String)"SalaryFileExportConfig_13", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("empgroup.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u7ec4.\u7f16\u7801", (String)"SalaryFileExportConfig_14", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("depemp.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u4e3b\u8981\u5c97\u4f4d.\u7f16\u7801", (String)"SalaryFileExportConfig_15", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("depemp.showname")) {
            displayName = String.format(ResManager.loadKDString((String)"\u4e3b\u8981\u5c97\u4f4d.\u540d\u79f0", (String)"SalaryFileExportConfig_16", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("depemp.orgteam.number")) {
            displayName = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7.\u7f16\u7801", (String)"SalaryFileExportConfig_17", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        if (fieldKey.equals("depemp.orgteam.name")) {
            displayName = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7.\u540d\u79f0", (String)"SalaryFileExportConfig_18", (String)"swc-hsas-business", (Object[])new Object[0]), new Object[0]);
        }
        displayName = displayName + placeHolder + entityType.getName() + "." + fieldKey;
        String dataType = this.parsePropertyType(dynProperty);
        if (dynProperty instanceof ComboProp) {
            this.putComboOption(columnInfo, dynProperty);
        }
        if (StringUtils.equals((CharSequence)dataType, (CharSequence)"date")) {
            this.putFormat(columnInfo, dynProperty, fieldKey);
        }
        if (StringUtils.equals((CharSequence)dataType, (CharSequence)"num")) {
            columnInfo.put("scale", ((DecimalProp)dynProperty).getScale());
        }
        int width = SalaryFileExportConfig.calcColumnWidth(displayName);
        columnInfo.put("code", entityKey + "." + fieldKey);
        columnInfo.put("displayName", displayName);
        columnInfo.put("dataType", dataType);
        columnInfo.put("width", width);
        return columnInfo;
    }

    private void putFormat(Map<String, Object> columnInfo, DynamicProperty dynProperty, String fieldKey) {
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"startpaydate")) {
            columnInfo.put("format", "yyyy-MM");
        } else {
            columnInfo.put("format", "yyyy-MM-dd");
        }
    }

    private boolean isMustInput(String[] splitField, MainEntityType entityType) {
        boolean isMustInput = false;
        DynamicProperty dp = entityType.getProperty(splitField[0]);
        if (dp instanceof FieldProp) {
            FieldProp fieldProp = (FieldProp)dp;
            isMustInput = fieldProp.isMustInput();
        } else if (dp instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dp;
            isMustInput = basedataProp.isMustInput();
        }
        return isMustInput;
    }

    private void putComboOption(Map<String, Object> columnInfo, DynamicProperty property) {
        ComboProp comboProp = (ComboProp)property;
        List vaItems = comboProp.getComboItems();
        HashMap<String, String> options = new HashMap<String, String>(vaItems.size());
        for (ValueMapItem item : vaItems) {
            options.put(item.getValue(), item.getName().toString());
        }
        columnInfo.put("options", options);
    }

    private static int calcColumnWidth(String caption) {
        return 256 * caption.getBytes(StandardCharsets.UTF_8).length;
    }

    private String parsePropertyType(DynamicProperty property) {
        if (property instanceof TextProp) {
            return "text";
        }
        if (property instanceof ComboProp) {
            return "combo";
        }
        if (property instanceof DateTimeProp) {
            return "date";
        }
        if (property instanceof TimeProp) {
            return "date";
        }
        if (property instanceof DecimalProp) {
            return "num";
        }
        if (property instanceof BooleanProp) {
            return "boolean";
        }
        return "text";
    }

    public List<Map<String, Object>> getData(int start, int limit) {
        Map<String, Object> params = this.getParams();
        boolean isExportAll = MapUtils.getBoolean(params, (Object)"isexportall");
        if (isExportAll) {
            return this.getBatchData(start, limit);
        }
        return this.getSelectData(start, limit);
    }

    private List<Map<String, Object>> getBatchData(int start, int limit) {
        List<Map<String, Object>> data = null;
        IFormView view = this.buildView();
        if (view != null) {
            BillList billList = (BillList)view.getControl("billlistap");
            QueryResult queryResult = billList.queryBatchData(start, limit);
            List<Long> dataIds = this.getDataIds(queryResult);
            data = SalaryFileExportService.getExportData(dataIds, this.entityRel, this.hasTaxPerms);
        }
        return data;
    }

    private List<Long> getDataIds(QueryResult queryResult) {
        ArrayList<Long> dataIds = new ArrayList<Long>(queryResult.getDataCount());
        DynamicObjectCollection dyObjColl = queryResult.getCollection();
        for (DynamicObject obj : dyObjColl) {
            dataIds.add(obj.getLong("id"));
        }
        return dataIds;
    }

    private List<Map<String, Object>> getSelectData(int start, int limit) {
        SWCPageCache pageCache = new SWCPageCache(this.getTargetView());
        List selectIds = (List)pageCache.get("selectIds", List.class);
        ArrayList<Long> dataIds = new ArrayList<Long>(limit);
        int count = 0;
        for (int i = start; i < selectIds.size() && count != limit; ++count, ++i) {
            dataIds.add((Long)selectIds.get(i));
        }
        return SalaryFileExportService.getExportData(dataIds, this.entityRel, this.hasTaxPerms);
    }

    public ImportEntityRel getEntityRel() {
        if (this.entityRel == null) {
            boolean isImport = MapUtils.getBooleanValue(this.getParams(), (Object)"isimport");
            this.entityRel = isImport ? PersonImportHelper.getSalaryAndTaxTempExportEntityRel() : (this.hasTaxPerms ? PersonImportHelper.getSalaryAndTaxExportEntityRel() : PersonImportHelper.getSalaryFileExportEntityRel());
        }
        return this.entityRel;
    }
}

