/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport.salaryfile;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.dataport.salaryfile.SalaryFileExportConfig;
import kd.swc.hsas.business.dataport.salaryfile.SalaryFileExportHelper;
import kd.swc.hsas.common.constants.SalaryFileExportConstants;
import kd.swc.hsbp.common.cache.SWCPageCache;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SalaryFileExportDataTask
implements Runnable {
    protected static final Log logger = LogFactory.getLog(SalaryFileExportDataTask.class);
    private RequestContext context;
    private SalaryFileExportConfig config;
    private String pageId;
    private String entityName;
    private int total;
    private String exportType = "3";
    private Object logPkId;
    private String url;

    public SalaryFileExportDataTask(RequestContext context, SalaryFileExportConfig config, String pageId) {
        this.context = context;
        this.config = config;
        this.pageId = pageId;
        this.entityName = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848", (String)"SalaryFileExportDataTask_0", (String)"swc-hsas-business", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.context);
        this.total = this.getExportTotal();
        this.logPkId = ExportLogHelper.create((Object)SalaryFileExportDataTask.getCacheKey(this.entityName, this.pageId), (String)this.entityName, (int)this.total, (String)this.exportType);
        int totalPages = (int)Math.ceil((double)this.total * 1.0 / (double)SalaryFileExportConstants.PAGE_SIZE.intValue());
        this.feedbackTotal(this.total);
        boolean isImport = MapUtils.getBooleanValue(this.config.getParams(), (Object)"isimport");
        String fileName = this.config.getFileName(isImport);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        logger.info("starting export data: {}", (Object)stopWatch.toString());
        try (SXSSFWorkbook wb = new SXSSFWorkbook(SalaryFileExportConstants.ROW_ACCESS_WINDOWS_SIZE);){
            SXSSFSheet sheet = wb.createSheet();
            sheet.setRandomAccessWindowSize(-1);
            wb.setSheetName(0, fileName);
            List<Map<String, Object>> headers = this.config.getHeader();
            int titleRows = SalaryFileExportHelper.writeHeader(wb, sheet, headers, isImport, this.config);
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                int startIndex = pageIndex * SalaryFileExportConstants.PAGE_SIZE;
                try {
                    List<Map<String, Object>> data = this.config.getData(startIndex, SalaryFileExportConstants.PAGE_SIZE);
                    SalaryFileExportHelper.writeData(wb, sheet, startIndex + titleRows, data, headers);
                    continue;
                }
                catch (Exception e) {
                    logger.info("by cyh export writeData error:", (Object)e);
                    continue;
                }
                finally {
                    this.feedbackComplete(totalPages, pageIndex + 1);
                }
            }
            this.flushAll(sheet, fileName, stopWatch);
        }
        catch (Exception e) {
            logger.info("by cyh export error :", (Object)e);
        }
    }

    private void feedbackComplete(int totalPages, int completePage) {
        SWCPageCache pageCache = new SWCPageCache(this.pageId);
        Map dataInfo = (Map)pageCache.get("data", Map.class);
        long total = ((Integer)dataInfo.get("total")).intValue();
        long count = completePage == totalPages ? total : (long)(completePage * SalaryFileExportConstants.PAGE_SIZE);
        dataInfo.put("complete", count);
        pageCache.put("data", (Object)dataInfo);
        Double percent = (double)completePage * 100.0 / (double)totalPages;
        if (percent >= 100.0) {
            percent = 99.0;
        }
        pageCache.put("progress", (Object)percent.intValue());
        pageCache.saveChanges();
    }

    private void flushAll(SXSSFSheet sheet, String fileName, StopWatch stopWatch) throws IOException {
        this.url = SWCExportDataHelper.storeFile((Workbook)sheet.getWorkbook(), fileName);
        SWCPageCache paCache = new SWCPageCache(this.pageId);
        paCache.put("url", (Object)this.url);
        paCache.put("progress", (Object)100);
        paCache.saveChanges();
        stopWatch.stop();
        SalaryFileExportDataTask.logAll(this.logPkId, this.url, "", this.total);
    }

    private void feedbackTotal(int total) {
        SWCPageCache paCache = new SWCPageCache(this.pageId);
        HashMap<String, Integer> data = new HashMap<String, Integer>(16);
        data.put("total", total);
        data.put("complete", 0);
        paCache.put("data", data);
    }

    private int getExportTotal() {
        return (Integer)new SWCPageCache(this.config.getTargetView()).get("total", Integer.class);
    }

    public static String getCacheKey(String formId, String pageId) {
        String cacheKey = String.format("EXPORT_%s_%s", formId, pageId);
        return cacheKey.substring(0, Math.min(cacheKey.length(), 50));
    }

    public static void logAll(Object pkId, String url, String data, int complete) {
        if (pkId == null) {
            return;
        }
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)pkId, (DynamicObjectType)objType);
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("complete", (Object)complete);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }
}

