/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport.salaryfile;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.dataport.ExportHelper;
import kd.swc.hsas.business.dataport.salaryfile.SalaryFileExportConfig;
import kd.swc.hsas.business.dataport.salaryfile.TaxFileServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class SalaryFileExportHelper {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileExportHelper.class);
    private static final String HSAS_SALARYFILE_STARTPAYDATE = "hsas_salaryfile.startpaydate";
    private static final String CODE = "code";
    private static final String YYYY_MM = "yyyy-MM";

    public static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, Object>> headers, boolean isImport, SalaryFileExportConfig config) {
        int title = 0;
        title = isImport ? SalaryFileExportHelper.writeImportHeader(wb, sheet, config.getEntityRel()) : SalaryFileExportHelper.writeExportHeader(wb, sheet, headers);
        return title;
    }

    public static int writeImportHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ImportEntityRel entityRel) {
        int rowNum = ExportHelper.writeHeader(wb, sheet, entityRel);
        String entityId = "hsas_taxfiletmp";
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        SXSSFCell cell = sheet.getRow(0).getCell(0);
        cell.setCellValue(entityType.getDisplayName() + " # " + entityId);
        ExportSheetStyle sheetStyle = new ExportSheetStyle(wb);
        CellStyle cellStyle = sheetStyle.getTitleStyle();
        SXSSFRow row = sheet.getRow(2);
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            cell = row.getCell(i);
            String cellValue = cell.getStringCellValue();
            cellValue = cellValue.replace("hsas_salaryfile.number", "hsas_taxfiletmp.salaryfile.number");
            if ((cellValue = cellValue.replace("hsas_salaryfile.employee.empnumber", "hsas_taxfiletmp.person.number")).contains("hsas_salaryfile")) {
                cellValue = cellValue.replace("*", "");
                cell.setCellStyle(cellStyle);
            }
            cell.setCellValue(cellValue);
        }
        return rowNum;
    }

    public static int writeExportHeader(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, Object>> headList) {
        SXSSFRow headRow0 = sheet.createRow(0);
        SXSSFCell cellHeadRow0 = headRow0.createCell(0);
        String firstValue = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848", (String)"SalaryFileExportHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        cellHeadRow0.setCellValue(firstValue + " # hsas_salaryfile");
        SXSSFRow headRow2 = sheet.createRow(2);
        for (int i = 0; i < headList.size(); ++i) {
            if (null == headList.get(i)) continue;
            SXSSFCell cell = headRow2.createCell(i);
            String headValue = MapUtils.getString(headList.get(i), (Object)"displayName");
            cell.setCellValue(headValue);
            if (headValue.contains("*")) {
                ExportSheetStyle style = new ExportSheetStyle(wb);
                cell.setCellStyle(style.getTitleMustInputStyle());
            } else {
                CellStyle headColumnStyle = SalaryFileExportHelper.getHeadColumnStyle(wb);
                cell.setCellStyle(headColumnStyle);
            }
            int width = MapUtils.getIntValue(headList.get(i), (Object)"width");
            sheet.setColumnWidth(i, width);
        }
        return sheet.getLastRowNum() + 1;
    }

    private static CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.LEFT);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    public static void writeData(SXSSFWorkbook wb, SXSSFSheet sheet, int rowIndex, List<Map<String, Object>> data, List<Map<String, Object>> headers) {
        if (data == null) {
            return;
        }
        List diyComboCodes = headers.stream().filter(SalaryFileExportHelper::checkTaxFields).map(e -> MapUtils.getString((Map)e, (Object)CODE)).collect(Collectors.toList());
        HashMap countryNumberToId = Maps.newHashMap();
        HashBasedTable taxComboTable = HashBasedTable.create();
        if (!CollectionUtils.isEmpty(diyComboCodes)) {
            ArrayList dataProps = Lists.newArrayListWithExpectedSize((int)diyComboCodes.size());
            for (String comboCode : diyComboCodes) {
                String[] split = comboCode.split("\\.");
                dataProps.add(split[1]);
            }
            Set countryNumbers = data.stream().map(e -> (String)e.get("hsas_salaryfile.payrollregion.number")).collect(Collectors.toSet());
            QFilter filter = new QFilter("number", "in", countryNumbers);
            DynamicObject[] countryObjs = new HRBaseServiceHelper("bd_country").query("id,number", new QFilter[]{filter});
            HashSet countryIds = Sets.newHashSetWithExpectedSize((int)countryObjs.length);
            for (DynamicObject obj : countryObjs) {
                long countryId = obj.getLong("id");
                countryIds.add(countryId);
                countryNumberToId.put(obj.getString("number"), countryId);
            }
            TaxFileServiceHelper.generateTaxComboTable((HashBasedTable<Long, String, List<ComboItem>>)taxComboTable, dataProps, countryIds);
        }
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> rowData = data.get(i);
            if (rowData == null) continue;
            SXSSFRow row = sheet.createRow(i + rowIndex);
            for (int j = 0; j < headers.size(); ++j) {
                Map<String, Object> columnInfo = headers.get(j);
                if (columnInfo == null) continue;
                SXSSFCell cell = row.createCell(j);
                String columnCode = MapUtils.getString(columnInfo, (Object)CODE);
                Object columnValue = MapUtils.getObject(rowData, (Object)columnCode);
                String columnType = MapUtils.getString(columnInfo, (Object)"dataType");
                String cellStyleKey = SWCExportDataHelper.getCellStyleKey(columnInfo, "");
                CellStyle defaultStyle = (CellStyle)cellStyleMap.get(cellStyleKey);
                if (defaultStyle == null) {
                    defaultStyle = SWCExportDataHelper.getDefaultCellStyle(columnInfo, "", wb);
                    SalaryFileExportHelper.setCustomCellStyle(defaultStyle, (String)columnInfo.get(CODE), wb);
                    cellStyleMap.put(cellStyleKey, defaultStyle);
                }
                if (columnValue != null) {
                    SalaryFileExportHelper.parseCellValue(cell, columnValue, columnType, columnInfo);
                }
                if (diyComboCodes.contains(columnCode)) {
                    String countryNumber = MapUtils.getString(rowData, (Object)"hsas_salaryfile.payrollregion.number");
                    String[] split = columnCode.split("\\.");
                    List comboItems = (List)taxComboTable.get(countryNumberToId.get(countryNumber), (Object)split[1]);
                    if (CollectionUtils.isNotEmpty((Collection)comboItems)) {
                        List<String> comboValues = comboItems.stream().map(item -> item.getCaption().getLocaleValue()).collect(Collectors.toList());
                        SalaryFileExportHelper.setCellValidation((Sheet)sheet, (Cell)cell, comboValues);
                    }
                }
                cell.setCellType(SWCExportDataHelper.getCellType(columnType));
                defaultStyle.setAlignment(HorizontalAlignment.LEFT);
                cell.setCellStyle(defaultStyle);
            }
        }
    }

    private static void setCustomCellStyle(CellStyle defaultStyle, String code, SXSSFWorkbook wb) {
        if (HSAS_SALARYFILE_STARTPAYDATE.equalsIgnoreCase(code)) {
            defaultStyle.setAlignment(HorizontalAlignment.CENTER);
            defaultStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            DataFormat format = wb.createDataFormat();
            String styleStr = YYYY_MM;
            defaultStyle.setDataFormat(format.getFormat(styleStr));
        }
    }

    private static void parseCellValue(SXSSFCell cell, Object value, String dataType, Map<String, Object> columnInfo) {
        if (SWCStringUtils.equals((String)dataType, (String)"text")) {
            cell.setCellValue(value.toString());
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            String fmt = (String)columnInfo.get("format");
            if (value instanceof Date) {
                String dateStr = SWCDateTimeUtils.format((Date)((Date)value), (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof Number) {
                long dataLong = Long.parseLong(value.toString());
                Date dateValue = new Date(dataLong);
                String dateStr = SWCDateTimeUtils.format((Date)dateValue, (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof String) {
                String valueStr = (String)value;
                try {
                    Date dateValue = SWCDateTimeUtils.parseDate((String)valueStr, (String)fmt);
                    cell.setCellValue(dateValue);
                }
                catch (ParseException e) {
                    cell.setCellValue(valueStr);
                }
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (SWCStringUtils.equals((String)dataType, (String)"num") || SWCStringUtils.equals((String)dataType, (String)"amount")) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else if (SWCStringUtils.equals((String)dataType, (String)"combo")) {
            Map options = MapUtils.getMap(columnInfo, (Object)"options");
            value = options.get(value);
            cell.setCellValue(value == null ? "" : String.valueOf(value));
        } else if (SWCStringUtils.equals((String)dataType, (String)"boolean")) {
            if (((Boolean)value).booleanValue()) {
                cell.setCellValue(ResManager.loadKDString((String)"\u662f", (String)"SalaryFileExportHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            } else {
                cell.setCellValue(ResManager.loadKDString((String)"\u5426", (String)"SalaryFileExportHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }

    private static boolean checkTaxFields(Map<String, Object> map) {
        String code = MapUtils.getString(map, (Object)CODE);
        String[] split = code.split("\\.");
        if (StringUtils.equals((CharSequence)split[0], (CharSequence)"hsas_taxfiletmp") && StringUtils.equals((CharSequence)"combo", (CharSequence)MapUtils.getString(map, (Object)"dataType"))) {
            Map options = MapUtils.getMap(map, (Object)"options");
            return MapUtils.isEmpty((Map)options);
        }
        return false;
    }

    private static void setCellValidation(Sheet sheet, Cell cell, List<String> dropDownVals) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        int lastCellNum = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        CellRangeAddressList addressList = new CellRangeAddressList(rowIndex, rowIndex, lastCellNum, lastCellNum);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(dropDownVals.toArray(new String[0]));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }
}

