/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport.salaryfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.swc.hsas.common.entity.ImportEntity;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileExportService {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileExportService.class);

    public static List<Map<String, Object>> getExportData(List<Long> dataIds, ImportEntityRel entityRel, boolean hasTaxPerms) {
        HashMap<String, Map<Long, DynamicObject>> dataMap = new HashMap<String, Map<Long, DynamicObject>>(2);
        Map<Long, DynamicObject> salaryMap = SalaryFileExportService.getSalaryFileMap(dataIds, entityRel.getMainEntity());
        dataMap.put(entityRel.getMainEntity().getEntityId(), salaryMap);
        if (hasTaxPerms) {
            for (ImportEntity other : entityRel.getOtherEntities()) {
                String otherId = other.getEntityId();
                if (!SWCStringUtils.equals((String)otherId, (String)"itc_taxfile")) continue;
                Map<Long, DynamicObject> taxMap = SalaryFileExportService.getTaxFileMap(dataIds, other);
                dataMap.put(otherId, taxMap);
            }
        }
        return SalaryFileExportService.transToList(dataMap, dataIds, entityRel);
    }

    private static List<Map<String, Object>> transToList(Map<String, Map<Long, DynamicObject>> dataMap, List<Long> dataIds, ImportEntityRel entityRel) {
        Map entityMap = entityRel.getAllEntity();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(dataIds.size());
        for (Long id : dataIds) {
            HashMap<String, Object> rowData = new HashMap<String, Object>(16);
            for (Map.Entry entry : entityMap.entrySet()) {
                DynamicObject dyObj;
                String prex = "";
                ImportEntity entity = (ImportEntity)entry.getValue();
                String entityId = entity.getEntityId();
                String[] fields = entity.getFieldKey();
                Map<Long, DynamicObject> entityDataMap = dataMap.get(entityId);
                if (entityDataMap == null || (dyObj = entityDataMap.get(id)) == null) continue;
                for (String fieldName : fields) {
                    Object value = SalaryFileExportService.beforeRowData(fieldName, dyObj);
                    rowData.put(entityId + "." + fieldName, value);
                }
            }
            data.add(rowData);
        }
        return data;
    }

    private static Object beforeRowData(String fieldName, DynamicObject dyObj) {
        if (fieldName.equals("isdeductexpstmp") && dyObj.get("taxpayertypetmp") == null && dyObj.get("emptypetmp") == null) {
            return null;
        }
        return dyObj.get(fieldName);
    }

    private static Map<Long, DynamicObject> getSalaryFileMap(List<Long> dataIds, ImportEntity mainEntity) {
        String mainEntityId = mainEntity.getEntityId();
        String[] fields = mainEntity.getFieldKey();
        String fixColumn = "id";
        StringBuilder selectFields = new StringBuilder(fixColumn).append(" ,");
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (SWCStringUtils.equals((String)fixColumn, (String)field)) continue;
            selectFields.append(field).append(" ,");
        }
        selectFields = selectFields.deleteCharAt(selectFields.lastIndexOf(","));
        QFilter filter = new QFilter("id", "in", dataIds);
        SWCDataServiceHelper relDataServiceHelper = new SWCDataServiceHelper(mainEntityId);
        DynamicObjectCollection salaryColls = relDataServiceHelper.queryColl(selectFields.toString(), new QFilter[]{filter}, "");
        HashMap<Long, DynamicObject> salaryMap = new HashMap<Long, DynamicObject>(salaryColls.size());
        salaryColls.forEach(obj -> salaryMap.put(obj.getLong("id"), (DynamicObject)obj));
        return salaryMap;
    }

    private static Map<Long, DynamicObject> getTaxFileMap(List<Long> dataIds, ImportEntity entity) {
        Object[] fields = entity.getFieldKey();
        if (ArrayUtils.isEmpty((Object[])fields)) {
            return null;
        }
        SWCDataServiceHelper relDataServiceHelper = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        QFilter felFilter = new QFilter("salaryfile.id", "in", dataIds);
        felFilter.and("status", "=", (Object)"C");
        String relFields = "salaryfile.id, salaryfile.payrollregion.id, taxfile";
        Object[] relQuery = relDataServiceHelper.query(relFields, new QFilter[]{felFilter});
        if (ArrayUtils.isEmpty((Object[])relQuery)) {
            return null;
        }
        HashMap salaryTaxIds = Maps.newHashMapWithExpectedSize((int)dataIds.size());
        HashMap regionTaxFileIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Object rel : relQuery) {
            Set taxFileIdSet = salaryTaxIds.computeIfAbsent(rel.getLong("salaryfile.id"), k -> Sets.newHashSetWithExpectedSize((int)16));
            taxFileIdSet.add(rel.getLong("taxfile"));
            List taxFileIds = regionTaxFileIdMap.computeIfAbsent(rel.getString("salaryfile.payrollregion.id"), k -> Lists.newArrayListWithCapacity((int)10));
            taxFileIds.add(rel.getLong("taxfile"));
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("srcType", "1");
        params.put("date", new Date());
        params.put("sense", "2");
        params.put("data", regionTaxFileIdMap);
        params.put("props", Arrays.stream(fields).map(obj -> {
            int i = obj.indexOf(46);
            return obj.substring(0, i > 0 ? i : obj.length());
        }).collect(Collectors.toSet()));
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"matchCalTaxFiles", (Object[])new Object[]{params});
        if (CollectionUtils.isEmpty((Map)result)) {
            LOGGER.info("by cyh matchCalTaxFiles fail : result is null\u3002");
        }
        if (!((Boolean)result.get("success")).booleanValue()) {
            LOGGER.info("by cyh matchCalTaxFiles fail : success is not true; message : {}", result.get("message"));
        }
        return SalaryFileExportService.packageTaxFiles(salaryTaxIds, (String[])fields, (Map)result.get("data"));
    }

    private static Map<Long, DynamicObject> packageTaxFiles(Map<Long, Set<Long>> salaryTaxIds, String[] fields, Map<Long, Map<String, Object>> data) {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        HashMap salaryIdToTaxFileMap = Maps.newHashMapWithExpectedSize((int)salaryTaxIds.size());
        for (Map.Entry<Long, Set<Long>> salaryTaxFileIdEntry : salaryTaxIds.entrySet()) {
            Long salaryFileId = salaryTaxFileIdEntry.getKey();
            Set<Long> taxFileIds = salaryTaxFileIdEntry.getValue();
            if (CollectionUtils.isEmpty(taxFileIds)) continue;
            ArrayList taxFileDyns = Lists.newArrayListWithCapacity((int)taxFileIds.size());
            for (Long taxFileId : taxFileIds) {
                Map<String, Object> taxFileMap = data.get(taxFileId);
                if (CollectionUtils.isEmpty(taxFileMap)) continue;
                taxFileDyns.add(SalaryFileExportService.transToDynamicObject(taxFileMap));
            }
            if (CollectionUtils.isEmpty((Collection)taxFileDyns)) continue;
            if (taxFileDyns.size() > 1) {
                LOGGER.info("by cyh matchManyTaxFiles salaryFileId = {} taxFileId = {} , {}", new Object[]{salaryFileId, ((DynamicObject)taxFileDyns.get(0)).get("id"), ((DynamicObject)taxFileDyns.get(1)).get("id")});
            }
            salaryIdToTaxFileMap.put(salaryFileId, taxFileDyns.get(0));
        }
        return salaryIdToTaxFileMap;
    }

    private static DynamicObject transToDynamicObject(Map<String, Object> taxFileMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        DynamicObject taxFile = serviceHelper.generateEmptyDynamicObject();
        taxFile.set("id", taxFileMap.get("id"));
        taxFile.set("number", taxFileMap.get("number"));
        taxFile.set("person", taxFileMap.get("person"));
        taxFile.set("org", taxFileMap.get("org"));
        taxFile.set("taxunit", taxFileMap.get("taxunit"));
        taxFile.set("taxregion", taxFileMap.get("taxregion"));
        taxFile.set("empgroup", taxFileMap.get("empgroup"));
        taxFile.set("isescrowstaff", taxFileMap.get("isescrowstaff"));
        taxFile.set("iscurrentversion", taxFileMap.get("iscurrentversion"));
        taxFile.set("taxpayertypetmp", taxFileMap.get("taxpayertypetmp"));
        taxFile.set("emptypetmp", taxFileMap.get("emptypetmp"));
        taxFile.set("empdatetmp", taxFileMap.get("empdatetmp"));
        taxFile.set("empsituationtmp", StringUtils.isBlank((Object)taxFileMap.get("empsituationtmp")) ? null : taxFileMap.get("empsituationtmp"));
        taxFile.set("isdeductexpstmp", taxFileMap.get("isdeductexpstmp"));
        taxFile.set("bsed", taxFileMap.get("bsed"));
        taxFile.set("bsled", taxFileMap.get("bsled"));
        return taxFile;
    }
}

