/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport.salaryfile;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.ExportHelper;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class SalaryFileImportHelper {
    public static final Log logger = LogFactory.getLog(SalaryFileImportHelper.class);

    public static String getImportTemplate(ImportEntityRel importEntityRel) {
        try {
            SXSSFWorkbook wb = new SXSSFWorkbook();
            SXSSFSheet sheet = wb.createSheet("sheet1");
            SXSSFSheet dropDownHiddenSheet = wb.createSheet("dropdown_items_sheet");
            wb.setSheetHidden(wb.getSheetIndex("dropdown_items_sheet"), true);
            ExportSheetStyle style = new ExportSheetStyle(wb);
            ExportHelper.writeHeader(wb, sheet, style, importEntityRel);
            ExportHelper.writeEntityField(wb, sheet, dropDownHiddenSheet, style, importEntityRel);
            SalaryFileImportHelper.addExtentTips(wb, sheet);
            SalaryFileImportHelper.setMustFill(wb, sheet);
            return ExportHelper.writeFile(wb, importEntityRel.getMainEntity().getEntityId());
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    private static void setMustFill(SXSSFWorkbook wb, SXSSFSheet sheet) {
        SXSSFRow row = sheet.getRow(2);
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            SXSSFCell cell = row.getCell(i);
            String cellValue = cell.getStringCellValue();
            String[] split = cellValue.split("#");
            int length = split.length;
            String key = split[length - 1].trim().toLowerCase();
            if (!SalaryFileImportHelper.getMustFillField().containsKey(key)) continue;
            Boolean isMust = SalaryFileImportHelper.getMustFillField().get(key);
            if (isMust.booleanValue() && !cellValue.startsWith("*")) {
                cell.setCellValue("*" + cellValue);
                cell.setCellStyle(new ExportSheetStyle(wb).getTitleMustInputStyle());
            }
            if (isMust.booleanValue() || !cellValue.startsWith("*")) continue;
            cell.setCellValue(cellValue.substring(1));
            cell.setCellStyle(new ExportSheetStyle(wb).getTitleStyle());
        }
    }

    private static void addExtentTips(SXSSFWorkbook wb, SXSSFSheet sheet) {
        SXSSFRow row = sheet.getRow(2);
        SXSSFRow tipsRow = sheet.getRow(1);
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            SXSSFCell cell = row.getCell(i);
            String cellValue = cell.getStringCellValue();
            String[] split = cellValue.split("#");
            int length = split.length;
            String key = split[length - 1].trim().toLowerCase();
            if (!SalaryFileImportHelper.getTipsMap().containsKey(key)) continue;
            XSSFHyperlink tips = (XSSFHyperlink)wb.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            String cellTips = SalaryFileImportHelper.getTipsMap().get(key);
            tips.setTooltip(cellTips);
            cell.setHyperlink((Hyperlink)tips);
            SXSSFCell tipsCell = tipsRow.getCell(i);
            if (tipsCell == null) {
                tipsCell = tipsRow.createCell(i);
            }
            XSSFRichTextString tipsRichText = new XSSFRichTextString(cellTips);
            tipsCell.setCellStyle(new ExportSheetStyle(wb).getTextHighLightStyle());
            tipsCell.setCellValue((RichTextString)tipsRichText);
        }
    }

    private static Map<String, String> getTipsMap() {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        resultMap.put("hsas_salaryfile.number", ResManager.loadKDString((String)"\u6dfb\u52a0\u65b0\u6570\u636e\u65f6\uff0c\u6863\u6848\u7f16\u53f7\u975e\u5fc5\u586b\uff1b\u66f4\u65b0\u5df2\u6709\u85aa\u8d44\u6863\u6848\u65f6\uff0c\u6863\u6848\u7f16\u53f7\u5fc5\u586b\u3002", (String)"SalaryFileImportHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        resultMap.put("hsas_salaryfile.depemp.number", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u85aa\u4eba\u5458\u4efb\u804c\u7ecf\u5386\u7684\u4e1a\u52a1\u7f16\u7801\uff1b\u5f53\u5458\u5de5\u8c03\u8d70\u6216\u79bb\u804c\u540e\uff0c\u9700\u8981\u586b\u5199\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2\u5386\u53f2\u4efb\u804c\uff1b\u4e0d\u586b\u5199\u65f6\uff0c\u5c06\u9ed8\u8ba4\u53d6\u5458\u5de5\u6700\u65b0\u7684\u4e3b\u4efb\u804c\u3002", (String)"SalaryFileImportHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        resultMap.put("hsas_salaryfile.adminorg.number", ResManager.loadKDString((String)"\u586b\u5199\u6302\u9760\u884c\u653f\u7ec4\u7ec7\uff0c\u82e5\u672a\u586b\u5199\uff0c\u5219\u9ed8\u8ba4\u4f7f\u7528\u5c97\u4f4d\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"SalaryFileImportHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        resultMap.put("hsas_salaryfile.bsed", ResManager.loadKDString((String)"\u82e5\u672a\u586b\u5199\u751f\u6548\u65e5\u671f\uff0c\u5219\u9ed8\u8ba4\u4f7f\u7528\u5c97\u4f4d\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"SalaryFileImportHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        resultMap.put("hsas_salaryfile.isupdatepayenddate", ResManager.loadKDString((String)"\u5f53\u53d8\u66f4\u6863\u6848\u4e14\u7b97\u85aa\u72b6\u6001\u4e3a\u505c\u6b62\u7b97\u85aa\u65f6\uff0c\u81ea\u52a8\u66f4\u65b0\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u4e3a\u6863\u6848\u751f\u6548\u65e5\u671f\u524d\u4e00\u5929\uff08\u5982\u679c\u8be5\u4efb\u804c\u8fd8\u9700\u8981\u521b\u5efa\u5176\u4ed6\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6863\u6848\uff0c\u8bf7\u586b\u201c\u662f\u201d\uff09\u3002", (String)"SalaryFileImportHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
        return resultMap;
    }

    private static Map<String, Boolean> getMustFillField() {
        HashMap<String, Boolean> mustFillField = new HashMap<String, Boolean>();
        mustFillField.put("hsas_salaryfile.depemp.number", Boolean.FALSE);
        mustFillField.put("hsas_salaryfile.adminorg.number", Boolean.FALSE);
        mustFillField.put("hsas_salaryfile.bsed", Boolean.FALSE);
        return mustFillField;
    }
}

