/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport.salaryfile;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.swc.hsas.business.dataport.IPersonImportPlugin;
import kd.swc.hsas.business.dataport.ImportRowInfo;
import kd.swc.hsas.business.dataport.PersonImportLogger;
import kd.swc.hsas.business.dataport.SalaryFileImportPlugin;
import kd.swc.hsas.business.dataport.salaryfile.TaxFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;

public class TaxFileImportPlugin
implements IPersonImportPlugin {
    public static final Date MIN_DATE = new Date(0L);
    public static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    private Set<String> salaryNumbers = Sets.newHashSetWithExpectedSize((int)16);
    private Set<String> taxNumbers = Sets.newHashSetWithExpectedSize((int)16);
    private static Map<String, String> regionApp = Maps.newHashMapWithExpectedSize((int)4);
    public static final Log logger = LogFactory.getLog(SalaryFileImportPlugin.class);
    private List<String> DIY_COMBO_PROP = Lists.newArrayList((Object[])new String[]{"taxpayertype", "emptype"});

    @Override
    public void setDataBaseSelectProp(String entityId, Set<String> selectProps) {
        switch (entityId) {
            case "hsas_salaryfile": {
                selectProps.add("bsed");
                selectProps.add("bsled");
                selectProps.add("employee.empnumber");
                selectProps.add("addtaxfilecheckbox");
                selectProps.add("empposinfo");
                selectProps.add("empposinfo.id");
                selectProps.add("payrollregion.number");
                selectProps.add("payrollregion.id");
                break;
            }
        }
    }

    @Override
    public void afterAssembleData(Map<String, Object> data, Map<String, Object> fillData, PersonImportLogger importLogger, List<ImportRowInfo> rowInfos) {
        long begin = System.currentTimeMillis();
        logger.info("cyh afterAssembleData start size = {}", (Object)rowInfos.size());
        Set<Integer> errorRowIndexs = importLogger.getLogCache().keySet();
        ArrayList validateTaxBsedRows = Lists.newArrayListWithCapacity((int)rowInfos.size());
        HashMap dataIndexs = Maps.newHashMapWithExpectedSize((int)rowInfos.size());
        HashBasedTable<Long, String, List<ComboItem>> taxComboTable = this.getBaseDataValue(rowInfos);
        for (ImportRowInfo rowInfo : rowInfos) {
            Boolean calEnable;
            DynamicObject taxFileDyobj;
            Map<String, DynamicObject> dyObjs = rowInfo.getDyobjs();
            if (CollectionUtils.isEmpty(dyObjs) || (taxFileDyobj = dyObjs.get("hsas_taxfiletmp")) == null) continue;
            dataIndexs.put(taxFileDyobj, rowInfo.getRowIndex());
            DynamicObject salaryFileDyobj = dyObjs.get("hsas_salaryfile");
            if (0L != taxFileDyobj.getLong("taxregion.id") && !(calEnable = TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)taxFileDyobj.getLong("taxregion.id"))).booleanValue()) {
                importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u201c{0}\u201d\u6ca1\u6709\u542f\u7528\u4e2a\u7a0e\u4e91\u670d\u52a1\uff0c\u65e0\u6cd5\u5bfc\u5165\u8be5\u56fd\u5bb6/\u5730\u533a\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u3002", (String)"TaxFileImportPlugin_12", (String)"swc-hsas-business", (Object[])new Object[0]), taxFileDyobj.getString("taxregion.name")));
                continue;
            }
            if (!this.validateTaxNumber(taxFileDyobj, rowInfo, importLogger) || !this.validateComboItem(taxFileDyobj, rowInfo, importLogger, taxComboTable)) continue;
            if (salaryFileDyobj == null) {
                if (!this.validateData(taxFileDyobj, rowInfo, importLogger)) continue;
                validateTaxBsedRows.add(rowInfo);
                continue;
            }
            this.fillDyobj(salaryFileDyobj, taxFileDyobj);
        }
        if (!CollectionUtils.isEmpty((Collection)validateTaxBsedRows)) {
            this.validateTaxFileBsedDate(validateTaxBsedRows, importLogger);
        }
        this.generateNumber(dataIndexs, importLogger);
        long end = System.currentTimeMillis();
        logger.info("cyh afterAssembleData spend : {}", (Object)(end - begin));
    }

    @NotNull
    private HashBasedTable<Long, String, List<ComboItem>> getBaseDataValue(List<ImportRowInfo> rowInfos) {
        Set<Long> countryIds = rowInfos.stream().filter(rowInfo -> {
            Map<String, DynamicObject> dyObjs = rowInfo.getDyobjs();
            if (CollectionUtils.isEmpty(dyObjs)) {
                return false;
            }
            DynamicObject taxFile = dyObjs.get("hsas_taxfiletmp");
            return taxFile != null && taxFile.get("taxregion") != null;
        }).map(rowInfo -> rowInfo.getDyobjs().get("hsas_taxfiletmp").getLong("taxregion.id")).collect(Collectors.toSet());
        HashBasedTable taxComboTable = HashBasedTable.create();
        TaxFileServiceHelper.generateTaxComboTable((HashBasedTable<Long, String, List<ComboItem>>)taxComboTable, this.DIY_COMBO_PROP, countryIds);
        return taxComboTable;
    }

    private void generateNumber(Map<DynamicObject, Integer> dataIndexs, PersonImportLogger importLogger) {
        LinkedHashMap regionFiles = Maps.newLinkedHashMapWithExpectedSize((int)2);
        for (Map.Entry<DynamicObject, Integer> entry : dataIndexs.entrySet()) {
            DynamicObject taxFile = entry.getKey();
            List taxFiles = regionFiles.computeIfAbsent(taxFile.getString("taxregion.number"), k -> new ArrayList(10));
            taxFiles.add(taxFile);
        }
        for (Map.Entry<Object, Integer> entry : regionFiles.entrySet()) {
            List files;
            String regionNumber = (String)entry.getKey();
            String appNumber = regionApp.get(regionNumber);
            if (!StringUtils.isEmpty((Object)appNumber) && !CollectionUtils.isEmpty((Collection)(files = (List)((Object)entry.getValue())))) continue;
        }
    }

    private boolean validateTaxNumber(DynamicObject taxFileDyobj, ImportRowInfo rowInfo, PersonImportLogger importLogger) {
        String taxNumber = taxFileDyobj.getString("number");
        if (!StringUtils.isEmpty((Object)taxNumber) && !this.taxNumbers.add(taxNumber)) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"Excel\u4e2d\u5df2\u5b58\u5728\u4e2a\u7a0e\u6863\u6848\u7f16\u53f7\u4e3a\u201c{0}\u201d\u7684\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u4f7f\u7528\u3002", (String)"TaxFileImportPlugin_6", (String)"swc-hsas-business", (Object[])new Object[0]), taxNumber));
            return false;
        }
        return true;
    }

    private boolean validateComboItem(DynamicObject taxFileDyobj, ImportRowInfo rowInfo, PersonImportLogger importLogger, HashBasedTable<Long, String, List<ComboItem>> taxComboTable) {
        if (taxFileDyobj.get("taxregion") == null) {
            return true;
        }
        long countryId = taxFileDyobj.getLong("taxregion.id");
        for (String prop : this.DIY_COMBO_PROP) {
            List keyMap;
            LocaleString displayName = ((MainEntityType)taxFileDyobj.getDataEntityType()).getProperty(prop).getDisplayName();
            List comboItems = (List)taxComboTable.get((Object)countryId, (Object)prop);
            if (taxFileDyobj.get(prop) == null || (keyMap = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toList())).contains(taxFileDyobj.getString(prop))) continue;
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c{1}\u201d\u7684\u201c{2}\u201d\u3002", (String)"TaxFileImportPlugin_10", (String)"swc-hsas-business", (Object[])new Object[0]), taxFileDyobj.getString("taxregion.name"), taxFileDyobj.getString(prop), displayName.getLocaleValue()));
            return false;
        }
        return true;
    }

    private void validateTaxFileBsedDate(List<ImportRowInfo> validateTaxBsedRows, PersonImportLogger importLogger) {
        HashSet props;
        Set<Long> salaryFileIds = validateTaxBsedRows.stream().map(rowInfo -> rowInfo.getDyobjs().get("hsas_taxfiletmp").getLong("salaryfile.id")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> salaryTaxFileMap = SalaryTaxFileRelServiceHelper.findSalaryTaxFileRel(salaryFileIds, props = Sets.newHashSet((Object[])new String[]{"boid", "id", "bsed", "bsled", "number", "status"}));
        if (CollectionUtils.isEmpty(salaryTaxFileMap)) {
            return;
        }
        block0: for (ImportRowInfo rowInfo2 : validateTaxBsedRows) {
            DynamicObject taxFile = rowInfo2.getDyobjs().get("hsas_taxfiletmp");
            List<DynamicObject> taxFileRels = salaryTaxFileMap.get(taxFile.getLong("salaryfile.id"));
            if (CollectionUtils.isEmpty(taxFileRels)) continue;
            Date bsed = taxFile.getDate("bsed");
            for (DynamicObject taxFileRel : taxFileRels) {
                if (SWCStringUtils.equals((String)taxFileRel.getString("status"), (String)"E") || !TaxFileImportPlugin.isDateRangeOverlap(bsed, MAX_DATE, taxFileRel.getDate("bsed"), taxFileRel.getDate("bsled"))) continue;
                importLogger.putRowError((Integer)rowInfo2.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u65f6\u95f4\u6bb5\u5185\u5df2\u5173\u8054\u6b63\u5e38\u7b97\u7a0e\u7684\u4e2a\u7a0e\u6863\u6848{0}\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxFileImportPlugin_4", (String)"swc-hsas-business", (Object[])new Object[0]), taxFileRel.getString("number")));
                continue block0;
            }
        }
    }

    public static boolean isDateRangeOverlap(Date effectDate, Date expireDate, Date anotherEffectDate, Date anotherExpireDate) {
        effectDate = effectDate == null ? MIN_DATE : effectDate;
        expireDate = expireDate == null ? MAX_DATE : expireDate;
        anotherEffectDate = anotherEffectDate == null ? MIN_DATE : anotherEffectDate;
        anotherExpireDate = anotherExpireDate == null ? MAX_DATE : anotherExpireDate;
        return !effectDate.after(anotherExpireDate) && !expireDate.before(anotherEffectDate);
    }

    private void fillDyobj(DynamicObject salaryFileDyobj, DynamicObject taxFileDyobj) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_person");
        DynamicObject person = serviceHelper.generateEmptyDynamicObject();
        person.set("id", (Object)salaryFileDyobj.getLong("employee.person.id"));
        person.set("number", (Object)salaryFileDyobj.getString("employee.person.number"));
        taxFileDyobj.set("person", (Object)person);
    }

    private boolean validateData(DynamicObject taxFileDyobj, ImportRowInfo rowInfo, PersonImportLogger importLogger) {
        String taxRegion;
        String salaryNumber = taxFileDyobj.getString("salaryfile.number");
        if (StringUtils.isEmpty((Object)salaryNumber)) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"\u53d1\u85aa\u6863\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxFileImportPlugin_7", (String)"swc-hsas-business", (Object[])new Object[0]), salaryNumber));
            return false;
        }
        if (!this.salaryNumbers.add(salaryNumber)) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"Excel\u4e2d\u5df2\u5b58\u5728\u53d1\u85aa\u6863\u6848\u7f16\u53f7\u4e3a\u201c{0}\u201d\u7684\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u4f7f\u7528\u3002", (String)"TaxFileImportPlugin_5", (String)"swc-hsas-business", (Object[])new Object[0]), salaryNumber));
            return false;
        }
        String salaryPersonNum = taxFileDyobj.getString("salaryfile.employee.empnumber");
        String personNum = taxFileDyobj.getString("person.number");
        if (personNum != null && !SWCStringUtils.equals((String)salaryPersonNum, (String)personNum)) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7684\u4eba\u5458\u7f16\u7801{0}\u4e0e\u4e2a\u7a0e\u4eba\u5458\u7f16\u7801{1}\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxFileImportPlugin_2", (String)"swc-hsas-business", (Object[])new Object[0]), salaryPersonNum, personNum));
            return false;
        }
        String payRollRegion = taxFileDyobj.getString("salaryfile.payrollregion.number");
        if (!SWCStringUtils.equals((String)payRollRegion, (String)(taxRegion = taxFileDyobj.getString("taxregion.number")))) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"\u4e2a\u7a0e\u7ba1\u7406\u5c5e\u5730\u201c{0}\u201d\u4e0e\u85aa\u8d44\u6863\u6848\u7684\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u201c{1}\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxFileImportPlugin_3", (String)"swc-hsas-business", (Object[])new Object[0]), taxRegion, payRollRegion));
            return false;
        }
        return true;
    }

    @Override
    public boolean fillBasedataWithSpecialUseStatus(DynamicProperty dp, DynamicObject dyobj, DynamicObject basedataDyObj, int rowIndex, PersonImportLogger importLogger) {
        String fieldId = dp.getName();
        boolean isBreak = false;
        switch (fieldId) {
            case "attachadminorg": 
            case "adminorg": {
                isBreak = true;
                if (SWCStringUtils.equals((String)basedataDyObj.getString("enable"), (String)"1")) {
                    dyobj.set(fieldId, (Object)basedataDyObj);
                    break;
                }
                importLogger.putRowError((Integer)rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599(%s)\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u542f\u7528\u201d\u3002", (String)"TaxFileImportPlugin_1", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName()));
                break;
            }
            case "salaryfile": {
                isBreak = true;
                if (SWCStringUtils.equals((String)basedataDyObj.getString("enable"), (String)"1")) {
                    dyobj.set(fieldId, (Object)basedataDyObj);
                    break;
                }
                importLogger.putRowError((Integer)rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599(%s)\u4f7f\u7528\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u53ef\u7528\u201d\u3002", (String)"TaxFileImportPlugin_0", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName()));
                break;
            }
        }
        return isBreak;
    }

    @Override
    public boolean fillSpecificBasedataBasedOnRel(DynamicProperty dp, DynamicObject dyobj, List<DynamicObject> basedataDyobjs, Map<String, Object> fillData, int rowIndex, PersonImportLogger importLogger) {
        String msgNotExists = ResManager.loadKDString((String)"\u8be5\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u6709\u6548\u7684\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"TaxFileImportPlugin_13", (String)"swc-hsas-business", (Object[])new Object[0]);
        if (basedataDyobjs != null && "person".equals(dp.getName()) && basedataDyobjs.size() >= 2) {
            String personNumber = dyobj.getString("person");
            String salaryfileNumber = dyobj.getString("salaryfile");
            SWCDataServiceHelper employeeServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
            QFilter filter = new QFilter("number", "=", (Object)salaryfileNumber);
            QFilter notAbandonFilter = new QFilter("iscurrentversion", "!=", (Object)"-1");
            BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
            DynamicObject dynamicObject = employeeServiceHelper.queryOne("employee.person", new QFilter[]{filter, notAbandonFilter});
            if (null != dynamicObject) {
                dyobj.set(dp.getName(), (Object)dynamicObject.getDynamicObject("employee.person"));
            } else {
                importLogger.putRowError((Integer)rowIndex, msgNotExists);
            }
            return true;
        }
        return false;
    }

    static {
        regionApp.put("001", "itc");
    }
}

