/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport.salaryfile;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.ComboItem;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxFileServiceHelper {
    public static void setComboItem(String entityId, MainEntityType entityType) {
        if (StringUtils.equals((CharSequence)"hsas_taxfiletmp", (CharSequence)entityId)) {
            ArrayList dataProps = Lists.newArrayList();
            entityType.getAllFields().forEach((field, property) -> {
                if (property instanceof ComboProp && CollectionUtils.isEmpty((Collection)((ComboProp)property).getComboItems())) {
                    dataProps.add(field);
                }
            });
            Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"TaxBaseDataApiService", (String)"findDataByCountry", (Object[])new Object[]{Lists.newArrayList(), dataProps});
            Object resultData = result.get("data");
            if (resultData != null) {
                HashMap propComboMap = Maps.newHashMapWithExpectedSize((int)dataProps.size());
                ((HashBasedTable)resultData).cellSet().forEach(cell -> {
                    String dataProp = (String)cell.getColumnKey();
                    LinkedHashMap valueMap = (LinkedHashMap)cell.getValue();
                    if (valueMap != null) {
                        List comboItems = propComboMap.computeIfAbsent(dataProp, k -> Lists.newArrayList());
                        valueMap.forEach((k, val) -> comboItems.add(new ValueMapItem(null, k, new LocaleString(val))));
                    }
                });
                for (String dataProp : dataProps) {
                    List comboItems = (List)propComboMap.get(dataProp);
                    ((ComboProp)entityType.getProperty(dataProp)).setComboItems(comboItems);
                }
            }
        }
    }

    public static void generateTaxComboTable(HashBasedTable<Long, String, List<ComboItem>> taxComboTable, List<String> dataProps, Set<Long> countryIds) {
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"TaxBaseDataApiService", (String)"findDataByCountry", (Object[])new Object[]{countryIds, dataProps});
        Object resultData = result.get("data");
        if (resultData != null) {
            ((HashBasedTable)resultData).cellSet().forEach(cell -> {
                Long countryKey = (Long)cell.getRowKey();
                String propKey = (String)cell.getColumnKey();
                LinkedHashMap valueMap = (LinkedHashMap)cell.getValue();
                if (countryKey != null && !StringUtils.isEmpty((CharSequence)propKey) && valueMap != null) {
                    ArrayList<ComboItem> items = new ArrayList<ComboItem>(valueMap.size());
                    for (Map.Entry valuePair : valueMap.entrySet()) {
                        items.add(new ComboItem(new LocaleString(String.valueOf(valuePair.getValue())), String.valueOf(valuePair.getKey())));
                    }
                    taxComboTable.put((Object)countryKey, (Object)propKey, items);
                }
            });
        }
    }
}

