/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.model.UserParam;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCBaseUserSyncFacade {
    private static final Log log = LogFactory.getLog(SWCBaseUserSyncFacade.class);
    private static final String ADD_NEW = "addnew";
    private static final String MODIFY = "monify";
    private static final String ADD_NEW_AGAIN = "addnewagain";

    public List<UserParam> saveUserInfo(DynamicObjectCollection personDyobjColl) {
        List<UserParam> userParams = this.assembleUserParamByPersonDyobj(personDyobjColl, ADD_NEW);
        UserServiceHelper.add(userParams);
        return userParams;
    }

    public List<UserParam> saveuserInfoAgain(DynamicObjectCollection personDyobjColl) {
        List<UserParam> userParams = this.assembleUserParamByPersonDyobj(personDyobjColl, ADD_NEW_AGAIN);
        UserServiceHelper.add(userParams);
        return userParams;
    }

    public List<UserParam> updateUserInfo(DynamicObjectCollection personDyobjColl) {
        List<UserParam> userParams = this.assembleUserParamByPersonDyobj(personDyobjColl, MODIFY);
        UserServiceHelper.update(userParams);
        return userParams;
    }

    public List<UserParam> deleteUserInfo(DynamicObjectCollection personDyobjColl) {
        List<UserParam> userParams = this.assembleUserParamByPersonDyobj(personDyobjColl, MODIFY);
        UserServiceHelper.delete(userParams);
        return userParams;
    }

    public List<UserParam> enableUserInfo(DynamicObjectCollection personDyobjColl) {
        List<UserParam> userParams = this.assembleUserParamByPersonDyobj(personDyobjColl, MODIFY);
        UserServiceHelper.enable(userParams);
        return userParams;
    }

    public List<UserParam> disableUserInfo(DynamicObjectCollection personDyobjColl) {
        List<UserParam> userParams = this.assembleUserParamByPersonDyobj(personDyobjColl, MODIFY);
        UserServiceHelper.disable(userParams);
        return userParams;
    }

    private List<UserParam> assembleUserParamByPersonDyobj(DynamicObjectCollection personDyobjs, String type) {
        log.info("getPersonSyncInfo Start");
        ArrayList<UserParam> userParams = new ArrayList<UserParam>();
        for (DynamicObject personDyobj : personDyobjs) {
            DynamicObject position;
            UserParam userParam = new UserParam();
            HashMap<String, Object> personInfo = new HashMap<String, Object>();
            String empNumber = personDyobj.getString("empnumber");
            log.info("\u540c\u6b65\u4eba\u5458\u7f16\u53f7: {}", (Object)empNumber);
            personInfo.put("id", personDyobj.get("id"));
            personInfo.put("number", empNumber);
            personInfo.put("name", personDyobj.getString("name"));
            personInfo.put("gender", personDyobj.getString("gender"));
            personInfo.put("picturefield", personDyobj.getString("headsculpture"));
            personInfo.put("birthday", personDyobj.getDate("birthday"));
            personInfo.put("username", personDyobj.getString("phone"));
            DynamicObject credentialType = personDyobj.getDynamicObject("credentialstype");
            if (null != credentialType && SWCStringUtils.equals((String)credentialType.getString("id"), (String)"1010")) {
                personInfo.put("idcard", personDyobj.getString("credentialsnumber"));
            }
            if (!SWCStringUtils.equals((String)ADD_NEW_AGAIN, (String)type)) {
                personInfo.put("phone", personDyobj.getString("phone"));
                personInfo.put("email", personDyobj.getString("peremail"));
            }
            ArrayList depInfos = new ArrayList();
            HashMap<String, Object> depInfo = new HashMap<String, Object>();
            DynamicObject adminOrgDyobj = personDyobj.getDynamicObject("adminorg");
            if (null != adminOrgDyobj) {
                depInfo.put("dpt", adminOrgDyobj.get("id"));
            }
            if (null != (position = personDyobj.getDynamicObject("position"))) {
                depInfo.put("position", position.get("name"));
            } else {
                DynamicObject job = personDyobj.getDynamicObject("job");
                if (null != job) {
                    depInfo.put("position", job.get("name"));
                }
            }
            depInfo.put("ispartjob", !personDyobj.getBoolean("isprimary"));
            depInfos.add(depInfo);
            personInfo.put("entryentity", depInfos);
            userParam.setDataMap(personInfo);
            userParam.setCustomUserId(personDyobj.getLong("id"));
            userParams.add(userParam);
        }
        return userParams;
    }
}

