/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.file;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.collections.ListUtils;

public class PersonCertCommonHelper {
    private static final Log LOGGER = LogFactory.getLog(PersonCertCommonHelper.class);
    private static final String APPID = "/UHMBBGZQ65X";

    public static Map<String, Object> verifyCertForApply(List<Long> personIndexIds) {
        return SWCCertCommonHelper.verifyCertForApply((String)APPID, (String)"hsas_salaryfile", personIndexIds);
    }

    public static Map<String, Object> verifyCert(List<DynamicObject> files) {
        HashSet<Long> successList = new HashSet<Long>(16);
        HashSet failList = new HashSet(16);
        HashSet<Long> requireList = new HashSet<Long>(16);
        for (DynamicObject file : files) {
            Long pid = file.getLong("person.personindexid");
            if (PersonCertCommonHelper.isRequireCert(file)) {
                requireList.add(pid);
                continue;
            }
            successList.add(pid);
        }
        Map<String, Object> resultUsable = PersonCertCommonHelper.verifyCertForApply(new ArrayList<Long>(requireList));
        boolean result = (Boolean)resultUsable.get("result");
        if (result) {
            successList.addAll(requireList);
        } else {
            List noCerts = (List)resultUsable.get("datas");
            failList.addAll(noCerts);
            List hsaDetail = ListUtils.removeAll(requireList, (Collection)noCerts);
            successList.addAll(hsaDetail);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("successList", successList);
        resultMap.put("failList", failList);
        Map checkCountMap = (Map)resultUsable.get("msg");
        resultMap.put("message", checkCountMap.get("message"));
        resultMap.put("msg", resultUsable.get("msg"));
        return resultMap;
    }

    private static boolean isRequireCert(DynamicObject salaryfile) {
        boolean isRequire = false;
        Date bsled = salaryfile.getDate("bsled");
        try {
            if (bsled == null) {
                bsled = SWCDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            }
        }
        catch (ParseException e) {
            LOGGER.info("[cert]:parse datetime 2999-12-31 error", (Object)e);
        }
        Date today = SWCDateTimeUtils.getTodayDateWithoutTime();
        String status = salaryfile.getString("status");
        return "1".equals(salaryfile.getString("paystatus")) && !bsled.before(today);
    }

    public static void calPersonCertByPersonId(List<Long> personIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_personhr");
        QFilter idFilter = new QFilter("id", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)idFilter);
        DynamicObject[] fileDys = serviceHelper.query("personindexid", new QFilter[]{idFilter});
        List<Long> pIds = Arrays.stream(fileDys).map(dy -> dy.getLong("personindexid")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByIndexId(pIds);
    }

    public static void calPersonCertByIndexId(List<Long> personIndexIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter pIdFilter = new QFilter("person.personindexid", "in", personIndexIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter isVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter qIdFilter = new QFilter("salaryfile.status", "!=", (Object)"E");
        QFilter payFilter = new QFilter("paystatus", "=", (Object)"1");
        ArrayList<String> dataStatus = new ArrayList<String>(2);
        dataStatus.add("1");
        dataStatus.add("0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", dataStatus);
        QFilter[] params = new QFilter[]{pIdFilter, statusFilter, isVersionFilter, qIdFilter, payFilter, dataStatusFilter};
        DynamicObject[] fileDys = serviceHelper.query("person.personindexid", params);
        Set requireCertIds = Arrays.stream(fileDys).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
        SWCCertCommonHelper.updateCert((String)APPID, (String)"hsas_salaryfile", new ArrayList(requireCertIds));
        List releaseDelIds = ListUtils.removeAll(personIndexIds, requireCertIds);
        SWCCertCommonHelper.releaseCert((String)APPID, (String)"hsas_salaryfile", (List)releaseDelIds);
    }

    public static void showWarningTip(IFormView showView, String preMsg, List<DynamicObject> dys) {
        Map<String, Object> resultUsable = PersonCertCommonHelper.verifyCert(dys);
        Map checkCountMap = (Map)resultUsable.get("msg");
        String showMessageType = (String)checkCountMap.get("showMessageType");
        if ("true".equals(checkCountMap.get("showMessage"))) {
            showView.showTipNotification(preMsg + (String)checkCountMap.get("message"));
        }
    }
}

