/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.swc.hsas.business.formula.helper.FormulaParseHelper;
import kd.swc.hsas.business.formula.helper.FormulaSplitHelper;
import kd.swc.hsas.common.formula.vo.FormulaInfo;
import kd.swc.hsas.common.formula.vo.OriginalNode;
import kd.swc.hsas.common.formula.vo.SalaryItem;
import kd.swc.hsas.common.utils.FormulaUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FormulaParseService {
    public FormulaInfo parseFormula(DynamicObject formula, Map<String, Map<String, Map<String, Object>>> dataMap) throws Exception {
        FormulaInfo formulaInfo = new FormulaInfo();
        this.setFormulaInfo(formula, formulaInfo, dataMap);
        FormulaSplitHelper splitHelper = new FormulaSplitHelper();
        List<OriginalNode> nodes = splitHelper.getOriginalNodes(formulaInfo.getOriginalCode());
        if (nodes == null || nodes.size() == 0) {
            throw new Exception(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u6709\u6548\u7684\u516c\u5f0f\u5185\u5bb9\u3002", (String)"FormulaParseService_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        formulaInfo.setOriginalNodes(nodes);
        FormulaParseHelper parseHelper = new FormulaParseHelper();
        parseHelper.parse(formulaInfo);
        this.replaceOriginalExp(formulaInfo);
        return formulaInfo;
    }

    private void replaceOriginalExp(FormulaInfo formulaInfo) {
        List nodes = formulaInfo.getOriginalNodes();
        StringBuilder originalExp = new StringBuilder();
        StringBuilder uniqueKeyExp = new StringBuilder();
        int preLineIndex = 0;
        OriginalNode node = null;
        for (int index = 0; index < nodes.size(); ++index) {
            node = (OriginalNode)nodes.get(index);
            if (index == 0) {
                originalExp.append(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                uniqueKeyExp.append(node.getUniqueKey());
            } else if (preLineIndex != node.getLineIndex()) {
                originalExp.append('\n').append(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                uniqueKeyExp.append('\n').append(node.getUniqueKey());
            } else {
                originalExp.append(' ').append(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                uniqueKeyExp.append(' ').append(node.getUniqueKey());
            }
            preLineIndex = node.getLineIndex();
        }
        formulaInfo.setOriginalCode(originalExp.toString());
        formulaInfo.setUniqueKeyCode(uniqueKeyExp.toString());
    }

    private void setFormulaInfo(DynamicObject formula, FormulaInfo formulaInfo, Map<String, Map<String, Map<String, Object>>> dataMap) throws KDBizException {
        formulaInfo.setOriginalCode(formula.getString("originalexp"));
        long formulaBoId = formula.getLong("boid");
        if (formulaBoId == 0L) {
            formulaBoId = formula.getLong("id");
        }
        formulaInfo.setId(String.valueOf(formulaBoId));
        formulaInfo.setProrateItemFormula(false);
        Map<String, Map<String, Object>> bsItemMap = dataMap.get("bsitemkey");
        bsItemMap.putAll(dataMap.get("bsattitemkey"));
        formulaInfo.setBsItemMap(bsItemMap);
        formulaInfo.setBsPropItemMap(dataMap.get("bspropitemkey"));
        formulaInfo.setSlItemMap(dataMap.get("salaryitemkey"));
        formulaInfo.setSpItemMap(dataMap.get("spitemkey"));
        formulaInfo.setFcMap(dataMap.get("funcKey"));
        formulaInfo.setDmMap(dataMap.get("dmkey"));
        formulaInfo.setAcMap(dataMap.get("ackey"));
        formulaInfo.setFtMap(dataMap.get("ftitemkey"));
        formulaInfo.setName(formula.getString("name"));
        if (SWCStringUtils.equals((String)formula.getString("usetype"), (String)"1")) {
            formulaInfo.setProrateItemFormula(true);
            SalaryItem item = new SalaryItem();
            item.setType("num");
            formulaInfo.setSalaryItem(item);
        } else {
            formulaInfo.setProrateItemFormula(false);
            DynamicObject salaryItemObj = formula.getDynamicObject("salaryitem");
            if (salaryItemObj == null) {
                String msg = ResManager.loadKDString((String)"\u516c\u5f0f\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u85aa\u916c\u9879\u76ee\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u5ba1\u6838\u72b6\u6001\u6216\u662f\u5426\u5220\u9664\u3002", (String)"FormulaParseService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            String salaryItemName = salaryItemObj.getString("name");
            SalaryItem item = new SalaryItem();
            item.setName(salaryItemName);
            item.setUniquecode(salaryItemObj.getString("uniquecode"));
            item.setType(FormulaUtils.getShowTypeById((long)salaryItemObj.getLong("datatype.id")));
            formulaInfo.setSalaryItem(item);
        }
    }
}

