/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.entity.ItemTreeNode;
import kd.sdk.swc.hsas.common.events.formula.BeforeBuildItemTreeEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.formula.IFormulaItemTreeExtPlugin;
import kd.swc.hsas.business.formula.FormulaItemTreeExtPlugin;
import kd.swc.hsas.common.enums.AttBizItemtypeEnum;
import kd.swc.hsas.common.formula.enums.FormulaKeyEnum;
import kd.swc.hsas.common.formula.enums.OperatorEnum;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.ProrationConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class FormulaDataServiceHelper {
    public static final String ATTBIZITEM = "1";

    public static List<Map<String, Object>> getFuncData(IFormView view, String itemName, DynamicObject formulaObj) {
        if (view == null) {
            return new ArrayList<Map<String, Object>>();
        }
        Map<String, Map<String, Map<String, Object>>> dataMap = FormulaDataServiceHelper.getAllItemAndFuncData(view, formulaObj);
        return FormulaDataServiceHelper.mapToList(dataMap.get(itemName));
    }

    public static Map<String, Map<String, Map<String, Object>>> getAllItemAndFuncData(IFormView view, DynamicObject formulaObj) {
        HashMap<String, Map<String, Map<String, Object>>> dataMap;
        SWCPageCache pageCache = new SWCPageCache(view);
        String cacheKey = "allItemAndFuncData";
        if (formulaObj != null) {
            cacheKey = cacheKey + formulaObj.getString("usetype");
        }
        if (null != (dataMap = (HashMap<String, Map<String, Map<String, Object>>>)pageCache.get(cacheKey, Map.class)) && dataMap.size() > 0) {
            return dataMap;
        }
        dataMap = new HashMap<String, Map<String, Map<String, Object>>>(16);
        HashMap<String, String> uniqueCodeRelMap = new HashMap<String, String>(16);
        FormulaDataServiceHelper.dealItemAndFuncData(formulaObj, dataMap, uniqueCodeRelMap);
        pageCache.put(cacheKey, dataMap);
        pageCache.put("uniqueCodeRelMap", uniqueCodeRelMap);
        return dataMap;
    }

    public static Map<String, Map<String, Map<String, Object>>> getAllItemDataForSubmit(DynamicObject formulaObj, String appKey, String subKey) {
        ISWCAppCache appCache = SWCAppCache.get((String)appKey);
        HashMap<String, Map<String, Map<String, Object>>> dataMap = (HashMap<String, Map<String, Map<String, Object>>>)appCache.get(subKey, Map.class);
        if (dataMap != null && dataMap.size() > 0) {
            return dataMap;
        }
        dataMap = new HashMap<String, Map<String, Map<String, Object>>>(16);
        HashMap<String, String> uniqueCodeRelMap = new HashMap<String, String>(16);
        FormulaDataServiceHelper.dealItemAndFuncData(formulaObj, dataMap, uniqueCodeRelMap);
        appCache.put(subKey, dataMap);
        return dataMap;
    }

    private static void dealItemAndFuncData(DynamicObject formulaObj, Map<String, Map<String, Map<String, Object>>> dataMap, Map<String, String> uniqueCodeRelMap) {
        boolean isProrationFormula = false;
        QFilter countryQFilter = null;
        QFilter calBlockQFilter = null;
        DynamicObject salaryItemObj = null;
        long orgID = 0L;
        if (null != formulaObj) {
            long countryId = formulaObj.getLong("country.id");
            String areatype = formulaObj.getString("areatype");
            countryQFilter = AreaHelper.addAreaFilter((long)countryId, (String)areatype);
            salaryItemObj = formulaObj.getDynamicObject("salaryitem");
            DynamicObject orgDyObj = formulaObj.getDynamicObject("createorg");
            if (orgDyObj != null) {
                orgID = (Long)orgDyObj.getPkValue();
            }
            if (null != salaryItemObj) {
                String calBlock = salaryItemObj.getString("calblock");
                calBlockQFilter = FormulaDataServiceHelper.getCalBlockFilter(calBlock);
            }
            if (SWCStringUtils.equals((String)formulaObj.getString("usetype"), (String)ATTBIZITEM)) {
                isProrationFormula = true;
            }
        }
        ArrayList<Map<String, Object>> bizItemPropList = new ArrayList<Map<String, Object>>(10);
        Map<String, Map<String, Object>> funcMap = FormulaDataServiceHelper.getFuncList(isProrationFormula);
        Map<String, Map<String, Object>> salaryItemMap = FormulaDataServiceHelper.getSalaryItemList(orgID, isProrationFormula, countryQFilter, calBlockQFilter, uniqueCodeRelMap);
        Map<String, Map<String, Object>> ftItemMap = FormulaDataServiceHelper.getFTItemList(countryQFilter, uniqueCodeRelMap);
        Map<String, Map<String, Object>> bsItemMap = FormulaDataServiceHelper.getBSItemList(orgID, countryQFilter, bizItemPropList, uniqueCodeRelMap);
        Map<String, Map<String, Object>> bsAttItemMap = FormulaDataServiceHelper.getAttBSItemList(orgID, countryQFilter, bizItemPropList, uniqueCodeRelMap);
        Map<String, Map<String, Object>> spItemMap = FormulaDataServiceHelper.getSPItemList(orgID, isProrationFormula, countryQFilter, uniqueCodeRelMap);
        Map<String, Map<String, Object>> dmItemMap = FormulaDataServiceHelper.getDMItemList(orgID, countryQFilter);
        Map<String, Map<String, Object>> accMap = FormulaDataServiceHelper.getAccDataMap(isProrationFormula, countryQFilter, uniqueCodeRelMap, orgID);
        Map<String, Map> bsItemPropMap = bizItemPropList.stream().collect(Collectors.toMap(obj -> obj.get("bizItemName") + "_@_" + obj.get("name"), obj -> obj));
        dataMap.put("funcKey", funcMap);
        dataMap.put("salaryitemkey", salaryItemMap);
        dataMap.put("ftitemkey", ftItemMap);
        dataMap.put("bsitemkey", bsItemMap);
        dataMap.put("bsattitemkey", bsAttItemMap);
        dataMap.put("spitemkey", spItemMap);
        dataMap.put("dmkey", dmItemMap);
        dataMap.put("ackey", accMap);
        dataMap.put("bspropitemkey", bsItemPropMap);
    }

    private static Map<String, Map<String, Object>> getAccDataMap(boolean isProrationFormula, QFilter countryQFilter, Map<String, String> uniqueCodeRelMap, long orgId) {
        QFilter useOrgQFilter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accumulator");
        LinkedHashMap<String, Map<String, Object>> accMap = new LinkedHashMap<String, Map<String, Object>>(16);
        if (isProrationFormula) {
            return accMap;
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        if (orgId > 0L && null != (useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_accumulator", (Long)orgId))) {
            filter.and(useOrgQFilter);
        }
        String fields = "id,number,name,datatype.showtype,uniquecode";
        DynamicObjectCollection accDataList = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "number asc");
        HashMap<String, Object> tempMap = null;
        for (DynamicObject acc : accDataList) {
            tempMap = new HashMap<String, Object>(5);
            tempMap.put("id", acc.getLong("id"));
            tempMap.put("name", acc.getString("name"));
            tempMap.put("number", acc.getString("number"));
            tempMap.put("datatype", acc.getString("datatype.showtype"));
            tempMap.put("uniquecode", acc.getString("uniquecode"));
            accMap.put(acc.getString("name"), tempMap);
            uniqueCodeRelMap.put(acc.getString("uniquecode"), acc.getString("name"));
        }
        return accMap;
    }

    private static QFilter getCalBlockFilter(String calBlock) {
        if (SWCStringUtils.equals((String)"0", (String)calBlock)) {
            return new QFilter("calblock", "=", (Object)calBlock);
        }
        return null;
    }

    private static Map<String, Map<String, Object>> getFuncList(boolean isProrationFormula) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_funcdefine");
        QFilter[] filters = null;
        if (isProrationFormula) {
            filters = new QFilter[2];
        } else {
            filters = new QFilter[3];
            filters[2] = new QFilter("functype.id", "!=", (Object)ProrationConstants.PRORATION_FUNC_TYPE_ID);
        }
        filters[0] = new QFilter("enable", "=", (Object)ATTBIZITEM);
        filters[1] = new QFilter("status", "=", (Object)"C");
        String queryField = "id,name,uniquecode,define,functype.number,functype.name,funcdatatype,entryentity.paramdatatype,entryentity.paramname,entryentity.paramdesc,description,example";
        DynamicObject[] result = helper.query(queryField, filters, "functype.index asc,functype.number asc,index asc,number asc");
        LinkedHashMap<String, Map<String, Object>> funcMap = new LinkedHashMap<String, Map<String, Object>>(result.length);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject func : result) {
            tempMap = new HashMap<String, Object>(12);
            tempMap.put("name", func.getString("name"));
            tempMap.put("id", func.getLong("id"));
            tempMap.put("uniquecode", func.getString("uniquecode"));
            tempMap.put("functypeNumber", func.getString("functype.number"));
            tempMap.put("functypeName", func.getString("functype.name"));
            tempMap.put("funcdatatype", func.getString("funcdatatype"));
            tempMap.put("description", func.getString("description"));
            tempMap.put("define", func.getString("define"));
            tempMap.put("example", func.getString("example"));
            tempMap.put("entryentity", FormulaDataServiceHelper.getParameters(func.getDynamicObjectCollection("entryentity")));
            funcMap.put(func.getString("name"), tempMap);
        }
        return funcMap;
    }

    private static List<Map<String, String>> getParameters(DynamicObjectCollection entryList) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(10);
        if (entryList == null || entryList.size() == 0) {
            return result;
        }
        HashMap<String, String> tempMap = null;
        for (DynamicObject entry : entryList) {
            tempMap = new HashMap<String, String>(3);
            tempMap.put("paramdatatype", entry.getString("paramdatatype"));
            tempMap.put("paramname", entry.getString("paramname"));
            tempMap.put("paramdesc", entry.getString("paramdesc"));
            result.add(tempMap);
        }
        return result;
    }

    private static Map<String, Map<String, Object>> getSalaryItemList(Long orgId, boolean isProrationFormula, QFilter countryQFilter, QFilter calBlockQFilter, Map<String, String> uniqueCodeRelMap) {
        QFilter useOrgQFilter;
        LinkedHashMap<String, Map<String, Object>> salaryItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        if (isProrationFormula) {
            return salaryItemMap;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (orgId > 0L && null != (useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgId))) {
            qFilters.add(useOrgQFilter);
        }
        if (null != countryQFilter) {
            qFilters.add(countryQFilter);
        }
        if (null != calBlockQFilter) {
            qFilters.add(calBlockQFilter);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String queryField = "id,number,name,salaryitemtype.number,salaryitemtype.name,uniquecode,datatype.showtype,salaryitemtype.index";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        qFilters.add(filter);
        QFilter[] newFilters = new QFilter[qFilters.size()];
        newFilters = qFilters.toArray(newFilters);
        String orderBy = "salaryitemtype.index asc,salaryitemtype.number asc,index asc,number asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, newFilters, orderBy);
        HashMap<String, Object> tempMap = null;
        ArrayList<ItemTreeNode> itemTreeNodeList = new ArrayList<ItemTreeNode>(result.size());
        ItemTreeNode treeNode = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(6);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("salaryitemtype_number", item.getString("salaryitemtype.number"));
            tempMap.put("salaryitemtype_name", item.getString("salaryitemtype.name"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            tempMap.put("showtype", item.getString("datatype.showtype"));
            salaryItemMap.put(item.getString("name"), tempMap);
            uniqueCodeRelMap.put(item.getString("uniquecode"), item.getString("name"));
            treeNode = new ItemTreeNode(item.getLong("id"), item.getString("name"), item.getString("number"));
            treeNode.setParentName(item.getString("salaryitemtype.name"));
            treeNode.setParentNumber(item.getString("salaryitemtype.number"));
            itemTreeNodeList.add(treeNode);
        }
        FormulaDataServiceHelper.invokeResetSalaryItemParentNode(itemTreeNodeList, salaryItemMap);
        return salaryItemMap;
    }

    private static void invokeResetSalaryItemParentNode(List<ItemTreeNode> itemTreeNodeList, Map<String, Map<String, Object>> salaryItemMap) {
        BeforeBuildItemTreeEvent event = new BeforeBuildItemTreeEvent(itemTreeNodeList);
        FormulaItemTreeExtPlugin formulaItemTreeExtPlugin = new FormulaItemTreeExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)formulaItemTreeExtPlugin, IFormulaItemTreeExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.formula.IFormulaItemTreeExtPlugin#resetSalaryItemParentNode", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.resetSalaryItemParentNode(event);
            return null;
        });
        itemTreeNodeList = event.getItemTreeNodeList();
        Map<String, Object> tempMap = null;
        for (ItemTreeNode node : itemTreeNodeList) {
            tempMap = salaryItemMap.get(node.getItemName());
            if (tempMap == null) continue;
            tempMap.put("salaryitemtype_name", node.getParentName());
            tempMap.put("salaryitemtype_number", node.getParentNumber());
        }
    }

    private static Map<String, Map<String, Object>> getBSItemList(long orgId, QFilter countryQFilter, List<Map<String, Object>> bizItemPropList, Map<String, String> uniqueCodeRelMap) {
        QFilter useOrgQFilter;
        LinkedHashMap<String, Map<String, Object>> bsItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        String queryField = "id,number,name,bizitemcategory.number,bizitemcategory.name,uniquecode,datatype.showtype,isextprop,bizitemprop,classification";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        filter.and(new QFilter("classification", "!=", (Object)ATTBIZITEM));
        if (orgId > 0L && null != (useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId))) {
            filter.and(useOrgQFilter);
        }
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        String orderBy = "index asc";
        DynamicObject[] result = helper.query(queryField, new QFilter[]{filter}, orderBy);
        List<Map<String, Object>> tempPropList = null;
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(9);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("bizTypeNumber", item.getString("bizitemcategory.number"));
            tempMap.put("bizTypeName", item.getString("bizitemcategory.name"));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            tempMap.put("classification", item.getString("classification"));
            tempPropList = FormulaDataServiceHelper.getBsItemProp(item, uniqueCodeRelMap);
            bizItemPropList.addAll(tempPropList);
            tempMap.put("bizItemPropList", tempPropList);
            bsItemMap.put(item.getString("name"), tempMap);
            uniqueCodeRelMap.put(item.getString("uniquecode"), item.getString("name"));
        }
        return bsItemMap;
    }

    private static Map<String, Map<String, Object>> getAttBSItemList(long orgId, QFilter countryQFilter, List<Map<String, Object>> bizItemPropList, Map<String, String> uniqueCodeRelMap) {
        QFilter useOrgQFilter;
        LinkedHashMap<String, Map<String, Object>> bsItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_attbizitem");
        String queryField = "id,number,name,uniquecode,datatype.showtype,isextprop,bizitemprop,classification,attitemtype";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        filter.and(new QFilter("classification", "=", (Object)ATTBIZITEM));
        if (orgId > 0L && null != (useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_attbizitem", (Long)orgId))) {
            filter.and(useOrgQFilter);
        }
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        String orderBy = "index asc";
        DynamicObject[] result = helper.query(queryField, new QFilter[]{filter}, orderBy);
        Object tempPropList = null;
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(9);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("bizTypeNumber", item.getString("attitemtype"));
            tempMap.put("bizTypeName", AttBizItemtypeEnum.getDesc((String)item.getString("attitemtype")));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            tempMap.put("classification", item.getString("classification"));
            bsItemMap.put(item.getString("name"), tempMap);
            uniqueCodeRelMap.put(item.getString("uniquecode"), item.getString("name"));
        }
        return bsItemMap;
    }

    private static List<Map<String, Object>> getBsItemProp(DynamicObject item, Map<String, String> uniqueCodeRelMap) {
        ArrayList<Map<String, Object>> propList = new ArrayList<Map<String, Object>>(10);
        DynamicObjectCollection entryList = item.getDynamicObjectCollection("bizitempropentry");
        if (entryList.size() == 0) {
            return propList;
        }
        HashMap<String, String> tempMap = null;
        for (DynamicObject entry : entryList) {
            tempMap = new HashMap<String, String>(8);
            tempMap.put("bizItemName", item.getString("name"));
            tempMap.put("name", entry.getString("bizitemprop.name"));
            tempMap.put("number", entry.getString("bizitemprop.number"));
            tempMap.put("datatype", String.valueOf(entry.getLong("bizitemprop.datatype.id")));
            tempMap.put("bizItemUiqueCode", item.getString("uniquecode"));
            tempMap.put("uniquecode", entry.getString("bizitemprop.propuniquecode"));
            propList.add(tempMap);
            uniqueCodeRelMap.put(entry.getString("bizitemprop.propuniquecode"), entry.getString("bizitemprop.name"));
        }
        return propList;
    }

    private static Map<String, Map<String, Object>> getFTItemList(QFilter countryQFilter, Map<String, String> uniqueCodeRelMap) {
        LinkedHashMap<String, Map<String, Object>> bsItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper ftItemRelHelper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        DynamicObjectCollection fetchConfigItemData = ftItemRelHelper.queryOriginalCollection("fetchitem.id", new QFilter[]{new QFilter("enable", "=", (Object)ATTBIZITEM)});
        if (fetchConfigItemData.size() == 0) {
            return bsItemMap;
        }
        List fetchItemIdList = fetchConfigItemData.stream().map(obj -> obj.getLong("fetchitem.id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        String queryField = "id,number,name,fetchitemgroupid.number,fetchitemgroupid.name,uniquecode,datatype.showtype";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        filter.and(new QFilter("id", "in", fetchItemIdList));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        String orderBy = "index asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(8);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("ftItemGroupNumber", item.getString("fetchitemgroupid.number"));
            tempMap.put("ftItemGroupName", item.getString("fetchitemgroupid.name"));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            bsItemMap.put(item.getString("name"), tempMap);
            uniqueCodeRelMap.put(item.getString("uniquecode"), item.getString("name"));
        }
        return bsItemMap;
    }

    private static Map<String, Map<String, Object>> getSPItemList(long orgId, boolean isProrationFormula, QFilter countryQFilter, Map<String, String> uniqueCodeRelMap) {
        QFilter useOrgQFilter;
        LinkedHashMap<String, Map<String, Object>> spItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        if (isProrationFormula) {
            return spItemMap;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_supportitem");
        String queryField = "id,number,name,uniquecode,datatype.showtype";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        if (orgId > 0L && null != (useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_supportitem", (Long)orgId))) {
            filter.and(useOrgQFilter);
        }
        String orderBy = "index asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(5);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            spItemMap.put(item.getString("name"), tempMap);
            uniqueCodeRelMap.put(item.getString("uniquecode"), item.getString("name"));
        }
        return spItemMap;
    }

    private static Map<String, Map<String, Object>> getDMItemList(long orgId, QFilter countryQFilter) {
        LinkedHashMap<String, Map<String, Object>> dmItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_datagrade");
        String queryField = "id,number,name,uniquecode,description,conditionentryidentify.conditionitemname,conditionentryidentify.conditionid,conditionentryidentify.conditionvaltype.number,conditionentryidentify.conditionvaltype.name,conditionentryidentify.conditionaccuracy,conditionentryidentify.conditionlength,conditionentryidentify.conditioncurrency.name";
        QFilter filter = FormulaDataServiceHelper.getQFilter(orgId, countryQFilter);
        String orderBy = "index asc,conditionentryidentify.seq asc";
        DynamicObjectCollection conditionInfo = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, orderBy);
        HashMap<Long, Object> dmMap = new HashMap<Long, Object>(16);
        FormulaDataServiceHelper.dealConditionData(conditionInfo, dmMap);
        queryField = "id,number,name,uniquecode,description,resultentryidentify.resultitemname,resultentryidentify.resultid,resultentryidentify.resultvaltype.number,resultentryidentify.resultvaltype.name,resultentryidentify.resultaccuracy,resultentryidentify.resultlength,resultentryidentify.resultcurrency.name,resultentryidentify.resultdefaultval";
        orderBy = "index asc,resultentryidentify.seq asc";
        DynamicObjectCollection resultInfo = helper.queryOriginalCollection(queryField, new QFilter[]{filter}, orderBy);
        for (DynamicObject obj : resultInfo) {
            Long id = obj.getLong("id");
            Map tempMap = dmMap.getOrDefault(id, new HashMap(16));
            List resultList = tempMap.getOrDefault("resultList", new ArrayList(10));
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            resultMap.put("resultId", obj.getLong("resultentryidentify.resultid"));
            resultMap.put("resultName", obj.getString("resultentryidentify.resultitemname"));
            resultMap.put("resultValType", obj.getString("resultentryidentify.resultvaltype.number"));
            resultMap.put("resultValTypeName", obj.getString("resultentryidentify.resultvaltype.name"));
            resultMap.put("resultAccuracy", obj.getString("resultentryidentify.resultaccuracy"));
            resultMap.put("resultLength", obj.getString("resultentryidentify.resultlength"));
            resultMap.put("resultCurrency", obj.getString("resultentryidentify.resultcurrency.name"));
            resultMap.put("resultDefaultVal", obj.getString("resultentryidentify.resultdefaultval"));
            resultList.add(resultMap);
            tempMap.put("id", obj.getLong("id"));
            tempMap.put("number", obj.getString("number"));
            tempMap.put("name", obj.getString("name"));
            tempMap.put("uniquecode", obj.getString("uniquecode"));
            tempMap.put("description", obj.getString("description"));
            tempMap.put("resultList", resultList);
            dmMap.put(id, tempMap);
        }
        for (Map.Entry entry : dmMap.entrySet()) {
            Map valueMap = (Map)entry.getValue();
            List resultList = (List)valueMap.get("resultList");
            for (HashMap<String, Object> resultMap : resultList) {
                String resultName = (String)resultMap.get("resultName");
                Long resultId = (Long)resultMap.get("resultId");
                HashMap map = new HashMap(16);
                map.put("conditionList", valueMap.get("conditionList"));
                map.put("resultList", resultList);
                map.put("uniquecode", "BR_" + resultId);
                map.put("name", resultName);
                String gradeName = (String)valueMap.get("name");
                map.put("gradeName", gradeName);
                String gradeNamber = (String)valueMap.get("number");
                map.put("gradeNumber", gradeNamber);
                map.put("gradeId", valueMap.get("id"));
                map.put("id", gradeNamber + "_" + resultId);
                map.put("description", valueMap.get("description"));
                map.put("resultValType", resultMap.get("resultValType"));
                dmItemMap.put(gradeName + "_" + resultName, map);
            }
        }
        return dmItemMap;
    }

    private static void dealConditionData(DynamicObjectCollection conditionInfo, Map<Long, Object> dmMap) {
        for (DynamicObject obj : conditionInfo) {
            HashMap<String, Object> tempMap;
            Long id = obj.getLong("id");
            Object idObj = dmMap.get(id);
            if (idObj != null) {
                HashMap<String, Object> conditionMap;
                ArrayList conditionList;
                tempMap = (HashMap<String, Object>)idObj;
                Object conditionListObj = tempMap.get("conditionList");
                if (conditionListObj != null) {
                    conditionList = (ArrayList)conditionListObj;
                    conditionMap = new HashMap<String, Object>(16);
                    conditionMap.put("conditionId", obj.getLong("conditionentryidentify.conditionid"));
                    conditionMap.put("conditionName", obj.getString("conditionentryidentify.conditionitemname"));
                    conditionMap.put("conditionValType", obj.getString("conditionentryidentify.conditionvaltype.number"));
                    conditionMap.put("conditionValTypeName", obj.getString("conditionentryidentify.conditionvaltype.name"));
                    conditionMap.put("conditionAccuracy", obj.getString("conditionentryidentify.conditionaccuracy"));
                    conditionMap.put("conditionLength", obj.getString("conditionentryidentify.conditionlength"));
                    conditionMap.put("conditionCurrency", obj.getString("conditionentryidentify.conditioncurrency.name"));
                    conditionList.add(conditionMap);
                    continue;
                }
                conditionList = new ArrayList(10);
                conditionMap = new HashMap(16);
                conditionMap.put("conditionId", obj.getLong("conditionentryidentify.conditionid"));
                conditionMap.put("conditionName", obj.getString("conditionentryidentify.conditionitemname"));
                conditionMap.put("conditionValType", obj.getString("conditionentryidentify.conditionvaltype.number"));
                conditionMap.put("conditionValTypeName", obj.getString("conditionentryidentify.conditionvaltype.name"));
                conditionMap.put("conditionAccuracy", obj.getString("conditionentryidentify.conditionaccuracy"));
                conditionMap.put("conditionLength", obj.getString("conditionentryidentify.conditionlength"));
                conditionMap.put("conditionCurrency", obj.getString("conditionentryidentify.conditioncurrency.name"));
                conditionList.add(conditionMap);
                tempMap.put("conditionList", conditionList);
                continue;
            }
            tempMap = new HashMap<String, Object>(16);
            tempMap.put("id", obj.getLong("id"));
            tempMap.put("number", obj.getString("number"));
            tempMap.put("name", obj.getString("name"));
            tempMap.put("uniquecode", obj.getString("uniquecode"));
            tempMap.put("description", obj.getString("description"));
            ArrayList conditionList = new ArrayList(10);
            HashMap<String, Object> conditionMap = new HashMap<String, Object>(10);
            conditionMap.put("conditionId", obj.getLong("conditionentryidentify.conditionid"));
            conditionMap.put("conditionName", obj.getString("conditionentryidentify.conditionitemname"));
            conditionMap.put("conditionValType", obj.getString("conditionentryidentify.conditionvaltype.number"));
            conditionMap.put("conditionValTypeName", obj.getString("conditionentryidentify.conditionvaltype.name"));
            conditionMap.put("conditionAccuracy", obj.getString("conditionentryidentify.conditionaccuracy"));
            conditionMap.put("conditionLength", obj.getString("conditionentryidentify.conditionlength"));
            conditionMap.put("conditionCurrency", obj.getString("conditionentryidentify.conditioncurrency.name"));
            conditionList.add(conditionMap);
            tempMap.put("conditionList", conditionList);
            dmMap.put(id, tempMap);
        }
    }

    @NotNull
    private static QFilter getQFilter(long orgId, QFilter countryQFilter) {
        QFilter useOrgQFilter;
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        if (null != countryQFilter) {
            filter.and(countryQFilter);
        }
        if (orgId > 0L && null != (useOrgQFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_datagrade", (Long)orgId))) {
            filter.and(useOrgQFilter);
        }
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        return filter;
    }

    public static Map<String, Object> findFuncById(String nodeId, IFormView view) {
        if (nodeId == null || view == null) {
            return null;
        }
        List<Map<String, Object>> result = FormulaDataServiceHelper.getFuncData(view, "funcKey", null);
        List filterFuncs = result.stream().filter(func -> nodeId.equals(String.valueOf(func.get("uniquecode")))).collect(Collectors.toList());
        if (filterFuncs != null && filterFuncs.size() > 0) {
            return (Map)filterFuncs.get(0);
        }
        return null;
    }

    public static Map<String, Object> findDataGradeById(String id, String parentNodeId, IFormView view) {
        if (id == null || view == null) {
            return null;
        }
        List<Map<String, Object>> result = FormulaDataServiceHelper.getFuncData(view, "dmkey", null);
        List filterDm = result.stream().filter(func -> id.equals(String.valueOf(func.get("id")))).collect(Collectors.toList());
        if (filterDm != null && filterDm.size() > 0) {
            for (Map filter : filterDm) {
                String gradeNumber = (String)filter.get("gradeNumber");
                if (!SWCStringUtils.equals((String)parentNodeId, (String)gradeNumber)) continue;
                return filter;
            }
            return (Map)filterDm.get(0);
        }
        return null;
    }

    public static Set<String> getItemOrFuncList(String itemName, Map<String, Map<String, Map<String, Object>>> dataMap) {
        Map<String, Map<String, Object>> result = dataMap.get(itemName);
        if (result == null || result.size() == 0) {
            return new HashSet<String>();
        }
        return result.keySet();
    }

    public static Set<String> getDMList(String itemName, Map<String, Map<String, Map<String, Object>>> dataMap) {
        Map<String, Map<String, Object>> result = dataMap.get(itemName);
        if (result == null || result.size() == 0) {
            return new HashSet<String>();
        }
        HashSet<String> dmSet = new HashSet<String>(16);
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            Map<String, Object> value = entry.getValue();
            dmSet.add((String)value.get("gradeName"));
        }
        return dmSet;
    }

    public static List<Map<String, Object>> findItemByName(String name, String itemName, Map<String, Map<String, Map<String, Object>>> dataMap) {
        ArrayList<Map<String, Object>> filterItemsList = new ArrayList<Map<String, Object>>();
        Map<String, Map<String, Object>> result = dataMap.get(itemName);
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            if (!entry.getKey().contains(name)) continue;
            filterItemsList.add(entry.getValue());
        }
        return filterItemsList;
    }

    public static Map<String, Object> getEditorKey(IFormView view, Map<String, Map<String, Map<String, Object>>> dataMap, DynamicObject formulaObj) {
        if (dataMap == null || dataMap.size() == 0) {
            dataMap = FormulaDataServiceHelper.getAllItemAndFuncData(view, formulaObj);
        }
        HashMap<String, Object> json = new HashMap<String, Object>(16);
        HashSet<String> keyList = new HashSet<String>(16);
        ArrayList<String> preKeyList = new ArrayList<String>();
        ArrayList<String> itemKeyList = new ArrayList<String>(10);
        keyList.add(FormulaKeyEnum.IF.getCode());
        keyList.add(FormulaKeyEnum.ELSEIF.getCode());
        keyList.add(FormulaKeyEnum.ELSE.getCode());
        keyList.add(FormulaKeyEnum.THEN.getCode());
        keyList.add(FormulaKeyEnum.LIKE.getCode());
        keyList.add(FormulaKeyEnum.RESULT.getCode());
        keyList.add(FormulaKeyEnum.AND.getCode());
        keyList.add(FormulaKeyEnum.OR.getCode());
        keyList.add(FormulaKeyEnum.ENDIF.getCode());
        keyList.add(FormulaKeyEnum.NUM.getCode());
        keyList.add(FormulaKeyEnum.DATE.getCode());
        keyList.add(FormulaKeyEnum.TEXT.getCode());
        keyList.add(FormulaKeyEnum.EXIT.getCode());
        keyList.add(FormulaKeyEnum.NULL.getCode());
        json.put("conditionKey", keyList);
        preKeyList.add("SL");
        preKeyList.add("SP");
        preKeyList.add("FC");
        preKeyList.add("BS");
        preKeyList.add("BR");
        preKeyList.add("FT");
        preKeyList.add("AC");
        preKeyList.add(OperatorEnum.FULLSTOP.getAlias());
        json.put("preKey", preKeyList);
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getItemOrFuncList("salaryitemkey", dataMap), "SL");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getItemOrFuncList("spitemkey", dataMap), "SP");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getItemOrFuncList("funcKey", dataMap), "FC");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getItemOrFuncList("bsitemkey", dataMap), "BS");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getItemOrFuncList("bsattitemkey", dataMap), "BS");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getDMList("dmkey", dataMap), "BR");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getItemOrFuncList("ftitemkey", dataMap), "FT");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getItemOrFuncList("ackey", dataMap), "AC");
        FormulaDataServiceHelper.collectItemKey(itemKeyList, FormulaDataServiceHelper.getBsPropNameSet(dataMap.get("bspropitemkey")), OperatorEnum.FULLSTOP.getAlias());
        json.put("itemKey", itemKeyList);
        return json;
    }

    private static Set<String> getBsPropNameSet(Map<String, Map<String, Object>> bspItemMap) {
        if (bspItemMap == null || bspItemMap.size() == 0) {
            return new HashSet<String>(0);
        }
        return bspItemMap.values().stream().map(obj -> (String)obj.get("name")).collect(Collectors.toSet());
    }

    private static void collectItemKey(List<String> itemKeyList, Set<String> keySet, String preKey) {
        if (CollectionUtils.isEmpty(keySet)) {
            return;
        }
        for (String key : keySet) {
            StringBuilder sb = new StringBuilder();
            sb.append(preKey);
            sb.append('[');
            sb.append(key);
            sb.append(']');
            itemKeyList.add(sb.toString());
        }
    }

    public static List<Map<String, Object>> mapToList(Map<String, Map<String, Object>> dataMap) {
        if (dataMap == null || dataMap.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dataMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : dataMap.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    public static DynamicObjectCollection getFetchConfigEntryByUniqueCode(String uniqueCode) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        QFilter filter = new QFilter("uniquecode", "=", (Object)uniqueCode);
        filter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        DynamicObject result = helper.queryOne("id", new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)result)) {
            return null;
        }
        SWCDataServiceHelper fetchConfigItemHelper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        QFilter fetchConfigItemFilter = new QFilter("fetchitem", "=", (Object)result.getLong("id"));
        fetchConfigItemFilter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        String fetchConfigItemField = "fetchconfig,fetchfieldentry,custfetchconfig,configtype";
        DynamicObject fetchConfigItemResult = fetchConfigItemHelper.queryOne(fetchConfigItemField, new QFilter[]{fetchConfigItemFilter});
        if (ObjectUtils.isEmpty((Object)fetchConfigItemResult)) {
            return null;
        }
        long fetchFieldEntryId = fetchConfigItemResult.getLong("fetchfieldentry");
        String configType = fetchConfigItemResult.getString("configtype");
        if (SWCStringUtils.equals((String)"2", (String)configType)) {
            long custFetchConfigId = fetchConfigItemResult.getLong("custfetchconfig.id");
            String fetchConfigField = "fetchfieldentry.id ,fetchfieldentry.srctype, fetchfieldentry.srcenum,fetchfieldentry.srcfield,fetchfieldentry.srcentity, fetchfieldentry.outputparam";
            return FormulaDataServiceHelper.selectFetchEntity(custFetchConfigId, fetchFieldEntryId, fetchConfigField, "hsbs_custfetchconfig");
        }
        if (SWCStringUtils.equals((String)"0", (String)configType)) {
            long fetchConfigId = fetchConfigItemResult.getLong("fetchconfig.id");
            String fetchConfigField = "fetchfieldentry.id ,fetchfieldentry.srctype, fetchfieldentry.srcenum,fetchfieldentry.srcfield,fetchfieldentry.srcentity, fetchfieldentry.field";
            return FormulaDataServiceHelper.selectFetchEntity(fetchConfigId, fetchFieldEntryId, fetchConfigField, "hsbs_fetchconfig");
        }
        return null;
    }

    private static DynamicObjectCollection selectFetchEntity(long id, long fetchFieldEntryId, String fetchConfigField, String entity) {
        QFilter fetchConfigFilter = new QFilter("id", "=", (Object)id);
        fetchConfigFilter.and(new QFilter("enable", "=", (Object)ATTBIZITEM));
        SWCDataServiceHelper fetchConfigHelper = new SWCDataServiceHelper(entity);
        DynamicObject fetchConfigResult = fetchConfigHelper.queryOne(fetchConfigField, new QFilter[]{fetchConfigFilter});
        if (ObjectUtils.isEmpty((Object)fetchConfigResult)) {
            return null;
        }
        DynamicObjectCollection fetchfieldentry = fetchConfigResult.getDynamicObjectCollection("fetchfieldentry");
        Iterator iterator = fetchfieldentry.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (dynamicObject.getLong("id") == fetchFieldEntryId) continue;
            iterator.remove();
        }
        return fetchfieldentry;
    }
}

