/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.constants.ExampleItemConstants;
import kd.swc.hsas.common.formula.enums.FormulaKeyEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FormulaExampleHelper {
    private static final String LEVEL_PRIMARY = "0";
    private static final String LEVEL_INTERMEDIATE = "1";
    private static final String LEVEL_ADVANCED = "2";

    public static Map<String, Object> getEditorKey() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> preKeyList = new ArrayList<String>(8);
        ArrayList<String> keyList = new ArrayList<String>(14);
        preKeyList.add("SL");
        preKeyList.add("SP");
        preKeyList.add("FC");
        preKeyList.add("BS");
        preKeyList.add("BR");
        preKeyList.add("FT");
        preKeyList.add("AC");
        keyList.add(FormulaKeyEnum.IF.getCode());
        keyList.add(FormulaKeyEnum.ELSEIF.getCode());
        keyList.add(FormulaKeyEnum.ELSE.getCode());
        keyList.add(FormulaKeyEnum.THEN.getCode());
        keyList.add(FormulaKeyEnum.LIKE.getCode());
        keyList.add(FormulaKeyEnum.RESULT.getCode());
        keyList.add(FormulaKeyEnum.AND.getCode());
        keyList.add(FormulaKeyEnum.OR.getCode());
        keyList.add(FormulaKeyEnum.ENDIF.getCode());
        keyList.add(FormulaKeyEnum.NUM.getCode());
        keyList.add(FormulaKeyEnum.DATE.getCode());
        keyList.add(FormulaKeyEnum.TEXT.getCode());
        keyList.add(FormulaKeyEnum.EXIT.getCode());
        keyList.add(FormulaKeyEnum.NULL.getCode());
        json.put("conditionKey", keyList);
        json.put("preKey", preKeyList);
        json.put("itemKey", FormulaExampleHelper.getExampleItemKeyList());
        return json;
    }

    private static List<String> getExampleItemKeyList() {
        SWCDataServiceHelper exampleItemHelper = new SWCDataServiceHelper("hsbs_exampleitem");
        DynamicObject[] exampleItems = exampleItemHelper.queryOriginalArray("name,itemtype", new QFilter[0]);
        if (exampleItems == null || exampleItems.length == 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> itemKeyList = new ArrayList<String>(exampleItems.length);
        for (DynamicObject exampleItem : exampleItems) {
            StringBuilder sb = new StringBuilder();
            String itemType = exampleItem.getString("itemtype");
            if (SWCStringUtils.equals((String)itemType, (String)ExampleItemConstants.ITEM_TYPE_SL)) {
                sb.append("SL");
            } else if (SWCStringUtils.equals((String)itemType, (String)ExampleItemConstants.ITEM_TYPE_SP)) {
                sb.append("SP");
            } else if (SWCStringUtils.equals((String)itemType, (String)ExampleItemConstants.ITEM_TYPE_FT)) {
                sb.append("FT");
            } else if (SWCStringUtils.equals((String)itemType, (String)ExampleItemConstants.ITEM_TYPE_BS)) {
                sb.append("BS");
            } else if (SWCStringUtils.equals((String)itemType, (String)ExampleItemConstants.ITEM_TYPE_AC)) {
                sb.append("AC");
            } else if (SWCStringUtils.equals((String)itemType, (String)ExampleItemConstants.ITEM_TYPE_BR)) {
                sb.append("BR");
            } else {
                if (!SWCStringUtils.equals((String)itemType, (String)ExampleItemConstants.ITEM_TYPE_FC)) continue;
                sb.append("FC");
            }
            sb.append('[');
            sb.append(exampleItem.getString("name"));
            sb.append(']');
            itemKeyList.add(sb.toString());
        }
        return itemKeyList;
    }

    public static List<Map<String, String>> getAllFormulaExample() {
        SWCDataServiceHelper formulaExampleHelper = new SWCDataServiceHelper("hsbs_formulaexample");
        DynamicObject[] formulaExamples = formulaExampleHelper.query("name,formulacontent,description,level,index", new QFilter[0], "index asc");
        if (formulaExamples == null || formulaExamples.length == 0) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> formulaExampleList = new ArrayList<Map<String, String>>(formulaExamples.length);
        for (DynamicObject formulaExample : formulaExamples) {
            HashMap<String, String> exampleMap = new HashMap<String, String>(5);
            exampleMap.put("name", formulaExample.getString("name"));
            exampleMap.put("formulacontent", formulaExample.getString("formulacontent"));
            exampleMap.put("description", formulaExample.getString("description"));
            String level = null;
            switch (formulaExample.getString("level")) {
                case "0": {
                    level = ResManager.loadKDString((String)"\u521d\u7ea7", (String)"FormulaExampleHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
                    break;
                }
                case "1": {
                    level = ResManager.loadKDString((String)"\u4e2d\u7ea7", (String)"FormulaExampleHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
                    break;
                }
                case "2": {
                    level = ResManager.loadKDString((String)"\u9ad8\u7ea7", (String)"FormulaExampleHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
                }
            }
            exampleMap.put("level", level);
            formulaExampleList.add(exampleMap);
        }
        return formulaExampleList;
    }
}

