/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula.helper;

import java.util.ArrayList;
import java.util.List;
import kd.swc.hsas.common.formula.vo.OriginalNode;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class FormulaFormatHelper {
    private static final String DOUBLE_SPACE = "  ";
    private static final char SINGLE_SPACE = ' ';
    private static final char LINE_BREAK = '\n';

    public static String formatFormula(List<OriginalNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        FormulaNode nodeTree = FormulaFormatHelper.createFormulaNodeTree(nodes);
        return FormulaFormatHelper.parseNodeTree(nodeTree);
    }

    private static FormulaNode createFormulaNodeTree(List<OriginalNode> nodes) {
        FormulaNode head;
        FormulaNode currentNode = head = FormulaFormatHelper.createNewNode(null, null);
        for (int index = 0; index < nodes.size(); ++index) {
            FormulaNode parentNode;
            FormulaNode newNode;
            OriginalNode node = nodes.get(index);
            String nodeText = node.getNodeText();
            if (nodeText.startsWith("IF") || nodeText.startsWith("ELSEIF")) {
                if (CollectionUtils.isEmpty(currentNode.getNodeList())) {
                    currentNode.addOriginNode(node);
                    continue;
                }
                newNode = FormulaFormatHelper.createNewNode(node, null);
                parentNode = currentNode.getParent();
                if (nodeText.startsWith("ELSEIF")) {
                    parentNode = parentNode != null ? parentNode.getParent() : null;
                    currentNode.getParent().setNext(newNode);
                } else {
                    currentNode.setNext(newNode);
                }
                newNode.setParent(parentNode);
                currentNode = newNode;
                continue;
            }
            if (nodeText.startsWith("THEN") || nodeText.startsWith("ELSE")) {
                if (CollectionUtils.isEmpty(currentNode.getNodeList())) {
                    currentNode.addOriginNode(node);
                } else {
                    newNode = FormulaFormatHelper.createNewNode(node, null);
                    parentNode = currentNode.getParent();
                    if (SWCStringUtils.equals((String)nodeText, (String)"ELSE")) {
                        parentNode.setNext(newNode);
                        parentNode = parentNode.getParent();
                    } else {
                        currentNode.setNext(newNode);
                    }
                    newNode.setParent(parentNode);
                    currentNode = newNode;
                }
                newNode = FormulaFormatHelper.createNewNode(null, currentNode);
                currentNode.addChildFormulaNode(newNode);
                currentNode = newNode;
                continue;
            }
            if (nodeText.startsWith("ENDIF")) {
                newNode = FormulaFormatHelper.createNewNode(node, currentNode.getParent().getParent());
                currentNode = currentNode.getParent();
                currentNode.setNext(newNode);
                currentNode = newNode;
                if (index + 1 < nodes.size()) {
                    OriginalNode nextNode = nodes.get(index + 1);
                    if (nextNode.getNodeText().startsWith("ELSE") || nextNode.getNodeText().startsWith("ELSEIF")) {
                        newNode = FormulaFormatHelper.createNewNode(null, currentNode.getParent().getParent());
                        currentNode.getParent().setNext(newNode);
                    } else {
                        newNode = FormulaFormatHelper.createNewNode(null, currentNode.getParent());
                        currentNode.setNext(newNode);
                    }
                } else {
                    newNode = FormulaFormatHelper.createNewNode(null, currentNode.getParent());
                    currentNode.setNext(newNode);
                }
                currentNode = newNode;
                continue;
            }
            if (CollectionUtils.isEmpty(currentNode.getNodeList())) {
                currentNode.addOriginNode(node);
                continue;
            }
            newNode = FormulaFormatHelper.createNewNode(node, currentNode.getParent());
            currentNode.setNext(newNode);
            currentNode = newNode;
        }
        return head;
    }

    private static FormulaNode createNewNode(OriginalNode node, FormulaNode parent) {
        FormulaNode newNode = new FormulaNode();
        if (node != null) {
            newNode.addOriginNode(node);
        }
        newNode.setParent(parent);
        return newNode;
    }

    private static String parseNodeTree(FormulaNode formulaNode) {
        StringBuilder formatCodeBuilder = new StringBuilder();
        FormulaFormatHelper.doTransferNodeTree(formulaNode, "", formatCodeBuilder);
        return formatCodeBuilder.deleteCharAt(formatCodeBuilder.length() - 1).toString();
    }

    private static void doTransferNodeTree(FormulaNode formulaNode, String prix, StringBuilder formatCodeBuilder) {
        if (formulaNode == null || CollectionUtils.isEmpty(formulaNode.getNodeList())) {
            return;
        }
        formatCodeBuilder.append(FormulaFormatHelper.transferOriginNodeList(formulaNode.getNodeList(), prix));
        List<FormulaNode> childNodeList = formulaNode.getChildFormulaNodeList();
        if (childNodeList != null) {
            for (FormulaNode childNode : childNodeList) {
                FormulaFormatHelper.doTransferNodeTree(childNode, prix + DOUBLE_SPACE, formatCodeBuilder);
            }
        }
        if (formulaNode.getNext() != null) {
            FormulaFormatHelper.doTransferNodeTree(formulaNode.getNext(), prix, formatCodeBuilder);
        }
    }

    private static String transferOriginNodeList(List<OriginalNode> originalNodeList, String prix) {
        if (CollectionUtils.isEmpty(originalNodeList)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (OriginalNode node : originalNodeList) {
            if (!node.isCommontNode()) {
                stringBuilder.append(prix);
            }
            stringBuilder.append(node.getNodeText());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    static class FormulaNode {
        private List<OriginalNode> nodeList = new ArrayList<OriginalNode>(10);
        private FormulaNode next = null;
        private FormulaNode parent = null;
        private List<FormulaNode> childFormulaNodeList = new ArrayList<FormulaNode>(10);

        public List<OriginalNode> getNodeList() {
            return this.nodeList;
        }

        public void setNodeList(List<OriginalNode> nodeList) {
            this.nodeList = nodeList;
        }

        public FormulaNode getNext() {
            return this.next;
        }

        public void setNext(FormulaNode next) {
            this.next = next;
        }

        public List<FormulaNode> getChildFormulaNodeList() {
            return this.childFormulaNodeList;
        }

        public void setChildFormulaNodeList(List<FormulaNode> childFormulaNodeList) {
            this.childFormulaNodeList = childFormulaNodeList;
        }

        public void addOriginNode(OriginalNode node) {
            this.nodeList.add(node);
        }

        public void addChildFormulaNode(FormulaNode node) {
            this.childFormulaNodeList.add(node);
        }

        public FormulaNode getParent() {
            return this.parent;
        }

        public void setParent(FormulaNode parent) {
            this.parent = parent;
        }
    }
}

