/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.genbizdata;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.genbizdata.GenBizDataService;

public class DelGenBizDataTask
implements Callable {
    private static final Log log = LogFactory.getLog(DelGenBizDataTask.class);
    private List<Long> personIdList;
    private Long taskId;
    private RequestContext requestContext;
    private CountDownLatch countDownLatch;

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public DelGenBizDataTask(List<Long> personIdList, Long taskId, RequestContext requestContext, CountDownLatch countDownLatch) {
        this.personIdList = personIdList;
        this.taskId = taskId;
        this.requestContext = requestContext;
        this.countDownLatch = countDownLatch;
    }

    public Object call() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        log.info("begin delgenbizdata ");
        GenBizDataService service = new GenBizDataService();
        try {
            service.delGenBizData(this.personIdList, this.taskId);
        }
        catch (Exception exception) {
            log.error("delgenbizdata_error", (Throwable)exception);
        }
        finally {
            this.countDownLatch.countDown();
        }
        return null;
    }
}

