/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.genbizdata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.Pair;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.bizdata.service.BizDataServiceHelper;
import kd.swc.hsas.common.enums.ItemTypeFieldsEnum;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCUnifiedThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.SWCUnifiedTaskTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class GenBizDataService {
    private static final Log logger = LogFactory.getLog(GenBizDataService.class);

    public boolean genBizData(Long taskId, List<Long> personIdList, Date bsed, Boolean isReGen, List<Long> reGenBizItemIds) {
        DynamicObject genBizDataConf = this.getGenBizDataConfByTask(taskId);
        if (genBizDataConf == null) {
            return false;
        }
        DynamicObjectCollection refItemEntry = genBizDataConf.getDynamicObjectCollection("entryentity");
        if (SWCListUtils.isEmpty((List)refItemEntry)) {
            return false;
        }
        Map<String, Map<Long, Long>> refItemMap = refItemEntry.stream().collect(Collectors.groupingBy(single -> single.getString("itemtype"), Collectors.toMap(v1 -> v1.getLong("itemid"), v2 -> v2.getLong("refbizitem.id"))));
        Map<Long, Long> refItemDataTypeMap = refItemEntry.stream().collect(Collectors.toMap(v1 -> v1.getLong("refbizitem.id"), v2 -> v2.getLong("datatype.id"), (v1, v2) -> v1));
        List personList = SWCListUtils.split(personIdList, (int)500);
        if (!isReGen.booleanValue()) {
            this.cacheGenBizDataProgress(taskId, personIdList.size());
        }
        Map<String, Object> taskInfo = this.getTaskInfo(taskId);
        SWCUnifiedThreadPoolFactory.SERVICE.execute(() -> {
            for (int i = 0; i < personList.size(); ++i) {
                List personIds = (List)personList.get(i);
                List codeList = (List)SWCMServiceUtils.invokeSWCService((String)"hsbs", (String)"IHSBSBizDataCodeService", (String)"getBizDataCodes", (Object[])new Object[]{"hsas", personIds.size() * refItemEntry.size()});
                if (SWCListUtils.isEmpty((List)codeList)) {
                    this.updateGenBizDataCache(taskId, 0, personIds.size());
                    continue;
                }
                this.asynGenBizData(bsed, refItemMap, refItemDataTypeMap, personIds, codeList, taskInfo, isReGen, reGenBizItemIds);
            }
        }, SWCUnifiedTaskTypeEnum.SWC_GENBIZDATATHREADPOOL.getKey(), RequestContext.get(), OperationContext.get());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delGenBizData(List<Long> personIdList, Long taskId) {
        ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)10);
        try (TXHandle txHandle = TX.requiresNew();){
            Map<Long, String> personFileNumberMap = this.queryPersonFileNumberMap(personIdList);
            Map<String, Pair<Long, Long>> dataCodeItemMap = this.queryPersonDataCodeItemMap(personIdList);
            if (dataCodeItemMap.size() == 0) {
                this.updateDelBizDataCache(taskId, 0, personIdList.size());
                return;
            }
            BizDataServiceHelper helper = new BizDataServiceHelper();
            Map<String, Object> paramMap = this.assembleDelBizDataParams(dataCodeItemMap);
            Map<String, Object> result = helper.delBizData(paramMap);
            if (result == null || !((Boolean)result.get("success")).booleanValue()) {
                this.updateDelBizDataCache(taskId, 0, personIdList.size());
                return;
            }
            Set<Long> refBizItemIdSet = dataCodeItemMap.values().stream().map(single -> (Long)single.getKey()).collect(Collectors.toSet());
            Map<Long, String> bizItemMap = this.assembleRefBizItemMap(refBizItemIdSet);
            List dataList = (List)result.get("result");
            ArrayList failDataCodeList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList succDataCodeList = Lists.newArrayListWithExpectedSize((int)10);
            HashMap<Long, List> succPersonDataCodeMap = new HashMap<Long, List>(16);
            for (Object data : dataList) {
                String bizDataCode = (String)data.get("bizdatacode");
                String status = (String)data.get("status");
                Pair<Long, Long> itemPersonPair = dataCodeItemMap.get(bizDataCode);
                Long personId = (Long)itemPersonPair.getValue();
                if (SWCStringUtils.equals((String)status, (String)"0")) {
                    String fileNumber = personFileNumberMap.get(personId);
                    errMsgList.add(fileNumber + ":\u3010" + bizItemMap.get(itemPersonPair.getKey()) + "\u3011" + BizDataFailStatusEnum.getDesc((String)((String)data.get("errorcode"))));
                    failDataCodeList.add(bizDataCode);
                    continue;
                }
                succDataCodeList.add(bizDataCode);
                List dataCodes = succPersonDataCodeMap.computeIfAbsent(personId, single -> new ArrayList(10));
                dataCodes.add(bizDataCode);
            }
            if (!SWCListUtils.isEmpty((List)errMsgList)) {
                this.updateFailMsgToCache(errMsgList, taskId);
            }
            HashSet failPersonIds = Sets.newHashSetWithExpectedSize((int)16);
            for (Object failCode : failDataCodeList) {
                Pair<Long, Long> failPair = dataCodeItemMap.get(failCode);
                if (failPair == null) continue;
                failPersonIds.add(failPair.getValue());
            }
            ArrayList<String> needReGenDataCodes = new ArrayList<String>(10);
            for (Long person : failPersonIds) {
                List dataCodes = (List)succPersonDataCodeMap.get(person);
                if (SWCListUtils.isEmpty((List)dataCodes)) continue;
                needReGenDataCodes.addAll(dataCodes);
            }
            Set<Long> succPersonIds = personIdList.stream().filter(single -> !failPersonIds.contains(single)).collect(Collectors.toSet());
            this.updateDelBizDataCache(taskId, succPersonIds.size(), failPersonIds.size());
            this.reGenBizData(taskId, needReGenDataCodes);
            this.updatePersonStatusAndDelRefGenBizData(succPersonIds, succDataCodeList);
        }
    }

    public void reGenBizData(Long taskId, List<String> needReGenDataCodes) {
        logger.info("reginbizdata datacode:{}", needReGenDataCodes);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personbizref");
        QFilter filter = new QFilter("bizdatacode", "in", needReGenDataCodes);
        DynamicObjectCollection personBizRefObjs = helper.queryOriginalCollection("bizdatacode,bizitem.id,person,bsed", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)personBizRefObjs)) {
            return;
        }
        ArrayList<Long> personIdList = new ArrayList<Long>(10);
        ArrayList<Long> bizItemIdList = new ArrayList<Long>(10);
        Date bsed = null;
        for (DynamicObject personBizRefObj : personBizRefObjs) {
            bsed = personBizRefObj.getDate("bsed");
            Long personId = personBizRefObj.getLong("person");
            if (!personIdList.contains(personId)) {
                personIdList.add(personId);
            }
            bizItemIdList.add(personBizRefObj.getLong("bizitem.id"));
        }
        try {
            this.genBizData(taskId, personIdList, bsed, Boolean.TRUE, bizItemIdList);
        }
        catch (Exception exception) {
            logger.error("reginbizdata error", (Throwable)exception);
        }
    }

    public void updatePersonStatusAndDelRefGenBizData(Set<Long> succPersonIds, List<String> succDataCodeList) {
        DynamicObject[] persons;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", succPersonIds);
        for (DynamicObject person : persons = helper.query("id,bizdatagenstatus", new QFilter[]{filter})) {
            person.set("bizdatagenstatus", (Object)"1");
        }
        helper.update(persons);
        helper = new SWCDataServiceHelper("hsas_personbizref");
        filter = new QFilter("person", "in", succPersonIds);
        helper.deleteByFilter(new QFilter[]{filter});
        filter = new QFilter("bizdatacode", "in", succDataCodeList);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public Map<String, Object> assembleDelBizDataParams(Map<String, Pair<Long, Long>> dataCodeItemMap) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("operate", "LD");
        params.put("opsystem", "hsas");
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)dataCodeItemMap.size());
        for (Map.Entry<String, Pair<Long, Long>> entry : dataCodeItemMap.entrySet()) {
            String dataCode = entry.getKey();
            Pair<Long, Long> itemPerson = entry.getValue();
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
            dataMap.put("bizdatacode", dataCode);
            dataMap.put("bizitemid", itemPerson.getKey());
            dataList.add(dataMap);
        }
        params.put("data", dataList);
        return params;
    }

    public Map<String, Pair<Long, Long>> queryPersonDataCodeItemMap(List<Long> personIdList) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personbizref");
        QFilter filter = new QFilter("person", "in", personIdList);
        DynamicObjectCollection dataObjs = helper.queryOriginalCollection("person,bizitem.id,bizdatacode", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)dataObjs)) {
            return dataMap;
        }
        for (DynamicObject dataObj : dataObjs) {
            dataMap.put(dataObj.getString("bizdatacode"), new Pair((Object)dataObj.getLong("bizitem.id"), (Object)dataObj.getLong("person")));
        }
        return dataMap;
    }

    public Map<Long, String> queryPersonFileNumberMap(List<Long> personIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdList);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,filenumber", new QFilter[]{filter});
        return personObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("id"), v2 -> v2.getString("filenumber")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynGenBizData(Date bsed, Map<String, Map<Long, Long>> refItemMap, Map<Long, Long> refItemDataTypeMap, List<Long> personIds, List<String> codeList, Map<String, Object> taskInfo, Boolean isReGen, List<Long> reGenBizItemIds) {
        BizDataServiceHelper helper = new BizDataServiceHelper();
        HashMap personResultIdMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        HashMap personFileNumberMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        HashSet failPersonIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet successPersonIds = Sets.newHashSetWithExpectedSize((int)16);
        Long taskId = (Long)taskInfo.get("taskId");
        try (TXHandle txHandle = TX.requiresNew();){
            Map<Long, Pair<Long, Long>> personRefIdMap = this.queryPersonRefIdMap(personIds, personResultIdMap, personFileNumberMap);
            logger.info("personRefIdMap:{}", (Object)personRefIdMap.toString());
            Map<Long, Map<Long, Object>> personItemDataMap = this.queryPersonItemResultMap(refItemMap, personResultIdMap);
            logger.info("personItemDataMap:{}", (Object)personItemDataMap.toString());
            ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)10);
            if (personItemDataMap.size() == 0) {
                this.handleEmptyData(personIds, personFileNumberMap, taskId, errMsgList);
                if (!isReGen.booleanValue()) {
                    this.updateFailMsgToCache(errMsgList, taskId);
                }
                return;
            }
            int failCnt = this.handlePartlyEmptyData(personFileNumberMap, personItemDataMap, errMsgList);
            if (!isReGen.booleanValue()) {
                this.updateGenBizDataCache(taskId, 0, failCnt);
            }
            if (personItemDataMap.size() == 0 && !SWCListUtils.isEmpty((List)errMsgList)) {
                if (!isReGen.booleanValue()) {
                    this.updateFailMsgToCache(errMsgList, taskId);
                }
                return;
            }
            HashMap personItemDataCodeMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
            HashMap personDataCodeMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
            HashMap itemIdRefMap = Maps.newHashMapWithExpectedSize((int)16);
            refItemMap.values().forEach(single -> itemIdRefMap.putAll(single));
            Map<String, Object> params = this.assembleSyncBizDataParams(codeList, personRefIdMap, personItemDataMap, bsed, taskInfo, refItemDataTypeMap, personItemDataCodeMap, personDataCodeMap, itemIdRefMap, isReGen, reGenBizItemIds);
            logger.info("asynGenBizData_params:{}", (Object)params.toString());
            Map<String, Object> result = helper.synBizData(params);
            logger.info("asynGenBizData_result:{}", (Object)result.toString());
            if (result == null || !((Boolean)result.get("success")).booleanValue()) {
                this.updateGenBizDataCache(taskId, 0, personIds.size());
                errMsgList.add(ResManager.loadKDString((String)"\u751f\u6210\u4e1a\u52a1\u6570\u636e\u63a5\u53e3\u8c03\u7528\u5931\u8d25\u3002", (String)"GenBizDataService_1", (String)"swc-hsas-business", (Object[])new Object[0]));
                this.updateFailMsgToCache(errMsgList, taskId);
                return;
            }
            Set<Long> refBizItemIdSet = personItemDataCodeMap.values().stream().map(single -> (Long)single.getKey()).collect(Collectors.toSet());
            Map<Long, String> bizItemMap = this.assembleRefBizItemMap(refBizItemIdSet);
            List dataList = (List)result.get("result");
            ArrayList successDataCodeList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList failDataCodeList = Lists.newArrayListWithExpectedSize((int)10);
            for (Map data : dataList) {
                String bizDataCode = (String)data.get("bizdatacode");
                String status = (String)data.get("status");
                if (SWCStringUtils.equals((String)status, (String)"1")) {
                    successDataCodeList.add(bizDataCode);
                    continue;
                }
                failDataCodeList.add(bizDataCode);
                Pair itemPersonPair = (Pair)personItemDataCodeMap.get(bizDataCode);
                String fileNumber = (String)personFileNumberMap.get(itemPersonPair.getValue());
                errMsgList.add(fileNumber + "\uff1a\u3010" + bizItemMap.get(itemPersonPair.getKey()) + "\u3011" + BizDataFailStatusEnum.getDesc((String)((String)data.get("errorcode"))));
            }
            HashMap needRollback = Maps.newHashMapWithExpectedSize((int)16);
            logger.info("failDataCodeList:{}", (Object)failDataCodeList);
            for (String failCode : failDataCodeList) {
                Pair failPair = (Pair)personItemDataCodeMap.get(failCode);
                if (failPair == null) continue;
                Long failPersonId = (Long)failPair.getValue();
                failPersonIds.add(failPersonId);
                List needRollbackDataCodeList = (List)personDataCodeMap.get(failPersonId);
                for (String dataCode : needRollbackDataCodeList) {
                    needRollback.put(dataCode, personItemDataCodeMap.get(dataCode));
                }
            }
            for (String succCode : successDataCodeList) {
                Pair succPair = (Pair)personItemDataCodeMap.get(succCode);
                if (succPair == null || failPersonIds.contains(succPair.getValue())) continue;
                successPersonIds.add(succPair.getValue());
            }
            if (needRollback.size() > 0) {
                this.rollbackGenBizData(needRollback);
            }
            if (!SWCListUtils.isEmpty((List)successDataCodeList) && successPersonIds.size() > 0) {
                this.savePersonGenBizData(bsed, successDataCodeList, personItemDataCodeMap, successPersonIds);
            }
            if (!SWCListUtils.isEmpty((List)errMsgList)) {
                this.updateFailMsgToCache(errMsgList, taskId);
            }
        }
        logger.info("failPersonIds:{}", (Object)failPersonIds);
        this.updateGenBizDataCache(taskId, successPersonIds.size(), failPersonIds.size());
    }

    public Map<Long, String> assembleRefBizItemMap(Set<Long> refBizItemIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter filter = new QFilter("id", "in", refBizItemIdSet);
        DynamicObjectCollection itemObjs = helper.queryOriginalCollection("id,name,number", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)itemObjs)) {
            return new HashMap<Long, String>(0);
        }
        return itemObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("id"), v2 -> v2.getString("name")));
    }

    public void rollbackGenBizData(Map<String, Pair<Long, Long>> needRollback) {
        Map<String, Object> paramMap = this.assembleDelBizDataParams(needRollback);
        BizDataServiceHelper helper = new BizDataServiceHelper();
        helper.delBizData(paramMap);
    }

    public void updateFailMsgToCache(List<String> errMsgList, Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "genbizdata_failmsg_%s", userId);
        List existErrMsgList = (List)appCache.get(curCacheKey, List.class);
        if (SWCListUtils.isEmpty((List)existErrMsgList)) {
            appCache.put(curCacheKey, errMsgList);
        } else {
            existErrMsgList.addAll(errMsgList);
            appCache.put(curCacheKey, (Object)existErrMsgList);
        }
    }

    public List<String> getCacheFailMsg(Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "genbizdata_failmsg_%s", userId);
        return (List)appCache.get(curCacheKey, List.class);
    }

    public void removeCacheFailMsg(Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "genbizdata_failmsg_%s", userId);
        appCache.remove(curCacheKey);
    }

    public void removeCacheProgress(Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String cacheKey1 = String.format(Locale.ROOT, "genbizdata_progress_%s", userId);
        String cacheKey2 = String.format(Locale.ROOT, "delbizdata_progress_%s", userId);
        String cacheKey3 = String.format(Locale.ROOT, "genbizdata_failmsg_%s", userId);
        appCache.remove(cacheKey1);
        appCache.remove(cacheKey2);
        appCache.remove(cacheKey3);
    }

    public void removeCacheDelGenBizDataProgress(Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "delbizdata_progress_%s", userId);
        appCache.remove(curCacheKey);
    }

    public void savePersonGenBizData(Date bsed, List<String> successDataCodeList, Map<String, Pair<Long, Long>> personItemDataCodeMap, Set<Long> successPersonIds) {
        DynamicObject[] persons;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", successPersonIds);
        for (DynamicObject person : persons = helper.query("id,bizdatagenstatus", new QFilter[]{filter})) {
            person.set("bizdatagenstatus", (Object)"2");
        }
        helper.update(persons);
        helper = new SWCDataServiceHelper("hsas_personbizref");
        List<DynamicObject> personBizRefObjs = this.assemblePersonBizRefObjs(bsed, successDataCodeList, personItemDataCodeMap, helper, successPersonIds);
        helper.save(personBizRefObjs.toArray(new DynamicObject[0]));
    }

    public List<DynamicObject> assemblePersonBizRefObjs(Date bsed, List<String> successDataCodeList, Map<String, Pair<Long, Long>> personItemDataCodeMap, SWCDataServiceHelper helper, Set<Long> successPersonIds) {
        ArrayList dataList = Lists.newArrayListWithCapacity((int)personItemDataCodeMap.size());
        Date now = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (Map.Entry<String, Pair<Long, Long>> entry : personItemDataCodeMap.entrySet()) {
            Pair<Long, Long> itemPerson;
            Long personId;
            String dataCode = entry.getKey();
            if (!successDataCodeList.contains(dataCode) || !successPersonIds.contains(personId = (Long)(itemPerson = entry.getValue()).getValue())) continue;
            DynamicObject obj = helper.generateEmptyDynamicObject();
            obj.set("person", (Object)personId);
            obj.set("bizitem", itemPerson.getKey());
            obj.set("bizdatacode", (Object)dataCode);
            obj.set("bsed", (Object)bsed);
            obj.set("createtime", (Object)now);
            obj.set("modifytime", (Object)now);
            obj.set("creator", (Object)currUserId);
            obj.set("modifier", (Object)currUserId);
            dataList.add(obj);
        }
        return dataList;
    }

    public int handlePartlyEmptyData(Map<Long, String> personFileNumberMap, Map<Long, Map<Long, Object>> personItemDataMap, List<String> errMsgList) {
        int failCnt = 0;
        Map<Long, Object> dataMap = null;
        for (Map.Entry<Long, String> entry : personFileNumberMap.entrySet()) {
            dataMap = personItemDataMap.get(entry.getKey());
            if (dataMap != null && dataMap.size() > 0) continue;
            errMsgList.add(ResManager.loadKDString((String)"{0}\uff1a\u85aa\u8d44\u6838\u7b97\u7ed3\u679c\u4e2d\u7f3a\u5c11\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6240\u9700\u8981\u7684\u7ed3\u679c\u9879\u76ee\u3002", (String)"GenBizDataService_0", (String)"swc-hsas-business", (Object[])new Object[]{entry.getValue()}));
            ++failCnt;
            personItemDataMap.remove(entry.getKey());
        }
        return failCnt;
    }

    public void handleEmptyData(List<Long> personIds, Map<Long, String> personFileNumberMap, Long taskId, List<String> errMsgList) {
        for (Long personId : personIds) {
            String fileNumber = personFileNumberMap.get(personId);
            if (SWCStringUtils.isEmpty((String)fileNumber)) continue;
            errMsgList.add(ResManager.loadKDString((String)"{0}\uff1a\u85aa\u8d44\u6838\u7b97\u7ed3\u679c\u4e2d\u7f3a\u5c11\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6240\u9700\u8981\u7684\u7ed3\u679c\u9879\u76ee\u3002", (String)"GenBizDataService_0", (String)"swc-hsas-business", (Object[])new Object[]{fileNumber}));
        }
        this.updateGenBizDataCache(taskId, 0, personIds.size());
    }

    public Map<String, Object> assembleSyncBizDataParams(List<String> codeList, Map<Long, Pair<Long, Long>> personRefIdMap, Map<Long, Map<Long, Object>> personItemDataMap, Date bsed, Map<String, Object> taskInfo, Map<Long, Long> refItemDataTypeMap, Map<String, Pair<Long, Long>> personItemDataCodeMap, Map<Long, List<String>> personDataCodeMap, Map<Long, Long> itemIdRefMap, Boolean isReGen, List<Long> reGenBizItemIds) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("operate", "1");
        params.put("opsystem", "hsas");
        ArrayList<HashMap> dataList = new ArrayList<HashMap>();
        int codeIndex = 0;
        for (Map.Entry<Long, Map<Long, Object>> personItemData : personItemDataMap.entrySet()) {
            Long personId = personItemData.getKey();
            Pair<Long, Long> personIdPair = personRefIdMap.get(personId);
            Map<Long, Object> itemData = personItemData.getValue();
            List dataCodeList = personDataCodeMap.computeIfAbsent(personId, single -> new ArrayList(10));
            for (Map.Entry<Long, Object> data : itemData.entrySet()) {
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)10);
                Long itemId = data.getKey();
                Long refItemId = itemIdRefMap.get(itemId);
                if (isReGen.booleanValue() && !reGenBizItemIds.contains(refItemId)) continue;
                Object value = data.getValue();
                String dataCode = codeList.get(codeIndex++);
                dataMap.put("bizdatacode", dataCode);
                dataMap.put("bizitemid", refItemId);
                dataMap.put("datasources", "2");
                dataMap.put("batchcode", taskInfo.get("number"));
                dataMap.put("srcsystem", "hsas");
                Long dataType = refItemDataTypeMap.get(refItemId);
                if (dataType != null && dataType == 1020L) {
                    dataMap.put("currencyid", taskInfo.get("currency"));
                    value = new BigDecimal(value + "").setScale((int)((Integer)taskInfo.get("precision")), 4);
                }
                if (dataType != null && dataType == 1050L) {
                    value = SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
                }
                dataMap.put("value", value);
                dataMap.put("employeeid", personIdPair.getKey());
                dataMap.put("depempid", personIdPair.getValue());
                dataMap.put("bsed", bsed);
                personItemDataCodeMap.put(dataCode, (Pair<Long, Long>)new Pair((Object)refItemId, (Object)personId));
                dataList.add(dataMap);
                dataCodeList.add(dataCode);
            }
        }
        params.put("data", dataList);
        return params;
    }

    public Map<Long, Pair<Long, Long>> queryPersonRefIdMap(List<Long> personIds, Map<Long, Long> personResultIdMap, Map<Long, String> personFileNumberMap) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIds);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,filenumber,calresultid,salaryfilev.employee.id,salaryfilev.depemp.id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return dataMap;
        }
        personObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("id"), v2 -> new Pair((Object)v2.getLong("salaryfilev.employee.id"), (Object)v2.getLong("salaryfilev.depemp.id"))));
        for (DynamicObject personObj : personObjs) {
            Long personId = personObj.getLong("id");
            Long employeeId = personObj.getLong("salaryfilev.employee.id");
            Long depempId = personObj.getLong("salaryfilev.depemp.id");
            if (employeeId == null || depempId == null) continue;
            dataMap.put(personId, new Pair((Object)employeeId, (Object)depempId));
            personResultIdMap.put(personObj.getLong("calresultid"), personId);
            personFileNumberMap.put(personId, personObj.getString("filenumber"));
        }
        return dataMap;
    }

    public Map<Long, Map<Long, Object>> queryPersonItemResultMap(Map<String, Map<Long, Long>> refItemMap, Map<Long, Long> personResultIdMap) {
        DynamicObjectCollection itemResultList;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personResultIdMap.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", personResultIdMap.keySet());
        StringBuilder fieldSb = new StringBuilder("id");
        ArrayList<QFilter> typeFilters = new ArrayList<QFilter>(refItemMap.size());
        for (String itemType : refItemMap.keySet()) {
            String selectFieldsByCode = ItemTypeFieldsEnum.getSelectFieldsByCode((String)itemType);
            if (!SWCStringUtils.isNotEmpty((String)selectFieldsByCode)) continue;
            fieldSb.append(selectFieldsByCode);
            QFilter typeFilter = this.getProrationQFilterByItemType(itemType);
            typeFilters.add(typeFilter);
        }
        if (!SWCListUtils.isEmpty(typeFilters)) {
            QFilter firstFilter = (QFilter)typeFilters.get(0);
            for (int i = 1; i < typeFilters.size(); ++i) {
                firstFilter.or((QFilter)typeFilters.get(i));
            }
            filter.and(firstFilter);
        }
        if (SWCListUtils.isEmpty((List)(itemResultList = helper.queryOriginalCollection(fieldSb.toString(), new QFilter[]{filter})))) {
            return resultMap;
        }
        for (Map.Entry<String, Map<Long, Long>> refItemEntry : refItemMap.entrySet()) {
            String itemType = refItemEntry.getKey();
            Map<Long, Long> itemIdMap = refItemEntry.getValue();
            for (DynamicObject result : itemResultList) {
                this.handleSingleResult(resultMap, personResultIdMap, itemType, itemIdMap, result);
            }
        }
        return resultMap;
    }

    public QFilter getProrationQFilterByItemType(String itemType) {
        ItemTypeFieldsEnum itemTypeEnum = ItemTypeFieldsEnum.getByCode((String)itemType);
        QFilter filter = null;
        switch (itemTypeEnum) {
            case SALARYITEM: {
                filter = new QFilter("hsas_caltableentry.slprorationindex", "=", (Object)0);
                break;
            }
            case SPITEM: {
                filter = new QFilter("hsas_calspentry.spprorationindex", "=", (Object)0);
                break;
            }
            case BSITEM: {
                filter = new QFilter("hsas_calbsentry.bsprorationindex", "=", (Object)0);
                break;
            }
            case FTITEM: {
                filter = new QFilter("hsas_calbcentry.ftprorationindex", "=", (Object)0);
                break;
            }
        }
        return filter;
    }

    public void handleSingleResult(Map<Long, Map<Long, Object>> resultMap, Map<Long, Long> personResultIdMap, String itemType, Map<Long, Long> itemIdMap, DynamicObject result) {
        Long calTableId = result.getLong("id");
        Long personId = personResultIdMap.get(calTableId);
        if (personId == null) {
            return;
        }
        Map itemDataMap = resultMap.computeIfAbsent(personId, itemData -> new HashMap(16));
        ItemTypeFieldsEnum itemTypeEnum = ItemTypeFieldsEnum.getByCode((String)itemType);
        switch (itemTypeEnum) {
            case SALARYITEM: {
                this.handleSingleSlResult(itemIdMap, result, itemDataMap);
                break;
            }
            case SPITEM: {
                this.handleSingleSpResult(itemIdMap, result, itemDataMap);
                break;
            }
            case BSITEM: {
                this.handleSingleBsResult(itemIdMap, result, itemDataMap);
                break;
            }
            case FTITEM: {
                this.handleSingleFtResult(itemIdMap, result, itemDataMap);
                break;
            }
        }
    }

    public void handleSingleSlResult(Map<Long, Long> itemIdMap, DynamicObject result, Map<Long, Object> itemDataMap) {
        Long itemId = result.getLong("hsas_caltableentry.salaryitem.id");
        Long refBsItemId = itemIdMap.get(itemId);
        if (refBsItemId == null) {
            return;
        }
        Object value = this.getSingleSlTypeValue(result);
        if (value != null) {
            itemDataMap.put(itemId, value);
        }
    }

    public void handleSingleSpResult(Map<Long, Long> itemIdMap, DynamicObject result, Map<Long, Object> itemDataMap) {
        Long itemId = result.getLong("hsas_calspentry.supportitem.id");
        Long refItemId = itemIdMap.get(itemId);
        if (refItemId == null) {
            return;
        }
        Object value = this.getSingleSpTypeValue(result);
        if (value != null) {
            itemDataMap.put(itemId, value);
        }
    }

    public void handleSingleFtResult(Map<Long, Long> itemIdMap, DynamicObject result, Map<Long, Object> itemDataMap) {
        Long itemId = result.getLong("hsas_calbcentry.fetchitem.id");
        Long refItemId = itemIdMap.get(itemId);
        if (refItemId == null) {
            return;
        }
        Object value = this.getSingleFtTypeValue(result);
        if (value != null) {
            itemDataMap.put(itemId, value);
        }
    }

    public void handleSingleBsResult(Map<Long, Long> itemIdMap, DynamicObject result, Map<Long, Object> itemDataMap) {
        Long itemId = result.getLong("hsas_calbsentry.bizitem.id");
        Long refItemId = itemIdMap.get(itemId);
        if (refItemId == null) {
            return;
        }
        Object value = this.getSingleBsTypeValue(result);
        if (value != null) {
            itemDataMap.put(itemId, value);
        }
    }

    public Object getSingleSlTypeValue(DynamicObject result) {
        Long dataTypeId = result.getLong("hsas_caltableentry.salaryitem.datatype.id");
        Integer scale = result.getInt("hsas_caltableentry.salaryitem.dataprecision.scale");
        Long dataRoundId = result.getLong("hsas_caltableentry.salaryitem.dataround.id");
        RoundingMode roundingMode = dataRoundId != null && dataRoundId > 0L ? ItemDataUtils.getRoundingMode((long)dataRoundId) : RoundingMode.HALF_UP;
        if (dataTypeId == 1010L) {
            return result.getBigDecimal("hsas_caltableentry.numvalue").setScale((int)scale, roundingMode);
        }
        if (dataTypeId == 1020L) {
            return result.getBigDecimal("hsas_caltableentry.calamountvalue");
        }
        if (dataTypeId == 1030L) {
            return result.getString("hsas_caltableentry.textvalue");
        }
        if (dataTypeId == 1050L) {
            return result.getDate("hsas_caltableentry.datevalue");
        }
        return null;
    }

    public Object getSingleSpTypeValue(DynamicObject result) {
        Long dataTypeId = result.getLong("hsas_calspentry.supportitem.datatype.id");
        Long precisionId = result.getLong("hsas_calspentry.supportitem.dataprecision.id");
        Long dataRoundId = result.getLong("hsas_calspentry.supportitem.dataround.id");
        Integer scale = 0;
        if (precisionId != null && precisionId > 0L) {
            scale = ItemDataUtils.getScal((long)precisionId);
        }
        RoundingMode roundingMode = dataRoundId != null && dataRoundId > 0L ? ItemDataUtils.getRoundingMode((long)dataRoundId) : RoundingMode.HALF_UP;
        if (dataTypeId == 1010L) {
            return result.getBigDecimal("hsas_calspentry.spnumvalue").setScale((int)scale, roundingMode);
        }
        if (dataTypeId == 1020L) {
            return result.getString("hsas_calspentry.spnumvalue");
        }
        if (dataTypeId == 1030L) {
            return result.getString("hsas_calspentry.sptextvalue");
        }
        if (dataTypeId == 1050L) {
            return result.getDate("hsas_calspentry.spdatevalue");
        }
        return null;
    }

    public Object getSingleFtTypeValue(DynamicObject result) {
        Long dataTypeId = result.getLong("hsas_calbcentry.fetchitem.datatype.id");
        Long precisionId = result.getLong("hsas_calbcentry.fetchitem.dataprecision.id");
        Long dataRoundId = result.getLong("hsas_calbcentry.fetchitem.dataround.id");
        Integer scale = 0;
        if (precisionId != null && precisionId > 0L) {
            scale = ItemDataUtils.getScal((long)precisionId);
        }
        RoundingMode roundingMode = dataRoundId != null && dataRoundId > 0L ? ItemDataUtils.getRoundingMode((long)dataRoundId) : RoundingMode.HALF_UP;
        if (dataTypeId == 1010L) {
            return result.getBigDecimal("hsas_calbcentry.bcnumvalue").setScale((int)scale, roundingMode);
        }
        if (dataTypeId == 1020L) {
            return result.getString("hsas_calbcentry.bcnumvalue");
        }
        if (dataTypeId == 1030L) {
            return result.getString("hsas_calbcentry.bctextvalue");
        }
        if (dataTypeId == 1050L) {
            return result.getDate("hsas_calbcentry.bcdatevalue");
        }
        return null;
    }

    public Object getSingleBsTypeValue(DynamicObject result) {
        Long dataTypeId = result.getLong("hsas_calbsentry.bizitem.datatype.id");
        Integer scale = result.getInt("hsas_calbsentry.bizitem.scalelimit");
        if (scale == null) {
            scale = 0;
        }
        if (dataTypeId == 1010L) {
            return result.getBigDecimal("hsas_calbsentry.bsnumvalue").setScale((int)scale, RoundingMode.HALF_UP);
        }
        if (dataTypeId == 1020L) {
            return result.getString("hsas_calbsentry.bscalamountvalue");
        }
        if (dataTypeId == 1030L) {
            return result.getString("hsas_calbsentry.bstextvalue");
        }
        if (dataTypeId == 1050L) {
            return result.getDate("hsas_calbsentry.bsdatevalue");
        }
        return null;
    }

    public synchronized void updateGenBizDataCache(Long taskId, int success, int fail) {
        logger.info("updateGenBizDataCache,success:{},fail:{}", (Object)success, (Object)fail);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "genbizdata_progress_%s", userId);
        Map progressMap = (Map)appCache.get(curCacheKey, Map.class);
        Integer existSuccess = progressMap.get("success") == null ? Integer.valueOf(0) : (Integer)progressMap.get("success");
        Integer existFail = progressMap.get("fail") == null ? Integer.valueOf(0) : (Integer)progressMap.get("fail");
        int newSuccess = existSuccess + success;
        int newFail = existFail + fail;
        progressMap.put("success", newSuccess);
        progressMap.put("fail", newFail);
        appCache.put(curCacheKey, (Object)progressMap);
        Integer totalCnt = (Integer)progressMap.get("total");
        int percentage = new BigDecimal(newSuccess).divide(new BigDecimal(String.valueOf(totalCnt)), 2, 1).multiply(new BigDecimal("100")).intValue();
        this.updateGenBizDataProcess(percentage, taskId);
    }

    public synchronized void updateDelBizDataCache(Long taskId, int success, int fail) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "delbizdata_progress_%s", userId);
        Map progressMap = (Map)appCache.get(curCacheKey, Map.class);
        Integer existSuccess = progressMap.get("success") == null ? Integer.valueOf(0) : (Integer)progressMap.get("success");
        Integer existFail = progressMap.get("fail") == null ? Integer.valueOf(0) : (Integer)progressMap.get("fail");
        progressMap.put("success", existSuccess + success);
        progressMap.put("fail", existFail + fail);
        appCache.put(curCacheKey, (Object)progressMap);
    }

    public Map<String, Integer> getDelBizDataProgressCache(Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "delbizdata_progress_%s", userId);
        Map progressMap = (Map)appCache.get(curCacheKey, Map.class);
        return progressMap;
    }

    public Map<String, Integer> getGenBizDataProgressCache(Long taskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "genbizdata_progress_%s", userId);
        Map progressMap = (Map)appCache.get(curCacheKey, Map.class);
        return progressMap;
    }

    public void cacheDelBizDataProgress(Long taskId, int total, int fail) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "delbizdata_progress_%s", userId);
        HashMap progressMap = Maps.newHashMapWithExpectedSize((int)3);
        progressMap.put("total", total);
        progressMap.put("success", 0);
        progressMap.put("fail", fail);
        appCache.put(curCacheKey, (Object)progressMap);
    }

    public void cacheGenBizDataProgress(Long taskId, int total) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_%s", taskId));
        long userId = RequestContext.get().getCurrUserId();
        String curCacheKey = String.format(Locale.ROOT, "genbizdata_progress_%s", userId);
        HashMap progressMap = Maps.newHashMapWithExpectedSize((int)3);
        progressMap.put("total", total);
        progressMap.put("success", 0);
        progressMap.put("fail", 0);
        appCache.put(curCacheKey, (Object)progressMap);
    }

    public List<String> selectRelatedFetchItem() {
        ArrayList fetchConfigIdList = new ArrayList(10);
        ArrayList retFetchConfigIdList = new ArrayList(10);
        ArrayList custFetchConfigIdList = new ArrayList(10);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_resultfetchconfig");
        DynamicObjectCollection retFetchConfigObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        retFetchConfigObjs.stream().forEach(obj -> retFetchConfigIdList.add(obj.getLong("id")));
        helper = new SWCDataServiceHelper("hsbs_custfetchconfig");
        DynamicObjectCollection custFetchConfigObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        custFetchConfigObjs.stream().forEach(obj -> custFetchConfigIdList.add(obj.getLong("id")));
        helper = new SWCDataServiceHelper("hsbs_fetchconfig");
        DynamicObjectCollection fetchConfigObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        fetchConfigObjs.stream().forEach(obj -> fetchConfigIdList.add(obj.getLong("id")));
        ArrayList<String> fetchItemCodeList = new ArrayList<String>(10);
        QFilter fetchConfigFilter = new QFilter("fetchconfig", "in", fetchConfigIdList);
        QFilter retFetchConfigFilter = new QFilter("resultfetchconfig", "in", retFetchConfigIdList);
        QFilter custFetchConfigFilter = new QFilter("custfetchconfig", "in", custFetchConfigIdList);
        filter.and(fetchConfigFilter.or(retFetchConfigFilter).or(custFetchConfigFilter));
        helper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        DynamicObjectCollection items = helper.queryOriginalCollection("fetchitem.uniquecode", new QFilter[]{filter});
        items.stream().forEach(code -> fetchItemCodeList.add(code.getString("fetchitem.uniquecode")));
        return fetchItemCodeList;
    }

    public DynamicObject getItemObjByTypeAndId(String entity, Long itemId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        return helper.queryOriginalOne("name,datatype.id,uniquecode", new QFilter[]{new QFilter("id", "=", (Object)itemId)});
    }

    public Map<String, String> getItemNameByTypeAndId(Map<String, List<Long>> itemIdMap) {
        HashMap<String, String> itemNameMap = new HashMap<String, String>(16);
        for (Map.Entry<String, List<Long>> itemEntry : itemIdMap.entrySet()) {
            String itemType = itemEntry.getKey();
            List<Long> itemIdList = itemEntry.getValue();
            Map<Long, String> nameMap = this.getItemNameByEntityAndId(this.getItemEntityByType(itemType), itemIdList);
            if (nameMap.size() <= 0) continue;
            for (Map.Entry<Long, String> entry : nameMap.entrySet()) {
                itemNameMap.put(itemType + "-" + entry.getKey(), entry.getValue());
            }
        }
        return itemNameMap;
    }

    public Map<Long, String> getItemNameByEntityAndId(String entity, List<Long> itemIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        QFilter filter = new QFilter("id", "in", itemIdList);
        DynamicObjectCollection itemObjs = helper.queryOriginalCollection("id,name", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)itemObjs)) {
            return new HashMap<Long, String>(0);
        }
        return itemObjs.stream().collect(Collectors.toMap(val1 -> val1.getLong("id"), val2 -> val2.getString("name")));
    }

    public String getItemEntityByType(String type) {
        String entity = "";
        switch (type) {
            case "1": {
                entity = "hsbs_salaryitem";
                break;
            }
            case "2": {
                entity = "hsbs_supportitem";
                break;
            }
            case "3": {
                entity = "hsbs_bizitem";
                break;
            }
            case "4": {
                entity = "hsbs_fetchitem";
                break;
            }
        }
        return entity;
    }

    public List<DynamicObject> getCalPersonObjs(List<Long> calPersons, String peritemId) {
        ArrayList<DynamicObject> personObjList = new ArrayList<DynamicObject>(calPersons.size());
        List split = SWCListUtils.split(calPersons, (int)1000);
        for (List personIdList : split) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            QFilter filter = new QFilter("id", "in", (Object)personIdList);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)peritemId);
            if (authorizedDataRuleQFilter != null) {
                filterList.addAll(authorizedDataRuleQFilter);
            } else {
                filterList.add(new QFilter("1", "!=", (Object)1));
            }
            filterList.add(filter);
            logger.info("getCalPersonObjs_filter:{}", (Object)((Object)filterList).toString());
            DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,filenumber,calstatus,bizdatagenstatus", filterList.toArray(new QFilter[filterList.size()]));
            personObjList.addAll(personObjs.stream().collect(Collectors.toList()));
        }
        return personObjList;
    }

    public DynamicObject getGenBizDataConfByTask(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = helper.queryOne("payrollscenev.id", new QFilter[]{filter});
        if (taskObj == null) {
            return null;
        }
        Long sceneVid = taskObj.getLong("payrollscenev.id");
        if (sceneVid == null) {
            return null;
        }
        helper = new SWCDataServiceHelper("hsas_payrollscene");
        filter = new QFilter("id", "=", (Object)sceneVid);
        DynamicObject sceneObj = helper.queryOne("genbizdata.id", new QFilter[]{filter});
        if (sceneObj == null) {
            return null;
        }
        Long genBizConfId = sceneObj.getLong("genbizdata.id");
        if (genBizConfId == null) {
            return null;
        }
        helper = new SWCDataServiceHelper("hsas_genbizdata");
        return helper.queryOne((Object)genBizConfId);
    }

    public Map<String, Object> getTaskInfo(Long taskId) {
        HashMap taskMap = Maps.newHashMapWithExpectedSize((int)2);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = helper.queryOne("number,payrollgroupv.currency.id,payrollgroupv.currency.amtprecision", new QFilter[]{filter});
        if (taskObj == null) {
            return taskMap;
        }
        taskMap.put("number", taskObj.getString("number"));
        taskMap.put("currency", taskObj.getLong("payrollgroupv.currency.id"));
        taskMap.put("taskId", taskId);
        taskMap.put("precision", taskObj.getInt("payrollgroupv.currency.amtprecision"));
        return taskMap;
    }

    public void updateGenBizDataProcess(int percentage, Long taskId) {
        ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "genbizdata_bggroud_taskid_%s", taskId));
        String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
        if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
            HRBackgroundTaskHelper.getInstance().feedbackProgress(bgTaskId, percentage, "", null);
        }
        if (percentage == 100) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_GENBIZDATA.getOperationKey());
        }
    }
}

