/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.importtaskguide;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.importtaskguide.ImportTaskGuideExportService;
import kd.swc.hsas.business.importtaskguide.utils.ImportTaskUtils;
import kd.swc.hsas.common.enums.PresetItemEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.WriteTaskTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ImportTaskGuideImportService {
    private static final Log logger = LogFactory.getLog(ImportTaskGuideImportService.class);
    private Long importTaskId;
    private Long migrationtplId;
    private String url;

    public ImportTaskGuideImportService(String url, Long importTaskId, Long migrationtplId) {
        this.url = url;
        this.importTaskId = importTaskId;
        this.migrationtplId = migrationtplId;
    }

    public Map<String, String> parseAndCheckExcelData(String writeTaskType, Long orgId, String pageId, String importTaskName) {
        HashMap<String, String> resultMap = new HashMap<String, String>(5);
        ArrayList dataHeadList = Lists.newArrayListWithCapacity((int)10);
        ArrayList dataRowList = Lists.newArrayListWithCapacity((int)10);
        DynamicObject migrationTplData = ImportTaskUtils.getMigrationTplData(this.migrationtplId, "id,startline,endline", null);
        logger.info("readExcelData begin");
        this.readExcelData(dataHeadList, dataRowList, migrationTplData.getInt("startline") - 2, migrationTplData.getInt("endline") - 1);
        logger.info("readExcelData end");
        if (dataHeadList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5217\u6807\u9898\u3002", (String)"ImportTaskGuideImportService_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        if (dataRowList.size() == 0) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"ImportTaskGuideImportService_17", (String)"swc-hsas-business", (Object[])new Object[0]));
            return resultMap;
        }
        HashSet<String> errDataList = new HashSet<String>(16);
        List<Map<String, String>> columnList = ImportTaskUtils.getColumnHeadList(this.migrationtplId, this.importTaskId);
        Map<Integer, PresetItemEnum> tplFixItemMap = this.getTplFixItemMap(columnList);
        this.checkExcelTemplate(dataHeadList, errDataList, tplFixItemMap);
        if (errDataList.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u6a21\u677f\u5217\u540d\u201c{0}\u201d\u4e0d\u80fd\u5220\u9664\u3002", (String)"ImportTaskGuideImportService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            String errorMsg = SWCListUtils.join(errDataList, (String)"\u3001");
            throw new KDBizException(MessageFormat.format(msg, errorMsg));
        }
        String cacheKey = UUID.randomUUID().toString();
        resultMap.put("totalCount", String.valueOf(dataRowList.size()));
        resultMap.put("cacheKey", cacheKey);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String name = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u6570\u636e\u5bfc\u5165-%s", (String)"ImportTaskGuideImportService_10", (String)"swc-hsas-business", (Object[])new Object[0]);
        name = String.format(Locale.ROOT, name, importTaskName);
        params.put("importTaskId", this.importTaskId);
        params.put("verifyId", cacheKey);
        params.put("totalCount", dataRowList.size());
        params.put("startTime", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        params.put("progressType", "22");
        String bgTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_importtaskguide_import", name, true, pageId, params);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", cacheKey));
        appCache.put("bgTaskId", (Object)bgTaskId);
        appCache.put("totalCount", (Object)dataRowList.size());
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"IMPORTTASK_IMPORT_IN_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            logger.info("parseAndCheckExcelData ,tranceId={}", (Object)ctx.getTraceId());
            this.importData(dataHeadList, dataRowList, migrationTplData, cacheKey, writeTaskType, orgId, tplFixItemMap);
        });
        return resultMap;
    }

    private void importData(List<Map<Integer, String>> dataHeadList, List<Map<Integer, String>> dataRowList, DynamicObject migrationTplData, String cacheKey, String writeTaskType, Long orgId, Map<Integer, PresetItemEnum> tplFixItemMap) {
        logger.info("importData begin,importTaskId={}", (Object)this.importTaskId);
        ArrayList<Map<String, String>> errDataList = new ArrayList<Map<String, String>>(10);
        ImportTaskGuideExportService service = new ImportTaskGuideExportService();
        if (this.isCancel(cacheKey).booleanValue()) {
            return;
        }
        boolean hasWorkStartDate = tplFixItemMap.containsKey(11);
        Map<Integer, List<Map<String, String>>> columnIndexMap = this.getColumnIndexMap();
        int defaultSize = 500;
        List splitDataList = SWCListUtils.split(dataRowList, (int)defaultSize);
        int lineIndex = 0;
        List tempList = null;
        int size = splitDataList.size();
        for (int index = 0; index < size; ++index) {
            tempList = (List)splitDataList.get(index);
            lineIndex = index * defaultSize;
            this.checkImportData(tempList, errDataList, columnIndexMap, lineIndex, cacheKey, writeTaskType, orgId, hasWorkStartDate);
        }
        if (this.isCancel(cacheKey).booleanValue()) {
            return;
        }
        if (errDataList.size() > 0) {
            String fileUrl = service.getImportErrorExcelFile(dataHeadList, dataRowList, errDataList, migrationTplData.getInt("startline") - 2, writeTaskType, columnIndexMap, hasWorkStartDate);
            ImportTaskUtils.updateImportDataProgress(0, 0, cacheKey, fileUrl);
        }
        logger.info("importData end,importTaskId={}", (Object)this.importTaskId);
    }

    private Boolean isCancel(String cacheKey) {
        String key = String.format(Locale.ROOT, "import_cache_%s", cacheKey);
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        Boolean isCancel = (Boolean)appCache.get(String.format(Locale.ROOT, "isCancel_%s", cacheKey), Boolean.class);
        if (isCancel != null && isCancel.booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void saveData(Map<Integer, Map<Integer, Object>> passDataRowMap, Map<Integer, List<Map<String, String>>> columnIndexMap, String writeTaskType, Map<String, DynamicObject> adminOrgMap, boolean hasWorkStartDate) {
        if (passDataRowMap == null || passDataRowMap.size() == 0) {
            return;
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_temporarydata");
        EntityType entryType = (EntityType)type.getAllEntities().get("itementry");
        DynamicObject temporary = null;
        Map<Integer, Object> rowMap = null;
        for (Map.Entry<Integer, Map<Integer, Object>> entry : passDataRowMap.entrySet()) {
            temporary = (DynamicObject)type.createInstance();
            rowMap = entry.getValue();
            temporary.set("datastatus", (Object)"0");
            if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(writeTaskType)) {
                ImportTaskUtils.setTemporaryValueForHisDataImoport(temporary, rowMap, adminOrgMap, hasWorkStartDate);
            } else {
                ImportTaskUtils.setTemporaryValueForCommon(temporary, rowMap);
            }
            temporary.set("importtask", (Object)this.importTaskId);
            temporary.set("creator", (Object)RequestContext.get().getCurrUserId());
            temporary.set("createtime", (Object)new Date());
            temporary.set("modifier", (Object)RequestContext.get().getCurrUserId());
            temporary.set("modifytime", (Object)new Date());
            temporary.set("itementry", (Object)ImportTaskUtils.getItemEntryList(rowMap, columnIndexMap, entryType));
            result.add((Object)temporary);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        try (TXHandle txHandle = TX.requiresNew();){
            helper.save(result);
            helper.setEntityName("hsas_importtask");
            DynamicObject importTask = helper.queryOne((Object)this.importTaskId);
            importTask.set("taskstatus", (Object)"1");
            importTask.set("modifytime", (Object)new Date());
            importTask.set("modifier", (Object)RequestContext.get().getCurrUserId());
            importTask.set("count", (Object)(importTask.getInt("count") + result.size()));
            helper.updateOne(importTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkImportData(List<Map<Integer, String>> dataRowList, List<Map<String, String>> allErrDataList, Map<Integer, List<Map<String, String>>> columnIndexMap, int lineIndex, String cacheKey, String writeTaskType, Long orgId, boolean hasWorkStartDate) {
        HashMap<Integer, Map<Integer, Object>> passDataRowMap = new HashMap<Integer, Map<Integer, Object>>(16);
        int lineIndexVer = lineIndex;
        ArrayList<Map<String, String>> errDataList = new ArrayList<Map<String, String>>(10);
        HashMap<String, List<Integer>> payRollGroupMap = new HashMap<String, List<Integer>>(16);
        HashMap<String, List<Integer>> payRollSceneMap = new HashMap<String, List<Integer>>(16);
        HashMap<String, List<Integer>> calTaskMap = new HashMap<String, List<Integer>>(16);
        HashSet<String> adminOrgNumberSet = new HashSet<String>(dataRowList.size());
        HashSet<String> empNumberSet = new HashSet<String>(dataRowList.size());
        int successCount = 0;
        int failCount = 0;
        try {
            Map<String, DynamicObject> adminOrgMap;
            HashMap<Integer, Object> passRowMap = null;
            boolean isSuccess = true;
            for (Map<Integer, String> rowMap : dataRowList) {
                passRowMap = new HashMap<Integer, Object>(16);
                if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(writeTaskType)) {
                    isSuccess = this.checkFieldRequriedForHisDataImport(rowMap, errDataList, lineIndex, passRowMap, payRollGroupMap, payRollSceneMap, hasWorkStartDate);
                    String adminOrgNumber = rowMap.get(9);
                    if (SWCStringUtils.isNotEmpty((String)adminOrgNumber)) {
                        adminOrgNumberSet.add(adminOrgNumber);
                    }
                    if (isSuccess) {
                        empNumberSet.add(rowMap.get(6));
                    }
                } else {
                    isSuccess = this.checkFieldRequriedForCommon(rowMap, errDataList, lineIndex, passRowMap, calTaskMap);
                }
                if (!isSuccess) {
                    ++lineIndex;
                    continue;
                }
                if (!this.checkItemValue(columnIndexMap, passRowMap, errDataList, lineIndex, rowMap)) {
                    ++lineIndex;
                    continue;
                }
                if (isSuccess) {
                    passDataRowMap.put(lineIndex, passRowMap);
                }
                ++lineIndex;
            }
            if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(writeTaskType)) {
                this.checkPayRollGroup(payRollGroupMap, passDataRowMap, errDataList, orgId);
                this.checkPayRollScene(payRollSceneMap, passDataRowMap, errDataList);
                this.checkEmpNumberData(passDataRowMap, errDataList, empNumberSet, hasWorkStartDate);
            }
            if (calTaskMap.size() > 0) {
                this.checkCalTaskIsExist(calTaskMap, errDataList, passDataRowMap, orgId);
            }
            if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(writeTaskType)) {
                adminOrgMap = this.getAdminOrgByNumber(adminOrgNumberSet);
                this.checkAdminOrg(adminOrgMap, errDataList, passDataRowMap);
            } else {
                adminOrgMap = null;
            }
            if (this.isCancel(cacheKey).booleanValue()) {
                return;
            }
            this.saveData(passDataRowMap, columnIndexMap, writeTaskType, adminOrgMap, hasWorkStartDate);
            successCount = passDataRowMap.size();
            failCount = dataRowList.size() - successCount;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            successCount = 0;
            failCount = dataRowList.size();
            errDataList.clear();
            this.setErrorData(dataRowList.size(), lineIndexVer, errDataList, e.getMessage());
        }
        finally {
            allErrDataList.addAll(errDataList);
            ImportTaskUtils.updateImportDataProgress(successCount, failCount, cacheKey, null);
        }
    }

    private void checkEmpNumberData(Map<Integer, Map<Integer, Object>> passDataRowMap, List<Map<String, String>> errDataList, Set<String> empNumberSet, boolean hasWorkStartDate) {
        if (passDataRowMap.size() == 0) {
            return;
        }
        String notExistMsg = ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u5b58\u5728\u3002", (String)"ImportTaskGuideImportService_14", (String)"swc-hsas-business", (Object[])new Object[0]);
        String multipleMsg = ResManager.loadKDString((String)"\u8be5\u5de5\u53f7\u5339\u914d\u5230\u591a\u4e2a\u7528\u5de5\u8bb0\u5f55\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u3002", (String)"ImportTaskGuideImportService_15", (String)"swc-hsas-business", (Object[])new Object[0]);
        String noMatchMsg = ResManager.loadKDString((String)"\u8be5\u5de5\u53f7\u5bf9\u5e94\u7684\u7528\u5de5\u8bb0\u5f55\u4e0e\u6240\u5bfc\u5165\u7684\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u4e0d\u5339\u914d\u3002", (String)"ImportTaskGuideImportService_16", (String)"swc-hsas-business", (Object[])new Object[0]);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        QFilter filter = new QFilter("empnumber", "in", empNumberSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObjectCollection result = helper.queryOriginalCollection("empnumber,startdate", new QFilter[]{filter});
        Map<String, List<DynamicObject>> empNumberMap = result.stream().collect(Collectors.groupingBy(obj -> obj.getString("empnumber")));
        Map<Integer, Object> rowMap = null;
        ArrayList<Integer> errorIndexList = new ArrayList<Integer>(passDataRowMap.size());
        List<DynamicObject> empObjList = null;
        for (Map.Entry<Integer, Map<Integer, Object>> entry : passDataRowMap.entrySet()) {
            rowMap = entry.getValue();
            empObjList = empNumberMap.get(rowMap.get(6));
            if (SWCListUtils.isEmpty(empObjList)) {
                errDataList.add(this.assembleErrMap(entry.getKey(), false, notExistMsg));
                errorIndexList.add(entry.getKey());
                continue;
            }
            Date workStartDate = null;
            if (hasWorkStartDate) {
                workStartDate = (Date)rowMap.get(11);
            }
            if (empObjList.size() == 1) {
                if (workStartDate == null || this.checkIsMatchWorkStartDate(workStartDate, empObjList)) continue;
                errDataList.add(this.assembleErrMap(entry.getKey(), false, noMatchMsg));
                errorIndexList.add(entry.getKey());
                continue;
            }
            if (workStartDate == null) {
                errDataList.add(this.assembleErrMap(entry.getKey(), false, multipleMsg));
                errorIndexList.add(entry.getKey());
                continue;
            }
            if (this.checkIsMatchWorkStartDate(workStartDate, empObjList)) continue;
            errDataList.add(this.assembleErrMap(entry.getKey(), false, noMatchMsg));
            errorIndexList.add(entry.getKey());
        }
        for (Integer index : errorIndexList) {
            passDataRowMap.remove(index);
        }
    }

    private boolean checkIsMatchWorkStartDate(Date workStartDate, List<DynamicObject> empObjList) {
        boolean isMatch = false;
        for (DynamicObject obj : empObjList) {
            Date startDate = obj.getDate("startdate");
            if (!SWCDateUtils.isEqual((Date)workStartDate, (Date)startDate)) continue;
            isMatch = true;
            break;
        }
        return isMatch;
    }

    private void checkAdminOrg(Map<String, DynamicObject> adminOrgMap, List<Map<String, String>> errDataList, Map<Integer, Map<Integer, Object>> passDataRowMap) {
        String errorMsg = ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"ImportTaskGuideImportService_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        ArrayList<Integer> errorIndexList = new ArrayList<Integer>(passDataRowMap.size());
        for (Map.Entry<Integer, Map<Integer, Object>> entry : passDataRowMap.entrySet()) {
            DynamicObject adminOrg;
            Map<Integer, Object> paramMap = entry.getValue();
            String adminNumber = (String)paramMap.get(9);
            if (SWCStringUtils.isEmpty((String)adminNumber) || (adminOrg = adminOrgMap.get(adminNumber)) != null) continue;
            errorIndexList.add(entry.getKey());
        }
        if (!CollectionUtils.isEmpty(errorIndexList)) {
            this.addErrorData(errorIndexList, errDataList, passDataRowMap, errorMsg);
        }
    }

    private boolean checkFieldRequriedForCommon(Map<Integer, String> rowMap, List<Map<String, String>> errDataList, int lineIndex, Map<Integer, Object> passRowMap, Map<String, List<Integer>> calTaskMap) {
        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c{0}\u201d\u3002", (String)"ImportTaskGuideImportService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        if (SWCStringUtils.isEmpty((String)rowMap.get(0))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.CALTASK_COMMON_AND_ADD.getItemName())));
            return false;
        }
        passRowMap.put(0, rowMap.get(0));
        if (SWCStringUtils.isEmpty((String)rowMap.get(1))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.EMP_NUMBER_COMMON_AND_ADD.getItemName())));
            return false;
        }
        passRowMap.put(1, rowMap.get(1));
        if (SWCStringUtils.isEmpty((String)rowMap.get(2))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.NAME_COMMON_AND_ADD.getItemName())));
            return false;
        }
        passRowMap.put(2, rowMap.get(2));
        if (SWCStringUtils.isEmpty((String)rowMap.get(3))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.SALARYFILE_NUMBER_COMMON_AND_ADD.getItemName())));
            return false;
        }
        passRowMap.put(3, rowMap.get(3));
        List<Integer> lineIndexList = calTaskMap.get(rowMap.get(0));
        if (lineIndexList == null) {
            lineIndexList = new ArrayList<Integer>(10);
            calTaskMap.put(rowMap.get(0), lineIndexList);
        }
        lineIndexList.add(lineIndex);
        return true;
    }

    private void checkCalTaskIsExist(Map<String, List<Integer>> calTaskNameMap, List<Map<String, String>> errDataList, Map<Integer, Map<Integer, Object>> passDataRowMap, Long orgId) {
        Map<String, DynamicObject> calTaskMap = this.getCalTaskByName(calTaskNameMap);
        String taskNotExistMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"ImportTaskGuideImportService_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        String orgNotEqualMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0e\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5339\u914d\u3002", (String)"ImportTaskGuideImportService_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        DynamicObject calTask = null;
        Set<Long> payRollGroupIdSet = new HashSet<Long>(16);
        Set<Long> payRollSceneIdSet = new HashSet<Long>(16);
        HashMap<String, List<Integer>> checkPassDataMap = new HashMap<String, List<Integer>>(calTaskNameMap.size());
        for (Map.Entry<String, List<Integer>> entry : calTaskNameMap.entrySet()) {
            calTask = calTaskMap.get(entry.getKey());
            if (null == calTask) {
                this.addErrorData(entry.getValue(), errDataList, passDataRowMap, taskNotExistMsg);
                continue;
            }
            if (!SWCObjectUtils.equals((Object)orgId, (Object)calTask.getLong("payrollgroup.org.id"))) {
                this.addErrorData(entry.getValue(), errDataList, passDataRowMap, orgNotEqualMsg);
                continue;
            }
            payRollGroupIdSet.add(calTask.getLong("payrollgroup.id"));
            payRollSceneIdSet.add(calTask.getLong("payrollscene.id"));
            checkPassDataMap.put(entry.getKey(), entry.getValue());
        }
        if (checkPassDataMap.size() == 0) {
            return;
        }
        DynamicObjectCollection payRollData = this.getHasPermPayRollGroupData(payRollGroupIdSet);
        DynamicObjectCollection paySceneData = this.getHasPermsPayRollSceneData(payRollSceneIdSet);
        payRollGroupIdSet = payRollData.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        payRollSceneIdSet = paySceneData.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        String noPayRollGroupPermMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ImportTaskGuideImportService_8", (String)"swc-hsas-business", (Object[])new Object[0]);
        String noPayRollScenePermMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u85aa\u8d44\u6838\u7b97\u573a\u666f\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ImportTaskGuideImportService_7", (String)"swc-hsas-business", (Object[])new Object[0]);
        Map<Integer, Object> rowMap = null;
        for (Map.Entry entry : checkPassDataMap.entrySet()) {
            calTask = calTaskMap.get(entry.getKey());
            if (null == calTask) continue;
            if (!payRollGroupIdSet.contains(calTask.getLong("payrollgroup.id"))) {
                this.addErrorData((List)entry.getValue(), errDataList, passDataRowMap, noPayRollGroupPermMsg);
                continue;
            }
            if (!payRollSceneIdSet.contains(calTask.getLong("payrollscene.id"))) {
                this.addErrorData((List)entry.getValue(), errDataList, passDataRowMap, noPayRollScenePermMsg);
                continue;
            }
            for (Integer lineIndex : (List)entry.getValue()) {
                rowMap = passDataRowMap.get(lineIndex);
                if (rowMap == null) continue;
                rowMap.put(-1, calTask.getLong("payrollgroup.id"));
                rowMap.put(-2, calTask.getLong("payrollscene.id"));
            }
        }
    }

    private void addErrorData(List<Integer> lineIndexList, List<Map<String, String>> errDataList, Map<Integer, Map<Integer, Object>> passDataRowMap, String msg) {
        for (Integer index : lineIndexList) {
            errDataList.add(this.assembleErrMap(index, false, msg));
            passDataRowMap.remove(index);
        }
    }

    private Map<String, DynamicObject> getCalTaskByName(Map<String, List<Integer>> calTaskMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String fields = "id,name,payrollgroup.id,payrollscene.id,payrollgroup.org.id";
        QFilter qFilter = new QFilter("name", "in", calTaskMap.keySet());
        qFilter.and("taskstatus", "!=", (Object)CalPayrollTaskStateEnum.DISUSED.getCode());
        qFilter.and("tasktype", "in", (Object)new String[]{"0", "1"});
        DynamicObjectCollection calTaskData = helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
        return calTaskData.stream().collect(Collectors.toMap(obj -> obj.getString("name"), obj -> obj, (k1, key2) -> k1));
    }

    private Map<String, DynamicObject> getAdminOrgByNumber(Set<String> adminOrgNumberSet) {
        if (adminOrgNumberSet.size() == 0) {
            return new HashMap<String, DynamicObject>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("haos_adminorghr");
        QFilter filter = new QFilter("number", "in", adminOrgNumberSet);
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataHisHelper.getHisCurrFilter());
        DynamicObjectCollection adminOrgs = helper.queryOriginalCollection("id,name,number", new QFilter[]{filter});
        return adminOrgs.stream().collect(Collectors.toMap(adminOrg -> adminOrg.getString("number"), adminOrg -> adminOrg));
    }

    private boolean checkFieldRequriedForHisDataImport(Map<Integer, String> rowMap, List<Map<String, String>> errDataList, int lineIndex, Map<Integer, Object> passRowMap, Map<String, List<Integer>> payRollGroupMap, Map<String, List<Integer>> payRollSceneMap, boolean hasWorkStartDate) {
        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c{0}\u201d\u3002", (String)"ImportTaskGuideImportService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        if (SWCStringUtils.isNotEmpty((String)rowMap.get(0))) {
            passRowMap.put(0, rowMap.get(0));
        }
        if (SWCStringUtils.isEmpty((String)rowMap.get(1))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.PAYROLLGROUP.getItemName())));
            return false;
        }
        List payRollGroupList = payRollGroupMap.getOrDefault(rowMap.get(1), new ArrayList());
        payRollGroupList.add(lineIndex);
        payRollGroupMap.put(rowMap.get(1), payRollGroupList);
        passRowMap.put(1, rowMap.get(1));
        if (SWCStringUtils.isNotEmpty((String)rowMap.get(2))) {
            List payRollSceneList = payRollSceneMap.getOrDefault(rowMap.get(2), new ArrayList());
            payRollSceneList.add(lineIndex);
            payRollSceneMap.put(rowMap.get(2), payRollSceneList);
            passRowMap.put(2, rowMap.get(2));
        }
        if (SWCStringUtils.isEmpty((String)rowMap.get(3))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.CALPERIOD_TYPE.getImportColumnName())));
            return false;
        }
        passRowMap.put(3, rowMap.get(3));
        if (SWCStringUtils.isEmpty((String)rowMap.get(4))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.CALPERIOD.getImportColumnName())));
            return false;
        }
        passRowMap.put(4, rowMap.get(4));
        if (SWCStringUtils.isNotEmpty((String)rowMap.get(5))) {
            try {
                passRowMap.put(5, SWCDateTimeUtils.parseDate((String)rowMap.get(5), (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                errDataList.add(this.assembleErrMap(lineIndex, false, ResManager.loadKDString((String)"\u652f\u4ed8\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"ImportTaskGuideImportService_3", (String)"swc-hsas-business", (Object[])new Object[0])));
                return false;
            }
        }
        if (SWCStringUtils.isEmpty((String)rowMap.get(6))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.EMP_NUMBER.getImportColumnName())));
            return false;
        }
        passRowMap.put(6, rowMap.get(6));
        if (SWCStringUtils.isEmpty((String)rowMap.get(7))) {
            errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, PresetItemEnum.NAME.getImportColumnName())));
            return false;
        }
        passRowMap.put(7, rowMap.get(7));
        if (SWCStringUtils.isNotEmpty((String)rowMap.get(8))) {
            passRowMap.put(8, rowMap.get(8));
        }
        if (SWCStringUtils.isNotEmpty((String)rowMap.get(9))) {
            passRowMap.put(9, rowMap.get(9));
        }
        if (SWCStringUtils.isNotEmpty((String)rowMap.get(10))) {
            passRowMap.put(10, rowMap.get(10));
        }
        if (hasWorkStartDate && SWCStringUtils.isNotEmpty((String)rowMap.get(11))) {
            try {
                passRowMap.put(11, SWCDateTimeUtils.parseDate((String)rowMap.get(11), (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                errDataList.add(this.assembleErrMap(lineIndex, false, ResManager.loadKDString((String)"\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"ImportTaskGuideImportService_13", (String)"swc-hsas-business", (Object[])new Object[0])));
                return false;
            }
        }
        return true;
    }

    private void setErrorData(int size, int lineIndexVer, List<Map<String, String>> errDataList, String errorMsg) {
        for (int i = 0; i < size; ++i) {
            errDataList.add(this.assembleErrMap(lineIndexVer, false, errorMsg));
            ++lineIndexVer;
        }
    }

    private void checkPayRollScene(Map<String, List<Integer>> payRollSceneMap, Map<Integer, Map<Integer, Object>> passDataRowMap, List<Map<String, String>> errDataList) {
        if (payRollSceneMap.size() == 0) {
            return;
        }
        Map<String, Long> nameMap = this.getPayRollSceneData(payRollSceneMap.keySet());
        String msg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0d\u5b58\u5728\u3002", (String)"ImportTaskGuideImportService_6", (String)"swc-hsas-business", (Object[])new Object[0]);
        String noPermMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u85aa\u8d44\u6838\u7b97\u573a\u666f\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ImportTaskGuideImportService_7", (String)"swc-hsas-business", (Object[])new Object[0]);
        Set<Long> payRollScenneIdSet = nameMap.values().stream().collect(Collectors.toSet());
        DynamicObjectCollection result = this.getHasPermsPayRollSceneData(payRollScenneIdSet);
        Set hasPermIdSet = result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        Long payRollSceneId = null;
        for (Map.Entry<String, List<Integer>> entry : payRollSceneMap.entrySet()) {
            payRollSceneId = nameMap.get(entry.getKey());
            if (payRollSceneId == null) {
                this.addErrorData(entry.getValue(), errDataList, passDataRowMap, msg);
                continue;
            }
            if (!hasPermIdSet.contains(payRollSceneId)) {
                this.addErrorData(entry.getValue(), errDataList, passDataRowMap, noPermMsg);
                continue;
            }
            for (Integer lineIndex : entry.getValue()) {
                Map<Integer, Object> rowMap = passDataRowMap.get(lineIndex);
                if (rowMap == null) continue;
                rowMap.put(2, payRollSceneId);
            }
        }
    }

    private Map<String, Long> getPayRollSceneData(Set<String> nameSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter qFilter = new QFilter("name", "in", nameSet);
        qFilter.and(BaseDataHisHelper.getHisCurrFilter());
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        String fields = "id,name";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
        return result.stream().collect(Collectors.toMap(obj -> obj.getString("name"), obj -> obj.getLong("id")));
    }

    private DynamicObjectCollection getHasPermsPayRollSceneData(Set<Long> payRollScenneIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_temporarydata", (String)"payrollscene", (String)"47150e89000000ac");
        QFilter filter = new QFilter("id", "in", payRollScenneIdSet);
        if (dataFilter != null) {
            filter.and(dataFilter);
        }
        return helper.queryOriginalCollection("id", new QFilter[]{filter});
    }

    private DynamicObjectCollection getPayRollGroupData(Set<String> nameSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter qFilter = new QFilter("name", "in", nameSet);
        qFilter.and(BaseDataHisHelper.getHisCurrFilter());
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        String fields = "id,name,org.id";
        return helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
    }

    private DynamicObjectCollection getHasPermPayRollGroupData(Set<Long> payRollGroupIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_temporarydata", (String)"payrollgroup", (String)"47150e89000000ac");
        QFilter filter = new QFilter("id", "in", payRollGroupIdSet);
        if (dataFilter != null) {
            filter.and(dataFilter);
        }
        return helper.queryOriginalCollection("id", new QFilter[]{filter});
    }

    private void checkPayRollGroup(Map<String, List<Integer>> payRollGroupMap, Map<Integer, Map<Integer, Object>> passDataRowMap, List<Map<String, String>> errDataList, Long orgId) {
        if (payRollGroupMap.size() == 0) {
            return;
        }
        DynamicObjectCollection result = this.getPayRollGroupData(payRollGroupMap.keySet());
        Set<Long> idSet = result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        Map<String, DynamicObject> payRollMap = result.stream().collect(Collectors.toMap(obj -> obj.getString("name"), obj -> obj));
        String msg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"ImportTaskGuideImportService_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        String noPermMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"ImportTaskGuideImportService_8", (String)"swc-hsas-business", (Object[])new Object[0]);
        result = this.getHasPermPayRollGroupData(idSet);
        Set hasPermIdSet = result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        String orgNotEqualMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0e\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5339\u914d\u3002", (String)"ImportTaskGuideImportService_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        Long payRollGroupId = null;
        DynamicObject payRollObj = null;
        for (Map.Entry<String, List<Integer>> entry : payRollGroupMap.entrySet()) {
            payRollObj = payRollMap.get(entry.getKey());
            if (payRollObj == null) {
                this.addErrorData(entry.getValue(), errDataList, passDataRowMap, msg);
                continue;
            }
            payRollGroupId = payRollObj.getLong("id");
            if (!hasPermIdSet.contains(payRollGroupId)) {
                this.addErrorData(entry.getValue(), errDataList, passDataRowMap, noPermMsg);
                continue;
            }
            if (!SWCObjectUtils.equals((Object)orgId, (Object)payRollObj.getLong("org.id"))) {
                this.addErrorData(entry.getValue(), errDataList, passDataRowMap, orgNotEqualMsg);
                continue;
            }
            for (Integer lineIndex : entry.getValue()) {
                Map<Integer, Object> rowMap = passDataRowMap.get(lineIndex);
                if (rowMap == null) continue;
                rowMap.put(1, payRollGroupId);
            }
        }
    }

    private boolean checkItemValue(Map<Integer, List<Map<String, String>>> columnIndexMap, Map<Integer, Object> passRowMap, List<Map<String, String>> errDataList, int lineIndex, Map<Integer, String> rowMap) {
        String itemValue = null;
        String itemName = null;
        boolean isPass = true;
        String msg = ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u683c\u5f0f\u586b\u5199\u9519\u8bef\u3002", (String)"ImportTaskGuideImportService_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Map.Entry<Integer, List<Map<String, String>>> entry : columnIndexMap.entrySet()) {
            itemValue = rowMap.get(entry.getKey());
            if (SWCStringUtils.isEmpty((String)itemValue)) continue;
            for (Map<String, String> itemMap : entry.getValue()) {
                long dataTypeId = Long.parseLong(itemMap.get("datatypeid"));
                itemName = itemMap.get("name");
                if (1050L == dataTypeId) {
                    try {
                        itemValue = SWCDateTimeUtils.format((Date)SWCDateTimeUtils.parseDate((String)itemValue), (String)"yyyy-MM-dd");
                        passRowMap.put(entry.getKey(), itemValue);
                    }
                    catch (ParseException e) {
                        isPass = false;
                        errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, itemName)));
                    }
                    continue;
                }
                if (1010L == dataTypeId || 1020L == dataTypeId) {
                    try {
                        BigDecimal value = new BigDecimal(itemValue);
                        passRowMap.put(entry.getKey(), value.toPlainString());
                    }
                    catch (Exception e) {
                        isPass = false;
                        errDataList.add(this.assembleErrMap(lineIndex, false, MessageFormat.format(msg, itemName)));
                    }
                    continue;
                }
                passRowMap.put(entry.getKey(), itemValue);
            }
        }
        return isPass;
    }

    private Map<Integer, List<Map<String, String>>> getColumnIndexMap() {
        List<Map<String, String>> columnHeadList = ImportTaskUtils.getColumnHeadList(this.migrationtplId, this.importTaskId);
        HashMap<Integer, List<Map<String, String>>> columnIndexMap = new HashMap<Integer, List<Map<String, String>>>(columnHeadList.size());
        ArrayList<Map<String, String>> tempMapList = null;
        for (Map<String, String> obj : columnHeadList) {
            if ("0".equals(obj.get("itemType"))) continue;
            tempMapList = (ArrayList<Map<String, String>>)columnIndexMap.get(Integer.valueOf(obj.get("columnIndex")));
            if (tempMapList == null) {
                tempMapList = new ArrayList<Map<String, String>>(10);
                columnIndexMap.put(Integer.valueOf(obj.get("columnIndex")), tempMapList);
            }
            tempMapList.add(obj);
        }
        return columnIndexMap;
    }

    private void checkExcelTemplate(List<Map<Integer, String>> dataHeadList, Set<String> errDataList, Map<Integer, PresetItemEnum> tplFixItemMap) {
        Map<Integer, String> dataHeadMap = dataHeadList.get(0);
        String excelName = null;
        StringBuilder tplName = new StringBuilder();
        for (Map.Entry<Integer, PresetItemEnum> entry : tplFixItemMap.entrySet()) {
            excelName = dataHeadMap.get(entry.getKey());
            if (SWCStringUtils.isEmpty((String)excelName)) {
                errDataList.add(entry.getValue().getImportColumnName());
                continue;
            }
            tplName.setLength(0);
            if (entry.getValue().isRequire()) {
                tplName.append('*');
            }
            tplName.append(entry.getValue().getImportColumnName());
            if (excelName.equals(tplName.toString())) continue;
            errDataList.add(entry.getValue().getImportColumnName());
        }
    }

    private Map<Integer, PresetItemEnum> getTplFixItemMap(List<Map<String, String>> columnList) {
        HashMap<Integer, PresetItemEnum> map = new HashMap<Integer, PresetItemEnum>(16);
        Map presetItemEnumMap = PresetItemEnum.getPresetItemEnumMap();
        PresetItemEnum tempItemEnum = null;
        for (Map<String, String> temp : columnList) {
            if (!"0".equals(temp.get("itemType"))) continue;
            Long itemId = Long.valueOf(temp.get("id"));
            String columnIndexStr = temp.get("columnIndex");
            tempItemEnum = (PresetItemEnum)presetItemEnumMap.get(itemId);
            map.put(Integer.valueOf(columnIndexStr), tempItemEnum);
        }
        return map;
    }

    private Map<String, String> assembleErrMap(int dataIndex, boolean isAll, String msg) {
        HashMap<String, String> errMap = new HashMap<String, String>(4);
        errMap.put("errMsg", msg);
        errMap.put("isAll", isAll ? "1" : "0");
        errMap.put("dataIndex", String.valueOf(dataIndex));
        return errMap;
    }

    private void readExcelData(final List<Map<Integer, String>> dataHeadList, final List<Map<Integer, String>> dataRowList, final int headIndex, final int dataEndIndex) throws KDBizException {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(this.url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (row.getRowNum() == headIndex) {
                        dataHeadList.add(row.getData());
                    } else if (row.getRowNum() > headIndex && row.getRowNum() <= dataEndIndex && row.getData().size() > 0) {
                        dataRowList.add(row.getData());
                    }
                }
            });
        }
        catch (Throwable ex) {
            logger.error("parse excel error,", ex);
            throw new KDBizException(ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
    }
}

