/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.migrationtpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.common.enums.PresetItemEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class MigrationTemplateHelper {
    private static List<PresetItemEnum> commonAndAddPresetItemEnumList = new ArrayList<PresetItemEnum>(4);
    private static List<PresetItemEnum> hisDataPresetItemEnumList = new ArrayList<PresetItemEnum>(11);
    private static Map<Long, PresetItemEnum> commonAndAddPresetItemEnumMap = new HashMap<Long, PresetItemEnum>(4);
    private static Map<Long, PresetItemEnum> hisDataPresetItemEnumMap = new HashMap<Long, PresetItemEnum>(11);

    public static Map<String, Map<String, Object>> analyzeItemDatas(DynamicObjectCollection itemDatas, Map<Long, Map<String, Object>> existItemDataMap) {
        ArrayList<String> sLUnicodeList = new ArrayList<String>(itemDatas.size());
        ArrayList<String> sPUnicodeList = new ArrayList<String>(itemDatas.size());
        ArrayList<String> bSUnicodeList = new ArrayList<String>(itemDatas.size());
        ArrayList<String> fTUnicodeList = new ArrayList<String>(itemDatas.size());
        for (DynamicObject itemData : itemDatas) {
            String itemCategory = itemData.getString("itemcategory");
            String uniCode = itemData.getString("itemunicodeid");
            if (SWCStringUtils.equals((String)"SL", (String)itemCategory)) {
                sLUnicodeList.add(uniCode);
                continue;
            }
            if (SWCStringUtils.equals((String)"SP", (String)itemCategory)) {
                sPUnicodeList.add(uniCode);
                continue;
            }
            if (SWCStringUtils.equals((String)"BS", (String)itemCategory) || SWCStringUtils.equals((String)"ATTBS", (String)itemCategory)) {
                bSUnicodeList.add(uniCode);
                continue;
            }
            if (!SWCStringUtils.equals((String)"FT", (String)itemCategory)) continue;
            fTUnicodeList.add(uniCode);
        }
        HashMap<String, Map<String, Object>> itemParamMap = new HashMap<String, Map<String, Object>>(itemDatas.size());
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap("uniquecode", sLUnicodeList, "1", "hsbs_salaryitem", existItemDataMap, null));
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap("uniquecode", sPUnicodeList, "2", "hsbs_supportitem", existItemDataMap, null));
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap("uniquecode", bSUnicodeList, "3", "hsbs_bizitem", existItemDataMap, null));
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap("uniquecode", fTUnicodeList, "4", "hsbs_fetchitem", existItemDataMap, null));
        return itemParamMap;
    }

    public static Map<String, Map<String, Object>> getItemParamMap(String key, List<String> keyList, String itemType, String entityName, Map<Long, Map<String, Object>> existItemDataMap, Long orgId) {
        if (CollectionUtils.isEmpty(keyList)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        if (existItemDataMap == null) {
            existItemDataMap = new HashMap<Long, Map<String, Object>>(0);
        }
        HashMap<String, Map<String, Object>> itemParamMap = new HashMap<String, Map<String, Object>>(keyList.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        QFilter filter = new QFilter(key, "in", keyList);
        if (!SWCStringUtils.equals((String)entityName, (String)"hsbs_fetchitem")) {
            filter.and(new QFilter("status", "=", (Object)"C"));
        }
        filter.and(new QFilter("enable", "=", (Object)"1"));
        if (orgId != null) {
            QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId);
            filter.and(useOrgFilter);
        }
        DynamicObjectCollection items = helper.queryOriginalCollection("id,number,uniquecode,datatype.id,name", new QFilter[]{filter});
        for (DynamicObject item : items) {
            Long itemId = item.getLong("id");
            Long dataTypeId = item.getLong("datatype.id");
            HashMap<String, Object> itemParam = new HashMap<String, Object>(6);
            Map<String, Object> existItemData = existItemDataMap.get(itemId);
            itemParam.put("id", itemId);
            itemParam.put("dataTypeId", dataTypeId);
            itemParam.put("itemType", itemType);
            itemParam.put("itemname", item.getString("name"));
            if (existItemData != null) {
                itemParam.put("matchcolumn", existItemData.get("matchcolumn"));
                itemParam.put("comment", existItemData.get("comment"));
            }
            itemParamMap.put(item.getString(key), itemParam);
        }
        return itemParamMap;
    }

    public static Map<String, Map<String, Object>> analyzeMatchItem(DynamicObjectCollection entryDatas) {
        if (CollectionUtils.isEmpty((Collection)entryDatas)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        ArrayList<Long> SLItemIdList = new ArrayList<Long>(entryDatas.size());
        ArrayList<Long> SPItemIdList = new ArrayList<Long>(entryDatas.size());
        ArrayList<Long> BSItemIdList = new ArrayList<Long>(entryDatas.size());
        ArrayList<Long> FTItemIdList = new ArrayList<Long>(entryDatas.size());
        for (DynamicObject entry : entryDatas) {
            String itemType = entry.getString("itemtype");
            Long itemId = entry.getLong("itemid");
            if (SWCStringUtils.equals((String)"1", (String)itemType)) {
                SLItemIdList.add(itemId);
                continue;
            }
            if (SWCStringUtils.equals((String)"2", (String)itemType)) {
                SPItemIdList.add(itemId);
                continue;
            }
            if (SWCStringUtils.equals((String)"3", (String)itemType)) {
                BSItemIdList.add(itemId);
                continue;
            }
            if (!SWCStringUtils.equals((String)"4", (String)itemType)) continue;
            FTItemIdList.add(itemId);
        }
        HashMap<String, Map<String, Object>> itemParamMap = new HashMap<String, Map<String, Object>>(entryDatas.size());
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap(SLItemIdList, "1", "hsbs_salaryitem", null, false));
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap(SPItemIdList, "2", "hsbs_supportitem", null, false));
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap(BSItemIdList, "3", "hsbs_bizitem", null, false));
        itemParamMap.putAll(MigrationTemplateHelper.getItemParamMap(FTItemIdList, "4", "hsbs_fetchitem", null, false));
        return itemParamMap;
    }

    public static Map<String, Map<String, Object>> getItemParamMap(List<Long> itemIdList, String itemType, String entityName, Long orgId) {
        return MigrationTemplateHelper.getItemParamMap(itemIdList, itemType, entityName, orgId, true);
    }

    public static Map<String, Map<String, Object>> getItemParamMap(List<Long> itemIdList, String itemType, String entityName, Long orgId, boolean filterUnSelectedData) {
        if (CollectionUtils.isEmpty(itemIdList)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        QFilter filter = new QFilter("id", "in", itemIdList);
        String fields = "id,number,name,uniquecode";
        if (!SWCStringUtils.equals((String)entityName, (String)"hsbs_fetchitem")) {
            if (filterUnSelectedData) {
                filter.and(new QFilter("status", "=", (Object)"C"));
            }
            fields = fields + ",useorg.id";
        }
        if (filterUnSelectedData) {
            filter.and(new QFilter("enable", "=", (Object)"1"));
            if (orgId != null) {
                QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId);
                filter.and(useOrgFilter);
            }
        }
        DynamicObjectCollection items = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<String, Map<String, Object>> itemParamMap = new HashMap<String, Map<String, Object>>(items.size());
        for (DynamicObject item : items) {
            HashMap<String, Object> itemParam = new HashMap<String, Object>(4);
            itemParam.put("itemnumber", item.getString("number"));
            itemParam.put("itemname", item.getString("name"));
            itemParam.put("uniquecode", item.getString("uniquecode"));
            if (!SWCStringUtils.equals((String)entityName, (String)"hsbs_fetchitem")) {
                itemParam.put("org", item.getLong("useorg.id"));
            }
            itemParamMap.put(itemType + '-' + item.getLong("id"), itemParam);
        }
        return itemParamMap;
    }

    public static PresetItemEnum getPresetItemEnum(Long itemId) {
        PresetItemEnum presetItemEnum = commonAndAddPresetItemEnumMap.get(itemId);
        return presetItemEnum == null ? hisDataPresetItemEnumMap.get(itemId) : presetItemEnum;
    }

    public static List<PresetItemEnum> getPresetItemEnumList(String writeTaskType) {
        if (SWCStringUtils.equals((String)writeTaskType, (String)"0")) {
            return commonAndAddPresetItemEnumList;
        }
        if (SWCStringUtils.equals((String)writeTaskType, (String)"1")) {
            return hisDataPresetItemEnumList;
        }
        return null;
    }

    static {
        commonAndAddPresetItemEnumList.add(PresetItemEnum.CALTASK_COMMON_AND_ADD);
        commonAndAddPresetItemEnumList.add(PresetItemEnum.EMP_NUMBER_COMMON_AND_ADD);
        commonAndAddPresetItemEnumList.add(PresetItemEnum.NAME_COMMON_AND_ADD);
        commonAndAddPresetItemEnumList.add(PresetItemEnum.SALARYFILE_NUMBER_COMMON_AND_ADD);
        hisDataPresetItemEnumList.add(PresetItemEnum.CALTASK);
        hisDataPresetItemEnumList.add(PresetItemEnum.PAYROLLGROUP);
        hisDataPresetItemEnumList.add(PresetItemEnum.PAYROLLSCENE);
        hisDataPresetItemEnumList.add(PresetItemEnum.CALPERIOD_TYPE);
        hisDataPresetItemEnumList.add(PresetItemEnum.CALPERIOD);
        hisDataPresetItemEnumList.add(PresetItemEnum.PAYTIME);
        hisDataPresetItemEnumList.add(PresetItemEnum.EMP_NUMBER);
        hisDataPresetItemEnumList.add(PresetItemEnum.NAME);
        hisDataPresetItemEnumList.add(PresetItemEnum.SALARYFILE_NUMBER);
        hisDataPresetItemEnumList.add(PresetItemEnum.ADMINORG);
        hisDataPresetItemEnumList.add(PresetItemEnum.EMPGROUP);
        hisDataPresetItemEnumList.add(PresetItemEnum.WORKSTARTDATE);
        for (PresetItemEnum presetItemEnum : commonAndAddPresetItemEnumList) {
            commonAndAddPresetItemEnumMap.put(presetItemEnum.getItemId(), presetItemEnum);
        }
        for (PresetItemEnum presetItemEnum : hisDataPresetItemEnumList) {
            hisDataPresetItemEnumMap.put(presetItemEnum.getItemId(), presetItemEnum);
        }
    }
}

