/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.mq;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.swc.hsas.business.attintegrate.AttIntegrateManager;

public class AttIntegrateConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(AttIntegrateConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            log.info("message id:{}, body -> {}", (Object)messageId, (Object)JSON.toJSONString((Object)message));
            Map msg = (Map)message;
            String version = (String)msg.get("version");
            int fileQuantity = (Integer)msg.get("fileQuantity");
            Long creatorId = (Long)msg.get("creatorId");
            String dataType = msg.getOrDefault("dataType", "1");
            AttIntegrateManager attIntegrateManager = new AttIntegrateManager();
            attIntegrateManager.dispatchTask(version, fileQuantity, creatorId, dataType);
            acker.ack(messageId);
        }
        catch (Exception e) {
            log.info("message consume error,id:{}, body -> {}, error:{}", new Object[]{messageId, JSON.toJSONString((Object)message), e});
            acker.deny(messageId);
        }
    }
}

