/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.onhold.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldDetailHelper;
import kd.swc.hsas.business.onhold.service.OnHoldBillService;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsas.common.enums.PayDetailAbandonReasonEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class OnHoldBillHelper {
    private static final String PAGEID = "PageId";
    private static final String PKID = "PkId";
    private static final Log LOGGER = LogFactory.getLog(OnHoldBillHelper.class);

    public static Map<String, DynamicObject> queryPersonListByIds(Object[] personIdArr) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_employee");
        QFilter idFilter = new QFilter("id", "in", (Object)personIdArr);
        DynamicObject[] personArr = serviceHelper.query("id,empnumber,person.name", new QFilter[]{idFilter});
        LinkedHashMap<String, DynamicObject> personObjMap = new LinkedHashMap<String, DynamicObject>(personArr.length);
        for (DynamicObject dynamic : personArr) {
            personObjMap.put(dynamic.getString("id"), dynamic);
        }
        return personObjMap;
    }

    public static Map<String, List<DynamicObject>> queryPersonRefSalaryListAssembleData(Set<Long> personIdSet) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter personFilter = new QFilter("employee.id", "in", personIdSet);
        personFilter.and(new QFilter("enable", "=", (Object)"1"));
        personFilter.and(new QFilter("status", "=", (Object)"C"));
        personFilter.and(new QFilter("datastatus", "in", Arrays.asList("0", "1", "2")));
        personFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        OnHoldBillHelper.setAUthQFilter(personFilter, "hsas_salaryfile");
        String selectProperties = "id,org,adminorg,number,empgroup,bsed,bsled,employee,payrollgroup,empposinfo,person,firstbsed";
        DynamicObject[] salaryfileArr = serviceHelper.query(selectProperties, new QFilter[]{personFilter});
        HashMap<String, List<DynamicObject>> personIdSalaryListMap = new HashMap<String, List<DynamicObject>>(salaryfileArr.length);
        for (DynamicObject obj : salaryfileArr) {
            String personId = obj.getString("employee.id");
            ArrayList<DynamicObject> salaryfileList = (ArrayList<DynamicObject>)personIdSalaryListMap.get(personId);
            if (salaryfileList == null) {
                salaryfileList = new ArrayList<DynamicObject>(10);
                personIdSalaryListMap.put(personId, salaryfileList);
            }
            salaryfileList.add(obj);
        }
        return personIdSalaryListMap;
    }

    public static void setAUthQFilter(QFilter filter, String entityNumber) {
        List authQFilterList;
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_onholdbillquery", (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            filter.and("org", "in", (Object)permOrgs.getHasPermOrgs());
        }
        if ((authQFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)entityNumber, (String)"47150e89000000ac")) == null || authQFilterList.isEmpty()) {
            return;
        }
        authQFilterList.forEach(authQFilter -> filter.and(authQFilter));
    }

    public static DynamicObject[] queryCalPersonArrByIds(Object[] calPersonIdArr) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,employee,org,adminorg,salaryfile,caltask,calresultid";
        QFilter idFilter = new QFilter("id", "in", (Object)calPersonIdArr);
        return calPersonHelper.query(selectProperties, new QFilter[]{idFilter});
    }

    public static Map<String, DynamicObject> queryPayedCalPersonMap(List<Long> calPersonIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,paystatus";
        QFilter idFilter = new QFilter("id", "in", calPersonIdList);
        QFilter payStatusFilter = new QFilter("paystatus", "in", (Object)new String[]{PayStateEnum.PAYING.getCode(), PayStateEnum.PAID.getCode()});
        DynamicObject[] calPersonArr = calPersonHelper.query(selectProperties, new QFilter[]{idFilter, payStatusFilter});
        HashMap<String, DynamicObject> payedCalPersonMap = new HashMap<String, DynamicObject>(calPersonArr.length);
        for (DynamicObject obj : calPersonArr) {
            String calPersonId = obj.getString("id");
            payedCalPersonMap.put(calPersonId, obj);
        }
        return payedCalPersonMap;
    }

    public static Set<String> validateSalaryFilePayDetail(List<Long> calTableIds) {
        DynamicObject[] dynamicObjects;
        HashSet<String> calIds = new HashSet<String>(16);
        if (calTableIds.isEmpty()) {
            return calIds;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", calTableIds);
        filter.and(new QFilter("bankofferstatus", "in", Arrays.asList(BankOfferEnum.EXPORTED.getCode(), BankOfferEnum.EXPORTING.getCode())));
        for (DynamicObject dynamicObject : dynamicObjects = helper.query("id,bankofferstatus,caltableid", new QFilter[]{filter})) {
            String id = dynamicObject.getString("caltableid");
            calIds.add(id);
        }
        return calIds;
    }

    public static Map<String, String> queryOnHoldIdRefIdByIdList(List<Long> onHoldList) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObject[] onHoldArr = onHoldHelper.query(onHoldList.toArray());
        HashMap<String, String> onHoldIdRefIdMap = new HashMap<String, String>(onHoldArr.length);
        for (DynamicObject onHold : onHoldArr) {
            String onHoldId = onHold.getString("id");
            onHoldIdRefIdMap.put(onHoldId, onHoldId);
        }
        return onHoldIdRefIdMap;
    }

    public static Map<String, DynamicObject> queryOnHoldIdRefObjByIdList(List<Long> onHoldToUpdateIdList) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObject[] onHoldArr = onHoldHelper.query(onHoldToUpdateIdList.toArray());
        HashMap<String, DynamicObject> onHoldIdRefObjMap = new HashMap<String, DynamicObject>(onHoldArr.length);
        for (DynamicObject onHold : onHoldArr) {
            onHoldIdRefObjMap.put(onHold.getString("id"), onHold);
        }
        return onHoldIdRefObjMap;
    }

    public static Map<String, DynamicObject> queryOnHoldedCalPersonMap(List<Long> caltableIdList) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter idFilter = new QFilter("caltableid", "in", caltableIdList);
        String selectProperties = "id,status,caltableid,startdate,enddate";
        DynamicObject[] onHoldArr = onHoldHelper.query(selectProperties, new QFilter[]{idFilter});
        HashMap<String, DynamicObject> onHoldCalPersonMap = new HashMap<String, DynamicObject>(onHoldArr.length);
        for (DynamicObject obj : onHoldArr) {
            String calPersonId = obj.getString("caltableid");
            onHoldCalPersonMap.put(calPersonId, obj);
        }
        return onHoldCalPersonMap;
    }

    public static Map<String, List<DynamicObject>> queryCalOnHoldedSalaryMap(List<Long> salaryIdList) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter idFilter = new QFilter("salaryfile.id", "in", salaryIdList);
        QFilter calPersonFilter = new QFilter("caltableid", "=", (Object)0);
        String selectProperties = "id,status,salaryfile,startdate,enddate";
        DynamicObject[] onHoldArr = onHoldHelper.query(selectProperties, new QFilter[]{idFilter, calPersonFilter});
        HashMap<String, List<DynamicObject>> onHoldSalaryfileMap = new HashMap<String, List<DynamicObject>>(onHoldArr.length);
        for (DynamicObject obj : onHoldArr) {
            String salaryFileId = obj.getString("salaryfile.id");
            ArrayList<DynamicObject> salaryDynamicObjList = (ArrayList<DynamicObject>)onHoldSalaryfileMap.get(salaryFileId);
            if (salaryDynamicObjList == null) {
                salaryDynamicObjList = new ArrayList<DynamicObject>(10);
                onHoldSalaryfileMap.put(salaryFileId, salaryDynamicObjList);
            }
            salaryDynamicObjList.add(obj);
        }
        return onHoldSalaryfileMap;
    }

    public static Map<String, List<DynamicObject>> queryOnHoldedSalaryMap(List<Long> salaryIdList) {
        SWCDataServiceHelper caltableHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter idFilter = new QFilter("salaryfile.id", "in", salaryIdList);
        QFilter calTaskFilter = new QFilter("caltask.id", "=", (Object)0);
        String selectProperties = "id,status,salaryfile,startdate,enddate,caltableid,isallowcal";
        DynamicObject[] onholdArr = caltableHelper.query(selectProperties, new QFilter[]{idFilter, calTaskFilter});
        HashMap<String, List<DynamicObject>> onHoldSalaryfileMap = new HashMap<String, List<DynamicObject>>(onholdArr.length);
        for (DynamicObject obj : onholdArr) {
            String salaryfileId = obj.getString("salaryfile.id");
            ArrayList<DynamicObject> salaryDynamicObjList = (ArrayList<DynamicObject>)onHoldSalaryfileMap.get(salaryfileId);
            if (salaryDynamicObjList == null) {
                salaryDynamicObjList = new ArrayList<DynamicObject>(10);
                onHoldSalaryfileMap.put(salaryfileId, salaryDynamicObjList);
            }
            salaryDynamicObjList.add(obj);
        }
        return onHoldSalaryfileMap;
    }

    public static Map<String, List<DynamicObject>> getSalaryFileIdRefCalPersonListMap(List<Long> salaryFileIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter idFilter = new QFilter("salaryfile.id", "in", salaryFileIdList);
        QFilter payStatusFilter = new QFilter("paystatus", "not in", (Object)new String[]{PayStateEnum.PAYING.getCode(), PayStateEnum.PAID.getCode()});
        DynamicObject[] calPersonArr = calPersonHelper.query("id,salaryfile,caltask,calresultid", new QFilter[]{idFilter, payStatusFilter});
        HashMap<String, List<DynamicObject>> salaryFileIdRefCalPersonListMap = new HashMap<String, List<DynamicObject>>(calPersonArr.length);
        for (DynamicObject calPerson : calPersonArr) {
            String salaryFileId = calPerson.getString("salaryfile.id");
            ArrayList<DynamicObject> caltableList = (ArrayList<DynamicObject>)salaryFileIdRefCalPersonListMap.get(salaryFileId);
            if (caltableList == null) {
                caltableList = new ArrayList<DynamicObject>(10);
                salaryFileIdRefCalPersonListMap.put(salaryFileId, caltableList);
            }
            caltableList.add(calPerson);
        }
        return salaryFileIdRefCalPersonListMap;
    }

    public static Map<String, List<DynamicObject>> queryCalPersonListBySalaryIds(List<Long> salaryFileIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter idFilter = new QFilter("salaryfile.id", "in", salaryFileIdList);
        QFilter payStatusFilter = new QFilter("paystatus", "not in", (Object)new String[]{PayStateEnum.PAYING.getCode(), PayStateEnum.PAID.getCode()});
        QFilter onholdFilter = new QFilter("onholdstatus", "not in", (Object)new String[]{String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())});
        String selectProperties = "salaryfile,caltask";
        DynamicObject[] calPersonArr = calPersonHelper.query(selectProperties, new QFilter[]{idFilter, payStatusFilter, onholdFilter});
        HashMap<String, List<DynamicObject>> salaryIdRefCalPersonObjListMap = new HashMap<String, List<DynamicObject>>(calPersonArr.length);
        if (calPersonArr.length <= 0) {
            return salaryIdRefCalPersonObjListMap;
        }
        List<Long> calPersonIds = Arrays.stream(calPersonArr).map(object -> object.getLong("id")).collect(Collectors.toList());
        Set<String> calPersonSet = OnHoldBillHelper.validateSalaryFilePayDetail(calPersonIds);
        for (DynamicObject calPerson : calPersonArr) {
            String salaryId = calPerson.getString("salaryfile.id");
            String calTableId = calPerson.getString("id");
            ArrayList<DynamicObject> calPersonList = (ArrayList<DynamicObject>)salaryIdRefCalPersonObjListMap.get(salaryId);
            if (calPersonSet.contains(calTableId)) continue;
            if (calPersonList == null) {
                calPersonList = new ArrayList<DynamicObject>(10);
                salaryIdRefCalPersonObjListMap.put(salaryId, calPersonList);
            }
            calPersonList.add(calPerson);
        }
        return salaryIdRefCalPersonObjListMap;
    }

    public static DynamicObject[] querySalaryFileArrByIds(Object[] salaryFileIdArr) {
        SWCDataServiceHelper salaryHelper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectProperties = "id,org,adminorg,number,bsed,bsled,person.id,payrollgroup,empposinfo,adminorg,employee,firstbsed";
        QFilter idFilter = new QFilter("id", "in", (Object)salaryFileIdArr);
        return salaryHelper.query(selectProperties, new QFilter[]{idFilter});
    }

    public static DynamicObject queryOnHoldByPkId(Long onHoldId) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        return onHoldHelper.queryOne((Object)onHoldId);
    }

    public static Map<String, String> queryCalRuleIdRefNetSalaryItemInfoMap(Collection<Long> calRuleIds) {
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        String selectProperties = "id,netsalary";
        QFilter idFilter = new QFilter("id", "in", calRuleIds);
        DynamicObject[] calRuleArr = calRuleHisHelper.query(selectProperties, new QFilter[]{idFilter});
        HashMap<String, String> calRuleIdRefNetSalaryItemInfoMap = new HashMap<String, String>(calRuleArr.length);
        for (DynamicObject calRule : calRuleArr) {
            String calRuleId = calRule.getString("id");
            String netSalaryId = calRule.getString("netsalary.id");
            String netSalaryName = calRule.getString("netsalary.name");
            if (!SWCStringUtils.isNotEmpty((String)netSalaryId)) continue;
            calRuleIdRefNetSalaryItemInfoMap.put(calRuleId, String.join((CharSequence)"||", netSalaryId, netSalaryName));
        }
        return calRuleIdRefNetSalaryItemInfoMap;
    }

    public static Map<String, DynamicObject> querySalaryFileIdRefSalaryFileObjMap(List<Long> salaryFileIdList) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter idFilter = new QFilter("id", "in", salaryFileIdList);
        DynamicObject[] salaryFileObjArr = salaryFileHelper.query("id,empposinfo", new QFilter[]{idFilter});
        HashMap<String, DynamicObject> salaryFileIdRefSalaryFileObjMap = new HashMap<String, DynamicObject>(salaryFileObjArr.length);
        for (DynamicObject salaryFile : salaryFileObjArr) {
            salaryFileIdRefSalaryFileObjMap.put(salaryFile.getString("id"), salaryFile);
        }
        return salaryFileIdRefSalaryFileObjMap;
    }

    public static Map<Long, DynamicObject> queryPayRollGroupIdRefPayRollGroupObjMap(Collection<Long> payRollGroupIdList) {
        SWCDataServiceHelper payRollGroupHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter idFilter = new QFilter("id", "in", payRollGroupIdList);
        DynamicObject[] payRollGroupObjArr = payRollGroupHelper.query("id,currency", new QFilter[]{idFilter});
        HashMap<Long, DynamicObject> PayRollGroupIdRefPayRollGroupObjMap = new HashMap<Long, DynamicObject>(payRollGroupObjArr.length);
        for (DynamicObject payRollGroup : payRollGroupObjArr) {
            PayRollGroupIdRefPayRollGroupObjMap.put(payRollGroup.getLong("id"), payRollGroup);
        }
        return PayRollGroupIdRefPayRollGroupObjMap;
    }

    public static Map<String, DynamicObject> queryCalTableIdRefCalTableObjMap(List<Long> calTableIdList) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_caltable");
        QFilter idFilter = new QFilter("id", "in", calTableIdList);
        String selectProp = "id,salaryitem,calamountvalue";
        DynamicObject[] calTableObjArr = calTableHelper.query(selectProp, new QFilter[]{idFilter});
        HashMap<String, DynamicObject> calTableIdRefCalTableObjMap = new HashMap<String, DynamicObject>(calTableObjArr.length);
        for (DynamicObject calTable : calTableObjArr) {
            calTableIdRefCalTableObjMap.put(calTable.getString("id"), calTable);
        }
        return calTableIdRefCalTableObjMap;
    }

    private static Map<String, List<DynamicObject>> queryPersonIdRefCalPersonListAssembleData(Set<Long> personIdSet, List<Long> calPersonIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProp = "id,employee,org,adminorg,salaryfile,caltask,calresultid";
        QFilter filter = new QFilter("employee.id", "in", personIdSet);
        filter.and(new QFilter("paystatus", "not in", (Object)new String[]{PayStateEnum.PAYING.getCode(), PayStateEnum.PAID.getCode()}));
        OnHoldBillHelper.setAUthQFilter(filter, "hsas_calperson");
        DynamicObject[] calPersonArr = calPersonHelper.query(selectProp, new QFilter[]{filter});
        HashMap<String, List<DynamicObject>> personIdSalaryListMap = new HashMap<String, List<DynamicObject>>(calPersonArr.length);
        for (DynamicObject calPersonObj : calPersonArr) {
            Long calPersonId = calPersonObj.getLong("id");
            if (calPersonIdList.indexOf(calPersonId) >= 0) continue;
            String personId = calPersonObj.getString("employee.id");
            ArrayList<DynamicObject> calPersonList = (ArrayList<DynamicObject>)personIdSalaryListMap.get(personId);
            if (calPersonList == null) {
                calPersonList = new ArrayList<DynamicObject>(10);
                personIdSalaryListMap.put(personId, calPersonList);
            }
            calPersonList.add(calPersonObj);
        }
        return personIdSalaryListMap;
    }

    public static void saveCaltableCache(Set<Long> personIdSet, JSONObject onholdInfoAppcheJSONObject) {
        List<Long> calPersonIdList = OnHoldBillHelper.queryOnHoldCalPersonIdListByPersonIdArr(personIdSet);
        Map<String, List<DynamicObject>> personRefCalPersonListMap = OnHoldBillHelper.queryPersonIdRefCalPersonListAssembleData(personIdSet, calPersonIdList);
        for (Map.Entry<String, List<DynamicObject>> entry : personRefCalPersonListMap.entrySet()) {
            String personId = entry.getKey();
            List<DynamicObject> calPersonList = entry.getValue();
            OnHoldBillHelper.saveCalPersonData(personId, onholdInfoAppcheJSONObject, calPersonList);
        }
    }

    public static void saveCalPersonData(String personId, JSONObject onholdInfoCacheJSONObject, List<DynamicObject> calPersonList) {
        JSONArray calPersonIdListCacheInfo;
        JSONArray calPersonCacheInfo;
        JSONObject personCacheInfo = onholdInfoCacheJSONObject.getJSONObject(personId);
        if (personCacheInfo == null) {
            personCacheInfo = new JSONObject();
        }
        if ((calPersonCacheInfo = personCacheInfo.getJSONArray("caltableList")) == null) {
            calPersonCacheInfo = new JSONArray();
        }
        if ((calPersonIdListCacheInfo = personCacheInfo.getJSONArray("caltableIdList")) == null) {
            calPersonIdListCacheInfo = new JSONArray();
        }
        int calPersonSize = calPersonList.size();
        HashMap<Long, Long> caPersonIdRefCalRuleVidMap = new HashMap<Long, Long>(calPersonSize);
        HashMap<Long, Long> calPersonIdRefPayRollGroupVidMap = new HashMap<Long, Long>(calPersonSize);
        ArrayList<Long> salaryFileIdList = new ArrayList<Long>(calPersonSize);
        ArrayList<Long> calTableIdList = new ArrayList<Long>(calPersonSize);
        for (DynamicObject calPersonObj : calPersonList) {
            long calRuleVid = calPersonObj.getLong("caltask.calrulev.id");
            salaryFileIdList.add(calPersonObj.getLong("salaryfile.id"));
            Long calTableId = calPersonObj.getLong("calresultid");
            Long payRollGroupVid = calPersonObj.getLong("caltask.payrollgroupv.id");
            Long calPersonId = calPersonObj.getLong("id");
            calPersonIdRefPayRollGroupVidMap.put(calPersonId, payRollGroupVid);
            caPersonIdRefCalRuleVidMap.put(calPersonId, calRuleVid);
            if (calTableId.intValue() == 0) continue;
            calTableIdList.add(calTableId);
        }
        Map<String, String> calRuleIdRefNetSalaryItemInfoMap = OnHoldBillHelper.queryCalRuleIdRefNetSalaryItemInfoMap(caPersonIdRefCalRuleVidMap.values());
        Map<String, DynamicObject> queryCalPersonIdRefSalaryFileObjMap = OnHoldBillHelper.querySalaryFileIdRefSalaryFileObjMap(salaryFileIdList);
        Map<Long, DynamicObject> payRollGroupIdRefPayRollGroupObjMap = OnHoldBillHelper.queryPayRollGroupIdRefPayRollGroupObjMap(calPersonIdRefPayRollGroupVidMap.values());
        Map<String, DynamicObject> calTableIdRefCalTableObjMap = OnHoldBillHelper.queryCalTableIdRefCalTableObjMap(calTableIdList);
        String personName = "";
        String personNo = "";
        int index = calPersonCacheInfo.size();
        for (DynamicObject calPersonObj : calPersonList) {
            String netSalaryItemId;
            ++index;
            JSONObject personInfoCacheJSONObject = new JSONObject();
            String calPersonId = calPersonObj.getString("id");
            Long calPersonLong = Long.valueOf(calPersonId);
            personInfoCacheJSONObject.put("caltable", (Object)calPersonId);
            calPersonIdListCacheInfo.add((Object)calPersonLong);
            personInfoCacheJSONObject.put("person", (Object)personId);
            String calTableId = calPersonObj.getString("calresultid");
            Long calRuleVid = (Long)caPersonIdRefCalRuleVidMap.get(Long.valueOf(calPersonId));
            if (calRuleVid != null && SWCStringUtils.isNotEmpty((String)(netSalaryItemId = calRuleIdRefNetSalaryItemInfoMap.get(calRuleVid.toString())))) {
                personInfoCacheJSONObject.put("payoutitem", (Object)netSalaryItemId.substring(0, netSalaryItemId.indexOf("||")));
            }
            DynamicObject calTable = calTableIdRefCalTableObjMap.get(calTableId);
            Long payRollGroupId = (Long)calPersonIdRefPayRollGroupVidMap.get(calPersonLong);
            DynamicObject payRollGroup = payRollGroupIdRefPayRollGroupObjMap.get(payRollGroupId);
            Map<String, String> actualSalaryInfoMap = OnHoldBillHelper.getNetSalaryAmountInfo(calRuleVid, calRuleIdRefNetSalaryItemInfoMap, calTable, payRollGroup);
            personInfoCacheJSONObject.put("caltablecalamount", (Object)actualSalaryInfoMap.get("calAmount"));
            personInfoCacheJSONObject.put("caltableoriamount", (Object)actualSalaryInfoMap.get("oriAmount"));
            personInfoCacheJSONObject.put("caltablecalcurrency", (Object)actualSalaryInfoMap.get("calcurrency"));
            personInfoCacheJSONObject.put("caltableoricurrency", (Object)actualSalaryInfoMap.get("oriCurrency"));
            personInfoCacheJSONObject.put("caltablecalcurrencySign", (Object)actualSalaryInfoMap.get("calcurrencySign"));
            personInfoCacheJSONObject.put("caltableoriCurrencySign", (Object)actualSalaryInfoMap.get("oriCurrencySign"));
            personInfoCacheJSONObject.put("org", (Object)calPersonObj.getString("org.id"));
            personInfoCacheJSONObject.put("caltableorgname", (Object)calPersonObj.getString("org.name"));
            personInfoCacheJSONObject.put("adminorg", (Object)calPersonObj.getString("adminorg.id"));
            personInfoCacheJSONObject.put("payrollgroup", (Object)calPersonObj.getString("caltask.payrollgroup.id"));
            String salaryFileId = calPersonObj.getString("salaryfile.id");
            DynamicObject salaryFile = queryCalPersonIdRefSalaryFileObjMap.get(salaryFileId);
            if (salaryFile != null) {
                personInfoCacheJSONObject.put("company", (Object)salaryFile.getString("empposinfo.company.id"));
                personInfoCacheJSONObject.put("position", (Object)salaryFile.getString("empposinfo.position.id"));
                personInfoCacheJSONObject.put("department", (Object)salaryFile.getString("empposinfo.adminorg.id"));
            }
            personInfoCacheJSONObject.put("salaryfile", (Object)salaryFileId);
            personInfoCacheJSONObject.put("caltableonholdstatus", (Object)Boolean.TRUE);
            personInfoCacheJSONObject.put("caltableonholdreason", (Object)"0");
            personInfoCacheJSONObject.put("caltableStartdate", (Object)calPersonObj.getDate("caltask.STARTDATE"));
            personInfoCacheJSONObject.put("caltableEnddate", (Object)calPersonObj.getDate("caltask.ENDDATE"));
            personInfoCacheJSONObject.put("caltablePayrollDate", (Object)calPersonObj.getDate("caltask.payrolldate"));
            personInfoCacheJSONObject.put("caltableCalCount", (Object)calPersonObj.getInt("caltask.calcount"));
            personInfoCacheJSONObject.put("caltask", (Object)calPersonObj.getString("caltask.id"));
            personInfoCacheJSONObject.put("caltableEmpgroup", (Object)calPersonObj.getString("salaryfile.empgroup.id"));
            personInfoCacheJSONObject.put("caltableSalaryfileNumber", (Object)calPersonObj.getString("salaryfile.number"));
            personInfoCacheJSONObject.put("caltableCaltaskNumber", (Object)calPersonObj.getString("caltask.number"));
            personName = calPersonObj.getString("employee.person.name");
            personNo = calPersonObj.getString("employee.person.number");
            personInfoCacheJSONObject.put("caltablePersonName", (Object)personName);
            personInfoCacheJSONObject.put("caltablePersonNo", (Object)personNo);
            personInfoCacheJSONObject.put("caltableIsPass", (Object)Boolean.FALSE);
            personInfoCacheJSONObject.put("caltableStatus", (Object)"00");
            personInfoCacheJSONObject.put("caltableIndex", (Object)index);
            calPersonCacheInfo.add((Object)personInfoCacheJSONObject);
        }
        personCacheInfo.put("caltableList", (Object)calPersonCacheInfo);
        personCacheInfo.put("caltableIdList", (Object)calPersonIdListCacheInfo);
        personCacheInfo.put("personNo", (Object)personNo);
        personCacheInfo.put("personName", (Object)personName);
        onholdInfoCacheJSONObject.put(personId, (Object)personCacheInfo);
    }

    public static Map<String, String> getNetSalaryAmountInfo(Long calRuleVid, Map<String, String> calRuleNetSalaryIdMap, DynamicObject calTable, DynamicObject payRollGroup) {
        HashMap<String, String> actualSalaryInfoMap = new HashMap<String, String>(16);
        if (calTable == null || calRuleVid == null || calRuleNetSalaryIdMap.isEmpty() || payRollGroup == null) {
            LOGGER.error("calTable is {}, calRuleNetSalaryIdMap is {}, payRollGroupV is {}", new Object[]{calTable, calRuleNetSalaryIdMap, payRollGroup});
            return actualSalaryInfoMap;
        }
        DynamicObjectCollection calTableEntry = calTable.getDynamicObjectCollection("hsas_caltableentry");
        String netSalaryId = calRuleNetSalaryIdMap.get(calRuleVid.toString());
        if (SWCStringUtils.isEmpty((String)netSalaryId)) {
            LOGGER.error("netSalaryId is empty");
            return actualSalaryInfoMap;
        }
        DynamicObject currency = payRollGroup.getDynamicObject("currency");
        for (DynamicObject calEnt : calTableEntry) {
            String calSalaryItemId = calEnt.getString("salaryitem.id");
            if (StringUtil.isEmpty((String)calSalaryItemId) || !netSalaryId.startsWith(calSalaryItemId)) continue;
            BigDecimal calAmount = calEnt.getBigDecimal("calamountvalue");
            LOGGER.info("calAmount:{}", (Object)calAmount);
            if (calAmount == null) continue;
            actualSalaryInfoMap.put("calAmount", calAmount.toPlainString());
            actualSalaryInfoMap.put("calcurrency", currency.getString("id"));
            actualSalaryInfoMap.put("calcurrencySign", currency.getString("sign"));
            return actualSalaryInfoMap;
        }
        return actualSalaryInfoMap;
    }

    public static void saveSalaryCache(JSONObject onholdInfoAppcheJSONObject, Map<String, List<DynamicObject>> personRefSalaryListAssembleDataMap) {
        for (Map.Entry<String, List<DynamicObject>> personRefSalaryListAssembleData : personRefSalaryListAssembleDataMap.entrySet()) {
            String personId = personRefSalaryListAssembleData.getKey();
            List<DynamicObject> salaryList = personRefSalaryListAssembleData.getValue();
            OnHoldBillHelper.saveSalaryDataToCache(onholdInfoAppcheJSONObject, personId, salaryList);
        }
    }

    public static void saveSalaryDataToCache(JSONObject onholdInfoAppcheJSONObject, String personId, List<DynamicObject> salaryList) {
        JSONObject personJsonInfo = onholdInfoAppcheJSONObject.getJSONObject(personId);
        if (personJsonInfo == null) {
            personJsonInfo = new JSONObject();
        }
        HashSet<String> cacheSalaryFileNumberSet = new HashSet<String>(16);
        JSONArray personInfoAppcheArr = personJsonInfo.getJSONArray("salaryfileList");
        if (personInfoAppcheArr == null) {
            personInfoAppcheArr = new JSONArray();
        } else {
            for (int i = 0; i < personInfoAppcheArr.size(); ++i) {
                JSONObject salaryFileObj = personInfoAppcheArr.getJSONObject(i);
                if (salaryFileObj == null || salaryFileObj.size() == 0) continue;
                String salaryfileNumber = salaryFileObj.getString("salaryNumber");
                cacheSalaryFileNumberSet.add(salaryfileNumber);
            }
        }
        JSONArray salaryfileIdAppcheArr = personJsonInfo.getJSONArray("salaryfileIdList");
        if (salaryfileIdAppcheArr == null) {
            salaryfileIdAppcheArr = new JSONArray();
        }
        JSONObject personInfoAppcheJSONObject = null;
        Map<String, Long> payrollgroupIdRefVidMap = OnHoldBillHelper.queryPayrollGroupVidById(salaryList);
        int index = personInfoAppcheArr.size();
        String personName = "";
        String personNo = "";
        for (DynamicObject salafileObj : salaryList) {
            ++index;
            personInfoAppcheJSONObject = new JSONObject();
            String salaryfileId = salafileObj.getString("id");
            String salaryFileNumber = salafileObj.getString("number");
            if (cacheSalaryFileNumberSet.contains(salaryFileNumber)) continue;
            salaryfileIdAppcheArr.add((Object)Long.valueOf(salaryfileId));
            personInfoAppcheJSONObject.put("salaryfile", (Object)salaryfileId);
            personInfoAppcheJSONObject.put("person", (Object)personId);
            personInfoAppcheJSONObject.put("org", (Object)salafileObj.getString("org.id"));
            personInfoAppcheJSONObject.put("adminorg", (Object)salafileObj.getString("adminorg.id"));
            personInfoAppcheJSONObject.put("payrollgroup", (Object)payrollgroupIdRefVidMap.get(salafileObj.getString("payrollgroup.id")));
            personInfoAppcheJSONObject.put("company", (Object)salafileObj.getString("empposinfo.company.id"));
            personInfoAppcheJSONObject.put("position", (Object)salafileObj.getString("empposinfo.position.id"));
            personInfoAppcheJSONObject.put("department", (Object)salafileObj.getString("empposinfo.adminorg.id"));
            personInfoAppcheJSONObject.put("salaryonholdstatus", (Object)Boolean.FALSE);
            personInfoAppcheJSONObject.put("salaryNumber", (Object)salafileObj.getString("number"));
            personInfoAppcheJSONObject.put("salaryFirstBred", (Object)SWCDateTimeUtils.format((Date)salafileObj.getDate("firstbsed"), (String)"yyyy-MM-dd"));
            personInfoAppcheJSONObject.put("salaryBred", (Object)SWCDateTimeUtils.format((Date)salafileObj.getDate("bsed"), (String)"yyyy-MM-dd"));
            personInfoAppcheJSONObject.put("salaryBrled", (Object)SWCDateTimeUtils.format((Date)salafileObj.getDate("bsled"), (String)"yyyy-MM-dd"));
            personName = salafileObj.getString("employee.person.name");
            personNo = salafileObj.getString("employee.empnumber");
            personInfoAppcheJSONObject.put("salaryPersonName", (Object)personName);
            personInfoAppcheJSONObject.put("salaryPersonNo", (Object)personNo);
            personInfoAppcheJSONObject.put("salaryonholdreason", (Object)"0");
            personInfoAppcheJSONObject.put("salaryIsPass", (Object)Boolean.FALSE);
            personInfoAppcheJSONObject.put("salaryIndex", (Object)index);
            personInfoAppcheJSONObject.put("salaryfileStatus", (Object)"00");
            personInfoAppcheArr.add((Object)personInfoAppcheJSONObject);
        }
        personJsonInfo.put("salaryfileList", (Object)personInfoAppcheArr);
        personJsonInfo.put("salaryfileIdList", (Object)salaryfileIdAppcheArr);
        personJsonInfo.put("personNo", (Object)personNo);
        personJsonInfo.put("personName", (Object)personName);
        onholdInfoAppcheJSONObject.put(personId, (Object)personJsonInfo);
    }

    public static Map<String, Long> queryPayrollGroupVidById(List<DynamicObject> salaryList) {
        ArrayList<Long> payrollGroupIdList = new ArrayList<Long>(salaryList.size());
        for (DynamicObject obj : salaryList) {
            payrollGroupIdList.add(obj.getLong("payrollgroup.id"));
        }
        SWCDataServiceHelper payRollGrpHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter idFilter = new QFilter("id", "in", payrollGroupIdList);
        String selectProperties = "id,sourcevid";
        DynamicObject[] payRollGroupArr = payRollGrpHelper.query(selectProperties, new QFilter[]{idFilter});
        HashMap<String, Long> payRollGroupIdRefVidMap = new HashMap<String, Long>(payRollGroupArr.length);
        for (DynamicObject payRollGroup : payRollGroupArr) {
            payRollGroupIdRefVidMap.put(payRollGroup.getString("id"), payRollGroup.getLong("sourcevid"));
        }
        return payRollGroupIdRefVidMap;
    }

    private static List<Long> queryOnHoldCalPersonIdListByPersonIdArr(Set<Long> personIdSet) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter idFilter = new QFilter("person.id", "in", personIdSet);
        QFilter statusFilter = new QFilter("status", "!=", (Object)(OnHoldStatusEnum.STATUS_RELEASE.getCode() + ""));
        String selectProperties = "id,status,caltableid";
        DynamicObject[] onHoldObjArr = onHoldHelper.query(selectProperties, new QFilter[]{idFilter, statusFilter});
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(onHoldObjArr.length);
        for (DynamicObject onHoldObj : onHoldObjArr) {
            long calPersonId = onHoldObj.getLong("caltableid");
            if (calPersonId == 0L) continue;
            calPersonIdList.add(calPersonId);
        }
        return calPersonIdList;
    }

    public static List<Long> queryOnHoldCalPersonIdListByPersonId(Long personId) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter idFilter = new QFilter("person.id", "=", (Object)personId);
        String selectProperties = "id,status,caltableid";
        DynamicObject[] onHoldObjArr = onHoldHelper.query(selectProperties, new QFilter[]{idFilter});
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(onHoldObjArr.length);
        for (DynamicObject onHoldObj : onHoldObjArr) {
            Long calPersonId = onHoldObj.getLong("caltableid");
            if (calPersonId == 0L) continue;
            calPersonIdList.add(calPersonId);
        }
        return calPersonIdList;
    }

    public static DynamicObject queryOnHoldById(Object onHoldId) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObject onHold = onHoldHelper.queryOne(onHoldId);
        return onHold;
    }

    public static DynamicObject[] querySalaryfileArrByPersonId(Long personId) {
        SWCDataServiceHelper caltableHelper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectProperties = "id,org,number,bsed,bsled";
        QFilter idFilter = new QFilter("person.id", "=", (Object)personId);
        return caltableHelper.query(selectProperties, new QFilter[]{idFilter});
    }

    public static void insertOnHoldFile(Date currDate, Long currUserId, DynamicObject[] onHoldObjects) {
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_onholdfile");
        DynamicObject[] onHoldFileDatas = new DynamicObject[onHoldObjects.length];
        for (int i = 0; i < onHoldObjects.length; ++i) {
            DynamicObject onHoldObj = onHoldObjects[i];
            DynamicObject dynamicObject = onHoldFileHelper.generateEmptyDynamicObject();
            dynamicObject.set("status", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            dynamicObject.set("description", (Object)onHoldObj.getString("remark"));
            dynamicObject.set("startdate", (Object)onHoldObj.getDate("startdate"));
            dynamicObject.set("salaryfile", onHoldObj.get("salaryfile") instanceof DynamicObject ? Long.valueOf(onHoldObj.getLong("salaryfile.id")) : onHoldObj.get("salaryfile"));
            dynamicObject.set("cause", onHoldObj.get("cause") instanceof DynamicObject ? Long.valueOf(onHoldObj.getLong("cause.id")) : onHoldObj.get("cause"));
            Date releaseDate = onHoldObj.getDate("releasedate");
            dynamicObject.set("releasedate", (Object)releaseDate);
            if (releaseDate != null) {
                Date currentDate = new Date();
                Date formateDate = null;
                try {
                    formateDate = SWCDateTimeUtils.formatDateToDate((Date)currentDate, (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    LOGGER.error("formate date error:{}", (Object)e.getMessage());
                }
                if (formateDate != null && releaseDate.getTime() <= currentDate.getTime()) {
                    dynamicObject.set("status", (Object)OnHoldStatusEnum.STATUS_TOPAY.getCode());
                }
            }
            dynamicObject.set("creator", (Object)currUserId);
            dynamicObject.set("createtime", (Object)currDate);
            dynamicObject.set("isallowcal", onHoldObj.get("isallowcal"));
            onHoldFileDatas[i] = dynamicObject;
        }
        onHoldFileHelper.save(onHoldFileDatas);
    }

    public static void updateCalTable(Set<Long> calTableIdSet, Map<Long, Date> cacheOnHoldBillMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject[] dynamicObjects = helper.query("id,onholdstatus,modifytime,modifier,caltask.ENDDATE", new QFilter[]{new QFilter("id", "in", calTableIdSet)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            Date endDate;
            obj.set("onholdstatus", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            Long calPersonId = obj.getLong("id");
            Date onHoldStartDate = cacheOnHoldBillMap.get(calPersonId);
            if (onHoldStartDate == null || (endDate = obj.getDate("caltask.ENDDATE")) == null || onHoldStartDate.getTime() <= endDate.getTime()) continue;
            obj.set("onholdstatus", (Object)Character.valueOf(' '));
        }
        helper.update(dynamicObjects);
    }

    public static Map<Long, String> updateCalTableBySalaryFile(Set<Long> salaryFileIdSet, Map<Long, Date> cacheSalaryFileMap) {
        SWCDataServiceHelper helper;
        DynamicObject[] dynamicObjects;
        HashMap<Long, String> calPersonOnHoldMap = new HashMap<Long, String>(16);
        SWCDataServiceHelper onHoldBillHepler = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter onHoldFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        onHoldFilter.and("caltask.id", ">", (Object)0);
        DynamicObject[] onHoldTaskInfos = onHoldBillHepler.query("caltask.id,salaryfile.id", new QFilter[]{onHoldFilter});
        HashMap onHoldTaskMap = new HashMap(16);
        if (onHoldTaskInfos != null && onHoldTaskInfos.length > 0) {
            for (DynamicObject onHoldTaskInfo : onHoldTaskInfos) {
                Long salaryFileId = onHoldTaskInfo.getLong("salaryfile.id");
                HashSet<Long> calTaskIdSet = (HashSet<Long>)onHoldTaskMap.get(salaryFileId);
                if (calTaskIdSet == null) {
                    calTaskIdSet = new HashSet<Long>(16);
                }
                Long calTaskId = onHoldTaskInfo.getLong("caltask.id");
                calTaskIdSet.add(calTaskId);
                onHoldTaskMap.put(salaryFileId, calTaskIdSet);
            }
        }
        if ((dynamicObjects = (helper = new SWCDataServiceHelper("hsas_calperson")).query("id,onholdstatus,modifytime,modifier,caltask.ENDDATE,caltask.id,salaryfile", new QFilter[]{new QFilter("salaryfile.id", "in", salaryFileIdSet)})) == null || dynamicObjects.length == 0) {
            return calPersonOnHoldMap;
        }
        for (DynamicObject obj : dynamicObjects) {
            Date endDate;
            Long calTaskId;
            Long salaryFileId = obj.getLong("salaryfile.id");
            Set calTaskIdSet = (Set)onHoldTaskMap.get(salaryFileId);
            if (calTaskIdSet != null && calTaskIdSet.size() > 0 && calTaskIdSet.contains(calTaskId = Long.valueOf(obj.getLong("caltask.id")))) continue;
            obj.set("onholdstatus", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            Date onHoldStartDate = cacheSalaryFileMap.get(salaryFileId);
            if (onHoldStartDate == null || (endDate = obj.getDate("caltask.ENDDATE")) == null) continue;
            if (endDate != null && onHoldStartDate.getTime() > endDate.getTime()) {
                obj.set("onholdstatus", (Object)Character.valueOf(' '));
                calPersonOnHoldMap.put(obj.getLong("id"), " ");
                continue;
            }
            calPersonOnHoldMap.put(obj.getLong("id"), String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()));
        }
        helper.update(dynamicObjects);
        return calPersonOnHoldMap;
    }

    public static void updateAllotDetail(Date currDate, Long currUserId, Set<Long> calTableIdSet) {
        DynamicObject[] dynamicObjects;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter qFilter = new QFilter("caltableid", "in", calTableIdSet);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        for (DynamicObject obj : dynamicObjects = helper.query("id,onholdstatus,modifytime,modifier", new QFilter[]{qFilter})) {
            obj.set("onholdstatus", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        helper.update(dynamicObjects);
    }

    public static void updateAllotDetailBySalaryFile(Date currDate, Long currUserId, Set<Long> salaryFileIdSet) {
        DynamicObject[] dynamicObjects;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter qFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        for (DynamicObject obj : dynamicObjects = helper.query("id,onholdstatus,modifytime,modifier", new QFilter[]{qFilter})) {
            obj.set("onholdstatus", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        helper.update(dynamicObjects);
    }

    public static void updateAllotDetailByCalPerson(Date currDate, Long currUserId, Map<Long, String> calPersonOnHoldMap) {
        QFilter qFilter = new QFilter("caltableid", "in", calPersonOnHoldMap.keySet());
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        DynamicObject[] dynamicObjects = helper.query("id,onholdstatus,modifytime,modifier,caltableid", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            Long calPersonId = obj.getLong("caltableid");
            String onHoldStatus = calPersonOnHoldMap.get(calPersonId);
            obj.set("onholdstatus", (Object)onHoldStatus);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        helper.update(dynamicObjects);
    }

    public static void updatePayDetail(Date currDate, Long currUserId, Set<Long> calTableIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("calpersonid", "in", calTableIdSet);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = helper.query("id,onholdstatus,modifytime,modifier", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            obj.set("onholdstatus", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        helper.update(dynamicObjects);
    }

    public static void updatePayDetailByCalPerson(Date currDate, Long currUserId, Map<Long, String> calPersonOnHoldMap) {
        HashSet<Long> calPersonIds = new HashSet<Long>(calPersonOnHoldMap.size());
        for (Map.Entry<Long, String> entry : calPersonOnHoldMap.entrySet()) {
            calPersonIds.add(entry.getKey());
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("calpersonid", "in", calPersonIds);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = helper.query("id,onholdstatus,modifytime,modifier,calpersonid", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            Long calPersonId = obj.getLong("calpersonid");
            String onHoldStatus = calPersonOnHoldMap.get(calPersonId);
            obj.set("onholdstatus", (Object)onHoldStatus);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        helper.update(dynamicObjects);
    }

    public static void showOnholdPreviewPage(Long personId, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("abstractFlex");
        showParameter.setFormId("hsas_onholdpreview");
        showParameter.setCustomParam("personid", (Object)personId);
        showParameter.setSendToClient(true);
        view.showForm(showParameter);
    }

    public static void updateEditStatus(IDataModel model, IFormView view, Long personId) {
        String pageId;
        DynamicObjectCollection salaryEntity = model.getEntryEntity("salaryentry");
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId = view.getPageId(), JSONObject.class);
        LinkedHashMap personJsonInfo = (LinkedHashMap)onholdInfoAppcheJSONObject.get((Object)personId);
        if (personJsonInfo == null) {
            return;
        }
        List salaryfileList = (List)personJsonInfo.get("salaryfileList");
        for (int i = 0; i < salaryEntity.size(); ++i) {
            LinkedHashMap salaryfileInfo = (LinkedHashMap)salaryfileList.get(i);
            Integer salaryfileStatus = Integer.valueOf((String)salaryfileInfo.get("salaryfileStatus"));
            if (salaryfileStatus <= OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            view.setEnable(Boolean.FALSE, i, new String[]{"salaryonholdstartdate", "salaryisallowcal", "salaryonholdreason", "salaryreleasedate"});
        }
        List caltableList = (List)personJsonInfo.get("caltableList");
        if (caltableList == null || caltableList.size() == 0) {
            view.getModel().deleteEntryData("caltableentry");
            view.updateView("caltableentry");
            return;
        }
        int cacheCalTableSize = caltableList.size();
        DynamicObjectCollection caltableEntity = model.getEntryEntity("caltableentry");
        for (int i = 0; i < caltableEntity.size(); ++i) {
            if (i >= cacheCalTableSize) continue;
            DynamicObject caltableObj = (DynamicObject)caltableEntity.get(i);
            LinkedHashMap catableInfo = (LinkedHashMap)caltableList.get(i);
            Boolean caltableOnHoldStatus = caltableObj.getBoolean("caltableonholdstatus");
            view.setEnable(caltableOnHoldStatus, i, new String[]{"caltableonholdreason"});
            Integer caltableStatus = Integer.valueOf((String)catableInfo.get("caltableStatus"));
            if (caltableStatus <= OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            view.setEnable(Boolean.FALSE, i, new String[]{"caltableonholdstatus", "caltableonholdreason"});
        }
        view.updateView("caltableentry");
        view.updateView("salaryentry");
    }

    public static void confirmOperate(IFormView view, boolean isSave, List<String> selectedPersonIdList) {
        OnHoldBillHelper.saveOrSubmitOnHoldInfo(view, selectedPersonIdList, isSave);
    }

    public static void saveOrSubmitOnHoldInfo(IFormView view, List<String> selectedPersonIdList, boolean isSave) {
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = view.getPageId();
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        OnHoldBillService onHoldService = new OnHoldBillService();
        Map<String, Object> resultMap = isSave ? onHoldService.saveOnHold(onholdInfoAppcheJSONObject, selectedPersonIdList, pageId) : onHoldService.submitOnHold(onholdInfoAppcheJSONObject, selectedPersonIdList, pageId);
        appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
        List savePkIds = (List)resultMap.get("SavePkIds");
        if (savePkIds != null && !savePkIds.isEmpty()) {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            Long onHoldId = (Long)savePkIds.get(0);
            param.put(PKID, onHoldId);
            param.put(PAGEID, view.getPageId());
            AttachmentFieldServiceHelper.saveTempAttachments((String)SerializationUtils.toJsonString(param));
            view.getModel().setValue("id", (Object)onHoldId);
            DynamicObject onHoldInfo = OnHoldBillHelper.queryOnHoldById(onHoldId);
            DynamicObjectCollection objColl = (DynamicObjectCollection)onHoldInfo.get("attachment");
            Long[] attIds = new Long[objColl.size()];
            int index = 0;
            for (DynamicObject obj : objColl) {
                attIds[index++] = obj.getLong("fbasedataid_id");
            }
            view.getModel().setValue("attachment", (Object)attIds);
            view.updateView("attachment");
        } else {
            AttachmentFieldServiceHelper.saveTempAttachments((String)view.getPageId());
        }
        OnHoldBillHelper.showEditResultMsg(resultMap, isSave ? "donothing_save" : "donothing_formsubmit", view);
    }

    public static Map<String, String> getEditContentByOperateKey(String operateKey) {
        HashMap<String, String> contentMap = new HashMap<String, String>(16);
        String message = "";
        String operateName = "";
        String operateSuccessTip = "";
        switch (operateKey) {
            case "caltable_deleteentry": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u5220\u9664\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"OnHoldDetailHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
                break;
            }
            case "salaryfile_deleteentry": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u5220\u9664\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"OnHoldDetailHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
                break;
            }
            case "donothing_save": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u4eba({1}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55)\uff0c{2}\u6761\u6210\u529f\uff0c{3}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u4fdd\u5b58\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OnHoldDetailHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
                break;
            }
            case "donothing_formsubmit": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u4eba({1}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55)\uff0c{2}\u6761\u6210\u529f\uff0c{3}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u751f\u6548\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u751f\u6548\u6210\u529f", (String)"OnHoldDetailHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]);
                break;
            }
        }
        contentMap.put(operateKey + "_message", message);
        contentMap.put(operateKey + "_operateName", operateName);
        contentMap.put(operateKey + "_operateSuccessTip", operateSuccessTip);
        return contentMap;
    }

    public static void showEditResultMsg(Map<String, Object> resultMap, String operateKey, IFormView view) {
        Map<String, String> contentByOperateKey = OnHoldBillHelper.getEditContentByOperateKey(operateKey);
        Set errorMsgSet = (Set)resultMap.get("errorMsgSet");
        if (errorMsgSet == null) {
            view.showSuccessNotification(contentByOperateKey.get(operateKey + "_operateSuccessTip"));
            return;
        }
        ArrayList errorMsgList = new ArrayList(errorMsgSet);
        Integer successCount = (Integer)resultMap.get("successCount");
        Integer totalRecordCount = (Integer)resultMap.get("totalRecordCount");
        Integer totalPersonCount = (Integer)resultMap.get("totalPersonCount");
        if (errorMsgList.isEmpty()) {
            view.showSuccessNotification(contentByOperateKey.get(operateKey + "_operateSuccessTip"));
            return;
        }
        if (totalRecordCount == 1 && errorMsgList.size() == 1) {
            view.showErrorNotification((String)errorMsgList.get(0));
        } else {
            int failCount = totalRecordCount - successCount;
            String message = MessageFormat.format(contentByOperateKey.get(operateKey + "_message"), totalPersonCount, totalRecordCount, successCount, failCount);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)contentByOperateKey.get(operateKey + "_operateName"), (String)message, errorMsgList);
            view.showForm(parameters);
        }
    }

    public static void openSalaryfileListF7(IFormView formView, String pluginName, Long personId) {
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"hsas_onholdsalaryfilef7", (boolean)true);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auditFilter = new QFilter("status", "=", (Object)"C");
        QFilter qFilter = new QFilter("employee.id", "=", (Object)personId);
        qFilter.and(auditFilter);
        qFilter.and(enableFilter);
        DynamicObjectCollection salaryEntryColl = formView.getModel().getEntryEntity("salaryentry");
        if (salaryEntryColl != null && salaryEntryColl.size() > 0) {
            HashSet<Long> salaryFileIdSet = new HashSet<Long>(salaryEntryColl.size());
            for (DynamicObject salaryEntryObj : salaryEntryColl) {
                Long salaryFileId = salaryEntryObj.getLong("salaryfileinfo.id");
                salaryFileIdSet.add(salaryFileId);
            }
            qFilter.and(new QFilter("id", "not in", salaryFileIdSet));
        }
        showParam.getListFilterParameter().setFilter(qFilter);
        showParam.setCloseCallBack(new CloseCallBack(pluginName, "hsas_onholdsalaryfilef7"));
        formView.showForm((FormShowParameter)showParam);
    }

    public static Object serialize(Serializable value) {
        return org.apache.commons.lang3.SerializationUtils.serialize((Serializable)value);
    }

    public static Serializable deserialize(byte[] value) {
        return value == null ? null : (Serializable)org.apache.commons.lang3.SerializationUtils.deserialize((byte[])value);
    }

    public static Map<String, Object> getOnHoldStatusStyle(String onHoldStatus) {
        HashMap<String, Object> styleMap = new HashMap<String, Object>(2);
        String color = "#333333";
        if (String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(onHoldStatus)) {
            color = "#276FF5";
        } else if (String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()).equals(onHoldStatus)) {
            color = "#FF991C";
        } else if (String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()).equals(onHoldStatus)) {
            color = "#FD6C6A";
        } else if (String.valueOf(OnHoldStatusEnum.ABANDON.getCode()).equals(onHoldStatus)) {
            color = "#999999";
        }
        styleMap.put("fc", color);
        return styleMap;
    }

    public static void errorMsgListSort(List<String> errorMsgList) {
        Collections.sort(errorMsgList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String preErrroMsg = o1.substring(o1.indexOf(65292));
                String behindErrroMsg = o2.substring(o2.indexOf(65292));
                return preErrroMsg.compareTo(behindErrroMsg);
            }
        });
    }

    public static void confirmRelPerson(IFormView view, List<Long> selectedRowsId) {
        int selectedSize = selectedRowsId.size();
        if (selectedSize == 1) {
            DynamicObject dynamicObject = OnHoldBillHelper.queryOnHoldByPkId(selectedRowsId.get(0));
            if (dynamicObject == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"OnHoldBillHelper_20", (String)"swc-hsas-business", (Object[])new Object[0]));
                return;
            }
            String personName = dynamicObject.getString("person.person.name");
            String personNum = dynamicObject.getString("person.empnumber");
            String calTaskNum = dynamicObject.getString("caltask.number");
            String salaryFileNum = dynamicObject.getString("salaryfile.number");
            String msg = SWCStringUtils.isNotEmpty((String)calTaskNum) ? ResManager.loadKDString((String)"\u60a8\u5c06\u5bf9{0}({1})\u7684\u6838\u7b97\u4efb\u52a1\u201c{2}\u201d\u6570\u636e\u8fdb\u884c\u89e3\u85aa\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f", (String)"OnHoldBillHelper_12", (String)"swc-hsas-business", (Object[])new Object[]{personName, personNum, calTaskNum}) : ResManager.loadKDString((String)"\u60a8\u5c06\u5bf9{0}({1})\u7684\u4eba\u5458\u85aa\u8d44\u6863\u6848\u201c{2}\u201d\u6570\u636e\u8fdb\u884c\u89e3\u85aa\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f", (String)"OnHoldBillHelper_13", (String)"swc-hsas-business", (Object[])new Object[]{personName, personNum, salaryFileNum});
            view.showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_release"));
            return;
        }
        if (selectedSize > 1) {
            String tipsBeforeRelease = OnHoldBillHelper.getTipMsgBeforeOp(selectedRowsId);
            String msg = ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u64cd\u4f5c\u89e3\u85aa\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f", (String)"OnHoldBillHelper_14", (String)"swc-hsas-business", (Object[])new Object[0]);
            view.showConfirm(msg, tipsBeforeRelease, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("donothing_release"));
            return;
        }
    }

    public static void confirmStopPerson(IFormView view, List<Long> selectedRowsId) {
        int selectedSize = selectedRowsId.size();
        if (selectedSize == 1) {
            DynamicObject dynamicObject = OnHoldBillHelper.queryOnHoldByPkId(selectedRowsId.get(0));
            if (dynamicObject == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"OnHoldBillHelper_20", (String)"swc-hsas-business", (Object[])new Object[0]));
                return;
            }
            String personName = dynamicObject.getString("person.person.name");
            String personNum = dynamicObject.getString("person.empnumber");
            String calTaskNum = dynamicObject.getString("caltask.number");
            String salaryFileNum = dynamicObject.getString("salaryfile.number");
            String msg = null;
            msg = SWCStringUtils.isNotEmpty((String)calTaskNum) ? ResManager.loadKDString((String)"\u60a8\u5c06\u5bf9{0}({1})\u7684\u6838\u7b97\u4efb\u52a1\u201c{2}\u201d\u6570\u636e\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\u3002\u64cd\u4f5c\u540e\u5bf9\u5e94\u7684\u6838\u7b97\u4efb\u52a1\u4e0b\u8be5\u5458\u5de5\u65e0\u6cd5\u8fdb\u884c\u6838\u7b97\u53ca\u53d1\u653e\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f", (String)"OnHoldBillHelper_17", (String)"swc-hsas-business", (Object[])new Object[]{personName, personNum, calTaskNum}) : ResManager.loadKDString((String)"\u60a8\u5c06\u5bf9{0}({1})\u7684\u4eba\u5458\u85aa\u8d44\u6863\u6848\u201c{2}\u201d\u6570\u636e\u8fdb\u884c\u7ec8\u6b62\u53d1\u653e\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f", (String)"OnHoldBillHelper_18", (String)"swc-hsas-business", (Object[])new Object[]{personName, personNum, salaryFileNum});
            view.showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_stoppay"));
            return;
        }
        if (selectedSize > 1) {
            String tipsBeforeStopPay = OnHoldBillHelper.getTipMsgBeforeOp(selectedRowsId);
            String msg = ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u64cd\u4f5c\u7ec8\u6b62\u53d1\u653e\uff0c\u64cd\u4f5c\u540e\u5bf9\u5e94\u7684\u6838\u7b97\u4efb\u52a1\u6570\u636e\u53ca\u4eba\u5458\u85aa\u8d44\u6863\u6848\u65e0\u6cd5\u8fdb\u884c\u6838\u7b97\u53ca\u53d1\u653e\uff0c\u786e\u8ba4\u7ee7\u7eed\u5417\uff1f", (String)"OnHoldBillHelper_19", (String)"swc-hsas-business", (Object[])new Object[0]);
            view.showConfirm(msg, tipsBeforeStopPay, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("donothing_stoppay"));
            return;
        }
    }

    public static String getTipMsgBeforeOp(List<Long> selectedRowsId) {
        DynamicObject[] dynamicObjects;
        StringBuilder tipBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects = OnHoldBillHelper.queryOnholdObjsByIdList(selectedRowsId)) {
            String personName = dynamicObject.getString("person.person.name");
            String personNum = dynamicObject.getString("person.empnumber");
            String calTaskNum = dynamicObject.getString("caltask.number");
            String salaryFileNum = dynamicObject.getString("salaryfile.number");
            String startDate = SWCInteDateTimeUtil.formateDate((Date)dynamicObject.getDate("startdate"));
            Date endDate = dynamicObject.getDate("enddate");
            String endDateStr = "";
            if (endDate != null) {
                endDateStr = SWCInteDateTimeUtil.formateDate((Date)endDate);
            }
            if (!SWCStringUtils.equals(null, (String)calTaskNum)) {
                tipBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6838\u7b97\u4efb\u52a1\uff08{2}\uff09\u7684\u505c\u7f13\u53d1\u533a\u95f4\u201c{3}~{4}\u201d\u3002", (String)"OnHoldBillHelper_15", (String)"swc-hsas-business", (Object[])new Object[0]), personName, personNum, calTaskNum, startDate, endDateStr));
                tipBuilder.append("\r\n");
                continue;
            }
            tipBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7684\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f{3}\u3002", (String)"OnHoldBillHelper_16", (String)"swc-hsas-business", (Object[])new Object[0]), personName, personNum, salaryFileNum, startDate));
            tipBuilder.append("\r\n");
        }
        return tipBuilder.toString();
    }

    public static DynamicObject[] queryOnholdObjsByIdList(List<Long> pKIdList) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("id", "in", pKIdList);
        String selectedProperties = "id,person.name,person.empnumber,caltask.number,salaryfile.number,startdate,enddate";
        return onHoldHelper.query(selectedProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryOnHoldsByIds(List<Long> pKIdList) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("id", "in", pKIdList);
        String selectedProperties = "id,caltableid,caltask,calamount,calcurrency,payoutitem";
        return onHoldHelper.query(selectedProperties, new QFilter[]{qFilter});
    }

    public static void updateOnHoldStatus(DynamicObject[] dynamicObjects, int newStatusCode) {
        Map<Long, String> calPersonOnHoldMap;
        int selectedSize = dynamicObjects.length;
        HashSet<Long> calTableIdSet = new HashSet<Long>(selectedSize);
        HashSet<Long> updateCaltabIdSet = new HashSet<Long>(selectedSize);
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(selectedSize);
        HashSet<Long> salaryFileIdSet2 = new HashSet<Long>(selectedSize);
        ArrayList<DynamicObject> onHoldSalaryFileObjList = new ArrayList<DynamicObject>(selectedSize);
        for (DynamicObject onHoldObj : dynamicObjects) {
            Long calTableId = onHoldObj.getLong("caltableid");
            if (calTableId > 0L) {
                calTableIdSet.add(calTableId);
                updateCaltabIdSet.add(calTableId);
                salaryFileIdSet2.add(onHoldObj.getLong("salaryfile.id"));
                continue;
            }
            salaryFileIdSet.add(onHoldObj.getLong("salaryfile.id"));
            onHoldSalaryFileObjList.add(onHoldObj);
        }
        calTableIdSet.addAll(OnHoldBillHelper.queryCalPersonIdByFileIds(salaryFileIdSet2));
        Date currDate = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        OnHoldBillHelper.updateOnHoldBillReleaseCalAmount(dynamicObjects, newStatusCode, calTableIdSet);
        OnHoldBillHelper.updateOnHoldBillStatus(dynamicObjects, newStatusCode, currDate, userId);
        OnHoldBillHelper.updateOnHoldFileStatus(salaryFileIdSet, onHoldSalaryFileObjList, newStatusCode, currDate, userId);
        if (salaryFileIdSet.size() > 0 && (calPersonOnHoldMap = OnHoldBillHelper.updateCalTableStatusBySalaryFile(salaryFileIdSet, newStatusCode, onHoldSalaryFileObjList)) != null && calPersonOnHoldMap.size() > 0) {
            OnHoldBillHelper.updatePayDetailStatusByCalPerson(calPersonOnHoldMap, currDate, userId, newStatusCode);
            OnHoldBillHelper.updateAllotDetailStatusByCalPerson(calPersonOnHoldMap, currDate, userId);
        }
        if (CollectionUtils.isEmpty(calTableIdSet)) {
            return;
        }
        OnHoldBillHelper.updateCalTableStatus(updateCaltabIdSet, newStatusCode);
        OnHoldBillHelper.updatePayDetailStatus(updateCaltabIdSet, currDate, userId, newStatusCode);
        OnHoldBillHelper.updateAllotDetailStatus(updateCaltabIdSet, currDate, userId, newStatusCode);
    }

    public static void updateOnHoldBillStatus(DynamicObject[] dynamicObjects, int newStatusCode, Date currDate, Long currUserId) {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("status", (Object)newStatusCode);
            dynamicObject.set("modifytime", (Object)currDate);
            dynamicObject.set("modifier", (Object)currUserId);
        }
        onHoldHelper.update(dynamicObjects);
    }

    public static void updateOnHoldBillReleaseCalAmount(DynamicObject[] dynamicObjects, int newStatusCode, Set<Long> calPersonIdSet) {
        if (OnHoldStatusEnum.STATUS_RELEASE.getCode() == newStatusCode && !calPersonIdSet.isEmpty()) {
            int calPersonLen = dynamicObjects.length;
            ArrayList<Long> calRuleIdList = new ArrayList<Long>(calPersonLen);
            ArrayList<Long> payRollGroupVids = new ArrayList<Long>(calPersonLen);
            for (DynamicObject dynamicObject : dynamicObjects) {
                long calRuleVid = dynamicObject.getLong("caltask.calrulev.id");
                Long payRollGroupVid = dynamicObject.getLong("caltask.payrollgroupv.id");
                calRuleIdList.add(calRuleVid);
                payRollGroupVids.add(payRollGroupVid);
            }
            Map<String, String> calRuleNetSalaryItemInfoMap = OnHoldBillHelper.queryCalRuleIdRefNetSalaryItemInfoMap(calRuleIdList);
            Map<Long, DynamicObject> payRollGroupIdRefPayRollGroupObjMap = OnHoldBillHelper.queryPayRollGroupIdRefPayRollGroupObjMap(payRollGroupVids);
            ArrayList<Long> calTableIds = new ArrayList<Long>(calPersonIdSet.size());
            Map<String, String> calPersonTableIdMap = OnHoldBillHelper.queryCalTableIdsByCalPersonId(calPersonIdSet, calTableIds);
            Map<String, DynamicObject> calTableIdRefCalTableObjMap = OnHoldBillHelper.queryCalTableIdRefCalTableObjMap(calTableIds);
            SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
            for (DynamicObject dynamicObject : dynamicObjects) {
                long calRuleVid = dynamicObject.getLong("caltask.calrulev.id");
                Long payRollGroupVid = dynamicObject.getLong("caltask.payrollgroupv.id");
                DynamicObject payRollGroup = payRollGroupIdRefPayRollGroupObjMap.get(payRollGroupVid);
                DynamicObject calTable = calTableIdRefCalTableObjMap.get(calPersonTableIdMap.get(dynamicObject.getString("caltableid")));
                Map<String, String> actualSalaryInfoMap = OnHoldBillHelper.getNetSalaryAmountInfo(calRuleVid, calRuleNetSalaryItemInfoMap, calTable, payRollGroup);
                dynamicObject.set("releasecalamount", (Object)actualSalaryInfoMap.get("calAmount"));
                dynamicObject.set("calcurrency", (Object)actualSalaryInfoMap.get("calcurrency"));
            }
            onHoldHelper.update(dynamicObjects);
        }
    }

    private static Map<String, String> queryCalTableIdsByCalPersonId(Set<Long> calPersonIdSet, List<Long> calTableIds) {
        DynamicObject[] calPersonDys;
        HashMap calPersonTableIdMap = Maps.newHashMapWithExpectedSize((int)calPersonIdSet.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        for (DynamicObject calPersonDy : calPersonDys = helper.query("id, calresultid", new QFilter("id", "in", calPersonIdSet).toArray())) {
            calPersonTableIdMap.put(calPersonDy.getString("id"), calPersonDy.getString("calresultid"));
            calTableIds.add(calPersonDy.getLong("calresultid"));
        }
        return calPersonTableIdMap;
    }

    public static void updateOnHoldFileStatus(Set<Long> salaryFileIdSet, List<DynamicObject> onHoldSalaryFileObjList, int newStatusCode, Date currDate, Long currUserId) {
        if (salaryFileIdSet.isEmpty() && onHoldSalaryFileObjList.isEmpty()) {
            return;
        }
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_onholdfile");
        QFilter salaryFileIdFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        DynamicObject[] onHoldFileObjs = onHoldFileHelper.query("id,status,startdate,enddate,salaryfile.id,createtime,modifytime,modifier", new QFilter[]{salaryFileIdFilter});
        Map<String, DynamicObject> result = OnHoldBillHelper.buildResultMap(onHoldFileObjs);
        StringBuilder key = new StringBuilder();
        for (DynamicObject dynamicObject : onHoldSalaryFileObjList) {
            Date onHoldBillStartDate = dynamicObject.getDate("startdate");
            Date onHoldBillEndDate = dynamicObject.getDate("enddate");
            String onHoldBillSalFileId = dynamicObject.getString("salaryfile.id");
            key.delete(0, key.length());
            key.append(onHoldBillSalFileId);
            key.append(onHoldBillStartDate);
            key.append(onHoldBillEndDate);
            DynamicObject onHoldFileObj = result.get(key.toString());
            if (SWCObjectUtils.isEmpty((Object)onHoldFileObj)) continue;
            onHoldFileObj.set("status", (Object)newStatusCode);
            onHoldFileObj.set("modifytime", (Object)currDate);
            onHoldFileObj.set("modifier", (Object)currUserId);
        }
        onHoldFileHelper.update(onHoldFileObjs);
    }

    public static Map<String, DynamicObject> buildResultMap(DynamicObject[] onHoldFileObjs) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(onHoldFileObjs.length);
        StringBuilder key = new StringBuilder();
        for (DynamicObject onHoldFileObj : onHoldFileObjs) {
            Date createTimeNew;
            key.delete(0, key.length());
            Date onHoldFileStartDate = onHoldFileObj.getDate("startdate");
            Date onHoldFileEndDate = onHoldFileObj.getDate("enddate");
            String onHoldFileSalFileId = onHoldFileObj.getString("salaryfile.id");
            key.append(onHoldFileSalFileId);
            key.append(onHoldFileStartDate);
            key.append(onHoldFileEndDate);
            if (SWCObjectUtils.isEmpty(result.get(key.toString()))) {
                result.put(key.toString(), onHoldFileObj);
                continue;
            }
            Date createTimeOld = ((DynamicObject)result.get(key.toString())).getDate("createtime");
            if (!createTimeOld.before(createTimeNew = onHoldFileObj.getDate("createtime"))) continue;
            result.put(key.toString(), onHoldFileObj);
        }
        return result;
    }

    public static void updateCalTableStatus(Set<Long> calTableIdSet, int newStatusCode) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject[] dynamicObjects = calTableHelper.query("id,onholdstatus", new QFilter[]{new QFilter("id", "in", calTableIdSet)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            obj.set("onholdstatus", (Object)newStatusCode);
        }
        calTableHelper.update(dynamicObjects);
    }

    public static Map<Long, String> updateCalTableStatusBySalaryFile(Set<Long> salaryFileIdSet, int newStatusCode, List<DynamicObject> onHoldSalaryFileObjList) {
        HashMap<Long, String> calPersonOnHoldMap = new HashMap<Long, String>(salaryFileIdSet.size());
        SWCDataServiceHelper onHoldBillHepler = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter onHoldFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        onHoldFilter.and("caltask.id", ">", (Object)0);
        DynamicObject[] onHoldTaskInfos = onHoldBillHepler.query("caltask.id,salaryfile.id", new QFilter[]{onHoldFilter});
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject[] dynamicObjects = calTableHelper.query("id,onholdstatus,caltask.ENDDATE,caltask.id,salaryfile", new QFilter[]{new QFilter("salaryfile.id", "in", salaryFileIdSet)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return calPersonOnHoldMap;
        }
        HashMap onHoldTaskMap = new HashMap(16);
        if (onHoldTaskInfos != null && onHoldTaskInfos.length > 0) {
            for (DynamicObject onHoldTaskInfo : onHoldTaskInfos) {
                Long salaryFileId = onHoldTaskInfo.getLong("salaryfile.id");
                HashSet<Long> calTaskIdSet = (HashSet<Long>)onHoldTaskMap.get(salaryFileId);
                if (calTaskIdSet == null) {
                    calTaskIdSet = new HashSet<Long>(16);
                }
                Long calTaskId = onHoldTaskInfo.getLong("caltask.id");
                calTaskIdSet.add(calTaskId);
                onHoldTaskMap.put(salaryFileId, calTaskIdSet);
            }
        }
        HashMap<Long, Date> onHoldStartDateMap = new HashMap<Long, Date>(onHoldSalaryFileObjList.size());
        for (DynamicObject onHoldSalaryFileObj : onHoldSalaryFileObjList) {
            Long salaryFileId = onHoldSalaryFileObj.getLong("salaryfile.id");
            Date onHoldStartDate = onHoldSalaryFileObj.getDate("startdate");
            onHoldStartDateMap.put(salaryFileId, onHoldStartDate);
        }
        for (DynamicObject obj : dynamicObjects) {
            Date taskEndDate;
            Date onHoldStartDate;
            Long calTaskId;
            Long salaryFileId = obj.getLong("salaryfile.id");
            Set calTaskIdSet = (Set)onHoldTaskMap.get(salaryFileId);
            if (calTaskIdSet != null && calTaskIdSet.size() > 0 && calTaskIdSet.contains(calTaskId = Long.valueOf(obj.getLong("caltask.id"))) || (onHoldStartDate = (Date)onHoldStartDateMap.get(salaryFileId)) == null || (taskEndDate = obj.getDate("caltask.ENDDATE")) == null) continue;
            if (onHoldStartDate.getTime() > taskEndDate.getTime()) {
                obj.set("onholdstatus", (Object)Character.valueOf(' '));
                calPersonOnHoldMap.put(obj.getLong("id"), " ");
                continue;
            }
            obj.set("onholdstatus", (Object)newStatusCode);
            calPersonOnHoldMap.put(obj.getLong("id"), String.valueOf(newStatusCode));
        }
        calTableHelper.update(dynamicObjects);
        return calPersonOnHoldMap;
    }

    private static Set<Long> queryCalPersonIdByFileIds(Set<Long> salaryFileIdSet) {
        SWCDataServiceHelper onHoldFileHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryFileIdFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        DynamicObject[] objects = onHoldFileHelper.queryOriginalArray("id", salaryFileIdFilter.toArray());
        HashSet<Long> calPersonIds = new HashSet<Long>(16);
        if (objects != null && objects.length > 0) {
            for (DynamicObject object : objects) {
                calPersonIds.add(object.getLong("id"));
            }
        }
        return calPersonIds;
    }

    public static void updatePayDetailStatus(Set<Long> calPersonIdSet, Date currDate, Long currUserId, int newStatusCode) {
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("calpersonid", "in", calPersonIdSet);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = payDetailHelper.query("id,onholdstatus,modifytime,modifier,abandonedstatus,abandonedres", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            obj.set("onholdstatus", (Object)newStatusCode);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
            if (OnHoldStatusEnum.ABANDON.getCode() != newStatusCode) continue;
            obj.set("abandonedstatus", (Object)Boolean.TRUE);
            obj.set("abandonedres", (Object)PayDetailAbandonReasonEnum.PAY_RELIEF_UNAUDIT.getDesc());
        }
        payDetailHelper.update(dynamicObjects);
    }

    public static void updatePayDetailStatusBySalaryFile(Set<Long> salaryFileIdSet, Date currDate, Long currUserId, int newStatusCode) {
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("salaryfilehis.id", "in", salaryFileIdSet);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = payDetailHelper.query("id,onholdstatus,modifytime,modifier,abandonedstatus,abandonedres", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            obj.set("onholdstatus", (Object)newStatusCode);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
            if (OnHoldStatusEnum.ABANDON.getCode() != newStatusCode) continue;
            obj.set("abandonedstatus", (Object)Boolean.TRUE);
            obj.set("abandonedres", (Object)PayDetailAbandonReasonEnum.PAY_RELIEF_UNAUDIT.getDesc());
        }
        payDetailHelper.update(dynamicObjects);
    }

    public static void updatePayDetailStatusByCalPerson(Map<Long, String> calPersonOnHoldMap, Date currDate, Long currUserId, int newStatusCode) {
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("calpersonid", "in", calPersonOnHoldMap.keySet());
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = payDetailHelper.query("id,onholdstatus,modifytime,modifier,abandonedstatus,abandonedres,calpersonid", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            Long calPersonId = obj.getLong("calpersonid");
            String onHoldStatus = calPersonOnHoldMap.get(calPersonId);
            obj.set("onholdstatus", (Object)onHoldStatus);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
            if (OnHoldStatusEnum.ABANDON.getCode() != newStatusCode) continue;
            obj.set("abandonedstatus", (Object)Boolean.TRUE);
            obj.set("abandonedres", (Object)PayDetailAbandonReasonEnum.PAY_RELIEF_UNAUDIT.getDesc());
        }
        payDetailHelper.update(dynamicObjects);
    }

    public static void updateAllotDetailStatus(Set<Long> calTableIdSet, Date currDate, Long currUserId, int newStatusCode) {
        SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter qFilter = new QFilter("caltableid", "in", calTableIdSet);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = allotDetailHelper.query("id,onholdstatus,modifytime,modifier", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            obj.set("onholdstatus", (Object)newStatusCode);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        allotDetailHelper.update(dynamicObjects);
    }

    public static void updateAllotDetailStatusBySalaryFile(Set<Long> salaryFileIdSet, Date currDate, Long currUserId, int newStatusCode) {
        SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter qFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = allotDetailHelper.query("id,onholdstatus,modifytime,modifier", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            obj.set("onholdstatus", (Object)newStatusCode);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        allotDetailHelper.update(dynamicObjects);
    }

    public static void updateAllotDetailStatusByCalPerson(Map<Long, String> calPersonOnHoldMap, Date currDate, Long currUserId) {
        SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter qFilter = new QFilter("caltableid", "in", calPersonOnHoldMap.keySet());
        qFilter.and(new QFilter("onholdstatus", "!=", (Object)String.valueOf(OnHoldStatusEnum.ABANDON.getCode())));
        DynamicObject[] dynamicObjects = allotDetailHelper.query("id,onholdstatus,modifytime,modifier,caltableid", new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject obj : dynamicObjects) {
            Long calPersonId = obj.getLong("caltableid");
            String onHoldStatus = calPersonOnHoldMap.get(calPersonId);
            obj.set("onholdstatus", (Object)onHoldStatus);
            obj.set("modifytime", (Object)currDate);
            obj.set("modifier", (Object)currUserId);
        }
        allotDetailHelper.update(dynamicObjects);
    }

    public static DynamicObject[] queryOnHoldByDataEntities(DynamicObject[] dataEntities) {
        HashSet<Long> onHoldIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            onHoldIdSet.add(dataEntity.getLong("id"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("id", "in", onHoldIdSet);
        String selectProperties = "id,status,salaryfile,caltableid,modifytime,modifier,startdate,enddate,caltask.calrulev.id,caltask.payrollgroupv.id,releasecalamount,calcurrency";
        return helper.query(selectProperties, new QFilter[]{qFilter});
    }

    public static Map<String, List<String>> getKeySortedMap(LinkedHashMap<String, List<String>> dataMap) {
        LinkedHashMap<String, List<String>> sortedLinkedMap = new LinkedHashMap<String, List<String>>();
        dataMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(map -> {
            List cfr_ignored_0 = (List)sortedLinkedMap.put((String)map.getKey(), (List<String>)map.getValue());
        });
        return sortedLinkedMap;
    }

    public static List<String> mergeMapValues(Map<String, List<String>> dataMap) {
        ArrayList<String> errorList = new ArrayList<String>(10);
        if (dataMap == null || dataMap.isEmpty()) {
            return errorList;
        }
        for (Map.Entry<String, List<String>> entry : dataMap.entrySet()) {
            errorList.addAll((Collection<String>)entry.getValue());
        }
        return errorList;
    }

    public static TableValueSetter getSetter(DynamicObject[] calPersonArr) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("caltableinfo", new Object[0]);
        setter.addField("caltableonholdstatus", new Object[0]);
        setter.addField("orgname", new Object[0]);
        setter.addField("calpayoutitem", new Object[0]);
        setter.addField("caltableamount", new Object[0]);
        setter.addField("caltablecalamount", new Object[0]);
        setter.addField("payrolldate", new Object[0]);
        setter.addField("caltablestartdate", new Object[0]);
        setter.addField("caltableenddate", new Object[0]);
        setter.addField("calcount", new Object[0]);
        setter.addField("caltaskent", new Object[0]);
        setter.addField("salaryfileent", new Object[0]);
        setter.addField("caltablecalcurrency", new Object[0]);
        int calPersonLen = calPersonArr.length;
        HashMap calPersonIdRefCalRuleVidMap = Maps.newHashMapWithExpectedSize((int)calPersonLen);
        ArrayList<Long> calTableIdList = new ArrayList<Long>(calPersonLen);
        HashMap calPersonIdRefPayRollGroupVidMap = Maps.newHashMapWithExpectedSize((int)calPersonLen);
        for (DynamicObject calPersonObj : calPersonArr) {
            long calRuleVid = calPersonObj.getLong("caltask.calrulev.id");
            Long calTableId = calPersonObj.getLong("calresultid");
            Long payRollGroupVid = calPersonObj.getLong("caltask.payrollgroupv.id");
            Long calPersonId = calPersonObj.getLong("id");
            calPersonIdRefPayRollGroupVidMap.put(calPersonId, payRollGroupVid);
            calPersonIdRefCalRuleVidMap.put(calPersonId, calRuleVid);
            if (calTableId.intValue() == 0) continue;
            calTableIdList.add(calTableId);
        }
        Map<String, String> calRuleNetSalaryItemInfoMap = OnHoldBillHelper.queryCalRuleIdRefNetSalaryItemInfoMap(calPersonIdRefCalRuleVidMap.values());
        Set<Long> salaryItemIdSet = OnHoldDetailHelper.getSalaryItemIdSet(calRuleNetSalaryItemInfoMap);
        Map<String, DynamicObject> salaryItemDataPrecisionInfoMap = OnHoldDetailHelper.getSalaryItemDataPrecisionInfoMap(salaryItemIdSet);
        Map<Long, DynamicObject> payRollGroupIdRefPayRollGroupObjMap = OnHoldBillHelper.queryPayRollGroupIdRefPayRollGroupObjMap(calPersonIdRefPayRollGroupVidMap.values());
        Map<String, DynamicObject> calTableIdRefCalTableObjMap = OnHoldBillHelper.queryCalTableIdRefCalTableObjMap(calTableIdList);
        for (DynamicObject calPersonObj : calPersonArr) {
            String calRuleNetSalaryItemInfo;
            Long calPersonId = calPersonObj.getLong("id");
            String calTableId = calPersonObj.getString("calresultid");
            DynamicObject calTable = calTableIdRefCalTableObjMap.get(calTableId);
            Long payRollGroupId = (Long)calPersonIdRefPayRollGroupVidMap.get(calPersonId);
            DynamicObject payRollGroup = payRollGroupIdRefPayRollGroupObjMap.get(payRollGroupId);
            Date payrollDate = calPersonObj.getDate("caltask.payrolldate");
            Date startDate = calPersonObj.getDate("caltask.STARTDATE");
            Date endDate = calPersonObj.getDate("caltask.ENDDATE");
            int calCount = calPersonObj.getInt("caltask.calcount");
            String calTaskId = calPersonObj.getString("caltask.id");
            String salaryFileId = calPersonObj.getString("salaryfile.id");
            Long calRuleVid = (Long)calPersonIdRefCalRuleVidMap.get(calPersonId);
            String calRuleNetSalaryItemId = "";
            String calPersonAmount = "";
            BigDecimal calAmount = BigDecimal.ZERO;
            long calCurrencyId = 0L;
            if (calRuleVid != null && SWCStringUtils.isNotEmpty((String)(calRuleNetSalaryItemInfo = calRuleNetSalaryItemInfoMap.get(calRuleVid.toString())))) {
                calRuleNetSalaryItemId = calRuleNetSalaryItemInfo.substring(0, calRuleNetSalaryItemInfo.indexOf("||"));
                Map<String, String> actualSalaryInfoMap = OnHoldBillHelper.getNetSalaryAmountInfo(calRuleVid, calRuleNetSalaryItemInfoMap, calTable, payRollGroup);
                String calTableAmount = actualSalaryInfoMap.get("calAmount");
                if (SWCStringUtils.isNotEmpty((String)calTableAmount)) {
                    calAmount = new BigDecimal(calTableAmount);
                }
                calPersonAmount = OnHoldDetailHelper.getCalPersonAmount(actualSalaryInfoMap, salaryItemDataPrecisionInfoMap, calRuleNetSalaryItemId);
                String calcurrency = actualSalaryInfoMap.get("calcurrency");
                if (!StringUtil.isEmpty((String)calcurrency)) {
                    calCurrencyId = Long.parseLong(calcurrency);
                }
            }
            String orgName = calPersonObj.getString("org.name");
            setter.addRow(new Object[]{calPersonId, Boolean.TRUE, orgName, calRuleNetSalaryItemId, calPersonAmount, calAmount, payrollDate, startDate, endDate, calCount, calTaskId, salaryFileId, calCurrencyId});
        }
        return setter;
    }
}

