/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.onhold.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.schedule.SendOnHoldMsgTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class OnHoldMsgHelper {
    private static final Log log = LogFactory.getLog(OnHoldMsgHelper.class);
    private static final String MSG_RECORD_PROPERTIES = "id,billid,msgid,msgstatus,msgchannel,msgscene,senderid,msgconfigid,msgtype,channelmsgid";
    private static final String ONHOLDBILLFIELDS = "id,startdate,enddate,org.id,msgstatus,person.person.id,person.person.name,person.empnumber,msgfailchannel";
    private static Map<String, String> statusMap = new HashMap<String, String>(16);

    public static void dispatchSendMsgTask(String scene, DynamicObject[] onholdbills) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("scene", scene);
        params.put("bills", onholdbills);
        RequestContext ctx = RequestContext.get();
        SWCThreadPoolFactory.getCommonAsyncThreadpool().execute(() -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            SendOnHoldMsgTask asyncService = new SendOnHoldMsgTask();
            asyncService.execute(params);
        });
    }

    public static void sendOnHoldMsgByBillCollection(String scene, DynamicObjectCollection list1, DynamicObjectCollection list2) {
        ArrayList objs = new ArrayList(10);
        if (list1 != null) {
            objs.addAll(list1);
        }
        if (list2 != null) {
            objs.addAll(list2);
        }
        DynamicObject[] onHoldBills = objs.toArray(new DynamicObject[0]);
        OnHoldMsgHelper.dispatchSendMsgTask(scene, onHoldBills);
    }

    public static void sendOnHoldMsg(DynamicObject[] onHoldBills, String scene) {
        SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter filter = new QFilter("id", "in", Arrays.stream(onHoldBills).map(o -> o.getLong("id")).collect(Collectors.toList()));
        onHoldBills = billHelper.query(ONHOLDBILLFIELDS, filter.toArray());
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject onHoldBill : onHoldBills) {
            Long orgId = onHoldBill.getLong("org.id");
            orgIds.add(orgId);
        }
        Map<Long, List<DynamicObject>> orgIdConfigMap = OnHoldMsgHelper.getOrgIdConfigMap(scene, orgIds);
        Long currUserId = RequestContext.get().getCurrUserId();
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_onholdmsgrecord");
        List<Long> allPerosonIds = Arrays.stream(onHoldBills).map(o -> o.getLong("person.person.id")).collect(Collectors.toList());
        Map<Long, List<Long>> personSuperMap = OnHoldMsgHelper.getPersonSuperMap(allPerosonIds);
        Map<Long, Long> personUserRelMap = OnHoldMsgHelper.getUserPersonRel(personSuperMap, allPerosonIds);
        for (DynamicObject onHoldBill : onHoldBills) {
            List<DynamicObject> msgConfigs = orgIdConfigMap.get(onHoldBill.getLong("org.id"));
            boolean isHasSending = false;
            if (msgConfigs == null || msgConfigs.size() <= 0) continue;
            for (DynamicObject msgConfig : msgConfigs) {
                List<Long> userIds = OnHoldMsgHelper.unionUserIds(personSuperMap, personUserRelMap, onHoldBill, msgConfig);
                if (userIds.size() == 0 || !OnHoldMsgHelper.sendMsg(scene, recordHelper, userIds, currUserId, onHoldBill, msgConfig)) continue;
                isHasSending = true;
            }
            OnHoldMsgHelper.setBillMsgStatus(onHoldBill, isHasSending);
            OnHoldMsgHelper.resetAllMCenterChannelStatus(scene, recordHelper, onHoldBill, msgConfigs);
            billHelper.saveOne(onHoldBill);
        }
    }

    private static void resetAllMCenterChannelStatus(String scene, SWCDataServiceHelper recordHelper, DynamicObject onHoldBill, List<DynamicObject> msgConfigs) {
        boolean isAllMCenter = true;
        for (DynamicObject msgConfig : msgConfigs) {
            if (SWCStringUtils.equals((String)msgConfig.getString("msgtemplate.msgchannel"), (String)"mcenter")) continue;
            isAllMCenter = false;
            break;
        }
        if (isAllMCenter) {
            QFilter billIdFilter = new QFilter("billid", "=", (Object)onHoldBill.getLong("id"));
            QFilter sceneFilter = new QFilter("msgscene", "=", (Object)scene);
            DynamicObject[] records = recordHelper.query(MSG_RECORD_PROPERTIES, new QFilter[]{billIdFilter, sceneFilter});
            OnHoldMsgHelper.setMsgStatusAndFailChannel(onHoldBill, records);
        }
    }

    private static List<Long> unionUserIds(Map<Long, List<Long>> personSuperMap, Map<Long, Long> personUserRelMap, DynamicObject onHoldBill, DynamicObject msgConfig) {
        List<Long> supers;
        Long userId;
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        String receivertype = msgConfig.getString("receivertype");
        long personId = onHoldBill.getLong("person.person.id");
        if (receivertype.contains("1") && (userId = personUserRelMap.get(personId)) != null) {
            userIds.add(userId);
        }
        if (receivertype.contains("2") && (supers = personSuperMap.get(personId)) != null) {
            for (Long superId : supers) {
                Long superUser = personUserRelMap.get(superId);
                if (superUser == null) continue;
                userIds.add(superUser);
            }
        }
        return userIds;
    }

    private static Map<Long, Long> getUserPersonRel(Map<Long, List<Long>> personSuperMap, List<Long> allperson) {
        ArrayList<Long> allPersonIdsAndSupers = new ArrayList<Long>(10);
        allPersonIdsAndSupers.addAll(allperson);
        for (Map.Entry<Long, List<Long>> longListEntry : personSuperMap.entrySet()) {
            allPersonIdsAndSupers.addAll((Collection)longListEntry.getValue());
        }
        HashMap<String, ArrayList<Long>> idMaps = new HashMap<String, ArrayList<Long>>(16);
        idMaps.put("person", allPersonIdsAndSupers);
        HashMap<Long, Long> personUserRelMap = new HashMap<Long, Long>(16);
        Map resultMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        Boolean success = (Boolean)resultMap.get("success");
        if (success.booleanValue()) {
            Map data = (Map)resultMap.get("data");
            for (Map.Entry longMapEntry : data.entrySet()) {
                personUserRelMap.put((Long)longMapEntry.getKey(), (Long)((Map)longMapEntry.getValue()).get("user"));
            }
        }
        return personUserRelMap;
    }

    private static Map<Long, List<Long>> getPersonSuperMap(List<Long> allPerosonIds) {
        HashMap<Long, List<Long>> personSuperMap = new HashMap<Long, List<Long>>(16);
        Map resultMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getDirectSuperior", (Object[])new Object[]{allPerosonIds});
        for (Map.Entry longListEntry : resultMap.entrySet()) {
            Long personId = (Long)longListEntry.getKey();
            List superMapList = (List)longListEntry.getValue();
            List supers = superMapList.stream().map(obj -> (Long)obj.get("person.id")).collect(Collectors.toList());
            personSuperMap.put(personId, supers);
        }
        return personSuperMap;
    }

    private static Map<Long, List<DynamicObject>> getOrgIdConfigMap(String scene, Set<Long> orgIds) {
        HashMap<Long, List<DynamicObject>> orgIdConfigMap = new HashMap<Long, List<DynamicObject>>(16);
        SWCDataServiceHelper msgCfgHelper = new SWCDataServiceHelper("hsbs_onholdmsgcfg");
        String selectProperties = "id,receivertype,msgtemplate.msgchannel,msgtemplate.msgtype,createorg.id";
        for (Long orgId : orgIds) {
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_onholdmsgcfg", (Long)orgId);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter sceneFilter = new QFilter("1", "=", (Object)"1");
            if (SWCStringUtils.isNotEmpty((String)scene)) {
                sceneFilter = new QFilter("msgtemplate.msgscene", "like", (Object)("%" + scene + "%"));
            }
            DynamicObject[] orgConfigs = msgCfgHelper.query(selectProperties, new QFilter[]{orgFilter, statusFilter, enableFilter, sceneFilter});
            orgIdConfigMap.put(orgId, Arrays.asList(orgConfigs));
        }
        return orgIdConfigMap;
    }

    private static void setBillMsgStatus(DynamicObject onHoldBill, boolean isHasSending) {
        if (isHasSending) {
            onHoldBill.set("msgstatus", (Object)"1");
        } else {
            onHoldBill.set("msgstatus", (Object)"3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendMsg(String scene, SWCDataServiceHelper recordHelper, List<Long> receivers, Long senderId, DynamicObject onHoldBill, DynamicObject msgConfig) {
        boolean isSuccess = false;
        long onHoldBillId = onHoldBill.getLong("id");
        String channel = msgConfig.getString("msgtemplate.msgchannel");
        String msgType = msgConfig.getString("msgtemplate.msgtype");
        MessageInfo info = OnHoldMsgHelper.initMessageInfo(scene, senderId, msgType, receivers, onHoldBill, channel);
        DynamicObject msgRecord = OnHoldMsgHelper.initMsgRecordDynamicObject(scene, recordHelper, senderId, onHoldBillId, channel, msgConfig.getLong("id"), msgType);
        try {
            long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)info);
            isSuccess = true;
            msgRecord.set("msgid", (Object)msgId);
            msgRecord.set("msgstatus", (Object)"1");
            if (SWCStringUtils.equals((String)"mcenter", (String)channel)) {
                msgRecord.set("msgstatus", (Object)"4");
            }
        }
        catch (Exception ex) {
            msgRecord.set("msgstatus", (Object)"2");
        }
        finally {
            recordHelper.saveOne(msgRecord);
        }
        return isSuccess;
    }

    private static DynamicObject[] queryOrgUseConfig(Set<Long> configIds) {
        SWCDataServiceHelper msgCfgHelper = new SWCDataServiceHelper("hsbs_onholdmsgcfg");
        String selectProperties = "id,receivertype,msgtemplate.msgchannel,msgtemplate.msgtype,createorg.id";
        QFilter pkFilter = new QFilter("id", "in", configIds);
        return msgCfgHelper.query(selectProperties, new QFilter[]{pkFilter});
    }

    private static DynamicObject initMsgRecordDynamicObject(String scene, SWCDataServiceHelper recordHelper, Long senderId, long onHoldBillId, String channel, long configId, String msgType) {
        DynamicObject msgRecord = recordHelper.generateEmptyDynamicObject();
        msgRecord.set("billid", (Object)onHoldBillId);
        msgRecord.set("msgstatus", (Object)"0");
        msgRecord.set("msgchannel", (Object)channel);
        msgRecord.set("msgscene", (Object)scene);
        msgRecord.set("senderid", (Object)senderId);
        msgRecord.set("msgconfigid", (Object)configId);
        msgRecord.set("msgtype", (Object)msgType);
        return msgRecord;
    }

    private static MessageInfo initMessageInfo(String scene, Long senderId, String msgtype, List<Long> allUserIds, DynamicObject bill, String channel) {
        MessageInfo info = new MessageInfo();
        info.setUserIds(allUserIds);
        info.setSenderId(senderId);
        info.setType(msgtype);
        info.setEntityNumber("hsas_onholdbill");
        info.setBizDataId(Long.valueOf(bill.getLong("id")));
        info.setTplScene(scene);
        info.setNotifyType(channel);
        info.setTag(ResManager.loadKDString((String)"\u505c\u7f13\u53d1\u6d88\u606f\u89e6\u8fbe", (String)"OnHoldMsgHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
        info.setTitle(ResManager.loadKDString((String)"\u505c\u7f13\u53d1\u53ca\u89e3\u85aa\u6d88\u606f\u901a\u77e5", (String)"OnHoldMsgHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]));
        String name = bill.getString("person.person.name");
        String empnumber = bill.getString("person.empnumber");
        String showScene = OnHoldMsgHelper.getSceneLang(scene);
        String startdate = HRInteDateTimeUtil.formatDate((String)"hsas_onholdbill", (String)"startdate", (Date)bill.getDate("startdate"));
        info.setContent(MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\u5728{2}\u5df2{3}\u3002", (String)"OnHoldMsgHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]), name, empnumber, startdate, showScene));
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMsgStatus(Long msgid, String status, Long channelMsgId) {
        SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter msgIdFilter = new QFilter("msgid", "=", (Object)msgid);
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_onholdmsgrecord");
        DynamicObject record = recordHelper.queryOne(MSG_RECORD_PROPERTIES, new QFilter[]{msgIdFilter});
        if (record == null) {
            return;
        }
        DLock lock = DLock.create((String)("onholdmsglock" + record.getLong("billid")));
        try {
            if (lock.tryLock(1000L)) {
                OnHoldMsgHelper.updateOnholdMsgStatus(status, channelMsgId, billHelper, recordHelper, record);
            }
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    private static void updateOnholdMsgStatus(String status, Long channelMsgId, SWCDataServiceHelper billHelper, SWCDataServiceHelper recordHelper, DynamicObject record) {
        try (TXHandle txHandle = TX.requiresNew();){
            record.set("msgstatus", (Object)status);
            record.set("channelmsgid", (Object)channelMsgId);
            recordHelper.saveOne(record);
            OnHoldMsgHelper.updateOnHoldBillMsgStatus(recordHelper, billHelper, record);
        }
    }

    private static void updateOnHoldBillMsgStatus(SWCDataServiceHelper recordHelper, SWCDataServiceHelper billHelper, DynamicObject record) {
        long billId = record.getLong("billid");
        DynamicObject bill = billHelper.queryOne((Object)billId);
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        QFilter sceneFilter = new QFilter("msgscene", "=", (Object)record.getString("msgscene"));
        DynamicObject[] records = recordHelper.query(MSG_RECORD_PROPERTIES, new QFilter[]{billIdFilter, sceneFilter});
        OnHoldMsgHelper.setMsgStatusAndFailChannel(bill, records);
        billHelper.saveOne(bill);
        if (SWCStringUtils.equals((String)record.getString("msgstatus"), (String)"3")) {
            OnHoldMsgHelper.sendFailMsgToSender(record, bill);
        }
    }

    private static void setMsgStatusAndFailChannel(DynamicObject bill, DynamicObject[] records) {
        boolean isSending = false;
        boolean isHasFail = false;
        StringBuilder sb = new StringBuilder();
        block9: for (DynamicObject sceneRecord : records) {
            String msgStatus;
            switch (msgStatus = sceneRecord.getString("msgstatus")) {
                case "3": 
                case "2": {
                    String msgchannel = sceneRecord.getString("msgchannel");
                    if (sb.indexOf(msgchannel) < 0) {
                        sb.append(msgchannel).append(',');
                    }
                    isHasFail = true;
                    continue block9;
                }
                case "1": {
                    isSending = true;
                    continue block9;
                }
            }
        }
        String failChannels = sb.toString();
        bill.set("msgfailchannel", (Object)" ");
        if (isSending) {
            bill.set("msgstatus", (Object)"1");
        } else if (isHasFail) {
            bill.set("msgstatus", (Object)"3");
            bill.set("msgfailchannel", (Object)failChannels);
        } else {
            bill.set("msgstatus", (Object)"4");
        }
    }

    private static void sendFailMsgToSender(DynamicObject record, DynamicObject bill) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setTitle(ResManager.loadKDString((String)"\u505c\u7f13\u53d1\u53ca\u89e3\u85aa\u6d88\u606f\u89e6\u53d1\u5931\u8d25\u901a\u77e5", (String)"OnHoldMsgHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        String name = bill.getString("person.person.name");
        String empnumber = bill.getString("person.empnumber");
        String scene = record.getString("msgscene");
        String showScene = OnHoldMsgHelper.getSceneLang(scene);
        messageInfo.setContent(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a{2}\u6d88\u606f\u89e6\u53d1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OnHoldMsgHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]), name, empnumber, showScene));
        String contentUrl = UrlService.getDomainContextUrl() + "/?formId=hsas_onholdbill&type=list&list_formId=bos_list";
        messageInfo.setContentUrl(contentUrl);
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(record.getLong("senderid"));
        messageInfo.setUserIds(userIds);
        messageInfo.setSendTime(new Date());
        messageInfo.setTag(ResManager.loadKDString((String)"\u505c\u7f13\u53d1\u6d88\u606f\u89e6\u8fbe", (String)"OnHoldMsgHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private static String getSceneLang(String scene) {
        String showScene = "";
        if (SWCStringUtils.equals((String)scene, (String)"onholdbillsubmit")) {
            showScene = ResManager.loadKDString((String)"\u505c\u7f13\u53d1", (String)"OnHoldMsgHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)scene, (String)"onholdbillrelease")) {
            showScene = ResManager.loadKDString((String)"\u89e3\u85aa", (String)"OnHoldMsgHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)scene, (String)"onholdbillstoppay")) {
            showScene = ResManager.loadKDString((String)"\u7ec8\u6b62\u53d1\u653e", (String)"OnHoldMsgHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        return showScene;
    }

    public static void reSendFailMsg(DynamicObject[] onHoldBills) {
        if (onHoldBills == null || onHoldBills.length == 0) {
            return;
        }
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_onholdmsgrecord");
        SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hsas_onholdbill");
        HashMap<Long, List<DynamicObject>> resendBillRecordsMap = new HashMap<Long, List<DynamicObject>>(16);
        HashMap<Long, List<DynamicObject>> resubmitBillRecordsMap = new HashMap<Long, List<DynamicObject>>(16);
        HashSet<Long> configIds = new HashSet<Long>(16);
        OnHoldMsgHelper.putDataToMap(onHoldBills, recordHelper, resendBillRecordsMap, resubmitBillRecordsMap, configIds);
        DynamicObject[] configs = OnHoldMsgHelper.queryOrgUseConfig(configIds);
        Map<Long, DynamicObject> configMap = Arrays.stream(configs).collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (v1, v2) -> v1));
        ArrayList updateRecords = new ArrayList(10);
        ArrayList<DynamicObject> updatebills = new ArrayList<DynamicObject>(10);
        List<Long> allPerosonIds = Arrays.stream(onHoldBills).map(o -> o.getLong("person.person.id")).collect(Collectors.toList());
        Map<Long, List<Long>> personSuperMap = OnHoldMsgHelper.getPersonSuperMap(allPerosonIds);
        Map<Long, Long> personUserRelMap = OnHoldMsgHelper.getUserPersonRel(personSuperMap, allPerosonIds);
        for (DynamicObject onHoldBill : onHoldBills) {
            List<Long> resendMsgIds;
            Long billId = (Long)onHoldBill.getPkValue();
            List submitFailRecords = (List)resubmitBillRecordsMap.get(billId);
            List resendRecords = (List)resendBillRecordsMap.get(billId);
            int sendSuccessCount = 0;
            if (resendRecords != null && (resendMsgIds = OnHoldMsgHelper.getFailsMsgIds(resendRecords)).size() > 0) {
                updateRecords.addAll(resendRecords);
                if (OnHoldMsgHelper.resendMsg(resendMsgIds)) {
                    for (DynamicObject resendRecord : resendRecords) {
                        resendRecord.set("msgstatus", (Object)"1");
                    }
                    sendSuccessCount += resendMsgIds.size();
                }
            }
            if (submitFailRecords != null && submitFailRecords.size() > 0) {
                updateRecords.addAll(submitFailRecords);
                for (DynamicObject submitFailRecord : submitFailRecords) {
                    if (!OnHoldMsgHelper.resubmitMsg(personSuperMap, personUserRelMap, configMap, onHoldBill, submitFailRecord)) continue;
                    ++sendSuccessCount;
                }
            }
            if (sendSuccessCount <= 0) continue;
            onHoldBill.set("msgstatus", (Object)"1");
            updatebills.add(onHoldBill);
        }
        billHelper.save(updatebills.toArray(new DynamicObject[0]));
        recordHelper.save(updateRecords.toArray(new DynamicObject[0]));
    }

    private static void putDataToMap(DynamicObject[] onHoldBills, SWCDataServiceHelper recordHelper, Map<Long, List<DynamicObject>> resendBillRecordsMap, Map<Long, List<DynamicObject>> resubmitBillRecordsMap, Set<Long> configIds) {
        DynamicObject[] allFailRecords;
        ArrayList<Long> billIds = new ArrayList<Long>(onHoldBills.length);
        HashMap<Long, DynamicObject> billidMap = new HashMap<Long, DynamicObject>(onHoldBills.length);
        for (DynamicObject onHoldBill : onHoldBills) {
            billIds.add((Long)onHoldBill.getPkValue());
            billidMap.put((Long)onHoldBill.getPkValue(), onHoldBill);
        }
        for (DynamicObject record : allFailRecords = OnHoldMsgHelper.getFailRecord(recordHelper, billIds)) {
            OnHoldMsgHelper.groupFailRecord(resendBillRecordsMap, resubmitBillRecordsMap, record, billidMap, configIds);
        }
    }

    private static void groupFailRecord(Map<Long, List<DynamicObject>> resendBillRecordsMap, Map<Long, List<DynamicObject>> resubmitBillRecordsMap, DynamicObject record, Map<Long, DynamicObject> billidMap, Set<Long> configIds) {
        String msgstatus;
        long billId = record.getLong("billid");
        String status = billidMap.get(billId).getString("status");
        String msgScene = statusMap.get(status);
        if (!SWCStringUtils.equals((String)msgScene, (String)record.getString("msgscene"))) {
            return;
        }
        switch (msgstatus = record.getString("msgstatus")) {
            case "3": {
                OnHoldMsgHelper.setRecordToMap(resendBillRecordsMap, record, billId, null);
                break;
            }
            case "2": {
                OnHoldMsgHelper.setRecordToMap(resubmitBillRecordsMap, record, billId, configIds);
                break;
            }
        }
    }

    private static void setRecordToMap(Map<Long, List<DynamicObject>> resendBillRecordsMap, DynamicObject record, long billId, Set<Long> configIds) {
        List<DynamicObject> records;
        if (configIds != null) {
            configIds.add(record.getLong("msgconfigid"));
        }
        if ((records = resendBillRecordsMap.get(billId)) == null) {
            records = new ArrayList<DynamicObject>(10);
            resendBillRecordsMap.put(billId, records);
        }
        records.add(record);
    }

    private static List<Long> getFailsMsgIds(List<DynamicObject> records) {
        ArrayList<Long> resendMsgIds = new ArrayList<Long>(records.size());
        for (DynamicObject record : records) {
            resendMsgIds.add(record.getLong("channelmsgid"));
        }
        return resendMsgIds;
    }

    private static boolean resubmitMsg(Map<Long, List<Long>> personSuperMap, Map<Long, Long> personUserRelMap, Map<Long, DynamicObject> configMap, DynamicObject onHoldBill, DynamicObject submitFailRecord) {
        boolean isSuccess = false;
        long msgconfigid = submitFailRecord.getLong("msgconfigid");
        List<Long> userIds = OnHoldMsgHelper.unionUserIds(personSuperMap, personUserRelMap, onHoldBill, configMap.get(msgconfigid));
        if (SWCListUtils.isEmpty(userIds)) {
            return false;
        }
        MessageInfo info = OnHoldMsgHelper.initMessageInfo(submitFailRecord.getString("msgscene"), submitFailRecord.getLong("senderid"), submitFailRecord.getString("msgtype"), userIds, onHoldBill, submitFailRecord.getString("msgchannel"));
        try {
            long msgid = MessageCenterServiceHelper.sendMessage((MessageInfo)info);
            submitFailRecord.set("msgid", (Object)msgid);
            submitFailRecord.set("msgstatus", (Object)"1");
            isSuccess = true;
        }
        catch (Exception e) {
            submitFailRecord.set("msgstatus", (Object)"2");
        }
        return isSuccess;
    }

    private static boolean resendMsg(List<Long> resendMsgIds) {
        try {
            MessageCenterServiceHelper.resendMessageByIds(resendMsgIds);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static DynamicObject[] getFailRecord(SWCDataServiceHelper recordHelper, List<Long> billIds) {
        QFilter billIdFilter = new QFilter("billid", "in", billIds);
        QFilter statusFilter = new QFilter("msgstatus", "in", (Object)new String[]{"3", "2"});
        return recordHelper.query(MSG_RECORD_PROPERTIES, new QFilter[]{billIdFilter, statusFilter});
    }

    static {
        statusMap.put(String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), "onholdbillsubmit");
        statusMap.put(String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()), "onholdbillrelease");
        statusMap.put(String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode()), "onholdbillsubmit");
        statusMap.put(String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), "onholdbillstoppay");
    }
}

