/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.onhold.service;

import com.alibaba.fastjson.JSONArray;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.swc.hsas.business.cal.service.PayStateService;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldDetailHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldMsgHelper;
import kd.swc.hsas.business.onhold.service.OnHoldBillService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class OnHoldDetailService {
    private static final Log LOGGER = LogFactory.getLog(OnHoldDetailService.class);
    private static final String SWC_HSAS_BUSINESS = "swc-hsas-business";
    private String pageId = "";

    public OnHoldDetailService(String pageId) {
        this.pageId = pageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> saveOnHold(Map<String, DynamicObjectCollection> onHoldObjMap, Map<String, Object> publicFieldValMap, String viewPageId) {
        LOGGER.info("#######starting saving onhold datas#######");
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList<Long> onHoldToDeleteIdList = new ArrayList<Long>(10);
        ArrayList<Long> onHoldToUpdateIdList = new ArrayList<Long>(10);
        Map<String, Object> validateResultMap = this.validateOnHoldInfo(onHoldObjMap, onHoldToUpdateIdList, onHoldToDeleteIdList, publicFieldValMap, true);
        Set errorMsgSet = (Set)validateResultMap.get("errorMsgSet");
        Integer failCount = (Integer)validateResultMap.get("failCount");
        Integer totalRecordCount = (Integer)validateResultMap.get("totalRecordCount");
        SWCDataServiceHelper onHoldBillService = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObjectCollection onHoldToSaveCollection = this.getOnHoldToSaveCollection(validateResultMap, publicFieldValMap);
        DynamicObjectCollection onHoldToUpdateCollection = this.getOnHoldToUpdateCollection(onHoldObjMap, onHoldToUpdateIdList, publicFieldValMap);
        Integer successCount = 0;
        try (TXHandle txHandle = TX.requiresNew();){
            Object[] updatedOnHoldArr;
            Object[] savedOnHoldArr = onHoldBillService.save(onHoldToSaveCollection);
            if (savedOnHoldArr != null && savedOnHoldArr.length > 0) {
                successCount = successCount + savedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(savedOnHoldArr, true);
                this.retrographyOnHoldId(onHoldObjMap, savedOnHoldArr);
            }
            JSONArray delOnHoldIdArr = OnHoldDetailHelper.getCacheDelOnHoldIdArr(this.pageId);
            delOnHoldIdArr.addAll(onHoldToDeleteIdList);
            if (!delOnHoldIdArr.isEmpty()) {
                onHoldBillService.delete(delOnHoldIdArr.toArray());
                this.clearOnHoldId(onHoldObjMap, (List<Object>)delOnHoldIdArr);
            }
            if ((updatedOnHoldArr = onHoldBillService.save((DynamicObject[])onHoldToUpdateCollection.toArray((Object[])new DynamicObject[0]))) != null && updatedOnHoldArr.length > 0) {
                successCount = successCount + updatedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(updatedOnHoldArr, true);
            }
        }
        AttachmentFieldServiceHelper.saveTempAttachments((String)viewPageId);
        resultMap.put("errorMsgSet", errorMsgSet);
        resultMap.put("failCount", failCount);
        resultMap.put("totalRecordCount", totalRecordCount);
        resultMap.put("successCount", successCount);
        long endTime = System.currentTimeMillis();
        LOGGER.info("[finish saving] total time:{}(ms)", (Object)(endTime - startTime));
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> submitOnHold(Map<String, DynamicObjectCollection> onHoldObjMap, Map<String, Object> publicFieldValMap, String pageId) {
        LOGGER.info("#######starting sumbiting onhold datas#######");
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList<Long> onHoldToDeleteIdList = new ArrayList<Long>(10);
        ArrayList<Long> onHoldToUpdateIdList = new ArrayList<Long>(10);
        Map<String, Object> validateResultMap = this.validateOnHoldInfo(onHoldObjMap, onHoldToUpdateIdList, onHoldToDeleteIdList, publicFieldValMap, false);
        Set errorMsgSet = (Set)validateResultMap.get("errorMsgSet");
        Integer failCount = (Integer)validateResultMap.get("failCount");
        Integer totalRecordCount = (Integer)validateResultMap.get("totalRecordCount");
        SWCDataServiceHelper onHoldBillService = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObjectCollection onHoldToSaveCollection = this.getOnHoldToSaveCollection(validateResultMap, publicFieldValMap);
        DynamicObjectCollection onHoldToUpdateCollection = this.getOnHoldToUpdateCollection(onHoldObjMap, onHoldToUpdateIdList, publicFieldValMap);
        Integer successCount = 0;
        try (TXHandle txHandle = TX.requiresNew();){
            Object[] updatedOnHoldArr;
            Object[] savedOnHoldArr = onHoldBillService.save(OnHoldDetailHelper.modifyOnHoldStatus(onHoldToSaveCollection));
            if (savedOnHoldArr != null && savedOnHoldArr.length > 0) {
                successCount = successCount + savedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(savedOnHoldArr, false);
                this.retrographyOnHoldId(onHoldObjMap, savedOnHoldArr);
            }
            JSONArray delOnHoldIdArr = OnHoldDetailHelper.getCacheDelOnHoldIdArr(this.pageId);
            delOnHoldIdArr.addAll(onHoldToDeleteIdList);
            if (!delOnHoldIdArr.isEmpty()) {
                onHoldBillService.delete(delOnHoldIdArr.toArray());
                this.clearOnHoldId(onHoldObjMap, (List<Object>)delOnHoldIdArr);
            }
            if ((updatedOnHoldArr = onHoldBillService.save((DynamicObject[])OnHoldDetailHelper.modifyOnHoldStatus(onHoldToUpdateCollection).toArray((Object[])new DynamicObject[0]))) != null && updatedOnHoldArr.length > 0) {
                successCount = successCount + updatedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(updatedOnHoldArr, false);
                this.retrographyOnHoldId(onHoldObjMap, updatedOnHoldArr);
            }
        }
        AttachmentFieldServiceHelper.saveTempAttachments((String)pageId);
        try {
            OnHoldMsgHelper.sendOnHoldMsgByBillCollection("onholdbillsubmit", onHoldToSaveCollection, onHoldToUpdateCollection);
        }
        catch (Exception e) {
            LOGGER.error("error occurred during sending message\uff1a{}", (Object)e.getMessage());
        }
        resultMap.put("errorMsgSet", errorMsgSet);
        resultMap.put("failCount", failCount);
        resultMap.put("totalRecordCount", totalRecordCount);
        resultMap.put("successCount", successCount);
        long endTime = System.currentTimeMillis();
        LOGGER.info("[finish saving] sumbit onhold data end total time:{}(ms)", (Object)(endTime - startTime));
        return resultMap;
    }

    private void retrographyOnHoldId(Map<String, DynamicObjectCollection> onHoldObjMap, Object[] onHoldArr) {
        DynamicObjectCollection salaryOnHoldList;
        Map<String, List<DynamicObject>> savedOnHoldObjMap = OnHoldBillService.savedOnHoldAssembleDataMap(onHoldArr);
        Map<String, List<DynamicObject>> salaryFileIdRefOnHoldMap = OnHoldBillService.packageSalaryfileSavedOnHoldInfo(onHoldArr);
        DynamicObjectCollection calPersonOnHoldList = onHoldObjMap.get("caltableList");
        if (!calPersonOnHoldList.isEmpty()) {
            List<DynamicObject> calPersonObjList = savedOnHoldObjMap.get("caltableObjList");
            this.setCaltableOnHoldId(calPersonOnHoldList, calPersonObjList);
        }
        if (!(salaryOnHoldList = onHoldObjMap.get("salaryfileList")).isEmpty()) {
            this.setSalaryfileOnHoldId(salaryOnHoldList, salaryFileIdRefOnHoldMap);
        }
    }

    private void clearOnHoldId(Map<String, DynamicObjectCollection> onHoldObjMap, List<Object> onHoldToDeleteIdList) {
        DynamicObjectCollection caltableOnHoldList = onHoldObjMap.get("caltableList");
        for (DynamicObject caltableOnHold : caltableOnHoldList) {
            String onHoldId = caltableOnHold.getString("caltableonhold");
            if (onHoldToDeleteIdList.indexOf(onHoldId) < 0) continue;
            caltableOnHold.set("caltableonhold", (Object)"");
            caltableOnHold.set("caltablestatus", (Object)"");
        }
        DynamicObjectCollection salaryOnHoldList = onHoldObjMap.get("salaryfileList");
        for (DynamicObject salaryOnHold : salaryOnHoldList) {
            String onHoldId = salaryOnHold.getString("salaryfileonhold");
            if (onHoldToDeleteIdList.indexOf(onHoldId) < 0) continue;
            salaryOnHold.set("salaryfileonhold", (Object)"");
            salaryOnHold.set("salaryfilestatus", (Object)"");
        }
    }

    private void setSalaryfileOnHoldId(DynamicObjectCollection salaryOnHoldCol, Map<String, List<DynamicObject>> salaryfileIdRefOnHoldMap) {
        for (DynamicObject pageOnHoldInfo : salaryOnHoldCol) {
            String pageSalaryfileId = pageOnHoldInfo.getString("salaryfileinfo.id");
            List<DynamicObject> salaryfileOnHoldSavedList = salaryfileIdRefOnHoldMap.get(pageSalaryfileId);
            if (salaryfileOnHoldSavedList == null) continue;
            for (DynamicObject salaryfileSavedObj : salaryfileOnHoldSavedList) {
                Object salaryfileObj = salaryfileSavedObj.get("salaryfile");
                String dbSalaryfileId = "";
                dbSalaryfileId = salaryfileObj instanceof DynamicObject ? ((DynamicObject)salaryfileObj).getString("id") : String.valueOf(salaryfileObj);
                Date pageStartDate = pageOnHoldInfo.getDate("salaryonholdstartdate");
                if (pageStartDate == null) continue;
                String pageIsAllowCal = pageOnHoldInfo.getString("salaryisallowcal");
                String saveIsAllowCal = salaryfileSavedObj.getString("isallowcal");
                Date startDate = salaryfileSavedObj.getDate("startdate");
                if (!pageSalaryfileId.equals(dbSalaryfileId) || !pageStartDate.equals(startDate) || !SWCStringUtils.equals((String)pageIsAllowCal, (String)saveIsAllowCal)) continue;
                pageOnHoldInfo.set("salaryfileonhold", (Object)salaryfileSavedObj.getString("id"));
                pageOnHoldInfo.set("salaryfilestatus", (Object)salaryfileSavedObj.getString("status"));
            }
        }
    }

    private void setCaltableOnHoldId(DynamicObjectCollection onHoldCollection, List<DynamicObject> savedOnHoldObjList) {
        for (DynamicObject pageOnHoldInfo : onHoldCollection) {
            for (DynamicObject dbOnHoldObj : savedOnHoldObjList) {
                String pageCaltableId = pageOnHoldInfo.getString("caltableinfo.id");
                String dbCaltableId = dbOnHoldObj.getString("caltableid");
                Boolean onholdStatus = pageOnHoldInfo.getBoolean("caltableonholdstatus");
                if (!onholdStatus.booleanValue() || !pageCaltableId.equals(dbCaltableId)) continue;
                pageOnHoldInfo.set("caltableonhold", (Object)dbOnHoldObj.getString("id"));
                pageOnHoldInfo.set("caltablestatus", (Object)dbOnHoldObj.getString("status"));
            }
        }
    }

    private DynamicObjectCollection getOnHoldToSaveCollection(Map<String, Object> validateResultMap, Map<String, Object> publicFieldValMap) {
        List correctSalaryOnHoldList;
        DynamicObjectCollection onHoldToSaveColl = new DynamicObjectCollection();
        List correctCalPersonOnHoldList = (List)validateResultMap.get("correctCaltableOnHoldList");
        if (correctCalPersonOnHoldList != null && !correctCalPersonOnHoldList.isEmpty()) {
            DynamicObjectCollection calPersonOnHoldColl = this.saveCalPersonOnHoldInfo(correctCalPersonOnHoldList, publicFieldValMap);
            onHoldToSaveColl.addAll((Collection)calPersonOnHoldColl);
        }
        if ((correctSalaryOnHoldList = (List)validateResultMap.get("correctSalaryOnHoldList")) != null && !correctSalaryOnHoldList.isEmpty()) {
            DynamicObjectCollection salaryOnHoldColl = this.saveSalaryOnHoldInfo(correctSalaryOnHoldList, publicFieldValMap);
            onHoldToSaveColl.addAll((Collection)salaryOnHoldColl);
        }
        return onHoldToSaveColl;
    }

    private DynamicObjectCollection saveCalPersonOnHoldInfo(List<DynamicObject> calPersonOnHoldList, Map<String, Object> publicFieldValMap) {
        DynamicObjectCollection onHoldColl = new DynamicObjectCollection();
        ArrayList<Long> salaryFileIdList = new ArrayList<Long>(calPersonOnHoldList.size());
        calPersonOnHoldList.forEach(calPersonOnHold -> salaryFileIdList.add(calPersonOnHold.getLong("salaryfileent.id")));
        Map<String, DynamicObject> queryCalPersonIdRefSalaryFileObjMap = OnHoldBillHelper.querySalaryFileIdRefSalaryFileObjMap(salaryFileIdList);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_onholdbill");
        for (DynamicObject onHold : calPersonOnHoldList) {
            DynamicObject onHoldBill = this.generateOnHold((DynamicObjectType)type);
            Long onHoldId = onHold.getLong("caltableonhold");
            if (onHoldId != null && onHoldId > 0L) continue;
            onHoldBill.set("person", (Object)onHold.getString("caltableinfo.employee.id"));
            onHoldBill.set("org", (Object)onHold.getString("caltableinfo.org.id"));
            onHoldBill.set("adminorg", (Object)onHold.getString("salaryfileent.adminorg.id"));
            onHoldBill.set("payrollgroup", (Object)onHold.getString("caltaskent.payrollgroupv.id"));
            String salaryFileId = onHold.getString("salaryfileent.id");
            DynamicObject salaryFile = queryCalPersonIdRefSalaryFileObjMap.get(salaryFileId);
            if (salaryFile != null) {
                onHoldBill.set("company", (Object)salaryFile.getString("empposinfo.company.id"));
                onHoldBill.set("department", (Object)salaryFile.getString("empposinfo.adminorg.id"));
                onHoldBill.set("position", (Object)salaryFile.getString("empposinfo.position.id"));
            }
            onHoldBill.set("salaryfile", (Object)salaryFileId);
            onHoldBill.set("caltableid", (Object)onHold.getString("caltableinfo.id"));
            onHoldBill.set("caltask", (Object)onHold.getString("caltaskent.id"));
            onHoldBill.set("payoutitem", (Object)onHold.getString("calpayoutitem.id"));
            onHoldBill.set("calamount", (Object)onHold.getBigDecimal("caltablecalamount"));
            onHoldBill.set("calcurrency", (Object)onHold.getString("caltablecalcurrency.id"));
            onHoldBill.set("startdate", (Object)onHold.getDate("caltablestartdate"));
            onHoldBill.set("enddate", (Object)onHold.getDate("caltableenddate"));
            onHoldBill.set("cause", (Object)onHold.getString("caltableonholdreason.id"));
            onHoldBill.set("attachment", (Object)this.getAttachmentColl((DynamicObjectCollection)publicFieldValMap.get("attachment")));
            onHoldBill.set("remark", publicFieldValMap.get("remark"));
            onHoldBill.set("releasedate", (Object)((Date)publicFieldValMap.get("releasedate")));
            onHoldColl.add((Object)onHoldBill);
        }
        return onHoldColl;
    }

    private DynamicObject generateOnHold(DynamicObjectType type) {
        DynamicObject onHoldBill = (DynamicObject)type.createInstance();
        Long userId = RequestContext.get().getCurrUserId();
        onHoldBill.set("createtime", (Object)new Date());
        onHoldBill.set("creator", (Object)userId);
        onHoldBill.set("billstatus", (Object)"C");
        onHoldBill.set("status", (Object)OnHoldStatusEnum.STATUS_SAVE.getCode());
        onHoldBill.set("modifier", (Object)userId);
        onHoldBill.set("modifytime", (Object)new Date());
        onHoldBill.set("msgstatus", (Object)"0");
        return onHoldBill;
    }

    private DynamicObjectCollection saveSalaryOnHoldInfo(List<DynamicObject> correctSalaryOnHoldList, Map<String, Object> publicFieldValMap) {
        DynamicObjectCollection onHoldColl = new DynamicObjectCollection();
        Map<String, Long> payrollGroupIdRefVidMap = OnHoldBillHelper.queryPayrollGroupVidById(correctSalaryOnHoldList);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_onholdbill");
        for (DynamicObject onHold : correctSalaryOnHoldList) {
            Date startDate = onHold.getDate("salaryonholdstartdate");
            String statusStr = onHold.getString("salaryfilestatus");
            if (SWCStringUtils.isNotEmpty((String)statusStr)) {
                int status = Integer.parseInt(statusStr);
                if (startDate == null || status > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            }
            DynamicObject onHoldBill = this.generateOnHold((DynamicObjectType)type);
            onHoldBill.set("person", (Object)onHold.getString("salaryfileinfo.employee.id"));
            onHoldBill.set("org", (Object)onHold.getString("salaryfileinfo.org.id"));
            onHoldBill.set("payrollgroup", (Object)payrollGroupIdRefVidMap.get(onHold.getString("payrollgroup.id")));
            onHoldBill.set("adminorg", (Object)onHold.getString("salaryfileinfo.adminorg.id"));
            onHoldBill.set("company", (Object)onHold.getLong("company"));
            onHoldBill.set("position", (Object)onHold.getLong("position"));
            onHoldBill.set("department", (Object)onHold.getLong("department"));
            onHoldBill.set("salaryfile", (Object)onHold.getString("salaryfileinfo.id"));
            onHoldBill.set("startdate", (Object)startDate);
            onHoldBill.set("cause", (Object)onHold.getString("salaryonholdreason.id"));
            onHoldBill.set("attachment", (Object)this.getAttachmentColl((DynamicObjectCollection)publicFieldValMap.get("attachment")));
            onHoldBill.set("remark", publicFieldValMap.get("remark"));
            onHoldBill.set("releasedate", (Object)onHold.getDate("salaryreleasedate"));
            onHoldBill.set("isallowcal", (Object)onHold.getString("salaryisallowcal"));
            onHoldColl.add((Object)onHoldBill);
        }
        return onHoldColl;
    }

    private DynamicObjectCollection getAttachmentColl(DynamicObjectCollection attachment) {
        if (attachment == null || attachment.isEmpty()) {
            return null;
        }
        DynamicObjectCollection attachmentColl = new DynamicObjectCollection();
        for (DynamicObject attachmentObj : attachment) {
            DynamicObject fileObj = new DynamicObject((DynamicObjectType)attachmentObj.getDataEntityType());
            fileObj.set("fbasedataid", attachmentObj.get("fbasedataid"));
            fileObj.set("fbasedataid_id", attachmentObj.get("fbasedataid_id"));
            attachmentColl.add((Object)fileObj);
        }
        return attachmentColl;
    }

    private DynamicObjectCollection updateCaltableOnHoldInfo(List<DynamicObject> caltableOnHoldList, Map<String, DynamicObject> onHoldIdRefObjMap, Map<String, Object> publicFieldValMap) {
        DynamicObjectCollection onHoldToUpdateObjColl = new DynamicObjectCollection();
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject caltableOnHold : caltableOnHoldList) {
            DynamicObject onHoldObj;
            Boolean onHoldStatus = (Boolean)caltableOnHold.get("caltableonholdstatus");
            String onHoldId = caltableOnHold.getString("caltableonhold");
            int caltableStatus = caltableOnHold.getInt("caltablestatus");
            if (!onHoldStatus.booleanValue() || onHoldId == null || caltableStatus >= OnHoldStatusEnum.STATUS_ONHOLD.getCode() || (onHoldObj = onHoldIdRefObjMap.get(onHoldId)) == null) continue;
            onHoldObj.set("modifier", (Object)userId);
            onHoldObj.set("modifytime", (Object)new Date());
            onHoldObj.set("cause", (Object)caltableOnHold.getString("caltableonholdreason.id"));
            onHoldObj.set("attachment", (Object)this.getAttachmentColl((DynamicObjectCollection)publicFieldValMap.get("attachment")));
            onHoldObj.set("remark", publicFieldValMap.get("remark"));
            onHoldObj.set("releasedate", (Object)((Date)publicFieldValMap.get("releasedate")));
            onHoldObj.set("msgstatus", (Object)"0");
            onHoldToUpdateObjColl.add((Object)onHoldObj);
        }
        return onHoldToUpdateObjColl;
    }

    private DynamicObjectCollection updateSalaryOnHoldInfo(List<DynamicObject> salaryOnHoldList, Map<String, DynamicObject> onHoldIdRefObjMap, Map<String, Object> publicFieldValMap) {
        DynamicObjectCollection onHoldToUpdateObjColl = new DynamicObjectCollection();
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject salaryfileOnHold : salaryOnHoldList) {
            DynamicObject onHoldObj;
            String onHoldId = salaryfileOnHold.getString("salaryfileonhold");
            int salaryfileStatus = salaryfileOnHold.getInt("salaryfilestatus");
            if (onHoldId == null || salaryfileStatus >= OnHoldStatusEnum.STATUS_ONHOLD.getCode() || (onHoldObj = onHoldIdRefObjMap.get(onHoldId)) == null) continue;
            onHoldObj.set("modifier", (Object)userId);
            onHoldObj.set("modifytime", (Object)new Date());
            onHoldObj.set("startdate", (Object)salaryfileOnHold.getDate("salaryonholdstartdate"));
            onHoldObj.set("cause", (Object)salaryfileOnHold.getString("salaryonholdreason.id"));
            onHoldObj.set("attachment", (Object)this.getAttachmentColl((DynamicObjectCollection)publicFieldValMap.get("attachment")));
            onHoldObj.set("remark", publicFieldValMap.get("remark"));
            onHoldObj.set("releasedate", (Object)salaryfileOnHold.getDate("salaryreleasedate"));
            onHoldObj.set("isallowcal", (Object)salaryfileOnHold.getString("salaryisallowcal"));
            onHoldObj.set("msgstatus", (Object)"0");
            onHoldToUpdateObjColl.add((Object)onHoldObj);
        }
        return onHoldToUpdateObjColl;
    }

    private DynamicObjectCollection getOnHoldToUpdateCollection(Map<String, DynamicObjectCollection> onHoldObjMap, List<Long> onHoldToUpdateIdList, Map<String, Object> publicFieldValMap) {
        DynamicObjectCollection salaryOnHoldList;
        DynamicObjectCollection onHoldToUpdateColl = new DynamicObjectCollection();
        Map<String, DynamicObject> onHoldIdRefObjMap = OnHoldBillHelper.queryOnHoldIdRefObjByIdList(onHoldToUpdateIdList);
        if (onHoldIdRefObjMap.isEmpty()) {
            return onHoldToUpdateColl;
        }
        DynamicObjectCollection caltableOnHoldList = onHoldObjMap.get("caltableList");
        if (caltableOnHoldList != null && !caltableOnHoldList.isEmpty()) {
            DynamicObjectCollection updateCaltableOnHoldInfo = this.updateCaltableOnHoldInfo((List<DynamicObject>)caltableOnHoldList, onHoldIdRefObjMap, publicFieldValMap);
            onHoldToUpdateColl.addAll((Collection)updateCaltableOnHoldInfo);
        }
        if ((salaryOnHoldList = onHoldObjMap.get("salaryfileList")) != null && !salaryOnHoldList.isEmpty()) {
            DynamicObjectCollection updateSalaryOnHoldInfo = this.updateSalaryOnHoldInfo((List<DynamicObject>)salaryOnHoldList, onHoldIdRefObjMap, publicFieldValMap);
            onHoldToUpdateColl.addAll((Collection)updateSalaryOnHoldInfo);
        }
        return onHoldToUpdateColl;
    }

    private Map<String, Object> validateOnHoldInfo(Map<String, DynamicObjectCollection> onHoldObjMap, List<Long> onHoldToUpdateIdList, List<Long> onHoldToDeleteIdList, Map<String, Object> publicFieldValMap, boolean isSave) {
        HashMap<String, Object> validateResultMap = new HashMap<String, Object>(16);
        HashSet errorMsgSet = new HashSet(16);
        DynamicObjectCollection errorCalPersonList = new DynamicObjectCollection();
        DynamicObjectCollection errorSalaryFileList = new DynamicObjectCollection();
        DynamicObjectCollection calPersonOnHoldList = onHoldObjMap.get("caltableList");
        Map<String, Object> validateCalPersonResultMap = this.validateCalPerson((List<DynamicObject>)calPersonOnHoldList, errorCalPersonList, onHoldToUpdateIdList, onHoldToDeleteIdList, isSave);
        Set calPersonErrorMsgSet = (Set)validateCalPersonResultMap.get("errorMsgSet");
        Integer calPersonFailCount = (Integer)validateCalPersonResultMap.get("failCount");
        Integer calPersonTotalCount = (Integer)validateCalPersonResultMap.get("totalCount");
        List correctCalPersonOnHoldList = (List)validateCalPersonResultMap.get("correctCaltableOnHoldList");
        DynamicObjectCollection salaryFileOnHoldList = onHoldObjMap.get("salaryfileList");
        Map<String, Object> validateSalaryResultMap = this.validateSalary((List<DynamicObject>)salaryFileOnHoldList, errorSalaryFileList, onHoldToUpdateIdList, onHoldToDeleteIdList, isSave);
        Set salaryErrorMsgSet = (Set)validateSalaryResultMap.get("errorMsgSet");
        Integer salaryFailCount = (Integer)validateSalaryResultMap.get("failCount");
        Integer salaryTotalCount = (Integer)validateSalaryResultMap.get("totalCount");
        List correctSalaryOnHoldList = (List)validateSalaryResultMap.get("correctSalaryOnHoldList");
        Integer totalRecordCount = calPersonTotalCount + salaryTotalCount;
        Integer failCount = calPersonFailCount + salaryFailCount;
        boolean releaseDateFlag = this.validateReleaseDate(onHoldObjMap, publicFieldValMap, calPersonErrorMsgSet);
        if (releaseDateFlag) {
            correctCalPersonOnHoldList.clear();
            correctSalaryOnHoldList.clear();
            onHoldToUpdateIdList.clear();
        }
        errorMsgSet.addAll(calPersonErrorMsgSet);
        errorMsgSet.addAll(salaryErrorMsgSet);
        validateResultMap.put("errorMsgSet", errorMsgSet);
        validateResultMap.put("failCount", failCount);
        validateResultMap.put("totalRecordCount", totalRecordCount);
        validateResultMap.put("correctCaltableOnHoldList", correctCalPersonOnHoldList);
        validateResultMap.put("correctSalaryOnHoldList", correctSalaryOnHoldList);
        return validateResultMap;
    }

    private boolean validateReleaseDate(Map<String, DynamicObjectCollection> onHoldObjMap, Map<String, Object> publicFieldValMap, Set<String> errorMsgSet) {
        boolean releaseDateFlag = false;
        String minDateStr = this.getMinDate(onHoldObjMap);
        Date releaseDate = (Date)publicFieldValMap.get("releasedate");
        if (minDateStr == null || releaseDate == null) {
            return false;
        }
        String minDate = minDateStr.substring(minDateStr.indexOf(45) + 1);
        if (SWCDateTimeUtils.format((Date)releaseDate).compareTo(minDate) < 0) {
            releaseDateFlag = true;
            String errorMsg = ResManager.loadKDString((String)"\u8ba1\u5212\u89e3\u85aa\u65e5\u671f\u9700\u665a\u4e8e\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u3002", (String)"OnHoldDetailService_17", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            if (minDateStr.startsWith("caltable")) {
                errorMsg = ResManager.loadKDString((String)"\u8ba1\u5212\u89e3\u85aa\u65e5\u671f\u65e9\u4e8e\u505c\u7f13\u53d1\u6240\u5c5e\u5e74\u6708\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u7684\u8ba1\u5212\u89e3\u85aa\u65e5\u671f\u8fdb\u884c\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailService_18", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            }
            errorMsgSet.add(String.format(errorMsg, new Object[0]));
        }
        return releaseDateFlag;
    }

    private String getMinDate(Map<String, DynamicObjectCollection> onHoldObjMap) {
        DynamicObjectCollection calPersonOnHoldList = onHoldObjMap.get("caltableList");
        Date calPersonMinDate = null;
        if (calPersonOnHoldList != null && !calPersonOnHoldList.isEmpty()) {
            ArrayList<Object> calPersonDateList = new ArrayList<Object>(calPersonOnHoldList.size());
            for (DynamicObject calPersonOnHold : calPersonOnHoldList) {
                Date startDate = calPersonOnHold.getDate("caltablestartdate");
                calPersonDateList.add(startDate);
            }
            calPersonMinDate = (Date)Collections.min(calPersonDateList);
        }
        DynamicObjectCollection salaryFileOnHoldList = onHoldObjMap.get("salaryfileList");
        Date salaryFileMinDate = null;
        if (salaryFileOnHoldList != null && !salaryFileOnHoldList.isEmpty()) {
            ArrayList<Date> salaryFileDateList = new ArrayList<Date>(salaryFileOnHoldList.size());
            for (DynamicObject salaryFileOnHold : salaryFileOnHoldList) {
                Date startDate = salaryFileOnHold.getDate("startdate");
                if (startDate == null) continue;
                salaryFileDateList.add(startDate);
            }
            if (salaryFileDateList.isEmpty()) {
                return null;
            }
            salaryFileMinDate = (Date)Collections.min(salaryFileDateList);
        }
        StringBuilder builder = new StringBuilder();
        if (calPersonMinDate == null && salaryFileMinDate == null) {
            return null;
        }
        if (calPersonMinDate == null) {
            return builder.append("salary").append('-').append(SWCDateTimeUtils.format(salaryFileMinDate)).toString();
        }
        if (salaryFileMinDate == null) {
            return builder.append("caltable").append('-').append(SWCDateTimeUtils.format((Date)calPersonMinDate)).toString();
        }
        String minDate = calPersonMinDate.compareTo(salaryFileMinDate) > 0 ? builder.append("salary").append('-').append(SWCDateTimeUtils.format(salaryFileMinDate)).toString() : builder.append("caltable").append('-').append(SWCDateTimeUtils.format((Date)calPersonMinDate)).toString();
        return minDate;
    }

    private Map<String, Object> validateCalPerson(List<DynamicObject> calPersonOnHoldList, DynamicObjectCollection errorCol, List<Long> onHoldToUpdateIdList, List<Long> onHoldToDeleteIdList, boolean isSave) {
        LOGGER.info("starting validating calTask");
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> validateResultMap = new HashMap<String, Object>(16);
        Integer failCount = 0;
        Integer totalCount = 0;
        int calPersonListSize = calPersonOnHoldList.size();
        HashSet<String> errorMsgSet = new HashSet<String>(16);
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(calPersonListSize);
        ArrayList<Long> onHoldIdList = new ArrayList<Long>(calPersonListSize);
        ArrayList<DynamicObject> correctCalPersonOnHoldList = new ArrayList<DynamicObject>(calPersonListSize);
        for (DynamicObject calPersonOnHold : calPersonOnHoldList) {
            calPersonIdList.add(calPersonOnHold.getLong("caltableinfo.id"));
            onHoldIdList.add(Long.valueOf(calPersonOnHold.getString("caltableonhold")));
            long l = calPersonOnHold.getLong("caltableinfo.salaryfile.id");
        }
        Map<String, DynamicObject> onHoldIdRefIdMap = OnHoldBillHelper.queryOnHoldIdRefObjByIdList(onHoldIdList);
        Map<String, DynamicObject> payedCalPersonMap = OnHoldBillHelper.queryPayedCalPersonMap(calPersonIdList);
        Map<String, DynamicObject> onHoldCalPersonMap = OnHoldBillHelper.queryOnHoldedCalPersonMap(calPersonIdList);
        Set<String> calIds = OnHoldBillHelper.validateSalaryFilePayDetail(calPersonIdList);
        PayStateService payStateService = new PayStateService();
        for (DynamicObject calPersonOnHold : calPersonOnHoldList) {
            boolean isBankOfferExported;
            boolean isCorrectFlag = true;
            Boolean onHoldStatus = calPersonOnHold.getBoolean("caltableonholdstatus");
            int calPersonStatus = calPersonOnHold.getInt("caltablestatus");
            String onHoldId = calPersonOnHold.getString("caltableonhold");
            DynamicObject onHoldDb = onHoldIdRefIdMap.get(onHoldId);
            if (!onHoldStatus.booleanValue()) {
                if (onHoldId == null || onHoldDb == null || onHoldDb.getInt("status") != OnHoldStatusEnum.STATUS_SAVE.getCode()) continue;
                onHoldToDeleteIdList.add(Long.valueOf(onHoldId));
                continue;
            }
            if (calPersonStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            Integer n = totalCount;
            Integer n2 = totalCount = Integer.valueOf(totalCount + 1);
            if (errorCol.indexOf((Object)calPersonOnHold) >= 0) {
                n = failCount;
                n2 = failCount = Integer.valueOf(failCount + 1);
                continue;
            }
            if (this.validateCalPersonPayStatus(calPersonOnHold, payedCalPersonMap, errorMsgSet, payStateService, isSave)) {
                n = failCount;
                n2 = failCount = Integer.valueOf(failCount + 1);
                isCorrectFlag = false;
            }
            if (this.validateCalPersonOnHoldStatus(calPersonOnHold, onHoldCalPersonMap, errorMsgSet, onHoldToUpdateIdList, isSave)) {
                n = failCount;
                n2 = failCount = Integer.valueOf(failCount + 1);
                isCorrectFlag = false;
            }
            if (isBankOfferExported = this.validatePayDetailBankOfferStatus(calPersonOnHold, errorMsgSet, calIds)) {
                n2 = failCount;
                Integer n3 = failCount = Integer.valueOf(failCount + 1);
                isCorrectFlag = false;
            }
            if (!isCorrectFlag) continue;
            if (onHoldId != null && onHoldDb != null) {
                onHoldToUpdateIdList.add(Long.valueOf(onHoldId));
                continue;
            }
            correctCalPersonOnHoldList.add(calPersonOnHold);
        }
        validateResultMap.put("errorMsgSet", errorMsgSet);
        validateResultMap.put("failCount", failCount);
        validateResultMap.put("totalCount", totalCount);
        validateResultMap.put("correctCaltableOnHoldList", correctCalPersonOnHoldList);
        long endTime = System.currentTimeMillis();
        LOGGER.info("[finish saving] finish validating caltask total time:{}(ms)", (Object)(endTime - startTime));
        return validateResultMap;
    }

    private boolean validateCalPersonPayStatus(DynamicObject calPersonOnHold, Map<String, DynamicObject> payedCalPersonMap, Set<String> errorMsgSet, PayStateService payStateService, boolean isSave) {
        String calPersonId = calPersonOnHold.getString("caltableinfo.id");
        DynamicObject payedCalPersonObj = payedCalPersonMap.get(calPersonId);
        String salaryFileNumber = calPersonOnHold.getString("caltableinfo.salaryfile.number");
        String calTaskNumber = calPersonOnHold.getString("caltableinfo.caltask.number");
        String errorMsg = "";
        if (payedCalPersonObj != null) {
            String payStatus = payedCalPersonObj.getString("paystatus");
            errorMsg = isSave ? MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff1a{0}\uff0c\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a{1}{2}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailService_0", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), salaryFileNumber, calTaskNumber, payStateService.getDescByCode(payStatus)) : MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff1a{0}\uff0c\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a{1}{2}\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldDetailService_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), salaryFileNumber, calTaskNumber, payStateService.getDescByCode(payStatus));
            errorMsgSet.add(errorMsg);
            return true;
        }
        return false;
    }

    private boolean validateCalPersonOnHoldStatus(DynamicObject calPersonOnHold, Map<String, DynamicObject> onHoldCalPersonMap, Set<String> errorMsgSet, List<Long> onHoldToUpdateIdList, boolean isSave) {
        String calPersonId = calPersonOnHold.getString("caltableinfo.id");
        String onHoldId = calPersonOnHold.getString("caltableonhold");
        DynamicObject onHoldCalPersonObj = onHoldCalPersonMap.get(calPersonId);
        if (onHoldCalPersonObj != null) {
            String onHoldCalPersonObjId = onHoldCalPersonObj.getString("id");
            int onHoldStatus = onHoldCalPersonObj.getInt("status");
            if (SWCStringUtils.equals((String)onHoldId, (String)onHoldCalPersonObjId) && (OnHoldStatusEnum.STATUS_SAVE.getCode() == onHoldStatus || OnHoldStatusEnum.STATUS_RELEASE.getCode() == onHoldStatus)) {
                return false;
            }
            JSONArray delOnHoldIdArr = OnHoldDetailHelper.getCacheDelOnHoldIdArr(this.pageId);
            if (delOnHoldIdArr != null && delOnHoldIdArr.indexOf((Object)onHoldCalPersonObjId) >= 0) {
                return false;
            }
            Date startDate = onHoldCalPersonObj.getDate("startdate");
            Date endDate = onHoldCalPersonObj.getDate("enddate");
            String calTaskNumber = calPersonOnHold.getString("caltableinfo.caltask.number");
            if (!(OnHoldStatusEnum.STATUS_SAVE.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_RELEASE.getCode() != onHoldStatus || isSave)) {
                calPersonOnHold.set("caltableonhold", (Object)onHoldCalPersonObjId);
                onHoldToUpdateIdList.add(Long.valueOf(onHoldCalPersonObjId));
            } else {
                String errorContent = OnHoldDetailHelper.getCalSalaryFileErrorMsg(isSave, true, onHoldStatus);
                String errorMsg = MessageFormat.format(errorContent, calTaskNumber, SWCDateTimeUtils.format((Date)startDate, (String)"yyyy/MM/dd"), SWCDateTimeUtils.format((Date)endDate, (String)"yyyy/MM/dd"), OnHoldStatusEnum.getDesc((Integer)onHoldStatus));
                errorMsgSet.add(errorMsg);
                return true;
            }
        }
        return false;
    }

    private boolean validateCalSalaryOnHoldStatus(DynamicObject calPersonOnHold, Set<String> errorMsgSet, List<DynamicObject> onHoldSalaryObjList, boolean isSave) {
        boolean isOnHold = false;
        if (onHoldSalaryObjList == null || onHoldSalaryObjList.isEmpty()) {
            return isOnHold;
        }
        Date calPersonStartDate = calPersonOnHold.getDate("caltablestartdate");
        Date calPersonEndDate = calPersonOnHold.getDate("caltableenddate");
        String calTaskNumber = calPersonOnHold.getString("caltableinfo.caltask.number");
        String pageOnHoldId = calPersonOnHold.getString("caltableonhold");
        String errorContent = "";
        String errorMsg = "";
        for (DynamicObject onHoldSalaryObj : onHoldSalaryObjList) {
            int onHoldStatus = onHoldSalaryObj.getInt("status");
            Date startDate = onHoldSalaryObj.getDate("startdate");
            Date endDate = onHoldSalaryObj.getDate("enddate");
            String onHoldId = onHoldSalaryObj.getString("id");
            if (SWCStringUtils.equals((String)pageOnHoldId, (String)onHoldId) || calPersonEndDate.before(SWCDateTimeUtils.getDayDate((Date)startDate)) || calPersonStartDate.after(SWCDateTimeUtils.getDayDate((Date)endDate))) continue;
            isOnHold = true;
            errorContent = OnHoldDetailHelper.getCalSalaryFileErrorMsg(isSave, true, onHoldStatus);
            errorMsg = MessageFormat.format(errorContent, calTaskNumber, SWCDateTimeUtils.format((Date)startDate, (String)"yyyy/MM/dd"), SWCDateTimeUtils.format((Date)endDate, (String)"yyyy/MM/dd"), OnHoldStatusEnum.getDesc((Integer)onHoldStatus));
            errorMsgSet.add(errorMsg);
        }
        return isOnHold;
    }

    private boolean validatePayDetailBankOfferStatus(DynamicObject calPersonOnHold, Set<String> errorMsgSet, Set<String> calIds) {
        String calTableId = calPersonOnHold.getString("caltableinfo.id");
        if (calIds.contains(calTableId)) {
            String calTaskNumber = calPersonOnHold.getString("caltableinfo.caltask.number");
            String errorMsg = "";
            errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a%s\u4e2d\u7684\u6838\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u53d1\u653e\u660e\u7ec6\uff0c\u5e76\u5df2\u5bfc\u51fa\u62a5\u76d8\u6587\u4ef6\u3002\u8bf7\u786e\u8ba4\u62a5\u76d8\u6587\u4ef6\u4e2d\u7684\u660e\u7ec6\u5747\u672a\u4ed8\u6b3e\u4e14\u5df2\u5931\u6548\uff0c\u4ee5\u907f\u514d\u91cd\u590d\u652f\u4ed8\u3002", (String)"OnHoldDetailService_16", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), calTaskNumber);
            errorMsgSet.add(errorMsg);
            return true;
        }
        return false;
    }

    private Map<String, Object> validateSalary(List<DynamicObject> salaryFileOnHoldList, DynamicObjectCollection errorCol, List<Long> onHoldToUpdateIdList, List<Long> onHoldToDeleteIdList, boolean isSave) {
        LOGGER.info("starting validating salary file");
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> validateResultMap = new HashMap<String, Object>(16);
        Integer failCount = 0;
        Integer totalCount = 0;
        int salaryFileOnHoldListSize = salaryFileOnHoldList.size();
        HashSet<String> errorMsgSet = new HashSet<String>(16);
        ArrayList<Long> salaryIdList = new ArrayList<Long>(salaryFileOnHoldListSize);
        ArrayList<Long> onHoldIdList = new ArrayList<Long>(salaryFileOnHoldListSize);
        HashSet<Long> employeeIdSet = new HashSet<Long>(salaryFileOnHoldListSize);
        for (DynamicObject salaryFileOnHold : salaryFileOnHoldList) {
            employeeIdSet.add(salaryFileOnHold.getLong("salaryfileinfo.employee.id"));
            salaryIdList.add(salaryFileOnHold.getLong("salaryfileinfo.id"));
            onHoldIdList.add(Long.valueOf(salaryFileOnHold.getString("salaryfileonhold")));
        }
        ArrayList<DynamicObject> correctSalaryOnHoldList = new ArrayList<DynamicObject>(salaryFileOnHoldListSize);
        Map<String, List<DynamicObject>> onHoldSalaryMap = OnHoldBillHelper.queryOnHoldedSalaryMap(salaryIdList);
        Map<String, DynamicObject> onHoldIdRefIdMap = OnHoldBillHelper.queryOnHoldIdRefObjByIdList(onHoldIdList);
        Map<String, List<DynamicObject>> personRefSalaryListMap = OnHoldBillHelper.queryPersonRefSalaryListAssembleData(employeeIdSet);
        for (DynamicObject pageSalaryOnHold : salaryFileOnHoldList) {
            Integer n;
            LOGGER.info("\u6821\u9a8c\u85aa\u8d44\u6863\u6848 validateSalary\uff0c pageSalaryOnHoldStartDate = {}, pageSalaryOnHoldEndDate = {}", (Object)pageSalaryOnHold.getDate("startdate"), (Object)pageSalaryOnHold.getDate("enddate"));
            boolean isCorrectFlag = true;
            int seq = pageSalaryOnHold.getInt("seq");
            int salaryFileStatus = pageSalaryOnHold.getInt("salaryfilestatus");
            String onHoldId = pageSalaryOnHold.getString("salaryfileonhold");
            DynamicObject onHoldDb = onHoldIdRefIdMap.get(onHoldId);
            if (salaryFileStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            Integer n2 = totalCount;
            Integer n3 = totalCount = Integer.valueOf(totalCount + 1);
            if (errorCol.indexOf((Object)pageSalaryOnHold) >= 0) {
                n2 = failCount;
                n3 = failCount = Integer.valueOf(failCount + 1);
                continue;
            }
            boolean isOnHold = this.validateSalaryOnHoldStatus(pageSalaryOnHold, errorMsgSet, onHoldSalaryMap, onHoldToUpdateIdList, isSave);
            if (isOnHold) {
                isCorrectFlag = false;
                n3 = failCount;
                Integer n4 = failCount = Integer.valueOf(failCount + 1);
                String pageOnHoldId = pageSalaryOnHold.getString("salaryfileonhold");
                if (!SWCStringUtils.isNotEmpty((String)pageOnHoldId)) continue;
                onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
                continue;
            }
            boolean isNull = this.validateSalaryDateIsNull(pageSalaryOnHold, errorMsgSet, seq, isSave, personRefSalaryListMap);
            if (isNull) {
                isCorrectFlag = false;
                Integer n5 = failCount;
                Integer n6 = failCount = Integer.valueOf(failCount + 1);
                String pageOnHoldId = pageSalaryOnHold.getString("salaryfileonhold");
                if (!SWCStringUtils.isNotEmpty((String)pageOnHoldId)) continue;
                onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
                continue;
            }
            boolean isEarly = this.validateSalaryStartDateEarlyReleaseDate(pageSalaryOnHold, errorMsgSet, seq, isSave);
            if (isEarly) {
                isCorrectFlag = false;
                Integer n7 = failCount;
                n = failCount = Integer.valueOf(failCount + 1);
                String pageOnHoldId = pageSalaryOnHold.getString("salaryfileonhold");
                if (!SWCStringUtils.isNotEmpty((String)pageOnHoldId)) continue;
                onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
                continue;
            }
            boolean isOver = this.validateSalaryDateIsOver(pageSalaryOnHold, errorMsgSet);
            if (isOver) {
                isCorrectFlag = false;
                n = failCount;
                Integer n8 = failCount = Integer.valueOf(failCount + 1);
                String pageOnHoldId = pageSalaryOnHold.getString("salaryfileonhold");
                if (!SWCStringUtils.isNotEmpty((String)pageOnHoldId)) continue;
                onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
                continue;
            }
            if (!isCorrectFlag) continue;
            if (onHoldId != null && onHoldDb != null) {
                onHoldToUpdateIdList.add(Long.valueOf(onHoldId));
                continue;
            }
            correctSalaryOnHoldList.add(pageSalaryOnHold);
        }
        validateResultMap.put("errorMsgSet", errorMsgSet);
        validateResultMap.put("failCount", failCount);
        validateResultMap.put("totalCount", totalCount);
        validateResultMap.put("correctSalaryOnHoldList", correctSalaryOnHoldList);
        long endTime = System.currentTimeMillis();
        LOGGER.info("[finish saving] finish validating salary file total time:{}(ms)", (Object)(endTime - startTime));
        return validateResultMap;
    }

    private boolean validateSalaryStartDateEarlyReleaseDate(DynamicObject salaryOnoldInfoMap, Set<String> errorMsgSet, int index, boolean isSave) {
        boolean isEarly = false;
        Date releaseDate = salaryOnoldInfoMap.getDate("salaryreleasedate");
        Date startDate = salaryOnoldInfoMap.getDate("salaryonholdstartdate");
        if (releaseDate == null || startDate == null) {
            return isEarly;
        }
        if (releaseDate.getTime() <= startDate.getTime()) {
            String errorMsgNew = MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u7b2c{0}\u884c\u6570\u636e\uff1a\u8ba1\u5212\u89e3\u85aa\u65e5\u671f\u5e94\u665a\u4e8e\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u586b\u5199\u6709\u6548\u7684\u8ba1\u5212\u89e3\u85aa\u65e5\u671f\u3002", (String)"OnHoldDetailService_19", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), index);
            errorMsgSet.add(errorMsgNew);
            isEarly = true;
        }
        return isEarly;
    }

    private boolean validateSalaryDateIsNull(DynamicObject pageSalaryOnHold, Set<String> errorMsgSet, int index, boolean isSave, Map<String, List<DynamicObject>> personRefSalaryListMap) {
        boolean isNull = false;
        String salaryfileNumber = pageSalaryOnHold.getString("salaryfileinfo.number");
        Long personId = pageSalaryOnHold.getLong("salaryfileinfo.employee.id");
        String personName = "";
        List<DynamicObject> salaryFileList = personRefSalaryListMap.get(String.valueOf(personId));
        if (salaryFileList != null && salaryFileList.size() > 0) {
            DynamicObject salaryFileObj = salaryFileList.get(0);
            personName = salaryFileObj.getString("employee.person.name");
        }
        String personNo = pageSalaryOnHold.getString("salaryfileinfo.employee.empnumber");
        String cacheStartDateStr = pageSalaryOnHold.getString("salaryonholdstartdate");
        String isAllowCal = pageSalaryOnHold.getString("salaryisallowcal");
        StringBuilder errorBuilder = new StringBuilder();
        if (SWCStringUtils.isEmpty((String)cacheStartDateStr)) {
            if (SWCStringUtils.isEmpty((String)isAllowCal)) {
                if (isSave) {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u548c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_34", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, index));
                } else {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u548c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldBillService_35", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, index));
                }
                isNull = true;
            } else {
                if (isSave) {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailService_20", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, index));
                } else {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldDetailService_21", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, index));
                }
                isNull = true;
            }
            errorMsgSet.add(errorBuilder.toString());
        } else if (SWCStringUtils.isEmpty((String)isAllowCal)) {
            if (isSave) {
                errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_36", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, index));
            } else {
                errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldBillService_37", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, index));
            }
            isNull = true;
            errorMsgSet.add(errorBuilder.toString());
        }
        return isNull;
    }

    private boolean validateSalaryDateIsOver(DynamicObject pageSalaryOnHold, Set<String> errorMsgSet) {
        boolean isOver = false;
        Date pageStartDate = pageSalaryOnHold.getDate("salaryonholdstartdate");
        if (pageStartDate == null) {
            return isOver;
        }
        Date salaryFirstBred = pageSalaryOnHold.getDate("salaryfileinfo.firstbsed");
        Date salaryBrled = pageSalaryOnHold.getDate("salaryfileinfo.bsled");
        if (pageStartDate.after(salaryBrled) || pageStartDate.before(salaryFirstBred)) {
            isOver = true;
            String salaryfileNumber = pageSalaryOnHold.getString("salaryfileinfo.number");
            String salaryFirstBredStr = SWCInteDateTimeUtil.formateDate((Date)salaryFirstBred);
            String salaryBrledStr = SWCInteDateTimeUtil.formateDate((Date)salaryBrled);
            errorMsgSet.add(MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u6709\u6548\u671f\u4e3a{1}~{2}\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u533a\u95f4\u8fdb\u884c\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailService_6", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), salaryfileNumber, salaryFirstBredStr, salaryBrledStr));
        }
        return isOver;
    }

    private boolean validateSalaryIsContainsCaltable(DynamicObject pageSalaryOnHold, Set<String> errorMsgSet, List<DynamicObject> calPersonList) {
        boolean isContain = false;
        if (calPersonList == null || calPersonList.isEmpty()) {
            return isContain;
        }
        Date pageStartDate = pageSalaryOnHold.getDate("startdate");
        if (pageStartDate == null) {
            return isContain;
        }
        Date pageEnddate = pageSalaryOnHold.getDate("enddate");
        pageStartDate = SWCDateTimeUtils.getDayDate((Date)pageStartDate);
        pageEnddate = SWCDateTimeUtils.getDayDate((Date)pageEnddate);
        LOGGER.info("\u6821\u9a8c\u85aa\u8d44\u6863\u6848 validateSalaryIsContainsCaltable\uff0c pageStartDate = {}, pageEnddate = {}", (Object)pageStartDate, (Object)pageEnddate);
        for (DynamicObject calPerson : calPersonList) {
            Date startDate = calPerson.getDate("caltask.STARTDATE");
            Date endDate = calPerson.getDate("caltask.ENDDATE");
            if (startDate == null || endDate == null) continue;
            Date caltaskStartDate = SWCDateTimeUtils.getDayDate((Date)startDate);
            Date caltaskEndDate = SWCDateTimeUtils.getDayDate((Date)endDate);
            LOGGER.info("\u6821\u9a8c\u85aa\u8d44\u6863\u6848 validateSalaryIsContainsCaltable\uff0c caltaskStartDate = {}, caltaskEndDate = {}", (Object)caltaskStartDate, (Object)caltaskEndDate);
            if (pageStartDate.after(caltaskEndDate) || pageEnddate.before(caltaskStartDate) || SWCDateTimeUtils.format((Date)caltaskStartDate, (String)"yyyy/MM/dd").equals(SWCDateTimeUtils.format((Date)pageStartDate, (String)"yyyy/MM/dd")) && SWCDateTimeUtils.format((Date)caltaskEndDate, (String)"yyyy/MM/dd").equals(SWCDateTimeUtils.format((Date)pageEnddate, (String)"yyyy/MM/dd"))) continue;
            isContain = true;
            String salaryfileNumber = pageSalaryOnHold.getString("salaryfileinfo.number");
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u9700\u9009\u62e9\u5b8c\u6574\u7684\u85aa\u8d44\u8d77\u6b62\u65e5\u671f({1}~{2})\u4e3a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u505c\u7f13\u53d1\u533a\u95f4\u3002", (String)"OnHoldDetailService_7", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), salaryfileNumber, SWCDateTimeUtils.format((Date)caltaskStartDate, (String)"yyyy/MM/dd"), SWCDateTimeUtils.format((Date)caltaskEndDate, (String)"yyyy/MM/dd"));
            errorMsgSet.add(errorMsg);
            return isContain;
        }
        return isContain;
    }

    private boolean validateSalaryOnHoldStatus(DynamicObject pageSalaryOnHold, Set<String> errorMsgSet, Map<String, List<DynamicObject>> onHoldSalaryMap, List<Long> onHoldToUpdateIdList, boolean isSave) {
        boolean isOnHold = false;
        Date pageStartDate = pageSalaryOnHold.getDate("salaryonholdstartdate");
        if (pageStartDate == null) {
            return isOnHold;
        }
        String salaryFileId = pageSalaryOnHold.getString("salaryfileinfo.id");
        List<DynamicObject> onHoldSalaryObjList = onHoldSalaryMap.get(salaryFileId);
        if (onHoldSalaryObjList == null || onHoldSalaryObjList.size() == 0) {
            return isOnHold;
        }
        String pageOnHoldId = pageSalaryOnHold.getString("salaryfileonhold");
        boolean isUpdate = true;
        for (DynamicObject dynamicObject : onHoldSalaryObjList) {
            String isAllowCal = dynamicObject.getString("isallowcal");
            if (SWCStringUtils.isEmpty((String)isAllowCal)) continue;
            String onHoldId = dynamicObject.getString("id");
            if (SWCStringUtils.equals((String)pageOnHoldId, (String)onHoldId)) {
                int onHoldStatus = dynamicObject.getInt("status");
                if (OnHoldStatusEnum.STATUS_SAVE.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_RELEASE.getCode() != onHoldStatus) continue;
                onHoldToUpdateIdList.add(Long.valueOf(onHoldId));
                continue;
            }
            isUpdate = false;
        }
        if (isUpdate) {
            return isOnHold;
        }
        boolean isExit = false;
        for (DynamicObject onHoldSalaryObj : onHoldSalaryObjList) {
            String onHoldId;
            Date startDate = onHoldSalaryObj.getDate("startdate");
            if (startDate == null || SWCStringUtils.equals((String)pageOnHoldId, (String)(onHoldId = onHoldSalaryObj.getString("id")))) continue;
            int onHoldStatus = onHoldSalaryObj.getInt("status");
            if (OnHoldStatusEnum.STATUS_SAVE.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_ONHOLD.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_STOPPAY.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_TOPAY.getCode() != onHoldStatus) continue;
            isExit = true;
            break;
        }
        if (isExit) {
            String string = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5b58\u5728\u672a\u89e3\u85aa\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u505c\u7f13\u53d1\u6570\u636e\uff0c\u8bf7\u5728\u539f\u6570\u636e\u4e0a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OnHoldDetailService_22", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            isOnHold = true;
            errorMsgSet.add(string);
        }
        return isOnHold;
    }

    private Set<String> validateSalaryDate(List<DynamicObject> salaryFileOnHoldList, Set<String> errorMsgSet, boolean isSave) {
        HashSet<String> salaryIndexSet = new HashSet<String>(salaryFileOnHoldList.size());
        for (int i = 0; i < salaryFileOnHoldList.size(); ++i) {
            DynamicObject salaryOnHold = salaryFileOnHoldList.get(i);
            String salaryIndex = salaryOnHold.getString("seq");
            Date cacheStartDate = salaryOnHold.getDate("startdate");
            Date cacheEndDate = salaryOnHold.getDate("enddate");
            Boolean onHoldStatus = salaryOnHold.getBoolean("salaryonholdstatus");
            int salaryFileStatus = salaryOnHold.getInt("salaryfilestatus");
            String salaryfileNumber = salaryOnHold.getString("salaryfileinfo.number");
            if (!onHoldStatus.booleanValue() || SWCObjectUtils.isEmpty((Object)cacheStartDate) || salaryFileStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            for (int j = i + 1; j < salaryFileOnHoldList.size(); ++j) {
                DynamicObject salaryOnHoldInfo = salaryFileOnHoldList.get(j);
                Date startDate = salaryOnHoldInfo.getDate("startdate");
                Date endDate = salaryOnHoldInfo.getDate("enddate");
                Boolean status = salaryOnHoldInfo.getBoolean("salaryonholdstatus");
                int salaryStatus = salaryOnHoldInfo.getInt("salaryfilestatus");
                String salaryNumber = salaryOnHoldInfo.getString("salaryfileinfo.number");
                if (!status.booleanValue() || SWCObjectUtils.isEmpty((Object)startDate) || salaryStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode() || !salaryfileNumber.equals(salaryNumber) || endDate.before(cacheStartDate) || startDate.after(cacheEndDate)) continue;
                StringBuilder errorBuilder = new StringBuilder();
                String index = String.valueOf(salaryOnHoldInfo.get("seq"));
                if (isSave) {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7b2c{0}\u548c\u7b2c{1}\u884c\u505c\u7f13\u53d1\u533a\u95f4\u91cd\u53e0\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailService_10", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), salaryIndex, index));
                } else {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7b2c{0}\u548c\u7b2c{1}\u884c\u505c\u7f13\u53d1\u533a\u95f4\u91cd\u53e0\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldDetailService_11", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), salaryIndex, index));
                }
                errorMsgSet.add(errorBuilder.toString());
                salaryIndexSet.add(salaryIndex);
                salaryIndexSet.add(index);
            }
        }
        return salaryIndexSet;
    }
}

