/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.openapi.bizdata.service;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.bizdata.service.BizDataServiceHelper;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataDeleteDataModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataDeleteMainModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataDepempMainModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataDepempMapModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataSalaryFileMainModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataSalaryFileMapModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataUpdateBsledDataModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizDataUpdateBsledMainModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.BizItemPropDataModel;
import kd.swc.hsas.business.openapi.bizdata.model.request.PersonChangeModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.BizDataCommonResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.BizDataDeleteResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.BizDataUpdateBsledResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.BizItemPropErrorResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.BizItemPropInfoResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.CurrencyInfoResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.QueryBizDataResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.QueryBizItemInfoResponseModel;
import kd.swc.hsas.business.openapi.bizdata.model.response.QueryPayRollGroupResponseModel;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataOpenApiService {
    private static final Log logger = LogFactory.getLog(BizDataOpenApiService.class);
    private static final int BIZDATACODE_MAXCOUNT = 10000;
    private static final int BIZDATA_MAXCOUNT = 500;

    public CustomApiResult<List<BizDataCommonResponseModel>> synBizDataBySalaryFile(BizDataSalaryFileMainModel bizDataMap) {
        logger.info("synBizDataBySalaryFile  start!");
        List<BizDataSalaryFileMapModel> salaryFileModelList = bizDataMap.getData();
        int dataMapLen = salaryFileModelList.size();
        if (dataMapLen > 500) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1024.getCode();
            String errorMsg = BizDataFailStatusEnum.getDesc((String)errorCode);
            CustomApiResult fail = CustomApiResult.fail((String)errorCode, (String)MessageFormat.format(errorMsg, 500));
            return fail;
        }
        BizDataServiceHelper helper = new BizDataServiceHelper();
        ArrayList<Map<String, Object>> failList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Long> cacheFileMap = new HashMap<String, Long>(16);
        List<BizDataSalaryFileMapModel> fileSuccList = this.salaryFileCheck(salaryFileModelList, helper, failList, cacheFileMap);
        logger.info("salaryFileCheck failList is:{}, cacheFileMap is {}.", failList, cacheFileMap);
        if (fileSuccList == null || fileSuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheBizItemMap = new HashMap<String, Long>(16);
        List<BizDataSalaryFileMapModel> bizItemSuccList = this.bizItemCheck(fileSuccList, helper, failList, cacheBizItemMap);
        logger.info("bizItemSuccList failList is:{}, cacheBizItemMap is {}.", failList, cacheBizItemMap);
        if (bizItemSuccList == null || bizItemSuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheFrequencyMap = new HashMap<String, Long>(16);
        List<BizDataSalaryFileMapModel> frequencySuccList = this.frequencyCheck(bizItemSuccList, helper, failList, cacheFrequencyMap);
        logger.info("frequencySuccList failList is:{}, cacheFrequencyMap is {}.", failList, cacheFrequencyMap);
        if (frequencySuccList == null || frequencySuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheCurrencyMap = new HashMap<String, Long>(16);
        List<BizDataSalaryFileMapModel> currencySuccList = this.currencyCheck(frequencySuccList, helper, failList, cacheCurrencyMap);
        logger.info("currencyCheck failList is:{}, cacheCurrencyMap is {}.", failList, cacheCurrencyMap);
        if (currencySuccList == null || currencySuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheBizItemPropMap = new HashMap<String, Long>(16);
        List<BizDataSalaryFileMapModel> bizItemPropSuccList = this.bizItemPropCheck(currencySuccList, helper, failList, cacheBizItemPropMap);
        logger.info("bizItemPropCheck failList is:{}, cacheBizItemPropMap is {}.", failList, cacheBizItemPropMap);
        if (bizItemPropSuccList == null || bizItemPropSuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheActionMap = new HashMap<String, Long>(16);
        List<BizDataSalaryFileMapModel> actionSuccList = this.actionCheck(bizItemPropSuccList, helper, failList, cacheActionMap);
        logger.info("actionCheck failList is:{}, cacheActionMap is {}.", failList, cacheActionMap);
        if (actionSuccList == null || actionSuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        Map<String, Object> paramMap = this.buildBizDataBySalaryFile(bizDataMap, cacheFileMap, cacheBizItemMap, cacheFrequencyMap, cacheCurrencyMap, cacheBizItemPropMap, cacheActionMap);
        Map<String, Object> result = helper.synBizDataBySalaryFile(paramMap);
        logger.info("synBizDataBySalaryFile result is: {}.", result);
        return this.addBizDataCommonSuccess(result);
    }

    public CustomApiResult<List<BizDataCommonResponseModel>> synBizDataByDepemp(BizDataDepempMainModel bizDataMap) {
        List<BizDataDepempMapModel> depempModelList = bizDataMap.getData();
        int dataMapLen = depempModelList.size();
        if (dataMapLen > 500) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1024.getCode();
            String errorMsg = BizDataFailStatusEnum.getDesc((String)errorCode);
            CustomApiResult fail = CustomApiResult.fail((String)errorCode, (String)MessageFormat.format(errorMsg, 500));
            return fail;
        }
        BizDataServiceHelper helper = new BizDataServiceHelper();
        ArrayList<Map<String, Object>> failList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Long> cacheBizItemMap = new HashMap<String, Long>(16);
        List<BizDataDepempMapModel> bizItemSuccList = this.bizItemDepempCheck(depempModelList, helper, failList, cacheBizItemMap);
        if (bizItemSuccList == null || bizItemSuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheFrequencyMap = new HashMap<String, Long>(16);
        List<BizDataDepempMapModel> frequencySuccList = this.frequencyDepempCheck(bizItemSuccList, helper, failList, cacheFrequencyMap);
        if (frequencySuccList == null || frequencySuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheCurrencyMap = new HashMap<String, Long>(16);
        List<BizDataDepempMapModel> currencySuccList = this.currencyDepempCheck(frequencySuccList, helper, failList, cacheCurrencyMap);
        if (currencySuccList == null || currencySuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheBizItemPropMap = new HashMap<String, Long>(16);
        List<BizDataDepempMapModel> bizItemPropSuccList = this.bizItemPropDepempCheck(currencySuccList, helper, failList, cacheBizItemPropMap);
        if (bizItemPropSuccList == null || bizItemPropSuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashMap<String, Long> cacheActionMap = new HashMap<String, Long>(16);
        List<BizDataDepempMapModel> actionSuccList = this.actionDepempCheck(bizItemPropSuccList, helper, failList, cacheActionMap);
        if (actionSuccList == null || actionSuccList.size() == 0) {
            CustomApiResult<List<BizDataCommonResponseModel>> success = this.buildFailErrorInfo(failList);
            return success;
        }
        HashSet<Long> depempIdSet = new HashSet<Long>(actionSuccList.size());
        for (BizDataDepempMapModel depempModel : actionSuccList) {
            depempIdSet.add(depempModel.getDepempid());
        }
        Map<Long, Long> cacheDepemeIdAndEmployeeIdMap = helper.getEmployeeIdByDepempIds(depempIdSet);
        Map<String, Object> paramMap = this.buildBizDataByDepemp(bizDataMap, cacheBizItemMap, cacheFrequencyMap, cacheCurrencyMap, cacheBizItemPropMap, cacheActionMap, cacheDepemeIdAndEmployeeIdMap);
        Map<String, Object> result = helper.synBizData(paramMap);
        logger.info("synBizData result is: {}.", result);
        return this.addBizDataCommonSuccess(result);
    }

    public CustomApiResult<List<String>> getBizDataCodes(String codeprefix, Integer count) {
        if (count < 1 || count > 10000) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1023.getCode();
            String errorMessage = BizDataFailStatusEnum.getDesc((String)errorCode);
            CustomApiResult fail = CustomApiResult.fail((String)errorCode, (String)MessageFormat.format(errorMessage, 10000));
            fail.setData(new ArrayList(0));
            return fail;
        }
        List bizDataCodes = (List)SWCMServiceUtils.invokeSWCService((String)"hsbs", (String)"IHSBSBizDataCodeService", (String)"getBizDataCodes", (Object[])new Object[]{codeprefix, count});
        logger.info("getBizDataCodes result is: {}.", (Object)bizDataCodes);
        CustomApiResult success = CustomApiResult.success(null);
        success.setData((Object)bizDataCodes);
        return success;
    }

    public CustomApiResult<List<QueryBizDataResponseModel>> getBizDatas(String empnumber, String salaryfilenumber, Long depempid, String bizitemnumber, Date startdate, Date enddate) {
        BizDataServiceHelper helper = new BizDataServiceHelper();
        ArrayList<String> bizItemNumberList = new ArrayList<String>(2);
        bizItemNumberList.add(bizitemnumber);
        QFilter filter = new QFilter("classification", "!=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(filter);
        Map<String, Long> bizRelationMap = helper.buildBaseDataIdAndNumberRelation("hsbs_bizitem", bizItemNumberList, filters);
        if (bizRelationMap == null || bizRelationMap.size() == 0) {
            QueryBizDataResponseModel retModel = new QueryBizDataResponseModel();
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1021.getCode();
            retModel.setErrorcode(errorCode);
            retModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
            ArrayList<QueryBizDataResponseModel> retList = new ArrayList<QueryBizDataResponseModel>(2);
            CustomApiResult success = CustomApiResult.success(null);
            retList.add(retModel);
            success.setData(retList);
            return success;
        }
        Set<Long> matchSalaryFileIdSet = null;
        if (SWCStringUtils.isNotEmpty((String)salaryfilenumber) && ((matchSalaryFileIdSet = helper.buildSalaryFileIdAndNumberRelation("hsas_salaryfile", salaryfilenumber, null)) == null || matchSalaryFileIdSet.size() == 0)) {
            QueryBizDataResponseModel retModel = new QueryBizDataResponseModel();
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1032.getCode();
            retModel.setErrorcode(errorCode);
            retModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
            ArrayList<QueryBizDataResponseModel> retList = new ArrayList<QueryBizDataResponseModel>(2);
            CustomApiResult success = CustomApiResult.success(null);
            retList.add(retModel);
            success.setData(retList);
            return success;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("empnumber", empnumber);
        if (matchSalaryFileIdSet != null && matchSalaryFileIdSet.size() > 0) {
            paramMap.put("salaryfileidset", matchSalaryFileIdSet);
        }
        paramMap.put("depempid", depempid);
        paramMap.put("bizitemid", bizRelationMap.get(bizitemnumber));
        paramMap.put("startdate", startdate);
        paramMap.put("enddate", enddate);
        List<Map<String, Object>> resultList = helper.getBizDatas(paramMap);
        logger.info("getBizDatas result is: {}.", resultList);
        CustomApiResult success = CustomApiResult.success(null);
        if (resultList == null || resultList.size() == 0) {
            return success;
        }
        ArrayList<QueryBizDataResponseModel> modelList = new ArrayList<QueryBizDataResponseModel>(resultList.size());
        for (Map<String, Object> resultMap : resultList) {
            QueryBizDataResponseModel model = new QueryBizDataResponseModel();
            model.setEmpnumber((String)resultMap.get("empnumber"));
            model.setSalaryfileid((Long)resultMap.get("salaryfileid"));
            model.setSalaryfilename((String)resultMap.get("Salaryfilename"));
            model.setSalaryfilenumber((String)resultMap.get("salaryfilenumber"));
            model.setDepempid((Long)resultMap.get("depempid"));
            model.setBizitemid((Long)resultMap.get("bizitemid"));
            model.setBizitemname((String)resultMap.get("bizitemname"));
            model.setBizitemnumber((String)resultMap.get("bizitemnumber"));
            model.setBsed((Date)resultMap.get("bsed"));
            model.setBsled((Date)resultMap.get("bsled"));
            model.setBizdatacode((String)resultMap.get("bizdatacode"));
            model.setAuditstatus((String)resultMap.get("auditstatus"));
            model.setValue((String)resultMap.get("value"));
            model.setErrorcode((String)resultMap.get("errorcode"));
            model.setErrormsg((String)resultMap.get("errormsg"));
            modelList.add(model);
        }
        success.setData(modelList);
        return success;
    }

    public CustomApiResult<List<QueryBizItemInfoResponseModel>> batchGetBizInfos(String bizItemNumbers) {
        BizDataServiceHelper helper = new BizDataServiceHelper();
        List<Map<String, Object>> bizItemInfoList = helper.getBizItemInfoByNumbers(bizItemNumbers);
        logger.info("getBizItemInfoByNumbers result is: {}.", bizItemInfoList);
        CustomApiResult success = CustomApiResult.success(null);
        if (bizItemInfoList == null || bizItemInfoList.size() == 0) {
            success.setData(new ArrayList(0));
            return success;
        }
        ArrayList<QueryBizItemInfoResponseModel> retList = new ArrayList<QueryBizItemInfoResponseModel>(bizItemInfoList.size());
        for (Map<String, Object> bizItemInfoMap : bizItemInfoList) {
            QueryBizItemInfoResponseModel model = new QueryBizItemInfoResponseModel();
            model.setBizitemid((Long)bizItemInfoMap.get("bizitemid"));
            model.setBizitemnumber((String)bizItemInfoMap.get("bizitemnumber"));
            model.setBizitemname((String)bizItemInfoMap.get("bizitemname"));
            model.setCreateorgid((Long)bizItemInfoMap.get("createorgid"));
            model.setCreateorgnumber((String)bizItemInfoMap.get("createorgnumber"));
            model.setCreateorgname((String)bizItemInfoMap.get("createorgname"));
            model.setCtrlstrategy((String)bizItemInfoMap.get("ctrlstrategy"));
            model.setAreatype((String)bizItemInfoMap.get("areatype"));
            model.setCountryid((Long)bizItemInfoMap.get("countryid"));
            model.setCountrynumber((String)bizItemInfoMap.get("countrynumber"));
            model.setCountryname((String)bizItemInfoMap.get("countryname"));
            model.setBizitemcategoryid((Long)bizItemInfoMap.get("bizitemcategoryid"));
            model.setBizitemcategorynumber((String)bizItemInfoMap.get("bizitemcategorynumber"));
            model.setBizitemcategoryname((String)bizItemInfoMap.get("bizitemcategoryname"));
            model.setDatatypeid((Long)bizItemInfoMap.get("datatypeid"));
            model.setDatatypenumber((String)bizItemInfoMap.get("datatypenumber"));
            model.setDatatypename((String)bizItemInfoMap.get("datatypename"));
            model.setCycle((Boolean)bizItemInfoMap.get("cycle"));
            List bizitemproplist = (List)bizItemInfoMap.get("bizitemproplist");
            if (bizitemproplist != null && bizitemproplist.size() > 0) {
                ArrayList<BizItemPropInfoResponseModel> bizItemPropModelList = new ArrayList<BizItemPropInfoResponseModel>(bizitemproplist.size());
                for (Map bizitempropMap : bizitemproplist) {
                    BizItemPropInfoResponseModel propModel = new BizItemPropInfoResponseModel();
                    propModel.setBizitempropid((Long)bizitempropMap.get("bizitempropid"));
                    propModel.setBizitempropnumber((String)bizitempropMap.get("bizitempropnumber"));
                    propModel.setBizitempropname((String)bizitempropMap.get("bizitempropname"));
                    bizItemPropModelList.add(propModel);
                }
                model.setBizitemproplist(bizItemPropModelList);
            }
            model.setIssalarystd((String)bizItemInfoMap.get("issalarystd"));
            model.setMultipleinput((String)bizItemInfoMap.get("multipleinput"));
            model.setMaxinputtime((Integer)bizItemInfoMap.get("maxinputtime"));
            model.setDatalength((Integer)bizItemInfoMap.get("datalength"));
            model.setInputminval((BigDecimal)bizItemInfoMap.get("inputminval"));
            model.setInputmaxval((BigDecimal)bizItemInfoMap.get("inputmaxval"));
            model.setEarliestdate((String)bizItemInfoMap.get("earliestdate"));
            model.setLastdate((String)bizItemInfoMap.get("lastdate"));
            List currencylist = (List)bizItemInfoMap.get("currencylist");
            if (currencylist != null && currencylist.size() > 0) {
                ArrayList<CurrencyInfoResponseModel> currencyModelList = new ArrayList<CurrencyInfoResponseModel>(currencylist.size());
                for (Map currencyMap : currencylist) {
                    CurrencyInfoResponseModel currencyModel = new CurrencyInfoResponseModel();
                    currencyModel.setCurrencyid((Long)currencyMap.get("currencyid"));
                    currencyModel.setCurrencynumber((String)currencyMap.get("currencynumber"));
                    currencyModel.setCurrencyname((String)currencyMap.get("currencyname"));
                    currencyModelList.add(currencyModel);
                }
                model.setCurrencylist(currencyModelList);
            }
            model.setConsumemethod((String)bizItemInfoMap.get("consumemethod"));
            model.setOneoffconsume((String)bizItemInfoMap.get("oneoffconsume"));
            model.setIslistgenerate((String)bizItemInfoMap.get("islistgenerate"));
            model.setStatus((String)bizItemInfoMap.get("status"));
            model.setEnable((String)bizItemInfoMap.get("enable"));
            retList.add(model);
        }
        success.setData(retList);
        return success;
    }

    public CustomApiResult<List<BizDataUpdateBsledResponseModel>> updateBsled(BizDataUpdateBsledMainModel bizDataMap) {
        List<BizDataUpdateBsledDataModel> dataModelList = bizDataMap.getData();
        int dataMapLen = dataModelList.size();
        if (dataMapLen > 500) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1024.getCode();
            String errorMsg = BizDataFailStatusEnum.getDesc((String)errorCode);
            CustomApiResult fail = CustomApiResult.fail((String)errorCode, (String)MessageFormat.format(errorMsg, 500));
            return fail;
        }
        ArrayList<String> bizItemNumberList = new ArrayList<String>(dataMapLen);
        for (BizDataUpdateBsledDataModel dataModel : dataModelList) {
            bizItemNumberList.add(dataModel.getBizitemnumber());
        }
        BizDataServiceHelper helper = new BizDataServiceHelper();
        Map<String, Long> relationMap = helper.buildBaseDataIdAndNumberRelation("hsbs_bizitem", bizItemNumberList, null);
        ArrayList<BizDataUpdateBsledResponseModel> retList = new ArrayList<BizDataUpdateBsledResponseModel>(10);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("opsystem", bizDataMap.getOpsystem());
        ArrayList dataList = new ArrayList(10);
        for (BizDataUpdateBsledDataModel dataModel : dataModelList) {
            String bizItemNumber = dataModel.getBizitemnumber();
            Long cacheBizItemId = relationMap.get(bizItemNumber);
            if (cacheBizItemId == null) {
                BizDataUpdateBsledResponseModel retModel = new BizDataUpdateBsledResponseModel();
                String errorCode = BizDataFailStatusEnum.FAILSTATUS_1021.getCode();
                retModel.setErrorcode(errorCode);
                retModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
                retModel.setStatus("0");
                retList.add(retModel);
                continue;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
            dataMap.put("bizdatacode", dataModel.getBizdatacode());
            dataMap.put("bizitemid", cacheBizItemId);
            dataMap.put("bsled", dataModel.getBsled());
            dataList.add(dataMap);
        }
        CustomApiResult success = CustomApiResult.success(null);
        if (dataList != null && dataList.size() > 0) {
            params.put("data", dataList);
            Map<String, Object> updateMap = helper.updateBlsed(params);
            logger.info("updateBlsed result is: {}.", updateMap);
            List resultList = (List)updateMap.get("result");
            if (resultList == null || resultList.size() == 0) {
                success.setData(retList);
                return success;
            }
            for (Map resultMap : resultList) {
                BizDataUpdateBsledResponseModel resultModel = new BizDataUpdateBsledResponseModel();
                resultModel.setBizdatacode((String)resultMap.get("bizdatacode"));
                resultModel.setStatus((String)resultMap.get("status"));
                String errorCode = (String)resultMap.get("errorcode");
                if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                    resultModel.setErrorcode(errorCode);
                    resultModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
                }
                retList.add(resultModel);
            }
        }
        success.setData(retList);
        return success;
    }

    public CustomApiResult<List<BizDataDeleteResponseModel>> delBizData(BizDataDeleteMainModel bizDataMap) {
        String operate = bizDataMap.getOperate();
        if (!(SWCStringUtils.equals((String)operate, (String)"E") || SWCStringUtils.equals((String)operate, (String)"LD") || SWCStringUtils.equals((String)operate, (String)"LDE"))) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1051.getCode();
            String errorMsg = BizDataFailStatusEnum.getDesc((String)errorCode);
            CustomApiResult fail = CustomApiResult.fail((String)errorCode, (String)errorMsg);
            return fail;
        }
        List<BizDataDeleteDataModel> dataModelList = bizDataMap.getData();
        int dataMapLen = dataModelList.size();
        if (dataMapLen > 500) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1024.getCode();
            String errorMsg = BizDataFailStatusEnum.getDesc((String)errorCode);
            CustomApiResult fail = CustomApiResult.fail((String)errorCode, (String)MessageFormat.format(errorMsg, 500));
            return fail;
        }
        ArrayList<String> bizItemNumberList = new ArrayList<String>(dataMapLen);
        for (BizDataDeleteDataModel dataModel : dataModelList) {
            bizItemNumberList.add(dataModel.getBizitemnumber());
        }
        BizDataServiceHelper helper = new BizDataServiceHelper();
        Map<String, Long> relationMap = helper.buildBaseDataIdAndNumberRelation("hsbs_bizitem", bizItemNumberList, null);
        ArrayList<BizDataDeleteResponseModel> retList = new ArrayList<BizDataDeleteResponseModel>(10);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("opsystem", bizDataMap.getOpsystem());
        params.put("operate", bizDataMap.getOperate());
        ArrayList dataList = new ArrayList(10);
        for (BizDataDeleteDataModel dataModel : dataModelList) {
            String bizItemNumber = dataModel.getBizitemnumber();
            Long cacheBizItemId = relationMap.get(bizItemNumber);
            if (cacheBizItemId == null) {
                BizDataDeleteResponseModel retModel = new BizDataDeleteResponseModel();
                String errorCode = BizDataFailStatusEnum.FAILSTATUS_1021.getCode();
                retModel.setErrorcode(errorCode);
                retModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
                retList.add(retModel);
                continue;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
            dataMap.put("bizdatacode", dataModel.getBizdatacode());
            dataMap.put("bizitemid", cacheBizItemId);
            dataMap.put("opreason", dataModel.getOpreason());
            dataList.add(dataMap);
        }
        CustomApiResult success = CustomApiResult.success(null);
        if (dataList != null && dataList.size() > 0) {
            params.put("data", dataList);
            Map<String, Object> updateMap = helper.delBizData(params);
            logger.info("delBizData result is: {}.", updateMap);
            List resultList = (List)updateMap.get("result");
            if (resultList == null || resultList.size() == 0) {
                success.setData(retList);
                return success;
            }
            for (Map resultMap : resultList) {
                BizDataDeleteResponseModel resultModel = new BizDataDeleteResponseModel();
                resultModel.setBizdatacode((String)resultMap.get("bizdatacode"));
                resultModel.setStatus((String)resultMap.get("status"));
                resultModel.setOperate((String)resultMap.get("operate"));
                String errorCode = (String)resultMap.get("errorcode");
                if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                    resultModel.setErrorcode(errorCode);
                    resultModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
                }
                retList.add(resultModel);
            }
        }
        success.setData(retList);
        return success;
    }

    private Map<String, Object> buildBizDataBySalaryFile(BizDataSalaryFileMainModel bizDataMap, Map<String, Long> cacheFileMap, Map<String, Long> cacheBizItemMap, Map<String, Long> cacheFrequencyMap, Map<String, Long> cacheCurrencyMap, Map<String, Long> cacheBizItemPropMap, Map<String, Long> cacheActionMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("opsystem", bizDataMap.getOpsystem());
        paramMap.put("operate", "1");
        List<BizDataSalaryFileMapModel> bizDataList = bizDataMap.getData();
        ArrayList<HashMap<String, Object>> data = new ArrayList<HashMap<String, Object>>(bizDataList.size());
        for (BizDataSalaryFileMapModel dataModel : bizDataList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("salaryfileid", cacheFileMap.get(dataModel.getSalaryfilenumber()));
            this.buildBizCommonData(dataModel, dataMap, cacheBizItemMap, cacheFrequencyMap, cacheCurrencyMap, cacheBizItemPropMap, cacheActionMap);
            data.add(dataMap);
        }
        paramMap.put("data", data);
        return paramMap;
    }

    private Map<String, Object> buildBizDataByDepemp(BizDataDepempMainModel bizDataMap, Map<String, Long> cacheBizItemMap, Map<String, Long> cacheFrequencyMap, Map<String, Long> cacheCurrencyMap, Map<String, Long> cacheBizItemPropMap, Map<String, Long> cacheActionMap, Map<Long, Long> cacheDepemeIdAndEmployeeIdMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("opsystem", bizDataMap.getOpsystem());
        paramMap.put("operate", "1");
        List<BizDataDepempMapModel> bizDataList = bizDataMap.getData();
        ArrayList<HashMap<String, Object>> data = new ArrayList<HashMap<String, Object>>(bizDataList.size());
        for (BizDataDepempMapModel dataModel : bizDataList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("depempid", dataModel.getDepempid());
            Long employeeid = cacheDepemeIdAndEmployeeIdMap.get(dataModel.getDepempid());
            if (employeeid != null) {
                dataMap.put("employeeid", employeeid);
            } else {
                dataMap.put("employeeid", 0L);
            }
            this.buildBizDepempCommonData(dataModel, dataMap, cacheBizItemMap, cacheFrequencyMap, cacheCurrencyMap, cacheBizItemPropMap, cacheActionMap);
            data.add(dataMap);
        }
        paramMap.put("data", data);
        return paramMap;
    }

    private void buildBizCommonData(BizDataSalaryFileMapModel dataModel, Map<String, Object> dataMap, Map<String, Long> cacheBizItemMap, Map<String, Long> cacheFrequencyMap, Map<String, Long> cacheCurrencyMap, Map<String, Long> cacheBizItemPropMap, Map<String, Long> cacheActionMap) {
        PersonChangeModel personChangeModel;
        List<BizItemPropDataModel> propModelList;
        String description;
        String currencynumber;
        dataMap.put("bizdatacode", dataModel.getBizdatacode());
        dataMap.put("batchcode", dataModel.getBatchcode());
        dataMap.put("datasources", "2");
        dataMap.put("srcsystem", dataModel.getSrcsystem());
        dataMap.put("bizitemid", cacheBizItemMap.get(dataModel.getBizitemnumber()));
        String calfrequencynumber = dataModel.getCalfrequencynumber();
        if (SWCStringUtils.isNotEmpty((String)calfrequencynumber)) {
            dataMap.put("calfrequencyid", cacheFrequencyMap.get(calfrequencynumber));
        }
        if (SWCStringUtils.isNotEmpty((String)(currencynumber = dataModel.getCurrencynumber()))) {
            dataMap.put("currencyid", cacheCurrencyMap.get(currencynumber));
        }
        dataMap.put("value", dataModel.getValue());
        dataMap.put("bsed", dataModel.getBsed());
        Date bsled = dataModel.getBsled();
        if (bsled != null) {
            dataMap.put("bsled", bsled);
        }
        if (SWCStringUtils.isNotEmpty((String)(description = dataModel.getDescription()))) {
            dataMap.put("description", description);
        }
        if ((propModelList = dataModel.getPropdatalist()) != null && propModelList.size() > 0) {
            ArrayList propdatalist = new ArrayList(propModelList.size());
            for (BizItemPropDataModel propModel : propModelList) {
                HashMap<String, Object> propMap = new HashMap<String, Object>(2);
                String bizitempropnumber = propModel.getBizitempropnumber();
                propMap.put("bizitempropid", cacheBizItemPropMap.get(bizitempropnumber));
                propMap.put("propvalue", propModel.getPropvalue());
                propdatalist.add(propMap);
            }
            dataMap.put("propdatalist", propdatalist);
        }
        if ((personChangeModel = dataModel.getPersonchangeinfo()) != null) {
            HashMap<String, Long> personchangeinfo = new HashMap<String, Long>(2);
            String actionnumber = personChangeModel.getActionnumber();
            if (SWCStringUtils.isNotEmpty((String)actionnumber)) {
                personchangeinfo.put("action", cacheActionMap.get(actionnumber));
            }
            dataMap.put("personchangeinfo", personchangeinfo);
        }
    }

    private void buildBizDepempCommonData(BizDataDepempMapModel dataModel, Map<String, Object> dataMap, Map<String, Long> cacheBizItemMap, Map<String, Long> cacheFrequencyMap, Map<String, Long> cacheCurrencyMap, Map<String, Long> cacheBizItemPropMap, Map<String, Long> cacheActionMap) {
        PersonChangeModel personChangeModel;
        List<BizItemPropDataModel> propModelList;
        String description;
        String currencynumber;
        dataMap.put("bizdatacode", dataModel.getBizdatacode());
        dataMap.put("batchcode", dataModel.getBatchcode());
        dataMap.put("datasources", "2");
        dataMap.put("srcsystem", dataModel.getSrcsystem());
        dataMap.put("bizitemid", cacheBizItemMap.get(dataModel.getBizitemnumber()));
        String calfrequencynumber = dataModel.getCalfrequencynumber();
        if (SWCStringUtils.isNotEmpty((String)calfrequencynumber)) {
            dataMap.put("calfrequencyid", cacheFrequencyMap.get(calfrequencynumber));
        }
        if (SWCStringUtils.isNotEmpty((String)(currencynumber = dataModel.getCurrencynumber()))) {
            dataMap.put("currencyid", cacheCurrencyMap.get(currencynumber));
        }
        dataMap.put("value", dataModel.getValue());
        dataMap.put("bsed", dataModel.getBsed());
        Date bsled = dataModel.getBsled();
        if (bsled != null) {
            dataMap.put("bsled", bsled);
        }
        if (SWCStringUtils.isNotEmpty((String)(description = dataModel.getDescription()))) {
            dataMap.put("description", description);
        }
        if ((propModelList = dataModel.getPropdatalist()) != null && propModelList.size() > 0) {
            ArrayList propdatalist = new ArrayList(propModelList.size());
            for (BizItemPropDataModel propModel : propModelList) {
                HashMap<String, Object> propMap = new HashMap<String, Object>(2);
                String bizitempropnumber = propModel.getBizitempropnumber();
                propMap.put("bizitempropid", cacheBizItemPropMap.get(bizitempropnumber));
                propMap.put("propvalue", propModel.getPropvalue());
                propdatalist.add(propMap);
            }
            dataMap.put("propdatalist", propdatalist);
        }
        if ((personChangeModel = dataModel.getPersonchangeinfo()) != null) {
            HashMap<String, Long> personchangeinfo = new HashMap<String, Long>(2);
            String actionnumber = personChangeModel.getActionnumber();
            if (SWCStringUtils.isNotEmpty((String)actionnumber)) {
                personchangeinfo.put("action", cacheActionMap.get(actionnumber));
            }
            dataMap.put("personchangeinfo", personchangeinfo);
        }
    }

    private CustomApiResult<List<BizDataCommonResponseModel>> addBizDataCommonSuccess(Map<String, Object> result) {
        CustomApiResult success = CustomApiResult.success(null);
        List retList = (List)result.get("result");
        if (retList == null || retList.size() == 0) {
            return success;
        }
        ArrayList<BizDataCommonResponseModel> retModelList = new ArrayList<BizDataCommonResponseModel>(retList.size());
        for (Map retMap : retList) {
            BizDataCommonResponseModel retModel = new BizDataCommonResponseModel();
            this.buildCommonAddResponse(retModel, retMap);
            retModelList.add(retModel);
        }
        success.setData(retModelList);
        return success;
    }

    private void buildCommonAddResponse(BizDataCommonResponseModel retModel, Map<String, Object> retMap) {
        String bizdatacode = (String)retMap.get("bizdatacode");
        retModel.setBizdatacode(bizdatacode);
        String status = (String)retMap.get("status");
        retModel.setStatus(status);
        String errorCode = (String)retMap.get("errorcode");
        retModel.setErrorcode(errorCode);
        if (SWCStringUtils.isNotEmpty((String)errorCode)) {
            String errorMsg = (String)retMap.get("errormsg");
            if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                retModel.setErrormsg(errorMsg);
            } else {
                retModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
            }
        }
        Long calpayrollid = (Long)retMap.get("calpayrollid");
        retModel.setCalpayrollid(calpayrollid);
        Long salaryfileid = (Long)retMap.get("salaryfileid");
        retModel.setSalaryfileid(salaryfileid);
        List bzItemPropErrorList = (List)retMap.get("properrorinfo");
        if (bzItemPropErrorList != null && bzItemPropErrorList.size() > 0) {
            ArrayList<BizItemPropErrorResponseModel> propRetModelList = new ArrayList<BizItemPropErrorResponseModel>(bzItemPropErrorList.size());
            for (Map map : bzItemPropErrorList) {
                BizItemPropErrorResponseModel propRetModel = new BizItemPropErrorResponseModel();
                propRetModel.setBizitempropid((Long)map.get("bizitempropid"));
                propRetModel.setBizitempropnumber((String)map.get("bizitempropnumber"));
                propRetModel.setBizitempropname((String)map.get("bizitempropname"));
                String propErrorCode = (String)map.get("errorcode");
                propRetModel.setErrorcode(propErrorCode);
                if (SWCStringUtils.isNotEmpty((String)propErrorCode)) {
                    propRetModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)propErrorCode));
                }
                propRetModelList.add(propRetModel);
            }
            retModel.setProperrorinfo(propRetModelList);
        }
    }

    public CustomApiResult<List<QueryPayRollGroupResponseModel>> getPayRollGroups(String orgnumber, String countrynumber) {
        if (SWCStringUtils.isEmpty((String)orgnumber) && SWCStringUtils.isEmpty((String)countrynumber)) {
            String errorCode = BizDataFailStatusEnum.FAILSTATUS_1084.getCode();
            String errorMsg = BizDataFailStatusEnum.getDesc((String)errorCode);
            CustomApiResult fail = CustomApiResult.fail((String)errorCode, (String)errorMsg);
            return fail;
        }
        BizDataServiceHelper helper = new BizDataServiceHelper();
        Long orgId = null;
        if (SWCStringUtils.isNotEmpty((String)orgnumber)) {
            ArrayList<String> orgNumberList = new ArrayList<String>(2);
            orgNumberList.add(orgnumber);
            Map<String, Long> orgRelationMap = helper.buildBaseDataIdAndNumberRelation("bos_org", orgNumberList, null);
            if (orgRelationMap == null || orgRelationMap.size() == 0) {
                QueryPayRollGroupResponseModel retModel = new QueryPayRollGroupResponseModel();
                String errorCode = BizDataFailStatusEnum.FAILSTATUS_1086.getCode();
                retModel.setErrorcode(errorCode);
                retModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
                ArrayList<QueryPayRollGroupResponseModel> retList = new ArrayList<QueryPayRollGroupResponseModel>(2);
                CustomApiResult success = CustomApiResult.success(null);
                retList.add(retModel);
                success.setData(retList);
                return success;
            }
            orgId = orgRelationMap.get(orgnumber);
        }
        Long countryId = null;
        if (SWCStringUtils.isNotEmpty((String)countrynumber)) {
            ArrayList<String> countryNumberList = new ArrayList<String>(2);
            countryNumberList.add(countrynumber);
            Map<String, Long> countryRelationMap = helper.buildBaseDataIdAndNumberRelation("bd_country", countryNumberList, null);
            if (countryRelationMap == null || countryRelationMap.size() == 0) {
                QueryPayRollGroupResponseModel retModel = new QueryPayRollGroupResponseModel();
                String errorCode = BizDataFailStatusEnum.FAILSTATUS_1087.getCode();
                retModel.setErrorcode(errorCode);
                retModel.setErrormsg(BizDataFailStatusEnum.getDesc((String)errorCode));
                ArrayList<QueryPayRollGroupResponseModel> retList = new ArrayList<QueryPayRollGroupResponseModel>(2);
                CustomApiResult success = CustomApiResult.success(null);
                retList.add(retModel);
                success.setData(retList);
                return success;
            }
            countryId = countryRelationMap.get(countrynumber);
        }
        List<Map<String, Object>> payRollGroupList = helper.getPayRollGroupsInfo(orgId, countryId);
        logger.info("getPayRollGroupsInfo result is: {}.", payRollGroupList);
        if (payRollGroupList == null || payRollGroupList.size() == 0) {
            CustomApiResult success = CustomApiResult.success(null);
            success.setData(new ArrayList(0));
            return success;
        }
        ArrayList<QueryPayRollGroupResponseModel> retModelList = new ArrayList<QueryPayRollGroupResponseModel>(payRollGroupList.size());
        CustomApiResult success = CustomApiResult.success(null);
        for (Map<String, Object> payRollGroupMap : payRollGroupList) {
            QueryPayRollGroupResponseModel retModel = new QueryPayRollGroupResponseModel();
            retModel.setBoid((Long)payRollGroupMap.get("boid"));
            retModel.setOrgid((Long)payRollGroupMap.get("orgid"));
            retModel.setOrgnumber((String)payRollGroupMap.get("orgnumber"));
            retModel.setOrgname((String)payRollGroupMap.get("orgname"));
            retModel.setCountryid((Long)payRollGroupMap.get("countryid"));
            retModel.setCountrynumber((String)payRollGroupMap.get("countrynumber"));
            retModel.setCountryname((String)payRollGroupMap.get("countryname"));
            retModel.setCurrencyid((Long)payRollGroupMap.get("currencyid"));
            retModel.setCurrencynumber((String)payRollGroupMap.get("currencynumber"));
            retModel.setCurrencyname((String)payRollGroupMap.get("currencyname"));
            retModelList.add(retModel);
        }
        success.setData(retModelList);
        return success;
    }

    private List<BizDataSalaryFileMapModel> salaryFileCheck(List<BizDataSalaryFileMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheFileMap) {
        HashSet<String> cacheFileNumberSet = new HashSet<String>(dataModelList.size());
        for (BizDataSalaryFileMapModel salaryFileModel : dataModelList) {
            String salaryFileNumber = salaryFileModel.getSalaryfilenumber();
            cacheFileNumberSet.add(salaryFileNumber);
        }
        ArrayList<QFilter> fileFilterList = new ArrayList<QFilter>(3);
        fileFilterList.add(new QFilter("status", "=", (Object)"C"));
        fileFilterList.add(new QFilter("enable", "=", (Object)"1"));
        fileFilterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        Map<String, Long> salaryFileMap = helper.buildBaseDataIdAndNumberRelation("hsas_salaryfile", new ArrayList<String>(cacheFileNumberSet), fileFilterList);
        cacheFileMap.putAll(salaryFileMap);
        ArrayList<BizDataSalaryFileMapModel> fileSuccList = new ArrayList<BizDataSalaryFileMapModel>(10);
        for (BizDataSalaryFileMapModel salaryFileModel : dataModelList) {
            String salaryFileNumber = salaryFileModel.getSalaryfilenumber();
            Long salaryFileId = salaryFileMap.get(salaryFileNumber);
            if (salaryFileId == null || salaryFileId == 0L) {
                HashMap<String, String> failMap = new HashMap<String, String>(6);
                failMap.put("bizdatacode", salaryFileModel.getBizdatacode());
                failMap.put("status", "0");
                String errorCode = BizDataFailStatusEnum.FAILSTATUS_1032.getCode();
                failMap.put("errorcode", errorCode);
                failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                failList.add(failMap);
                continue;
            }
            fileSuccList.add(salaryFileModel);
        }
        return fileSuccList;
    }

    private List<BizDataSalaryFileMapModel> bizItemCheck(List<BizDataSalaryFileMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheBizItemMap) {
        HashSet<String> cacheBizItemSet = new HashSet<String>(dataModelList.size());
        for (BizDataSalaryFileMapModel dataModel : dataModelList) {
            String bizItemNumber = dataModel.getBizitemnumber();
            cacheBizItemSet.add(bizItemNumber);
        }
        ArrayList<QFilter> bizItemFilterList = new ArrayList<QFilter>(3);
        bizItemFilterList.add(new QFilter("status", "=", (Object)"C"));
        bizItemFilterList.add(new QFilter("enable", "=", (Object)"1"));
        Map<String, Long> bizItemMap = helper.buildBaseDataIdAndNumberRelation("hsbs_bizitem", new ArrayList<String>(cacheBizItemSet), bizItemFilterList);
        cacheBizItemMap.putAll(bizItemMap);
        ArrayList<BizDataSalaryFileMapModel> bizItemSuccList = new ArrayList<BizDataSalaryFileMapModel>(10);
        for (BizDataSalaryFileMapModel dataModel : dataModelList) {
            String bizItemNumber = dataModel.getBizitemnumber();
            Long bizItemId = cacheBizItemMap.get(bizItemNumber);
            if (bizItemId == null || bizItemId == 0L) {
                HashMap<String, String> failMap = new HashMap<String, String>(6);
                failMap.put("bizdatacode", dataModel.getBizdatacode());
                failMap.put("status", "0");
                String errorCode = BizDataFailStatusEnum.FAILSTATUS_1021.getCode();
                failMap.put("errorcode", errorCode);
                failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                failList.add(failMap);
                continue;
            }
            bizItemSuccList.add(dataModel);
        }
        return bizItemSuccList;
    }

    private List<BizDataDepempMapModel> bizItemDepempCheck(List<BizDataDepempMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheBizItemMap) {
        HashSet<String> cacheBizItemSet = new HashSet<String>(dataModelList.size());
        for (BizDataDepempMapModel dataModel : dataModelList) {
            String bizItemNumber = dataModel.getBizitemnumber();
            cacheBizItemSet.add(bizItemNumber);
        }
        ArrayList<QFilter> bizItemFilterList = new ArrayList<QFilter>(3);
        bizItemFilterList.add(new QFilter("status", "=", (Object)"C"));
        bizItemFilterList.add(new QFilter("enable", "=", (Object)"1"));
        Map<String, Long> bizItemMap = helper.buildBaseDataIdAndNumberRelation("hsbs_bizitem", new ArrayList<String>(cacheBizItemSet), bizItemFilterList);
        cacheBizItemMap.putAll(bizItemMap);
        ArrayList<BizDataDepempMapModel> bizItemSuccList = new ArrayList<BizDataDepempMapModel>(10);
        for (BizDataDepempMapModel dataModel : dataModelList) {
            String bizItemNumber = dataModel.getBizitemnumber();
            Long bizItemId = cacheBizItemMap.get(bizItemNumber);
            if (bizItemId == null || bizItemId == 0L) {
                HashMap<String, String> failMap = new HashMap<String, String>(6);
                failMap.put("bizdatacode", dataModel.getBizdatacode());
                failMap.put("status", "0");
                String errorCode = BizDataFailStatusEnum.FAILSTATUS_1021.getCode();
                failMap.put("errorcode", errorCode);
                failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                failList.add(failMap);
                continue;
            }
            bizItemSuccList.add(dataModel);
        }
        return bizItemSuccList;
    }

    private List<BizDataSalaryFileMapModel> frequencyCheck(List<BizDataSalaryFileMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheFrequencyMap) {
        HashSet<String> cacheFrequencySet = new HashSet<String>(dataModelList.size());
        for (BizDataSalaryFileMapModel dataModel : dataModelList) {
            String calfrequencynumber = dataModel.getCalfrequencynumber();
            if (SWCStringUtils.isEmpty((String)calfrequencynumber)) continue;
            cacheFrequencySet.add(calfrequencynumber);
        }
        ArrayList<BizDataSalaryFileMapModel> frequencySuccList = new ArrayList(dataModelList.size());
        if (cacheFrequencySet.size() > 0) {
            ArrayList<QFilter> frequencyFilterList = new ArrayList<QFilter>(3);
            frequencyFilterList.add(new QFilter("status", "=", (Object)"C"));
            frequencyFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> frequencyMap = helper.buildBaseDataIdAndNumberRelation("hsbs_calfrequency", new ArrayList<String>(cacheFrequencySet), frequencyFilterList);
            cacheFrequencyMap.putAll(frequencyMap);
            for (BizDataSalaryFileMapModel dataModel : dataModelList) {
                String calfrequencynumber = dataModel.getCalfrequencynumber();
                if (SWCStringUtils.isEmpty((String)calfrequencynumber)) {
                    frequencySuccList.add(dataModel);
                    continue;
                }
                Long frequencyId = cacheFrequencyMap.get(calfrequencynumber);
                if (frequencyId == null || frequencyId == 0L) {
                    HashMap<String, String> failMap = new HashMap<String, String>(6);
                    failMap.put("bizdatacode", dataModel.getBizdatacode());
                    failMap.put("status", "0");
                    String errorCode = BizDataFailStatusEnum.FAILSTATUS_1042.getCode();
                    failMap.put("errorcode", errorCode);
                    failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                    failList.add(failMap);
                    continue;
                }
                frequencySuccList.add(dataModel);
            }
        } else {
            frequencySuccList = dataModelList;
        }
        return frequencySuccList;
    }

    private List<BizDataDepempMapModel> frequencyDepempCheck(List<BizDataDepempMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheFrequencyMap) {
        HashSet<String> cacheFrequencySet = new HashSet<String>(dataModelList.size());
        for (BizDataDepempMapModel dataModel : dataModelList) {
            String calfrequencynumber = dataModel.getCalfrequencynumber();
            if (SWCStringUtils.isEmpty((String)calfrequencynumber)) continue;
            cacheFrequencySet.add(calfrequencynumber);
        }
        ArrayList<BizDataDepempMapModel> frequencySuccList = new ArrayList(dataModelList.size());
        if (cacheFrequencySet.size() > 0) {
            ArrayList<QFilter> frequencyFilterList = new ArrayList<QFilter>(3);
            frequencyFilterList.add(new QFilter("status", "=", (Object)"C"));
            frequencyFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> frequencyMap = helper.buildBaseDataIdAndNumberRelation("hsbs_calfrequency", new ArrayList<String>(cacheFrequencySet), frequencyFilterList);
            cacheFrequencyMap.putAll(frequencyMap);
            for (BizDataDepempMapModel dataModel : dataModelList) {
                String calfrequencynumber = dataModel.getCalfrequencynumber();
                if (SWCStringUtils.isEmpty((String)calfrequencynumber)) {
                    frequencySuccList.add(dataModel);
                    continue;
                }
                Long frequencyId = cacheFrequencyMap.get(calfrequencynumber);
                if (frequencyId == null || frequencyId == 0L) {
                    HashMap<String, String> failMap = new HashMap<String, String>(6);
                    failMap.put("bizdatacode", dataModel.getBizdatacode());
                    failMap.put("status", "0");
                    String errorCode = BizDataFailStatusEnum.FAILSTATUS_1042.getCode();
                    failMap.put("errorcode", errorCode);
                    failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                    failList.add(failMap);
                    continue;
                }
                frequencySuccList.add(dataModel);
            }
        } else {
            frequencySuccList = dataModelList;
        }
        return frequencySuccList;
    }

    private List<BizDataSalaryFileMapModel> currencyCheck(List<BizDataSalaryFileMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheCurrencyMap) {
        HashSet<String> cacheCurrencySet = new HashSet<String>(dataModelList.size());
        for (BizDataSalaryFileMapModel dataModel : dataModelList) {
            String currencynumber = dataModel.getCurrencynumber();
            if (SWCStringUtils.isEmpty((String)currencynumber)) continue;
            cacheCurrencySet.add(currencynumber);
        }
        ArrayList<BizDataSalaryFileMapModel> currencySuccList = new ArrayList(dataModelList.size());
        if (cacheCurrencySet.size() > 0) {
            ArrayList<QFilter> currencyFilterList = new ArrayList<QFilter>(3);
            currencyFilterList.add(new QFilter("status", "=", (Object)"C"));
            currencyFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> currencyMap = helper.buildBaseDataIdAndNumberRelation("bd_currency", new ArrayList<String>(cacheCurrencySet), currencyFilterList);
            cacheCurrencyMap.putAll(currencyMap);
            for (BizDataSalaryFileMapModel dataModel : dataModelList) {
                String currencynumber = dataModel.getCurrencynumber();
                if (SWCStringUtils.isEmpty((String)currencynumber)) {
                    currencySuccList.add(dataModel);
                    continue;
                }
                Long currencyId = cacheCurrencyMap.get(currencynumber);
                if (currencyId == null || currencyId == 0L) {
                    HashMap<String, String> failMap = new HashMap<String, String>(6);
                    failMap.put("bizdatacode", dataModel.getBizdatacode());
                    failMap.put("status", "0");
                    String errorCode = BizDataFailStatusEnum.FAILSTATUS_1089.getCode();
                    failMap.put("errorcode", errorCode);
                    failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                    failList.add(failMap);
                    continue;
                }
                currencySuccList.add(dataModel);
            }
        } else {
            currencySuccList = dataModelList;
        }
        return currencySuccList;
    }

    private List<BizDataDepempMapModel> currencyDepempCheck(List<BizDataDepempMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheCurrencyMap) {
        HashSet<String> cacheCurrencySet = new HashSet<String>(dataModelList.size());
        for (BizDataDepempMapModel dataModel : dataModelList) {
            String currencynumber = dataModel.getCurrencynumber();
            if (SWCStringUtils.isEmpty((String)currencynumber)) continue;
            cacheCurrencySet.add(currencynumber);
        }
        ArrayList<BizDataDepempMapModel> currencySuccList = new ArrayList(dataModelList.size());
        if (cacheCurrencySet.size() > 0) {
            ArrayList<QFilter> currencyFilterList = new ArrayList<QFilter>(3);
            currencyFilterList.add(new QFilter("status", "=", (Object)"C"));
            currencyFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> currencyMap = helper.buildBaseDataIdAndNumberRelation("bd_currency", new ArrayList<String>(cacheCurrencySet), currencyFilterList);
            cacheCurrencyMap.putAll(currencyMap);
            for (BizDataDepempMapModel dataModel : dataModelList) {
                String currencynumber = dataModel.getCurrencynumber();
                if (SWCStringUtils.isEmpty((String)currencynumber)) {
                    currencySuccList.add(dataModel);
                    continue;
                }
                Long currencyId = cacheCurrencyMap.get(currencynumber);
                if (currencyId == null || currencyId == 0L) {
                    HashMap<String, String> failMap = new HashMap<String, String>(6);
                    failMap.put("bizdatacode", dataModel.getBizdatacode());
                    failMap.put("status", "0");
                    String errorCode = BizDataFailStatusEnum.FAILSTATUS_1089.getCode();
                    failMap.put("errorcode", errorCode);
                    failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                    failList.add(failMap);
                    continue;
                }
                currencySuccList.add(dataModel);
            }
        } else {
            currencySuccList = dataModelList;
        }
        return currencySuccList;
    }

    private List<BizDataSalaryFileMapModel> bizItemPropCheck(List<BizDataSalaryFileMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheBizItemPropMap) {
        HashSet<String> bizItemPropSet = new HashSet<String>(16);
        for (BizDataSalaryFileMapModel dataModel : dataModelList) {
            List<BizItemPropDataModel> propdatalist = dataModel.getPropdatalist();
            if (propdatalist == null || propdatalist.size() == 0) continue;
            for (BizItemPropDataModel bizItemPropDataModel : propdatalist) {
                String propNumber = bizItemPropDataModel.getBizitempropnumber();
                if (SWCStringUtils.isEmpty((String)propNumber)) continue;
                bizItemPropSet.add(propNumber);
            }
        }
        ArrayList<BizDataSalaryFileMapModel> propSuccList = new ArrayList(dataModelList.size());
        if (bizItemPropSet.size() > 0) {
            ArrayList<QFilter> propFilterList = new ArrayList<QFilter>(3);
            propFilterList.add(new QFilter("status", "=", (Object)"C"));
            propFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> bizItemPropMap = helper.buildBaseDataIdAndNumberRelation("hsbs_bizitemprop", new ArrayList<String>(bizItemPropSet), propFilterList);
            cacheBizItemPropMap.putAll(bizItemPropMap);
            for (BizDataSalaryFileMapModel dataModel : dataModelList) {
                List<BizItemPropDataModel> propdatalist = dataModel.getPropdatalist();
                if (propdatalist == null || propdatalist.size() == 0) {
                    propSuccList.add(dataModel);
                    continue;
                }
                boolean isStop = false;
                for (BizItemPropDataModel bizItemPropDataModel : propdatalist) {
                    Long propId;
                    String propNumber = bizItemPropDataModel.getBizitempropnumber();
                    if (!SWCStringUtils.isNotEmpty((String)propNumber) || (propId = cacheBizItemPropMap.get(propNumber)) != null && propId != 0L) continue;
                    HashMap<String, String> failMap = new HashMap<String, String>(6);
                    failMap.put("bizdatacode", dataModel.getBizdatacode());
                    failMap.put("status", "0");
                    String errorCode = BizDataFailStatusEnum.FAILSTATUS_1025.getCode();
                    failMap.put("errorcode", errorCode);
                    failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                    failList.add(failMap);
                    isStop = true;
                    break;
                }
                if (isStop) continue;
                propSuccList.add(dataModel);
            }
        } else {
            propSuccList = dataModelList;
        }
        return propSuccList;
    }

    private List<BizDataDepempMapModel> bizItemPropDepempCheck(List<BizDataDepempMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheBizItemPropMap) {
        HashSet<String> bizItemPropSet = new HashSet<String>(16);
        for (BizDataDepempMapModel dataModel : dataModelList) {
            List<BizItemPropDataModel> propdatalist = dataModel.getPropdatalist();
            if (propdatalist == null || propdatalist.size() == 0) continue;
            for (BizItemPropDataModel bizItemPropDataModel : propdatalist) {
                String propNumber = bizItemPropDataModel.getBizitempropnumber();
                if (SWCStringUtils.isEmpty((String)propNumber)) continue;
                bizItemPropSet.add(propNumber);
            }
        }
        ArrayList<BizDataDepempMapModel> propSuccList = new ArrayList(dataModelList.size());
        if (bizItemPropSet.size() > 0) {
            ArrayList<QFilter> propFilterList = new ArrayList<QFilter>(3);
            propFilterList.add(new QFilter("status", "=", (Object)"C"));
            propFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> bizItemPropMap = helper.buildBaseDataIdAndNumberRelation("hsbs_bizitemprop", new ArrayList<String>(bizItemPropSet), propFilterList);
            cacheBizItemPropMap.putAll(bizItemPropMap);
            for (BizDataDepempMapModel dataModel : dataModelList) {
                List<BizItemPropDataModel> propdatalist = dataModel.getPropdatalist();
                if (propdatalist == null || propdatalist.size() == 0) {
                    propSuccList.add(dataModel);
                    continue;
                }
                boolean isStop = false;
                for (BizItemPropDataModel bizItemPropDataModel : propdatalist) {
                    Long propId;
                    String propNumber = bizItemPropDataModel.getBizitempropnumber();
                    if (!SWCStringUtils.isNotEmpty((String)propNumber) || (propId = cacheBizItemPropMap.get(propNumber)) != null && propId != 0L) continue;
                    HashMap<String, String> failMap = new HashMap<String, String>(6);
                    failMap.put("bizdatacode", dataModel.getBizdatacode());
                    failMap.put("status", "0");
                    String errorCode = BizDataFailStatusEnum.FAILSTATUS_1025.getCode();
                    failMap.put("errorcode", errorCode);
                    failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                    failList.add(failMap);
                    isStop = true;
                    break;
                }
                if (isStop) continue;
                propSuccList.add(dataModel);
            }
        } else {
            propSuccList = dataModelList;
        }
        return propSuccList;
    }

    private List<BizDataSalaryFileMapModel> actionCheck(List<BizDataSalaryFileMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheActionMap) {
        HashSet<String> actionSet = new HashSet<String>(16);
        for (BizDataSalaryFileMapModel dataModel : dataModelList) {
            String actionNumber;
            PersonChangeModel personChangeModel = dataModel.getPersonchangeinfo();
            if (personChangeModel == null || SWCStringUtils.isEmpty((String)(actionNumber = personChangeModel.getActionnumber()))) continue;
            actionSet.add(actionNumber);
        }
        ArrayList<BizDataSalaryFileMapModel> actionSuccList = new ArrayList(dataModelList.size());
        if (actionSet.size() > 0) {
            ArrayList<QFilter> actionFilterList = new ArrayList<QFilter>(3);
            actionFilterList.add(new QFilter("status", "=", (Object)"C"));
            actionFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> actionMap = helper.buildBaseDataIdAndNumberRelation("hbss_action", new ArrayList<String>(actionSet), actionFilterList);
            cacheActionMap.putAll(actionMap);
            for (BizDataSalaryFileMapModel dataModel : dataModelList) {
                PersonChangeModel personChangeModel = dataModel.getPersonchangeinfo();
                if (personChangeModel == null) {
                    actionSuccList.add(dataModel);
                    continue;
                }
                String actionNumber = personChangeModel.getActionnumber();
                if (SWCStringUtils.isNotEmpty((String)actionNumber)) {
                    Long actionId = cacheActionMap.get(actionNumber);
                    if (actionId == null || actionId == 0L) {
                        HashMap<String, String> failMap = new HashMap<String, String>(6);
                        failMap.put("bizdatacode", dataModel.getBizdatacode());
                        failMap.put("status", "0");
                        String errorCode = BizDataFailStatusEnum.FAILSTATUS_1026.getCode();
                        failMap.put("errorcode", errorCode);
                        failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                        failList.add(failMap);
                        continue;
                    }
                    actionSuccList.add(dataModel);
                    continue;
                }
                actionSuccList.add(dataModel);
            }
        } else {
            actionSuccList = dataModelList;
        }
        return actionSuccList;
    }

    private List<BizDataDepempMapModel> actionDepempCheck(List<BizDataDepempMapModel> dataModelList, BizDataServiceHelper helper, List<Map<String, Object>> failList, Map<String, Long> cacheActionMap) {
        HashSet<String> actionSet = new HashSet<String>(16);
        for (BizDataDepempMapModel dataModel : dataModelList) {
            String actionNumber;
            PersonChangeModel personChangeModel = dataModel.getPersonchangeinfo();
            if (personChangeModel == null || SWCStringUtils.isEmpty((String)(actionNumber = personChangeModel.getActionnumber()))) continue;
            actionSet.add(actionNumber);
        }
        ArrayList<BizDataDepempMapModel> actionSuccList = new ArrayList(dataModelList.size());
        if (actionSet.size() > 0) {
            ArrayList<QFilter> actionFilterList = new ArrayList<QFilter>(3);
            actionFilterList.add(new QFilter("status", "=", (Object)"C"));
            actionFilterList.add(new QFilter("enable", "=", (Object)"1"));
            Map<String, Long> actionMap = helper.buildBaseDataIdAndNumberRelation("hbss_action", new ArrayList<String>(actionSet), actionFilterList);
            cacheActionMap.putAll(actionMap);
            for (BizDataDepempMapModel dataModel : dataModelList) {
                PersonChangeModel personChangeModel = dataModel.getPersonchangeinfo();
                if (personChangeModel == null) {
                    actionSuccList.add(dataModel);
                    continue;
                }
                String actionNumber = personChangeModel.getActionnumber();
                if (SWCStringUtils.isNotEmpty((String)actionNumber)) {
                    Long actionId = cacheActionMap.get(actionNumber);
                    if (actionId == null || actionId == 0L) {
                        HashMap<String, String> failMap = new HashMap<String, String>(6);
                        failMap.put("bizdatacode", dataModel.getBizdatacode());
                        failMap.put("status", "0");
                        String errorCode = BizDataFailStatusEnum.FAILSTATUS_1026.getCode();
                        failMap.put("errorcode", errorCode);
                        failMap.put("errormsg", BizDataFailStatusEnum.getDesc((String)errorCode));
                        failList.add(failMap);
                        continue;
                    }
                    actionSuccList.add(dataModel);
                    continue;
                }
                actionSuccList.add(dataModel);
            }
        } else {
            actionSuccList = dataModelList;
        }
        return actionSuccList;
    }

    private CustomApiResult<List<BizDataCommonResponseModel>> buildFailErrorInfo(List<Map<String, Object>> failList) {
        CustomApiResult success = CustomApiResult.success(null);
        ArrayList<BizDataCommonResponseModel> retList = new ArrayList<BizDataCommonResponseModel>(failList.size());
        for (Map<String, Object> failMap : failList) {
            BizDataCommonResponseModel retModel = new BizDataCommonResponseModel();
            retModel.setBizdatacode((String)failMap.get("bizdatacode"));
            retModel.setStatus((String)failMap.get("status"));
            retModel.setErrorcode((String)failMap.get("errorcode"));
            retModel.setErrormsg((String)failMap.get("errormsg"));
            retList.add(retModel);
        }
        success.setData(retList);
        return success;
    }
}

