/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paynode;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.swc.hsas.business.paynode.PayNodeHelper;
import kd.swc.hsas.common.dto.PayNodeScmEntity;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import org.apache.commons.lang.SerializationUtils;

public class PayNodeCacheHelper {
    public static final String PAY_NODE_GRP_HIS_ENTRIES = "payNodeGrpHisEntries";
    public static final String PAY_NODE_SCM_ENTRIES = "payNodeScmEntries";
    public static final String PAY_NODE_SCM_APP_CACHE = "payNodeScm";
    public static final String START_FIELD_TYPE_MAP = "startFieldTypeMap";
    public static final String END_FIELD_TYPE_MAP = "endFieldTypeMap";
    public static final String PARENT_STATUS = "parentStatus";
    public static final String START_TIME_CHECK_BOX = "starttimebox";
    public static final String START_CAL_PERIOD = "startcalperiod";
    public static final String END_CAL_PERIOD = "endcalperiod";

    public static Map<String, Object> parseParentPageData(String parentPageId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        ISWCAppCache payNodeScmAppCache = SWCAppCache.get((String)(PAY_NODE_SCM_APP_CACHE + parentPageId));
        byte[] payNodeScmEntryBytes = (byte[])payNodeScmAppCache.get(PAY_NODE_SCM_ENTRIES, byte[].class);
        DynamicObjectCollection payNodeScmEntries = (DynamicObjectCollection)PayNodeHelper.deserialize(payNodeScmEntryBytes);
        byte[] payNodeGrpHisEntryBytes = (byte[])payNodeScmAppCache.get(PAY_NODE_GRP_HIS_ENTRIES, byte[].class);
        DynamicObjectCollection payNodeGrpHisEntries = (DynamicObjectCollection)PayNodeHelper.deserialize(payNodeGrpHisEntryBytes);
        result.put(PAY_NODE_SCM_ENTRIES, payNodeScmEntries);
        result.put(PAY_NODE_GRP_HIS_ENTRIES, payNodeGrpHisEntries);
        result.put(PARENT_STATUS, payNodeScmAppCache.get(PARENT_STATUS, Integer.TYPE));
        result.put(START_FIELD_TYPE_MAP, payNodeScmAppCache.get(START_FIELD_TYPE_MAP, Map.class));
        result.put(END_FIELD_TYPE_MAP, payNodeScmAppCache.get(END_FIELD_TYPE_MAP, Map.class));
        return result;
    }

    public static void putAppCache(IFormView view, DynamicObjectCollection payNodeScmEntries, DynamicObjectCollection payNodeGrpHisEntries) {
        ISWCAppCache payNodeScmAppCache = SWCAppCache.get((String)(PAY_NODE_SCM_APP_CACHE + view.getPageId()));
        payNodeScmAppCache.put(PAY_NODE_SCM_ENTRIES, PayNodeHelper.serialize((Serializable)payNodeScmEntries));
        payNodeScmAppCache.put(PAY_NODE_GRP_HIS_ENTRIES, PayNodeHelper.serialize((Serializable)payNodeGrpHisEntries));
        payNodeScmAppCache.put(PARENT_STATUS, (Object)PayNodeHelper.getOperationStatus(view));
        HashMap<String, Boolean> startFieldTypeMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> endFieldTypeMap = new HashMap<String, Boolean>(16);
        for (DynamicObject dynamicObject : payNodeGrpHisEntries) {
            startFieldTypeMap.put(String.valueOf(dynamicObject.getPkValue()), dynamicObject.getBoolean(START_TIME_CHECK_BOX));
            endFieldTypeMap.put(String.valueOf(dynamicObject.getPkValue()), Boolean.TRUE);
        }
        payNodeScmAppCache.put(START_FIELD_TYPE_MAP, startFieldTypeMap);
        payNodeScmAppCache.put(END_FIELD_TYPE_MAP, endFieldTypeMap);
    }

    public static void putPayNodeScmToCache(IFormView view, List<PayNodeScmEntity> scmEntities) {
        SWCPageCache pageCache = new SWCPageCache(view);
        pageCache.put("PayNodeScmEntity", (Object)JSON.toJSONString(scmEntities));
    }

    public static List<PayNodeScmEntity> getPayNodeScmFromCache(IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        String str = (String)pageCache.get("PayNodeScmEntity", String.class);
        return JSON.parseArray((String)str, PayNodeScmEntity.class);
    }

    public static <T> void putToPageCache(IFormView view, String key, ArrayList<T> list) {
        SWCPageCache pageCache = new SWCPageCache(view);
        pageCache.put(key, (Object)SerializationUtils.serialize(list));
    }

    public static Serializable getFromPageCache(IFormView view, String key) {
        SWCPageCache pageCache = new SWCPageCache(view);
        return PayNodeHelper.deserialize((byte[])pageCache.get(key, byte[].class));
    }
}

