/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payrollgrp.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class PayRollGrpHelper {
    public static Long[] queryPayRollSceneList(QFilter filter) {
        return PayRollGrpHelper.queryEntityIdList("hsas_payrollscene", filter);
    }

    public static Long[] queryEntityIdList(String entityName, QFilter filter) {
        if (filter == null) {
            return new Long[0];
        }
        SWCDataServiceHelper sceneHelper = new SWCDataServiceHelper(entityName);
        Object[] payRollSceneInfoArr = sceneHelper.query("id", filter.toArray());
        if (SWCArrayUtils.isEmpty((Object[])payRollSceneInfoArr)) {
            return new Long[0];
        }
        return (Long[])Arrays.stream(payRollSceneInfoArr).map(dyObj -> dyObj.getLong("id")).toArray(Long[]::new);
    }

    public static Set<Long> queryInValidEntityIds(String entityNumber, Set<Long> entityIdSet) {
        if (entityIdSet.isEmpty() || entityNumber == null || entityNumber.trim().length() == 0) {
            return Collections.emptySet();
        }
        QFilter filter = new QFilter("enable", "=", (Object)"0");
        filter.and("id", "in", entityIdSet);
        if (!"hsbs_salslipsumview".equals(entityNumber)) {
            BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        }
        HashSet inValidEntityIds = Sets.newHashSet((Object[])PayRollGrpHelper.queryEntityIdList(entityNumber, filter));
        inValidEntityIds.remove(0L);
        return inValidEntityIds;
    }

    public static List<Long> queryInValidCalListViewIdList(Set<Long> calListViewIdSet) {
        if (calListViewIdSet.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        QFilter filter = new QFilter("enable", "=", (Object)"0");
        filter.and("id", "in", calListViewIdSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        return Arrays.asList(PayRollGrpHelper.queryEntityIdList("hsas_callistview", filter));
    }

    public static List<Long> queryAuditPayrollGrpIdList(Set<Long> payRollGrpIdSet) {
        if (payRollGrpIdSet.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("id", "in", payRollGrpIdSet);
        Object[] payRollGrpArr = helper.query("id", filter.toArray());
        if (SWCArrayUtils.isEmpty((Object[])payRollGrpArr)) {
            return new ArrayList<Long>(0);
        }
        return Arrays.stream(payRollGrpArr).map(dyObj -> dyObj.getLong("id")).collect(Collectors.toCollection(ArrayList::new));
    }
}

