/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payrollscene.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MainOrgEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.swc.hsas.business.payrollscene.errorinfo.PayRollSceneErrorInfo;
import kd.swc.hsas.business.payrollscene.helper.SWCPayRollSceneHelper;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCListUtils;

public class SWCPayRollSceneService {
    private static final Log logger = LogFactory.getLog(SWCPayRollSceneService.class);

    public static SWCPayRollSceneService createInstance() {
        return new SWCPayRollSceneService();
    }

    public void multiSetBeforeF7SelectListener(Object plugin, String ... fieldArr) {
        Optional.ofNullable(fieldArr).filter(arr -> !SWCArrayUtils.isEmpty((Object[])fieldArr)).ifPresent(arr -> {
            for (String field : arr) {
                BasedataEdit baseDataEdit = (BasedataEdit)((AbstractBasePlugIn)plugin).getControl(field);
                baseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
            }
        });
    }

    public void openPopupOfF7Name(String f7Name, AbstractFormPlugin formPlugin, Map<String, Object> customParams, boolean needCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (customParams != null && customParams.size() > 0) {
            showParameter.setCustomParams(customParams);
        }
        if (needCallBack) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, f7Name));
            formPlugin.getPageCache().put(f7Name + formPlugin.getView().getPageId(), showParameter.getPageId());
        }
        showParameter.setFormId(f7Name);
        formPlugin.getView().showForm(showParameter);
    }

    public QFilter getCommonQFilter(DynamicObject dataEntity, String orgField, String countryField, String customKey) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        if (orgField != null && customKey != null) {
            String entityID = null;
            switch (customKey) {
                case "calrule": {
                    entityID = "hsas_calrule";
                    break;
                }
                case "periodtype": {
                    entityID = "hsbs_calperiodtype";
                    break;
                }
                case "callistview": {
                    entityID = "hsas_callistview";
                    break;
                }
                case "callistrule": {
                    entityID = "hsas_callistrule";
                    break;
                }
                case "calbordermulbd": {
                    entityID = "hsbs_bizitem";
                    break;
                }
                case "salarycalcstyle": {
                    entityID = "hsas_salarycalcstyle";
                    break;
                }
                case "salaryslipview": {
                    entityID = "hsbs_salaryslipview";
                    break;
                }
                case "payrollgrpmulsum": {
                    entityID = "hsbs_salslipsumview";
                    break;
                }
                case "schemeaftercal": {
                    entityID = "hsas_schemeaftercal";
                    break;
                }
                case "genbizdata": {
                    entityID = "hsas_genbizdata";
                    break;
                }
            }
            if (entityID != null) {
                logger.info("SWCPayRollSceneService.getCommonQFilter: the org id is {}, and entity name is {}", (Object)dataEntity.getLong("org.id"), (Object)entityID);
                if ("hsas_callistrule".equals(entityID)) {
                    filter.and("org", "=", (Object)dataEntity.getLong("org.id"));
                } else {
                    filter.and(SWCPermissionServiceHelper.getBaseDataFilter((String)entityID, (Long)dataEntity.getLong("org.id")));
                }
            }
        }
        if (countryField != null) {
            long countryId = dataEntity.getLong("country.id");
            filter.and(AreaHelper.addCountryFilter((long)countryId));
        }
        return filter;
    }

    public Map<String, String> getErrMarkAndInfoMap(DynamicObjectCollection calBorderEntryEntity) {
        ArrayList<String> errSeqList = new ArrayList<String>(10);
        if (SWCListUtils.isEmpty((List)calBorderEntryEntity)) {
            return new HashMap<String, String>(0);
        }
        HashMap<Long, String> sumBizDataIdAndNameMap = new HashMap<Long, String>(16);
        HashMap<Long, String> sumSalaryCalStyleIdAndNameMap = new HashMap<Long, String>(calBorderEntryEntity.size());
        for (DynamicObject calBorderDyObj : calBorderEntryEntity) {
            DynamicObjectCollection multiBizData = calBorderDyObj.getDynamicObjectCollection("calbordermulbd");
            Integer seq = calBorderDyObj.getInt("seq");
            if ("1".equals(calBorderDyObj.getString("attachcondition"))) {
                if (SWCListUtils.isEmpty((List)multiBizData)) {
                    errSeqList.add(String.valueOf(seq));
                } else {
                    for (DynamicObject bizDataDyObj : multiBizData) {
                        DynamicObject bizData = bizDataDyObj.getDynamicObject("fbasedataid");
                        if (HRObjectUtils.isEmpty((Object)bizData)) continue;
                        sumBizDataIdAndNameMap.put((Long)bizData.getPkValue(), bizData.getString("name"));
                    }
                }
            }
            sumSalaryCalStyleIdAndNameMap.put(calBorderDyObj.getLong("salarycalcstyle.id"), calBorderDyObj.getString("salarycalcstyle.name"));
        }
        HashMap<String, String> errMarkAndInfoMap = new HashMap<String, String>(16);
        Set<Long> salaryCalStyleAuditedAndEnabledIdSet = SWCPayRollSceneHelper.queryAuditedAndEnableIds("hsas_salarycalcstyle", sumSalaryCalStyleIdAndNameMap.keySet());
        Set<Long> bizItemDataAuditedAndEnabledIdSet = SWCPayRollSceneHelper.queryAuditedAndEnableIds("hsbs_bizitem", sumBizDataIdAndNameMap.keySet());
        sumSalaryCalStyleIdAndNameMap.keySet().removeAll(salaryCalStyleAuditedAndEnabledIdSet);
        sumBizDataIdAndNameMap.keySet().removeAll(bizItemDataAuditedAndEnabledIdSet);
        this.getErrorNames(errMarkAndInfoMap, errSeqList, "calbordermulbd");
        this.getErrorNames(errMarkAndInfoMap, sumSalaryCalStyleIdAndNameMap.values(), "salarycalcstyle.id");
        this.getErrorNames(errMarkAndInfoMap, sumBizDataIdAndNameMap.values(), "errMulBd");
        return errMarkAndInfoMap;
    }

    private void getErrorNames(Map<String, String> errMarkAndInfoMap, Collection<String> errInfos, String errMarkName) {
        String commaLabel;
        Map<String, String> errMsgMap = PayRollSceneErrorInfo.getErrMsgMap();
        if (errMsgMap != null && (commaLabel = errMsgMap.get("CommaSeparator")) != null) {
            StringJoiner errSj = new StringJoiner(commaLabel);
            errInfos.forEach(errSj::add);
            if (errSj.length() > 0) {
                errMarkAndInfoMap.put(errMarkName, errSj.toString());
            }
        }
    }

    public List<String> checkFieldsAuditAndEnable(DynamicObject dataEntity) {
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("periodtype.id", "calrule.id", "callistview.id", "callistrule.id"));
        if (dataEntity.getBoolean("lssuepayslip")) {
            fields.add("salaryslipview.id");
        }
        Map<String, String> fieldAndEntityMap = PayRollTaskService.createInstance().getFieldAndEntityMap();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            String entityName;
            String field = (String)iterator.next();
            long pKId = dataEntity.getLong(field);
            if (pKId != 0L && fieldAndEntityMap != null && (entityName = fieldAndEntityMap.get(field)) != null && !PayRollTaskHelper.isCurrEntityAuditedAndEnable(entityName, pKId)) continue;
            iterator.remove();
        }
        return fields;
    }

    public void lockCommonFields(IFormView iFormView) {
        if (iFormView != null && BaseDataHisHelper.isHisPage((IFormView)iFormView)) {
            BasedataEdit basedataEdit;
            TextEdit numberEdit;
            MainOrgEdit orgEdit = (MainOrgEdit)iFormView.getControl("org");
            if (orgEdit != null) {
                orgEdit.setEnable(null, false, 0);
            }
            if ((numberEdit = (TextEdit)iFormView.getControl("number")) != null) {
                numberEdit.setEnable(null, false, 0);
            }
            if ((basedataEdit = (BasedataEdit)iFormView.getControl("country")) != null) {
                basedataEdit.setEnable(null, false, 0);
            }
        }
    }

    public Long getDefaultSchemeAfterCal() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_schemeaftercal");
        QFilter filter = new QFilter("number", "=", (Object)"1010_S");
        DynamicObjectCollection objects = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)objects)) {
            return 0L;
        }
        return ((DynamicObject)objects.get(0)).getLong("id");
    }

    public DynamicObject getSchemeAfterCalObjById(Long id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_schemeaftercal");
        QFilter filter = new QFilter("id", "=", (Object)id);
        String fields = "number,calapprove,costallot,genbizdata,nocountbizdata,nocountsinsur,nocountatt";
        DynamicObjectCollection schemeAfterCalObjs = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)schemeAfterCalObjs)) {
            return null;
        }
        return (DynamicObject)schemeAfterCalObjs.get(0);
    }

    public DynamicObject getSceneSchemeAfterCalObj(Long sceneId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter filter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject sceneObj = helper.queryOne("schemeaftercal.id", new QFilter[]{filter});
        if (sceneObj == null) {
            return null;
        }
        long schemeAfterCalId = sceneObj.getLong("schemeaftercal.id");
        helper = new SWCDataServiceHelper("hsas_schemeaftercal");
        filter = new QFilter("id", "=", (Object)schemeAfterCalId);
        String fields = "number,calapprove,costallot,genbizdata,nocountbizdata,nocountsinsur,nocountatt";
        DynamicObjectCollection schemeAfterCalObjs = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)schemeAfterCalObjs)) {
            return null;
        }
        return (DynamicObject)schemeAfterCalObjs.get(0);
    }

    public DynamicObject getGenBizDataConfBySceneId(Long sceneId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter filter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject sceneObj = helper.queryOne("genbizdata.id", new QFilter[]{filter});
        if (sceneObj == null) {
            return null;
        }
        long genBizDataConfId = sceneObj.getLong("genbizdata.id");
        helper = new SWCDataServiceHelper("hsas_genbizdata");
        filter = new QFilter("id", "=", (Object)genBizDataConfId);
        String fields = "isautogenbsed,basedatetype,month,datetype";
        DynamicObjectCollection genBizDataConfObjs = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)genBizDataConfObjs)) {
            return null;
        }
        return (DynamicObject)genBizDataConfObjs.get(0);
    }

    public DynamicObject getGenBizDataConfByTaskId(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = helper.queryOne("payrollscenev.id", new QFilter[]{filter});
        if (taskObj == null) {
            return null;
        }
        Long sceneId = taskObj.getLong("payrollscenev.id");
        return this.getGenBizDataConfBySceneId(sceneId);
    }

    public DynamicObject getAfterCalObjByTask(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = helper.queryOne("payrollscenev.id", new QFilter[]{filter});
        if (taskObj == null) {
            return null;
        }
        Long sceneId = taskObj.getLong("payrollscenev.id");
        return this.getSceneSchemeAfterCalObj(sceneId);
    }

    public DynamicObject getTaskDateInfo(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        return helper.queryOne("startdate,enddate,paydate", new QFilter[]{filter});
    }
}

