/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payrolltask.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.CalPayrollTaskConstants;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayRollTaskHelper {
    private static final Log logger = LogFactory.getLog(PayRollTaskService.class);

    public static DynamicObject queryDefaultTracker() {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("bos_user");
        return serviceHelper.queryOne((Object)RequestContext.get().getCurrUserId());
    }

    public static DynamicObject[] queryCalRuleVersionArr(long calRuleId, Date endDate) {
        logger.info("PayRollTaskHelper.queryCalRuleVersionArr,calRuleId = {}", (Object)calRuleId);
        QFilter filter = new QFilter("boid", "=", (Object)calRuleId);
        filter.and("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        filter.and("bsed", "<=", (Object)endDate);
        String selectProperties = "id,boid,calruleitementry.id,calruleitementry.ispayoutitem";
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        logger.info("PayRollTaskHelper.queryCalRuleVersionArr,filter = {}", (Object)filter);
        return helper.query(selectProperties, new QFilter[]{filter}, "boid asc,bsed desc");
    }

    public static Long queryCurrentTimePayRollGrpVId(long payRollGrpId, Date selectedDate) {
        Long payRollGrpVid;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("boid", "=", (Object)payRollGrpId);
        filter.and(PayRollTaskHelper.getDateFilter(selectedDate));
        filter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        DynamicObject payRollGrpVDyObj = helper.queryOne("id", new QFilter[]{filter});
        if (payRollGrpVDyObj == null || (payRollGrpVid = Long.valueOf(payRollGrpVDyObj.getLong("id"))) == 0L) {
            payRollGrpVid = null;
        }
        return payRollGrpVid;
    }

    private static QFilter getDateFilter(Date selectedDate) {
        selectedDate = HandleProrationHelper.replaceDateTime((Date)selectedDate, (String)"00:00:00");
        QFilter filter = new QFilter("bsed", "<=", (Object)selectedDate);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)selectedDate);
        bsledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(bsledFilter);
        return filter;
    }

    public static Map<String, Long> querySceneAndGroupDetailInfoMap(Long pkId) {
        Long periodTypeId;
        Long payRollGroupVId;
        Long payRollSceneVId;
        DynamicObject payRollSceneVDyObj;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrpschis");
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        DynamicObject payrollGrpScHisInfoDyObj = helper.queryOne("id,payrollscene.id,payrollscene.enable,payrollgroupv.id,payrollgroupv.country.id,callistview.id", new QFilter[]{filter});
        HashMap<String, Long> resultMap = new HashMap<String, Long>(4);
        if (SWCObjectUtils.isEmpty((Object)payrollGrpScHisInfoDyObj)) {
            return resultMap;
        }
        Long payRollSceneId = payrollGrpScHisInfoDyObj.getLong("payrollscene.id");
        if (payRollSceneId == 0L || (payRollSceneVDyObj = PayRollTaskHelper.queryPayRollSceneVId(payRollSceneId)) == null || (payRollSceneVId = Long.valueOf(payRollSceneVDyObj.getLong("id"))) == 0L || (payRollGroupVId = Long.valueOf(payrollGrpScHisInfoDyObj.getLong("payrollgroupv.id"))) == 0L || (periodTypeId = Long.valueOf(payRollSceneVDyObj.getLong("periodtype.id"))) == 0L) {
            return resultMap;
        }
        resultMap.put("calListViewLocation", CalPayrollTaskConstants.CAL_LIST_VIEW_IN_GROUP);
        Long calListViewId = payrollGrpScHisInfoDyObj.getLong("callistview.id");
        if (calListViewId == 0L) {
            resultMap.put("calListViewLocation", CalPayrollTaskConstants.CAL_LIST_VIEW_IN_SCENE);
            calListViewId = payRollSceneVDyObj.getLong("callistview.id");
        }
        Long calListViewVId = PayRollTaskHelper.queryCalListViewVId(calListViewId);
        Long calListRuleId = PayRollTaskHelper.getValidCalListRuleId(payRollSceneVDyObj.getLong("callistrule.id"));
        if (payrollGrpScHisInfoDyObj.getBoolean("payrollscene.enable")) {
            resultMap.put("payrollscene", payRollSceneId);
        }
        resultMap.put("payrollscenev", payRollSceneVId);
        resultMap.put("payrollgroupv", payRollGroupVId);
        resultMap.put("callistviewv", calListViewVId);
        resultMap.put("callistrule", calListRuleId);
        resultMap.put("periodtype", periodTypeId);
        resultMap.put("country", payrollGrpScHisInfoDyObj.getDynamicObject("payrollgroupv").getLong("country.id"));
        resultMap.put("calrule", payRollSceneVDyObj.getLong("calrule.id"));
        return resultMap;
    }

    private static Long getValidCalListRuleId(long calListRuleId) {
        if (calListRuleId == 0L) {
            return 0L;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_callistrule");
        QFilter idFilter = new QFilter("id", "=", (Object)calListRuleId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        if (helper.count(new QFilter[]{idFilter, statusFilter, enableFilter, hisCurrFilter}) == 0) {
            return null;
        }
        return calListRuleId;
    }

    public static Long queryCalListViewVId(Long calListViewId) {
        return calListViewId;
    }

    public static Map<Long, Long> querySceneAndGroupBaseInfoMap(Long pkId) {
        Long payRollGroupVId;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrpschis");
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        DynamicObject sceneInfoDyObj = helper.queryOne("id,payrollscene.id,payrollgroupv.id", new QFilter[]{filter});
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(1);
        if (SWCObjectUtils.isEmpty((Object)sceneInfoDyObj)) {
            return resultMap;
        }
        Long payRollSceneId = sceneInfoDyObj.getLong("payrollscene.id");
        if (payRollSceneId == 0L || (payRollGroupVId = Long.valueOf(sceneInfoDyObj.getLong("payrollgroupv.id"))) == 0L) {
            return resultMap;
        }
        resultMap.put(payRollSceneId, payRollGroupVId);
        return resultMap;
    }

    private static DynamicObject queryPayRollSceneVId(Long payRollSceneId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter filterId = new QFilter("boid", "=", (Object)payRollSceneId);
        QFilter validFilter = new QFilter("datastatus", "=", (Object)"1");
        BaseDataHisHelper.addHisVerFilter((QFilter)validFilter);
        return helper.queryOne("id,callistview.id,periodtype.id,calrule.id,callistrule.id", new QFilter[]{filterId, validFilter});
    }

    public static int queryCalListRuleVCount(Long calListRuleID, Date pointDate) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_callistrule");
        QFilter filter = new QFilter("boid", "=", (Object)calListRuleID);
        Date selectedDate = HandleProrationHelper.replaceDateTime((Date)pointDate, (String)"23:59:59");
        filter.and("bsed", "<=", (Object)selectedDate);
        filter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        return helper.count(filter.toArray());
    }

    public static String queryTaskStatusByTaskId(Long taskPkId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String selectProperties = "id,taskstatus";
        DynamicObject calTask = helper.queryOriginalOne(selectProperties, (Object)taskPkId);
        String taskStatus = null;
        if (calTask != null) {
            taskStatus = calTask.getString("taskstatus");
        }
        return taskStatus;
    }

    public static int queryCalPersonCountByTaskId(Long taskPkId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter qFilter = new QFilter("caltask", "=", (Object)taskPkId);
        return helper.count(qFilter.toArray());
    }

    public static Long queryCalFrequencyId(Long periodTypeId) {
        Long calFrequencyId;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiodtype");
        QFilter qFilter = new QFilter("id", "=", (Object)periodTypeId);
        DynamicObject calFrequencyDyObj = helper.queryOne("calfrequency.id", new QFilter[]{qFilter});
        if (calFrequencyDyObj == null || (calFrequencyId = Long.valueOf(calFrequencyDyObj.getLong("calfrequency.id"))) == 0L) {
            return null;
        }
        return calFrequencyId;
    }

    public static int queryTotalCalCount(QFilter filter) {
        String maxCalCount;
        if (filter == null) {
            return 0;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calFrequencyDyObj = helper.queryOne("calcount", filter.toArray(), "calcount desc");
        if (calFrequencyDyObj == null || (maxCalCount = calFrequencyDyObj.getString("calcount")) == null) {
            return 0;
        }
        try {
            return Integer.parseInt(maxCalCount);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static DynamicObject queryPeriodTypeInfo(Long periodTypId) {
        if (periodTypId == null) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiodtype");
        QFilter qFilter = new QFilter("id", "=", (Object)periodTypId);
        return helper.queryOne("name,enable, calfrequency.id, entryentity.periodmasterid", new QFilter[]{qFilter});
    }

    public static int queryCount(String taskName) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter qFilter = new QFilter("name", "=", (Object)taskName);
        return helper.count(new QFilter[]{qFilter});
    }

    public static boolean isCurrEntityAuditedAndEnable(String entityName, long currEntityId) {
        if (SWCStringUtils.isEmpty((String)entityName) || currEntityId == 0L) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)currEntityId);
        qFilter.and(PayRollTaskHelper.getAuditAndEnableFilter(entityName));
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        return helper.isExists(qFilter.toArray());
    }

    public static QFilter getAuditAndEnableFilter(String entityName) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        return qFilter;
    }

    public static boolean isCurrEntityEffective(String entityName, long currEntityId) {
        if (currEntityId == 0L) {
            return false;
        }
        logger.info("PayRollTaskHelper.isCurrEntityEffective,currEntityId = {},entityName = {}", (Object)currEntityId, (Object)entityName);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        QFilter payRollGrpVFilter = new QFilter("id", "=", (Object)currEntityId);
        payRollGrpVFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        return helper.isExists(payRollGrpVFilter.toArray());
    }

    public static long queryCalListViewInPayRollGrpScV(long payRollGrpVId, long payRollSceneId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrpschis");
        QFilter filter = new QFilter("payrollgroupv", "=", (Object)payRollGrpVId);
        filter.and("payrollscene", "=", (Object)payRollSceneId);
        DynamicObject payRollGrpVEntityInfo = helper.queryOne("callistview.id", filter.toArray());
        if (SWCObjectUtils.isEmpty((Object)payRollGrpVEntityInfo)) {
            return 0L;
        }
        return payRollGrpVEntityInfo.getLong("callistview.id");
    }

    public static List<Long> queryPkIdsByAuthorizedFilter(String entityName, QFilter qFilter) {
        if (SWCStringUtils.isEmpty((String)entityName) || qFilter == null) {
            return new ArrayList<Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DynamicObjectCollection pkIdInfoColl = helper.queryOriginalCollection("id", qFilter.toArray());
        if (pkIdInfoColl == null) {
            return new ArrayList<Long>(0);
        }
        return pkIdInfoColl.stream().map(pkIdInfo -> pkIdInfo.getLong("id")).collect(Collectors.toList());
    }

    public static String getProrationCalValue(long payRollGroupVid, long payRollSceneId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("id", "=", (Object)payRollGroupVid);
        filter.and("payrollsceneentry.payrollscene.id", "=", (Object)payRollSceneId);
        DynamicObject data = helper.queryOriginalOne("id,payrollsceneentry.prorationcal", new QFilter[]{filter});
        if (data == null) {
            return "0";
        }
        return data.getString("payrollsceneentry.prorationcal");
    }
}

