/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payrolltask.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.StyleCss;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.CalPayrollTaskConstants;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskMutex;

public class PayRollTaskService {
    private static final String[] PAYROLL_TASK_NAME_PART_ARR = new String[]{"payrollgroup", "payrollscene", "period"};
    private static final Log logger = LogFactory.getLog(PayRollTaskService.class);

    private PayRollTaskService() {
    }

    public static PayRollTaskService createInstance() {
        return new PayRollTaskService();
    }

    public ListShowParameter getPayRollGroupEntityInfoShowParameter(long payRollGrpId, Date selectedDate) {
        Long payRollGrpVid = PayRollTaskHelper.queryCurrentTimePayRollGrpVId(payRollGrpId, selectedDate);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_payrollgrpschis", (boolean)false);
        StyleCss css = new StyleCss();
        css.setWidth("700px");
        css.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("payrollgroupv", "in", (Object)payRollGrpVid));
        showParameter.setCustomParam("payRollGrpId", (Object)payRollGrpId);
        showParameter.setHasRight(true);
        return showParameter;
    }

    public Object checkPeriodTypeAndGetPeriodPkIdList(DynamicObject periodTypeDyObj) {
        if (SWCObjectUtils.isEmpty((Object)periodTypeDyObj)) {
            return null;
        }
        if ("0".equals(periodTypeDyObj.getString("enable"))) {
            String format = ResManager.loadKDString((String)"\u201c\u671f\u95f4\u7c7b\u578b\u201d\uff1a%s\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4f7f\u7528\u671f\u95f4\u6570\u636e\u3002", (String)"PayRollTaskService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            return String.format(Locale.ROOT, format, periodTypeDyObj.getString("name"));
        }
        DynamicObjectCollection periodInfos = periodTypeDyObj.getDynamicObjectCollection("entryentity");
        ArrayList periodInfoIds = Lists.newArrayListWithExpectedSize((int)periodInfos.size());
        for (DynamicObject periodInfo : periodInfos) {
            periodInfoIds.add((Long)periodInfo.getPkValue());
        }
        return periodInfoIds;
    }

    public String checkCalListRuleV(Long calListRuleID, Date endDate) {
        if (PayRollTaskHelper.queryCalListRuleVCount(calListRuleID, endDate) == 0) {
            return ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u65e0\u53ef\u7528\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        return null;
    }

    public void setDateAboutPeriodAndCalRuleV(IFormView currView, DynamicObject periodInfo, long calRuleId) {
        String[][] dateKeyValueArr = new String[][]{{"payrollyearshow", "periodyear"}, {"payrolldate", "perioddate"}, {"STARTDATE", "startdate"}, {"ENDDATE", "enddate"}, {"exratedate", "ratedate"}, {"paydate", "paydate"}};
        int currIndex = 0;
        int valueIndex = 1;
        IDataModel dataModel = currView.getModel();
        for (int i = 0; i < dateKeyValueArr.length; ++i) {
            dataModel.setValue(dateKeyValueArr[i][currIndex], (Object)periodInfo.getDate(dateKeyValueArr[i][valueIndex]));
        }
        Date endDate = periodInfo.getDate("enddate");
        this.setPayrollYearAndMonth(dataModel, periodInfo.getDate("perioddate"));
        this.setCalRuleV(currView, calRuleId, endDate);
        this.setCalRuleVF7Filter(currView, calRuleId, endDate);
        this.verifyPayrollGrpV(currView, endDate);
    }

    private void setPayrollYearAndMonth(IDataModel dataModel, Date payRollDate) {
        if (payRollDate != null) {
            int year = SWCDateTimeUtils.getYear((Date)payRollDate);
            int month = SWCDateTimeUtils.getMonth((Date)payRollDate);
            dataModel.setValue("payrollyear", (Object)year);
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, 1);
            dataModel.setValue("payrollmonth", (Object)month);
        } else {
            dataModel.setValue("payrollyear", (Object)"");
            dataModel.setValue("payrollmonth", (Object)"");
        }
    }

    public void setCalRuleV(IFormView currView, long calRuleId, Date endDate) {
        IDataModel model = currView.getModel();
        if (calRuleId == 0L) {
            currView.setEnable(Boolean.FALSE, new String[]{"calrulev"});
            model.setValue("calrulev", null);
        } else {
            DynamicObject[] calRuleVersionArr = PayRollTaskHelper.queryCalRuleVersionArr(calRuleId, endDate);
            if (calRuleVersionArr != null && calRuleVersionArr.length > 0) {
                currView.getModel().setValue("calrulev", (Object)calRuleVersionArr[0].getLong("id"));
            } else {
                model.setValue("calrulev", null);
                currView.getPageCache().put("isCalRuleVF7Null", "true");
                currView.showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5728\u85aa\u8d44\u7ed3\u675f\u65e5\u671f\u524d\u4e0d\u5b58\u5728\u5df2\u751f\u6548\u7684\u6570\u636e\u7248\u672c\uff0c\u8bf7\u65b0\u589e\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4fe1\u606f\u6216\u66f4\u6539\u671f\u95f4\u3002", (String)"PayRollTaskService_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            currView.setEnable(Boolean.TRUE, new String[]{"calrulev"});
        }
    }

    public void setCalRuleVF7Filter(IFormView currView, long calRuleId, Date endDate) {
        BasedataEdit calRuleVF7 = (BasedataEdit)currView.getControl("calrulev");
        if (calRuleId != 0L) {
            logger.info("PayRollTaskService.setCalRuleVF7Filter,calRuleId = {}", (Object)calRuleId);
            QFilter qFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
            qFilter.and("boid", "=", (Object)calRuleId);
            BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
            if (null != endDate) {
                qFilter.and("bsed", "<=", (Object)endDate);
            }
            calRuleVF7.setQFilter(qFilter);
            logger.info("PayRollTaskService.setCalRuleVF7Filter,qFilter = {}", (Object)qFilter);
        }
    }

    public void verifyPayrollGrpV(IFormView currView, Date endDate) {
        IDataModel dataModel = currView.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        DynamicObject payrollGrpV = dataEntity.getDynamicObject("payrollgroupv");
        if (!SWCObjectUtils.isEmpty((Object)payrollGrpV)) {
            Date bsed = payrollGrpV.getDate("bsed");
            if (endDate != null && bsed != null) {
                endDate = HandleProrationHelper.replaceDateTime((Date)endDate, (String)"23:59:59");
                if (bsed.after(endDate = SWCDateTimeUtils.getDateWithoutMinTs((Date)endDate))) {
                    currView.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u5728\u85aa\u8d44\u8d77\u6b62\u65e5\u671f\u8303\u56f4\u5185\u65e0\u6548\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u9519\u8bef\u6570\u636e\uff0c\u5efa\u8bae\u91cd\u65b0\u7ef4\u62a4\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u6216\u9009\u62e9\u5176\u4ed6\u671f\u95f4\u3002", (String)"PayRollTaskService_3", (String)"swc-hsas-business", (Object[])new Object[0]));
                }
            }
        }
    }

    public static Object checkAndGetPayRollGroupInfo(Long pkId) {
        Map<String, Long> resultMap;
        if (pkId == null || (resultMap = PayRollTaskHelper.querySceneAndGroupDetailInfoMap(pkId)).isEmpty()) {
            return null;
        }
        ArrayList<String> errMsgList = new ArrayList<String>(2);
        String errMsg = null;
        if (resultMap.get("payrollscene") == null) {
            errMsgList.add(PayRollTaskService.getFieldErrMsgWhenSaveMap(false).get("payrollscene.id"));
        }
        if (resultMap.get("callistviewv") == null) {
            errMsg = CalPayrollTaskConstants.CAL_LIST_VIEW_IN_GROUP.equals(resultMap.get("calListViewLocation")) ? ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u85aa\u8d44\u6838\u7b97\u573a\u666f\u5206\u5f55\u4e0a\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_4", (String)"swc-hsas-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_5", (String)"swc-hsas-business", (Object[])new Object[0]);
            errMsgList.add(errMsg);
        }
        if (resultMap.get("callistrule") == null) {
            errMsg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_11", (String)"swc-hsas-business", (Object[])new Object[0]);
            errMsgList.add(errMsg);
        }
        if (!errMsgList.isEmpty()) {
            return errMsgList;
        }
        resultMap.remove("callistrule");
        resultMap.remove("calListViewLocation");
        return resultMap;
    }

    public Long getDyObjFieldId(DynamicObject dyObj, String proName) {
        Long pkId;
        if (dyObj == null || (pkId = Long.valueOf(dyObj.getLong(proName + ".id"))) == 0L) {
            return null;
        }
        return pkId;
    }

    public Long getFieldPkId(DynamicObject dyObj) {
        Long pkId;
        if (dyObj == null || (pkId = Long.valueOf(dyObj.getLong("id"))) == 0L) {
            return null;
        }
        return pkId;
    }

    public Long getPkId(Object pkId) {
        Long currPkId = null;
        if (pkId == null || pkId instanceof Long && (currPkId = (Long)pkId) == 0L || pkId instanceof Integer && (currPkId = Long.valueOf(((Integer)pkId).longValue())) == 0L) {
            return null;
        }
        return currPkId;
    }

    public String checkAllowModified(Long taskPkId, String pagetaskStatus) {
        String taskStatus = PayRollTaskHelper.queryTaskStatusByTaskId(taskPkId);
        if (taskStatus == null) {
            return null;
        }
        if (!SWCStringUtils.equals((String)pagetaskStatus, (String)taskStatus)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u5df2\u8fdb\u884c\u8fc7\u6838\u7b97\u540d\u5355\u64cd\u4f5c\uff0c\u8bf7\u9000\u51fa\u5f53\u524d\u9875\u9762\u540e\u91cd\u65b0\u8fdb\u5165\u3002", (String)"PayRollTaskService_6", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean verifyHasPayoutItem(DynamicObject calRuleVObj) {
        if (calRuleVObj != null) {
            DynamicObjectCollection calRuleVEnt = calRuleVObj.getDynamicObjectCollection("calruleitementry");
            for (DynamicObject ent : calRuleVEnt) {
                boolean isPayOutItem = ent.getBoolean("ispayoutitem");
                if (!isPayOutItem) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkPeriodTypeInfoAndSetFilterForPeriod(AbstractFormPlugin plugIn, Long periodTypeId) {
        DynamicObject periodTypeInfo = PayRollTaskHelper.queryPeriodTypeInfo(periodTypeId);
        Object result = this.checkPeriodTypeAndGetPeriodPkIdList(periodTypeInfo);
        if (result == null) {
            return true;
        }
        if (result instanceof String) {
            plugIn.getView().showErrorNotification((String)result);
            return true;
        }
        if (result instanceof List) {
            QFilter qFilter = new QFilter("id", "in", result);
            BasedataEdit periodEditF7 = (BasedataEdit)plugIn.getControl("period");
            periodEditF7.setQFilter(qFilter);
            return false;
        }
        return true;
    }

    public String getCalCount(DynamicObject dataEntity) {
        QFilter filter = this.getGrpSceneAndPeriodFilter(dataEntity, null);
        if (filter != null) {
            int maxCount = PayRollTaskHelper.queryTotalCalCount(filter);
            return maxCount + 1 + "";
        }
        return null;
    }

    private QFilter getGrpSceneAndPeriodFilter(DynamicObject dataEntity, String taskType) {
        long payPeriodId;
        long payRollSceneId;
        long payRollGroupId = dataEntity.getLong("payrollgroup.id");
        if (payRollGroupId != 0L && (payRollSceneId = dataEntity.getLong("payrollscene.id")) != 0L && (payPeriodId = dataEntity.getLong("period.id")) != 0L) {
            return PayRollTaskService.getGrpSceneAndPeriodFilter(payRollGroupId, payRollSceneId, payPeriodId, taskType);
        }
        return null;
    }

    public static QFilter getGrpSceneAndPeriodFilter(long payRollGroupId, long payRollSceneId, long payPeriodId, String taskType) {
        QFilter filter = new QFilter("payrollgroup", "=", (Object)payRollGroupId);
        filter.and("payrollscene", "=", (Object)payRollSceneId);
        filter.and("period", "=", (Object)payPeriodId);
        if (taskType != null) {
            filter.and("tasktype", "=", (Object)taskType);
        }
        filter.and("taskstatus", "!=", (Object)CalPayrollTaskStateEnum.DISUSED.getCode());
        return filter;
    }

    public Map<String, String> addPayrollTask(DynamicObject srcTaskInfoDyObj) {
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask");
        DynamicObject calTask = (DynamicObject)type.createInstance();
        this.fillCalTaskDy(srcTaskInfoDyObj, calTask);
        String calCount = this.getCalCount(srcTaskInfoDyObj);
        if (calCount == null) {
            calCount = "1";
        }
        calTask.set("calcount", (Object)calCount);
        String number = CodeRuleHelper.getNumber((DynamicObject)calTask, null);
        calTask.set("number", (Object)number);
        long payrollTaskId = DB.genLongId((String)"hsas_calpayrolltask");
        calTask.set("masterid", (Object)payrollTaskId);
        calTask.set("id", (Object)payrollTaskId);
        List<String> orderFieldList = Arrays.asList("payrollgroup.id", "payrollscene.id", "calrule.id", "periodtype.id", "callistrule.id");
        Map<String, String> resultMap = this.checkFieldsBeforeSaveDataAndGetErrMap(calTask, orderFieldList);
        if (!resultMap.isEmpty()) {
            return resultMap;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            calTaskHelper.saveOne(calTask);
        }
        resultMap.put("name", calTask.getString("name"));
        resultMap.put("id", payrollTaskId + "");
        return resultMap;
    }

    private void fillCalTaskDy(DynamicObject srcTaskInfoDyObj, DynamicObject calTask) {
        DynamicObject calPeriodObj;
        calTask.set("name", (Object)srcTaskInfoDyObj.getString("name"));
        calTask.set("simplename", (Object)"");
        calTask.set("calpersoncount", (Object)0);
        calTask.set("handlestate", (Object)"0");
        calTask.set("viewdetailfield", (Object)"0");
        String tasktype = srcTaskInfoDyObj.getString("tasktype");
        calTask.set("tasktype", (Object)tasktype);
        DynamicObject payrollGroupInfo = srcTaskInfoDyObj.getDynamicObject("payrollgroup");
        DynamicObject payrollGroupVInfo = srcTaskInfoDyObj.getDynamicObject("payrollgroupv");
        calTask.set("payrollgroup", (Object)payrollGroupInfo);
        calTask.set("country", (Object)payrollGroupVInfo.getLong("country.id"));
        DynamicObject payrollSceneInfo = srcTaskInfoDyObj.getDynamicObject("payrollscene");
        DynamicObject payrollSceneVInfo = srcTaskInfoDyObj.getDynamicObject("payrollscenev");
        calTask.set("payrollscene", (Object)payrollSceneInfo);
        calTask.set("islimitadd", (Object)Boolean.FALSE);
        if (SWCStringUtils.equals((String)tasktype, (String)"1")) {
            calTask.set("islimitadd", payrollSceneInfo.get("islimitadd"));
        }
        calTask.set("payrollscenev", (Object)payrollSceneVInfo);
        calTask.set("callistviewv", (Object)srcTaskInfoDyObj.getDynamicObject("callistviewv"));
        DynamicObject periodInfo = srcTaskInfoDyObj.getDynamicObject("period");
        calTask.set("period", (Object)periodInfo);
        calTask.set("isautoaddperson", (Object)srcTaskInfoDyObj.getBoolean("isautoaddperson"));
        this.copyMulBaseDataField(srcTaskInfoDyObj, calTask, "tracker");
        calTask.set("description", (Object)srcTaskInfoDyObj.getString("description"));
        calTask.set("calrule", (Object)payrollSceneVInfo.getDynamicObject("calrule"));
        calTask.set("calrulev", (Object)srcTaskInfoDyObj.getDynamicObject("calrulev"));
        DynamicObject periodTypeInfo = payrollSceneVInfo.getDynamicObject("periodtype");
        calTask.set("periodtype", (Object)periodTypeInfo);
        calTask.set("calfrequency", (Object)periodInfo.getLong("periodcalfrequency.id"));
        calTask.set("STARTDATE", (Object)periodInfo.getDate("startdate"));
        calTask.set("ENDDATE", (Object)periodInfo.getDate("enddate"));
        calTask.set("exratedate", (Object)periodInfo.getDate("ratedate"));
        calTask.set("paydate", (Object)periodInfo.getDate("paydate"));
        Date payRollDate = periodInfo.getDate("perioddate");
        if (payRollDate != null) {
            int payrollYear = SWCDateTimeUtils.getYear((Date)payRollDate);
            int month = SWCDateTimeUtils.getMonth((Date)payRollDate);
            calTask.set("payrollyear", (Object)payrollYear);
            Calendar calendar = Calendar.getInstance();
            calendar.set(payrollYear, month - 1, 1);
            calTask.set("payrollmonth", (Object)month);
            calTask.set("payrolldate", (Object)payRollDate);
            if (payrollYear != 0) {
                calendar.set(1, payrollYear);
                calTask.set("payrollyearshow", (Object)calendar.getTime());
            }
        }
        calTask.set("payrollgroupv", (Object)payrollGroupVInfo);
        calTask.set("org", (Object)payrollGroupVInfo.getDynamicObject("org"));
        calTask.set("aftercal", (Object)payrollSceneVInfo.getString("aftercal"));
        calTask.set("tasknewmethod", (Object)"1");
        calTask.set("tasknewtplhis", null);
        calTask.set("taskstatus", (Object)CalPayrollTaskStateEnum.CREATE.getCode());
        calTask.set("createtime", (Object)new Date());
        calTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        calTask.set("modifytime", null);
        calTask.set("modifier", (Object)0L);
        calTask.set("status", (Object)"A");
        calTask.set("disabler", (Object)0L);
        calTask.set("disabledate", null);
        calTask.set("enable", (Object)"1");
        calTask.set("index", (Object)0);
        calTask.set("issyspreset", (Object)"0");
        if (payrollSceneVInfo.getBoolean("isenableatt") && !SWCObjectUtils.isEmpty((Object)(calPeriodObj = this.getAttDateRange(payrollSceneVInfo, periodInfo, periodTypeInfo)))) {
            calTask.set("ATTSTARTDATE", (Object)calPeriodObj.getDate("STARTDATE"));
            calTask.set("ATTENDDATE", (Object)calPeriodObj.getDate("ENDDATE"));
        }
        calTask.set("ishandleproration", (Object)PayRollTaskHelper.getProrationCalValue(payrollGroupVInfo.getLong("id"), payrollSceneInfo.getLong("id")));
    }

    public DynamicObject getAttDateRange(DynamicObject payrollSceneInfo, DynamicObject calTaskPeriod, DynamicObject calTaskPeriodType) {
        DynamicObject targetCalPeriod = null;
        if (SWCObjectUtils.isEmpty((Object)calTaskPeriod) || SWCObjectUtils.isEmpty((Object)calTaskPeriodType)) {
            return targetCalPeriod;
        }
        Long calTaskPeriodId = calTaskPeriod.getLong("id");
        Long calTaskPeriodTypeId = calTaskPeriodType.getLong("id");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiod");
        DynamicObjectCollection calPeriods = helper.queryOriginalCollection("id,periodtypeid,startdate,enddate", new QFilter[]{new QFilter("periodtypeid", "=", (Object)calTaskPeriodTypeId)}, "startdate asc");
        String matchAttPeriod = payrollSceneInfo.getString("matchattperiod");
        for (int index = 0; index < calPeriods.size(); ++index) {
            int targetIndex;
            DynamicObject calPeriod = (DynamicObject)calPeriods.get(index);
            if (calPeriod.getLong("id") != calTaskPeriodId.longValue()) continue;
            if ("0".equals(matchAttPeriod)) {
                targetCalPeriod = calPeriod;
                break;
            }
            int n = targetIndex = "1".equals(matchAttPeriod) ? index - 1 : index - 2;
            if (targetIndex < 0) break;
            targetCalPeriod = (DynamicObject)calPeriods.get(targetIndex);
            break;
        }
        return targetCalPeriod;
    }

    public void copyMulBaseDataField(DynamicObject srcTaskInfoDyObj, DynamicObject targetCalTask, String mulBaseDataField) {
        DynamicObjectCollection multiDataColl = srcTaskInfoDyObj.getDynamicObjectCollection(mulBaseDataField);
        if (SWCListUtils.isEmpty((List)multiDataColl)) {
            return;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)targetCalTask.getDataEntityType().getProperties().get((Object)mulBaseDataField);
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp baseDataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)targetCalTask);
        for (DynamicObject dataDyObj : multiDataColl) {
            DynamicObject baseDataObj = dataDyObj.getDynamicObject("fbasedataid");
            Long currentUserId = (Long)baseDataObj.getPkValue();
            DynamicObject newRow = new DynamicObject(subEntityType);
            rows.add((Object)newRow);
            DynamicObject newBaseDataObj = BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (DynamicObjectType)baseDataProp.getDynamicComplexPropertyType());
            baseDataProp.setValue((Object)newRow, (Object)newBaseDataObj);
        }
    }

    public String autoAddCalPerson(Long calTaskId) {
        CalPayRollTaskMutex calPayRollTaskMutex = PayrollTaskHelper.tryLock((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
        if (calPayRollTaskMutex == null) {
            logger.info("PayRollTaskService.autoAddCalPerson: begin to add person automatically, and the start time: {}", (Object)SWCDateTimeUtils.format((Date)new Date()));
            String errorInfo = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ICalPersonService", (String)"addCalPersonWhenCreateTask", (Object[])new Object[]{calTaskId});
            logger.info("autoAddCalPerson end,calTaskId = {}", (Object)calTaskId);
            if (SWCStringUtils.isNotEmpty((String)errorInfo)) {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
            }
            return errorInfo;
        }
        logger.info("autoAddCalPerson lock error ,calTaskId = {}", (Object)calTaskId);
        String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6b63\u5728{1}\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\u64cd\u4f5c\u3002", (String)"PayRollTaskService_42", (String)"swc-hsas-business", (Object[])new Object[]{calPayRollTaskMutex.getCalPersonOperationEnum().getOperationName()});
        return msg;
    }

    public static Map<String, Object> checkFieldsMustInput(Object fieldObj) {
        if (SWCObjectUtils.isEmpty((Object)fieldObj)) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        StringBuilder tipHead = new StringBuilder();
        FieldTip nameTip = PayRollTaskService.getFieldTip(Boolean.FALSE, "name");
        tipHead.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"PayRollTaskService_8", (String)"swc-hsas-business", (Object[])new Object[0]));
        resultMap.put("errMsg", tipHead.toString());
        resultMap.put("FieldTip", nameTip);
        return resultMap;
    }

    private static FieldTip getFieldTip(Boolean isHide, String fieldName) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, fieldName, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728", (String)"PayRollTaskService_9", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldTip.setSuccess(false);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Collections.singletonList(fieldName));
        fieldTip.setDeleteRule(deleteRule);
        return fieldTip;
    }

    public Map<String, String> checkFieldsBeforeSaveDataAndGetErrMap(DynamicObject calTaskDy, List<String> orderFieldList) {
        HashMap<String, String> errFieldMap = new HashMap<String, String>(16);
        if (SWCListUtils.isEmpty(orderFieldList) || calTaskDy == null) {
            return errFieldMap;
        }
        ArrayList<String> allOrderFieldList = new ArrayList<String>(orderFieldList);
        allOrderFieldList.addAll(Arrays.asList(CalPayrollTaskConstants.CAL_LIST_VIEW_IN_GROUP.toString(), CalPayrollTaskConstants.CAL_LIST_VIEW_IN_SCENE.toString()));
        Date endDate = calTaskDy.getDate("ENDDATE");
        String errField = null;
        int errorIndex = this.checkFieldValid(orderFieldList, calTaskDy);
        if (errorIndex >= 0 || (errorIndex = this.checkCalListViewValid(calTaskDy, orderFieldList.size())) >= 0) {
            if (errorIndex == 0) {
                errFieldMap.put("isSaveErrorMark", "payrollgroup");
            } else {
                errFieldMap.put("isSaveErrorMark", "payrollscene");
            }
            errField = (String)allOrderFieldList.get(errorIndex);
        } else if (this.checkPeriodExist(calTaskDy)) {
            errFieldMap.put("isSaveErrorMark", "period");
            errField = "period.id";
        } else if (this.verifyCalListRuleV(calTaskDy, endDate)) {
            errFieldMap.put("isSaveErrorMark", "period");
            errField = "callistrulev.id";
        } else if (this.verifyCalRuleV(calTaskDy, endDate)) {
            errFieldMap.put("isSaveErrorMark", "calrulev");
            errField = "calrulev.id";
        } else if (this.verifyAttDateRange(calTaskDy, errFieldMap)) {
            errField = (String)errFieldMap.get("isSaveErrorMark");
        }
        if (errField != null) {
            errFieldMap.put("SaveErrorField", errField);
        }
        return errFieldMap;
    }

    private boolean verifyAttDateRange(DynamicObject calTaskDy, Map<String, String> errFieldMap) {
        DynamicObject payrollSceneVInfo = calTaskDy.getDynamicObject("payrollscenev");
        if (!payrollSceneVInfo.getBoolean("isenableatt")) {
            return false;
        }
        Date startDate = calTaskDy.getDate("ATTSTARTDATE");
        if (startDate == null) {
            String matchAttPeriod = payrollSceneVInfo.getString("matchattperiod");
            if ("1".equals(matchAttPeriod)) {
                errFieldMap.put("isSaveErrorMark", "matchLastPeriod");
            } else {
                errFieldMap.put("isSaveErrorMark", "matchBeforeLastPeriod");
            }
            return true;
        }
        return false;
    }

    private boolean checkPeriodExist(DynamicObject payrollTask) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiod");
        DynamicObject period = payrollTask.getDynamicObject("period");
        Object pkValue = period.getPkValue();
        return !helper.isExists(pkValue);
    }

    private boolean verifyCalListRuleV(DynamicObject calTaskDy, Date endDate) {
        Long calListRuleID;
        DynamicObject payRollSceneVInfo = calTaskDy.getDynamicObject("payrollscenev");
        return !SWCObjectUtils.isEmpty((Object)payRollSceneVInfo) && (calListRuleID = Long.valueOf(payRollSceneVInfo.getLong("callistrule.id"))) != 0L && PayRollTaskHelper.queryCalListRuleVCount(calListRuleID, endDate) == 0;
    }

    public boolean verifyCalRuleV(DynamicObject payrollTaskObj, Date endDate) {
        DynamicObject calRuleVObj = payrollTaskObj.getDynamicObject("calrulev");
        if (SWCObjectUtils.isEmpty((Object)calRuleVObj)) {
            logger.info("PayRollTaskHelper.verifyCalRuleV,calRuleVId is empty.");
            return true;
        }
        Date bsed = calRuleVObj.getDate("bsed");
        boolean isCurrEntityEffective = PayRollTaskHelper.isCurrEntityEffective("hsas_calrule", payrollTaskObj.getLong("calrulev.id"));
        logger.info("PayRollTaskHelper.verifyCalRuleV,calRuleVId = {}, endDate = {}, bsed = {}, isCurrEntityEffective={}", new Object[]{calRuleVObj.get("id"), endDate, bsed, isCurrEntityEffective});
        return endDate != null && bsed != null && endDate.before(bsed) || !isCurrEntityEffective;
    }

    public int checkFieldValid(List<String> orderFieldList, DynamicObject dataEntity) {
        if (SWCListUtils.isEmpty(orderFieldList)) {
            return -1;
        }
        Map<String, String> fieldAndEntityMap = this.getFieldAndEntityMap();
        for (int i = 0; i < orderFieldList.size(); ++i) {
            long fieldNameId;
            String fieldName = orderFieldList.get(i);
            String entityName = fieldAndEntityMap.get(fieldName);
            if (!(fieldName.endsWith("v.id") ? !PayRollTaskHelper.isCurrEntityEffective(entityName, dataEntity.getLong(fieldName)) : ("callistrule.id".equals(fieldName) ? (fieldNameId = this.getFieldNameIdFromSceneV(dataEntity, fieldName)) != 0L && !PayRollTaskHelper.isCurrEntityAuditedAndEnable(entityName, fieldNameId) : !PayRollTaskHelper.isCurrEntityAuditedAndEnable(entityName, dataEntity.getLong(fieldName))))) continue;
            return i;
        }
        return -1;
    }

    private long getFieldNameIdFromSceneV(DynamicObject dataEntity, String fieldNameId) {
        DynamicObject payRollSceneVInfo = dataEntity.getDynamicObject("payrollscenev");
        if (SWCObjectUtils.isEmpty((Object)payRollSceneVInfo)) {
            return 0L;
        }
        return payRollSceneVInfo.getLong(fieldNameId);
    }

    public int checkCalListViewValid(DynamicObject dataEntity, int size) {
        boolean isCalListViewValid;
        long payRollSceneId;
        int errIndex = -1;
        long payRollGrpVId = dataEntity.getLong("payrollgroupv.id");
        long calListViewId = PayRollTaskHelper.queryCalListViewInPayRollGrpScV(payRollGrpVId, payRollSceneId = dataEntity.getLong("payrollscene.id"));
        boolean isCalListViewInGrp = calListViewId != 0L;
        boolean bl = isCalListViewValid = calListViewId != 0L || (calListViewId = dataEntity.getDynamicObject("payrollscenev").getLong("callistview.id")) != 0L;
        if (!(isCalListViewValid && PayRollTaskHelper.isCurrEntityAuditedAndEnable("hsas_callistview", calListViewId) && PayRollTaskHelper.isCurrEntityEffective("hsas_callistview", dataEntity.getLong("callistviewv.id")))) {
            errIndex = isCalListViewInGrp ? size : size + 1;
        }
        return errIndex;
    }

    public Map<String, String> getFieldAndEntityMap() {
        HashMap<String, String> fieldAndEntityMap = new HashMap<String, String>(16);
        fieldAndEntityMap.put("payrollgroup.id", "hsas_payrollgrp");
        fieldAndEntityMap.put("payrollgroupv.id", "hsas_payrollgrp");
        fieldAndEntityMap.put("payrollscene.id", "hsas_payrollscene");
        fieldAndEntityMap.put("payrollscenev.id", "hsas_payrollscene");
        fieldAndEntityMap.put("calrule.id", "hsas_calrule");
        fieldAndEntityMap.put("periodtype.id", "hsbs_calperiodtype");
        fieldAndEntityMap.put("callistrule.id", "hsas_callistrule");
        fieldAndEntityMap.put("callistview.id", "hsas_callistview");
        fieldAndEntityMap.put("salaryslipview.id", "hsbs_salaryslipview");
        return fieldAndEntityMap;
    }

    public Map<String, String> getFieldErrMsgWhenCopyMap() {
        HashMap<String, String> fieldErrMsgWhenCopyMap = new HashMap<String, String>(16);
        fieldErrMsgWhenCopyMap.put("payrollgroup.id", ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_12", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("payrollgroupv.id", ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u7248\u672c\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_13", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("payrollscene.id", ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_14", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("payrollscenev.id", ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u7248\u672c\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_15", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("calrule.id", ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u8ba1\u7b97\u89c4\u5219\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_16", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("periodtype.id", ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u671f\u95f4\u7c7b\u578b\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_17", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("callistrule.id", ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u4e0a\u7684\u201c\u6838\u7b97\u540d\u5355\u89c4\u5219\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_18", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put(CalPayrollTaskConstants.CAL_LIST_VIEW_IN_GROUP.toString(), ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_19", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put(CalPayrollTaskConstants.CAL_LIST_VIEW_IN_SCENE.toString(), ResManager.loadKDString((String)"\u88ab\u590d\u5236\u7684\u6838\u7b97\u4efb\u52a1\u7684\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u4e0a\u7684\u201c\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_20", (String)"swc-hsas-business", (Object[])new Object[0]));
        return fieldErrMsgWhenCopyMap;
    }

    public static Map<String, String> getFieldErrMsgWhenSaveMap(boolean isQuicklyCreate) {
        HashMap<String, String> fieldErrMsgWhenCopyMap = new HashMap<String, String>(16);
        fieldErrMsgWhenCopyMap.put("payrollgroup.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0d\u53ef\u7528\u3002", (String)"PayRollTaskService_21", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("payrollscenev.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u7248\u672c\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_22", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("payrollscene.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0d\u53ef\u7528\u3002", (String)"PayRollTaskService_23", (String)"swc-hsas-business", (Object[])new Object[0]));
        if (isQuicklyCreate) {
            fieldErrMsgWhenCopyMap.put("periodtype.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u53ef\u7528\u3002", (String)"PayRollTaskService_24", (String)"swc-hsas-business", (Object[])new Object[0]));
            fieldErrMsgWhenCopyMap.put("calrule.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u8ba1\u7b97\u89c4\u5219\u4e0d\u53ef\u7528\u3002", (String)"PayRollTaskService_25", (String)"swc-hsas-business", (Object[])new Object[0]));
            fieldErrMsgWhenCopyMap.put("calrulev.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u8ba1\u7b97\u89c4\u5219\u5728\u85aa\u8d44\u622a\u6b62\u65e5\u671f\u524d\u4e0d\u5b58\u5728\u5df2\u751f\u6548\u7684\u6570\u636e\u7248\u672c\uff0c\u5efa\u8bae\u91cd\u65b0\u914d\u7f6e\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4fe1\u606f\u6216\u66f4\u6539\u671f\u95f4\u3002", (String)"PayRollTaskService_26", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else {
            fieldErrMsgWhenCopyMap.put("payrollgroupv.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollTaskService_27", (String)"swc-hsas-business", (Object[])new Object[0]));
            fieldErrMsgWhenCopyMap.put("periodtype.id", ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\u4e0d\u53ef\u7528\u3002", (String)"PayRollTaskService_28", (String)"swc-hsas-business", (Object[])new Object[0]));
            fieldErrMsgWhenCopyMap.put("calrule.id", ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u4e0d\u53ef\u7528\u3002", (String)"PayRollTaskService_29", (String)"swc-hsas-business", (Object[])new Object[0]));
            fieldErrMsgWhenCopyMap.put("calrulev.id", ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5728\u85aa\u8d44\u7ed3\u675f\u65e5\u671f\u524d\u4e0d\u5b58\u5728\u5df2\u751f\u6548\u7684\u6570\u636e\u7248\u672c\uff0c\u8bf7\u65b0\u589e\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4fe1\u606f\u6216\u66f4\u6539\u671f\u95f4\u3002", (String)"PayRollTaskService_30", (String)"swc-hsas-business", (Object[])new Object[0]));
            fieldErrMsgWhenCopyMap.put("partmodify", ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5728\u85aa\u8d44\u7ed3\u675f\u65e5\u671f\u524d\u4e0d\u5b58\u5728\u5df2\u751f\u6548\u7684\u6570\u636e\u7248\u672c\uff0c\u8bf7\u65b0\u589e\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4fe1\u606f\u6216\u66f4\u6539\u671f\u95f4\u3002", (String)"PayRollTaskService_36", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        fieldErrMsgWhenCopyMap.put("period.id", ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u671f\u95f4\u3002", (String)"PayRollTaskService_31", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("callistrule.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_32", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("callistrulev.id", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u6838\u7b97\u540d\u5355\u89c4\u5219\u65e0\u53ef\u7528\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_33", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put(CalPayrollTaskConstants.CAL_LIST_VIEW_IN_GROUP.toString(), ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u85aa\u8d44\u6838\u7b97\u573a\u666f\u5206\u5f55\u4e2d\uff0c\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u4e0d\u53ef\u7528\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_34", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put(CalPayrollTaskConstants.CAL_LIST_VIEW_IN_SCENE.toString(), ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0a\u7684\u6838\u7b97\u540d\u5355\u663e\u793a\u65b9\u6848\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u573a\u666f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"PayRollTaskService_35", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("SaveErrorForTaskAdd", ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u8be5\u85aa\u8d44\u6838\u7b97\u7ec4\u3001\u85aa\u8d44\u6838\u7b97\u573a\u666f\u3001\u671f\u95f4\u7684\u5e38\u89c4\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u3002", (String)"PayRollTaskService_37", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("comfirm_before_save_common_task", ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u85aa\u8d44\u6838\u7b97\u7ec4\u3001\u85aa\u8d44\u6838\u7b97\u573a\u666f\u3001\u671f\u95f4\u7684\u5e38\u89c4\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u3002\u8be5\u4efb\u52a1\u4e2d\u7684\u6838\u7b97\u4eba\u5458\u4e0d\u53ef\u6dfb\u52a0\u5230\u65b0\u6838\u7b97\u4efb\u52a1\u4e2d\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"PayRollTaskService_38", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("comfirm_before_save_common_task_tpl", ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u85aa\u8d44\u6838\u7b97\u7ec4\u3001\u85aa\u8d44\u6838\u7b97\u573a\u666f\u7684\u6838\u7b97\u4efb\u52a1\u6a21\u677f\uff0c\u82e5\u7ee7\u7eed\u65b0\u5efa\u5219\u53ef\u80fd\u91cd\u590d\u521b\u5efa\u6838\u7b97\u4efb\u52a1\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"PayRollTaskService_39", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("task_names_before_save_common_task", ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7684\u5e38\u89c4\u6838\u7b97\u4efb\u52a1\u5982\u4e0b\uff1a", (String)"PayRollTaskService_40", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("task_tpl_names_before_save_common_task_tpl", ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7684\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u5982\u4e0b\uff1a", (String)"PayRollTaskService_41", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("matchLastPeriodFail", ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u671f\u95f4\u65e0\u53ef\u7528\u7684\u201c\u4e0a\u4e2a\u671f\u95f4\u201d\uff0c\u8003\u52e4\u8d77\u6b62\u65e5\u671f\u751f\u6210\u5931\u8d25\u3002", (String)"PayRollTaskService_43", (String)"swc-hsas-business", (Object[])new Object[0]));
        fieldErrMsgWhenCopyMap.put("matchBeforeLastPeriodFail", ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u671f\u95f4\u65e0\u53ef\u7528\u7684\u201c\u4e0a\u4e0a\u4e2a\u671f\u95f4\u201d\uff0c\u8003\u52e4\u8d77\u6b62\u65e5\u671f\u751f\u6210\u5931\u8d25\u3002", (String)"PayRollTaskService_44", (String)"swc-hsas-business", (Object[])new Object[0]));
        return fieldErrMsgWhenCopyMap;
    }

    public String getCalPayRollTaskDefaultName(DynamicObject dataEntity) {
        StringJoiner defaultPayRollTaskNameSJ = new StringJoiner("-");
        for (String field : PAYROLL_TASK_NAME_PART_ARR) {
            DynamicObject dynamicObject = dataEntity.getDynamicObject(field);
            if (SWCObjectUtils.isEmpty((Object)dynamicObject)) continue;
            defaultPayRollTaskNameSJ.add(dynamicObject.getString("name"));
        }
        String defaultPayRollTaskName = defaultPayRollTaskNameSJ.toString();
        if (SWCStringUtils.isEmpty((String)defaultPayRollTaskName)) {
            defaultPayRollTaskName = "";
        } else if (defaultPayRollTaskName.length() > 50) {
            defaultPayRollTaskName = defaultPayRollTaskName.substring(0, 50);
        }
        return defaultPayRollTaskName;
    }

    public String getPayRollGrpSceneAndPeriodKey(DynamicObject calTaskDyObj) {
        long periodId;
        long payrollSceneId;
        long payrollGrpId;
        String key = null;
        if (!SWCObjectUtils.isEmpty((Object)calTaskDyObj) && (payrollGrpId = calTaskDyObj.getLong("payrollgroup.id")) != 0L && (payrollSceneId = calTaskDyObj.getLong("payrollscene.id")) != 0L && (periodId = calTaskDyObj.getLong("period.id")) != 0L) {
            key = payrollGrpId + "," + payrollSceneId + "," + periodId;
        }
        return key;
    }

    public static void setOrgAuthorFilter(List<QFilter> qFilters) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            logger.info("PayRollTaskService.setOrgAuthorFilter: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            QFilter permFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            qFilters.add(permFilter);
        }
    }

    public boolean checkResultCoverChanged(long calTaskId, long calRuleVid) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter taskFilter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject taskObj = helper.queryOne("calrulev.id", new QFilter[]{taskFilter});
        if (taskObj == null) {
            return false;
        }
        long oldCalRuleVid = taskObj.getLong("calrulev.id");
        helper = new SWCDataServiceHelper("hsas_calrule");
        QFilter filterv = new QFilter("id", "=", (Object)oldCalRuleVid);
        QFilter filter = new QFilter("id", "=", (Object)calRuleVid);
        DynamicObject[] ruleVObjs = helper.query("id,calruleitementry,calruleitementry.salaryitem,calruleitementry.allowresultcover", new QFilter[]{filterv}, "modifytime desc");
        DynamicObject[] ruleObjs = helper.query("id,calruleitementry,calruleitementry.salaryitem,calruleitementry.allowresultcover", new QFilter[]{filter});
        if (ruleVObjs.length == 0 || ruleObjs.length == 0) {
            return false;
        }
        DynamicObjectCollection calRuleVItemEntry = ruleVObjs[0].getDynamicObjectCollection("calruleitementry");
        DynamicObjectCollection calRuleItemEntry = ruleObjs[0].getDynamicObjectCollection("calruleitementry");
        if (calRuleVItemEntry.size() == 0 || calRuleItemEntry.size() == 0) {
            return false;
        }
        Map<Long, String> allowResultCoverVMap = calRuleVItemEntry.stream().collect(Collectors.toMap(key -> key.getLong("salaryitem.id"), value -> value.getString("allowresultcover")));
        Map<Long, String> allowResultCoverMap = calRuleItemEntry.stream().collect(Collectors.toMap(key -> key.getLong("salaryitem.id"), value -> value.getString("allowresultcover")));
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, String> entry : allowResultCoverVMap.entrySet()) {
            String curValue = allowResultCoverMap.get(entry.getKey());
            if (SWCStringUtils.isEmpty((String)curValue) || !SWCStringUtils.equals((String)"1", (String)entry.getValue()) || !SWCStringUtils.equals((String)"0", (String)curValue)) continue;
            itemIdList.add(entry.getKey());
        }
        if (itemIdList.size() > 0) {
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cal_task_check_value_cache_key_%s", calTaskId));
            String cacheKey = String.format(Locale.ROOT, "cal_task_check_cache_key_%s", calTaskId);
            appCache.put(cacheKey, itemIdList);
            return true;
        }
        return false;
    }

    public void deleteItemCoverData(long calTaskId, List<Long> itemIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        DynamicObject[] persons = helper.queryOriginalArray("id", new QFilter[]{filter});
        if (persons.length == 0) {
            return;
        }
        List perosnIdList = Arrays.stream(persons).map(single -> single.getLong("id")).collect(Collectors.toList());
        helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        filter = new QFilter("calperson", "in", perosnIdList);
        filter.and("salaryitem.id", "in", itemIdList);
        helper.deleteByFilter(new QFilter[]{filter});
        helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public static boolean checkDataPermission(Object pkId, String opKey) {
        QFilter filter = new QFilter("id", "=", pkId);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)opKey);
        if (authorizedDataRuleQFilter == null) {
            filter.and(new QFilter("1", "!=", (Object)1));
        } else {
            authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        return new SWCDataServiceHelper("hsas_calpayrolltask").isExists(filter.toArray());
    }
}

