/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payrolltask.service;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public enum TaskConfirmEnum {
    TASK("hsas_calpayrolltask"){

        @Override
        protected QFilter getEntityQFilter(DynamicObject dataEntity) {
            long payPeriodId;
            long payRollSceneId;
            long payRollGroupId;
            QFilter filter = null;
            String name = dataEntity.getString("name");
            if (SWCStringUtils.isNotEmpty((String)name) && (payRollGroupId = dataEntity.getLong("payrollgroup.id")) != 0L && (payRollSceneId = dataEntity.getLong("payrollscene.id")) != 0L && (payPeriodId = dataEntity.getLong("period.id")) != 0L) {
                filter = PayRollTaskService.getGrpSceneAndPeriodFilter(payRollGroupId, payRollSceneId, payPeriodId, "0");
            }
            return filter;
        }
    }
    ,
    TPL("hsas_caltasknewtpl"){

        @Override
        protected QFilter getEntityQFilter(DynamicObject dataEntity) {
            long payRollSceneId;
            long payRollGrpId;
            QFilter filter = null;
            String name = dataEntity.getString("name");
            if (SWCStringUtils.isNotEmpty((String)name) && (payRollGrpId = dataEntity.getLong(TaskConfirmEnum.TPL_PAYROLL_GRP_ID)) != 0L && (payRollSceneId = dataEntity.getLong("payrollscene.id")) != 0L) {
                filter = new QFilter(TaskConfirmEnum.TPL_PAYROLL_GRP_ID, "=", (Object)payRollGrpId);
                filter.and("payrollscene.id", "=", (Object)payRollSceneId);
                filter.and("status", "=", (Object)"C");
                filter.and("enable", "=", (Object)"1");
                BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
            }
            return filter;
        }
    };

    private static final String TPL_PAYROLL_GRP_ID = "payrollgrp.id";
    private String entityName;

    private TaskConfirmEnum(String entityName) {
        this.entityName = entityName;
    }

    public static TaskConfirmEnum getInstance(String billForm, Boolean isCommonTaskType) {
        TaskConfirmEnum taskConfirmEnum = null;
        switch (billForm) {
            case "hsas_calpayrolltask": 
            case "hsas_createcalpayrolltask": {
                if (!Boolean.TRUE.equals(isCommonTaskType)) break;
                taskConfirmEnum = TASK;
                break;
            }
            case "hsas_caltasknewtpl": {
                taskConfirmEnum = TPL;
                break;
            }
        }
        return taskConfirmEnum;
    }

    public boolean confirmBeforeSave(Object plugIn) {
        AbstractFormPlugin currPlugin = (AbstractFormPlugin)plugIn;
        IFormView currView = currPlugin.getView();
        IPageCache pageCache = currPlugin.getPageCache();
        String cacheKey = currView.getPageId() + "tasktype";
        String cacheValue = pageCache.get(cacheKey);
        if (!Boolean.TRUE.toString().equals(cacheValue)) {
            DynamicObject dataEntity = currView.getModel().getDataEntity();
            Map<Long, String> taskInfoMap = this.getEntityInfo(dataEntity);
            if (taskInfoMap.size() > 0) {
                String confirmDetail;
                String confirmMsg;
                Map<String, String> fieldErrMsgWhenSaveMap;
                String errMarkMsg = null;
                String errMarkDetail = null;
                switch (this) {
                    case TASK: {
                        errMarkMsg = "comfirm_before_save_common_task";
                        errMarkDetail = "task_names_before_save_common_task";
                        break;
                    }
                    case TPL: {
                        errMarkMsg = "comfirm_before_save_common_task_tpl";
                        errMarkDetail = "task_tpl_names_before_save_common_task_tpl";
                        break;
                    }
                }
                if (errMarkMsg != null && (fieldErrMsgWhenSaveMap = PayRollTaskService.getFieldErrMsgWhenSaveMap(false)) != null && (confirmMsg = fieldErrMsgWhenSaveMap.get(errMarkMsg)) != null && (confirmDetail = fieldErrMsgWhenSaveMap.get(errMarkDetail)) != null) {
                    StringBuilder confirmDetailSB = new StringBuilder(confirmDetail);
                    taskInfoMap.values().forEach(name -> confirmDetailSB.append('\n').append("  ").append((String)name));
                    currView.showConfirm(confirmMsg, confirmDetailSB.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("callback_id_before_save_common"));
                }
                return true;
            }
        } else {
            pageCache.remove(cacheKey);
        }
        return false;
    }

    public static void confirmCallBack(Object plugIn, String callBackId) {
        if ("callback_id_before_save_common".equals(callBackId)) {
            AbstractFormPlugin currPlugin = (AbstractFormPlugin)plugIn;
            IFormView currView = currPlugin.getView();
            String cacheKey = currView.getPageId() + "tasktype";
            currPlugin.getPageCache().put(cacheKey, Boolean.TRUE.toString());
            if ("hsas_createcalpayrolltask".equals(currView.getEntityId())) {
                currView.invokeOperation("donothing_ok");
            } else {
                currView.invokeOperation("save");
            }
        }
    }

    private Map<Long, String> getEntityInfo(DynamicObject dataEntity) {
        QFilter filter = this.getEntityQFilter(dataEntity);
        return this.queryEntityInfoByFollows(filter);
    }

    protected abstract QFilter getEntityQFilter(DynamicObject var1);

    private Map<Long, String> queryEntityInfoByFollows(QFilter filter) {
        if (filter == null) {
            return new HashMap<Long, String>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(this.entityName);
        DynamicObjectCollection taskInfoDys = helper.queryOriginalCollection("id, name", filter.toArray());
        return taskInfoDys.stream().collect(Collectors.toMap(taskInfoDy -> taskInfoDy.getLong("id"), taskInfoDy -> taskInfoDy.getString("name")));
    }
}

