/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class PaySalarySettingExportHelper {
    private static Log logger = LogFactory.getLog(PaySalarySettingExportHelper.class);
    private static final String TEXT = "text";
    private static final String NUM = "num";
    private static final String AMOUNT = "amount";
    private static final String DATE = "date";
    private static final String ERROR_MESSAGE = "errorMessage";

    public static void write2ExportHead(SXSSFSheet sheet, Map<String, String> headData) {
        List<Map<String, String>> headList = PaySalarySettingExportHelper.headMapToListMap(headData);
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 4);
        }
        PaySalarySettingExportHelper.createHeadColumn(sheet.getWorkbook(), sheet, headList);
    }

    public static void write2ExportContent(SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, Map<String, String> headData) {
        List<Map<String, String>> headList = PaySalarySettingExportHelper.headMapToListMap(headData);
        PaySalarySettingExportHelper.createContentColumn(sheet.getWorkbook(), sheet, beginIndex, exportDataList, headList);
    }

    public static List<Map<String, String>> headMapToListMap(Map<String, String> headData) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, String> entry : headData.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("id".equals(key)) continue;
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("key", key);
            temp.put("value", value);
            list.add(temp);
        }
        return list;
    }

    private static String getCellStyleKey(String dataType, String key, ErrorLevel level) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(dataType);
        keyBuilder.append('#');
        keyBuilder.append(key);
        keyBuilder.append('#');
        keyBuilder.append(level != null ? level : "");
        return keyBuilder.toString();
    }

    private static void parseCellValue(SXSSFCell cell, Object value, String dataType) throws ParseException {
        if (SWCStringUtils.equals((String)dataType, (String)TEXT)) {
            cell.setCellValue(value.toString());
        } else if (SWCStringUtils.equals((String)dataType, (String)DATE)) {
            String fmt = "yyyy-MM-dd";
            if (value instanceof Date) {
                String dateStr = SWCDateTimeUtils.format((Date)((Date)value), (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof Number) {
                long dataLong = Long.parseLong(value.toString());
                Date dateValue = new Date(dataLong);
                String dateStr = SWCDateTimeUtils.format((Date)dateValue, (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof String) {
                String valueStr = (String)value;
                cell.setCellValue(valueStr);
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (SWCStringUtils.equals((String)dataType, (String)NUM) || SWCStringUtils.equals((String)dataType, (String)AMOUNT)) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)NUM)) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)DATE)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)AMOUNT)) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    private static void getDateCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "yyyy-MM-dd";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static void getStringCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void getAmountCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, String sign, int scale) {
        if (SWCStringUtils.isEmpty((String)sign)) {
            sign = "";
        }
        DataFormat format = wb.createDataFormat();
        String styleStr = sign + "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void createHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, String>> headList) {
        int row = 0;
        SXSSFRow headRow = sheet.createRow(row);
        int headSize = headList.size();
        for (int i = 0; i < headSize; ++i) {
            if (null == headList.get(i)) continue;
            SXSSFCell cell = headRow.createCell(i);
            String headString = headList.get(i).get("value");
            cell.setCellValue(headString);
            CellStyle headColumnStyle = PaySalarySettingExportHelper.getHeadColumnStyle(wb);
            String headKey = headList.get(i).get("key");
            cell.setCellStyle(headColumnStyle);
        }
    }

    private static CellStyle getDefaultCellStyle(String dataType, SXSSFWorkbook wb, String key, Map<String, Object> exportDataMap) {
        int scale = 0;
        CellStyle cellStyle = wb.createCellStyle();
        if (SWCStringUtils.equals((String)dataType, (String)NUM)) {
            PaySalarySettingExportHelper.getNumberCellStyle(wb, cellStyle, scale);
        } else if (SWCStringUtils.equals((String)dataType, (String)DATE)) {
            PaySalarySettingExportHelper.getDateCellStyle(wb, cellStyle);
        } else if (SWCStringUtils.equals((String)dataType, (String)AMOUNT)) {
            PaySalarySettingExportHelper.getAmountCellStyle(wb, cellStyle, dataType, scale);
        } else {
            PaySalarySettingExportHelper.getStringCellStyle(wb, cellStyle);
        }
        if (ERROR_MESSAGE.equals(key)) {
            Font font = wb.createFont();
            Object errorLevel = exportDataMap.get("errorLevel");
            if (ErrorLevel.Warning == errorLevel) {
                font.setColor(HSSFColor.HSSFColorPredefined.ORANGE.getIndex());
            } else {
                font.setColor((short)10);
            }
            cellStyle.setFont(font);
        }
        return cellStyle;
    }

    private static CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    public static void createContentColumn(SXSSFWorkbook wb, SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, List<Map<String, String>> headList) {
        if (exportDataList.isEmpty()) {
            return;
        }
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
        for (int rowIndex = beginIndex.intValue(); rowIndex < exportDataList.size() + beginIndex; ++rowIndex) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            Map<String, Object> exportDataMap = exportDataList.get(rowIndex - beginIndex);
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                ErrorLevel errorLevel;
                String cellStyleKey;
                CellStyle defaultStyle;
                Object value;
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = headList.get(columnIndex).get("key");
                if (null == key || null == (value = exportDataMap.get(key))) continue;
                if ("rowSeq".equals(key)) {
                    value = rowIndex;
                }
                String dataType = TEXT;
                if ("bsed".equals(key)) {
                    dataType = DATE;
                }
                if ((defaultStyle = (CellStyle)cellStyleMap.get(cellStyleKey = PaySalarySettingExportHelper.getCellStyleKey(dataType, key, errorLevel = (ErrorLevel)exportDataMap.get("errorLevel")))) == null) {
                    defaultStyle = PaySalarySettingExportHelper.getDefaultCellStyle(dataType, wb, key, exportDataMap);
                    cellStyleMap.put(cellStyleKey, defaultStyle);
                }
                columnCell.setCellStyle(defaultStyle);
                try {
                    PaySalarySettingExportHelper.parseCellValue(columnCell, value, dataType);
                }
                catch (Exception e) {
                    columnCell.setCellValue(value.toString());
                    logger.error("parseCellValue error:", (Throwable)e);
                }
                columnCell.setCellType(PaySalarySettingExportHelper.getCellType(dataType));
            }
        }
    }
}

