/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting.paysetting;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.PaySettingUpdateProgressInfo;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdateErrorResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingErrorEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdateSdkResultDTO;
import kd.swc.hsas.business.paysalarysetting.paysetting.thread.PaySettingBatchThread;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class UpdatePaySettingService {
    private static final Log logger = LogFactory.getLog(UpdatePaySettingService.class);
    private static final String PERSONIDLIST = "personIdList";
    private static final String ISVERIFYPERM = "isVerifyPerm";
    private static final String ISHANDUPDATEBANKCARD = "isHandUpdateBankCard";

    public void updatePaySetting(List<Long> salaryFileIds, String recordId, Boolean isHandUpdateBankCard) {
        RequestContext requestContext = RequestContext.get();
        ThreadPools.executeOnce((String)"EXPORT_EXCEL_POOL_UPDATE_PAY_SETTING_ASYNC", (Runnable)new PaySettingBatchThread(requestContext, recordId, salaryFileIds, isHandUpdateBankCard));
    }

    public UpdatePaySettingResult synUpdatePaySetting(List<Long> salaryFileIds, Boolean isHandUpdateBankCard) {
        RequestContext requestContext = RequestContext.get();
        PaySettingBatchThread thread = new PaySettingBatchThread(requestContext, salaryFileIds, isHandUpdateBankCard);
        return thread.synRun();
    }

    public UpdatePaySettingResult synUpdatePaySetting(List<Long> personIdList, Boolean isVerifyPerm, Boolean isHandUpdateBankCard) {
        DynamicObjectCollection salaryFileCol = this.getSalaryFileColByPersonId(personIdList, isVerifyPerm);
        return this.synUpdatePaySetting(salaryFileCol.stream().map(data -> data.getLong("id")).collect(Collectors.toList()), isHandUpdateBankCard);
    }

    public ApiResult synUpdatePersonPaySetting(Map<String, Object> param) {
        List personIdList = param.getOrDefault(PERSONIDLIST, new ArrayList());
        Boolean isVerifyPerm = (Boolean)param.getOrDefault(ISVERIFYPERM, Boolean.FALSE);
        Boolean isHandUpdateBankCard = (Boolean)param.getOrDefault(ISHANDUPDATEBANKCARD, Boolean.FALSE);
        if (personIdList == null || personIdList.isEmpty()) {
            return ApiResult.fail((String)"personIdList is empty");
        }
        Map<Long, Long> salaryFilePersonIdMap = this.getSalaryFilePersonIdMap(personIdList, isVerifyPerm);
        HashMap salaryFileUpdateMap = new HashMap(salaryFilePersonIdMap.size());
        HashSet personIdSet = new HashSet(personIdList);
        ArrayList resultList = new ArrayList(salaryFilePersonIdMap.size());
        salaryFilePersonIdMap.forEach((salaryFileId, personId) -> {
            UpdateSdkResultDTO resultDTO = UpdateSdkResultDTO.getInstance(personId, salaryFileId);
            salaryFileUpdateMap.put(salaryFileId, resultDTO);
            personIdSet.remove(personId);
        });
        UpdatePaySettingResult updatePaySettingResult = this.synUpdatePaySetting(new ArrayList<Long>(salaryFilePersonIdMap.keySet()), isHandUpdateBankCard);
        List<Long> successSalaryFileIdList = updatePaySettingResult.getSuccessSalaryFileIdList();
        List<UpdateErrorResult> errorList = updatePaySettingResult.getErrorList();
        successSalaryFileIdList.forEach(salaryFileId -> {
            UpdateSdkResultDTO resultDTO = (UpdateSdkResultDTO)salaryFileUpdateMap.get(salaryFileId);
            if (resultDTO != null) {
                resultDTO.setUpdateSuccess(Boolean.TRUE);
            }
        });
        errorList.forEach(error -> {
            Long salaryFileId = error.getSalaryFileId();
            UpdateSdkResultDTO resultDTO = (UpdateSdkResultDTO)salaryFileUpdateMap.get(salaryFileId);
            if (resultDTO != null) {
                UpdatePaySettingErrorEnum errorEnum = error.getErrorEnum();
                resultDTO.setErrorCode(errorEnum.getErrorEnum());
                resultDTO.setErrorMsg(error.getErrorReason());
            }
        });
        resultList.addAll(salaryFileUpdateMap.values());
        personIdSet.forEach(personId -> {
            UpdateSdkResultDTO result = UpdateSdkResultDTO.getInstance(personId, null);
            result.setErrorCode(UpdatePaySettingErrorEnum.NOT_SALARY_FILE.getErrorEnum());
            result.setErrorMsg(UpdatePaySettingErrorEnum.NOT_SALARY_FILE.getDesc());
            resultList.add(result);
        });
        JSONObject data = new JSONObject();
        data.put("resultList", resultList);
        return ApiResult.success((Object)data);
    }

    private DynamicObjectCollection getSalaryFileColByPersonId(List<Long> personIdList, Boolean isVerifyPerm) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter filter = new QFilter("person.id", "in", personIdList);
        filterList.add(filter);
        filterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        if (isVerifyPerm.booleanValue()) {
            List dataRuleFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"2=R55S=NFOZB");
            if (dataRuleFilter == null) {
                return new DynamicObjectCollection();
            }
            filterList.addAll(dataRuleFilter);
        }
        return helper.queryOriginalCollection("id,person.id", filterList.toArray(new QFilter[0]));
    }

    public Map<Long, Long> getSalaryFilePersonIdMap(List<Long> personIdList, Boolean isVerifyPerm) {
        DynamicObjectCollection salaryFileCol = this.getSalaryFileColByPersonId(personIdList, isVerifyPerm);
        return salaryFileCol.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getLong("person.id"), (o1, o2) -> o1));
    }

    public void openProgressAndUpdatePaySetting(IFormView view, CloseCallBack closeCallBack, List<Long> personIdList, Boolean isManuallyModify) {
        UpdatePaySettingService service = new UpdatePaySettingService();
        DynamicObjectCollection salaryFileCol = service.getSalaryFileColByPersonId(personIdList, Boolean.TRUE);
        if (salaryFileCol.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u5185\u8ba1\u85aa\u4eba\u5458\u65e0\u5173\u8054\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u9700\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u3002", (String)"UpdatePaySettingService_1", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        service.openUpdatePaySettingProgress(salaryFileCol.size(), view, closeCallBack);
        service.updatePaySetting(salaryFileCol.stream().map(data -> data.getLong("id")).collect(Collectors.toList()), view.getPageId(), isManuallyModify);
    }

    public void openUpdatePaySettingProgress(int totalNum, IFormView view, CloseCallBack closeCallBack) {
        String pageId = view.getPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        this.setPaySettingUpdateProgressInfo(totalNum, pageId, appCache);
        this.createProgress(pageId, appCache, totalNum);
        this.openPaySettingProgressForm(totalNum, pageId, view, closeCallBack);
    }

    public void openPaySettingList(IFormView view, Map<String, Object> progressReturnData) {
        if (SWCObjectUtils.isEmpty(progressReturnData)) {
            return;
        }
        List successIdList = (List)progressReturnData.get("successIdList");
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_paysetting");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("viewupdateresult", (Object)Boolean.TRUE);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        QFilter qFilter = new QFilter("id", "in", (Object)successIdList);
        listFilterParameter.setFilter(qFilter);
        showParameter.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)showParameter);
    }

    private void setPaySettingUpdateProgressInfo(int totalNum, String pageId, ISWCAppCache appCache) {
        PaySettingUpdateProgressInfo progress = new PaySettingUpdateProgressInfo();
        progress.setTotal(totalNum);
        progress.setStatus(0);
        progress.setFail(0);
        progress.setFinish(0);
        progress.setSuccess(0);
        String key = String.format(Locale.ROOT, "paySettingUpdateProgress_%s", pageId);
        SWCAppCache.get((String)"hsas").put(key, (Object)progress);
        appCache.put("updatepaysettinglock", (Object)"1");
    }

    private void createProgress(String pageId, ISWCAppCache appCache, int totalNum) {
        String name = ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e", (String)"UpdatePaySettingService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("recordId", pageId);
        customMap.put("totalnum", totalNum);
        String floatingTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_paysetting", name, true, pageId, customMap);
        appCache.put(String.format(Locale.ROOT, "paySettingUpdateJob_%s", pageId), (Object)floatingTaskId);
    }

    private void openPaySettingProgressForm(int totalNum, String pageId, IFormView view, CloseCallBack closeCallBack) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_paysettingupdateprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("recordId", pageId);
        customMap.put("totalnum", totalNum);
        para.setCustomParam("customMap", customMap);
        para.setCloseCallBack(closeCallBack);
        view.showForm(para);
    }
}

