/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting.paysetting.thread;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdateErrorResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingDTO;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingErrorEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.updateobject.UpdateStrategyService;
import kd.swc.hsas.common.dto.PersonRangeDTO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class UpdatePaySettingThread
implements Callable<UpdatePaySettingResult> {
    private static final Log logger = LogFactory.getLog(UpdatePaySettingThread.class);
    private static final String OP_FORMSAVE = "save";
    private static final String OP_SAVEAFTERAUDIT = "saveafteraudit";
    private RequestContext requestContext;
    private String recordId;
    private CountDownLatch latch;
    private List<Long> salaryFileIdList;
    private List<UpdatePaySettingDTO> updatePaySettingAuditList;
    private List<UpdatePaySettingDTO> updatePaySettingSaveList;
    private List<UpdatePaySettingDTO> updatePaySettingAuditSaveList;
    private Boolean isHandUpdateBankCard;
    private Integer successNum;
    private List<UpdateErrorResult> updateErrorResultList;

    UpdatePaySettingThread(RequestContext requestContext, String recordId, CountDownLatch latch, List<Long> salaryFileIdList, Boolean isHandUpdateBankCard) {
        this.requestContext = requestContext;
        this.recordId = recordId;
        this.latch = latch;
        this.salaryFileIdList = salaryFileIdList;
        this.updatePaySettingAuditList = new ArrayList<UpdatePaySettingDTO>(10);
        this.updatePaySettingSaveList = new ArrayList<UpdatePaySettingDTO>(10);
        this.updatePaySettingAuditSaveList = new ArrayList<UpdatePaySettingDTO>(10);
        this.isHandUpdateBankCard = isHandUpdateBankCard;
        this.successNum = 0;
        this.updateErrorResultList = new ArrayList<UpdateErrorResult>(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePaySettingResult call() throws Exception {
        UpdatePaySettingResult result = UpdatePaySettingResult.getInstance();
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        Boolean isCancel = (Boolean)appCache.get("isCancelUpdatePaySetting", Boolean.class);
        this.successNum = 0;
        try {
            if (isCancel == null || !isCancel.booleanValue()) {
                RequestContext.copyAndSet((RequestContext)this.requestContext);
                this.initData();
                UpdateStrategyService service = new UpdateStrategyService();
                this.updatePaySettingAuditList.removeIf(service::updatePaySetting);
                this.updatePaySettingSaveList.removeIf(service::updatePaySetting);
                this.updatePaySettingAuditSaveList.removeIf(service::updatePaySetting);
                this.updateErrorResultList.addAll(service.getUpdateErrorResultList());
                this.savePaySetting(result);
                result.setErrorList(this.updateErrorResultList);
            }
        }
        catch (Exception e) {
            logger.error("Update PaySetting error {}", (Object)e.getMessage());
            this.successNum = 0;
            this.setUpdateErrorResultList();
        }
        finally {
            if (isCancel != null && isCancel.booleanValue()) {
                result.setFinishNum(this.salaryFileIdList.size());
            } else {
                result.setSuccessNum(this.successNum);
                result.setFinishNum(this.salaryFileIdList.size());
                result.setFailNum(this.salaryFileIdList.size() - this.successNum);
            }
            if (SWCStringUtils.isNotEmpty((String)this.recordId)) {
                PaySalarySettingHelper.updatePaySettingProgressInfo(appCache, this.recordId, result);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
        return result;
    }

    private void initData() {
        UpdatePaySettingBuild paySettingBuild = new UpdatePaySettingBuild();
        this.queryRecentSalaryFile(paySettingBuild);
        this.queryRecentPaySettingRule(paySettingBuild);
        this.queryRecentPaySetting(paySettingBuild);
        this.queryRecentPaySalaryList(paySettingBuild);
        this.createUpdateEntity(paySettingBuild);
    }

    private void createUpdateEntity(UpdatePaySettingBuild paySettingBuild) {
        Map<Long, DynamicObject> salaryFileMapHandPaySetting = paySettingBuild.getSalaryFileMapHandPaySetting();
        Map<Long, DynamicObject> salaryFileMapPaySetting = paySettingBuild.getSalaryFileMapPaySetting();
        Map orgCountryToPayRuleMap = paySettingBuild.getOrgCountryToPayRuleMap();
        Map<Long, DynamicObject> salaryFileIdToSalaryFileMap = paySettingBuild.getSalaryFileIdToSalaryFileMap();
        Map<Long, List<DynamicObject>> perBankCardIdMap = paySettingBuild.getPerBankCardIdMap();
        Map<Long, Set<Long>> payRollGroupAndItemMap = paySettingBuild.getPayRollGroupAndItemMap();
        Map<Long, PersonRangeDTO> personFileInfo = paySettingBuild.getSalaryFileMapPersonRange();
        salaryFileIdToSalaryFileMap.forEach((salaryFileId, salaryFile) -> {
            String salaryFileStatus = salaryFile.getString("status");
            Long personId = salaryFile.getLong("person.id");
            DynamicObject calCurrency = salaryFile.getDynamicObject("payrollgroup.currency");
            String orgId = salaryFile.getString("org.id");
            String countryId = salaryFile.getString("payrollregion.id");
            Set salaryItemSet = (Set)payRollGroupAndItemMap.get(salaryFile.getLong("payrollgroup.id"));
            DynamicObject payRule = (DynamicObject)orgCountryToPayRuleMap.get(orgId + '-' + countryId);
            List perBankCardList = perBankCardIdMap.getOrDefault(personId, new ArrayList(10));
            PersonRangeDTO personRangeDTO = (PersonRangeDTO)personFileInfo.get(salaryFileId);
            UpdatePaySettingDTO dto = null;
            DynamicObject paySettingHand = (DynamicObject)salaryFileMapHandPaySetting.get(salaryFileId);
            if (paySettingHand != null) {
                dto = new UpdatePaySettingDTO(Boolean.FALSE, (DynamicObject)salaryFile, paySettingHand, UpdatePaySettingEnum.UPDATE_ONLY_BANK, payRule, perBankCardList, calCurrency);
                this.addListBySalaryFileStatus(salaryFileStatus, dto);
            } else {
                DynamicObject paySetting = (DynamicObject)salaryFileMapPaySetting.get(salaryFileId);
                if (paySetting != null) {
                    dto = new UpdatePaySettingDTO(Boolean.FALSE, (DynamicObject)salaryFile, paySetting, UpdatePaySettingEnum.UPDATE_COVER, payRule, perBankCardList, calCurrency);
                    this.addListBySalaryFileStatus(salaryFileStatus, dto);
                } else {
                    Long payRuleId = payRule == null ? 0L : payRule.getLong("id");
                    paySetting = this.createPaySettingEntity((Long)salaryFileId, payRuleId);
                    paySetting.set("status", (Object)salaryFileStatus);
                    dto = new UpdatePaySettingDTO(Boolean.TRUE, (DynamicObject)salaryFile, paySetting, UpdatePaySettingEnum.UPDATE_COVER, payRule, perBankCardList, calCurrency);
                    this.addListBySalaryFileStatusNotPaySetting(salaryFileStatus, dto);
                }
            }
            dto.setPersonRange(personRangeDTO);
            dto.setSalaryItem(salaryItemSet);
        });
    }

    private void addListBySalaryFileStatus(String salaryFileStatus, UpdatePaySettingDTO dto) {
        if ("A".equals(salaryFileStatus)) {
            this.updatePaySettingSaveList.add(dto);
        } else {
            this.updatePaySettingAuditList.add(dto);
        }
    }

    private void addListBySalaryFileStatusNotPaySetting(String salaryFileStatus, UpdatePaySettingDTO dto) {
        if ("A".equals(salaryFileStatus)) {
            this.updatePaySettingSaveList.add(dto);
        } else {
            this.updatePaySettingAuditSaveList.add(dto);
        }
    }

    private void savePaySetting(UpdatePaySettingResult result) {
        this.dealPaySettingData(result, this.updatePaySettingSaveList, OP_FORMSAVE, false);
        this.dealPaySettingData(result, this.updatePaySettingAuditList, OP_SAVEAFTERAUDIT, true);
        this.dealPaySettingData(result, this.updatePaySettingAuditSaveList, OP_FORMSAVE, true);
    }

    private void dealPaySettingData(UpdatePaySettingResult result, List<UpdatePaySettingDTO> updatePaySettingList, String opKey, boolean isAudit) {
        if (!updatePaySettingList.isEmpty()) {
            DynamicObjectCollection auditCol = new DynamicObjectCollection();
            updatePaySettingList.forEach(dto -> {
                auditCol.add((Object)dto.getPaySetting());
                result.addSuccessId(dto.getPaySetting().getLong("id"));
                result.addSuccessSalaryFileId(dto.getSalaryFile().getLong("id"));
            });
            this.executeOp(opKey, (DynamicObject[])auditCol.toArray((Object[])new DynamicObject[0]), result, isAudit);
        }
    }

    private DynamicObject createPaySettingEntity(Long salaryFileId, Long payRuleId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paysetting");
        DynamicObject paySetting = helper.generateEmptyDynamicObject();
        DynamicObjectCollection paySettingEntryDyCollection = paySetting.getDynamicObjectCollection("entryentity");
        paySetting.set("salaryfile", (Object)this.genEmptyDyObjWithPkId("hsas_salaryfile", salaryFileId));
        paySetting.set("payrule", (Object)this.genEmptyDyObjWithPkId("hsas_payaccountcfg", payRuleId));
        paySetting.set("entryentity", (Object)paySettingEntryDyCollection);
        this.setDyObjDefVal(paySetting, "hsas_paysetting");
        return paySetting;
    }

    private DynamicObject genEmptyDyObjWithPkId(String entityId, Long pkId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityId);
        DynamicObject dyobj = serviceHelper.generateEmptyDynamicObject();
        dyobj.set("id", (Object)pkId);
        return dyobj;
    }

    private void setDyObjDefVal(DynamicObject dyobj, String entityId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        Map allFields = mainEntityType.getAllFields();
        allFields.forEach((fieldKey, dp) -> {
            if (!"entryentity".equals(dp.getParent().getName())) {
                if (dp instanceof CreateDateProp || dp instanceof ModifyDateProp) {
                    dyobj.set(fieldKey, (Object)new Date());
                } else if (dp instanceof CreaterProp || dp instanceof ModifierProp) {
                    dyobj.set(fieldKey, (Object)RequestContext.get().getCurrUserId());
                } else if (dp instanceof FieldProp) {
                    dyobj.set(fieldKey, ((FieldProp)dp).getDefValue());
                }
            }
        });
    }

    public void executeOp(String opName, DynamicObject[] updatePaySettings, UpdatePaySettingResult result, boolean isAudit) {
        try {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("opType", "insert");
            operateOption.setVariableValue("ignore_validator", "1");
            operateOption.setVariableValue("ishasright", "true");
            operateOption.setVariableValue("skipCheckDataPermission", "true");
            operateOption.setVariableValue("skipCheckSpecialDataPermission", "true");
            if (isAudit) {
                operateOption.setVariableValue("status", "C");
            }
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation(opName, updatePaySettings, operateOption);
            this.successNum = this.successNum + operationResult.getSuccessPkIds().size();
            if (OP_FORMSAVE.equals(opName)) {
                result.addSuccessIds(operationResult.getSuccessPkIds().stream().map(id -> (Long)id).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            logger.error("executeOp error, msg: {}", (Object)e.getMessage());
            this.successNum = 0;
            this.setUpdateErrorResultList();
        }
    }

    private void queryRecentPaySettingRule(UpdatePaySettingBuild paySettingData) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payaccountcfg");
        DynamicObject[] query = serviceHelper.query("id,sourcevid,name,useorg,country,opsalaryitem,opsalaryitemdata,oppaymentway,oppaytype,oppayscale,oppayamount,oppaycurrency,oppaycurrencydata,oppaysubject,opentryentity.opbankpurpose,opbankpurposedata,oppayrollacrelation,oppayrollacrelationdata,rulecontent,salaryitem,salaryitemdata,paycurrency,paycurrencydata,paymentway,payscale,payamount,paysubject,paytype,bankpurpose,bankpurposedata,payrollacrelation,payrollacrelationdata", new QFilter[]{statusFilter, enableFilter, BaseDataHisHelper.getHisCurrFilter()});
        Map orgCountryToPayRuleMap = paySettingData.getOrgCountryToPayRuleMap();
        for (DynamicObject payRule : query) {
            String orgId = payRule.getString("useorg.id");
            String countryId = payRule.getString("country.id");
            orgCountryToPayRuleMap.put(orgId + '-' + countryId, payRule);
        }
        paySettingData.setOrgCountryToPayRuleMap(orgCountryToPayRuleMap);
    }

    private void queryRecentSalaryFile(UpdatePaySettingBuild paySettingData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectProperties = "id,org,status,payrollregion,employee,number,depcytype,payrollgroup,empgroup,payrollregion,person,adminorg.name,laborrelrecord.lawentity.name";
        QFilter salaryFileFilter = new QFilter("id", "in", this.salaryFileIdList);
        QFilter[] filters = new QFilter[]{salaryFileFilter};
        DynamicObject[] query = helper.query(selectProperties, filters);
        Map<Long, DynamicObject> salaryFileIdToSalaryFileMap = paySettingData.getSalaryFileIdToSalaryFileMap();
        Set<Long> salaryFileHandIdSet = paySettingData.getSalaryFileMapHandPaySetting().keySet();
        Set<Long> personIdSet = paySettingData.getPersonIdSet();
        Set<Long> personIdPerBankCardSet = paySettingData.getPersonIdSet();
        HashSet<Long> payRollGroupIdSet = new HashSet<Long>(16);
        for (DynamicObject salaryFile : query) {
            Long salaryFileId = salaryFile.getLong("id");
            Long personId = salaryFile.getLong("person.id");
            if (this.salaryFileNotPermValidator(salaryFile)) continue;
            salaryFileIdToSalaryFileMap.put(salaryFileId, salaryFile);
            if (!salaryFileHandIdSet.contains(salaryFileId)) {
                personIdSet.add(personId);
            }
            personIdPerBankCardSet.add(personId);
            payRollGroupIdSet.add(salaryFile.getLong("payrollgroup.id"));
        }
        paySettingData.setPayRollGroupAndItemMap(PaySalarySettingHelper.getPayRollGroupAndItemMap(payRollGroupIdSet));
        helper = new SWCDataServiceHelper("hrpi_perbankcard");
        selectProperties = "id,person.id,accountrelation.id,cardpurpose,sourcevid,boid";
        QFilter filter = new QFilter("person.id", "in", personIdPerBankCardSet);
        filter.and(new QFilter("isdelete", "=", (Object)Boolean.FALSE));
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        filters = new QFilter[]{filter};
        query = helper.query(selectProperties, filters);
        Map<Long, List<DynamicObject>> perBankCardIdMap = paySettingData.getPerBankCardIdMap();
        for (DynamicObject perBankCard : query) {
            Long personId = perBankCard.getLong("person.id");
            List perBankCardList = perBankCardIdMap.getOrDefault(personId, new ArrayList(10));
            perBankCardList.add(perBankCard);
            perBankCardIdMap.put(personId, perBankCardList);
        }
        paySettingData.setPerBankCardIdMap(perBankCardIdMap);
        paySettingData.setSalaryFileIdToSalaryFileMap(salaryFileIdToSalaryFileMap);
        paySettingData.setPersonIdSet(personIdSet);
    }

    private void queryRecentPaySetting(UpdatePaySettingBuild paySettingData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paysetting");
        QFilter salaryFileFilter = new QFilter("salaryfile", "in", paySettingData.getSalaryFileIdToSalaryFileMap().keySet());
        BaseDataHisHelper.addHisCurrFilter((QFilter)salaryFileFilter);
        QFilter[] filters = new QFilter[]{salaryFileFilter};
        DynamicObject[] query = helper.loadDynamicObjectArray(filters);
        Map<Long, DynamicObject> salaryFileMapPaySetting = paySettingData.getSalaryFileMapPaySetting();
        Map<Long, DynamicObject> salaryFileMapHandPaySetting = paySettingData.getSalaryFileMapHandPaySetting();
        for (DynamicObject paySetting : query) {
            boolean isManuallyModify = paySetting.getBoolean("ismanuallymodify");
            if (this.isHandUpdateBankCard.booleanValue() && isManuallyModify) {
                salaryFileMapHandPaySetting.put(paySetting.getLong("salaryfile.id"), paySetting);
                continue;
            }
            salaryFileMapPaySetting.put(paySetting.getLong("salaryfile.id"), paySetting);
        }
        paySettingData.setSalaryFileMapPaySetting(salaryFileMapPaySetting);
        paySettingData.setSalaryFileMapHandPaySetting(salaryFileMapHandPaySetting);
    }

    private void queryRecentPaySalaryList(UpdatePaySettingBuild paySettingBuild) {
        Map<Long, DynamicObject> salaryFileMapHandPaySetting = paySettingBuild.getSalaryFileMapHandPaySetting();
        Map orgCountryToPayRuleMap = paySettingBuild.getOrgCountryToPayRuleMap();
        Map<Long, DynamicObject> salaryFileIdToSalaryFileMap = paySettingBuild.getSalaryFileIdToSalaryFileMap();
        Map<Long, PersonRangeDTO> personFileInfo = paySettingBuild.getSalaryFileMapPersonRange();
        HashMap<String, List> orgCountryToSalaryFileIdListMap = new HashMap<String, List>(16);
        salaryFileIdToSalaryFileMap.forEach((salaryFileId, salaryFile) -> {
            DynamicObject paySettingHand = (DynamicObject)salaryFileMapHandPaySetting.get(salaryFileId);
            if (paySettingHand == null) {
                String orgId = salaryFile.getString("org.id");
                String countryId = salaryFile.getString("payrollregion.id");
                List idList = orgCountryToSalaryFileIdListMap.getOrDefault(orgId + '-' + countryId, new ArrayList(10));
                idList.add(salaryFileId);
                orgCountryToSalaryFileIdListMap.put(orgId + '-' + countryId, idList);
            }
        });
        orgCountryToSalaryFileIdListMap.forEach((payRuleKey, idList) -> {
            DynamicObject payRule = (DynamicObject)orgCountryToPayRuleMap.get(payRuleKey);
            PaySalarySettingHelper.getSalaryFilePersonRangeRule(payRule, idList, personFileInfo);
        });
    }

    private boolean salaryFileNotPermValidator(DynamicObject salaryFile) {
        String salaryFileStatus = salaryFile.getString("status");
        if ("E".equals(salaryFileStatus)) {
            this.setSalaryFilePermError(salaryFile, UpdatePaySettingErrorEnum.SALARY_FILE_ABANDON);
            return true;
        }
        if ("B".equals(salaryFileStatus)) {
            this.setSalaryFilePermError(salaryFile, UpdatePaySettingErrorEnum.SALARY_FILE_SUBMIT);
            return true;
        }
        return false;
    }

    private void setSalaryFilePermError(DynamicObject salaryFile, UpdatePaySettingErrorEnum errorEnum) {
        Long id = salaryFile.getLong("id");
        String number = salaryFile.getString("number");
        String personNumber = salaryFile.getString("person.number");
        String personName = salaryFile.getString("person.name");
        UpdateErrorResult result = new UpdateErrorResult(id, number, personName, personNumber);
        result.setErrorLevel(ErrorLevel.Error);
        result.setErrorReason(errorEnum.getDesc());
        result.setErrorEnum(errorEnum);
        this.updateErrorResultList.add(result);
    }

    private void setUpdateErrorResultList() {
        this.updateErrorResultList.clear();
        this.setResultToList(this.updatePaySettingAuditList);
        this.setResultToList(this.updatePaySettingSaveList);
    }

    private void setResultToList(List<UpdatePaySettingDTO> updatePaySettingSaveList) {
        updatePaySettingSaveList.forEach(dto -> {
            DynamicObject salaryFile = dto.getSalaryFile();
            Long id = salaryFile.getLong("id");
            String number = salaryFile.getString("number");
            String personNumber = salaryFile.getString("person.number");
            String personName = salaryFile.getString("person.name");
            UpdateErrorResult result = new UpdateErrorResult(id, number, personName, personNumber);
            result.setErrorReason(UpdatePaySettingErrorEnum.ERROR_ENUM.getDesc());
            result.setErrorEnum(UpdatePaySettingErrorEnum.ERROR_ENUM);
            this.updateErrorResultList.add(result);
        });
    }

    static class UpdatePaySettingBuild {
        private Map<Long, DynamicObject> salaryFileIdToSalaryFileMap = new HashMap<Long, DynamicObject>(16);
        private Map<Long, Set<Long>> payRollGroupAndItemMap = new HashMap<Long, Set<Long>>(16);
        private Set<Long> personIdSet = new HashSet<Long>(16);
        private Map<String, DynamicObject> orgCountryToPayRuleMap = new HashMap<String, DynamicObject>(16);
        private Map<Long, PersonRangeDTO> salaryFileMapPersonRange;
        private Map<Long, DynamicObject> salaryFileMapPaySetting = new HashMap<Long, DynamicObject>(16);
        private Map<Long, DynamicObject> salaryFileMapHandPaySetting = new HashMap<Long, DynamicObject>(16);
        private Map<Long, List<DynamicObject>> perBankCardIdMap = new HashMap<Long, List<DynamicObject>>(16);

        public UpdatePaySettingBuild() {
            this.salaryFileMapPersonRange = new HashMap<Long, PersonRangeDTO>(16);
        }

        private Map<String, DynamicObject> getOrgCountryToPayRuleMap() {
            return this.orgCountryToPayRuleMap;
        }

        public void setOrgCountryToPayRuleMap(Map<String, DynamicObject> orgCountryToPayRuleMap) {
            this.orgCountryToPayRuleMap = orgCountryToPayRuleMap;
        }

        public Map<Long, DynamicObject> getSalaryFileIdToSalaryFileMap() {
            return this.salaryFileIdToSalaryFileMap;
        }

        public void setSalaryFileIdToSalaryFileMap(Map<Long, DynamicObject> salaryFileIdToSalaryFileMap) {
            this.salaryFileIdToSalaryFileMap = salaryFileIdToSalaryFileMap;
        }

        public Map<Long, DynamicObject> getSalaryFileMapPaySetting() {
            return this.salaryFileMapPaySetting;
        }

        public void setSalaryFileMapPaySetting(Map<Long, DynamicObject> salaryFileMapPaySetting) {
            this.salaryFileMapPaySetting = salaryFileMapPaySetting;
        }

        public Map<Long, DynamicObject> getSalaryFileMapHandPaySetting() {
            return this.salaryFileMapHandPaySetting;
        }

        public void setSalaryFileMapHandPaySetting(Map<Long, DynamicObject> salaryFileMapHandPaySetting) {
            this.salaryFileMapHandPaySetting = salaryFileMapHandPaySetting;
        }

        public Set<Long> getPersonIdSet() {
            return this.personIdSet;
        }

        public void setPersonIdSet(Set<Long> personIdSet) {
            this.personIdSet = personIdSet;
        }

        public Map<Long, List<DynamicObject>> getPerBankCardIdMap() {
            return this.perBankCardIdMap;
        }

        public void setPerBankCardIdMap(Map<Long, List<DynamicObject>> perBankCardIdMap) {
            this.perBankCardIdMap = perBankCardIdMap;
        }

        public Map<Long, Set<Long>> getPayRollGroupAndItemMap() {
            return this.payRollGroupAndItemMap;
        }

        public void setPayRollGroupAndItemMap(Map<Long, Set<Long>> payRollGroupAndItemMap) {
            this.payRollGroupAndItemMap = payRollGroupAndItemMap;
        }

        public Map<Long, PersonRangeDTO> getSalaryFileMapPersonRange() {
            return this.salaryFileMapPersonRange;
        }

        public void setSalaryFileMapPersonRange(Map<Long, PersonRangeDTO> salaryFileMapPersonRange) {
            this.salaryFileMapPersonRange = salaryFileMapPersonRange;
        }
    }
}

