/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting.paysetting.updateobject;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.ErrorLevel;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.ErrorResultObserver;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingDTO;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingErrorEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.updateobject.BasePaySettingStrategy;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;

public class UpdateBankStrategy
extends BasePaySettingStrategy {
    UpdateBankStrategy(ErrorResultObserver observer) {
        this.OBSERVER = observer;
    }

    @Override
    public boolean strategyMethod(UpdatePaySettingDTO updatePaySettingDTO) {
        DynamicObject salaryFile = updatePaySettingDTO.getSalaryFile();
        DynamicObject paySetting = updatePaySettingDTO.getPaySetting();
        DynamicObjectCollection collection = paySetting.getDynamicObjectCollection("entryentity");
        List<DynamicObject> perBankCardList = updatePaySettingDTO.getPerBankCardList();
        HashMap perBankCardMap = new HashMap(16);
        perBankCardList.forEach(bankCard -> {
            Long id = bankCard.getLong("id");
            Long vId = bankCard.getLong("sourcevid");
            perBankCardMap.put(id, vId);
        });
        UpdatePaySettingErrorEnum reasonWarning = null;
        boolean isUpdate = false;
        for (DynamicObject payEntry : collection) {
            Long perBankCardBoId;
            Long perBankCardIdNow;
            Long perBankCardId;
            payEntry.set("salaryitemshow", (Object)"salaryitemshow");
            Long payCategoryId = payEntry.getLong("paytype.paycategory.id");
            if (!PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payCategoryId)) continue;
            boolean isDelete = payEntry.getBoolean("perbankcard.isdelete");
            if (reasonWarning == null && isDelete) {
                reasonWarning = UpdatePaySettingErrorEnum.BANK_CARD_DELETE;
            }
            if ((perBankCardId = Long.valueOf(payEntry.getLong("perbankcard.id"))) == 0L || perBankCardId.equals(perBankCardIdNow = (Long)perBankCardMap.get(perBankCardBoId = Long.valueOf(payEntry.getLong("perbankcard.boid"))))) continue;
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
            payEntry.set("perbankcard", (Object)new DynamicObject((DynamicObjectType)type, (Object)perBankCardIdNow));
            isUpdate = true;
        }
        if (!isUpdate) {
            this.OBSERVER.setErrorResult(salaryFile, UpdatePaySettingErrorEnum.NOT_UPDATE_BANK_CARD);
            return false;
        }
        if (reasonWarning != null) {
            this.OBSERVER.setErrorResult(salaryFile, ErrorLevel.Warning, reasonWarning);
        }
        updatePaySettingDTO.setPaySetting(paySetting);
        return true;
    }
}

