/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payschedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.cal.service.WorkCalendarLoadService;
import kd.swc.hsas.common.enums.PayScheduleStatusEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class PayScheduleHelper {
    private static final String PAGE_CACHE_TREE_NODE = "page_cache_tree_node";
    private static final Log LOGGER = LogFactory.getLog(PayScheduleHelper.class);

    public static void showMsgCfg(DynamicObjectCollection entryentity, List<Long> trackerIds, String dataStatus, IFormView view, String className) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_payschtplmsgcfg");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        JSONArray subEntryEntity = PayScheduleHelper.packageSendEntry(entryentity);
        showParameter.setCustomParam("subEntryEntity", (Object)subEntryEntity);
        showParameter.setCustomParam("trackerIds", trackerIds);
        if ("A".equals(dataStatus)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.setCloseCallBack(new CloseCallBack(className, "action_msgcfg"));
        view.showForm(showParameter);
    }

    private static JSONArray packageSendEntry(DynamicObjectCollection entryentity) {
        JSONArray dyColl = new JSONArray(entryentity.size());
        int index = 0;
        for (DynamicObject dyObj : entryentity) {
            JSONObject dyRow = new JSONObject();
            dyRow.put("isenable", dyObj.get("isenable"));
            dyRow.put("receiver", dyObj.get("receiver"));
            dyRow.put("msgtpl", dyObj.get("msgtpl"));
            dyRow.put("msgpushstep", dyObj.get("msgpushstep"));
            dyRow.put("msgpushnum", dyObj.get("msgpushnum"));
            dyRow.put("msgpushdaytype", dyObj.get("msgpushdaytype"));
            dyRow.put("msgpushtime", dyObj.get("msgpushtime"));
            dyColl.add((Object)dyRow);
            ++index;
        }
        return dyColl;
    }

    public static List<Map<String, String>> getWorkCalendar(Long wpId, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 0, 1);
        return WorkCalendarLoadService.loadThreeYearWorkCalendar(calendar.getTime(), wpId);
    }

    public static void setEntryByTrackersChanged(IFormView view, boolean isSubEntry, String entryEntityName) {
        List<Long> leftPeronIds;
        DynamicObjectCollection trackerDyColl;
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entryEntityName);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        if (isSubEntry) {
            int entryRowCount = view.getModel().getEntryCurrentRowIndex("entryentity");
            trackerDyColl = (DynamicObjectCollection)view.getModel().getValue("tracker", entryRowCount);
        } else {
            trackerDyColl = (DynamicObjectCollection)view.getModel().getValue("tracker");
        }
        if (trackerDyColl == null || trackerDyColl.isEmpty()) {
            view.getModel().deleteEntryData(entryEntityName);
            return;
        }
        HashSet<Long> trackerIds = new HashSet<Long>(trackerDyColl.size());
        for (DynamicObject trackerDy : trackerDyColl) {
            trackerIds.add(trackerDy.getLong("fbasedataid.id"));
        }
        ArrayList<Integer> deleteRows = new ArrayList<Integer>(entryEntity.size());
        LinkedHashMap<Integer, List<Long>> leftRowPersonMap = new LinkedHashMap<Integer, List<Long>>(entryEntity.size());
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObjectCollection receiverDyColl = ((DynamicObject)entryEntity.get(index)).getDynamicObjectCollection("receiver");
            int exclude = 0;
            leftPeronIds = new ArrayList(receiverDyColl.size());
            for (DynamicObject receiverDy : receiverDyColl) {
                long personId = receiverDy.getLong("fbasedataid.id");
                if (trackerIds.contains(personId)) {
                    leftPeronIds.add(personId);
                    continue;
                }
                ++exclude;
            }
            if (exclude == receiverDyColl.size()) {
                deleteRows.add(index);
                continue;
            }
            leftRowPersonMap.put(index, leftPeronIds);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
        for (Map.Entry entry : leftRowPersonMap.entrySet()) {
            leftPeronIds = (List)entry.getValue();
            if (leftPeronIds.isEmpty()) continue;
            Integer entryIndex = (Integer)entry.getKey();
            DynamicObjectCollection receiverDyColl = (DynamicObjectCollection)view.getModel().getValue("receiver", entryIndex.intValue());
            DynamicObjectType mulBasedataType = receiverDyColl.getDynamicObjectType();
            receiverDyColl.clear();
            for (int i = 0; i < leftPeronIds.size(); ++i) {
                Long personId = (Long)leftPeronIds.get(i);
                DynamicObject mulBasedataDy = new DynamicObject(mulBasedataType);
                DynamicObject personDy = helper.generateEmptyDynamicObject("bos_user");
                personDy.set("masterid", (Object)personId);
                personDy.set("id", (Object)personId);
                mulBasedataDy.set("fbasedataid", (Object)personDy);
                receiverDyColl.add((Object)mulBasedataDy);
            }
            view.getModel().setValue("receiver", (Object)receiverDyColl, entryIndex.intValue());
        }
        if (!deleteRows.isEmpty()) {
            view.getModel().deleteEntryRows(entryEntityName, deleteRows.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public static void putTreeNodeInCache(List<TreeNode> treeNodes) {
        String treeNodeStr = null;
        try {
            treeNodeStr = SWCJSONUtils.toString(treeNodes);
        }
        catch (IOException ex) {
            LogFactory.getLog(PayScheduleHelper.class).error("Analysis TreeNodes Json String Error!", (Throwable)ex);
        }
        if (!SWCObjectUtils.isEmpty((Object)treeNodeStr)) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            cache.put(CacheKeyUtil.getAcctId() + '.' + "swc_hsas_payrollhome_gant_tree", PAGE_CACHE_TREE_NODE + RequestContext.get().getCurrUserId(), (Object)treeNodeStr);
        }
    }

    public static List<TreeNode> getTreeNodeInCache() {
        ArrayList orgNodes = null;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String treeNodeStr = (String)cache.get(CacheKeyUtil.getAcctId() + '.' + "swc_hsas_payrollhome_gant_tree", PAGE_CACHE_TREE_NODE + RequestContext.get().getCurrUserId());
        if (!SWCObjectUtils.isEmpty((Object)treeNodeStr)) {
            try {
                orgNodes = (ArrayList)SWCJSONUtils.cast((String)treeNodeStr, List.class, (Class[])new Class[]{TreeNode.class});
            }
            catch (IOException exception) {
                LogFactory.getLog(PayScheduleHelper.class).error("Analysis TreeNodes Json String Error!", (Throwable)exception);
                orgNodes = new ArrayList(10);
            }
        } else {
            orgNodes = PayScheduleHelper.queryAndBuildTreeNode();
            PayScheduleHelper.putTreeNodeInCache(orgNodes);
        }
        return orgNodes;
    }

    public static void clearTreeNodeInCache() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.remove(CacheKeyUtil.getAcctId() + '.' + "swc_hsas_payrollhome_gant_tree");
    }

    public static List<TreeNode> queryAndBuildTreeNode() {
        HashMap<Long, Set<Long>> orgPayrollGrpMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Set<Long>> payrollGrpCalRuleMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(16);
        HashMap<Long, String> payrollGrpNameMap = new HashMap<Long, String>(16);
        HashMap<Long, String> payrollSceneNameMap = new HashMap<Long, String>(16);
        PayScheduleHelper.queryPayrollGrp(orgPayrollGrpMap, payrollGrpCalRuleMap, orgNameMap, payrollGrpNameMap, payrollSceneNameMap);
        if (orgPayrollGrpMap.isEmpty() || payrollGrpCalRuleMap.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        for (Map.Entry entry : orgPayrollGrpMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            String orgTreeNodeId = orgId.toString();
            TreeNode orgTreeNode = new TreeNode("payrollhome_gantt_root_node_id", orgTreeNodeId, (String)orgNameMap.get(orgId));
            Set payrollGrpIds = (Set)entry.getValue();
            for (Long payrollGrpId : payrollGrpIds) {
                String payrollGrpTreeNodeId = orgTreeNodeId + "&" + String.valueOf(payrollGrpId);
                TreeNode payrollGrpTreeNode = new TreeNode(orgTreeNodeId, payrollGrpTreeNodeId, (String)payrollGrpNameMap.get(payrollGrpId));
                Set payrollSceneIds = (Set)payrollGrpCalRuleMap.get(payrollGrpId);
                for (Long payrollSceneId : payrollSceneIds) {
                    String payrollSceneTreeNodeId = payrollGrpTreeNodeId + "&" + String.valueOf(payrollSceneId);
                    TreeNode calRuleTreeNode = new TreeNode(payrollGrpTreeNodeId, payrollSceneTreeNodeId, (String)payrollSceneNameMap.get(payrollSceneId));
                    payrollGrpTreeNode.addChild(calRuleTreeNode);
                }
                orgTreeNode.addChild(payrollGrpTreeNode);
            }
            treeNodes.add(orgTreeNode);
        }
        return treeNodes;
    }

    public static void queryPayrollGrp(Map<Long, Set<Long>> orgPayrollGrpMap, Map<Long, Set<Long>> payrollGrpCalRuleMap, Map<Long, String> orgNameMap, Map<Long, String> payrollGrpNameMap, Map<Long, String> payrollSceneNameMap) {
        DynamicObject[] paySchDys;
        SWCDataServiceHelper paySchHelper = new SWCDataServiceHelper("hsas_payschedule");
        String selProps = "org.id,org.name,payrollgrp.id,payrollgrp.name,payrollscene.id,payrollscene.name";
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            qFilter.and("org", "in", (Object)hasPermOrgs);
        }
        for (DynamicObject paySchDy : paySchDys = paySchHelper.queryOriginalArray(selProps, qFilter.toArray())) {
            long orgId = paySchDy.getLong("org.id");
            long payrollGrpId = paySchDy.getLong("payrollgrp.id");
            long payrollSceneId = paySchDy.getLong("payrollscene.id");
            Set<Long> payrollGrpIds = orgPayrollGrpMap.get(orgId);
            if (payrollGrpIds == null) {
                HashSet<Long> payrollGrpIdsInit = new HashSet<Long>(16);
                payrollGrpIdsInit.add(payrollGrpId);
                orgPayrollGrpMap.put(orgId, payrollGrpIdsInit);
            } else {
                payrollGrpIds.add(payrollGrpId);
                orgPayrollGrpMap.put(orgId, payrollGrpIds);
            }
            Set<Long> payrollSceneIds = payrollGrpCalRuleMap.get(payrollGrpId);
            if (payrollSceneIds == null) {
                HashSet<Long> calRuleIdsInit = new HashSet<Long>(16);
                calRuleIdsInit.add(payrollSceneId);
                payrollGrpCalRuleMap.put(payrollGrpId, calRuleIdsInit);
            } else {
                payrollSceneIds.add(payrollSceneId);
                payrollGrpCalRuleMap.put(payrollGrpId, payrollSceneIds);
            }
            orgNameMap.put(orgId, paySchDy.getString("org.name"));
            payrollGrpNameMap.put(payrollGrpId, paySchDy.getString("payrollgrp.name"));
            payrollSceneNameMap.put(payrollSceneId, paySchDy.getString("payrollscene.name"));
        }
    }

    public static void markPayScheduleStatus(String operationKey, DynamicObject[] dataEntities) {
        block10: for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("markuser", (Object)RequestContext.get().getCurrUserId());
            String scheduleStatus = dataEntity.getString("schedulestatus");
            switch (operationKey) {
                case "donothing_unstarted": {
                    dataEntity.set("schedulestatus", (Object)PayScheduleStatusEnum.UNSTARTED.getCode());
                    dataEntity.set("finishtime", null);
                    continue block10;
                }
                case "donothing_processing": {
                    dataEntity.set("schedulestatus", (Object)PayScheduleStatusEnum.PROCESSING.getCode());
                    dataEntity.set("finishtime", null);
                    continue block10;
                }
                case "donothing_finished": {
                    dataEntity.set("finishtime", (Object)new Date());
                    if (PayScheduleStatusEnum.OVERDUE.getCode().equals(scheduleStatus) || PayScheduleStatusEnum.OVERDUE_FINISHED.getCode().equals(scheduleStatus)) {
                        dataEntity.set("schedulestatus", (Object)PayScheduleStatusEnum.OVERDUE_FINISHED.getCode());
                        continue block10;
                    }
                    dataEntity.set("schedulestatus", (Object)PayScheduleStatusEnum.FINISHED.getCode());
                    continue block10;
                }
            }
        }
    }

    public static void clickPayrollSceneF7(BeforeF7SelectEvent event, IDataModel dataModel) {
        SWCDataServiceHelper grpvHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        long payrollGrpvId = dataModel.getDataEntity().getLong("payrollgrpv.id");
        QFilter grpvFilter = new QFilter("id", "=", (Object)payrollGrpvId);
        DynamicObject payrollGrpV = grpvHelper.queryOne("payrollsceneentry,payrollscene.id", grpvFilter.toArray());
        if (payrollGrpV == null) {
            return;
        }
        DynamicObjectCollection payrollSceneEntry = payrollGrpV.getDynamicObjectCollection("payrollsceneentry");
        HashSet<Long> payrollSceneIds = new HashSet<Long>(16);
        for (DynamicObject entry : payrollSceneEntry) {
            long payrollSceneId = entry.getLong("payrollscene.id");
            payrollSceneIds.add(payrollSceneId);
        }
        QFilter payrollSceneFilter = new QFilter("id", "in", payrollSceneIds);
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.getListFilterParameter().setFilter(payrollSceneFilter);
    }

    public static void changePayRollGrp(ChangeData[] changeSets, IFormView view, IDataModel model) {
        if (changeSets != null && changeSets.length > 0) {
            if (SWCObjectUtils.isEmpty((Object)changeSets[0].getNewValue())) {
                model.setValue("payrollgrpv", null);
                view.setEnable(Boolean.FALSE, new String[]{"payrollgrpv"});
            } else {
                long payrollGrpId = model.getDataEntity().getLong("payrollgrp.id");
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
                QFilter qFilter = new QFilter("boid", "=", (Object)payrollGrpId);
                qFilter.and("datastatus", "=", (Object)"1");
                BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
                DynamicObject payrollGrpvDy = helper.queryOne("id", qFilter.toArray());
                if (payrollGrpvDy != null) {
                    model.setValue("payrollgrpv", (Object)payrollGrpvDy.getLong("id"));
                    view.updateView("payrollgrpv");
                } else {
                    model.setValue("payrollgrpv", null);
                }
                view.setEnable(Boolean.TRUE, new String[]{"payrollgrpv"});
            }
        }
    }
}

