/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.personchange;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.personchange.PersonChangeServiceHelper;
import kd.swc.hsas.common.enums.PersonChangeSourceEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class PersonChangeLogHelper {
    public static final Log log = LogFactory.getLog(PersonChangeLogHelper.class);
    private static final PersonChangeServiceHelper personChangeServiceHelper = PersonChangeServiceHelper.getInstance();

    public static void generatePersonChange(DynamicObject[] personChangeLogs, Long currUserId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personchangelog");
        try {
            HashMap<String, List<DynamicObject>> logMap = new HashMap<String, List<DynamicObject>>(16);
            List<Map<String, Object>> params = PersonChangeLogHelper.assembleGenChangeRecordParam(personChangeLogs, currUserId, logMap);
            log.info("PersonChangeLogHelper.generatePersonChange params: {}", params);
            DynamicObject[] personChanges = personChangeServiceHelper.createPersonChange(PersonChangeSourceEnum.BIZDATA.getCode(), params);
            personChangeServiceHelper.afterGenPersonChange(params, Boolean.FALSE);
            Set successKeys = Arrays.stream(personChanges).map(dy -> PersonChangeServiceHelper.getKey(dy.getLong("salaryfile.id"), dy.getLong("changereason.id"), SWCDateTimeUtils.format((Date)dy.getDate("changedate"), (String)"yyyy-MM-dd"))).collect(Collectors.toSet());
            Date currentTime = new Date();
            for (Map.Entry entry : logMap.entrySet()) {
                if (successKeys.contains(entry.getKey())) {
                    ((List)entry.getValue()).forEach(dy -> {
                        dy.set("status", (Object)1);
                        dy.set("operatedate", (Object)currentTime);
                    });
                    continue;
                }
                ((List)entry.getValue()).forEach(dy -> {
                    dy.set("status", (Object)0);
                    dy.set("operatedate", (Object)currentTime);
                });
            }
            helper.update(personChangeLogs);
            List<DynamicObject> waitGenerateEventDys = Arrays.stream(personChanges).filter(dy -> !"1".equals(dy.getString("generatedstatus"))).collect(Collectors.toList());
            PersonChangeServiceHelper.generateProrationEvent(waitGenerateEventDys.toArray(new DynamicObject[waitGenerateEventDys.size()]));
        }
        catch (Exception exp) {
            log.error("genPersonChangeForSalaryFile() error {0}", (Throwable)exp);
            String msg = exp instanceof KDException && "codeRuleStepSizeIsFull".equals(((KDException)exp).getErrorCode().getCode()) ? ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u6d41\u6c34\u53f7\u5df2\u7528\u5b8c\uff0c\u751f\u6210\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u5931\u8d25\uff0c\u8bf7\u8c03\u6574\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"PersonChangeServiceHelper_20", (String)"swc-hsas-business", (Object[])new Object[0]) : exp.getMessage();
            for (DynamicObject personChangeLog : personChangeLogs) {
                personChangeLog.set("status", (Object)0);
                personChangeLog.set("errormsg", (Object)msg);
            }
            helper.update(personChangeLogs);
        }
    }

    private static List<Map<String, Object>> assembleGenChangeRecordParam(DynamicObject[] dataEntities, Long currUserId, Map<String, List<DynamicObject>> logMap) {
        String notMatchMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u89c4\u5219\u7ba1\u7406\u7684\u7b56\u7565\u7ba1\u7406\u914d\u7f6e\u3002", (String)"PersonChangeLogHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        Map<String, List<DynamicObject>> gMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(dy -> PersonChangeLogHelper.getSalaryActBuKey(dy)));
        log.info("PersonChangeLogHelper.assembleGenChangeRecordParam dataEntities gMap: {}", gMap.keySet());
        HashMap<String, Object> resMap = new HashMap<String, Object>(gMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : gMap.entrySet()) {
            DynamicObject dy2 = entry.getValue().get(0);
            String buNumber = dy2.getString("salaryfile.org.number");
            Long salaryAdjustRsnId = dy2.getLong("salaryadjustrsn.id");
            Long actionId = dy2.getLong("action.id");
            personChangeServiceHelper.callRuleEngine(buNumber, salaryAdjustRsnId, actionId, entry.getKey(), resMap);
        }
        log.info("PersonChangeLogHelper.assembleGenChangeRecordParam changeReason resMap: {}", resMap);
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long changeReasonId = MapUtils.getLong(resMap, (Object)PersonChangeLogHelper.getSalaryActBuKey(dataEntity));
            if (SWCObjectUtils.isEmpty((Object)changeReasonId)) {
                String errorMsg = MapUtils.getString(resMap, (Object)PersonChangeServiceHelper.getKey(PersonChangeLogHelper.getSalaryActBuKey(dataEntity), "errorMsg"));
                if (SWCStringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = notMatchMsg;
                }
                dataEntity.set("errormsg", (Object)errorMsg);
            } else {
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("salaryFileId", dataEntity.getLong("salaryfile.id"));
                param.put("changeDate", dataEntity.getDate("changedate"));
                param.put("salaryAdjustRsnId", dataEntity.getLong("salaryadjustrsn.id"));
                param.put("actionId", dataEntity.getLong("action.id"));
                param.put("bizDataId", dataEntity.getLong("bizdataid"));
                param.put("bizDataCode", dataEntity.getString("bizdatacode"));
                param.put("cycle", dataEntity.get("cycle"));
                param.put("creatorId", currUserId);
                param.put("changeReasonId", changeReasonId);
                params.add(param);
            }
            String key = PersonChangeServiceHelper.getKey(dataEntity.getLong("salaryfile.id"), changeReasonId, SWCDateTimeUtils.format((Date)dataEntity.getDate("changedate"), (String)"yyyy-MM-dd"));
            List list = logMap.getOrDefault(key, new ArrayList());
            list.add(dataEntity);
            logMap.put(key, list);
        }
        return params;
    }

    private static String getSalaryActBuKey(DynamicObject dy) {
        return PersonChangeServiceHelper.getKey(dy.get("salaryadjustrsn.id"), dy.get("action.id"), dy.get("salaryfile.org.number"));
    }
}

