/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.prorationevent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.prorationevent.ProrationEventUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ProrationEventService {
    private static final Log logger = LogFactory.getLog(ProrationEventService.class);
    private static final int SUCCESS_CODE = 200;
    private static final int NO_GENERATE_CODE = 300;
    private static final int FAIL_CODE = 400;

    public List<Map<String, Object>> autoGenrateEvent(List<Map<String, Object>> request) {
        CalHelper.printLog("autoGenrateEvent start,request=>", request);
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>(request.size());
        Set<Long> salaryFileIdSet = request.stream().map(obj -> (Long)obj.get("salaryFile")).collect(Collectors.toSet());
        Map<Long, Long> salaryFileRelMap = this.getSalaryFileRelMap(salaryFileIdSet);
        HashMap<Long, String> failMap = new HashMap<Long, String>(16);
        HashMap<Long, String> noGenerateMap = new HashMap<Long, String>(16);
        DynamicObjectCollection payRollData = this.matchPayRollGrpVersionData(salaryFileRelMap, request, failMap);
        Set<Long> genRuleIdSet = payRollData.stream().map(obj -> obj.getLong("payrollsceneentry.prorationgenrule.id")).collect(Collectors.toSet());
        Map<Long, Map<Long, DynamicObject>> ruleMap = this.getProrationGenRuleData(genRuleIdSet);
        Map<Long, Set<Long>> fileGenRuleRelMap = this.getSalaryFileGenRuleRelMap(payRollData, salaryFileRelMap, noGenerateMap);
        List<Map<String, Object>> successList = this.matchGenRule(request, ruleMap, fileGenRuleRelMap, response, failMap, noGenerateMap);
        DynamicObjectCollection prorationEventList = this.checkIsExistInDb(successList, response);
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationevent");
            if (prorationEventList.size() > 0) {
                helper.save(prorationEventList);
            }
        }
        return response;
    }

    private DynamicObjectCollection checkIsExistInDb(List<Map<String, Object>> successList, List<Map<String, Object>> response) {
        HashSet<Long> genRuleIdSet = new HashSet<Long>(successList.size());
        HashSet<Long> fileIdSet = new HashSet<Long>(successList.size());
        HashSet<Long> reasonIdSet = new HashSet<Long>(successList.size());
        HashSet<Date> prorationDateSet = new HashSet<Date>(successList.size());
        for (Map<String, Object> obj2 : successList) {
            genRuleIdSet.add((Long)obj2.get("prorationGenRule"));
            fileIdSet.add((Long)obj2.get("salaryFile"));
            reasonIdSet.add((Long)obj2.get("changeReason"));
            prorationDateSet.add((Date)obj2.get("prorationDate"));
        }
        QFilter filter = new QFilter("salaryfile.id", "in", fileIdSet);
        filter.and("prorationgenrule.id", "in", genRuleIdSet);
        filter.and("changereason.id", "in", reasonIdSet);
        filter.and("eventstatus", "=", (Object)"1");
        QFilter dateFilter = null;
        for (Date temp : prorationDateSet) {
            if (dateFilter == null) {
                dateFilter = new QFilter("prorationdate", "=", (Object)temp);
                continue;
            }
            dateFilter.or("prorationdate", "=", (Object)temp);
        }
        filter.and(dateFilter);
        Map<String, DynamicObject> eventMap = ProrationEventUtils.getProrationEventMap(filter);
        DynamicObjectCollection prorationEventList = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_prorationevent");
        Map<Long, List<Map>> dataMap = successList.stream().collect(Collectors.groupingBy(obj -> (Long)obj.get("personChange")));
        String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u201c\u6863\u6848\u201d\u3001\u201c\u5206\u6bb5\u65e5\u671f\u201d\u3001\u201c\u53d8\u52a8\u539f\u56e0\u201d\u3001\u201c\u5206\u6bb5\u7c7b\u578b\u201d\u7684\u6570\u636e\u3002", (String)"ProrationEventService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        boolean noCheckPassflag = true;
        HashMap<String, Object> resultMap = null;
        for (Map.Entry<Long, List<Map>> entry : dataMap.entrySet()) {
            noCheckPassflag = true;
            Long salaryFileId = null;
            Long personChangeId = null;
            for (Map tempMap : entry.getValue()) {
                salaryFileId = (Long)tempMap.get("salaryFile");
                personChangeId = (Long)tempMap.get("personChange");
                if (eventMap.containsKey(this.getMapKey(tempMap))) continue;
                prorationEventList.add((Object)this.createProrationEventObj((DynamicObjectType)type, tempMap));
                noCheckPassflag = false;
            }
            resultMap = new HashMap<String, Object>(4);
            resultMap.put("salaryFile", salaryFileId);
            resultMap.put("personChange", personChangeId);
            if (noCheckPassflag) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("code", 400);
                resultMap.put("message", msg);
            } else {
                resultMap.put("success", Boolean.TRUE);
                resultMap.put("message", "");
                resultMap.put("code", 200);
            }
            response.add(resultMap);
        }
        return prorationEventList;
    }

    private DynamicObject createProrationEventObj(DynamicObjectType type, Map<String, Object> tempMap) {
        DynamicObject event = (DynamicObject)type.createInstance();
        event.set("salaryfile", tempMap.get("salaryFile"));
        event.set("prorationgenrule", tempMap.get("prorationGenRule"));
        event.set("changereason", tempMap.get("changeReason"));
        event.set("prorationdate", tempMap.get("prorationDate"));
        event.set("personchange", tempMap.get("personChange"));
        event.set("prorationtype", tempMap.get("prorationType"));
        ProrationEventUtils.setMulBaseDataFieldValue((DynamicObjectCollection)tempMap.get("prorationItem"), event);
        event.set("source", (Object)"2");
        event.set("eventstatus", (Object)"1");
        event.set("referencestatus", (Object)"1");
        event.set("createtime", (Object)new Date());
        event.set("modifytime", (Object)new Date());
        event.set("creator", (Object)RequestContext.get().getCurrUserId());
        event.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return event;
    }

    private String getMapKey(Map<String, Object> tempMap) {
        return tempMap.get("salaryFile") + "@;@" + tempMap.get("prorationGenRule") + "@;@" + tempMap.get("changeReason") + "@;@" + SWCDateTimeUtils.format((Date)((Date)tempMap.get("prorationDate")), (String)"yyyy-MM-dd");
    }

    private List<Map<String, Object>> matchGenRule(List<Map<String, Object>> request, Map<Long, Map<Long, DynamicObject>> ruleMap, Map<Long, Set<Long>> fileGenRuleRelMap, List<Map<String, Object>> response, Map<Long, String> failMap, Map<Long, String> noGenerateMap) {
        Long salaryFileId = null;
        Set<Long> ruleIdSet = null;
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(10);
        Map<Long, DynamicObject> reasonMap = null;
        String msg = ResManager.loadKDString((String)"\u6839\u636e\u53d8\u52a8\u539f\u56e0\uff0c\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\uff0c\u65e0\u6cd5\u751f\u6210\u4eba\u5458\u5206\u6bb5\u4e8b\u4ef6\u3002", (String)"ProrationEventService_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        DynamicObject reasonObj = null;
        boolean isMatch = false;
        String errorMsg = null;
        for (Map<String, Object> tempMap : request) {
            HashMap<String, Long> resultMap;
            salaryFileId = (Long)tempMap.get("salaryFile");
            ruleIdSet = fileGenRuleRelMap.get(salaryFileId);
            if (ruleIdSet == null) {
                resultMap = new HashMap(4);
                resultMap.put("salaryFile", salaryFileId);
                resultMap.put("personChange", (Long)tempMap.get("personChange"));
                resultMap.put("success", (Long)((Object)Boolean.FALSE));
                errorMsg = failMap.get(salaryFileId);
                if (errorMsg != null) {
                    resultMap.put("message", (Long)((Object)errorMsg));
                    resultMap.put("code", (Long)400);
                } else {
                    resultMap.put("message", (Long)((Object)noGenerateMap.get(salaryFileId)));
                    resultMap.put("code", (Long)300);
                }
                response.add(resultMap);
                continue;
            }
            isMatch = false;
            for (Long ruleId : ruleIdSet) {
                reasonMap = ruleMap.get(ruleId);
                reasonObj = reasonMap.get((Long)tempMap.get("changeReason"));
                if (reasonObj == null) continue;
                successList.add(this.getSuccessMap(tempMap, reasonObj, ruleId, salaryFileId));
                isMatch = true;
            }
            if (isMatch) continue;
            resultMap = new HashMap<String, Long>(5);
            resultMap.put("salaryFile", salaryFileId);
            resultMap.put("personChange", (Long)tempMap.get("personChange"));
            resultMap.put("success", (Long)((Object)Boolean.FALSE));
            resultMap.put("code", (Long)300);
            resultMap.put("message", (Long)((Object)msg));
            response.add(resultMap);
        }
        return successList;
    }

    private Map<String, Object> getSuccessMap(Map<String, Object> tempMap, DynamicObject reasonObj, Long ruleId, Long salaryFileId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("salaryFile", salaryFileId);
        result.put("prorationGenRule", ruleId);
        result.put("changeReason", reasonObj.getLong("changereason.id"));
        result.put("prorationDate", tempMap.get("prorationDate"));
        result.put("prorationType", reasonObj.getString("prorationtype"));
        result.put("prorationItem", reasonObj.getDynamicObjectCollection("prorationitem"));
        result.put("personChange", tempMap.get("personChange"));
        return result;
    }

    private Map<Long, Set<Long>> getSalaryFileGenRuleRelMap(DynamicObjectCollection payRollData, Map<Long, Long> salaryFileRelMap, Map<Long, String> noGenerateMap) {
        HashMap<Long, Set<Long>> fileGenRuleRelMap = new HashMap<Long, Set<Long>>(salaryFileRelMap.size());
        Map<Long, List<DynamicObject>> payRollMap = payRollData.stream().collect(Collectors.groupingBy(obj -> obj.getLong("boid")));
        String msg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u6570\u636e\u4e2d\uff0c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5206\u6bb5\u8ba1\u7b97\u201d\uff0c\u65e0\u6cd5\u751f\u6210\u4eba\u5458\u5206\u6bb5\u4e8b\u4ef6\u3002", (String)"ProrationEventService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        List<DynamicObject> tempList = null;
        for (Map.Entry<Long, Long> entry : salaryFileRelMap.entrySet()) {
            tempList = payRollMap.get(entry.getValue());
            if (tempList == null) {
                noGenerateMap.put(entry.getKey(), msg);
                continue;
            }
            fileGenRuleRelMap.put(entry.getKey(), this.removeRepeatData(tempList));
        }
        return fileGenRuleRelMap;
    }

    private Set<Long> removeRepeatData(List<DynamicObject> entryList) {
        HashSet<Long> genRuleIdSet = new HashSet<Long>(entryList.size());
        for (DynamicObject obj : entryList) {
            genRuleIdSet.add(obj.getLong("payrollsceneentry.prorationgenrule.id"));
        }
        return genRuleIdSet;
    }

    private Map<Long, Map<Long, DynamicObject>> getProrationGenRuleData(Set<Long> genRuleIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationgenrule");
        String fields = "id,entryentity,changereason,prorationtype,prorationitem";
        DynamicObject[] result = helper.query(fields, new QFilter[]{new QFilter("id", "in", genRuleIdSet)});
        HashMap<Long, Map<Long, DynamicObject>> ruleMap = new HashMap<Long, Map<Long, DynamicObject>>(result.length);
        HashMap<Long, DynamicObject> reasonMap = null;
        DynamicObjectCollection entryList = null;
        for (DynamicObject rule : result) {
            entryList = rule.getDynamicObjectCollection("entryentity");
            if (entryList == null) continue;
            reasonMap = new HashMap<Long, DynamicObject>(16);
            ruleMap.put(rule.getLong("id"), reasonMap);
            for (DynamicObject entry : entryList) {
                reasonMap.put(entry.getLong("changereason.id"), entry);
            }
        }
        return ruleMap;
    }

    private DynamicObjectCollection matchPayRollGrpVersionData(Map<Long, Long> salaryFileRelMap, List<Map<String, Object>> request, Map<Long, String> failMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("boid", "in", salaryFileRelMap.values());
        filter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        String fields = "id,boid,bsed,bsled";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "boid desc,bsed desc");
        Map<Long, List<DynamicObject>> payRollGrpMap = result.stream().collect(Collectors.groupingBy(obj -> obj.getLong("boid")));
        String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u6bb5\u4e8b\u4ef6\u3002", (String)"ProrationEventService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        List<DynamicObject> payRollList = null;
        Long salaryFileId = null;
        Long tempPayRollId = null;
        HashSet<Long> payRollIdSet = new HashSet<Long>(request.size());
        Date prorationDate = null;
        boolean isMatch = false;
        for (Map<String, Object> tempMap : request) {
            salaryFileId = (Long)tempMap.get("salaryFile");
            tempPayRollId = salaryFileRelMap.get(salaryFileId);
            payRollList = payRollGrpMap.get(tempPayRollId);
            if (payRollList == null) {
                logger.info("salaryFile:{} is not match payRollGrp Version", (Object)salaryFileId);
                failMap.put(salaryFileId, msg);
                salaryFileRelMap.remove(salaryFileId);
                continue;
            }
            isMatch = false;
            prorationDate = (Date)tempMap.get("prorationDate");
            for (DynamicObject payRoll : payRollList) {
                if (payRoll.getDate("bsed").after(prorationDate) || payRoll.getDate("bsled").before(prorationDate)) continue;
                payRollIdSet.add(payRoll.getLong("id"));
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            failMap.put(salaryFileId, msg);
            salaryFileRelMap.remove(salaryFileId);
        }
        filter = new QFilter("id", "in", payRollIdSet);
        filter.and("payrollsceneentry.prorationcal", "=", (Object)"1");
        fields = "id,boid,payrollsceneentry.prorationgenrule.id";
        return helper.queryOriginalCollection(fields, new QFilter[]{filter});
    }

    private Map<Long, Long> getSalaryFileRelMap(Set<Long> salaryFileIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", salaryFileIdSet);
        String fields = "id,payrollgroup.id";
        DynamicObjectCollection salaryFileData = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return salaryFileData.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong("payrollgroup.id")));
    }

    public List<Map<String, Object>> abandonProrationEvent(List<Map<String, Long>> request) {
        logger.info("abandonProrationEvent start,request => {}", (Object)request.toString());
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>(request.size());
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(16);
        HashSet<Long> personChangeIdSet = new HashSet<Long>(16);
        for (Map<String, Long> tempMap : request) {
            salaryFileIdSet.add(tempMap.get("salaryFile"));
            personChangeIdSet.add(tempMap.get("personChange"));
        }
        HashMap<String, String> errorMap = new HashMap<String, String>(16);
        HashMap<Long, DynamicObject> prorationEventRelMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection successCollection = new DynamicObjectCollection();
        QFilter filter = new QFilter("salaryfile", "in", salaryFileIdSet);
        filter.and("personchange", "in", personChangeIdSet);
        String fields = "id,salaryfile.id,personchange,eventstatus,referencestatus,modifytime,modifier";
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationevent");
        DynamicObject[] eventData = helper.query(fields, new QFilter[]{filter});
        if (eventData == null || eventData.length == 0) {
            HashMap<String, Object> resultMap = null;
            String notFoundMsg = ResManager.loadKDString((String)"\u8be5\u53d8\u52a8\u8bb0\u5f55\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u5206\u6bb5\u4e8b\u4ef6\u3002", (String)"ProrationEventService_6", (String)"swc-hsas-business", (Object[])new Object[0]);
            for (Map<String, Long> tempMap : request) {
                resultMap = new HashMap<String, Object>(5);
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("code", 400);
                resultMap.put("message", notFoundMsg);
                resultMap.put("salaryFile", tempMap.get("salaryFile"));
                resultMap.put("personChange", tempMap.get("personChange"));
                response.add(resultMap);
            }
            return response;
        }
        this.checkEventStatus(errorMap, prorationEventRelMap, successCollection, eventData, request);
        this.checkReference(errorMap, prorationEventRelMap, successCollection);
        HashMap<String, Object> resultMap = null;
        String errorMsg = null;
        for (Map<String, Long> tempMap : request) {
            resultMap = new HashMap<String, Object>(5);
            errorMsg = (String)errorMap.get(tempMap.get("salaryFile") + "-" + tempMap.get("personChange"));
            if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("code", 400);
                resultMap.put("message", errorMsg);
            } else {
                resultMap.put("success", Boolean.TRUE);
                resultMap.put("code", 200);
                resultMap.put("message", null);
            }
            resultMap.put("salaryFile", tempMap.get("salaryFile"));
            resultMap.put("personChange", tempMap.get("personChange"));
            response.add(resultMap);
        }
        try (TXHandle txHandle = TX.required();){
            if (successCollection.size() > 0) {
                Object[] updateArray = new DynamicObject[successCollection.size()];
                successCollection.toArray(updateArray);
                helper.update((DynamicObject[])updateArray);
            }
        }
        logger.info("abandonProrationEvent end,response => {}", (Object)((Object)response).toString());
        return response;
    }

    private void checkReference(Map<String, String> errorMap, Map<Long, DynamicObject> prorationEventRelMap, DynamicObjectCollection successCollection) {
        if (prorationEventRelMap.size() == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> relMap = ProrationEventUtils.getProrationEventRelMap(prorationEventRelMap.keySet());
        List<DynamicObject> relList = null;
        String key = null;
        String msg = null;
        String existMsg = null;
        for (Map.Entry<Long, DynamicObject> entry : prorationEventRelMap.entrySet()) {
            relList = relMap.get(entry.getKey());
            if (relList == null || relList.size() == 0) {
                entry.getValue().set("eventstatus", (Object)"2");
                entry.getValue().set("modifytime", (Object)new Date());
                entry.getValue().set("modifier", (Object)RequestContext.get().getCurrUserId());
                successCollection.add((Object)entry.getValue());
                continue;
            }
            key = entry.getValue().getLong("salaryfile.id") + "-" + entry.getValue().getLong("personchange");
            msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5206\u6bb5\u4e8b\u4ef6\u88ab\u4ecd\u5728\u5904\u7406\u4e2d\u7684\u6838\u7b97\u4efb\u52a1\u201c{0}\u201d\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u8be5\u6838\u7b97\u4eba\u5458\u6216\u5e9f\u5f03\u6838\u7b97\u4efb\u52a1\u3002", (String)"ProrationEventService_5", (String)"swc-hsas-business", (Object[])new Object[]{ProrationEventUtils.getCalTaskName(relList)});
            existMsg = errorMap.get(key);
            existMsg = SWCStringUtils.isNotEmpty((String)existMsg) ? existMsg + ";" + msg : msg;
            errorMap.put(key, existMsg);
        }
    }

    private void checkEventStatus(Map<String, String> errorMap, Map<Long, DynamicObject> prorationEventRelMap, DynamicObjectCollection successCollection, DynamicObject[] eventData, List<Map<String, Long>> request) {
        Map<String, List<DynamicObject>> eventMap = Arrays.asList(eventData).stream().collect(Collectors.groupingBy(obj -> obj.getLong("salaryfile.id") + "-" + obj.getLong("personchange")));
        List<DynamicObject> tempList = null;
        String key = null;
        String msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5206\u6bb5\u4e8b\u4ef6\u5df2\u5e9f\u5f03\uff0c\u4e0d\u80fd\u518d\u5e9f\u5f03\u3002", (String)"ProrationEventService_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Map<String, Long> tempMap : request) {
            key = tempMap.get("salaryFile") + "-" + tempMap.get("personChange");
            tempList = eventMap.get(key);
            if (tempList == null) {
                errorMap.put(key, ResManager.loadKDString((String)"\u8be5\u53d8\u52a8\u8bb0\u5f55\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u5206\u6bb5\u4e8b\u4ef6\u3002", (String)"ProrationEventService_6", (String)"swc-hsas-business", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject obj2 : tempList) {
                if ("2".equals(obj2.getString("eventstatus"))) {
                    errorMap.put(obj2.getLong("salaryfile.id") + "-" + obj2.getLong("personchange"), msg);
                    continue;
                }
                if ("2".equals(obj2.getString("referencestatus"))) {
                    prorationEventRelMap.put(obj2.getLong("id"), obj2);
                    continue;
                }
                obj2.set("eventstatus", (Object)"2");
                obj2.set("modifytime", (Object)new Date());
                obj2.set("modifier", (Object)RequestContext.get().getCurrUserId());
                successCollection.add((Object)obj2);
            }
        }
    }
}

