/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salarydeatilresult.service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.list.SummaryResult;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.sdk.swc.hsas.common.enums.SalaryItemTypeEnum;
import kd.swc.hsas.business.cal.helper.CalResultQueryHelper;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsas.common.constants.SalaryFileExportConstants;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.SWCFieldType;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class SalaryDetailResultListService {
    public final Log log = LogFactory.getLog(SalaryDetailResultListService.class);
    private final int bitchSize = 1000;
    private int totalDataBitchSize;
    private DynamicObject[] calPersonIdArray;
    private int totalPageCount;

    public void getCalResultItemData(DynamicObjectCollection calResultDatas, Map<String, Map<String, Object>> calResultTplMap, Long calTaskId, String currencyKey, Boolean showCurrency) {
        SalaryDetailResultListHelper helper = new SalaryDetailResultListHelper();
        DynamicObject taskInfo = helper.getTaskInfo(calTaskId);
        DynamicObject calCurrency = taskInfo.getDynamicObject("payrollgroupv.currency");
        ArrayList<Long> calPersonList = new ArrayList<Long>(calResultDatas.size());
        this.log.info("getCalResultItemData showCurrency is:{}", (Object)showCurrency);
        for (DynamicObject dataObj : calResultDatas) {
            calPersonList.add(dataObj.getLong("id"));
            this.buildCurrencyVal(dataObj, calCurrency, currencyKey, showCurrency);
        }
        Map<Long, Long> calResultIdMap = this.getCalResultIdList(calPersonList);
        if (calResultIdMap == null || calResultIdMap.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject[]> calPersonMap = new HashMap<Long, DynamicObject[]>(calResultDatas.size());
        for (DynamicObject[] dataObj : calResultDatas) {
            long calPersonId = dataObj.getLong("id");
            if (calPersonId == 0L) continue;
            calPersonMap.put(calPersonId, dataObj);
        }
        DynamicObject[] itemDataArray = this.getSalaryDetailResultDatas(calResultIdMap, 0);
        if (itemDataArray != null && itemDataArray.length > 0) {
            for (DynamicObject calData : itemDataArray) {
                DynamicObjectCollection spEntryColl;
                int spSize;
                DynamicObjectCollection bsEntryColl;
                int bsSize;
                DynamicObjectCollection slEntryColl;
                int entrySize;
                DynamicObject calPersonObj;
                Long calResultId = calData.getLong("id");
                Long calPersonId = calResultIdMap.get(calResultId);
                if (calPersonId == null || SWCObjectUtils.isEmpty((Object)(calPersonObj = (DynamicObject)calPersonMap.get(calPersonId)))) continue;
                DynamicObjectCollection ftEntryColl = calData.getDynamicObjectCollection("hsas_calbcentry");
                int ftSize = ftEntryColl.size();
                if (ftSize > 0) {
                    this.buildFTData(ftEntryColl, calResultTplMap, calPersonObj);
                }
                if ((entrySize = (slEntryColl = calData.getDynamicObjectCollection("hsas_caltableentry")).size()) > 0) {
                    this.buildSLData(slEntryColl, calResultTplMap, calPersonObj, calCurrency);
                }
                if ((bsSize = (bsEntryColl = calData.getDynamicObjectCollection("hsas_calbsentry")).size()) > 0) {
                    this.buildBSData(bsEntryColl, calResultTplMap, calPersonObj, calCurrency);
                }
                if ((spSize = (spEntryColl = calData.getDynamicObjectCollection("hsas_calspentry")).size()) <= 0) continue;
                this.buildSPData(spEntryColl, calResultTplMap, calPersonObj);
            }
        }
        DynamicObject[] accSummaryColl = null;
        if (this.isExitAccItem(calResultTplMap)) {
            HashMap<Long, Map<String, Object>> calMap = new HashMap<Long, Map<String, Object>>(calResultTplMap.size());
            for (Map<String, Object> dataMap : calResultTplMap.values()) {
                Object idObj = dataMap.get("id");
                Long id = 0L;
                if (idObj instanceof Long) {
                    id = (Long)idObj;
                } else if (idObj instanceof Integer) {
                    id = Long.parseLong(String.valueOf(idObj));
                }
                if (id == null) continue;
                calMap.put(id, dataMap);
            }
            QFilter accFilter = new QFilter("caltask", "=", (Object)calTaskId);
            accSummaryColl = this.getAccProrationRowsData(new QFilter[]{accFilter}, 0);
            if (accSummaryColl != null && accSummaryColl.length > 0) {
                for (DynamicObject calData : accSummaryColl) {
                    DynamicObject calPersonObj;
                    Long calPersonId = calData.getLong("calpersonid");
                    if (calPersonId == null || calPersonId == 0L || SWCObjectUtils.isEmpty((Object)(calPersonObj = (DynamicObject)calPersonMap.get(calPersonId)))) continue;
                    this.buildAccData(calData, calMap, calPersonObj, calCurrency);
                }
            }
        }
    }

    public void addAccItemNewTotal(DynamicObject[] accSummaryColl, Map<String, Map<String, Object>> calResultTplMap, Map<String, BigDecimal> acTotalMap, int currentPage) {
        HashMap<Long, Map<String, Object>> accInfoMap = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry<String, Map<String, Object>> entry : calResultTplMap.entrySet()) {
            Map<String, Object> accItem;
            Long accId;
            String uniqueCode = entry.getKey();
            if (!uniqueCode.startsWith("AC_") || (accId = (Long)(accItem = entry.getValue()).get("id")) == null || accId == 0L) continue;
            accInfoMap.put(accId, accItem);
            String dataType = (String)accItem.get("dataType");
            if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) continue;
            acTotalMap.put(uniqueCode + '_' + currentPage, BigDecimal.ZERO);
        }
        for (DynamicObject dataObj : accSummaryColl) {
            Long accItemId;
            Map accItemInfo;
            Long calPersonId = dataObj.getLong("calpersonid");
            if (calPersonId == null || calPersonId == 0L || (accItemInfo = (Map)accInfoMap.get(accItemId = Long.valueOf(dataObj.getLong("accresult.acc.id")))) == null || accItemInfo.size() == 0) continue;
            String dataType = (String)accItemInfo.get("dataType");
            if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) continue;
            BigDecimal currentVal = dataObj.getBigDecimal("currentvalue");
            BigDecimal initVal = dataObj.getBigDecimal("initvalue");
            BigDecimal totalVal = currentVal.add(initVal);
            String uniqueCode = (String)accItemInfo.get("uniquecode");
            if (SWCStringUtils.isEmpty((String)uniqueCode)) continue;
            BigDecimal cacheVal = acTotalMap.get(uniqueCode + '_' + currentPage);
            cacheVal = cacheVal.add(totalVal);
            acTotalMap.put(uniqueCode + '_' + currentPage, cacheVal);
        }
    }

    public void addAccItemTotalToMap(Map<String, Object> totalMap, String fieldId, Map<String, Object> itemInfo, DynamicObject[] accSummaryColl, Map<String, Map<String, Object>> calResultTplMap, List<Map<String, Object>> dataList, Boolean isShowCurrency, DynamicObject currencyObj) {
        String dataType = (String)itemInfo.get("dataType");
        if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) {
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject dataObj : accSummaryColl) {
            Map<String, Object> calPersonObj;
            Long calPersonId = dataObj.getLong("calpersonid");
            if (calPersonId == null || calPersonId == 0L || SWCObjectUtils.isEmpty(calPersonObj = this.getCalPersonDynamicFromList(calPersonId, dataList))) continue;
            Long accItemId = dataObj.getLong("accresult.acc.id");
            Long id = (Long)itemInfo.get("id");
            if (id == null || accItemId.longValue() != id.longValue()) continue;
            BigDecimal currentVal = dataObj.getBigDecimal("currentvalue");
            BigDecimal initVal = dataObj.getBigDecimal("initvalue");
            BigDecimal totalVal = currentVal.add(initVal);
            totalAmount = totalAmount.add(totalVal);
        }
        String columnKey = fieldId.replace("_", "").toLowerCase();
        if (isShowCurrency.booleanValue()) {
            String currencySign = currencyObj.getString("sign");
            totalMap.put(columnKey + "_sign", currencySign);
        }
        totalMap.put(columnKey, totalAmount);
    }

    public void addBusinessItemTotalToMap(Map<String, Object> totalMap, String fieldId, Map<String, Object> itemInfo, DynamicObject[] itemDataArray, Boolean isShowCurrency, DynamicObject currencyObj) {
        String dataType = (String)itemInfo.get("dataType");
        if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) {
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject dataObj : itemDataArray) {
            DynamicObjectCollection bsEntryColl = dataObj.getDynamicObjectCollection("hsas_calbsentry");
            if (bsEntryColl == null || bsEntryColl.size() == 0) continue;
            Integer lastProrationIndex = null;
            BigDecimal lastValue = null;
            for (DynamicObject calData : bsEntryColl) {
                BigDecimal itemValue;
                String uniqueCode = calData.getString("bizitem.uniquecode");
                if (!SWCStringUtils.equals((String)uniqueCode, (String)fieldId)) continue;
                int prorationIndex = calData.getInt("bsprorationindex");
                if (lastProrationIndex != null && lastProrationIndex > prorationIndex) continue;
                lastProrationIndex = prorationIndex;
                if (lastValue != null) {
                    totalAmount = totalAmount.subtract(lastValue);
                }
                if ((itemValue = calData.getBigDecimal("bscalamountvalue")) == null) continue;
                totalAmount = totalAmount.add(itemValue);
                lastValue = itemValue;
            }
        }
        String columnKey = fieldId.replace("_", "").toLowerCase();
        if (isShowCurrency.booleanValue()) {
            String currencySign = currencyObj.getString("sign");
            totalMap.put(columnKey + "_sign", currencySign);
        }
        totalMap.put(columnKey, totalAmount);
    }

    public void addSlAndBsTotal(Map<String, Map<String, Object>> calResultTplMap, Map<Long, String> itemIdAndUniquecodeMap, Map<String, BigDecimal> slTotalMap, Map<String, BigDecimal> bsTotalMap, Map<String, BigDecimal> acTotalMap, Map<Long, Map<Long, Object>> slItemDataMap, Map<Long, Map<Long, Object>> bsItemDataMap, int currentPage) {
        BigDecimal totalVal;
        String uniqueCode;
        BigDecimal amountVal;
        Long itemId;
        Map<Object, Object> dataMap;
        for (Map.Entry<String, Map<String, Object>> entry : calResultTplMap.entrySet()) {
            String uniqueCode2 = entry.getKey();
            Map<String, Object> itemInfo = entry.getValue();
            String dataType = (String)itemInfo.get("dataType");
            if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) continue;
            if (uniqueCode2.startsWith("SL_") || uniqueCode2.startsWith("SI_")) {
                slTotalMap.put(uniqueCode2 + '_' + currentPage, BigDecimal.ZERO);
                continue;
            }
            if (!uniqueCode2.startsWith("BS_")) continue;
            bsTotalMap.put(uniqueCode2 + '_' + currentPage, BigDecimal.ZERO);
        }
        if (slItemDataMap != null && slItemDataMap.size() > 0) {
            for (Map.Entry<Object, Map<Object, Object>> entry : slItemDataMap.entrySet()) {
                dataMap = entry.getValue();
                for (Map.Entry<Object, Object> amountMap : dataMap.entrySet()) {
                    itemId = (Long)amountMap.getKey();
                    amountVal = (BigDecimal)amountMap.getValue();
                    uniqueCode = itemIdAndUniquecodeMap.get(itemId);
                    if (SWCStringUtils.isEmpty((String)uniqueCode)) continue;
                    totalVal = slTotalMap.get(uniqueCode + '_' + currentPage);
                    if (totalVal == null) {
                        totalVal = BigDecimal.ZERO;
                    }
                    if (amountVal != null) {
                        totalVal = totalVal.add(amountVal);
                    }
                    slTotalMap.put(uniqueCode + '_' + currentPage, totalVal);
                }
            }
        }
        if (bsItemDataMap != null && bsItemDataMap.size() > 0) {
            for (Map.Entry<Object, Map<Object, Object>> entry : bsItemDataMap.entrySet()) {
                dataMap = entry.getValue();
                for (Map.Entry<Object, Object> amountMap : dataMap.entrySet()) {
                    itemId = (Long)amountMap.getKey();
                    amountVal = (BigDecimal)amountMap.getValue();
                    uniqueCode = itemIdAndUniquecodeMap.get(itemId);
                    if (SWCStringUtils.isEmpty((String)uniqueCode)) continue;
                    totalVal = bsTotalMap.get(uniqueCode + '_' + currentPage);
                    if (totalVal == null) {
                        totalVal = BigDecimal.ZERO;
                    }
                    if (amountVal != null) {
                        totalVal = totalVal.add(amountVal);
                    }
                    bsTotalMap.put(uniqueCode + '_' + currentPage, totalVal);
                }
            }
        }
    }

    public void addItemTotal(Map<String, Map<String, Object>> calResultTplMap, Map<String, BigDecimal> slTotalMap, Map<String, BigDecimal> bsTotalMap, Map<String, BigDecimal> acTotalMap, DynamicObject[] itemDataArray, int currentPage) {
        for (Map.Entry<String, Map<String, Object>> entry : calResultTplMap.entrySet()) {
            String uniqueCode = entry.getKey();
            Map<String, Object> itemInfo = entry.getValue();
            String dataType = (String)itemInfo.get("dataType");
            if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) continue;
            if (uniqueCode.startsWith("SL_") || uniqueCode.startsWith("SI_")) {
                slTotalMap.put(uniqueCode + '_' + currentPage, BigDecimal.ZERO);
                continue;
            }
            if (!uniqueCode.startsWith("BS_")) continue;
            bsTotalMap.put(uniqueCode + '_' + currentPage, BigDecimal.ZERO);
        }
        for (DynamicObject dataObj : itemDataArray) {
            DynamicObjectCollection bsEntryColl;
            BigDecimal itemValue;
            BigDecimal totalVal;
            String dataType;
            String uniqueCode;
            Map<String, Object> itemInfo;
            DynamicObjectCollection slEntryColl = dataObj.getDynamicObjectCollection("hsas_caltableentry");
            if (slEntryColl != null && slEntryColl.size() > 0) {
                for (DynamicObject calData : slEntryColl) {
                    int prorationIndex = calData.getInt("slprorationindex");
                    if (prorationIndex != 0 || (itemInfo = calResultTplMap.get(uniqueCode = calData.getString("salaryitem.uniquecode"))) == null || itemInfo.size() <= 0) continue;
                    dataType = (String)itemInfo.get("dataType");
                    if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) continue;
                    totalVal = slTotalMap.get(uniqueCode + '_' + currentPage);
                    if (totalVal == null) {
                        totalVal = BigDecimal.ZERO;
                    }
                    if ((itemValue = calData.getBigDecimal("calamountvalue")) != null) {
                        totalVal = totalVal.add(itemValue);
                    }
                    slTotalMap.put(uniqueCode + '_' + currentPage, totalVal);
                }
            }
            if ((bsEntryColl = dataObj.getDynamicObjectCollection("hsas_calbsentry")) == null || bsEntryColl.size() <= 0) continue;
            for (DynamicObject calData : bsEntryColl) {
                uniqueCode = calData.getString("bizitem.uniquecode");
                itemInfo = calResultTplMap.get(uniqueCode);
                if (itemInfo == null || itemInfo.size() <= 0) continue;
                dataType = (String)itemInfo.get("dataType");
                if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) continue;
                totalVal = bsTotalMap.get(uniqueCode + '_' + currentPage);
                if (totalVal == null) {
                    totalVal = BigDecimal.ZERO;
                }
                if ((itemValue = calData.getBigDecimal("bscalamountvalue")) != null) {
                    totalVal = totalVal.add(itemValue);
                }
                bsTotalMap.put(uniqueCode + '_' + currentPage, totalVal);
            }
        }
    }

    public void addSalaryItemTotalToMap(Map<String, Object> totalMap, String fieldId, Map<String, Object> itemInfo, DynamicObject[] itemDataArray, Boolean isShowCurrency, DynamicObject currencyObj) {
        String dataType = (String)itemInfo.get("dataType");
        if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) {
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject dataObj : itemDataArray) {
            DynamicObjectCollection slEntryColl = dataObj.getDynamicObjectCollection("hsas_caltableentry");
            if (slEntryColl == null || slEntryColl.size() == 0) continue;
            for (DynamicObject calData : slEntryColl) {
                BigDecimal itemValue;
                String uniqueCode;
                int prorationIndex = calData.getInt("slprorationindex");
                if (prorationIndex != 0 || !SWCStringUtils.equals((String)(uniqueCode = calData.getString("salaryitem.uniquecode")), (String)fieldId) || (itemValue = calData.getBigDecimal("calamountvalue")) == null) continue;
                totalAmount = totalAmount.add(itemValue);
            }
        }
        String columnKey = fieldId.replace("_", "").toLowerCase();
        if (isShowCurrency.booleanValue()) {
            String currencySign = currencyObj.getString("sign");
            totalMap.put(columnKey + "_sign", currencySign);
        }
        totalMap.put(columnKey, totalAmount);
    }

    private void buildAccData(DynamicObject dataObj, Map<Long, Map<String, Object>> calMap, DynamicObject calPersonObj, DynamicObject calCurrency) {
        Map<String, Object> accTplMap;
        BigDecimal initVal;
        Long accItemId = dataObj.getLong("accresult.acc.id");
        BigDecimal currentVal = dataObj.getBigDecimal("currentvalue");
        BigDecimal totalVal = currentVal.add(initVal = dataObj.getBigDecimal("initvalue"));
        if (totalVal.compareTo(BigDecimal.ZERO) == 0) {
            totalVal = BigDecimal.ZERO;
        }
        if ((accTplMap = calMap.get(accItemId)) == null || accTplMap.size() == 0) {
            return;
        }
        String uniqueCode = (String)accTplMap.get("uniquecode");
        if (SWCStringUtils.isEmpty((String)uniqueCode)) {
            return;
        }
        String columnKey = uniqueCode.replace("_", "").toLowerCase();
        String dataType = (String)accTplMap.get("dataType");
        if (SWCStringUtils.equals((String)dataType, (String)"amount") || SWCStringUtils.equals((String)dataType, (String)"num")) {
            this.setBigDecimalVal(calPersonObj, columnKey, totalVal);
        }
    }

    private void buildCurrencyVal(DynamicObject calPersonObj, DynamicObject currencyObj, String currencyKey, Boolean showCurrency) {
        String currencyNum = currencyObj.getString("number");
        DynamicObject newObj = new DynamicObject(currencyObj.getDynamicObjectType());
        this.log.info("start to buildCurrencyVal!!");
        if (showCurrency != null && showCurrency.booleanValue()) {
            String currencySign = currencyObj.getString("sign");
            this.log.info("currencySign val is :{}", (Object)currencySign);
            newObj.set("sign", (Object)currencySign);
        }
        String amtprecision = currencyObj.getString("amtprecision");
        newObj.set("number", (Object)currencyNum);
        newObj.set("name", (Object)currencyObj.getString("sign"));
        newObj.set("amtprecision", (Object)amtprecision);
        calPersonObj.set(currencyKey, (Object)newObj);
    }

    private void buildAccDataToMap(DynamicObject dataObj, Map<Long, Map<String, Object>> calMap, Map<String, Object> calPersonObj, Boolean isShowCurrency, DynamicObject currencyObj) {
        Map<String, Object> accTplMap;
        BigDecimal initVal;
        Long accItemId = dataObj.getLong("accresult.acc.id");
        BigDecimal currentVal = dataObj.getBigDecimal("currentvalue");
        BigDecimal totalVal = currentVal.add(initVal = dataObj.getBigDecimal("initvalue"));
        if (totalVal.compareTo(BigDecimal.ZERO) == 0) {
            totalVal = BigDecimal.ZERO;
        }
        if ((accTplMap = calMap.get(accItemId)) == null || accTplMap.size() == 0) {
            return;
        }
        String uniqueCode = (String)accTplMap.get("uniquecode");
        String dataType = (String)accTplMap.get("dataType");
        if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            String currencySign;
            if (isShowCurrency.booleanValue() && SWCStringUtils.isNotEmpty((String)(currencySign = currencyObj.getString("sign")))) {
                calPersonObj.put(uniqueCode.replace("_", "").toLowerCase() + "_sign", currencySign);
            }
            this.setBigDecimalPlainString(totalVal, calPersonObj, uniqueCode);
        } else if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            this.setBigDecimalPlainString(totalVal, calPersonObj, uniqueCode);
        }
    }

    private DynamicObject[] getAccProrationRowsData(QFilter[] filters, int totalDataBitchSize) {
        String field = this.queryAccFields();
        this.log.info("step2-->accdataquery-start");
        long st = System.currentTimeMillis();
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        DynamicObject[] coll = null;
        try {
            coll = SWCMultithreadedQueryService.getInstance().getData("hsas_accdetails", field, filters, null, totalDataBitchSize == 0 ? 1000 : totalDataBitchSize);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        stopwatch.stop();
        this.log.info("\u7d2f\u52a0\u5668\u5217\u8868\u67e5\u8be2\u65f6\u957f:{}", (Object)stopwatch);
        if (coll == null) {
            coll = new DynamicObject[]{};
        }
        long ed = System.currentTimeMillis();
        this.log.info("step2-->accdataquery-end");
        this.log.info("query time:{}", (Object)(ed - st));
        return coll;
    }

    private String queryAccFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("currency.id,currency.number,currency.name,currency.amtprecision,initvalue,currentvalue,calpersonid,accresult.acc.id");
        return sb.toString();
    }

    private boolean isExitAccItem(Map<String, Map<String, Object>> calResultTplInfo) {
        for (String key : calResultTplInfo.keySet()) {
            if (!key.startsWith("AC_")) continue;
            return true;
        }
        return false;
    }

    private void buildSPData(DynamicObjectCollection spEntryColl, Map<String, Map<String, Object>> calResultTplMap, DynamicObject calPersonObj) {
        for (DynamicObject dataObj : spEntryColl) {
            String uniqueCode = dataObj.getString("supportitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode)) continue;
            String columnKey = uniqueCode.replace("_", "").toLowerCase();
            Map<String, Object> spMap = calResultTplMap.get(uniqueCode);
            String itemType = (String)spMap.get("dataType");
            if (SWCStringUtils.equals((String)itemType, (String)"text")) {
                String textVal = dataObj.getString("sptextvalue");
                calPersonObj.set(columnKey, (Object)textVal);
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"num")) {
                BigDecimal numVal = dataObj.getBigDecimal("spnumvalue");
                this.setBigDecimalVal(calPersonObj, columnKey, numVal);
                continue;
            }
            if (!SWCStringUtils.equals((String)itemType, (String)"date")) continue;
            Date dateVal = dataObj.getDate("spdatevalue");
            calPersonObj.set(columnKey, (Object)dateVal);
        }
    }

    private void buildSPDataToMap(DynamicObjectCollection spEntryColl, Map<String, Map<String, Object>> calResultTplMap, Map<String, Object> calPersonObj) {
        for (DynamicObject dataObj : spEntryColl) {
            String uniqueCode = dataObj.getString("supportitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode)) continue;
            String columnKey = uniqueCode.replace("_", "").toLowerCase();
            Map<String, Object> spMap = calResultTplMap.get(uniqueCode);
            String itemType = (String)spMap.get("dataType");
            if (SWCStringUtils.equals((String)itemType, (String)"text")) {
                String textVal = dataObj.getString("sptextvalue");
                calPersonObj.put(columnKey, textVal);
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"num")) {
                BigDecimal numVal = dataObj.getBigDecimal("spnumvalue");
                calPersonObj.put(columnKey, numVal == null ? "" : numVal.toPlainString());
                continue;
            }
            if (!SWCStringUtils.equals((String)itemType, (String)"date")) continue;
            Date dateVal = dataObj.getDate("spdatevalue");
            calPersonObj.put(columnKey, dateVal);
        }
    }

    private void buildBSData(DynamicObjectCollection bsEntryColl, Map<String, Map<String, Object>> calResultTplMap, DynamicObject calPersonObj, DynamicObject calCurrency) {
        HashMap<String, Integer> prorationIndexMap = new HashMap<String, Integer>(bsEntryColl.size());
        for (DynamicObject dataObj : bsEntryColl) {
            String uniqueCode = dataObj.getString("bizitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode)) continue;
            int prorationIndex = dataObj.getInt("bsprorationindex");
            Integer usedProrationIndex = (Integer)prorationIndexMap.get(uniqueCode);
            if (usedProrationIndex != null && usedProrationIndex > prorationIndex) continue;
            prorationIndexMap.put(uniqueCode, prorationIndex);
            String columnKey = uniqueCode.replace("_", "").toLowerCase();
            Map<String, Object> bsMap = calResultTplMap.get(uniqueCode);
            String itemType = (String)bsMap.get("dataType");
            if (SWCStringUtils.equals((String)itemType, (String)"text")) {
                String textVal = dataObj.getString("bstextvalue");
                calPersonObj.set(columnKey, (Object)textVal);
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"num")) {
                BigDecimal numVal = dataObj.getBigDecimal("bsnumvalue");
                this.setBigDecimalVal(calPersonObj, columnKey, numVal);
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"date")) {
                Date dateVal = dataObj.getDate("bsdatevalue");
                calPersonObj.set(columnKey, (Object)dateVal);
                continue;
            }
            if (!SWCStringUtils.equals((String)itemType, (String)"amount")) continue;
            BigDecimal itemValue = dataObj.getBigDecimal("bscalamountvalue");
            this.setBigDecimalVal(calPersonObj, columnKey, itemValue);
        }
    }

    private void buildBSDataToMap(DynamicObjectCollection bsEntryColl, Map<String, Map<String, Object>> calResultTplMap, Map<String, Object> calPersonObj, Boolean isShowCurrency, DynamicObject currencyObj) {
        HashMap<String, Integer> prorationIndexMap = new HashMap<String, Integer>(bsEntryColl.size());
        for (DynamicObject dataObj : bsEntryColl) {
            String uniqueCode = dataObj.getString("bizitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode)) continue;
            int prorationIndex = dataObj.getInt("bsprorationindex");
            Integer usedProrationIndex = (Integer)prorationIndexMap.get(uniqueCode);
            if (usedProrationIndex != null && usedProrationIndex > prorationIndex) continue;
            prorationIndexMap.put(uniqueCode, prorationIndex);
            String columnKey = uniqueCode.replace("_", "").toLowerCase();
            Map<String, Object> bsMap = calResultTplMap.get(uniqueCode);
            String itemType = (String)bsMap.get("dataType");
            if (SWCStringUtils.equals((String)itemType, (String)"text")) {
                String textVal = dataObj.getString("bstextvalue");
                calPersonObj.put(columnKey, textVal);
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"num")) {
                BigDecimal numVal = dataObj.getBigDecimal("bsnumvalue");
                calPersonObj.put(columnKey, numVal == null ? "" : numVal.toPlainString());
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"date")) {
                Date dateVal = dataObj.getDate("bsdatevalue");
                calPersonObj.put(columnKey, dateVal);
                continue;
            }
            if (!SWCStringUtils.equals((String)itemType, (String)"amount")) continue;
            if (isShowCurrency.booleanValue()) {
                String currencySign = currencyObj.getString("sign");
                calPersonObj.put(columnKey + "_sign", currencySign);
            }
            BigDecimal itemValue = null;
            itemValue = dataObj.getBigDecimal("bscalamountvalue");
            this.setBigDecimalPlainString(itemValue, calPersonObj, uniqueCode);
        }
    }

    private void buildSLData(DynamicObjectCollection slEntryColl, Map<String, Map<String, Object>> calResultTplMap, DynamicObject calPersonObj, DynamicObject calCurrency) {
        for (DynamicObject dataObj : slEntryColl) {
            int prorationIndex;
            String uniqueCode = dataObj.getString("salaryitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode) || (prorationIndex = dataObj.getInt("slprorationindex")) != 0) continue;
            String columKey = uniqueCode.replace("_", "").toLowerCase();
            Object itemValue = null;
            Map<String, Object> slMap = calResultTplMap.get(uniqueCode);
            String itemType = (String)slMap.get("dataType");
            if (itemType.equals("text")) {
                itemValue = dataObj.getString(SWCFieldType.TEXT.name().toLowerCase() + "value");
                calPersonObj.set(columKey, itemValue);
                continue;
            }
            if (itemType.equals("num")) {
                itemValue = dataObj.getBigDecimal(SWCFieldType.NUM.name().toLowerCase() + "value");
                if (BigDecimal.ZERO.compareTo((BigDecimal)itemValue) == 0) {
                    itemValue = dataObj.getBoolean("isnull") ? null : BigDecimal.ZERO;
                }
                this.setBigDecimalVal(calPersonObj, columKey, itemValue);
                continue;
            }
            if (itemType.equals("amount")) {
                itemValue = dataObj.getBigDecimal("calamountvalue");
                if (BigDecimal.ZERO.compareTo((BigDecimal)itemValue) == 0) {
                    itemValue = dataObj.getBoolean("isnull") ? null : BigDecimal.ZERO;
                }
                this.setBigDecimalVal(calPersonObj, columKey, itemValue);
                continue;
            }
            if (!itemType.equals("date")) continue;
            itemValue = dataObj.getDate(SWCFieldType.DATE.name().toLowerCase() + "value");
            calPersonObj.set(columKey, itemValue);
        }
    }

    private void buildSLDataToMap(DynamicObjectCollection slEntryColl, Map<String, Map<String, Object>> calResultTplMap, Map<String, Object> calPersonObj, Boolean isShowCurrency, DynamicObject currencyObj) {
        for (DynamicObject dataObj : slEntryColl) {
            int prorationIndex;
            String uniqueCode = dataObj.getString("salaryitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode) || (prorationIndex = dataObj.getInt("slprorationindex")) != 0) continue;
            String columKey = uniqueCode.replace("_", "").toLowerCase();
            Object itemValue = null;
            Map<String, Object> slMap = calResultTplMap.get(uniqueCode);
            String itemType = (String)slMap.get("dataType");
            if (itemType.equals("text")) {
                itemValue = dataObj.getString(SWCFieldType.TEXT.name().toLowerCase() + "value");
                calPersonObj.put(columKey, itemValue);
                continue;
            }
            if (itemType.equals("num")) {
                itemValue = dataObj.getBigDecimal(SWCFieldType.NUM.name().toLowerCase() + "value");
                if (BigDecimal.ZERO.compareTo((BigDecimal)itemValue) == 0) {
                    itemValue = dataObj.getBoolean("isnull") ? null : Integer.valueOf(0);
                }
                this.setBigDecimalPlainString(itemValue, calPersonObj, uniqueCode);
                continue;
            }
            if (itemType.equals("amount")) {
                itemValue = dataObj.getBigDecimal("calamountvalue");
                if (BigDecimal.ZERO.compareTo((BigDecimal)itemValue) == 0) {
                    itemValue = dataObj.getBoolean("isnull") ? null : Integer.valueOf(0);
                }
                if (isShowCurrency.booleanValue()) {
                    String currencySign = currencyObj.getString("sign");
                    calPersonObj.put(columKey + "_sign", currencySign);
                }
                this.setBigDecimalPlainString(itemValue, calPersonObj, uniqueCode);
                continue;
            }
            if (!itemType.equals("date")) continue;
            itemValue = dataObj.getDate(SWCFieldType.DATE.name().toLowerCase() + "value");
            calPersonObj.put(columKey, itemValue);
        }
    }

    private void buildFTData(DynamicObjectCollection ftEntryColl, Map<String, Map<String, Object>> calResultTplMap, DynamicObject calPersonObj) {
        HashMap<String, Integer> prorationIndexMap = new HashMap<String, Integer>(ftEntryColl.size());
        for (DynamicObject dataObj : ftEntryColl) {
            String uniqueCode = dataObj.getString("fetchitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode)) continue;
            int prorationIndex = dataObj.getInt("ftprorationindex");
            Integer usedProrationIndex = (Integer)prorationIndexMap.get(uniqueCode);
            if (usedProrationIndex != null && usedProrationIndex > prorationIndex) continue;
            prorationIndexMap.put(uniqueCode, prorationIndex);
            Map<String, Object> ftMap = calResultTplMap.get(uniqueCode);
            String columKey = uniqueCode.replace("_", "").toLowerCase();
            String itemType = (String)ftMap.get("dataType");
            if (SWCStringUtils.equals((String)itemType, (String)"text")) {
                String textVal = dataObj.getString("bctextvalue");
                calPersonObj.set(columKey, (Object)textVal);
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"num")) {
                long precision = dataObj.getLong("fetchitem.dataprecision.id");
                long dataRound = dataObj.getLong("fetchitem.dataround.id");
                BigDecimal numVal = precision > 0L && dataRound > 0L ? dataObj.getBigDecimal("bcnumvalue").setScale(ItemDataUtils.getScal((long)precision), ItemDataUtils.getRoundingMode((long)dataRound)) : dataObj.getBigDecimal("bcnumvalue");
                if (numVal == null) continue;
                calPersonObj.set(columKey, (Object)numVal);
                continue;
            }
            if (!SWCStringUtils.equals((String)itemType, (String)"date")) continue;
            Date dateVal = dataObj.getDate("bcdatevalue");
            calPersonObj.set(columKey, (Object)dateVal);
        }
    }

    private void buildFTDataToMap(DynamicObjectCollection ftEntryColl, Map<String, Map<String, Object>> calResultTplMap, Map<String, Object> calPersonMap) {
        HashMap<String, Integer> prorationIndexMap = new HashMap<String, Integer>(ftEntryColl.size());
        for (DynamicObject dataObj : ftEntryColl) {
            String uniqueCode = dataObj.getString("fetchitem.uniquecode");
            if (!calResultTplMap.containsKey(uniqueCode)) continue;
            int prorationIndex = dataObj.getInt("ftprorationindex");
            Integer usedProrationIndex = (Integer)prorationIndexMap.get(uniqueCode);
            if (usedProrationIndex != null && usedProrationIndex > prorationIndex) continue;
            prorationIndexMap.put(uniqueCode, prorationIndex);
            Map<String, Object> ftMap = calResultTplMap.get(uniqueCode);
            String columKey = uniqueCode.replace("_", "").toLowerCase();
            String itemType = (String)ftMap.get("dataType");
            if (SWCStringUtils.equals((String)itemType, (String)"text")) {
                String textVal = dataObj.getString("bctextvalue");
                calPersonMap.put(columKey, textVal);
                continue;
            }
            if (SWCStringUtils.equals((String)itemType, (String)"num")) {
                long precision = dataObj.getLong("fetchitem.dataprecision.id");
                long dataRound = dataObj.getLong("fetchitem.dataround.id");
                BigDecimal numVal = precision > 0L && dataRound > 0L ? dataObj.getBigDecimal("bcnumvalue").setScale(ItemDataUtils.getScal((long)precision), ItemDataUtils.getRoundingMode((long)dataRound)) : dataObj.getBigDecimal("bcnumvalue");
                calPersonMap.put(columKey, numVal == null ? BigDecimal.ZERO : numVal.toPlainString());
                continue;
            }
            if (!SWCStringUtils.equals((String)itemType, (String)"date")) continue;
            Date dateVal = dataObj.getDate("bcdatevalue");
            calPersonMap.put(columKey, dateVal);
        }
    }

    private void setBigDecimalVal(DynamicObject calPersonObj, String columKey, Object itemValue) {
        if (itemValue == null) {
            return;
        }
        if (itemValue instanceof BigDecimal) {
            calPersonObj.set(columKey, itemValue);
        } else {
            calPersonObj.set(columKey, (Object)new BigDecimal(itemValue.toString()));
        }
    }

    private Map<String, Object> getCalPersonDynamicFromList(Long calPersonId, List<Map<String, Object>> dataList) {
        for (Map<String, Object> dataMap : dataList) {
            Long id = (Long)dataMap.get("id");
            if (calPersonId == null || id.longValue() != calPersonId.longValue()) continue;
            return dataMap;
        }
        return null;
    }

    private DynamicObject[] getSalaryDetailResultDatas(Map<Long, Long> calResultIdMap, int totalDataBitchSize) {
        ArrayList<Long> calTableIdList = new ArrayList<Long>(calResultIdMap.size());
        for (Map.Entry<Long, Long> entry : calResultIdMap.entrySet()) {
            calTableIdList.add(entry.getKey());
        }
        QFilter filter = new QFilter("id", "in", calTableIdList);
        String field = this.queryFields();
        this.log.info("step2-->dataquery-start");
        long st = System.currentTimeMillis();
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        DynamicObject[] coll = null;
        try {
            coll = SWCMultithreadedQueryService.getInstance().getData("hsas_caltable", field, new QFilter[]{filter}, null, totalDataBitchSize == 0 ? 1000 : totalDataBitchSize);
            this.log.info("page query count:{}", (Object)(totalDataBitchSize == 0 ? 1000 : totalDataBitchSize));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        stopwatch.stop();
        this.log.info("\u6838\u7b97\u5217\u8868\u67e5\u8be2\u65f6\u957f:{}", (Object)stopwatch);
        if (coll == null) {
            coll = new DynamicObject[]{};
        }
        long ed = System.currentTimeMillis();
        this.log.info("step2-->dataquery-end");
        this.log.info("query time:{}", (Object)(ed - st));
        return coll;
    }

    private String queryFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("salaryitem.uniquecode,textvalue,numvalue,isnull,calamountvalue,datevalue,slprorationindex,");
        sb.append("bcproratetype,bctextvalue,bcnumvalue,bcdatevalue,fetchitem.uniquecode,ftprorationindex,fetchitem.dataprecision.id,fetchitem.dataround.id,");
        sb.append("bizitem.uniquecode,bsproratetype,bstextvalue,bsnumvalue,bsdatevalue,bscalamountvalue,bsoriamountvalue,bsoricurrency.number,bsoricurrency.name,bsprorationindex,");
        sb.append("supportitem.uniquecode,spproratetype,sptextvalue,spnumvalue,spdatevalue,spamountvalue");
        return sb.toString();
    }

    private Map<Long, Long> getCalResultIdList(List<Long> calPersonList) {
        HashMap<Long, Long> calResultMap = new HashMap<Long, Long>(calPersonList.size());
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonList);
        DynamicObject[] calResultIdArray = calPersonHelper.query("id,calresultid", new QFilter[]{filter});
        if (calResultIdArray == null || calResultIdArray.length == 0) {
            return calResultMap;
        }
        for (DynamicObject dynamicObject : calResultIdArray) {
            Long calResultId = dynamicObject.getLong("calresultid");
            if (SWCObjectUtils.isEmpty((Object)calResultId) || calResultId == 0L) continue;
            calResultMap.put(calResultId, dynamicObject.getLong("id"));
        }
        return calResultMap;
    }

    public List<Map<String, Object>> getExportData(QFilter[] filters, Map<String, Map<String, Object>> gridItemInfo, Long calTaskId, Map<String, String> calPersonInfo, Boolean isShowCurrency, DynamicObject currencyObj, int currentPage, int pageSize, Map<String, Object> totalValMap, String orderStr) {
        List<Map<String, Object>> exportData = this.queryExportData(filters, gridItemInfo, calTaskId, calPersonInfo, isShowCurrency, currencyObj, currentPage, pageSize, totalValMap, orderStr);
        return exportData;
    }

    private List<Map<String, Object>> queryExportData(QFilter[] filters, Map<String, Map<String, Object>> gridItemInfo, Long calTaskId, Map<String, String> calPersonInfo, Boolean isShowCurrency, DynamicObject currencyObj, int currentPage, int pageSize, Map<String, Object> totalValMap, String orderStr) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        SalaryDetailResultListHelper helper = new SalaryDetailResultListHelper();
        String fields = helper.buildCalPersonSql(calPersonInfo);
        this.log.info("calresult export data queryExportData is:{}", (Object)fields);
        String orderBy = "filenumber asc";
        if (SWCStringUtils.isNotEmpty((String)orderStr)) {
            orderBy = orderStr;
        }
        this.log.info("calresult export data order is:{}", (Object)orderBy);
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)fields, (QFilter[])filters, (String)orderBy, (int)currentPage, (int)pageSize);
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(10);
        int size = coll.length;
        HashMap<String, MainEntityType> mainEntityTypeMap = new HashMap<String, MainEntityType>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject dataObj = coll[i];
            LinkedHashMap<String, Long> valueMap = new LinkedHashMap<String, Long>(16);
            Long l = dataObj.getLong("id");
            valueMap.put("id", l);
            calPersonIdList.add(l);
            Map<String, String> fixCloum = helper.getFixedCloum();
            for (Map.Entry<String, String> entry : fixCloum.entrySet()) {
                String field = entry.getKey();
                Object object = this.getPrivacyValue(dataObj.get(field), field, mainEntityTypeMap, dataObj);
                valueMap.put(field, (Long)object);
            }
            long salaryFileVid = dataObj.getLong("salaryfilev.id");
            for (Map.Entry entry : calPersonInfo.entrySet()) {
                String field = (String)entry.getKey();
                if (fixCloum.containsKey(field)) continue;
                Object dataVal = dataObj.get(field);
                if (dataVal instanceof BigDecimal) {
                    DecimalFormat decimalFormat = new DecimalFormat("0.0#");
                    String strVal = decimalFormat.format(dataVal);
                    valueMap.put(field, (Long)((Object)new BigDecimal(strVal)));
                    continue;
                }
                String decodeKey = field;
                if (SWCStringUtils.equals((String)"salaryfilev.adminorg.name", (String)field)) {
                    if (salaryFileVid == 0L) {
                        decodeKey = "adminorg.name";
                        dataVal = dataObj.get(field);
                    }
                } else if (SWCStringUtils.equals((String)"salaryfilev.empgroup.name", (String)field) && salaryFileVid == 0L) {
                    decodeKey = "empgroup.name";
                    dataVal = dataObj.get("empgroup.name");
                }
                Object desensitizeValue = this.getPrivacyValue(dataVal, decodeKey, mainEntityTypeMap, dataObj);
                valueMap.put(field, (Long)desensitizeValue);
            }
            dataList.add((Map<String, Object>)valueMap);
        }
        Map<Long, Long> calResultIdMap = this.getCalResultIdList(calPersonIdList);
        if (calResultIdMap == null || calResultIdMap.size() == 0) {
            return dataList;
        }
        HashMap<Long, Map> dataListMap = new HashMap<Long, Map>(dataList.size());
        for (Map map : dataList) {
            Long id = (Long)map.get("id");
            if (id == null) continue;
            dataListMap.put(id, map);
        }
        long startTime = System.currentTimeMillis();
        DynamicObject[] itemDataArray = this.getSalaryDetailResultDatas(calResultIdMap, 0);
        long endTime = System.currentTimeMillis();
        if (itemDataArray != null && itemDataArray.length != 0) {
            startTime = System.currentTimeMillis();
            for (DynamicObject calData : itemDataArray) {
                DynamicObjectCollection spEntryColl;
                int spSize;
                DynamicObjectCollection bsEntryColl;
                int bsSize;
                DynamicObjectCollection slEntryColl;
                int entrySize;
                Map calPersonMap;
                Long calResultId = calData.getLong("id");
                Long calPersonId = calResultIdMap.get(calResultId);
                if (SWCObjectUtils.isEmpty((Object)calPersonId) || (calPersonMap = (Map)dataListMap.get(calPersonId)) == null || calPersonMap.size() == 0) continue;
                DynamicObjectCollection ftEntryColl = calData.getDynamicObjectCollection("hsas_calbcentry");
                int ftSize = ftEntryColl.size();
                if (ftSize > 0) {
                    this.buildFTDataToMap(ftEntryColl, gridItemInfo, calPersonMap);
                }
                if ((entrySize = (slEntryColl = calData.getDynamicObjectCollection("hsas_caltableentry")).size()) > 0) {
                    this.buildSLDataToMap(slEntryColl, gridItemInfo, calPersonMap, isShowCurrency, currencyObj);
                }
                if ((bsSize = (bsEntryColl = calData.getDynamicObjectCollection("hsas_calbsentry")).size()) > 0) {
                    this.buildBSDataToMap(bsEntryColl, gridItemInfo, calPersonMap, isShowCurrency, currencyObj);
                }
                if ((spSize = (spEntryColl = calData.getDynamicObjectCollection("hsas_calspentry")).size()) <= 0) continue;
                this.buildSPDataToMap(spEntryColl, gridItemInfo, calPersonMap);
            }
            endTime = System.currentTimeMillis();
        }
        DynamicObject[] accSummaryColl = null;
        if (this.isExitAccItem(gridItemInfo)) {
            HashMap<Long, Map<String, Object>> hashMap = new HashMap<Long, Map<String, Object>>(gridItemInfo.size());
            for (Map<String, Object> dataMap : gridItemInfo.values()) {
                Object idObj = dataMap.get("id");
                Long id = 0L;
                if (idObj instanceof Long) {
                    id = (Long)idObj;
                } else if (idObj instanceof Integer) {
                    id = Long.parseLong(String.valueOf(idObj));
                }
                if (id == null) continue;
                hashMap.put(id, dataMap);
            }
            QFilter accFilter = new QFilter("caltask", "=", (Object)calTaskId);
            startTime = System.currentTimeMillis();
            accSummaryColl = this.getAccProrationRowsData(new QFilter[]{accFilter}, 0);
            endTime = System.currentTimeMillis();
            if (accSummaryColl != null && accSummaryColl.length != 0) {
                startTime = System.currentTimeMillis();
                for (DynamicObject calData : accSummaryColl) {
                    Map calPersonObj;
                    Long calPersonId = calData.getLong("calpersonid");
                    if (calPersonId == null || calPersonId == 0L || (calPersonObj = (Map)dataListMap.get(calPersonId)) == null || calPersonObj.size() == 0) continue;
                    this.buildAccDataToMap(calData, hashMap, calPersonObj, isShowCurrency, currencyObj);
                }
                endTime = System.currentTimeMillis();
            }
        }
        this.addExportTotalRows(dataList, itemDataArray, accSummaryColl, gridItemInfo, isShowCurrency, currencyObj, totalValMap);
        return dataList;
    }

    private synchronized void addExportTotalRows(List<Map<String, Object>> dataList, DynamicObject[] itemDataArray, DynamicObject[] accSummaryColl, Map<String, Map<String, Object>> gridItemInfo, Boolean isShowCurrency, DynamicObject currencyObj, Map<String, Object> totalValMap) {
        HashMap<String, Object> totalMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, Map<String, Object>> entry : gridItemInfo.entrySet()) {
            String fieldId = entry.getKey();
            Map<String, Object> itemInfo = entry.getValue();
            if (fieldId.startsWith("SL_") || fieldId.startsWith("SI_")) {
                if (itemDataArray == null || itemDataArray.length <= 0) continue;
                this.addSalaryItemTotalToMap(totalMap, fieldId, itemInfo, itemDataArray, isShowCurrency, currencyObj);
                continue;
            }
            if (fieldId.startsWith("BS_")) {
                if (itemDataArray == null || itemDataArray.length <= 0) continue;
                this.addBusinessItemTotalToMap(totalMap, fieldId, itemInfo, itemDataArray, isShowCurrency, currencyObj);
                continue;
            }
            if (!fieldId.startsWith("AC_") || accSummaryColl == null || accSummaryColl.length <= 0) continue;
            this.addAccItemTotalToMap(totalMap, fieldId, itemInfo, accSummaryColl, gridItemInfo, dataList, isShowCurrency, currencyObj);
        }
        for (Map.Entry<String, Map<String, Object>> entry : totalMap.entrySet()) {
            BigDecimal totalVal;
            String key = entry.getKey();
            if (key.endsWith("_sign")) {
                String currencySign = currencyObj.getString("sign");
                totalValMap.put(key, currencySign);
                continue;
            }
            BigDecimal value = (BigDecimal)((Object)entry.getValue());
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            if ((totalVal = (BigDecimal)totalValMap.get(key)) == null) {
                totalVal = BigDecimal.ZERO;
            }
            totalVal = totalVal.add(value);
            totalValMap.put(key, totalVal);
        }
    }

    private Object getPrivacyValue(Object dataVal, String field, Map<String, MainEntityType> mainEntityTypeMap, DynamicObject dataObj) {
        Object desensitizeValue = dataVal;
        String privacyInfo = (String)SalaryFileExportConstants.PRIVACY_MAP.get(field);
        if (SWCStringUtils.isNotEmpty((String)privacyInfo)) {
            String[] privacyInfoArr = privacyInfo.split("\\.");
            String entityId = privacyInfoArr[0];
            String key = privacyInfoArr[1];
            MainEntityType mainEntityType = mainEntityTypeMap.get(entityId);
            if (mainEntityType == null) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                mainEntityTypeMap.put(entityId, mainEntityType);
            }
            IDataEntityProperty property = mainEntityType.findProperty(key);
            desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)dataObj, (Object)desensitizeValue);
        }
        return desensitizeValue;
    }

    public void setBigDecimalPlainString(Object itemValue, Map<String, Object> valueMap, String uniqueCode) {
        String cloumKey = uniqueCode.replace("_", "").toLowerCase();
        if (itemValue == null) {
            valueMap.put(cloumKey, "");
        } else if (itemValue instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)itemValue;
            if (bd.compareTo(BigDecimal.ZERO) == 0) {
                bd = BigDecimal.ZERO;
            }
            valueMap.put(cloumKey, bd.toPlainString());
        } else {
            valueMap.put(cloumKey, itemValue.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getAmountFieldTotalValueByCalResult(Long calTaskId, Map<String, Map<String, Object>> calResultTplMap, List<SummaryResult> summaryResultList, Boolean showCurrency) {
        int n;
        QFilter[] qFilters;
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        long startTime = System.currentTimeMillis();
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        long endTime = System.currentTimeMillis();
        this.log.info("getAuthorizedDataRuleQFilter use time:{}", (Object)(endTime - startTime));
        if (authorizedDataRuleQFilter == null || authorizedDataRuleQFilter.size() == 0) {
            qFilters = new QFilter[]{filter};
        } else {
            int size = authorizedDataRuleQFilter.size();
            qFilters = new QFilter[size + 1];
            for (int i = 0; i < size; ++i) {
                qFilters[i] = (QFilter)authorizedDataRuleQFilter.get(i);
            }
            qFilters[size] = filter;
        }
        SalaryDetailResultListHelper helper = new SalaryDetailResultListHelper();
        startTime = System.currentTimeMillis();
        DynamicObject taskInfo = helper.getTaskInfo(calTaskId);
        endTime = System.currentTimeMillis();
        this.log.info("query task info use time:{}", (Object)(endTime - startTime));
        DynamicObject calCurrency = taskInfo.getDynamicObject("payrollgroupv.currency");
        ConcurrentHashMap slTotalMap = new ConcurrentHashMap(16);
        ConcurrentHashMap bsTotalMap = new ConcurrentHashMap(16);
        ConcurrentHashMap acTotalMap = new ConcurrentHashMap(16);
        boolean isExistAccItem = this.isExitAccItem(calResultTplMap);
        HashMap<Long, String> itemIdAndUniquecodeMap = new HashMap<Long, String>(calResultTplMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : calResultTplMap.entrySet()) {
            String uniqueCode = entry.getKey();
            Map<String, Object> valMap = entry.getValue();
            Object itemId = 0L;
            Object object = valMap.get("id");
            itemId = object instanceof Integer ? Long.valueOf(Long.parseLong(String.valueOf(object))) : (Long)valMap.get("id");
            itemIdAndUniquecodeMap.put((Long)itemId, uniqueCode);
        }
        startTime = System.currentTimeMillis();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hsas_calperson", qFilters);
        endTime = System.currentTimeMillis();
        this.log.info("query total rownum use time:{}", (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        DynamicObject[] calPersonIdColl = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)"id", (QFilter[])qFilters, (String)"filenumber asc");
        this.calPersonIdArray = calPersonIdColl;
        endTime = System.currentTimeMillis();
        this.log.info("query all calperson id use time:{}", (Object)(endTime - startTime));
        ArrayList<void> slItemIdList = new ArrayList<void>(calResultTplMap.size());
        ArrayList<void> bsItemIdList = new ArrayList<void>(calResultTplMap.size());
        for (Map.Entry entry : calResultTplMap.entrySet()) {
            void var30_36;
            String key = (String)entry.getKey();
            Map itemInfo = (Map)entry.getValue();
            String dataType = (String)itemInfo.get("dataType");
            if (!SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) continue;
            Object itemIdObj = itemInfo.get("id");
            Long l = 0L;
            if (itemIdObj instanceof Integer) {
                Long l2 = Long.parseLong(String.valueOf(itemIdObj));
            } else {
                Long l3 = (Long)itemIdObj;
            }
            if (SWCStringUtils.startsWithIgnoreCase((String)key, (String)"SL_") || SWCStringUtils.startsWithIgnoreCase((String)key, (String)"SI_")) {
                slItemIdList.add(var30_36);
                continue;
            }
            if (!SWCStringUtils.startsWithIgnoreCase((String)key, (String)"BS_")) continue;
            bsItemIdList.add(var30_36);
        }
        int pageSize = this.getPageSizeByItem(slItemIdList.size() > bsItemIdList.size() ? slItemIdList.size() : bsItemIdList.size());
        if (pageSize == 0) {
            pageSize = this.getPageSizeByTotal(totalElements);
        }
        this.totalDataBitchSize = pageSize;
        this.totalPageCount = n = (int)Math.ceil((double)totalElements * 1.0 / (double)this.totalDataBitchSize);
        CountDownLatch countDownLatch = new CountDownLatch(n);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"CANCULATE_TOTAL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            int pageIndex = 0;
            while (pageIndex < this.totalPageCount) {
                int currentPage = pageIndex++;
                SWCThreadPoolFactory.getCalresultTotalThreadpool().execute(() -> {
                    try {
                        RequestContext.copyAndSet((RequestContext)ctx);
                        ArrayList<Long> calPersonIdList = new ArrayList<Long>(10);
                        if (currentPage != this.totalPageCount - 1) {
                            for (int i = currentPage * this.totalDataBitchSize; i < (currentPage + 1) * this.totalDataBitchSize; ++i) {
                                DynamicObject dataObj = this.calPersonIdArray[i];
                                Long id = dataObj.getLong("id");
                                calPersonIdList.add(id);
                            }
                        } else {
                            int size = this.calPersonIdArray.length;
                            for (int i = currentPage * this.totalDataBitchSize; i < size; ++i) {
                                DynamicObject dataObj = this.calPersonIdArray[i];
                                Long id = dataObj.getLong("id");
                                calPersonIdList.add(id);
                            }
                        }
                        Map<Long, Map<Long, Object>> slItemDataMap = null;
                        if (slItemIdList.size() > 0) {
                            long queryStartTime = System.currentTimeMillis();
                            slItemDataMap = new CalResultQueryHelper().getCalResult(calPersonIdList, SalaryItemTypeEnum.ITEMSL.getCode(), slItemIdList);
                            this.log.info("getCalResult sl item use time:{}", (Object)(System.currentTimeMillis() - queryStartTime));
                        }
                        Map<Long, Map<Long, Object>> bsItemDataMap = null;
                        if (bsItemIdList.size() > 0) {
                            long queryStartTime = System.currentTimeMillis();
                            bsItemDataMap = new CalResultQueryHelper().getCalResult(calPersonIdList, SalaryItemTypeEnum.ITEMBS.getCode(), bsItemIdList);
                            this.log.info("getCalResult bs item use time:{}", (Object)(System.currentTimeMillis() - queryStartTime));
                        }
                        DynamicObject[] accSummaryColl = null;
                        if (isExistAccItem) {
                            QFilter uniqueCodeFilter = this.filterAccByUniqueCode(calResultTplMap);
                            QFilter accFilter = new QFilter("caltask", "=", (Object)calTaskId);
                            if (uniqueCodeFilter != null) {
                                accFilter.and(uniqueCodeFilter);
                            }
                            accSummaryColl = this.getAccProrationRowsData(new QFilter[]{accFilter}, this.totalDataBitchSize);
                        }
                        this.addSlAndBsTotal(calResultTplMap, itemIdAndUniquecodeMap, slTotalMap, bsTotalMap, acTotalMap, slItemDataMap, bsItemDataMap, currentPage);
                        if (accSummaryColl != null) {
                            this.addAccItemNewTotal(accSummaryColl, calResultTplMap, acTotalMap, currentPage);
                        }
                    }
                    catch (Exception e) {
                        this.log.error("SalaryDetailResultListService.getAmountFieldTotalValue.error. ", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
        });
        try {
            if (countDownLatch.await(3L, TimeUnit.MINUTES)) {
                String key;
                String columnKey;
                BigDecimal value;
                startTime = System.currentTimeMillis();
                HashMap<String, BigDecimal> allSlMap = new HashMap<String, BigDecimal>(16);
                for (Map.Entry entry : slTotalMap.entrySet()) {
                    String key3 = (String)entry.getKey();
                    String columnKey3 = key3.substring(0, key3.lastIndexOf(95));
                    BigDecimal currentVal = (BigDecimal)allSlMap.get(columnKey3);
                    if (currentVal == null) {
                        currentVal = BigDecimal.ZERO;
                    }
                    if ((value = (BigDecimal)entry.getValue()) == null) {
                        value = BigDecimal.ZERO;
                    }
                    currentVal = currentVal.add(value);
                    allSlMap.put(columnKey3, currentVal);
                }
                for (Map.Entry entry : allSlMap.entrySet()) {
                    String key2 = (String)entry.getKey();
                    BigDecimal value2 = (BigDecimal)entry.getValue();
                    String columnKey2 = key2.replace("_", "").toLowerCase();
                    SummaryResult summaryResult = new SummaryResult(columnKey2, null, 1);
                    NumberPrecision numberPrecision = new NumberPrecision();
                    numberPrecision.setResult(value2);
                    Map<String, Object> itemInfo = calResultTplMap.get(key2);
                    int scale = (Integer)itemInfo.get("scale");
                    numberPrecision.setPrecision(scale);
                    String sign = calCurrency.getString("sign");
                    numberPrecision.setSign(sign);
                    boolean showSign = false;
                    if (showCurrency != null && showCurrency.booleanValue()) {
                        showSign = true;
                    }
                    numberPrecision.setShowSign(showSign);
                    summaryResult.setNumberPrecision(numberPrecision);
                    summaryResultList.add(summaryResult);
                }
                endTime = System.currentTimeMillis();
                this.log.info("get sl total data use time:{}", (Object)(endTime - startTime));
                startTime = System.currentTimeMillis();
                HashMap<String, BigDecimal> allBsMap = new HashMap<String, BigDecimal>(16);
                for (Map.Entry entry : bsTotalMap.entrySet()) {
                    BigDecimal value3;
                    String key2 = (String)entry.getKey();
                    String columnKey2 = key2.substring(0, key2.lastIndexOf(95));
                    BigDecimal currentVal = (BigDecimal)allBsMap.get(columnKey2);
                    if (currentVal == null) {
                        currentVal = BigDecimal.ZERO;
                    }
                    if ((value3 = (BigDecimal)entry.getValue()) == null) {
                        value3 = BigDecimal.ZERO;
                    }
                    currentVal = currentVal.add(value3);
                    allBsMap.put(columnKey2, currentVal);
                }
                for (Map.Entry entry : allBsMap.entrySet()) {
                    String key3 = (String)entry.getKey();
                    BigDecimal value4 = (BigDecimal)entry.getValue();
                    columnKey = key3.replace("_", "").toLowerCase();
                    SummaryResult summaryResult = new SummaryResult(columnKey, null, 1);
                    NumberPrecision numberPrecision = new NumberPrecision();
                    numberPrecision.setResult(value4);
                    Map<String, Object> itemInfo = calResultTplMap.get(key3);
                    int scale = (Integer)itemInfo.get("scale");
                    numberPrecision.setPrecision(scale);
                    String sign = calCurrency.getString("sign");
                    numberPrecision.setSign(sign);
                    boolean showSign = false;
                    if (showCurrency != null && showCurrency.booleanValue()) {
                        showSign = true;
                    }
                    numberPrecision.setShowSign(showSign);
                    summaryResult.setNumberPrecision(numberPrecision);
                    summaryResultList.add(summaryResult);
                }
                endTime = System.currentTimeMillis();
                this.log.info("get bs total data use time:{}", (Object)(endTime - startTime));
                startTime = System.currentTimeMillis();
                HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(16);
                for (Map.Entry entry : acTotalMap.entrySet()) {
                    BigDecimal value5;
                    key = (String)entry.getKey();
                    columnKey = key.substring(0, key.lastIndexOf(95));
                    BigDecimal currentVal = (BigDecimal)hashMap.get(columnKey);
                    if (currentVal == null) {
                        currentVal = BigDecimal.ZERO;
                    }
                    if ((value5 = (BigDecimal)entry.getValue()) == null) {
                        value5 = BigDecimal.ZERO;
                    }
                    currentVal = currentVal.add(value5);
                    hashMap.put(columnKey, currentVal);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    key = (String)entry.getKey();
                    value = (BigDecimal)entry.getValue();
                    String columnKey4 = key.replace("_", "").toLowerCase();
                    SummaryResult summaryResult = new SummaryResult(columnKey4, null, 1);
                    NumberPrecision numberPrecision = new NumberPrecision();
                    numberPrecision.setResult(value);
                    Map<String, Object> itemInfo = calResultTplMap.get(key);
                    int scale = (Integer)itemInfo.get("scale");
                    numberPrecision.setPrecision(scale);
                    String sign = calCurrency.getString("sign");
                    numberPrecision.setSign(sign);
                    boolean showSign = false;
                    if (showCurrency != null && showCurrency.booleanValue()) {
                        showSign = true;
                    }
                    numberPrecision.setShowSign(showSign);
                    summaryResult.setNumberPrecision(numberPrecision);
                    summaryResultList.add(summaryResult);
                }
                endTime = System.currentTimeMillis();
                this.log.info("get acc total data use time:{}", (Object)(endTime - startTime));
            }
        }
        catch (Exception e) {
            this.log.error("summaryResultList error:{}", (Object)e.getMessage());
        }
    }

    public void getAmountFieldTotalValue(Long calTaskId, Map<String, Map<String, Object>> calResultTplMap, List<SummaryResult> summaryResultList, Boolean showCurrency) {
        int totalPages;
        int pageSize;
        QFilter[] qFilters;
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        long startTime = System.currentTimeMillis();
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        long endTime = System.currentTimeMillis();
        this.log.info("getAuthorizedDataRuleQFilter use time:{}", (Object)(endTime - startTime));
        if (authorizedDataRuleQFilter == null || authorizedDataRuleQFilter.size() == 0) {
            qFilters = new QFilter[]{filter};
        } else {
            int size = authorizedDataRuleQFilter.size();
            qFilters = new QFilter[size + 1];
            for (int i = 0; i < size; ++i) {
                qFilters[i] = (QFilter)authorizedDataRuleQFilter.get(i);
            }
            qFilters[size] = filter;
        }
        SalaryDetailResultListHelper helper = new SalaryDetailResultListHelper();
        startTime = System.currentTimeMillis();
        DynamicObject taskInfo = helper.getTaskInfo(calTaskId);
        endTime = System.currentTimeMillis();
        this.log.info("query task info use time:{}", (Object)(endTime - startTime));
        DynamicObject calCurrency = taskInfo.getDynamicObject("payrollgroupv.currency");
        ConcurrentHashMap slTotalMap = new ConcurrentHashMap(16);
        ConcurrentHashMap bsTotalMap = new ConcurrentHashMap(16);
        ConcurrentHashMap acTotalMap = new ConcurrentHashMap(16);
        boolean isExistAccItem = this.isExitAccItem(calResultTplMap);
        startTime = System.currentTimeMillis();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hsas_calperson", qFilters);
        endTime = System.currentTimeMillis();
        this.log.info("query total rownum use time:{}", (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        DynamicObject[] calPersonIdColl = BusinessDataServiceHelper.load((String)"hsas_calperson", (String)"id", (QFilter[])qFilters, (String)"filenumber asc");
        this.calPersonIdArray = calPersonIdColl;
        endTime = System.currentTimeMillis();
        this.log.info("query all calperson id use time:{}", (Object)(endTime - startTime));
        this.totalDataBitchSize = pageSize = this.getPageSizeByTotal(totalElements);
        this.totalPageCount = totalPages = (int)Math.ceil((double)totalElements * 1.0 / (double)this.totalDataBitchSize);
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"CANCULATE_TOTAL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            int pageIndex = 0;
            while (pageIndex < this.totalPageCount) {
                int currentPage = pageIndex++;
                SWCThreadPoolFactory.getCalresultTotalThreadpool().execute(() -> {
                    try {
                        RequestContext.copyAndSet((RequestContext)ctx);
                        ArrayList<Long> calPersonIdList = new ArrayList<Long>(10);
                        if (currentPage != this.totalPageCount - 1) {
                            for (int i = currentPage * this.totalDataBitchSize; i < (currentPage + 1) * this.totalDataBitchSize; ++i) {
                                DynamicObject dataObj = this.calPersonIdArray[i];
                                Long id = dataObj.getLong("id");
                                calPersonIdList.add(id);
                            }
                        } else {
                            int size = this.calPersonIdArray.length;
                            for (int i = currentPage * this.totalDataBitchSize; i < size; ++i) {
                                DynamicObject dataObj = this.calPersonIdArray[i];
                                Long id = dataObj.getLong("id");
                                calPersonIdList.add(id);
                            }
                        }
                        long threadStartTime = System.currentTimeMillis();
                        Map<Long, Long> calResultIdMap = this.getCalResultIdList(calPersonIdList);
                        long threadEndTime = System.currentTimeMillis();
                        this.log.info("getCalResultIdList use time:{}", (Object)(threadEndTime - threadStartTime));
                        if (calResultIdMap == null || calResultIdMap.size() == 0) {
                            return;
                        }
                        DynamicObject[] itemDataArray = this.getSalaryDetailResultDatas(calResultIdMap, this.totalDataBitchSize);
                        threadStartTime = System.currentTimeMillis();
                        DynamicObject[] accSummaryColl = null;
                        if (isExistAccItem) {
                            QFilter uniqueCodeFilter = this.filterAccByUniqueCode(calResultTplMap);
                            QFilter accFilter = new QFilter("caltask", "=", (Object)calTaskId);
                            if (uniqueCodeFilter != null) {
                                accFilter.and(uniqueCodeFilter);
                            }
                            accSummaryColl = this.getAccProrationRowsData(new QFilter[]{accFilter}, this.totalDataBitchSize);
                        }
                        threadEndTime = System.currentTimeMillis();
                        this.log.info("query Acc item use time:{}", (Object)(threadEndTime - threadStartTime));
                        threadStartTime = System.currentTimeMillis();
                        this.addItemTotal(calResultTplMap, slTotalMap, bsTotalMap, acTotalMap, itemDataArray, currentPage);
                        threadEndTime = System.currentTimeMillis();
                        this.log.info("build sl and bs use time:{}", (Object)(threadEndTime - threadStartTime));
                        threadStartTime = System.currentTimeMillis();
                        this.addAccItemNewTotal(accSummaryColl, calResultTplMap, acTotalMap, currentPage);
                        threadEndTime = System.currentTimeMillis();
                        this.log.info("build acc new use time:{}", (Object)(threadEndTime - threadStartTime));
                    }
                    catch (Exception e) {
                        this.log.error("SalaryDetailResultListService.getAmountFieldTotalValue.error. ", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
        });
        try {
            if (countDownLatch.await(3L, TimeUnit.MINUTES)) {
                String key;
                String columnKey;
                BigDecimal value;
                startTime = System.currentTimeMillis();
                HashMap<String, BigDecimal> allSlMap = new HashMap<String, BigDecimal>(16);
                for (Map.Entry entry : slTotalMap.entrySet()) {
                    String key3 = (String)entry.getKey();
                    String columnKey3 = key3.substring(0, key3.lastIndexOf(95));
                    BigDecimal currentVal = (BigDecimal)allSlMap.get(columnKey3);
                    if (currentVal == null) {
                        currentVal = BigDecimal.ZERO;
                    }
                    if ((value = (BigDecimal)entry.getValue()) == null) {
                        value = BigDecimal.ZERO;
                    }
                    currentVal = currentVal.add(value);
                    allSlMap.put(columnKey3, currentVal);
                }
                for (Map.Entry entry : allSlMap.entrySet()) {
                    String key2 = (String)entry.getKey();
                    BigDecimal value2 = (BigDecimal)entry.getValue();
                    String columnKey2 = key2.replace("_", "").toLowerCase();
                    SummaryResult summaryResult = new SummaryResult(columnKey2, null, 1);
                    NumberPrecision numberPrecision = new NumberPrecision();
                    numberPrecision.setResult(value2);
                    Map<String, Object> itemInfo = calResultTplMap.get(key2);
                    int scale = (Integer)itemInfo.get("scale");
                    numberPrecision.setPrecision(scale);
                    String sign = calCurrency.getString("sign");
                    numberPrecision.setSign(sign);
                    boolean showSign = false;
                    if (showCurrency != null && showCurrency.booleanValue()) {
                        showSign = true;
                    }
                    numberPrecision.setShowSign(showSign);
                    summaryResult.setNumberPrecision(numberPrecision);
                    summaryResultList.add(summaryResult);
                }
                endTime = System.currentTimeMillis();
                this.log.info("get sl total data use time:{}", (Object)(endTime - startTime));
                startTime = System.currentTimeMillis();
                HashMap<String, BigDecimal> allBsMap = new HashMap<String, BigDecimal>(16);
                for (Map.Entry entry : bsTotalMap.entrySet()) {
                    BigDecimal value3;
                    String key2 = (String)entry.getKey();
                    String columnKey2 = key2.substring(0, key2.lastIndexOf(95));
                    BigDecimal currentVal = (BigDecimal)allBsMap.get(columnKey2);
                    if (currentVal == null) {
                        currentVal = BigDecimal.ZERO;
                    }
                    if ((value3 = (BigDecimal)entry.getValue()) == null) {
                        value3 = BigDecimal.ZERO;
                    }
                    currentVal = currentVal.add(value3);
                    allBsMap.put(columnKey2, currentVal);
                }
                for (Map.Entry entry : allBsMap.entrySet()) {
                    String key3 = (String)entry.getKey();
                    BigDecimal value4 = (BigDecimal)entry.getValue();
                    columnKey = key3.replace("_", "").toLowerCase();
                    SummaryResult summaryResult = new SummaryResult(columnKey, null, 1);
                    NumberPrecision numberPrecision = new NumberPrecision();
                    numberPrecision.setResult(value4);
                    Map<String, Object> itemInfo = calResultTplMap.get(key3);
                    int scale = (Integer)itemInfo.get("scale");
                    numberPrecision.setPrecision(scale);
                    String sign = calCurrency.getString("sign");
                    numberPrecision.setSign(sign);
                    boolean showSign = false;
                    if (showCurrency != null && showCurrency.booleanValue()) {
                        showSign = true;
                    }
                    numberPrecision.setShowSign(showSign);
                    summaryResult.setNumberPrecision(numberPrecision);
                    summaryResultList.add(summaryResult);
                }
                endTime = System.currentTimeMillis();
                this.log.info("get bs total data use time:{}", (Object)(endTime - startTime));
                startTime = System.currentTimeMillis();
                HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(16);
                for (Map.Entry entry : acTotalMap.entrySet()) {
                    BigDecimal value5;
                    key = (String)entry.getKey();
                    columnKey = key.substring(0, key.lastIndexOf(95));
                    BigDecimal currentVal = (BigDecimal)hashMap.get(columnKey);
                    if (currentVal == null) {
                        currentVal = BigDecimal.ZERO;
                    }
                    if ((value5 = (BigDecimal)entry.getValue()) == null) {
                        value5 = BigDecimal.ZERO;
                    }
                    currentVal = currentVal.add(value5);
                    hashMap.put(columnKey, currentVal);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    key = (String)entry.getKey();
                    value = (BigDecimal)entry.getValue();
                    String columnKey4 = key.replace("_", "").toLowerCase();
                    SummaryResult summaryResult = new SummaryResult(columnKey4, null, 1);
                    NumberPrecision numberPrecision = new NumberPrecision();
                    numberPrecision.setResult(value);
                    Map<String, Object> itemInfo = calResultTplMap.get(key);
                    int scale = (Integer)itemInfo.get("scale");
                    numberPrecision.setPrecision(scale);
                    String sign = calCurrency.getString("sign");
                    numberPrecision.setSign(sign);
                    boolean showSign = false;
                    if (showCurrency != null && showCurrency.booleanValue()) {
                        showSign = true;
                    }
                    numberPrecision.setShowSign(showSign);
                    summaryResult.setNumberPrecision(numberPrecision);
                    summaryResultList.add(summaryResult);
                }
                endTime = System.currentTimeMillis();
                this.log.info("get acc total data use time:{}", (Object)(endTime - startTime));
            }
        }
        catch (Exception e) {
            this.log.error("summaryResultList error:{}", (Object)e.getMessage());
        }
    }

    private int getPageSizeByTotal(int total) {
        if (total <= 2000) {
            return 100;
        }
        if (total > 2000 && total <= 5000) {
            return 200;
        }
        if (total > 5000 && total <= 10000) {
            return 500;
        }
        if (total > 10000 && total <= 20000) {
            return 1000;
        }
        if (total > 20000 && total <= 100000) {
            return 2000;
        }
        return 5000;
    }

    private int getPageSizeByItem(int itemCount) {
        if (itemCount > 0 && itemCount <= 50) {
            return 4000;
        }
        if (itemCount > 50 && itemCount <= 100) {
            return 2000;
        }
        if (itemCount > 100 && itemCount <= 150) {
            return 1200;
        }
        if (itemCount > 150 && itemCount <= 200) {
            return 1000;
        }
        if (itemCount > 200) {
            return 800;
        }
        return 0;
    }

    private QFilter filterAccByUniqueCode(Map<String, Map<String, Object>> calResultTplMap) {
        if (calResultTplMap == null || calResultTplMap.size() == 0) {
            return null;
        }
        ArrayList<String> uniqueCodeList = new ArrayList<String>(10);
        for (Map.Entry<String, Map<String, Object>> entry : calResultTplMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("AC_")) continue;
            uniqueCodeList.add(key);
        }
        if (uniqueCodeList != null && uniqueCodeList.size() > 0) {
            QFilter qFilter = new QFilter("accresult.acc.uniquecode", "in", uniqueCodeList);
            return qFilter;
        }
        return null;
    }
}

