/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class SalaryFileDBHelper {
    private static final Log LOG = LogFactory.getLog(SalaryFileDBHelper.class);

    private SalaryFileDBHelper() {
    }

    public static SalaryFileDBHelper getInstance() {
        return load.SALARY_FILE_DB;
    }

    public Map<String, List<Long>> queryRelatedSalaryFileDataBySalaryFileIds(final List<Long> salaryFileIds) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        sql.append(" SALARYFILE.FID salaryfileid,  PAYSETTING.FID paysettingid, SALARYSTRU.FID salarystruid, ITEMGRPCFG.FID itemgrpcfgid");
        sql.append(" FROM T_HSAS_SALARYFILE SALARYFILE");
        sql.append(" LEFT JOIN T_HSAS_PAYSETTING PAYSETTING ON PAYSETTING.FSALARYFILEID = SALARYFILE.FID  AND PAYSETTING.FISCURRENTVERSION  = '1' ");
        sql.append(" LEFT JOIN T_HSAS_SALARYSTRU SALARYSTRU ON SALARYSTRU.FSALARYFILEID = SALARYFILE.FID");
        sql.append(" LEFT JOIN T_HSAS_ITEMGRPCFG ITEMGRPCFG ON ITEMGRPCFG.FSALARYFILEID = SALARYFILE.FID  AND ITEMGRPCFG.FISCURRENTVERSION  = '1'");
        sql.append(" WHERE SALARYFILE.FID IN (?");
        int size = salaryFileIds.size();
        for (int i = 1; i < size; ++i) {
            sql.append(", ?");
        }
        sql.append(" )");
        ArrayList<Long> paramList = new ArrayList<Long>(10);
        paramList.addAll(salaryFileIds);
        Object[] params = paramList.toArray();
        Map datas = (Map)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, List<Long>>>(){

            public Map<String, List<Long>> handle(ResultSet rs) throws Exception {
                HashMap<String, List<Long>> datas = new HashMap<String, List<Long>>();
                ArrayList paySettingIds = new ArrayList(10);
                ArrayList salaryStruIds = new ArrayList(10);
                ArrayList itemgrpcfgIds = new ArrayList(10);
                while (rs.next()) {
                    SalaryFileDBHelper.this.addInputPkIdList(paySettingIds, "paysettingid", rs);
                    SalaryFileDBHelper.this.addInputPkIdList(salaryStruIds, "salarystruid", rs);
                    SalaryFileDBHelper.this.addInputPkIdList(itemgrpcfgIds, "itemgrpcfgid", rs);
                }
                SalaryFileDBHelper.this.inputIntoDatasMap("hsas_salaryfile", datas, salaryFileIds);
                SalaryFileDBHelper.this.inputIntoDatasMap("hsas_paysetting", datas, paySettingIds);
                SalaryFileDBHelper.this.inputIntoDatasMap("hsas_salarystru", datas, salaryStruIds);
                SalaryFileDBHelper.this.inputIntoDatasMap("hsas_itemgrpcfg", datas, itemgrpcfgIds);
                return datas;
            }
        });
        return datas;
    }

    public Map<String, Long> queryAllSalaryFileRelatedPkId(Long salaryFileId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(" PAYSETTING.FID paysettingid,  ITEMGRPCFG.FID itemgrpcfgid, EMPPOSORGREL.FID empposorgrelid ");
        sql.append(" FROM T_HSAS_SALARYFILE SALARYFILE");
        sql.append(" LEFT JOIN T_HSAS_PAYSETTING PAYSETTING ON PAYSETTING.FSALARYFILEID = SALARYFILE.FID  AND PAYSETTING.FISCURRENTVERSION  = '1' ");
        sql.append(" LEFT JOIN T_HSAS_ITEMGRPCFG ITEMGRPCFG ON ITEMGRPCFG.FSALARYFILEID = SALARYFILE.FID  AND ITEMGRPCFG.FISCURRENTVERSION  = '1' ");
        sql.append(" LEFT JOIN T_HSAS_EMPPOSORGREL EMPPOSORGREL ON EMPPOSORGREL.FSALARYFILEID = SALARYFILE.FBOID ");
        sql.append(" WHERE SALARYFILE.FID = ?");
        return (Map)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)sql.toString(), (Object[])new Object[]{salaryFileId}, (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                HashMap<String, Long> result = new HashMap<String, Long>();
                while (rs.next()) {
                    SalaryFileDBHelper.this.putValueIfNotEmpty(result, rs, "paysettingid", "hsas_paysetting");
                    SalaryFileDBHelper.this.putValueIfNotEmpty(result, rs, "itemgrpcfgid", "hsas_itemgrpcfg");
                    SalaryFileDBHelper.this.putValueIfNotEmpty(result, rs, "empposorgrelid", "hsas_empposorgrel");
                }
                return result;
            }
        });
    }

    private void putValueIfNotEmpty(Map<String, Long> result, ResultSet rs, String fieldKey, String mapKey) {
        try {
            if (null != rs.getObject(fieldKey)) {
                result.put(mapKey, rs.getLong(fieldKey));
            }
        }
        catch (SQLException e) {
            LOG.error((Throwable)e);
        }
    }

    private void addInputPkIdList(List<Long> pkIds, String dbFieldId, ResultSet rs) {
        try {
            if (null != rs.getObject(dbFieldId)) {
                pkIds.add(rs.getLong(dbFieldId));
            }
        }
        catch (SQLException e) {
            LOG.error((Throwable)e);
        }
    }

    private void inputIntoDatasMap(String entityId, Map<String, List<Long>> datas, List<Long> pkIds) {
        if (!pkIds.isEmpty()) {
            datas.put(entityId, pkIds);
        }
    }

    public DynamicObject validateSalaryfileUnique(Long personId, Long orgId, Long payRollGroupId, Long payRollRegionId, Long salaryFileId) {
        SWCDataServiceHelper salaryFileDataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter personFilter = new QFilter("employee.person.id", "=", (Object)personId);
        personFilter.and("id", "!=", (Object)salaryFileId);
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter payRollGroupFilter = new QFilter("payrollgroup.id", "=", (Object)payRollGroupId);
        QFilter payRollRegionFilter = new QFilter("payrollregion", "=", (Object)payRollRegionId);
        QFilter notAbandonFilter = new QFilter("status", "!=", (Object)"E");
        BaseDataHisHelper.addHisCurrFilter((QFilter)personFilter);
        DynamicObject[] dynamicObjects = salaryFileDataServiceHelper.query("empposinfo.empposinfo", new QFilter[]{personFilter, orgFilter, payRollGroupFilter, notAbandonFilter, payRollRegionFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        return dynamicObjects[0];
    }

    private static class load {
        private static SalaryFileDBHelper SALARY_FILE_DB = new SalaryFileDBHelper();

        private load() {
        }
    }
}

