/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.swc.hsas.business.salaryfile.ImportRowEntity;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryFileImportDataOperate {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileImportDataOperate.class);
    private static final String OPKEY = "donothing_import";
    private static final String OP_VALIDATE = "validate";
    private static final String SALARYFILE = "salaryfile";
    private static final String OP_FORMSAVE = "save";

    public static void validateImportData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger, ImportContext ctx) {
        List<ImportRowEntity> importableRowInfos = SalaryFileImportDataOperate.filterImportableData(mainEntityType, rowInfos, logger);
        ArrayList<DynamicObject> multiEntityDyobjRel = new ArrayList<DynamicObject>(importableRowInfos.size());
        String entityId = mainEntityType.getName();
        for (ImportRowEntity rowEntity : importableRowInfos) {
            DynamicObject entityDyobj = rowEntity.getEntityDyobj(entityId);
            multiEntityDyobjRel.add(entityDyobj);
        }
        HashMap<String, OperationResult> operationResults = new HashMap<String, OperationResult>();
        DynamicObject[] multiEntityDyobjRelArray = multiEntityDyobjRel.toArray(new DynamicObject[0]);
        if (multiEntityDyobjRelArray.length > 0) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("op", OP_VALIDATE);
            operateOption.setVariableValue("import", "1");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)OPKEY, (String)entityId, (DynamicObject[])multiEntityDyobjRelArray, (OperateOption)operateOption);
            operationResults.put(entityId, operationResult);
        }
        SalaryFileImportDataOperate.assembleErrorInfosDuringValidate(operationResults, importableRowInfos, logger);
    }

    public static void executeImportData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportContext ctx, ImportLogger logger) {
        LOGGER.info("SalaryFileImportDataOperate filterImportableData begin 1-1");
        List<ImportRowEntity> importableRowInfos = SalaryFileImportDataOperate.filterImportableData(mainEntityType, rowInfos, logger);
        LOGGER.info("SalaryFileImportDataOperate batchDealImportableData begin 1-2");
        SalaryFileImportDataOperate.batchDealImportableData(importableRowInfos, mainEntityType, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOp(String opName, DynamicObject importDy, ImportRowEntity rowEntity, ImportLogger logger, String status) {
        try (TXHandle txHandle = TX.required();){
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("opType", "insert");
            operateOption.setVariableValue("ignore_validator", "1");
            operateOption.setVariableValue("status", status);
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation(opName, new DynamicObject[]{importDy}, operateOption);
            SalaryFileImportDataOperate.dealOperationResult(importDy, operationResult, rowEntity, logger);
            txHandle.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchExecuteOp(String opName, List<DynamicObject> importDyList, Map<Long, ImportRowEntity> importRowEntityIdKeyMap, ImportLogger logger, String status) {
        try (TXHandle txHandle = TX.required();){
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("opType", "insert");
            operateOption.setVariableValue("ignore_validator", "1");
            operateOption.setVariableValue("status", status);
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation(opName, importDyList.toArray(new DynamicObject[importDyList.size()]), operateOption);
            SalaryFileImportDataOperate.batchDealOperationResult(operationResult, importRowEntityIdKeyMap, logger);
            txHandle.commit();
        }
    }

    public static List<ImportRowEntity> filterImportableData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger) {
        Set errorRowIndexs = logger.getLogCache().keySet();
        ArrayList<ImportRowEntity> importableRowInfos = new ArrayList<ImportRowEntity>();
        for (ImportRowEntity rowInfo : rowInfos) {
            if (errorRowIndexs.contains(rowInfo.getRowIndex())) continue;
            importableRowInfos.add(rowInfo);
        }
        return importableRowInfos;
    }

    private static void batchDealImportableData(List<ImportRowEntity> importableRowInfoList, MainEntityType mainEntityType, ImportLogger logger) {
        LOGGER.info("SalaryFileImportDataOperate fillData begin 1-1");
        if (CollectionUtils.isEmpty(importableRowInfoList)) {
            return;
        }
        String currEntity = mainEntityType.getName();
        Set<String> ignoreKeysSet = SalaryFileImportDataOperate.getIgnoreKeysSet();
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        HashMap<Long, ImportRowEntity> importRowEntityIdKeyMap = new HashMap<Long, ImportRowEntity>(16);
        ArrayList<DynamicObject> newHisDys = new ArrayList<DynamicObject>(10);
        ArrayList<ImportRowEntity> newHisImportRowEntity = new ArrayList<ImportRowEntity>(10);
        for (ImportRowEntity importableRowInfo : importableRowInfoList) {
            DynamicObject currEntityDyObj = importableRowInfo.getEntityDyobj(currEntity);
            DynamicObject salaryFileObj = currEntityDyObj.getDynamicObject(SALARYFILE);
            String salaryFileStatus = salaryFileObj.getString("status");
            String salaryFileNumber = salaryFileObj.getString("number");
            currEntityDyObj.set("status", (Object)salaryFileStatus);
            DynamicObject dbDynamicObj = importableRowInfo.getEntityDyobj(salaryFileNumber);
            if (dbDynamicObj == null) {
                needSaveList.add(currEntityDyObj);
                long currEntityDyId = currEntityDyObj.getLong("id");
                importRowEntityIdKeyMap.put(currEntityDyId, importableRowInfo);
                continue;
            }
            if ("A".equals(salaryFileStatus) || "B".equals(salaryFileStatus)) {
                SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)currEntityDyObj, (DynamicObject)dbDynamicObj, ignoreKeysSet, null);
                needSaveList.add(dbDynamicObj);
                long currEntityDyId = dbDynamicObj.getLong("id");
                importRowEntityIdKeyMap.put(currEntityDyId, importableRowInfo);
                continue;
            }
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(dbDynamicObj.getDataEntityType().getName());
            DynamicObject hisDyn = serviceHelper.generateEmptyDynamicObject();
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)dbDynamicObj, (DynamicObject)hisDyn, null, null);
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)currEntityDyObj, (DynamicObject)hisDyn, ignoreKeysSet, null);
            hisDyn.set("status", (Object)"C");
            hisDyn.set("boid", dbDynamicObj.get("id"));
            newHisDys.add(hisDyn);
            newHisImportRowEntity.add(importableRowInfo);
        }
        LOGGER.info("SalaryFileImportDataOperate batchExecuteOp begin 1-2");
        SalaryFileImportDataOperate.batchExecuteOp(OP_FORMSAVE, needSaveList, importRowEntityIdKeyMap, logger, null);
        LOGGER.info("SalaryFileImportDataOperate saveNoTimeVersion begin 1-3");
        HisResponse response = BaseDataHisHelper.saveNoTimeVersion((DynamicObject[])newHisDys.toArray(new DynamicObject[newHisDys.size()]), (boolean)true);
        LOGGER.info("SalaryFileImportDataOperate setLogInfoByResponse begin 1-4");
        SalaryFileImportDataOperate.setLogInfoByResponse(logger, newHisImportRowEntity, (HisResponse<VersionChangeRespData>)response);
        LOGGER.info("SalaryFileImportDataOperate getNeedUpdateList begin 1-5");
        List<Object> needUpdateList = SalaryFileImportDataOperate.getNeedUpdateList(needSaveList);
        LOGGER.info("SalaryFileImportDataOperate batchUpdateStatus begin 1-6");
        SalaryFileImportDataOperate.batchUpdateStatus(needSaveList, needUpdateList);
        LOGGER.info("SalaryFileImportDataOperate batchUpdateStatus end 1-7");
    }

    private static void setLogInfoByResponse(ImportLogger logger, List<ImportRowEntity> newHisImportRowEntity, HisResponse<VersionChangeRespData> response) {
        if (response != null && SWCStringUtils.isNotEmpty((String)response.getErrorMessage())) {
            for (ImportRowEntity rowEntity : newHisImportRowEntity) {
                SalaryFileImportDataOperate.log(rowEntity.getRowIndex(), response.getErrorMessage(), logger);
            }
        } else {
            List delRows = logger.getDelRows();
            for (ImportRowEntity importableRowInfo : newHisImportRowEntity) {
                delRows.add(new int[]{importableRowInfo.getRowIndex(), importableRowInfo.getEndRowIndex()});
                logger.setDelRows(delRows);
            }
        }
    }

    private static void batchUpdateStatus(List<DynamicObject> needSaveList, List<Object> needUpdateList) {
        if (CollectionUtils.isNotEmpty(needUpdateList) && CollectionUtils.isNotEmpty(needSaveList)) {
            DynamicObject[] currEntityDyObjNewArray;
            String entityName = needSaveList.get(0).getDataEntityType().getName();
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityName);
            QFilter qFilter = new QFilter("id", "in", needUpdateList);
            for (DynamicObject currEntityDyObjNew : currEntityDyObjNewArray = serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)entityName), new QFilter[]{qFilter})) {
                currEntityDyObjNew.set("status", (Object)"B");
            }
            serviceHelper.update(currEntityDyObjNewArray);
            LOGGER.info("SalaryFileImportDataOperate batchUpdateStatus begin 1-1");
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperateOption operateOption = OperateOption.create();
            OperationResult operationResult = opImpl.localInvokeOperation("audit", currEntityDyObjNewArray, operateOption);
            boolean is = operationResult.isSuccess();
            LOGGER.info("SalaryFileImportDataOperate batchUpdateStatus end 1-2");
            if (!is) {
                throw new KDBizException(operationResult.getMessage());
            }
        }
    }

    private static List<Object> getNeedUpdateList(List<DynamicObject> needSaveList) {
        ArrayList<Object> needUpdateList = new ArrayList<Object>(10);
        for (DynamicObject currEntityDyObj : needSaveList) {
            DynamicObject salaryFileObj = currEntityDyObj.getDynamicObject(SALARYFILE);
            String status = salaryFileObj.getString("status");
            if (!"C".equals(status)) continue;
            needUpdateList.add(currEntityDyObj.get("id"));
        }
        return needUpdateList;
    }

    private static Set<String> getIgnoreKeysSet() {
        HashSet keySet = Sets.newHashSetWithExpectedSize((int)6);
        return keySet;
    }

    private static void dealOperationResult(DynamicObject importDy, OperationResult operationResult, ImportRowEntity rowEntity, ImportLogger logger) {
        HashSet<String> errorMsgs = new HashSet<String>();
        if (operationResult.isSuccess()) {
            List delRows = logger.getDelRows();
            delRows.add(new int[]{rowEntity.getRowIndex(), rowEntity.getEndRowIndex()});
            logger.setDelRows(delRows);
        } else {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                errorMsgs.add(operateInfo.getMessage());
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
                errorMsgs.add(msg);
            }
            SalaryFileImportDataOperate.log(rowEntity.getRowIndex(), SalaryFileImportDataOperate.assembleErrorMsg(errorMsgs), logger);
        }
    }

    private static void batchDealOperationResult(OperationResult operationResult, Map<Long, ImportRowEntity> importRowEntityIdKeyMap, ImportLogger logger) {
        if (operationResult.isSuccess()) {
            List delRows = logger.getDelRows();
            List successPkIds = operationResult.getSuccessPkIds();
            for (Object pkIdObj : successPkIds) {
                ImportRowEntity rowEntity = importRowEntityIdKeyMap.get(Long.valueOf(String.valueOf(pkIdObj)));
                if (rowEntity == null) continue;
                delRows.add(new int[]{rowEntity.getRowIndex(), rowEntity.getEndRowIndex()});
                logger.setDelRows(delRows);
            }
        } else {
            HashSet<String> errorMsgs = new HashSet<String>(16);
            String msg = operationResult.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                errorMsgs.add(msg);
            }
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                Object pkValue = operateInfo.getPkValue();
                errorMsgs.add(operateInfo.getMessage());
                ImportRowEntity rowEntity = importRowEntityIdKeyMap.get(Long.valueOf(String.valueOf(pkValue)));
                if (rowEntity == null) continue;
                SalaryFileImportDataOperate.log(rowEntity.getRowIndex(), SalaryFileImportDataOperate.assembleErrorMsg(errorMsgs), logger);
            }
        }
    }

    private static void assembleErrorInfosDuringValidate(Map<String, OperationResult> operationResults, List<ImportRowEntity> rowInfos, ImportLogger importLogger) {
        for (Map.Entry<String, OperationResult> operationResultMap : operationResults.entrySet()) {
            String entityId = operationResultMap.getKey();
            OperationResult operationResult = operationResultMap.getValue();
            HashMap<String, Set<String>> opErrorInfos = new HashMap<String, Set<String>>();
            if (!operationResult.isSuccess()) {
                List operateInfos = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo operateInfo : operateInfos) {
                    String pkId = String.valueOf(operateInfo.getPkValue());
                    if (!opErrorInfos.containsKey(pkId)) {
                        TreeSet errorMsg = new TreeSet();
                        opErrorInfos.put(pkId, errorMsg);
                    }
                    ((Set)opErrorInfos.get(pkId)).add(operateInfo.getMessage());
                }
            }
            SalaryFileImportDataOperate.assembleErrorRowInfo(entityId, opErrorInfos, rowInfos, importLogger);
        }
    }

    private static String assembleErrorMsg(Set<String> errors) {
        return StringUtils.join((Object[])errors.toArray(), (String)";");
    }

    private static void assembleErrorRowInfo(String entityId, Map<String, Set<String>> opErrorInfos, List<ImportRowEntity> rowInfos, ImportLogger importLogger) {
        for (Map.Entry<String, Set<String>> opErrorInfosMap : opErrorInfos.entrySet()) {
            String entityPkId = opErrorInfosMap.getKey();
            Set<String> errorMsgs = opErrorInfosMap.getValue();
            for (ImportRowEntity rowInfo : rowInfos) {
                DynamicObject dyobj = rowInfo.getEntityDyobj(entityId);
                String originEntityPkId = dyobj.getString("id");
                if (!SWCStringUtils.equals((String)entityPkId, (String)originEntityPkId)) continue;
                SalaryFileImportDataOperate.log(rowInfo.getRowIndex(), SalaryFileImportDataOperate.assembleErrorMsg(errorMsgs), importLogger);
            }
        }
    }

    public static void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

