/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsas.business.openapi.salaryfile.model.request.SalaryFileQueryParamModel;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.DynamicTransformUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;

public class SalaryFileQueryServiceHelper {
    private static final Log LOG = LogFactory.getLog(SalaryFileQueryServiceHelper.class);
    private static final SWCDataServiceHelper FILE_HELPER = new SWCDataServiceHelper("hsas_salaryfile");
    private static final List<String> IGNOR_ELIST = Arrays.asList("enable", "simplename", "index", "issyspreset", "disabler", "disabledate", "boid", "iscurrentversion", "datastatus", "bred", "brled", "bsed", "bsled", "ismodify", "salaryfile", "addtaxfilecheckbox", "department", "emptype");
    private static final Long NOTEXISTSID = -999999999L;

    public static Map<String, Object> querySalaryFileBoByEmp(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SalaryFileQueryServiceHelper.validateParam(param, result);
            if (result.containsKey("success")) {
                return result;
            }
            List<Map<String, Object>> datas = SalaryFileQueryServiceHelper.queryFileBoByEmpCore(param);
            result.put("success", Boolean.TRUE);
            result.put("data", datas);
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...queryFile.error\uff1a", (Throwable)ex);
            result.put("success", Boolean.FALSE);
            result.put("message", ex.getMessage());
        }
        return result;
    }

    private static void validateParam(Map<String, Object> param, Map<String, Object> result) {
        try {
            if (!(param.get("employees") instanceof List) || ((List)param.get("employees")).size() == 0) {
                result.put("success", Boolean.FALSE);
                result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"SalaryFileQueryServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
                return;
            }
            List employees = (List)param.get("employees");
            ArrayList<Long> employeesNew = new ArrayList<Long>(10);
            for (Object empId : employees) {
                employeesNew.add(Long.parseLong(String.valueOf(empId)));
            }
            param.put("employees", employeesNew);
            List status = (List)param.get("status");
            String string = (String)param.get("selectProperties");
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...validateParam.error\uff1a", (Throwable)ex);
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"SalaryFileQueryServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
    }

    public static int queryFileBoCount(SalaryFileQueryParamModel queryParam) {
        Map<String, Object> param = SalaryFileQueryServiceHelper.transferQueryParamToMap(queryParam);
        QFilter fileIdFilter = SalaryFileQueryServiceHelper.buildQueryFileFilter(param);
        int count = FILE_HELPER.count(new QFilter[]{fileIdFilter});
        return count;
    }

    public static List<Map<String, Object>> queryFileBoDetail(SalaryFileQueryParamModel queryParam) {
        Map<String, Object> param = SalaryFileQueryServiceHelper.transferQueryParamToMap(queryParam);
        List<Map<String, Object>> list = SalaryFileQueryServiceHelper.queryFileBoByEmpCore(param);
        return list;
    }

    @NotNull
    private static Map<String, Object> transferQueryParamToMap(SalaryFileQueryParamModel queryParam) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        QFilter currFilter = BaseDataHisHelper.getHisCurrFilter();
        filterList.add(currFilter);
        Map orgMap = SWCBaseDataHelper.buildBaseDataIdAndNumberRelation((String)"bos_org", queryParam.getOrgnumbers(), null);
        ArrayList orgs = new ArrayList(orgMap.values());
        if (queryParam.getOrgnumbers() != null && queryParam.getOrgnumbers().size() >= 1) {
            orgs.add(NOTEXISTSID);
        }
        Map adminorgMap = SWCBaseDataHelper.buildBaseDataIdAndNumberRelation((String)"haos_adminorghr", queryParam.getAdminorgnumbers(), filterList);
        ArrayList adminorgs = new ArrayList(adminorgMap.values());
        if (queryParam.getAdminorgnumbers() != null && queryParam.getAdminorgnumbers().size() >= 1) {
            adminorgs.add(NOTEXISTSID);
        }
        Map payrollgroupMap = SWCBaseDataHelper.buildBaseDataIdAndNumberRelation((String)"hsas_payrollgrp", queryParam.getPayrollgroupnumbers(), filterList);
        ArrayList payrollgroups = new ArrayList(payrollgroupMap.values());
        if (queryParam.getPayrollgroupnumbers() != null && queryParam.getPayrollgroupnumbers().size() >= 1) {
            payrollgroups.add(NOTEXISTSID);
        }
        Map empMap = SWCBaseDataHelper.buildBaseDataIdAndNumberRelation((String)"hsas_employee", queryParam.getEmpnumbers(), filterList, (String)"empnumber");
        ArrayList employees = new ArrayList(empMap.values());
        if (queryParam.getEmpnumbers() != null && queryParam.getEmpnumbers().size() >= 1) {
            employees.add(NOTEXISTSID);
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("status", Arrays.asList("A", "B", "C"));
        param.put("employees", employees);
        param.put("orgs", orgs);
        param.put("adminorgs", adminorgs);
        param.put("payrollgroups", payrollgroups);
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        return param;
    }

    public static List<Map<String, Object>> queryFileBoByEmpCore(Map<String, Object> param) {
        String selectPropertiesOrg;
        QFilter fileIdFilter = SalaryFileQueryServiceHelper.buildQueryFileFilter(param);
        String selectProperties = SalaryFileQueryServiceHelper.buildSelectProperties(param);
        Integer pageIndex = 0;
        Object pageIndexObj = param.get("pageIndex");
        if (pageIndexObj instanceof Integer) {
            pageIndex = (Integer)pageIndexObj;
        }
        Integer pageSize = 10000;
        Object pageSizeObj = param.get("pageSize");
        if (pageSizeObj instanceof Integer) {
            pageSize = (Integer)pageSizeObj;
        }
        DynamicObject[] fileDys = BusinessDataServiceHelper.load((String)"hsas_salaryfile", (String)selectProperties, (QFilter[])new QFilter[]{fileIdFilter}, (String)"number", (int)pageIndex, (int)pageSize);
        HashSet<String> ignoreKey = new HashSet<String>(16);
        ignoreKey.addAll(IGNOR_ELIST);
        ArrayList<Map<String, Object>> fileMaps = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> needKeys = null;
        String string = selectPropertiesOrg = param.get("selectProperties") == null ? null : String.valueOf(param.get("selectProperties"));
        if (SWCStringUtils.isNotEmpty((String)selectPropertiesOrg)) {
            needKeys = new ArrayList<String>();
            needKeys.add("employee_id");
            needKeys.addAll(Arrays.asList(selectProperties.replace(" ", "").replace('.', '_').split(",")));
        }
        for (DynamicObject fileDy : fileDys) {
            Map fileMap = DynamicTransformUtil.dynamicObjectToMap((DynamicObject)fileDy, ignoreKey, needKeys);
            fileMaps.add(fileMap);
        }
        return fileMaps;
    }

    private static String buildSelectProperties(Map<String, Object> param) {
        String selectProperties;
        String string = selectProperties = param.get("selectProperties") == null ? null : String.valueOf(param.get("selectProperties"));
        if (selectProperties == null || "".equals(selectProperties)) {
            selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)FILE_HELPER.getEntityName());
        } else {
            if (!selectProperties.contains("employee.id")) {
                selectProperties = selectProperties + ",employee.id";
            }
            if (!selectProperties.contains("number")) {
                selectProperties = selectProperties + ",number";
            }
        }
        return selectProperties;
    }

    @NotNull
    private static QFilter buildQueryFileFilter(Map<String, Object> param) {
        ArrayList<String> status;
        QFilter fileIdFilter = BaseDataHisHelper.getHisCurrFilter();
        List orgs = (List)param.get("orgs");
        List adminorgs = (List)param.get("adminorgs");
        List payrollgroups = (List)param.get("payrollgroups");
        List employees = (List)param.get("employees");
        if (orgs != null && orgs.size() >= 1) {
            fileIdFilter.and("org.id", "in", (Object)orgs);
        }
        if (adminorgs != null && adminorgs.size() >= 1) {
            fileIdFilter.and("adminorg.id", "in", (Object)adminorgs);
        }
        if (payrollgroups != null && payrollgroups.size() >= 1) {
            fileIdFilter.and("payrollgroup.id", "in", (Object)payrollgroups);
        }
        if (employees != null && employees.size() >= 1) {
            fileIdFilter.and("employee.id", "in", (Object)employees);
        }
        ArrayList<String> arrayList = status = param.get("status") == null ? null : (ArrayList<String>)param.get("status");
        if (status == null) {
            status = new ArrayList<String>(1);
            status.add("C");
        }
        fileIdFilter.and("status", "in", status);
        return fileIdFilter;
    }
}

