/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileMatchExtService;
import kd.swc.hsas.business.dataport.SalaryFileMatchExtService;
import kd.swc.hsas.business.personchange.PersonChangeService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SalaryFileServiceHelper {
    private static final Log LOG = LogFactory.getLog(SalaryFileServiceHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MSG = "message";
    private static final String[] EXINCLUDE_FIELDS = new String[]{"person", "description", "name", "id", "empposinfo", "addtaxfilecheckbox", "managingscope", "isescrowstaff", "paystatus", "laborrelrecord"};

    public static void recycleSalaryFileNumber(String salaryFileNumber, Long employeeId) {
        SWCDataServiceHelper eserviceHelper = new SWCDataServiceHelper("hsas_employee");
        SalaryFileServiceHelper.recycleSalaryFileNumber(salaryFileNumber, eserviceHelper.queryOne((Object)employeeId));
    }

    public static void recycleSalaryFileNumber(String salaryFileNumber, DynamicObject employeeDy) {
        SWCDataServiceHelper fserviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject tmpDy = fserviceHelper.generateEmptyDynamicObject();
        tmpDy.set("employee", (Object)employeeDy);
        tmpDy.set("number", (Object)salaryFileNumber);
        CodeRuleServiceHelper.recycleNumber((String)"hsas_salaryfile", (DynamicObject)tmpDy, null, (String)tmpDy.getString("number"));
    }

    public static Map<String, Object> genPersonChangeForSalaryFile(List<DynamicObject> fileDys) {
        ArrayList<Map<String, Object>> genPersonParams = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Comparable<Long>> genPersonParam = null;
        for (DynamicObject dataEntity : fileDys) {
            Long changeReason = dataEntity.getLong("changereason.id");
            if (changeReason == 0L) continue;
            genPersonParam = new HashMap<String, Comparable<Long>>(16);
            genPersonParam.put("salaryFileId", Long.valueOf(dataEntity.getLong("boid")));
            genPersonParam.put("changeReasonId", changeReason);
            genPersonParam.put("changeDate", dataEntity.getDate("bsed"));
            genPersonParams.add(genPersonParam);
        }
        Map<String, Object> result = null;
        if (!genPersonParams.isEmpty()) {
            PersonChangeService personChangeService = new PersonChangeService();
            result = personChangeService.genPersonChangeForSalaryFile(genPersonParams);
        }
        return result;
    }

    public static Map<String, Object> syncSalaryFileExtField(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (result.containsKey(KEY_SUCCESS)) {
                return result;
            }
            Map<String, Object> datas = SalaryFileServiceHelper.syncSalaryFileExtFieldCore(param);
            result.put(KEY_SUCCESS, Boolean.TRUE);
            result.put("data", datas);
        }
        catch (Exception ex) {
            LOG.error("SalaryFileServiceHelper...syncSalaryFileExtField.error\uff1a", (Throwable)ex);
            result.put(KEY_SUCCESS, Boolean.FALSE);
            result.put(KEY_MSG, ex.getMessage());
        }
        return result;
    }

    private static Map<String, Object> syncSalaryFileExtFieldCore(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> presetDataMap = new HashMap<String, Object>();
        SalaryFileServiceHelper.dealSalaryFileExtField(param, presetDataMap);
        SalaryFileServiceHelper.dealCollaExtField(param, presetDataMap);
        result.put("presetDataMap", presetDataMap);
        return result;
    }

    public static void dealCollaExtField(Map<String, Object> param, Map<String, Object> presetDataMap) {
        String bizEntityNumber = String.valueOf(param.get("bizEntityNumber"));
        ArrayList<Long> setIds = new ArrayList<Long>(10);
        SWCDataServiceHelper collaSerHelper = new SWCDataServiceHelper("hsbs_triggercolla");
        QFilter filter = new QFilter("entityobject.number", "=", (Object)bizEntityNumber);
        filter.and("issyspreset", "=", (Object)Boolean.TRUE);
        DynamicObject collaDy = collaSerHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)collaSerHelper.getEntityName()), filter.toArray());
        if (collaDy == null) {
            return;
        }
        DynamicObjectCollection params = collaDy.getDynamicObjectCollection("paramentryentity");
        Map<String, DynamicObject> paramMap = params.stream().collect(Collectors.toMap(dy -> dy.getString("fieldkey"), dy -> dy, (v1, v2) -> v1));
        List fields = (List)param.get("data");
        for (Map field : fields) {
            String fieldkey = String.valueOf(field.get("number"));
            String type = String.valueOf(field.get("type"));
            Boolean isDelete = (Boolean)field.get("delete");
            if ("BasedataPropField".equals(type) || "MulBasedataField".equals(type) || "AttachmentPanelAp".equals(type) || "DateTimeField".equals(type)) continue;
            DynamicObject paramDB = paramMap.get(fieldkey);
            if (paramDB == null && !isDelete.booleanValue()) {
                DynamicObject newEntry = params.addNew();
                newEntry.set("fieldkey", (Object)fieldkey);
                newEntry.set("seq", (Object)params.size());
                newEntry.set("isentrysyspreset", (Object)"0");
            }
            if (paramDB == null || !isDelete.booleanValue()) continue;
            params.remove((Object)paramDB);
        }
        collaSerHelper.saveOne(collaDy);
        setIds.add(collaDy.getLong("id"));
        presetDataMap.put(collaSerHelper.getEntityName(), setIds);
    }

    private static void dealSalaryFileExtField(Map<String, Object> param, Map<String, Object> presetDataMap) {
        List fields;
        ArrayList setIds = new ArrayList(10);
        ArrayList<DynamicObject> waitSaveDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> waitModifyDys = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfileextfield");
        DynamicObject[] existsDyArr = serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)serviceHelper.getEntityName()), null);
        HashSet<String> existsField = new HashSet<String>(16);
        HashMap<String, DynamicObject> existsFieldMap = new HashMap<String, DynamicObject>(16);
        existsField.addAll(Arrays.asList(EXINCLUDE_FIELDS));
        HashMap<String, DynamicObject> waitDeleteDyMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dy : existsDyArr) {
            String fileKey = dy.getString("fieldkey").split("\\.")[0];
            existsField.add(fileKey);
            existsFieldMap.put(fileKey, dy);
            if (!"30".equals(dy.getString("source"))) continue;
            waitDeleteDyMap.put(fileKey, dy);
        }
        DynamicObject setLastDy = serviceHelper.queryOne("index", null, "index desc");
        int maxIndex = 1000;
        if (setLastDy != null) {
            maxIndex = setLastDy.getInt("index");
        }
        if ((fields = (List)param.get("data")) == null || fields.size() == 0) {
            return;
        }
        for (Map field : fields) {
            String fieldkey = String.valueOf(field.get("number"));
            String type = String.valueOf(field.get("type"));
            Boolean isDelete = (Boolean)field.get("delete");
            waitDeleteDyMap.remove(fieldkey);
            if ("BasedataPropField".equals(type) || "MulBasedataField".equals(type) || "AttachmentPanelAp".equals(type) || "DateTimeField".equals(type)) continue;
            if (!existsField.contains(fieldkey)) {
                DynamicObject setDy = serviceHelper.generateEmptyDynamicObject();
                if ("BasedataField".equals(type)) {
                    setDy.set("fieldkey", (Object)(fieldkey + ".number"));
                } else {
                    setDy.set("fieldkey", (Object)fieldkey);
                }
                setDy.set("fieldname", field.get("name"));
                setDy.set("isimport", (Object)"1");
                setDy.set("isexport", (Object)"1");
                setDy.set("source", (Object)"30");
                setDy.set("enable", (Object)"1");
                setDy.set("index", (Object)(++maxIndex));
                setDy.set("creator", (Object)RequestContext.get().getCurrUserId());
                waitSaveDys.add(setDy);
                continue;
            }
            DynamicObject fieldConfDy = (DynamicObject)existsFieldMap.get(fieldkey);
            if (fieldConfDy == null) continue;
            fieldConfDy.set("fieldname", field.get("name"));
            if (isDelete.booleanValue()) {
                fieldConfDy.set("enable", (Object)"0");
            }
            waitModifyDys.add(fieldConfDy);
        }
        for (DynamicObject dy : waitDeleteDyMap.values()) {
            if ("0".equals(dy.get("enable"))) continue;
            dy.set("enable", (Object)"0");
            waitModifyDys.add(dy);
        }
        serviceHelper.save(waitSaveDys.toArray(new DynamicObject[0]));
        serviceHelper.save(waitModifyDys.toArray(new DynamicObject[0]));
        waitSaveDys.forEach(o -> setIds.add(o.getLong("id")));
        waitModifyDys.forEach(o -> setIds.add(o.getLong("id")));
        presetDataMap.put(serviceHelper.getEntityName(), setIds);
    }

    public List<Map<String, Object>> matchSalaryFile(List<Map<String, Object>> params, Map<Long, DynamicObject> collectFileMap) {
        long currTime = System.currentTimeMillis();
        LOG.info("SalaryFileServiceHelper matchSalaryFile {} params is: {}", (Object)currTime, params);
        this.validateParam(params);
        List<Map<String, Object>> rightParams = this.filterRightParams(params);
        DynamicObject[] fileEmps = this.queryfileEmps(rightParams);
        HashMap<Long, Long> entryFileRlsMap = new HashMap<Long, Long>(16);
        Map<String, List<DynamicObject>> empEntMap = this.getFileMap(fileEmps, entryFileRlsMap);
        Map<Long, DynamicObject> fileMap = this.queryfileMap(entryFileRlsMap);
        List<DynamicObject> empEnts = null;
        LOG.info("SalaryFileServiceHelper matchSalaryFile start query!");
        for (Map<String, Object> param : rightParams) {
            String key = String.valueOf(param.get("depEmpId"));
            empEnts = empEntMap.get(key);
            if (empEnts == null) {
                LOG.info("SalaryFileServiceHelper matchSalaryFile empEnts is null");
                param.put("queryRowCount", 0);
                continue;
            }
            Long salaryFileId = (Long)param.get("salaryFileId");
            Long payrollGrpId = (Long)param.get("payrollGrpId");
            Date endDate = (Date)param.get("endDate");
            List status = (List)param.get("status");
            Long matchSalaryFileId = null;
            HashSet<Long> matchSalaryFileIds = new HashSet<Long>(10);
            HashSet<DynamicObject> matchSalaryFileVers = new HashSet<DynamicObject>(10);
            for (DynamicObject empEnt : empEnts) {
                Long salaryFileIdDB = (Long)entryFileRlsMap.get(empEnt.getLong("id"));
                DynamicObject fileDy = fileMap.get(salaryFileIdDB);
                if (fileDy == null) {
                    LOG.error("SalaryFileServiceHelper.matchSalaryFile error.params..{}", (Object)JSON.toJSONString(params));
                    LOG.error("SalaryFileServiceHelper.matchSalaryFile error.entryFileRlsMap..{}", (Object)JSON.toJSONString(entryFileRlsMap));
                    LOG.error("SalaryFileServiceHelper.matchSalaryFile error.salaryFileIdDB..{}", (Object)salaryFileIdDB);
                    continue;
                }
                Long payrollGrpIdDB = fileDy.getLong("payrollgroup.id");
                Date payEndDateDB = empEnt.getDate("payenddate");
                if (status != null && !status.isEmpty() && !status.contains(fileDy.getString("status"))) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile status match fail");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile status is: {}", (Object)status);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile fileDy getStatus: {}", (Object)fileDy.getString("status"));
                    continue;
                }
                if (salaryFileId != null && salaryFileId != 0L && !salaryFileIdDB.equals(salaryFileId)) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile salaryFileId is match null");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile salaryFileId value is: {}", (Object)salaryFileId);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile salaryFileIdDB value is: {}", (Object)salaryFileIdDB);
                    continue;
                }
                if (payrollGrpId != null && payrollGrpId != 0L && !payrollGrpIdDB.equals(payrollGrpId)) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile payrollGrpId not match success");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile payrollGrpId value is: {}", (Object)payrollGrpId);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile payrollGrpIdDB value is: {}", (Object)payrollGrpIdDB);
                    continue;
                }
                if (endDate != null && (payEndDateDB == null || endDate.after(payEndDateDB))) {
                    LOG.info("SalaryFileServiceHelper matchSalaryFile date match fail");
                    LOG.info("SalaryFileServiceHelper matchSalaryFile date endDate is: {}", (Object)endDate);
                    LOG.info("SalaryFileServiceHelper matchSalaryFile date payEndDateDB is: {}", (Object)payEndDateDB);
                    continue;
                }
                matchSalaryFileIds.add(salaryFileIdDB);
                matchSalaryFileVers.add(fileDy);
                if (matchSalaryFileIds.size() == 1) {
                    matchSalaryFileId = salaryFileIdDB;
                }
                if (endDate == null) continue;
                break;
            }
            param.put("queryRowCount", matchSalaryFileIds.size());
            param.put("matchSalaryFileId", matchSalaryFileId);
            param.put("matchSalaryFileIds", new ArrayList(matchSalaryFileIds));
            param.put("matchSalaryFileVers", new ArrayList(matchSalaryFileVers));
            if (collectFileMap == null) continue;
            collectFileMap.putAll(fileMap);
        }
        this.afterMatchSalaryFile(params);
        LOG.info("SalaryFileServiceHelper matchSalaryFile {} is end", (Object)currTime);
        return params;
    }

    private void afterMatchSalaryFile(List<Map<String, Object>> params) {
        SalaryFileMatchExtService iSalaryFileMatchExtService = new SalaryFileMatchExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileMatchExtService, ISalaryFileMatchExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileMatchExtService#afterMatchSalaryFile", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterMatchSalaryFile(params);
            return null;
        });
    }

    private void validateParam(List<Map<String, Object>> params) {
        String depEmpIdMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4ebaID\u201cdepEmpId\u201d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"SalaryFileServiceHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        String salaryFileIdMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848ID\uff08salaryFileId\uff09\u7c7b\u578b\u5e94\u4e3aLong\u3002", (String)"SalaryFileServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        String payrollGrpIdMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4ID\uff08payrollGrpId\uff09\u7c7b\u578b\u5e94\u4e3aLong\u3002", (String)"SalaryFileServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        String endDateMsg = ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u4e3a\u65e5\u671f\u7c7b\u578b\u3002", (String)"SalaryFileServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        String statusMsg = ResManager.loadKDString((String)"\u72b6\u6001\u201cstatus\u201d\u7c7b\u578b\u5e94\u4e3a\u201cList\u201d\u3002", (String)"SalaryFileServiceHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Map<String, Object> param : params) {
            Object status;
            Object depEmpId = param.get("depEmpId");
            if (depEmpId == null) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, depEmpIdMsg);
                continue;
            }
            Object salaryFileId = param.get("salaryFileId");
            if (salaryFileId != null && !(salaryFileId instanceof Long)) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, salaryFileIdMsg);
                continue;
            }
            Object payrollGrpId = param.get("payrollGrpId");
            if (payrollGrpId != null && !(payrollGrpId instanceof Long)) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, payrollGrpIdMsg);
                continue;
            }
            Object endDate = param.get("endDate");
            if (endDate != null && !(endDate instanceof Date)) {
                try {
                    Date endDateNew = SWCDateTimeUtils.parseDate((String)String.valueOf(endDate));
                    param.put("endDate", endDateNew);
                }
                catch (ParseException ex) {
                    LOG.error((Throwable)ex);
                    param.put(KEY_SUCCESS, Boolean.FALSE);
                    param.put(KEY_MSG, endDateMsg);
                    continue;
                }
            }
            if ((status = param.get("status")) == null || status instanceof List) continue;
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, statusMsg);
        }
    }

    private List<Map<String, Object>> filterRightParams(List<Map<String, Object>> params) {
        return params.stream().filter(param -> {
            Object success = param.get(KEY_SUCCESS);
            return success == null || (Boolean)success != false;
        }).collect(Collectors.toList());
    }

    public List<Map<String, Object>> matchSalaryFile(List<Map<String, Object>> params) {
        return this.matchSalaryFile(params, null);
    }

    private Map<Long, DynamicObject> queryfileMap(Map<Long, Long> entryFileRlsMap) {
        QFilter fileIdFilter = new QFilter("id", "in", entryFileRlsMap.values());
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] fileDys = fileHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), new QFilter[]{fileIdFilter});
        return Arrays.stream(fileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
    }

    private DynamicObject[] queryfileEmps(List<Map<String, Object>> params) {
        HashSet<String> status = new HashSet<String>(16);
        ArrayList<Long> depempList = new ArrayList<Long>(10);
        for (Map<String, Object> param : params) {
            depempList.add(Long.parseLong(String.valueOf(param.get("depEmpId"))));
            List statusTmp = (List)param.get("status");
            if (statusTmp != null) {
                status.addAll(statusTmp);
                continue;
            }
            status.add("C");
        }
        QFilter filterStatus = new QFilter("salaryfile.status", "in", status);
        QFilter filterDepemp = new QFilter("entryentity.workrole", "in", depempList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empposorgrel");
        return helper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_empposorgrel"), new QFilter[]{filterStatus, filterDepemp});
    }

    private Map<String, List<DynamicObject>> getFileMap(DynamicObject[] files, Map<Long, Long> entryFileRlsMap) {
        HashMap<String, List<DynamicObject>> fileMap = new HashMap<String, List<DynamicObject>>(10);
        ArrayList<DynamicObject> filesTemp = null;
        for (DynamicObject file : files) {
            DynamicObjectCollection entryentity = file.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                String key = entry.getString("workrole.id");
                filesTemp = (ArrayList<DynamicObject>)fileMap.get(key);
                if (filesTemp == null) {
                    filesTemp = new ArrayList<DynamicObject>(10);
                    fileMap.put(key, filesTemp);
                }
                filesTemp.add(entry);
                entryFileRlsMap.put(entry.getLong("id"), file.getLong("salaryfile.id"));
            }
        }
        for (List vals : fileMap.values()) {
            vals.sort((o1, o2) -> {
                if (o1 != null && o2 != null && o1.getDate("paystartdate") != null && o2.getDate("paystartdate") != null) {
                    return o1.getDate("paystartdate").compareTo(o2.getDate("paystartdate"));
                }
                return 1;
            });
        }
        return fileMap;
    }

    public List<Map<String, Object>> matchSalaryFileAndValidate(List<Map<String, Object>> params) {
        List<Map<String, Object>> matchSalaryFile = this.matchSalaryFile(params);
        return matchSalaryFile;
    }

    public Set<Long> filterSalaryFileById(Set<Long> idSet) {
        Set<Long> salaryFileIdSet = new HashSet<Long>(idSet.size());
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("id", "in", idSet);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObjectCollection coll = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (coll == null || coll.size() == 0) {
            return salaryFileIdSet;
        }
        salaryFileIdSet = coll.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        return salaryFileIdSet;
    }

    public Map<Long, Long> getSalaryFileIdAndOrgIdRelation(Set<Long> idSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection coll = helper.queryOriginalCollection("id,org", new QFilter[]{filter});
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(idSet.size());
        if (coll == null || coll.size() == 0) {
            return retMap;
        }
        for (DynamicObject dataObj : coll) {
            retMap.put(dataObj.getLong("id"), dataObj.getLong("org"));
        }
        return retMap;
    }

    public List<Map<String, Object>> matchSalaryFileByPerson(List<Map<String, Object>> params) {
        long startTime = System.currentTimeMillis();
        LOG.info("SalaryFileServiceHelper matchSalaryFileByPerson startTime is: {}, params is: {}", (Object)startTime, params);
        if (CollectionUtils.isEmpty(params)) {
            return params;
        }
        DynamicObject[] salaryFileArr = this.querySalaryFiles(params);
        Map<Long, List<DynamicObject>> sfMap = Arrays.stream(salaryFileArr).collect(Collectors.groupingBy(dy -> dy.getLong("employee.person.id")));
        for (Map<String, Object> param : params) {
            List matchSalaryFiles = (List)sfMap.getOrDefault(param.get("person"), new ArrayList(1)).clone();
            if (CollectionUtils.isEmpty((Collection)matchSalaryFiles)) {
                param.put("queryRowCount", 0);
                continue;
            }
            this.filterSalaryFiles(param, matchSalaryFiles, null);
            List matchSalaryFileIds = matchSalaryFiles.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            Long matchSalaryFileId = null;
            if (matchSalaryFileIds.size() == 1) {
                matchSalaryFileId = (Long)matchSalaryFileIds.get(0);
            }
            param.put("queryRowCount", matchSalaryFiles.size());
            param.put("matchSalaryFileId", matchSalaryFileId);
            param.put("matchSalaryFileIds", matchSalaryFileIds);
            param.put("matchSalaryFiles", matchSalaryFiles);
        }
        long endTime = System.currentTimeMillis();
        LOG.info("SalaryFileServiceHelper matchSalaryFileByPerson endTime is: {}, total cost time: {}", (Object)endTime, (Object)(endTime - startTime));
        return params;
    }

    private DynamicObject[] querySalaryFiles(List<Map<String, Object>> params) {
        HashSet<Long> personIds = new HashSet<Long>(params.size());
        HashSet<Long> payrollGrpIds = new HashSet<Long>(params.size());
        HashSet<String> status = new HashSet<String>(16);
        for (Map<String, Object> param : params) {
            personIds.add((Long)param.get("person"));
            payrollGrpIds.add((Long)param.get("payrollgrp"));
            List subStatus = (List)param.get("status");
            if (CollectionUtils.isNotEmpty((Collection)subStatus)) {
                status.addAll(subStatus);
                continue;
            }
            status.add("C");
        }
        QFilter statusFilter = new QFilter("status", "in", status);
        QFilter currentVerFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter payrollGrpFilter = new QFilter("payrollgroup", "in", payrollGrpIds);
        QFilter personFilter = new QFilter("employee.person.id", "in", personIds);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] salaryFiles = helper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile") + "employee.person.id", new QFilter[]{currentVerFilter, statusFilter, payrollGrpFilter, personFilter});
        return salaryFiles;
    }

    private void filterSalaryFiles(Map<String, Object> param, List<DynamicObject> salaryFiles, Map<Long, List<DynamicObject>> fileEmpMap) {
        Long payrollGrpId = (Long)param.get("payrollgrp");
        if (null == payrollGrpId) {
            salaryFiles.clear();
            return;
        }
        List status = (List)param.get("status");
        Iterator<DynamicObject> iterator = salaryFiles.iterator();
        while (iterator.hasNext()) {
            DynamicObject salaryFile = iterator.next();
            if (!payrollGrpId.equals(salaryFile.getLong("payrollgroup.id"))) {
                iterator.remove();
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)status) || status.contains(salaryFile.getString("status"))) continue;
            iterator.remove();
        }
    }
}

