/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileSubTableServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileSubTableServiceHelper.class);

    public static boolean verifyPermAndIsSelected(BeforeDoOperationEventArgs args, IFormView view, ListSelectedRowCollection selectIds, String listFormId) {
        boolean hasPerm = SalaryFileSubTableServiceHelper.checkPermission("4715a0df000000ac", listFormId);
        if (!hasPerm) {
            String errorTips = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SalaryFileSubTableServiceHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            view.showErrorNotification(errorTips);
            args.setCancel(true);
            return false;
        }
        if (selectIds == null || selectIds.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SalaryFileSubTableServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        int selectSize = 0;
        HashSet<Long> removeDuplicateSet = new HashSet<Long>();
        for (ListSelectedRow selectedRow : selectIds) {
            removeDuplicateSet.add(Long.valueOf(selectedRow.getPrimaryKeyValue().toString()));
        }
        selectSize = removeDuplicateSet.size();
        if (selectSize > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d\u5355\u6761\u8bb0\u5f55\u4fee\u6539\u3002", (String)"SalaryFileSubTableServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public static boolean verifyHisDataStatus(BeforeDoOperationEventArgs args, IFormView view, DynamicObject salaryfileSubObj) {
        if (salaryfileSubObj == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u53ef\u80fd\u88ab\u5220\u9664\u3002", (String)"SalaryFileSubTableServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        DynamicObject salaryfile = salaryfileSubObj.getDynamicObject("salaryfile");
        if (salaryfile == null) {
            String msg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalaryFileSubTableServiceHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
            view.showTipNotification(msg);
            args.setCancel(true);
            return false;
        }
        if ("E".equals(salaryfile.getString("status"))) {
            String msg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7{0}\uff1a\u8be5\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"SalaryFileSubTableServiceHelper_6", (String)"swc-hsas-business", (Object[])new Object[]{salaryfile.getString("number")});
            view.showTipNotification(msg);
            args.setCancel(true);
            return false;
        }
        String dataStatus = salaryfileSubObj.getString("datastatus");
        if ("-1".equals(dataStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u5e9f\u5f03\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"SalaryFileSubTableServiceHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public static boolean checkPermission(String permItemId, String entityName) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        return SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)entityName, (String)permItemId);
    }

    public static BaseShowParameter getBaseShowParameter(String pkId, String formId, DynamicObject salaryfileSubObj) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("hsas_itemgrpcfghis".equals(formId)) {
            parameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        parameter.setPkId((Object)pkId);
        parameter.setFormId(formId);
        String boId = salaryfileSubObj.getString("boid");
        String userId = SalaryFileSubTableServiceHelper.getDataMutexLockUserId(boId, SalaryFileSubTableServiceHelper.getCurrEntity(formId));
        if (!SWCStringUtils.isEmpty((String)userId)) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.setCustomParam("salaryfileid", (Object)salaryfileSubObj.getString("salaryfile.id"));
        parameter.setCustomParam("personid", (Object)salaryfileSubObj.getString("salaryfile.employee.id"));
        Long paySubjectId = salaryfileSubObj.getLong("salaryfile.payrollgroup.id");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        DynamicObject paySubjectObj = serviceHelper.queryOne("id,currency", (Object)paySubjectId);
        parameter.setCustomParam("currency", (Object)paySubjectObj.getString("currency.id"));
        parameter.setCustomParam("country", (Object)salaryfileSubObj.getString("salaryfile.payrollregion.id"));
        parameter.setCustomParam("org", (Object)salaryfileSubObj.getString("salaryfile.org.id"));
        parameter.setCustomParam("ismodify", (Object)Boolean.TRUE);
        return parameter;
    }

    public static String getCurrEntity(String modifyFormId) {
        if (modifyFormId.endsWith("_m")) {
            return modifyFormId.substring(0, modifyFormId.length() - 5);
        }
        return modifyFormId.substring(0, modifyFormId.length() - 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataMutexLockUserId(String boId, String entityId) {
        Map mutex = null;
        String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"modify");
        DataMutex dataMutex = DataMutex.create();
        try {
            mutex = dataMutex.getLockInfo(boId, groupId, entityId);
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
        }
        if (null != mutex && !mutex.isEmpty()) {
            return (String)mutex.get("userid");
        }
        return null;
    }
}

