/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.swc.hsas.business.bankoffer.vo.BaseDataConverter;
import kd.swc.hsas.common.enums.ResultStatusEnum;
import kd.swc.hsas.common.utils.BaseResult;
import kd.swc.hsas.common.utils.BatchResult;
import kd.swc.hsas.common.utils.HsasDateUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.DataStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryTaxFileRelServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SalaryTaxFileRelServiceHelper.class);
    public static final String SWC_HSAS_BUSINESS = "swc-hsas-business";
    public static final String HSAS_TAX_FILE_TMP = "hsas_taxfiletmp";
    public static final String HSAS_SALARY_TAX_FILE_REL = "hsas_salarytaxfilerel";
    public static final String ITC_TAX_FILE = "itc_taxfile";
    public static final int FAIL_REASON_CEIL_FOR_DEAL = 200;
    public static final int MAX_PUSH_TIMES = 10;
    public static final int MAX_MSG_LENGTH = 254;
    public static final String ITC_TAX_FILE_BSED = "bsed";
    public static final String ITC_TAX_FILE_BSLED = "bsled";
    public static final String SALARY_FILE_BSED = "bsed";
    public static final String SALARY_FILE_BSLED = "bsled";
    protected static final Date MIN_DATE = new Date(0L);
    protected static final Date MAX_DATE = new Date(Long.MAX_VALUE);

    public static DynamicObject copySalaryPropToTax(SWCDataServiceHelper dataServiceHelper, DynamicObject salaryModel, DynamicObject taxEntity, long salaryFileId, long taxFileTmpId) {
        long empId;
        DynamicObject taxFileTmp = dataServiceHelper.isExists((Object)taxFileTmpId) ? dataServiceHelper.loadSingle((Object)taxFileTmpId) : dataServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)taxEntity, (DynamicObject)taxFileTmp);
        taxFileTmp.set("id", (Object)taxFileTmpId);
        SWCDataServiceHelper perServiceHelper = new SWCDataServiceHelper("hrpi_person");
        DynamicObject person = perServiceHelper.generateDynamicObject(salaryModel.get("employee.person.id"), "id");
        taxFileTmp.set("person", (Object)person);
        if (salaryFileId != 0L && SWCObjectUtils.isEmpty((Object)taxFileTmp.get("salaryfile"))) {
            if ("hsas_salaryfile".equals(salaryModel.getDataEntityType().getName())) {
                taxFileTmp.set("salaryfile", (Object)salaryModel);
            } else {
                DynamicObject salaryFileEntity = dataServiceHelper.generateDynamicObject("hsas_salaryfile", (Object)salaryFileId, "id,empposinfo");
                salaryFileEntity.set("empposinfo", salaryModel.get("empposorgrel"));
                taxFileTmp.set("salaryfile", (Object)salaryFileEntity);
            }
        }
        if ((empId = taxFileTmp.getLong("salaryfile.empposinfo.id")) != 0L) {
            SWCDataServiceHelper empServiceHelper = new SWCDataServiceHelper("hrpi_empposorgrel");
            DynamicObject employment = empServiceHelper.generateDynamicObject(taxFileTmp.get("salaryfile.empposinfo.id"), "id");
            taxFileTmp.set("employment", (Object)employment);
        }
        taxFileTmp.set("pushcount", (Object)0);
        SalaryTaxFileRelServiceHelper.assignSystemFieldValue(taxFileTmp);
        return taxFileTmp;
    }

    public static BaseResult<DynamicObject> pushTaxFileToItc(DynamicObject taxEntity, int todoType) {
        DynamicObject data;
        BatchResult<DynamicObject> result = SalaryTaxFileRelServiceHelper.pushTaxFilesToItc(Collections.singletonList(taxEntity), "0", todoType + "");
        boolean success = true;
        List successResult = result.getSuccessResult();
        List failResult = result.getFailResult();
        if (CollectionUtils.isEmpty((Collection)successResult)) {
            success = false;
            data = (DynamicObject)failResult.get(0);
        } else {
            data = (DynamicObject)successResult.get(0);
        }
        String message = data.getString("failmsg");
        message = StringUtils.isEmpty((Object)message) ? result.getMessage() : message;
        BaseResult res = new BaseResult(success, (Object)data, message);
        return res.ofStatus(result.getStatus());
    }

    public static BatchResult<DynamicObject> pushTaxFilesToItc(List<DynamicObject> taxEntities, String actionWay, String action) {
        BatchResult res;
        ArrayList params = Lists.newArrayListWithCapacity((int)taxEntities.size());
        HashMap objMap = Maps.newHashMapWithExpectedSize((int)taxEntities.size());
        for (DynamicObject taxEntity : taxEntities) {
            params.add(SalaryTaxFileRelServiceHelper.convertTaxDynamicObjToMap(taxEntity));
            objMap.put(taxEntity.getLong("id"), taxEntity);
        }
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"saveTaxFiles", (Object[])new Object[]{params, actionWay, action});
        LOGGER.info("by cyh pushTaxFilesToItc result = " + result);
        Boolean success = BaseDataConverter.convert(result.get("success"), Boolean.class, Boolean.FALSE);
        LOGGER.info("by cyh pushTaxFilesToItc success = " + success + " result = " + result);
        if (!success.booleanValue()) {
            res = new BatchResult(false, taxEntities);
        } else {
            res = new BatchResult(true, (List)Lists.newArrayListWithCapacity((int)taxEntities.size()));
            List data = (List)result.get("data");
            for (Map datum : data) {
                DynamicObject object = (DynamicObject)objMap.get(datum.get("tmpid"));
                Long taxFileId = BaseDataConverter.convert(datum.get("id"), Long.class, 0L);
                Boolean successData = BaseDataConverter.convert(datum.get("success"), Boolean.class, Boolean.FALSE);
                LOGGER.info("by cyh pushTaxFilesToItc taxFileId = " + taxFileId + "object = " + object);
                if (successData == null || !successData.booleanValue()) {
                    SalaryTaxFileRelServiceHelper.packageDefaultFailInfo(datum, object);
                    res.addFailItem((Object)object, MapUtils.getString((Map)datum, (Object)"message"));
                    continue;
                }
                object.set("taxfile", (Object)taxFileId);
                res.addSuccessItem((Object)object);
            }
            LOGGER.info("by cyh pushTaxFilesToItc objMap = " + objMap);
        }
        Integer status = BaseDataConverter.convert(result.get("status"), Integer.class, 200);
        return res.ofMessage(String.valueOf(result.get("message"))).ofStatus(status.intValue());
    }

    public static Map<Long, DynamicObject> findTaxFiles(long regionId, List<Long> taxFileIds, Set<String> props, boolean isShowStopTax, boolean useHis) {
        if (props == null) {
            props = Sets.newHashSet((Object[])new String[]{"id"});
        } else {
            props.add((String)"id");
        }
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"findTaxFiles", (Object[])new Object[]{regionId, taxFileIds, props, isShowStopTax, useHis});
        return SalaryTaxFileRelServiceHelper.packageTaxFileFromApi(result, props).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e, (k1, k2) -> k1));
    }

    public static List<DynamicObject> findTaxFilesOfPerson(long regionId, long personId, Set<String> props, Set<Long> excludeTaxFileIds) {
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"findTaxFilesOfPerson", (Object[])new Object[]{regionId, personId, props, Boolean.TRUE, excludeTaxFileIds});
        return SalaryTaxFileRelServiceHelper.packageTaxFileFromApi(result, props);
    }

    public static Map<String, Object> convertTaxDynamicObjToMap(DynamicObject taxEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>(32);
        map.put("number", taxEntity.get("number"));
        map.put("person", taxEntity.get("person"));
        map.put("org", taxEntity.get("org"));
        map.put("taxregion", taxEntity.get("taxregion"));
        map.put("empgroup", taxEntity.get("empgroup"));
        map.put("taxunit", taxEntity.get("taxunit"));
        map.put("employment", taxEntity.get("employment"));
        map.put("salaryfileid", taxEntity.get("salaryfile.id"));
        map.put("bsed", taxEntity.get("bsed"));
        map.put("isescrowstaff", taxEntity.get("isescrowstaff"));
        map.put("tmpid", taxEntity.get("id"));
        map.put("taxpayertype", taxEntity.get("taxpayertype"));
        map.put("emptype", taxEntity.get("emptype"));
        map.put("empdate", taxEntity.get("empdate"));
        map.put("empsituation", taxEntity.get("empsituation"));
        map.put("isdeductexps", taxEntity.get("isdeductexps") == null ? Boolean.TRUE : taxEntity.get("isdeductexps"));
        map.put("creator", taxEntity.get("creator"));
        map.put("createtime", taxEntity.get("createtime"));
        map.put("modifier", taxEntity.get("modifier"));
        map.put("modifytime", taxEntity.get("modifytime"));
        return map;
    }

    public static void dealSuccessRecords(SWCDataServiceHelper tempDataServiceHelper, List<DynamicObject> successResult) {
        SWCDataServiceHelper relDataServiceHelper = new SWCDataServiceHelper(HSAS_SALARY_TAX_FILE_REL);
        Object[] pkIds = new Object[successResult.size()];
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(pkIds.length);
        for (int i = 0; i < pkIds.length; ++i) {
            DynamicObject taxEntity = successResult.get(i);
            pkIds[i] = taxEntity.get("id");
            relations.add(SalaryTaxFileRelServiceHelper.convertTaxFileTempToRel(relDataServiceHelper, taxEntity));
        }
        try {
            relDataServiceHelper.save(relations.toArray(new DynamicObject[0]));
            tempDataServiceHelper.delete(pkIds);
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when relate salary and tax files", (Throwable)e);
        }
    }

    public static void packageDefaultFailInfo(Map<String, Object> res, DynamicObject taxEntity) {
        taxEntity.set("pushcount", (Object)(taxEntity.getInt("pushcount") + 1));
        String message = MapUtils.getString(res, (Object)"message", (String)ResManager.loadKDString((String)"\u7f51\u7edc\u8d85\u65f6", (String)"SalaryFileTaxAddNewPlugin_9", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
        if (message.length() > 254) {
            message = message.substring(0, 254);
        }
        taxEntity.set("failmsg", (Object)message);
        taxEntity.set("failreason", (Object)MapUtils.getInteger(res, (Object)"status", (Integer)0));
    }

    private static DynamicObject convertTaxFileTempToRel(SWCDataServiceHelper relDataServiceHelper, DynamicObject taxEntity) {
        QFilter taxFileId = new QFilter("taxfile", "=", taxEntity.get("taxfile"));
        QFilter salaryFileId = new QFilter("salaryfile.id", "=", taxEntity.get("salaryfile.id"));
        DynamicObject relEntity = relDataServiceHelper.queryOne("id", new QFilter[]{taxFileId, salaryFileId});
        if (relEntity != null) {
            return relEntity;
        }
        relEntity = relDataServiceHelper.generateEmptyDynamicObject();
        relEntity.set("creator", taxEntity.get("creator"));
        relEntity.set("createtime", (Object)new Date());
        relEntity.set("modifier", taxEntity.get("modifier"));
        relEntity.set("modifytime", (Object)new Date());
        relEntity.set("status", (Object)"C");
        relEntity.set("person", taxEntity.get("person"));
        relEntity.set("salaryfile", taxEntity.get("salaryfile"));
        relEntity.set("taxfile", taxEntity.get("taxfile"));
        return relEntity;
    }

    public static Map<String, Object> saveOrUpdateSalaryTaxFileRel(Map<String, Object> cond, boolean fromTax) {
        Long salaryFile = MapUtils.getLong(cond, (Object)"salaryFile");
        Long taxFile = MapUtils.getLong(cond, (Object)"taxFile");
        Long oldRelId = MapUtils.getLong(cond, (Object)"oldRelId");
        if (SWCObjectUtils.isEmpty((Object)salaryFile) || SWCObjectUtils.isEmpty((Object)taxFile)) {
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5b8c\u6574\u3002", (String)"HSASService_03", (String)"swc-hsas-mservice", (Object[])new Object[0]);
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)msg, null);
        }
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject salaryFileObj = salaryFileHelper.queryOne("id,bsed,bsled,payrollregion,employee.person.id,boid", (Object)salaryFile);
        if (salaryFileObj == null) {
            String msg = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u53c2\u6570\u9519\u8bef\u3002", (String)"HSASService_04", (String)"swc-hsas-mservice", (Object[])new Object[0]);
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)msg, null);
        }
        return SalaryTaxFileRelServiceHelper.saveOrUpdateSalaryTaxFileRel(taxFile, salaryFileObj, salaryFileObj.getDynamicObject("employee.person"), oldRelId, fromTax).toMap(false);
    }

    public static BaseResult<?> relateSalaryWithTaxFile(Long taxFile, Long salaryFile, Long oldRelId) {
        List data = Lists.newArrayListWithExpectedSize((int)1);
        Map item = Maps.newHashMapWithExpectedSize((int)4);
        item.put("taxFileId", taxFile);
        item.put("salaryFileId", salaryFile);
        item.put("oldRelId", oldRelId);
        data.add(item);
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        param.put("data", data);
        Map<String, Object> map = SalaryTaxFileRelServiceHelper.relateSalaryWithTaxFile(param);
        boolean success = MapUtils.getBooleanValue(map, (Object)"success", (boolean)true);
        if (!success) {
            return BaseResult.fail((String)MapUtils.getString(map, (Object)"message"));
        }
        data = (List)map.get("data");
        if (CollectionUtils.isEmpty((Collection)data)) {
            return BaseResult.success((Object)item);
        }
        item = (Map)data.get(0);
        success = MapUtils.getBooleanValue((Map)item, (Object)"success", (boolean)true);
        if (!success) {
            return BaseResult.fail((String)MapUtils.getString((Map)item, (Object)"message"));
        }
        return BaseResult.success((Object)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> relateSalaryWithTaxFile(Map<String, Object> params) {
        String paramNotComplete = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5b8c\u6574\u3002", (String)"SalaryTaxFileRelServiceHelper_11", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        if (params == null) {
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)paramNotComplete, null);
        }
        List data = (List)params.get("data");
        if (data == null) {
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)paramNotComplete, null);
        }
        ArrayList successParams = Lists.newArrayListWithCapacity((int)data.size());
        ArrayList failParams = Lists.newArrayListWithCapacity((int)data.size());
        HashSet salaryFileIds = Sets.newHashSetWithExpectedSize((int)data.size());
        for (Map datum : data) {
            Long salaryFile = MapUtils.getLong((Map)datum, (Object)"salaryFileId");
            Long taxFile = MapUtils.getLong((Map)datum, (Object)"taxFileId");
            if (salaryFile == null || salaryFile == 0L || taxFile == null || taxFile == 0L) {
                HashMap failItem = Maps.newHashMap((Map)datum);
                failItem.put("message", paramNotComplete);
                failItem.put("success", Boolean.FALSE);
                continue;
            }
            successParams.add(Maps.newHashMap((Map)datum));
            salaryFileIds.add(salaryFile);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        if (CollectionUtils.isEmpty((Collection)successParams)) {
            result.put("data", failParams);
            return result;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hsas_salaryfile");
        QFilter idFilter = new QFilter("boid", "in", (Object)salaryFileIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "not in", (Object)new String[]{DataStatusEnum.DELETE.getCode(), "-1"});
        Object[] salaryFiles = serviceHelper.query("id,boid,number,payrollregion.id,employee.person.id,employee.person.name,bsed,bsled,paystatus,iscurrentversion,status", new QFilter[]{idFilter, dataStatusFilter});
        String salaryFileNotExist = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u4e0d\u5b58\u5728\u3002", (String)"SalaryTaxFileRelServiceHelper_12", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        if (ArrayUtils.isEmpty((Object[])salaryFiles)) {
            for (Map param : successParams) {
                param.put("message", salaryFileNotExist);
                param.put("success", Boolean.FALSE);
            }
            failParams.addAll(successParams);
            result.put("data", failParams);
            return result;
        }
        HashMap taxFileIds = Maps.newHashMapWithExpectedSize((int)data.size());
        Map<Long, List<DynamicObject>> salaryFilesGroupByBoId = Arrays.stream(salaryFiles).collect(Collectors.groupingBy(e -> e.getLong("boid")));
        String salaryFileAbd = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458{0}\u7684\u85aa\u8d44\u6863\u6848\u4e3a\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"SalaryTaxFileRelServiceHelper_13", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        Iterator iterator = successParams.iterator();
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            Long salaryFile = MapUtils.getLong((Map)next, (Object)"salaryFileId");
            List<DynamicObject> list = salaryFilesGroupByBoId.get(salaryFile);
            if (CollectionUtils.isEmpty(list)) {
                iterator.remove();
                next.put("success", Boolean.FALSE);
                next.put("message", salaryFileNotExist);
                failParams.add(next);
                continue;
            }
            if (SalaryTaxFileRelServiceHelper.isSalaryFileAbandon(list)) {
                iterator.remove();
                next.put("success", Boolean.FALSE);
                next.put("message", MessageFormat.format(salaryFileAbd, list.get(0).getString("employee.person.name")));
                failParams.add(next);
                continue;
            }
            Long taxFile = MapUtils.getLong((Map)next, (Object)"taxFileId");
            taxFileIds.put(taxFile, list.get(0).getLong("payrollregion.id"));
            next.put("personId", list.get(0).getLong("employee.person.id"));
        }
        if (CollectionUtils.isEmpty((Collection)successParams)) {
            result.put("data", failParams);
            return result;
        }
        ArrayList iitParamsData = Lists.newArrayListWithExpectedSize((int)taxFileIds.size());
        for (Map.Entry entry : taxFileIds.entrySet()) {
            LinkedHashMap item = Maps.newLinkedHashMapWithExpectedSize((int)2);
            item.put("taxFileId", entry.getKey());
            item.put("regionId", entry.getValue());
            iitParamsData.add(item);
        }
        HashMap iitParams = Maps.newHashMapWithExpectedSize((int)2);
        iitParams.put("data", iitParamsData);
        iitParams.put("props", Sets.newHashSet((Object[])new String[]{"id", "boid", "number", "person.id", "bsed", "bsled", "status", "taxstatus"}));
        iitParams.put("useHis", 0);
        iitParams.put("dataStatus", 2);
        iitParams.put("includeStop", Boolean.TRUE);
        iitParams.put("includeAbandon", 1);
        Map map = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"findPropOfTaxFile", (Object[])new Object[]{iitParams});
        String taxFileNotExist = ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u4e0d\u5b58\u5728\u3002", (String)"SalaryTaxFileRelServiceHelper_14", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        if (map == null || !MapUtils.getBooleanValue((Map)map, (Object)"success", (boolean)false)) {
            String failMsg = MapUtils.getString((Map)map, (Object)"message", (String)taxFileNotExist);
            for (Map param : successParams) {
                param.put("success", Boolean.FALSE);
                param.put("message", failMsg);
                failParams.add(param);
            }
            result.put("data", failParams);
            return result;
        }
        Map iitResultData = (Map)map.get("data");
        if (CollectionUtils.isEmpty((Map)iitResultData)) {
            for (Map param : successParams) {
                param.put("success", Boolean.FALSE);
                param.put("message", taxFileNotExist);
                failParams.add(param);
            }
            result.put("data", failParams);
            return result;
        }
        HashMap taxFileGroupByBoId = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
        for (Map.Entry entry : iitResultData.entrySet()) {
            Map datum = (Map)entry.getValue();
            Long boId = MapUtils.getLong((Map)datum, (Object)"boid");
            if (boId == null) {
                boId = (Long)entry.getKey();
            }
            List mapList = taxFileGroupByBoId.computeIfAbsent(boId, ky -> Lists.newArrayListWithExpectedSize((int)4));
            mapList.add(datum);
        }
        salaryFileIds.clear();
        iterator = successParams.iterator();
        String taxFileAbd = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u72b6\u6001\u4e3a\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u5173\u8054\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryTaxFileRelServiceHelper_10", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        String personNotSame = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u4e0e\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u4eba\u5458\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"SalaryTaxFileRelServiceHelper_6", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        String dateOverLap1 = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848{0}\u6b63\u5e38\u7b97\u7a0e\u65f6\u95f4\u6bb5\u5185\uff0c\u85aa\u8d44\u6863\u6848{1}\u4e0d\u662f\u6b63\u5e38\u7b97\u85aa\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"SalaryTaxFileRelServiceHelper_7", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        String dateOverLap2 = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848{0}\u6b63\u5e38\u7b97\u7a0e\u65f6\u95f4\u6bb5\u5185\uff0c\u85aa\u8d44\u6863\u6848{1}\u4e0d\u662f\u6b63\u5e38\u7b97\u85aa\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"SalaryTaxFileRelServiceHelper_8", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        String dateOverLap3 = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848{0}\u6b63\u5e38\u7b97\u7a0e\u65f6\u95f4\u6bb5\u5185\uff0c\u85aa\u8d44\u6863\u6848{1}\u4e0d\u662f\u6b63\u5e38\u7b97\u85aa\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"SalaryTaxFileRelServiceHelper_9", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        HashMap dateOverLapMsg = Maps.newHashMapWithExpectedSize((int)3);
        dateOverLapMsg.put(1, dateOverLap1);
        dateOverLapMsg.put(2, dateOverLap2);
        dateOverLapMsg.put(3, dateOverLap3);
        while (iterator.hasNext()) {
            Map taxFileMap;
            boolean success;
            Map param = (Map)iterator.next();
            Long taxFile = MapUtils.getLong((Map)param, (Object)"taxFileId");
            List taxFiles = (List)taxFileGroupByBoId.get(taxFile);
            if (taxFiles == null) {
                param.put("success", Boolean.FALSE);
                param.put("message", taxFileNotExist);
                failParams.add(param);
                iterator.remove();
                continue;
            }
            if (taxFiles.size() == 1 && !(success = MapUtils.getBooleanValue((Map)(taxFileMap = (Map)taxFiles.get(0)), (Object)"success", (boolean)true))) {
                param.put("success", Boolean.FALSE);
                param.put("message", MapUtils.getString((Map)taxFileMap, (Object)"message", (String)taxFileNotExist));
                failParams.add(param);
                iterator.remove();
                continue;
            }
            taxFileMap = (Map)taxFiles.get(0);
            if ("E".equals(MapUtils.getString((Map)taxFileMap, (Object)"status"))) {
                param.put("success", Boolean.FALSE);
                param.put("message", taxFileAbd);
                failParams.add(param);
                iterator.remove();
                continue;
            }
            Long salaryFile = MapUtils.getLong((Map)param, (Object)"salaryFileId");
            List<DynamicObject> salaryFileList = salaryFilesGroupByBoId.get(salaryFile);
            if (salaryFileList.get(0).getLong("employee.person.id") != MapUtils.getLongValue((Map)taxFileMap, (Object)"person.id", (long)0L)) {
                param.put("success", Boolean.FALSE);
                param.put("message", personNotSame);
                failParams.add(param);
                iterator.remove();
                continue;
            }
            BaseResult<Integer> baseResult = SalaryTaxFileRelServiceHelper.hasOverLapTaxSalary(taxFiles, salaryFileList);
            if (!baseResult.isSuccess()) {
                param.put("success", Boolean.FALSE);
                param.put("message", MessageFormat.format((String)dateOverLapMsg.get(baseResult.getData()), MapUtils.getString((Map)taxFileMap, (Object)"number"), salaryFileList.get(0).getString("number")));
                failParams.add(param);
                iterator.remove();
                continue;
            }
            salaryFileIds.add(salaryFile);
        }
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter salaryFileFilter = new QFilter("salaryfile.id", "in", (Object)salaryFileIds);
        HRBaseServiceHelper relServiceHelper = new HRBaseServiceHelper(HSAS_SALARY_TAX_FILE_REL);
        Object[] relQuery = relServiceHelper.query("id,salaryfile,taxfile,person,status", new QFilter[]{salaryFileFilter, statusFilter});
        int reRelateNum = 0;
        ArrayList deleteRel = Lists.newArrayListWithExpectedSize((int)salaryFileIds.size());
        if (!ArrayUtils.isEmpty((Object[])relQuery)) {
            HashMap taxFileOfSalaryFile = Maps.newHashMapWithExpectedSize((int)relQuery.length);
            HashMap oldRelIdOfSalaryFile = Maps.newHashMapWithExpectedSize((int)relQuery.length);
            HashMap oldRelMap = Maps.newHashMapWithExpectedSize((int)relQuery.length);
            for (Object object : relQuery) {
                long l = object.getLong("salaryfile.id");
                long taxFileId = object.getLong("taxfile");
                long id = object.getLong("id");
                oldRelMap.put(id, object);
                Set oldRelIds = oldRelIdOfSalaryFile.computeIfAbsent(l, ky -> Sets.newHashSetWithExpectedSize((int)4));
                oldRelIds.add(id);
                Map oldTaxFileIds = taxFileOfSalaryFile.computeIfAbsent(l, ky -> Maps.newHashMapWithExpectedSize((int)4));
                oldTaxFileIds.put(taxFileId, id);
            }
            ArrayList iitParamsData2 = Lists.newArrayListWithExpectedSize((int)relQuery.length);
            iterator = successParams.iterator();
            while (iterator.hasNext()) {
                Map next = (Map)iterator.next();
                Long salaryFileId = MapUtils.getLong((Map)next, (Object)"salaryFileId");
                Long taxFileId = MapUtils.getLong((Map)next, (Object)"taxFileId");
                Map map2 = (Map)taxFileOfSalaryFile.get(salaryFileId);
                Long oldRelId = (Long)map2.get(taxFileId);
                if (oldRelId != null) {
                    next.put("success", Boolean.TRUE);
                    next.put("newRelId", oldRelId);
                    failParams.add(next);
                    iterator.remove();
                    oldRelIdOfSalaryFile.remove(salaryFileId);
                    taxFileOfSalaryFile.remove(salaryFileId);
                    ++reRelateNum;
                    continue;
                }
                long regionId = salaryFilesGroupByBoId.get(salaryFileId).get(0).getLong("payrollregion.id");
                for (Map.Entry entry : map2.entrySet()) {
                    HashMap item = Maps.newHashMapWithExpectedSize((int)2);
                    item.put("taxFileId", entry.getKey());
                    item.put("regionId", regionId);
                    iitParamsData2.add(item);
                }
            }
            if (CollectionUtils.isEmpty((Collection)successParams)) {
                result.put("data", failParams);
                result.put("successRows", successParams.size() + reRelateNum);
                result.put("failRows", failParams.size() - reRelateNum);
                result.put("waitDealRows", 0);
                return result;
            }
            iitParams.put("includeStop", Boolean.FALSE);
            iitParams.put("includeAbandon", 0);
            iitParams.put("data", iitParamsData2);
            Map map3 = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"findPropOfTaxFile", (Object[])new Object[]{iitParams});
            if (map3 != null && MapUtils.getBooleanValue((Map)map3, (Object)"success", (boolean)false)) {
                Map iitResultData2 = (Map)map3.get("data");
                HashMap taxFileGroupByBoId2 = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
                for (Map.Entry entry : iitResultData2.entrySet()) {
                    Map datum = (Map)entry.getValue();
                    Long boId = MapUtils.getLong((Map)datum, (Object)"boid");
                    List mapList = taxFileGroupByBoId2.computeIfAbsent(boId, ky -> Lists.newArrayListWithExpectedSize((int)4));
                    mapList.add(datum);
                }
                String oldRelDateOverlap = ResManager.loadKDString((String)"\u5173\u8054\u5931\u8d25\uff0c\u4eba\u5458\u85aa\u8d44\u6863\u6848{0}\u5728\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\u5df2\u5173\u8054\u4eba\u5458\u4e2a\u7a0e\u6863\u6848{1}\uff0c\u9700\u8981\u786e\u4fdd\u4eba\u5458\u85aa\u8d44\u6863\u6848\u4e0e\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u7684\u5173\u8054\u5173\u7cfb\u5728\u4e00\u4e2a\u65f6\u95f4\u6bb5\u5185\u552f\u4e00\u5bf9\u5e94\u3002", (String)"SalaryTaxFileRelServiceHelper_15", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                iterator = successParams.iterator();
                while (iterator.hasNext()) {
                    Map map4 = (Map)iterator.next();
                    Long salaryFile = MapUtils.getLong((Map)map4, (Object)"salaryFileId");
                    Long taxFile = MapUtils.getLong((Map)map4, (Object)"taxFileId");
                    Long relId = MapUtils.getLong((Map)map4, (Object)"oldRelId");
                    Map oldTaxFileId = (Map)taxFileOfSalaryFile.get(salaryFile);
                    if (oldTaxFileId == null) continue;
                    Long oldRelId = (Long)oldTaxFileId.get(taxFile);
                    if (oldRelId != null) {
                        map4.put("success", Boolean.TRUE);
                        map4.put("newRelId", oldRelId);
                        failParams.add(map4);
                        iterator.remove();
                        ++reRelateNum;
                        continue;
                    }
                    ArrayList oldTaxFiles = Lists.newArrayListWithExpectedSize((int)oldTaxFileId.size());
                    for (Map.Entry entry : oldTaxFileId.entrySet()) {
                        List maps;
                        if (((Long)entry.getValue()).equals(relId) || (maps = (List)taxFileGroupByBoId2.get(entry.getKey())) == null) continue;
                        oldTaxFiles.addAll(maps);
                    }
                    List newFiles = (List)taxFileGroupByBoId.get(taxFile);
                    if (SalaryTaxFileRelServiceHelper.hasOverLapTax(oldTaxFiles, newFiles)) {
                        List<DynamicObject> list = salaryFilesGroupByBoId.get(salaryFile);
                        map4.put("success", Boolean.FALSE);
                        map4.put("message", MessageFormat.format(oldRelDateOverlap, list.get(0).getString("number"), MapUtils.getString((Map)((Map)oldTaxFiles.get(0)), (Object)"number")));
                        failParams.add(map4);
                        iterator.remove();
                        continue;
                    }
                    Set set = (Set)oldRelIdOfSalaryFile.get(salaryFile);
                    if (!set.contains(relId)) continue;
                    DynamicObject dynamicObject = (DynamicObject)oldRelMap.get(relId);
                    dynamicObject.set("status", (Object)"E");
                    deleteRel.add(dynamicObject);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)successParams)) {
            result.put("data", failParams);
            result.put("successRows", successParams.size() + reRelateNum);
            result.put("failRows", failParams.size() - reRelateNum);
            result.put("waitDealRows", 0);
            return result;
        }
        try (TXHandle required = TX.required();){
            Long userId = RequestContext.get().getCurrUserId();
            Date now = new Date();
            HashMap mapping = Maps.newHashMapWithExpectedSize((int)successParams.size());
            ArrayList newRelList = Lists.newArrayListWithExpectedSize((int)successParams.size());
            for (Map param : successParams) {
                DynamicObject dynamicObject = relServiceHelper.generateEmptyDynamicObject();
                newRelList.add(dynamicObject);
                dynamicObject.set("person", (Object)MapUtils.getLong((Map)param, (Object)"personId"));
                dynamicObject.set("salaryfile", (Object)MapUtils.getLong((Map)param, (Object)"salaryFileId"));
                dynamicObject.set("taxfile", (Object)MapUtils.getLong((Map)param, (Object)"taxFileId"));
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("creator", (Object)userId);
                dynamicObject.set("modifier", (Object)userId);
                dynamicObject.set("createtime", (Object)now);
                dynamicObject.set("modifytime", (Object)now);
                mapping.put(dynamicObject, param);
            }
            relServiceHelper.save(newRelList.toArray(new DynamicObject[0]));
            for (Object object : newRelList) {
                ((Map)mapping.get(object)).put("newRelId", object.getLong("id"));
            }
            if (!CollectionUtils.isEmpty((Collection)deleteRel)) {
                relServiceHelper.update(deleteRel.toArray(new DynamicObject[0]));
            }
            required.commit();
        }
        result.put("successRows", successParams.size() + reRelateNum);
        result.put("failRows", failParams.size() - reRelateNum);
        result.put("waitDealRows", 0);
        successParams.addAll(failParams);
        result.put("data", successParams);
        return result;
    }

    public static boolean isSalaryFileAbandon(List<DynamicObject> salaryFiles) {
        for (DynamicObject salaryFile : salaryFiles) {
            if (!salaryFile.getBoolean("iscurrentversion") || !"E".equals(salaryFile.getString("status"))) continue;
            return true;
        }
        return false;
    }

    private static BaseResult<Integer> hasOverLapTaxSalary(List<Map<String, Object>> taxFiles, List<DynamicObject> salaryFileList) {
        int resData = 3;
        for (Map<String, Object> taxFile : taxFiles) {
            Date taxFileEffect = BaseDataConverter.convert(taxFile.get("bsed"), Date.class);
            Date taxFileExpire = BaseDataConverter.convert(taxFile.get("bsled"), Date.class);
            boolean taxStop = "0".equals(BaseDataConverter.convert(taxFile.get("taxstatus"), String.class));
            for (DynamicObject object : salaryFileList) {
                Date salaryFileEffect = object.getDate("bsed");
                Date salaryFileExpire = object.getDate("bsled");
                boolean salaryStop = "0".equals(object.getString("paystatus"));
                if (!HsasDateUtil.isDateRangeOverlap((Date)taxFileEffect, (Date)taxFileExpire, (Date)salaryFileEffect, (Date)salaryFileExpire)) continue;
                if (!taxStop && !salaryStop) {
                    return BaseResult.success((Object)0);
                }
                if (!taxStop && resData > 1) {
                    resData = 1;
                    continue;
                }
                if (salaryStop || resData <= 2) continue;
                resData = 2;
            }
        }
        BaseResult result = BaseResult.fail((String)(resData + ""));
        result.setData((Object)resData);
        return result;
    }

    private static boolean hasOverLapTax(List<Map<String, Object>> taxFiles, List<Map<String, Object>> salaryFiles) {
        for (Map<String, Object> taxFile : taxFiles) {
            for (Map<String, Object> salaryFile : salaryFiles) {
                Date salaryFileExpire;
                Date salaryFileEffect;
                Date taxFileExpire;
                Date taxFileEffect = BaseDataConverter.convert(taxFile.get("bsed"), Date.class);
                if (!HsasDateUtil.isDateRangeOverlap((Date)taxFileEffect, (Date)(taxFileExpire = BaseDataConverter.convert(taxFile.get("bsled"), Date.class)), (Date)(salaryFileEffect = BaseDataConverter.convert(salaryFile.get("bsed"), Date.class)), (Date)(salaryFileExpire = BaseDataConverter.convert(salaryFile.get("bsled"), Date.class)))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> batchRelateSalaryTaxFile(Map<String, Object> cond) {
        QFilter dataStatusFilter;
        QFilter statusFilter;
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        Long regionId = BaseDataConverter.convert(cond.get("region"), Long.class);
        Map taxFileOfPerson = (Map)cond.get("data");
        String noMatchSalaryFiles = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u65e0\u6cd5\u5339\u914d\u5230\u53ef\u7528\u7684\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryTaxFileRelServiceHelper_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        if (regionId == null || regionId == 0L || CollectionUtils.isEmpty((Map)taxFileOfPerson)) {
            result.put("success", Boolean.FALSE);
            result.put("message", noMatchSalaryFiles);
            return result;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hsas_salaryfile");
        QFilter personFilter = new QFilter("employee.person.id", "in", taxFileOfPerson.keySet());
        Object[] salaryFiles = serviceHelper.query("id,boid,payrollregion.id,employee.person.id,bsed,bsled,paystatus,iscurrentversion", new QFilter[]{personFilter, statusFilter = new QFilter("status", "!=", (Object)"E"), dataStatusFilter = new QFilter("datastatus", "not in", (Object)new String[]{DataStatusEnum.DELETE.getCode(), "-1"})});
        if (ArrayUtils.isEmpty((Object[])salaryFiles)) {
            result.put("success", Boolean.FALSE);
            result.put("message", noMatchSalaryFiles);
            return result;
        }
        HashSet salaryFileBoIds = Sets.newHashSetWithExpectedSize((int)(salaryFiles.length / 2));
        for (Object salaryFile : salaryFiles) {
            if (!salaryFile.getBoolean("iscurrentversion")) continue;
            salaryFileBoIds.add(salaryFile.getLong("boid"));
        }
        HashMap salaryFileOfPerson = Maps.newHashMapWithExpectedSize((int)taxFileOfPerson.size());
        HashSet failPersonIds = Sets.newHashSetWithExpectedSize((int)taxFileOfPerson.size());
        HashMap diffRegionPersonIds = Maps.newHashMapWithExpectedSize((int)taxFileOfPerson.size());
        HashSet notOverlapPersons = Sets.newHashSetWithExpectedSize((int)taxFileOfPerson.size());
        Map dateMap = (Map)cond.get("dateMap");
        for (Object salaryFile : salaryFiles) {
            Object[] taxDates;
            if (!salaryFileBoIds.contains(salaryFile.getLong("boid"))) continue;
            long regionIdSalary = salaryFile.getLong("payrollregion.id");
            long personId = salaryFile.getLong("employee.person.id");
            if (regionId != regionIdSalary) {
                diffRegionPersonIds.putIfAbsent(personId, salaryFile);
                continue;
            }
            Long taxFileId = (Long)taxFileOfPerson.get(personId);
            if (dateMap == null || (taxDates = (Object[])dateMap.get(taxFileId)) == null) {
                notOverlapPersons.add(personId);
                continue;
            }
            int overlap = 0;
            for (Map.Entry dateEntry : taxDates.entrySet()) {
                if (!"1".equals(salaryFile.getString("paystatus")) || !HsasDateUtil.isDateRangeOverlap((Date)((Date)dateEntry.getKey()), (Date)((Date)dateEntry.getValue()), (Date)salaryFile.getDate("bsed"), (Date)salaryFile.getDate("bsled"))) continue;
                overlap = 1;
                break;
            }
            if (overlap == 0) {
                notOverlapPersons.add(personId);
                continue;
            }
            long salaryFileId = salaryFile.getLong("boid");
            Long oldSalaryFile = salaryFileOfPerson.putIfAbsent(personId, salaryFileId);
            if (oldSalaryFile == null || oldSalaryFile == salaryFileId) continue;
            failPersonIds.add(personId);
        }
        ArrayList data = Lists.newArrayListWithCapacity((int)taxFileOfPerson.size());
        result.put("data", data);
        String repeatMatchSalaryFiles = ResManager.loadKDString((String)"\u540c\u4e00\u7ba1\u7406\u5c5e\u5730\u4e0b\uff0c\u4e2a\u7a0e\u4eba\u5458{0}\u5b58\u5728\u591a\u4e2a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u6279\u91cf\u5173\u8054\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u3002", (String)"SalaryTaxFileRelServiceHelper_2", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        String regionNotMatchSalaryFiles = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458{0}\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848{1}\u4e0e\u4eba\u5458\u85aa\u8d44\u6863\u6848{2}\u4e0d\u662f\u540c\u4e00\u7ba1\u7406\u5c5e\u5730\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"SalaryTaxFileRelServiceHelper_3", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        String notOverlapFiles = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458{0}\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848{1}\u6b63\u5e38\u7b97\u7a0e\u65f6\u95f4\u6bb5\u5185\uff0c\u4e0d\u5b58\u5728\u6b63\u5e38\u7b97\u85aa\u7684\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"SalaryTaxFileRelServiceHelper_5", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        for (Map.Entry entry : taxFileOfPerson.entrySet()) {
            HashMap item;
            if (salaryFileOfPerson.containsKey(entry.getKey())) {
                if (!failPersonIds.contains(entry.getKey())) continue;
                item = Maps.newHashMapWithExpectedSize((int)4);
                item.put("person", entry.getKey());
                item.put("success", Boolean.FALSE);
                item.put("message", repeatMatchSalaryFiles);
                data.add(item);
                salaryFileOfPerson.remove(entry.getKey());
                continue;
            }
            DynamicObject salaryFile = (DynamicObject)diffRegionPersonIds.get(entry.getKey());
            if (salaryFile != null) {
                item = Maps.newHashMapWithExpectedSize((int)4);
                item.put("person", entry.getKey());
                item.put("success", Boolean.FALSE);
                item.put("message", MessageFormat.format(regionNotMatchSalaryFiles, "{0}", "{1}", salaryFile.getString("number")));
                data.add(item);
                continue;
            }
            item = Maps.newHashMapWithExpectedSize((int)4);
            item.put("person", entry.getKey());
            item.put("success", Boolean.FALSE);
            data.add(item);
            if (notOverlapPersons.contains(entry.getKey())) {
                item.put("message", notOverlapFiles);
                continue;
            }
            item.put("message", noMatchSalaryFiles);
        }
        QFilter salaryFileFilter = new QFilter("salaryfile.id", "in", salaryFileOfPerson.values());
        HRBaseServiceHelper relServiceHelper = new HRBaseServiceHelper(HSAS_SALARY_TAX_FILE_REL);
        Object[] relQuery = relServiceHelper.query("id,salaryfile,taxfile,person,status", new QFilter[]{salaryFileFilter, statusFilter});
        try (TXHandle required = TX.required();){
            if (!ArrayUtils.isEmpty((Object[])relQuery)) {
                String relatedMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458{0}\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848{1}\u5df2\u5173\u8054\u4eba\u5458\u85aa\u8d44\u6863\u6848{2}\u3002", (String)"SalaryTaxFileRelServiceHelper_4", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                for (Object object : relQuery) {
                    Long taxFileId;
                    long personId = object.getLong("person.id");
                    long oldTaxFileId = object.getLong("taxfile");
                    if (oldTaxFileId != (taxFileId = (Long)taxFileOfPerson.get(personId))) {
                        object.set("status", (Object)"E");
                        continue;
                    }
                    HashMap item = Maps.newHashMapWithExpectedSize((int)4);
                    item.put("person", object.getLong("person.id"));
                    item.put("success", Boolean.FALSE);
                    item.put("message", MessageFormat.format(relatedMsg, "{0}", "{1}", object.getString("salaryfile.number")));
                    data.add(item);
                    salaryFileOfPerson.remove(personId);
                }
                relServiceHelper.save((DynamicObject[])relQuery);
            }
            if (!CollectionUtils.isEmpty((Map)salaryFileOfPerson)) {
                ArrayList newRelList = Lists.newArrayListWithExpectedSize((int)salaryFileOfPerson.size());
                Long userId = RequestContext.get().getCurrUserId();
                Date now = new Date();
                for (Map.Entry entry : salaryFileOfPerson.entrySet()) {
                    DynamicObject object = relServiceHelper.generateEmptyDynamicObject();
                    newRelList.add(object);
                    object.set("person", entry.getKey());
                    object.set("status", (Object)"C");
                    object.set("salaryfile", entry.getValue());
                    object.set("taxfile", taxFileOfPerson.get(entry.getKey()));
                    object.set("creator", (Object)userId);
                    object.set("modifier", (Object)userId);
                    object.set("createtime", (Object)now);
                    object.set("modifytime", (Object)now);
                }
                relServiceHelper.save(newRelList.toArray(new DynamicObject[0]));
            }
            result.put("success", Boolean.TRUE);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseResult<Object> saveOrUpdateSalaryTaxFileRel(Long taxFile, DynamicObject salaryFile, DynamicObject person, Long oldRelId, boolean fromTax) {
        Object pk;
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_SALARY_TAX_FILE_REL);
        BaseResult<Object> result = SalaryTaxFileRelServiceHelper.validateRel(salaryFile, oldRelId, false, taxFile, null, dataServiceHelper, fromTax);
        if (!result.isSuccess()) {
            return result;
        }
        DynamicObject dynamicObjectRel = dataServiceHelper.generateEmptyDynamicObject();
        dynamicObjectRel.set("salaryFile", (Object)salaryFile);
        dynamicObjectRel.set("taxFile", (Object)taxFile);
        dynamicObjectRel.set("person", (Object)person);
        dynamicObjectRel.set("status", (Object)"C");
        SalaryTaxFileRelServiceHelper.assignSystemFieldValue(dynamicObjectRel);
        try (TXHandle required = TX.required();){
            pk = dataServiceHelper.saveOne(dynamicObjectRel);
            if (oldRelId != null && !Long.valueOf(0L).equals(oldRelId) && !SalaryTaxFileRelServiceHelper.deleteSalaryTaxFileRel(Collections.singletonList(oldRelId)).isSuccess()) {
                throw new KDBizException("Data delete failed");
            }
        }
        return BaseResult.success((Object)pk);
    }

    public static BaseResult<Object> validateRel(DynamicObject salaryFile, Long oldRelId, boolean bothAdd, Long taxFile, Date taxBsed, SWCDataServiceHelper dataServiceHelper, boolean fromTax) {
        Object[] query;
        if (bothAdd) {
            return BaseResult.success(null);
        }
        BaseResult<Object> validateDateRangeResult = SalaryTaxFileRelServiceHelper.validateSalaryFileAndTaXfileDateRange(salaryFile, taxFile, taxBsed, fromTax);
        if (!validateDateRangeResult.isSuccess()) {
            return validateDateRangeResult;
        }
        ArrayList filters = Lists.newArrayListWithCapacity((int)4);
        long salaryId = salaryFile.getLong("id");
        filters.add(new QFilter("salaryFile.id", "=", (Object)salaryId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        if (oldRelId != null && oldRelId != 0L) {
            filters.add(new QFilter("id", "!=", (Object)oldRelId));
        }
        if (ArrayUtils.isEmpty((Object[])(query = dataServiceHelper.query("id,taxFile", filters.toArray(new QFilter[0]))))) {
            return BaseResult.success(null);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("oldTaxFileIds", Arrays.stream(query).map(e -> e.getLong("taxfile")).collect(Collectors.toSet()));
        if (taxFile != null && taxFile != 0L) {
            params.put("newTaxFileId", taxFile);
        } else {
            params.put("newTaxFileBsed", taxBsed);
        }
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"validateSalaryTaxFileRel", (Object[])new Object[]{salaryFile.getLong("payrollregion.id"), params});
        boolean success = BaseDataConverter.convert(result.get("success"), Boolean.class, Boolean.FALSE);
        if (success) {
            return BaseResult.success(null);
        }
        return BaseResult.fail((String)((String)result.get("message")));
    }

    private static BaseResult<Object> validateSalaryFileAndTaXfileDateRange(DynamicObject salaryFile, Long taxFile, Date taxBsed, boolean fromTax) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        if ((null == taxFile || 0L == taxFile) && null == taxBsed) {
            BaseResult.success(null);
        }
        ArrayList salaryFilters = Lists.newArrayListWithCapacity((int)4);
        salaryFilters.add(new QFilter("boid", "=", (Object)salaryFile.getLong("boid")));
        salaryFilters.add(new QFilter("status", "!=", (Object)"E"));
        salaryFilters.add(new QFilter("datastatus", "not in", (Object)new String[]{DataStatusEnum.DELETE.getCode(), "-1"}));
        salaryFilters.add(new QFilter("paystatus", "=", (Object)"1"));
        DynamicObject[] salaryFiles = salaryFileHelper.query("bsed,bsled", salaryFilters.toArray(new QFilter[0]));
        String msg = fromTax ? ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u6b63\u5e38\u7b97\u7a0e\u65f6\u95f4\u6bb5\u5185\uff0c\u65e0\u6b63\u5e38\u7b97\u85aa\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryTaxFileRelServiceHelper_16", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u85aa\u8d44\u6863\u6848\u6b63\u5e38\u7b97\u85aa\u65f6\u95f4\u6bb5\u5185\uff0c\u6ca1\u6709\u6b63\u5e38\u7b97\u7a0e\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u3002", (String)"SalaryTaxFileRelServiceHelper_17", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        boolean isOverlap = false;
        if (taxBsed != null) {
            for (DynamicObject file : salaryFiles) {
                Date bsled = file.getDate("bsled");
                Date bsed = file.getDate("bsed");
                if (!HsasDateUtil.isDateRangeOverlap((Date)bsed, (Date)bsled, (Date)taxBsed, (Date)SWCBaseUtils.getMaxLoseEffectDate())) continue;
                isOverlap = true;
                break;
            }
        }
        if (null != taxFile && 0L != taxFile) {
            Map taxFileInfos = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"findTaxFile", (Object[])new Object[]{salaryFile.getLong("payrollregion.id"), taxFile, Sets.newHashSet((Object[])new String[]{"datastatus", "taxstatus", "bsed", "bsled", "boid"}), Boolean.FALSE});
            boolean success = BaseDataConverter.convert(taxFileInfos.get("success"), Boolean.class, Boolean.FALSE);
            if (!success) {
                return BaseResult.fail((String)((String)taxFileInfos.get("message")));
            }
            Map datas = (Map)taxFileInfos.get("data");
            if (CollectionUtils.isEmpty((Map)datas)) {
                return BaseResult.fail((String)ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u65e0\u6cd5\u5339\u914d\u5230\u53ef\u7528\u7684\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryTaxFileRelServiceHelper_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
            }
            Map taxFiles = (Map)datas.get(taxFile);
            block1: for (DynamicObject file : salaryFiles) {
                Date bsled = file.getDate("bsled");
                Date bsed = file.getDate("bsed");
                Set entries = taxFiles.entrySet();
                for (Map.Entry entry : taxFiles.entrySet()) {
                    Date taxFileBsled;
                    Map value = (Map)entry.getValue();
                    Date taxFileBsed = (Date)value.get("bsed");
                    if (!HsasDateUtil.isDateRangeOverlap((Date)bsed, (Date)bsled, (Date)taxFileBsed, (Date)(taxFileBsled = (Date)value.get("bsled")))) continue;
                    isOverlap = true;
                    continue block1;
                }
            }
        }
        if (!isOverlap) {
            return BaseResult.fail((String)msg);
        }
        return BaseResult.success(null);
    }

    public static BaseResult<Object> deleteSalaryTaxFileRel(List<Long> ids) {
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_SALARY_TAX_FILE_REL);
        QFilter qFilter = new QFilter("id", "in", (Object)ids.toArray());
        Object[] query = dataServiceHelper.query("id,status", new QFilter[]{qFilter});
        if (!SWCArrayUtils.isEmpty((Object[])query)) {
            for (Object obj : query) {
                obj.set("status", (Object)"E");
            }
            dataServiceHelper.save((DynamicObject[])query);
        }
        return BaseResult.success(null);
    }

    public static BaseResult<Object> deleteSalaryTaxFileRelByTax(List<Long> ids) {
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_SALARY_TAX_FILE_REL);
        QFilter qFilter = new QFilter("taxfile", "in", (Object)ids.toArray());
        Object[] query = dataServiceHelper.query("id,status", new QFilter[]{qFilter});
        if (!SWCArrayUtils.isEmpty((Object[])query)) {
            for (Object obj : query) {
                obj.set("status", (Object)"E");
            }
            dataServiceHelper.save((DynamicObject[])query);
        }
        return BaseResult.success(null);
    }

    public static void pushTaxFileFormTemp() {
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_TAX_FILE_TMP);
        QFilter filterCount = new QFilter("pushcount", "<", (Object)10);
        QFilter filterReason = new QFilter("failreason", "<", (Object)200);
        Object[] taxEntities = dataServiceHelper.query("id,person,org,taxregion,depcytype,adminorg,attachadminorg,empgroup,taxunit,starttaxdate,bsed,bsled,isescrowstaff,salaryfile,taxappnumber,taxfile,pushcount,failreason,failmsg,creator,createtime,modifier,modifytime", new QFilter[]{filterCount, filterReason});
        if (SWCArrayUtils.isEmpty((Object[])taxEntities)) {
            return;
        }
        ScheduledThreadPoolHolder.pushTaxFileAndCycle(0, Lists.newArrayList((Object[])taxEntities), "0", null, dataServiceHelper);
    }

    public static void backUpForPushTaxFail(DynamicObject taxEntity) {
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_TAX_FILE_TMP);
        dataServiceHelper.saveOne(taxEntity);
        ScheduledThreadPoolHolder.pushTaxFileAndCycle(1, Collections.singletonList(taxEntity), "0", null, dataServiceHelper);
    }

    public static void backUpForPushTaxFail(List<DynamicObject> taxEntities, String actionWay, String action) {
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_TAX_FILE_TMP);
        dataServiceHelper.save(taxEntities.toArray(new DynamicObject[0]));
        ScheduledThreadPoolHolder.pushTaxFileAndCycle(1, taxEntities, actionWay, action, dataServiceHelper);
    }

    private static void assignSystemFieldValue(DynamicObject object) {
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        object.set("creator", (Object)userId);
        object.set("modifier", (Object)userId);
        object.set("createtime", (Object)now);
        object.set("modifytime", (Object)now);
    }

    private static List<DynamicObject> packageTaxFileFromApi(Map<String, Object> result, Set<String> props) {
        boolean success = BaseDataConverter.convert(result.get("success"), Boolean.class, Boolean.FALSE);
        if (!success) {
            return Lists.newArrayList();
        }
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_TAX_FILE_TMP);
        Map data = (Map)result.get("data");
        ArrayList res = Lists.newArrayListWithCapacity((int)data.size());
        for (Map.Entry datum : data.entrySet()) {
            DynamicObject object = dataServiceHelper.generateEmptyDynamicObject();
            for (String prop : props) {
                object.set(prop, ((Map)datum.getValue()).get(prop));
            }
            res.add(object);
        }
        return res;
    }

    public static Map<Long, List<DynamicObject>> findSalaryTaxFileRel(Set<Long> salaryFileIds, Set<String> props) {
        if (CollectionUtils.isEmpty(salaryFileIds)) {
            return null;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(HSAS_SALARY_TAX_FILE_REL);
        QFilter filter = new QFilter("salaryFile.id", "in", salaryFileIds);
        filter.and(new QFilter("status", "=", (Object)"C"));
        Object[] query = serviceHelper.query("id,taxFile,salaryFile.id,salaryFile.payrollregion.id", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])query)) {
            return null;
        }
        HashMap regionTaxFileIds = Maps.newHashMapWithExpectedSize((int)4);
        HashMap taxSalaryFileIds = Maps.newHashMapWithExpectedSize((int)salaryFileIds.size());
        for (Object rel : query) {
            List taxFileIds = regionTaxFileIds.computeIfAbsent(rel.getLong("salaryFile.payrollregion.id"), arg_0 -> SalaryTaxFileRelServiceHelper.lambda$findSalaryTaxFileRel$9((DynamicObject[])query, arg_0));
            taxFileIds.add(rel.getLong("taxfile"));
            taxSalaryFileIds.put(rel.getLong("taxfile"), rel.getLong("salaryFile.id"));
        }
        HashMap salaryTaxFileMap = Maps.newHashMapWithExpectedSize((int)salaryFileIds.size());
        for (Map.Entry regionEntry : regionTaxFileIds.entrySet()) {
            Map<Long, DynamicObject> taxFileMap = SalaryTaxFileRelServiceHelper.findTaxFiles((Long)regionEntry.getKey(), (List)regionEntry.getValue(), props, false, true);
            if (CollectionUtils.isEmpty(taxFileMap)) continue;
            for (Map.Entry<Long, DynamicObject> entry : taxFileMap.entrySet()) {
                DynamicObject taxFile = entry.getValue();
                List taxFiles = salaryTaxFileMap.computeIfAbsent(taxSalaryFileIds.get(taxFile.getLong("boid")), k -> Lists.newArrayListWithCapacity((int)10));
                taxFiles.add(taxFile);
            }
        }
        return salaryTaxFileMap;
    }

    private static /* synthetic */ List lambda$findSalaryTaxFileRel$9(DynamicObject[] query, Long k) {
        return Lists.newArrayListWithCapacity((int)query.length);
    }

    private static class ScheduledThreadPoolHolder {
        private static final long[] JOB_EXEC_INTERVAL = new long[]{0L, 1L, 10L, 20L, 30L};
        private static final ThreadPool EXECUTOR = ThreadPools.newFixedThreadPool((String)"swc-hsas-salary-tax", (int)2);

        private ScheduledThreadPoolHolder() {
        }

        public static void pushTaxFileAndCycle(int count, List<DynamicObject> taxEntities, String actionWay, String action, SWCDataServiceHelper dataServiceHelper) {
            if (count >= JOB_EXEC_INTERVAL.length) {
                return;
            }
            RequestContext ctx = RequestContext.get();
            EXECUTOR.execute(() -> {
                List failResult;
                try {
                    TimeUnit.MINUTES.sleep(JOB_EXEC_INTERVAL[count]);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                RequestContext.copyAndSet((RequestContext)ctx);
                BatchResult<DynamicObject> result = SalaryTaxFileRelServiceHelper.pushTaxFilesToItc(taxEntities, actionWay, action);
                List successResult = result.getSuccessResult();
                if (!SWCListUtils.isEmpty((List)successResult)) {
                    SalaryTaxFileRelServiceHelper.dealSuccessRecords(dataServiceHelper, successResult);
                }
                if (!SWCListUtils.isEmpty((List)(failResult = result.getFailResult()))) {
                    try {
                        dataServiceHelper.save(failResult.toArray(new DynamicObject[0]));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurs when update tax file temp data", (Throwable)e);
                    }
                    ScheduledThreadPoolHolder.pushTaxFileAndCycle(count + 1, failResult, actionWay, action, dataServiceHelper);
                }
            }, ctx);
        }
    }
}

