/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.swc.hsas.business.bankoffer.vo.BaseDataConverter;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelServiceHelper;
import kd.swc.hsas.common.utils.BaseResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryTaxFileRelViewHelper {
    private static final Log LOGGER = LogFactory.getLog(SalaryTaxFileRelViewHelper.class);
    private static final Map<String, String> SALARY_TAX_FIELD_MAPPING = new HashMap<String, String>(8);
    private static final Map<String, String> TAX_SALARY_FIELD_MAPPING = new HashMap<String, String>(8);
    public static final String FIELD_NAME_ADD_TAX_FILE_CHECKBOX = "addtaxfilecheckbox";
    public static final String TAX_FILE_PAGE_ID = "taxFilePageId";
    public static final String HSAS_TAX_FILE_TMP = "hsas_taxfiletmp";
    public static final String HSAS_ADD_TAX_FILE_TMP = "hsas_addtaxfiletmp";
    public static final String BTN_SAVE_TAX_FILE = "savetaxfile";
    public static final String ADD_TAX_FILE_FLEX = "addtaxfileflex";
    public static final String HSAS_SALARY_TAX_FILE_REL = "hsas_salarytaxfilerel";
    public static final String SWC_HSAS_BUSINESS = "swc-hsas-business";
    public static final int TODO_VALIDATE = 1;
    public static final int TODO_SAVE = 2;
    public static final int TODO_VALIDATE_AND_SAVE = 3;

    public static void showOrHideTaxFile(IFormView view) {
        boolean hasPerm;
        long countryId = view.getModel().getDataEntity().getLong("payrollregion.id");
        boolean bl = hasPerm = SalaryTaxFileRelViewHelper.enableTaxCal(countryId) && SalaryTaxFileRelViewHelper.hasTaxFileAddPerm();
        if (!hasPerm) {
            view.getModel().getDataEntity().set(FIELD_NAME_ADD_TAX_FILE_CHECKBOX, (Object)Boolean.FALSE);
            view.setVisible(Boolean.FALSE, new String[]{BTN_SAVE_TAX_FILE, ADD_TAX_FILE_FLEX, FIELD_NAME_ADD_TAX_FILE_CHECKBOX});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{FIELD_NAME_ADD_TAX_FILE_CHECKBOX});
        Long salaryFileId = (Long)view.getFormShowParameter().getCustomParam("salaryFileId");
        DynamicObject dataEntity = view.getModel().getDataEntity();
        if (salaryFileId != null && !Long.valueOf(0L).equals(salaryFileId)) {
            view.setEnable(Boolean.FALSE, new String[]{"fieldsetpanelap"});
            view.setVisible(Boolean.FALSE, new String[]{FIELD_NAME_ADD_TAX_FILE_CHECKBOX, "bar_save"});
            view.setVisible(Boolean.TRUE, new String[]{BTN_SAVE_TAX_FILE});
            dataEntity.set(FIELD_NAME_ADD_TAX_FILE_CHECKBOX, (Object)Boolean.TRUE);
            view.getModel().updateCache();
        } else {
            view.setVisible(Boolean.FALSE, new String[]{BTN_SAVE_TAX_FILE});
            view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
        boolean addTaxFileFlag = dataEntity.getBoolean(FIELD_NAME_ADD_TAX_FILE_CHECKBOX);
        if (!addTaxFileFlag) {
            view.setVisible(Boolean.FALSE, new String[]{ADD_TAX_FILE_FLEX});
            view.getPageCache().remove(TAX_FILE_PAGE_ID);
            return;
        }
        if (view.getPageCache().get(TAX_FILE_PAGE_ID) == null) {
            view.getPageCache().put("countryIdForTax", String.valueOf(countryId));
            SalaryTaxFileRelViewHelper.embedTaxFileAdd(view);
        }
        view.setVisible(Boolean.TRUE, new String[]{ADD_TAX_FILE_FLEX});
    }

    public static void resetHeight(FormShowParameter showParameter) {
        OpenStyle style = showParameter.getOpenStyle();
        style = style == null ? new OpenStyle() : style;
        showParameter.setOpenStyle(style);
        StyleCss cssValue = style.getInlineStyleCss();
        cssValue = cssValue == null ? new StyleCss() : cssValue;
        style.setInlineStyleCss(cssValue);
        boolean hasPerm = SalaryTaxFileRelViewHelper.hasTaxFileAddPerm();
        showParameter.setCustomParam("hasTaxPerm", (Object)hasPerm);
        if (hasPerm) {
            cssValue.setHeight("628px");
        } else {
            cssValue.setHeight("420px");
        }
    }

    public static void initTaxFileBySalaryFile(IFormView view, IFormView taxFileView, boolean force) {
        if (taxFileView != null) {
            IDataModel model = view.getModel();
            IDataModel taxModel = taxFileView.getModel();
            for (Map.Entry<String, String> entry : SALARY_TAX_FIELD_MAPPING.entrySet()) {
                String[] split;
                String mapping = entry.getValue();
                for (String field : split = StringUtils.split((String)mapping, (String)",")) {
                    if (!ObjectUtils.isEmpty((Object)taxModel.getValue(field))) continue;
                    taxModel.setValue(field, model.getValue(entry.getKey()));
                }
            }
            taxFileView.getModel().updateCache();
            view.sendFormAction(taxFileView);
        }
    }

    public static void propertyOfSalaryChanged(IFormView view, String fieldKey, Object newValue, Object oldValue) {
        IFormView taxFileView;
        String taxFieldMapping;
        if (FIELD_NAME_ADD_TAX_FILE_CHECKBOX.equals(fieldKey)) {
            SalaryTaxFileRelViewHelper.showOrHideTaxFile(view);
            return;
        }
        if ("payrollregion".equals(fieldKey)) {
            SalaryTaxFileRelViewHelper.showOrHideTaxFile(view);
        }
        if ((taxFieldMapping = SALARY_TAX_FIELD_MAPPING.get(fieldKey)) != null && (taxFileView = view.getView(view.getPageCache().get(TAX_FILE_PAGE_ID))) != null) {
            String[] split;
            for (String field : split = StringUtils.split((String)taxFieldMapping, (String)",")) {
                String lockVal = taxFileView.getControl(field).getLock();
                Object taxValue = taxFileView.getModel().getValue(field);
                if (!ObjectUtils.isEmpty((Object)taxValue) && !ObjectUtils.nullSafeEquals((Object)oldValue, (Object)taxValue) && (lockVal == null || !lockVal.contains("new"))) continue;
                taxFileView.getModel().setValue(field, newValue);
            }
            taxFileView.getModel().updateCache();
            view.sendFormAction(taxFileView);
        }
    }

    public static void propertyOfTaxChanged(IFormView view, IDataEntityProperty property, Object newValue) {
        Object salaryFieldValue;
        String fieldKey;
        String salaryFieldMapping;
        IFormView parentView = view.getParentView();
        if ("hsas_addsalaryfile".equals(parentView.getFormShowParameter().getFormId()) && (salaryFieldMapping = TAX_SALARY_FIELD_MAPPING.get(fieldKey = property.getName())) != null && !ObjectUtil.equals((Object)(salaryFieldValue = parentView.getModel().getDataEntity().get(salaryFieldMapping)), (Object)newValue) && !ObjectUtils.isEmpty((Object)salaryFieldValue)) {
            Control control = view.getControl(fieldKey);
            if (control instanceof FieldEdit) {
                ((FieldEdit)control).setFocus(false);
            }
            IDataEntityProperty salaryProperty = parentView.getModel().getProperty(salaryFieldMapping);
            SalaryTaxFileRelViewHelper.showConfirm(view, property, salaryProperty);
        }
    }

    public static boolean standardValidate(IFormView view) {
        StringBuilder query = new StringBuilder();
        if (!SalaryTaxFileRelViewHelper.hasTaxFileAddPerm()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"SalaryFileTaxAddNewPlugin_34", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        IFormView taxFileView = view.getView(view.getPageCache().get(TAX_FILE_PAGE_ID));
        if (taxFileView != null) {
            HashSet<String> validFields = new HashSet<String>(16);
            SalaryTaxFileRelViewHelper.validateRequiredFiled(taxFileView, query, validFields);
            if (query.length() > 0) {
                query.delete(query.length() - 1, query.length());
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\uff1a{0}\u3002", (String)"SalaryFileTaxAddNewPlugin_4", (String)SWC_HSAS_BUSINESS, (Object[])new Object[]{query.toString()}));
                view.sendFormAction(taxFileView);
                return false;
            }
            DynamicObject taxFile = taxFileView.getModel().getDataEntity();
            Long salaryFileId = (Long)view.getFormShowParameter().getCustomParam("salaryFileId");
            boolean bothAdd = salaryFileId == null || salaryFileId == 0L;
            BaseResult<Object> valResult = SalaryTaxFileRelServiceHelper.validateRel(view.getModel().getDataEntity(), null, bothAdd, null, taxFile.getDate("bsed"), new SWCDataServiceHelper(HSAS_SALARY_TAX_FILE_REL), false);
            if (!valResult.isSuccess()) {
                view.showErrorNotification(valResult.getMessage());
                view.sendFormAction(taxFileView);
                return false;
            }
        }
        view.sendFormAction(taxFileView);
        return true;
    }

    public static BaseResult<DynamicObject> saveTaxFile(IFormView view, long salaryFileId, int todoType, boolean taxOnly) {
        DynamicObject salaryEntity = view.getModel().getDataEntity();
        boolean addTaxFileFlag = salaryEntity.getBoolean(FIELD_NAME_ADD_TAX_FILE_CHECKBOX);
        long countryId = salaryEntity.getLong("payrollregion.id");
        if (!addTaxFileFlag || !SalaryTaxFileRelViewHelper.enableTaxCal(countryId)) {
            return BaseResult.success(null);
        }
        IFormView taxFileView = view.getView(view.getPageCache().get(TAX_FILE_PAGE_ID));
        if (taxFileView == null) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4e2a\u7a0e\u6863\u6848\u6570\u636e\u3002", (String)"SalaryFileTaxAddNewPlugin_8", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]));
        }
        DynamicObject taxEntity = taxFileView.getModel().getDataEntity();
        String taxFileIdStr = view.getPageCache().get("taxFileId");
        long taxFileTmpId = SWCStringUtils.isEmpty((String)taxFileIdStr) ? ORM.create().genLongId(HSAS_TAX_FILE_TMP) : Long.parseLong(taxFileIdStr);
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper(HSAS_TAX_FILE_TMP);
        taxEntity = SalaryTaxFileRelServiceHelper.copySalaryPropToTax(dataServiceHelper, salaryEntity, taxEntity, salaryFileId, taxFileTmpId);
        BaseResult<DynamicObject> result = SalaryTaxFileRelServiceHelper.pushTaxFileToItc(taxEntity, todoType);
        if (todoType == 1) {
            return result;
        }
        if (result.isSuccess() || result.isEqualSuccess()) {
            SalaryTaxFileRelServiceHelper.dealSuccessRecords(dataServiceHelper, Collections.singletonList(result.getData()));
        }
        view.getFormShowParameter().setCustomParam("salaryFileId", (Object)salaryFileId);
        view.getPageCache().put("salaryFileId", String.valueOf(salaryFileId));
        view.getPageCache().put("taxFileId", String.valueOf(taxFileTmpId));
        SalaryTaxFileRelViewHelper.showOrHideTaxFile(view);
        if (!result.isSuccess() && result.isContinue()) {
            SalaryTaxFileRelServiceHelper.backUpForPushTaxFail(taxEntity);
        }
        if (result.isSuccess()) {
            return result;
        }
        if (!taxOnly) {
            result.setMessage(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u4fdd\u5b58\u6210\u529f\uff0c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u201c{0}\u201d\u3002", (String)"SalaryFileTaxAddNewPlugin_12", (String)SWC_HSAS_BUSINESS, (Object[])new Object[]{result.getMessage()}));
        }
        return result;
    }

    public static void showTaxFilePreview(long taxFileId, long regionId, int editStatus, IFormView formView, boolean useParentView) {
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"IndividualTaxFileService", (String)"taxFilePreviewFormParameter", (Object[])new Object[]{regionId, taxFileId, editStatus, 0L, formView.getPageId()});
        boolean success = BaseDataConverter.convert(result.get("success"), Boolean.class, Boolean.FALSE);
        if (success) {
            FormShowParameter formShowParameter = (FormShowParameter)result.get("data");
            formShowParameter.setAppId("hsas");
            if (useParentView) {
                formView.getParentView().showForm(formShowParameter);
            } else {
                formView.showForm(formShowParameter);
            }
            if (formView.getMainView() != null) {
                formView.sendFormAction(formView.getMainView());
            }
        } else {
            formView.showErrorNotification(String.valueOf(result.get("message")));
        }
    }

    public static boolean enableTaxCal(long countryId) {
        return TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)countryId);
    }

    public static boolean hasTaxFileAddPerm() {
        return SWCPermissionServiceHelper.hasPermByPermItemNum((long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxfile", (String)"QXX0002");
    }

    public static boolean hasTaxFileQueryPerm() {
        return SWCPermissionServiceHelper.hasPermByPermItemNum((long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxfile", (String)"QXX0001");
    }

    public static boolean showFieldTips(IFormView view, IDataEntityProperty property, Object value) {
        if (!SalaryTaxFileRelViewHelper.isMustInput(property)) {
            return true;
        }
        return SalaryTaxFileRelViewHelper.showFieldTipsInner(view, property, value);
    }

    private static void embedTaxFileAdd(IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        for (Map.Entry<String, String> entry : SALARY_TAX_FIELD_MAPPING.entrySet()) {
            String[] split;
            String taxFileKeys = entry.getValue();
            for (String param : split = StringUtils.split((String)taxFileKeys, (String)",")) {
                showParameter.setCustomParam(param, view.getModel().getValue(entry.getKey()));
            }
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("taxfileplaceflex");
        showParameter.setFormId(HSAS_ADD_TAX_FILE_TMP);
        showParameter.setHasRight(true);
        showParameter.setCustomParam("countryId", (Object)view.getPageCache().get("countryIdForTax"));
        view.showForm(showParameter);
        view.getPageCache().put(TAX_FILE_PAGE_ID, showParameter.getPageId());
    }

    private static void validateRequiredFiled(IFormView view, StringBuilder failField, Set<String> validFields) {
        IDataModel model = view.getModel();
        Map fields = model.getDataEntityType().getFields();
        DynamicObject dataEntity = model.getDataEntity();
        for (Map.Entry entry : fields.entrySet()) {
            String localeValue;
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (!SalaryTaxFileRelViewHelper.isMustInput(property) || SalaryTaxFileRelViewHelper.showFieldTipsInner(view, property, property.getValue((Object)dataEntity)) || validFields.contains(localeValue = property.getDisplayName().getLocaleValue())) continue;
            failField.append('\u201c').append(localeValue).append('\u201d').append('\uff0c');
            validFields.add(localeValue);
        }
    }

    private static boolean isMustInput(IDataEntityProperty property) {
        try {
            Method isMustInput = property.getClass().getMethod("isMustInput", new Class[0]);
            Object invoke = isMustInput.invoke((Object)property, new Object[0]);
            return invoke == null ? false : BaseDataConverter.convert(invoke, Boolean.class);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private static boolean showFieldTipsInner(IFormView view, IDataEntityProperty property, Object value) {
        String fieldName = property.getName();
        String notEmptyTips = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"SalaryFileTaxAddNewPlugin_5", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
        if (!property.getReadOnly() && SWCObjectUtils.isEmpty((Object)value)) {
            view.showFieldTip(new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.scope, fieldName, notEmptyTips));
            return false;
        }
        FieldTip tip = new FieldTip();
        tip.setFieldKey(fieldName);
        tip.setSuccess(true);
        view.showFieldTip(tip);
        return true;
    }

    private static void showConfirm(IFormView view, IDataEntityProperty property, IDataEntityProperty salaryProperty) {
        String salaryLocaleValue;
        String taxLocaleValue = property.getDisplayName().getLocaleValue();
        String fields = taxLocaleValue.equals(salaryLocaleValue = salaryProperty.getDisplayName().getLocaleValue()) ? taxLocaleValue : ResManager.loadKDString((String)"{0}\u4e0e{1}", (String)"SalaryTaxFileRelViewHelper_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[]{taxLocaleValue, salaryLocaleValue});
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u85aa\u8d44\u6863\u6848\u5173\u8054\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u7684{0}\u4e0d\u4e00\u81f4\u3002", (String)"SalaryFileTaxAddNewPlugin_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[]{fields});
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replace("\\\\r\\\\n", "\r\n") : msg;
        view.showMessage(msg);
    }

    static {
        SALARY_TAX_FIELD_MAPPING.put("payrollregion", "taxregion");
        SALARY_TAX_FIELD_MAPPING.put("bsed", "bsed");
        for (Map.Entry<String, String> entry : SALARY_TAX_FIELD_MAPPING.entrySet()) {
            String[] split;
            for (String field : split = StringUtils.split((String)entry.getValue(), (String)",")) {
                TAX_SALARY_FIELD_MAPPING.put(field, entry.getKey());
            }
        }
    }
}

