/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryresultcheck.helper;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class SalaryResultCheckHelper {
    public DynamicObject[] getSalaryResultCheckInfoByCalTaskId(long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkretstats");
        String field = "id,checkscheme";
        QFilter filter = new QFilter("caltask", "=", (Object)calTaskId);
        String permEntity = "hsas_calperson";
        String permItemId = "47150e89000000ac";
        Set adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"/UHMBBGZQ65X", (String)permEntity, (String)permItemId, (String)"adminorg");
        if (adminOrgIds != null) {
            filter.and("adminorg", "in", (Object)adminOrgIds);
        }
        DynamicObject[] checkDatas = helper.query(field, new QFilter[]{filter}, null);
        return checkDatas;
    }

    public DynamicObjectCollection getCheckStatsIdByCalTaskId(long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkretstats");
        String field = "id";
        QFilter filter = new QFilter("caltask", "=", (Object)calTaskId);
        String permEntity = "hsas_calperson";
        String permItemId = "47150e89000000ac";
        Set adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"/UHMBBGZQ65X", (String)permEntity, (String)permItemId, (String)"adminorg");
        if (adminOrgIds != null) {
            filter.and("adminorg", "in", (Object)adminOrgIds);
        }
        DynamicObjectCollection checkStatsIdColl = helper.queryOriginalCollection(field, new QFilter[]{filter});
        return checkStatsIdColl;
    }

    public DynamicObjectCollection getCheckIndexStatsByItemIdAndCheckStatsId(Set<Long> checkStatsIdSet, long basicItemId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexstats");
        String field = "indexcode,indexvalue";
        QFilter filter = new QFilter("checkstatid", "in", checkStatsIdSet);
        filter.and("itemid", "=", (Object)basicItemId);
        DynamicObjectCollection checkIndexStatsColl = helper.queryOriginalCollection(field, new QFilter[]{filter});
        return checkIndexStatsColl;
    }

    public DynamicObjectCollection getCheckIndexPersonByItemIdAndCheckStatsId(Set<Long> checkStatsIdSet, long basicItemId, Set<String> indexCodeSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexperson");
        String field = "indexcode,personid";
        QFilter filter = new QFilter("checkstatid", "in", checkStatsIdSet);
        filter.and("itemid", "=", (Object)basicItemId);
        filter.and("indexcode", "in", indexCodeSet);
        DynamicObjectCollection checkIndexPersonColl = helper.queryOriginalCollection(field, new QFilter[]{filter});
        return checkIndexPersonColl;
    }

    public DynamicObjectCollection getCheckIndexPersonByCheckRetStatsIds(List<Long> checkRetstatsIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexperson");
        QFilter filter = new QFilter("checkstatid", "in", checkRetstatsIdList);
        DynamicObjectCollection checkIndexPersonColl = helper.queryOriginalCollection("personid,itemid", new QFilter[]{filter});
        return checkIndexPersonColl;
    }

    public DynamicObjectCollection getCheckIndexStatsByCheckRetStatsIds(List<Long> checkRetstatsIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexstats");
        QFilter filter = new QFilter("checkstatid", "in", checkRetstatsIdList);
        DynamicObjectCollection checkIndexStatsColl = helper.queryOriginalCollection("indexcode,indexvalue,itemid", new QFilter[]{filter});
        return checkIndexStatsColl;
    }

    public DynamicObject[] getItemSeqByCheckSchemeId(Set<Long> retCheckSchemeIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_resultcheckscheme");
        String field = "valueentry.itemid";
        String orderBy = "valueentry.seq asc";
        QFilter filter = new QFilter("id", "in", retCheckSchemeIdSet);
        return helper.query(field, new QFilter[]{filter}, orderBy);
    }

    public DynamicObject[] getItemInfoByItemIdAndSchemeId(Set<Long> retCheckSchemeIdSet, Set<Long> itemIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_resultcheckscheme");
        QFilter filter = new QFilter("id", "in", retCheckSchemeIdSet);
        filter.and("valueentry.itemid", "in", itemIdSet);
        DynamicObject[] itemInfoArray = helper.query("valueentry.itemtype, valueentry.itemname, valueentry.itemid", new QFilter[]{filter}, null);
        return itemInfoArray;
    }

    public void updateSalaryResultCheckInfo(DynamicObject[] checkDatas) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkretstats");
        helper.update(checkDatas);
    }

    public DynamicObject[] getSalaryCheckMarkInfoByCalTaskId(long calTaskId, Long itemId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycheckmark");
        String field = "markid,checktype";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        if (itemId != null) {
            filter.and("markid", "=", (Object)itemId);
        }
        DynamicObject[] markInfo = helper.query(field, new QFilter[]{filter}, null);
        return markInfo;
    }

    public DynamicObject getSalaryRetMarkIdsByCalTaskId(long calTaskId, String checkType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycheckmark");
        String field = "salaryretmarkids";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        filter.and("checktype", "=", (Object)checkType);
        DynamicObject[] markObjs = helper.query(field, new QFilter[]{filter}, null);
        if (markObjs == null || markObjs.length == 0) {
            return null;
        }
        return markObjs[0];
    }

    public DynamicObject[] getSalaryRetMarkInfoByIds(Long[] markIds) {
        if (markIds == null || markIds.length == 0) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarydtmark");
        String field = "id";
        QFilter filter = new QFilter("id", "in", (Object)markIds);
        DynamicObject[] markArray = helper.query(field, new QFilter[]{filter}, null);
        return markArray;
    }

    public DynamicObjectCollection getCheckNotPromptInfo(long calTaskId, long userId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarychecknotprompt");
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        filter.and("userid", "=", (Object)userId);
        return helper.queryOriginalCollection("itemid", new QFilter[]{filter});
    }
}

