/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryrpt;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SalaryRptDateLogger {
    private Log log;
    private Map<String, Long> timeMap = Maps.newHashMapWithExpectedSize((int)16);

    public SalaryRptDateLogger(Class clazz) {
        this.log = LogFactory.getLog((Class)clazz);
    }

    public SalaryRptDateLogger(Log log) {
        this.log = log;
    }

    public void logStart(String key) {
        this.timeMap.computeIfAbsent(key, k -> System.currentTimeMillis());
        this.log.info("{} start at {}\u3002", (Object)key, (Object)System.currentTimeMillis());
    }

    public void logEnd(String key) {
        String traceId = RequestContext.get().getTraceId();
        Long startTime = this.timeMap.remove(key);
        long endTime = System.currentTimeMillis();
        if (startTime == null) {
            startTime = 0L;
        }
        this.log.info("{} start at {} ; end at {}, spent:{}; traceId is {}\u3002", new Object[]{key, startTime, endTime, endTime - startTime, traceId});
    }
}

