/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryrpt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.FieldEdit;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryrpt.entity.SchemeAdvanceInfo;
import kd.swc.hsbp.business.report.RptShowNodeHelper;
import kd.swc.hsbp.business.report.RptShowNodeVo;
import kd.swc.hsbp.business.report.RptTypeHelper;
import kd.swc.hsbp.business.report.RptTypeVo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryRptService {
    String rptFormId;
    private static final String CACHE_ROOTNODE = "rootnode";
    public static final String KEY_SOURCE_ID = "sourceid";
    private static final Map<String, String> RLS_MAP = new HashMap<String, String>(16);
    private Map<String, RptShowNodeVo> fieldMap;
    private Map<String, RptShowNodeVo> fieldAliasMap;

    public SalaryRptService(String rptFormId) {
        this.rptFormId = rptFormId;
    }

    public void refreshField() {
        this.fieldMap = RptShowNodeHelper.queryRptShowNodeMap((String)this.rptFormId);
        if (CollectionUtils.isEmpty(this.fieldMap)) {
            this.fieldMap = Maps.newHashMapWithExpectedSize((int)0);
        }
        this.fieldAliasMap = Maps.newHashMapWithExpectedSize((int)this.fieldMap.size());
        for (Map.Entry<String, RptShowNodeVo> nodeVoEntry : this.fieldMap.entrySet()) {
            RptShowNodeVo nodeVo = nodeVoEntry.getValue();
            this.fieldAliasMap.put(nodeVo.getQueryField(), nodeVo);
        }
    }

    public RptShowNodeVo getSelectFieldAtt(String key) {
        if (this.fieldMap == null) {
            this.refreshField();
        }
        return this.fieldMap.get(key);
    }

    public RptShowNodeVo getFieldAliasAtt(String key) {
        if (this.fieldAliasMap == null) {
            this.refreshField();
        }
        return this.fieldAliasMap.get(key);
    }

    public static Map<String, String> getRlsMap() {
        return RLS_MAP;
    }

    public static void updateDisplaySettingCache(IFormView view, int reportType, int sumtype, boolean isShowTotal) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("reporttype", reportType);
        map.put("sumtype", sumtype);
        map.put("isshowtotal", isShowTotal);
        map.put("isLoad", Boolean.TRUE);
        SalaryRptService.updateDisplaySettingCache(view, map, reportType);
    }

    public static void updateDisplaySettingCache(IFormView view, Map<String, Object> map, int reportType) {
        SWCPageCache pageCache = new SWCPageCache(view);
        String userId = RequestContext.get().getUserId();
        String key = "rptDispalySetting_" + userId + reportType;
        pageCache.put(key, map);
    }

    public static Map<String, Object> getDisplaySettingCache(IFormView view, int reportType) {
        String key = "rptDispalySetting_" + RequestContext.get().getCurrUserId() + reportType;
        SWCPageCache pageCache = new SWCPageCache(view);
        return (Map)pageCache.get(key, HashMap.class);
    }

    public static Map<String, Object> getDisplaySettingFromDB(int reportType) {
        long userId = RequestContext.get().getCurrUserId();
        QFilter reportTypeFilter = new QFilter("reporttype", "=", (Object)String.valueOf(reportType));
        QFilter userFilter = new QFilter("operateuser.id", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter, reportTypeFilter};
        String fields = "sumtype,reporttype, operateuser, isshowtotal";
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryrptdisset");
        DynamicObject info = helper.queryOne(fields, filters);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (info == null) {
            return null;
        }
        map.put("reporttype", info.getInt("reporttype"));
        map.put("sumtype", info.getInt("sumtype"));
        map.put("isshowtotal", info.getBoolean("isshowtotal"));
        return map;
    }

    public static Map<String, Object> getDisplaySetting(IFormView view, int reportType) {
        Map<String, Object> settingMap = SalaryRptService.getDisplaySettingCache(view, reportType);
        if (settingMap == null) {
            settingMap = SalaryRptService.getDisplaySettingFromDB(reportType);
            if (settingMap == null) {
                SalaryRptService.updateDisplaySettingCache(view, reportType, 2, true);
            } else {
                SalaryRptService.updateDisplaySettingCache(view, settingMap, reportType);
            }
        }
        return settingMap;
    }

    public static void searchTreeNode(String searchText, IFormView iFormView, boolean isSelected) {
        List<Object> treeNodes;
        boolean flag;
        SWCPageCache swcPageCache = new SWCPageCache(iFormView);
        String rootNode = (String)swcPageCache.get(CACHE_ROOTNODE, String.class);
        if (rootNode == null) {
            return;
        }
        List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNode);
        IPageCache pageCache = (IPageCache)iFormView.getService(IPageCache.class);
        TreeView treeView = (TreeView)iFormView.getControl("treeviewap");
        String searchNodesCacheKey = iFormView.getPageId() + "_searchNodes";
        String matchNodesCacheKey = iFormView.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = iFormView.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = iFormView.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = flag = (oldSearchText == null || oldSearchText.equals(searchText)) && !SWCStringUtils.isEmpty((String)matchNodesCache);
        if (flag) {
            String treeViewNode = pageCache.get(searchNodesCacheKey);
            treeNodes = SWCStringUtils.isEmpty((String)treeViewNode) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)treeViewNode, TreeNode.class);
        } else {
            treeNodes = SalaryRptService.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            treeNodes = SalaryRptService.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"SalaryRptService_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else {
            if (SWCStringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    if (isSelected) {
                        SalaryRptService.keyWordSearchSelected(treeView, iFormView, pageCache, searchIndexCacheKey, indexCache, treeNode);
                    }
                } else {
                    iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"SalaryRptService_4", (String)"swc-hsas-business", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private static List<TreeNode> getNodes(List<TreeNode> rootNodes, String searchText) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (TreeNode rootNode : rootNodes) {
            nodes.addAll(rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16));
        }
        return nodes;
    }

    private static void keyWordSearchSelected(TreeView treeView, IFormView iFormView, IPageCache pageCache, String searchIndexCacheKey, int indexCache, TreeNode treeNode) {
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        TreeView tree = (TreeView)iFormView.getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        treeView.uncheckNodes(checkedNodeIds);
        treeView.checkNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
    }

    public static DynamicObject copyDisplayScheme(String reportFormId, String pkId, Map<String, Object> returnData) {
        if (pkId == null || returnData == null) {
            return null;
        }
        DynamicObject shareSchemeObj = SalaryRptService.queryRptDisplaySchemeObj(Long.parseLong(pkId));
        DynamicObject newCopyDyObj = SalaryRptService.copyDynamicObj(shareSchemeObj);
        Object schemeName = returnData.get("name");
        Object schemeDesc = returnData.get("schemedesc");
        newCopyDyObj.set("name", schemeName);
        newCopyDyObj.set("schemedesc", schemeDesc);
        newCopyDyObj.set("reportformid", (Object)reportFormId);
        newCopyDyObj.set("createtime", (Object)new Date());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
        DynamicObject result = (DynamicObject)serviceHelper.saveOne(newCopyDyObj);
        return result;
    }

    public static DynamicObject copyDisplayScheme(Long sourceSchmId, String reportFormId) {
        if (sourceSchmId == null) {
            return null;
        }
        DynamicObject shareSchemeObj = SalaryRptService.queryRptDisplaySchemeObj(sourceSchmId);
        DynamicObject newCopyDyObj = SalaryRptService.copyDynamicObj(shareSchemeObj);
        newCopyDyObj.set("reportformid", (Object)reportFormId);
        Date currTime = new Date();
        newCopyDyObj.set("createtime", (Object)currTime);
        newCopyDyObj.set("modifytime", (Object)currTime);
        newCopyDyObj.set(KEY_SOURCE_ID, (Object)sourceSchmId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
        DynamicObject result = (DynamicObject)serviceHelper.saveOne(newCopyDyObj);
        return result;
    }

    public static Map<Long, DynamicObject> copyDisplaySchemes(Collection<Long> sourceSchemeIds, String reportFormId) {
        if (CollectionUtils.isEmpty(sourceSchemeIds)) {
            return Maps.newLinkedHashMapWithExpectedSize((int)0);
        }
        Object[] shareSchemeObjs = SalaryRptService.queryRptDisplaySchemeObjs(sourceSchemeIds);
        if (ArrayUtils.isEmpty((Object[])shareSchemeObjs)) {
            return Maps.newLinkedHashMapWithExpectedSize((int)0);
        }
        ArrayList newCopyDyObjs = Lists.newArrayListWithExpectedSize((int)shareSchemeObjs.length);
        for (Object shareSchemeObj : shareSchemeObjs) {
            DynamicObject newCopyDyObj = SalaryRptService.copyDynamicObj((DynamicObject)shareSchemeObj);
            newCopyDyObj.set("reportformid", (Object)reportFormId);
            Date currTime = new Date();
            newCopyDyObj.set("createtime", (Object)currTime);
            newCopyDyObj.set("modifytime", (Object)currTime);
            newCopyDyObj.set(KEY_SOURCE_ID, (Object)shareSchemeObj.getLong("id"));
            newCopyDyObjs.add(newCopyDyObj);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
        serviceHelper.save(newCopyDyObjs.toArray(new DynamicObject[0]));
        return newCopyDyObjs.stream().collect(Collectors.toMap(ele -> ele.getLong(KEY_SOURCE_ID), ele -> ele));
    }

    public static DynamicObject queryRptDisplaySchemeObj(Long pkId) {
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryrptdisplayschm");
        selectProperties = selectProperties + ", entryentity.seq";
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject queryRptDisplaySchemeObj(String schemeEntity, Long pkId) {
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)schemeEntity);
        selectProperties = selectProperties + ", entryentity.seq";
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(schemeEntity);
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryRptDisplaySchemeObjs(Collection<Long> pkIds) {
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryrptdisplayschm");
        selectProperties = selectProperties + ", entryentity.seq";
        QFilter qFilter = new QFilter("id", "in", pkIds);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
        return serviceHelper.query(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject copyDynamicObj(DynamicObject shareSchemeObj) {
        String entityNumber = shareSchemeObj.getDataEntityType().getName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List entryEntities = SWCHisBaseDataHelper.getEntryEntitys((MainEntityType)mainEntityType);
        Map fieldMaps = SWCHisBaseDataHelper.getEntityFieldsMap((MainEntityType)mainEntityType);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityNumber);
        DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
        Long pkId = ORM.create().genLongId((IDataEntityType)mainEntityType);
        for (String fieldName : (List)fieldMaps.get(entityNumber)) {
            if (fieldName.equals("id")) {
                emptyDynamicObject.set("id", (Object)pkId);
                continue;
            }
            if (fieldName.equals("creator") || fieldName.equals("modifier")) {
                emptyDynamicObject.set(fieldName, (Object)RequestContext.get().getUserId());
                continue;
            }
            if (fieldName.equals("sharescheme") || fieldName.equals("defaultscheme")) {
                emptyDynamicObject.set(fieldName, (Object)"0");
                continue;
            }
            emptyDynamicObject.set(fieldName, shareSchemeObj.get(fieldName));
        }
        for (String entryEntity : entryEntities) {
            DynamicObjectCollection coll = shareSchemeObj.getDynamicObjectCollection(entryEntity);
            if (coll == null || coll.isEmpty()) continue;
            List entryFields = (List)fieldMaps.get(entryEntity);
            SalaryRptService.copyEntryEntities(serviceHelper, emptyDynamicObject, entryEntity, entryFields, coll);
        }
        return emptyDynamicObject;
    }

    private static void copyEntryEntities(SWCDataServiceHelper serviceHelper, DynamicObject dynamicObject, String entryEntity, List<String> entryFields, DynamicObjectCollection coll) {
        DynamicObjectCollection newColl = dynamicObject.getDynamicObjectCollection(entryEntity);
        int index = 1;
        for (DynamicObject entryDyObj : coll) {
            DynamicObject newEntryDy = serviceHelper.generateEmptyEntryDynamicObject(entryEntity);
            for (String entryField : entryFields) {
                newEntryDy.set(entryField, entryDyObj.get(entryField));
            }
            newEntryDy.set("seq", (Object)index);
            newColl.add((Object)newEntryDy);
            ++index;
        }
    }

    public static DynamicObject queryDefaultScheme(String reportFormId) {
        QFilter filter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        filter.and(new QFilter("defaultscheme", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("reportformid", "=", (Object)reportFormId));
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryrptdisplayschm");
        return serviceHelper.queryOne("defaultscheme", new QFilter[]{filter});
    }

    public static <T> void forEach(Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        int index = 0;
        for (T element : elements) {
            action.accept(index, (Integer)element);
            ++index;
        }
    }

    public static RptTypeVo getRptTypeVo(String pageId, String formId) {
        return SalaryRptService.getRptTypeVo((IPageCache)new PageCache(pageId), formId);
    }

    public static RptTypeVo getRptTypeVo(IPageCache pageCache, String formId) {
        RptTypeVo rptTypeVo;
        if (pageCache == null) {
            return null;
        }
        String rptTypeVoStr = pageCache.get("cache_rpttypevo");
        if (StringUtils.isEmpty((CharSequence)rptTypeVoStr)) {
            rptTypeVo = RptTypeHelper.querytRptTypeVo((String)formId);
            if (rptTypeVo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u589e\u52a0\u914d\u7f6e\u3002", (String)"SalaryRptAbstractForm_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            pageCache.put("cache_rpttypevo", SerializationUtils.serializeToBase64((Object)rptTypeVo));
        } else {
            rptTypeVo = (RptTypeVo)SerializationUtils.deSerializeFromBase64((String)rptTypeVoStr);
        }
        return rptTypeVo;
    }

    public static List<RptShowNodeVo> getMoreFilterNodes(IPageCache pageCache, String formId) {
        List moreFilterNodes;
        if (pageCache == null) {
            return null;
        }
        String moreFilterNodesStr = pageCache.get("cache_morefilternodes");
        if (StringUtils.isEmpty((CharSequence)moreFilterNodesStr)) {
            moreFilterNodes = RptShowNodeHelper.getMoreFilterNodes((String)formId);
            if (moreFilterNodes == null) {
                moreFilterNodes = Lists.newArrayListWithCapacity((int)0);
            }
            pageCache.put("cache_morefilternodes", SerializationUtils.serializeToBase64((Object)moreFilterNodes));
        } else {
            moreFilterNodes = (List)SerializationUtils.deSerializeFromBase64((String)moreFilterNodesStr);
        }
        return moreFilterNodes;
    }

    public static SchemeAdvanceInfo buildSchemeAdvanceInfo(DynamicObject schemeDyn) {
        SchemeAdvanceInfo schemeAdvanceInfo = new SchemeAdvanceInfo();
        if (schemeDyn == null) {
            return schemeAdvanceInfo;
        }
        schemeAdvanceInfo.setDiffValShow(schemeDyn.getBoolean("isdiffvalshow"));
        schemeAdvanceInfo.setDiffValShowName(schemeDyn.getString("diffvalshowname"));
        schemeAdvanceInfo.setDiffRateShow(schemeDyn.getBoolean("isdiffrateshow"));
        schemeAdvanceInfo.setDiffRateShowName(schemeDyn.getString("diffrateshowname"));
        schemeAdvanceInfo.setShowUnChng(schemeDyn.getBoolean("isshowunchng"));
        schemeAdvanceInfo.setShowAdd(schemeDyn.getBoolean("isshowadd"));
        schemeAdvanceInfo.setShowDel(schemeDyn.getBoolean("isshowdel"));
        schemeAdvanceInfo.setChngRecShowDiv(schemeDyn.getBoolean("ischngrecshowdiv"));
        schemeAdvanceInfo.setDiffValShowDiv(schemeDyn.getBoolean("isdiffvalshowdiv"));
        return schemeAdvanceInfo;
    }

    public static void setSchemeAdvanceInfo(DynamicObject schemeDyn) {
        if (schemeDyn == null) {
            return;
        }
        SchemeAdvanceInfo advanceInfo = SalaryRptService.buildSchemeAdvanceInfo(schemeDyn);
        schemeDyn.set("advanceinfo", (Object)SerializationUtils.toJsonString((Object)advanceInfo));
    }

    public static SchemeAdvanceInfo getSchemeAdvanceInfo(DynamicObject schemeDyn) {
        return SalaryRptService.getSchemeAdvanceInfo(schemeDyn.getString("advanceinfo"));
    }

    public static SchemeAdvanceInfo getSchemeAdvanceInfo(String advanceInfoStr) {
        if (StringUtils.isEmpty((CharSequence)advanceInfoStr)) {
            return null;
        }
        return (SchemeAdvanceInfo)SerializationUtils.fromJsonString((String)advanceInfoStr, SchemeAdvanceInfo.class);
    }

    public static String getReportFormId(FormShowParameter formShowParameter) {
        Object customParam = formShowParameter.getCustomParam("reportformid");
        if (null == customParam || SWCStringUtils.isEmpty((String)customParam.toString())) {
            return formShowParameter.getParentFormId();
        }
        return String.valueOf(customParam);
    }

    public static void setFieldTagEnable(IFormView view) {
        FieldEdit fieldTagCtl = (FieldEdit)view.getControl("fieldtag");
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObjectCollection fieldEntry = dataEntity.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < fieldEntry.size(); ++i) {
            DynamicObject fieldDyn = (DynamicObject)fieldEntry.get(i);
            String isDimension = fieldDyn.getString("isdimension");
            if (StringUtils.isEmpty((CharSequence)isDimension) || StringUtils.equals((CharSequence)isDimension, (CharSequence)"0")) {
                fieldTagCtl.setEnable("", false, i);
                continue;
            }
            fieldTagCtl.setEnable("", true, i);
        }
    }

    static {
        RLS_MAP.put("num", "decimal");
        RLS_MAP.put("amount", "amount");
        RLS_MAP.put("text", "text");
        RLS_MAP.put("int", "integer");
        RLS_MAP.put("date", "date");
        RLS_MAP.put("bool", "boolean");
    }
}

