/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.service;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.common.dto.BankAccountModifyDTO;
import kd.swc.hsas.common.enums.PayDetailAbandonReasonEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.enums.PayStateEnum;

public class BankAccountModifyServiceHelper {
    public static void bankAccountModify(DynamicObject[] dataEntities) {
        BankAccountModifyDTO bankAccountModifyDTO;
        HashMap<Long, BankAccountModifyDTO> payDetailModifyMap = new HashMap<Long, BankAccountModifyDTO>(16);
        int idsSize = 0;
        for (DynamicObject modifyBill : dataEntities) {
            DynamicObjectCollection collection = modifyBill.getDynamicObjectCollection("entryentity");
            idsSize += collection.size();
        }
        long[] ids = DB.genLongIds((String)"hsas_paydetail", (int)idsSize);
        int index = 0;
        for (DynamicObject modifyBill : dataEntities) {
            DynamicObjectCollection collection = modifyBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : collection) {
                DynamicObject payDetail = entry.getDynamicObject("paydetail");
                boolean abandonedStatus = payDetail.getBoolean("abandonedstatus");
                if (abandonedStatus) continue;
                Long payDetailId = payDetail.getLong("id");
                DynamicObject perBankCard = entry.getDynamicObject("modifyperbankcard");
                long id = ids[index++];
                bankAccountModifyDTO = new BankAccountModifyDTO(Long.valueOf(id), perBankCard);
                payDetailModifyMap.put(payDetailId, bankAccountModifyDTO);
                entry.set("modifypaydetail", (Object)id);
            }
            modifyBill.set("billstatus", (Object)"C");
            modifyBill.set("updatestatus", (Object)"S");
        }
        SWCDataServiceHelper modifyBillHelper = new SWCDataServiceHelper("hsas_acctmodifybill");
        modifyBillHelper.update(dataEntities);
        if (payDetailModifyMap.isEmpty()) {
            return;
        }
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("id", "in", payDetailModifyMap.keySet());
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_paydetail");
        DynamicObject[] query = payDetailHelper.query(selectProperties, new QFilter[]{filter});
        DynamicObjectCollection collection = new DynamicObjectCollection();
        HashSet<Long> calPersonIdSet = new HashSet<Long>(16);
        for (DynamicObject payDetail : query) {
            Long payDetailId = payDetail.getLong("id");
            DynamicObject modifyPayDetail = payDetailHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)payDetail, (DynamicObject)modifyPayDetail);
            payDetail.set("abandonedstatus", (Object)Boolean.TRUE);
            payDetail.set("abandonedres", (Object)PayDetailAbandonReasonEnum.ACCOUNT_MODIFY.getDesc());
            bankAccountModifyDTO = (BankAccountModifyDTO)payDetailModifyMap.get(payDetailId);
            if (bankAccountModifyDTO != null) {
                DynamicObject perBankCard = bankAccountModifyDTO.getPerBankCard();
                modifyPayDetail.set("id", (Object)bankAccountModifyDTO.getId());
                modifyPayDetail.set("perbankcard", (Object)perBankCard);
                if (perBankCard != null) {
                    modifyPayDetail.set("bank", (Object)perBankCard.getDynamicObject("bankdeposit"));
                }
                modifyPayDetail.set("acctmodifybill", null);
                modifyPayDetail.set("createtime", (Object)new Date());
                modifyPayDetail.set("creator", (Object)RequestContext.get().getCurrUserId());
                if (PayStateEnum.PAYFAIL.getCode().equals(modifyPayDetail.getString("paystate"))) {
                    modifyPayDetail.set("paystate", (Object)PayStateEnum.UNPAY.getCode());
                }
                modifyPayDetail.set("agencypaystate", (Object)"0");
                modifyPayDetail.set("agencypaybill", null);
                collection.add((Object)modifyPayDetail);
            }
            calPersonIdSet.add(payDetail.getLong("calpersonid"));
        }
        payDetailHelper.save(collection);
        payDetailHelper.update(query);
        new AgencyPayWriteBackService().updateCaltablePayState(calPersonIdSet);
    }
}

